#!/bin/sh

OLDDIR=$(pwd)

if ! [ -f ./tool/ventoy_lib.sh ]; then
    if [ -f ${0%Ventoy2Disk.sh}/tool/ventoy_lib.sh ]; then
        cd ${0%Ventoy2Disk.sh}    
    fi
fi

if [ -f ./ventoy/version ]; then
    curver=$(cat ./ventoy/version) 
fi

if uname -m | grep -E -q 'aarch64|arm64'; then
    export TOOLDIR=aarch64
elif uname -m | grep -E -q 'x86_64|amd64'; then
    export TOOLDIR=x86_64
elif uname -m | grep -E -q 'mips64'; then
    export TOOLDIR=mips64el
else
    export TOOLDIR=i386
fi
export PATH="$OLDDIR/tool/$TOOLDIR:$PATH"


echo ''
echo '**********************************************'
echo "      Ventoy: $curver  $TOOLDIR"
echo "      longpanda admin@ventoy.net"
echo "      https://www.ventoy.net"
echo '**********************************************'
echo ''


if ! [ -f ./boot/boot.img ]; then
    if [ -d ./grub ]; then
        echo "Don't run Ventoy2Disk.sh here, please download the released install package, and run the script in it."
    else
        echo "Please run under the correct directory!" 
    fi
    exit 1
fi

test -w /var/log && echo "############# Ventoy2Disk $* [$TOOLDIR] ################" >> /var/log/ventoy.log
test -w /var/log && date >> /var/log/ventoy.log

#decompress tool
cd ./tool/$TOOLDIR

ls *.xz > /dev/null 2>&1
if [ $? -eq 0 ]; then
    [ -f ./xzcat ] && chmod +x ./xzcat

    for file in $(ls *.xz); do
        echo "decompress $file" >> /var/log/ventoy.log
        xzcat $file > ${file%.xz}
        [ -f ./${file%.xz} ] && chmod +x ./${file%.xz}
        [ -f ./$file ] && rm -f ./$file
    done
fi

#use static linked mkexfatfs for musl-libc environment
if [ -f mkexfatfs_static ]; then
    if ldd --version 2>&1 | grep -qi musl; then
        mv mkexfatfs mkexfatfs_shared
        mv mkexfatfs_static mkexfatfs
    fi
fi

cd ../../


if [ -f /bin/bash ]; then
    /bin/bash ./tool/VentoyWorker.sh $*
else
    ash ./tool/VentoyWorker.sh $*
fi

if [ -n "$OLDDIR" ]; then 
    CURDIR=$(pwd)
    if [ "$CURDIR" != "$OLDDIR" ]; then
        cd "$OLDDIR"
    fi
fi
