'use strict';

require("core-js/modules/es.regexp.exec.js");
require("core-js/modules/es.string.replace.js");
require("core-js/modules/es.object.create.js");
require("core-js/modules/es.array.for-each.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/web.dom-collections.for-each.js");
require("core-js/modules/es.array.map.js");
require("core-js/modules/es.object.keys.js");
require("core-js/modules/es.date.to-string.js");
require("core-js/modules/es.regexp.to-string.js");
require("core-js/modules/es.array.join.js");
var Helpers = require('./helpers');
module.exports.decodeValue = decodeValue;
module.exports.encodeValue = encodeValue;
module.exports.decode = decode;
module.exports.encode = encode;
var tokens_map = {
  '\\\\': '\\',
  '\\:': ';',
  '\\s': ' ',
  '\\n': '\n',
  '\\r': '\r',
  '\\': '' // remove invalid backslashes
};

var token_lookup = /\\\\|\\:|\\s|\\n|\\r|\\/gi;
function decodeValue(value) {
  return value.replace(token_lookup, function (m) {
    return tokens_map[m] || '';
  });
}
var vals_map = {
  '\\': '\\\\',
  ';': '\\:',
  ' ': '\\s',
  '\n': '\\n',
  '\r': '\\r'
};
var val_lookup = /\\|;| |\n|\r/gi;
function encodeValue(value) {
  return value.replace(val_lookup, function (m) {
    return vals_map[m] || '';
  });
}
function decode(tag_str) {
  var tags = Object.create(null);
  tag_str.split(';').forEach(function (tag) {
    var parts = Helpers.splitOnce(tag, '=');
    var key = parts[0].toLowerCase();
    var value = parts[1] || '';
    if (!key) {
      return;
    }
    value = decodeValue(value);
    tags[key] = value;
  });
  return tags;
}
function encode(tags) {
  var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ';';
  var parts = Object.keys(tags).map(function (key) {
    var val = tags[key];
    if (typeof val === 'boolean') {
      return key;
    }
    return key + '=' + encodeValue(val.toString());
  });
  return parts.join(separator);
}