"use strict";

require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/es.object.create.js");
require("core-js/modules/es.array.for-each.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/web.dom-collections.for-each.js");
require("core-js/modules/es.array.index-of.js");
require("core-js/modules/es.array.join.js");
require("core-js/modules/es.object.assign.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var MessageTags = require('./messagetags');
module.exports = /*#__PURE__*/function () {
  function IrcMessage(command) {
    _classCallCheck(this, IrcMessage);
    this.tags = Object.create(null);
    this.prefix = '';
    this.nick = '';
    this.ident = '';
    this.hostname = '';
    this.command = command || '';
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    this.params = args || [];
  }
  _createClass(IrcMessage, [{
    key: "to1459",
    value: function to1459() {
      var _this = this;
      var parts = [];
      var tags = MessageTags.encode(this.tags);
      if (tags) {
        parts.push('@' + tags);
      }
      if (this.prefix) {
        // TODO: If prefix is empty, build it from the nick!ident@hostname
        parts.push(':' + this.prefix);
      }
      parts.push(this.command);
      if (this.params.length > 0) {
        this.params.forEach(function (param, idx) {
          if (idx === _this.params.length - 1 && (param.indexOf(' ') > -1 || param[0] === ':')) {
            parts.push(':' + param);
          } else {
            parts.push(param);
          }
        });
      }
      return parts.join(' ');
    }
  }, {
    key: "toJson",
    value: function toJson() {
      return {
        tags: Object.assign({}, this.tags),
        source: this.prefix,
        command: this.command,
        params: this.params
      };
    }
  }]);
  return IrcMessage;
}();