'use strict';

require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.object.keys.js");
require("core-js/modules/es.array.filter.js");
require("core-js/modules/es.object.get-own-property-descriptor.js");
require("core-js/modules/es.object.get-own-property-descriptors.js");
require("core-js/modules/es.object.define-properties.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
require("core-js/modules/es.parse-int.js");
require("core-js/modules/es.array.index-of.js");
require("core-js/modules/es.regexp.exec.js");
require("core-js/modules/es.array.slice.js");
require("core-js/modules/es.array.join.js");
require("core-js/modules/es.array.splice.js");
require("core-js/modules/es.array.for-each.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/web.dom-collections.for-each.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _ = {
  each: require('lodash/each'),
  clone: require('lodash/clone'),
  map: require('lodash/map')
};
var Helpers = require('../../helpers');
var handlers = {
  RPL_LISTSTART: function RPL_LISTSTART(command, handler) {
    var cache = getChanListCache(handler);
    cache.channels = [];
    handler.emit('channel list start');
  },
  RPL_LISTEND: function RPL_LISTEND(command, handler) {
    var cache = getChanListCache(handler);
    if (cache.channels.length) {
      handler.emit('channel list', cache.channels);
      cache.channels = [];
    }
    cache.destroy();
    handler.emit('channel list end');
  },
  RPL_LIST: function RPL_LIST(command, handler) {
    var cache = getChanListCache(handler);
    cache.channels.push({
      channel: command.params[1],
      num_users: parseInt(command.params[2], 10),
      topic: command.params[3] || '',
      tags: command.tags
    });
    if (cache.channels.length >= 50) {
      handler.emit('channel list', cache.channels);
      cache.channels = [];
    }
  },
  RPL_MOTD: function RPL_MOTD(command, handler) {
    var cache = handler.cache('motd');
    cache.motd += command.params[command.params.length - 1] + '\n';
  },
  RPL_MOTDSTART: function RPL_MOTDSTART(command, handler) {
    var cache = handler.cache('motd');
    cache.motd = '';
  },
  RPL_ENDOFMOTD: function RPL_ENDOFMOTD(command, handler) {
    var cache = handler.cache('motd');
    handler.emit('motd', {
      motd: cache.motd,
      tags: command.tags
    });
    cache.destroy();
  },
  ERR_NOMOTD: function ERR_NOMOTD(command, handler) {
    var params = _.clone(command.params);
    params.shift();
    handler.emit('motd', {
      error: command.params[command.params.length - 1],
      tags: command.tags
    });
  },
  RPL_OMOTD: function RPL_OMOTD(command, handler) {
    var cache = handler.cache('oper motd');
    cache.motd += command.params[command.params.length - 1] + '\n';
  },
  RPL_OMOTDSTART: function RPL_OMOTDSTART(command, handler) {
    var cache = handler.cache('oper motd');
    cache.motd = '';
  },
  RPL_ENDOFOMOTD: function RPL_ENDOFOMOTD(command, handler) {
    var cache = handler.cache('oper motd');
    handler.emit('motd', {
      motd: cache.motd,
      tags: command.tags
    });
    cache.destroy();
  },
  ERR_NOOPERMOTD: function ERR_NOOPERMOTD(command, handler) {
    var params = _.clone(command.params);
    params.shift();
    handler.emit('motd', {
      error: command.params[command.params.length - 1],
      tags: command.tags
    });
  },
  RPL_WHOREPLY: function RPL_WHOREPLY(command, handler) {
    var cache = handler.cache('who');
    if (!cache.members) {
      cache.members = [];
    }
    var params = command.params;
    var _Helpers$parseWhoFlag = Helpers.parseWhoFlags(params[6], handler.network.options),
      parsedFlags = _Helpers$parseWhoFlag.parsedFlags,
      unparsedFlags = _Helpers$parseWhoFlag.unparsedFlags;
    var hops_away = 0;
    var realname = params[7];

    // The realname should be in the format of "<num hops> <real name>"
    var space_idx = realname.indexOf(' ');
    if (space_idx > -1) {
      hops_away = parseInt(realname.substr(0, space_idx), 10);
      realname = realname.substr(space_idx + 1);
    }
    cache.members.push(_objectSpread({
      nick: params[5],
      ident: params[2],
      hostname: params[3],
      server: params[4],
      real_name: realname,
      num_hops_away: hops_away,
      channel: params[1],
      tags: command.tags,
      unparsed_flags: unparsedFlags
    }, parsedFlags));
  },
  RPL_WHOSPCRPL: function RPL_WHOSPCRPL(command, handler) {
    var cache = handler.cache('who');
    if (!cache.members) {
      cache.members = [];
      cache.type = 'whox';
    }
    var client = handler.client;
    var params = command.params;
    if (cache.token === 0) {
      // Token validation has already been attempted but failed,
      // ignore this event as it will not be emitted
      return;
    }
    if (!cache.token) {
      var token = parseInt(params[1], 10) || 0;
      if (token && params.length === 12 && client.whox_token.validate(token)) {
        // Token is valid, store it in the cache
        cache.token = token;
      } else {
        // This event does not have a valid token so did not come from irc-fw,
        // ignore it as the response order may differ
        cache.token = 0;
        return;
      }
    }
    var _Helpers$parseWhoFlag2 = Helpers.parseWhoFlags(params[7], handler.network.options),
      parsedFlags = _Helpers$parseWhoFlag2.parsedFlags,
      unparsedFlags = _Helpers$parseWhoFlag2.unparsedFlags;

    // Some ircd's use n/a for no level, use undefined to represent no level
    var op_level = /^[0-9]+$/.test(params[10]) ? parseInt(params[10], 10) : undefined;
    cache.members.push(_objectSpread({
      nick: params[6],
      ident: params[3],
      hostname: params[4],
      server: params[5],
      op_level: op_level,
      real_name: params[11],
      account: params[9] === '0' ? '' : params[9],
      num_hops_away: parseInt(params[8], 10),
      channel: params[2],
      tags: command.tags,
      unparsed_flags: unparsedFlags
    }, parsedFlags));
  },
  RPL_ENDOFWHO: function RPL_ENDOFWHO(command, handler) {
    var cache = handler.cache('who');
    if (cache.type === 'whox' && !cache.token) {
      // Dont emit wholist for whox requests without a token
      // they did not come from irc-fw
      cache.destroy();
      return;
    }
    handler.emit('wholist', {
      target: command.params[1],
      users: cache.members || [],
      tags: command.tags
    });
    cache.destroy();
  },
  PING: function PING(command, handler) {
    handler.connection.write('PONG ' + command.params[command.params.length - 1]);
    var time = command.getServerTime();
    handler.emit('ping', {
      message: command.params[1],
      time: time,
      tags: command.tags
    });
  },
  PONG: function PONG(command, handler) {
    var time = command.getServerTime();
    if (time) {
      handler.network.addServerTimeOffset(time);
    }
    handler.emit('pong', {
      message: command.params[1],
      time: time,
      tags: command.tags
    });
  },
  MODE: function MODE(command, handler) {
    // Check if we have a server-time
    var time = command.getServerTime();

    // Get a JSON representation of the modes
    var raw_modes = command.params[1];
    var raw_params = command.params.slice(2);
    var modes = handler.parseModeList(raw_modes, raw_params);
    handler.emit('mode', {
      target: command.params[0],
      nick: command.nick || command.prefix || '',
      modes: modes,
      time: time,
      raw_modes: raw_modes,
      raw_params: raw_params,
      tags: command.tags,
      batch: command.batch
    });
  },
  RPL_LINKS: function RPL_LINKS(command, handler) {
    var cache = handler.cache('links');
    cache.links = cache.links || [];
    cache.links.push({
      address: command.params[1],
      access_via: command.params[2],
      hops: parseInt(command.params[3].split(' ')[0]),
      description: command.params[3].split(' ').splice(1).join(' '),
      tags: command.tags
    });
  },
  RPL_ENDOFLINKS: function RPL_ENDOFLINKS(command, handler) {
    var cache = handler.cache('links');
    handler.emit('server links', {
      links: cache.links
    });
    cache.destroy();
  },
  RPL_INFO: function RPL_INFO(command, handler) {
    var cache = handler.cache('info');
    if (!cache.info) {
      cache.info = '';
    }
    cache.info += command.params[command.params.length - 1] + '\n';
  },
  RPL_ENDOFINFO: function RPL_ENDOFINFO(command, handler) {
    var cache = handler.cache('info');
    handler.emit('info', {
      info: cache.info,
      tags: command.tags
    });
    cache.destroy();
  },
  RPL_HELPSTART: function RPL_HELPSTART(command, handler) {
    var cache = handler.cache('help');
    cache.help = command.params[command.params.length - 1] + '\n';
  },
  RPL_HELPTXT: function RPL_HELPTXT(command, handler) {
    var cache = handler.cache('help');
    cache.help += command.params[command.params.length - 1] + '\n';
  },
  RPL_ENDOFHELP: function RPL_ENDOFHELP(command, handler) {
    var cache = handler.cache('help');
    handler.emit('help', {
      help: cache.help,
      tags: command.tags
    });
    cache.destroy();
  },
  BATCH: function BATCH(command, handler) {
    var batch_start = command.params[0].substr(0, 1) === '+';
    var batch_id = command.params[0].substr(1);
    var cache_key = 'batch.' + batch_id;
    if (!batch_id) {
      return;
    }
    if (batch_start) {
      var _cache = handler.cache(cache_key);
      _cache.commands = [];
      _cache.type = command.params[1];
      _cache.params = command.params.slice(2);
      return;
    }
    if (!handler.hasCache(cache_key)) {
      // If we don't have this batch ID in cache, it either means that the
      // server hasn't sent the starting batch command or that the server
      // has already sent the end batch command.
      return;
    }
    var cache = handler.cache(cache_key);
    var emit_obj = {
      id: batch_id,
      type: cache.type,
      params: cache.params,
      commands: cache.commands
    };

    // Destroy the cache object before executing each command. If one
    // errors out then we don't have the cache object stuck in memory.
    cache.destroy();
    handler.emit('batch start', emit_obj);
    handler.emit('batch start ' + emit_obj.type, emit_obj);
    emit_obj.commands.forEach(function (c) {
      c.batch = {
        id: batch_id,
        type: cache.type,
        params: cache.params
      };
      handler.executeCommand(c);
    });
    handler.emit('batch end', emit_obj);
    handler.emit('batch end ' + emit_obj.type, emit_obj);
  }
};
module.exports = function AddCommandHandlers(command_controller) {
  _.each(handlers, function (handler, handler_command) {
    command_controller.addHandler(handler_command, handler);
  });
};
function getChanListCache(handler) {
  var cache = handler.cache('chanlist');

  // fix some IRC networks
  if (!cache.channels) {
    cache.channels = [];
  }
  return cache;
}