'use strict';

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
require("core-js/modules/es.reflect.construct.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/es.array.concat.js");
require("core-js/modules/es.array.slice.js");
require("core-js/modules/es.array.reduce.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/es.array.find.js");
require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.object.create.js");
require("core-js/modules/es.object.set-prototype-of.js");
require("core-js/modules/es.function.bind.js");
require("core-js/modules/es.object.get-prototype-of.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var _ = {
  reduce: require('lodash/reduce'),
  find: require('lodash/find'),
  uniq: require('lodash/uniq')
};
var EventEmitter = require('eventemitter3');
var irc_numerics = require('./numerics');
var IrcCommand = require('./command');
module.exports = /*#__PURE__*/function (_EventEmitter) {
  _inherits(IrcCommandHandler, _EventEmitter);
  var _super = _createSuper(IrcCommandHandler);
  function IrcCommandHandler(client) {
    var _this;
    _classCallCheck(this, IrcCommandHandler);
    _this = _super.call(this);

    // Adds an 'all' event to .emit()
    _this.addAllEventName();
    _this.client = client;
    _this.connection = client.connection;
    _this.network = client.network;
    _this.handlers = [];
    _this.request_extra_caps = [];
    _this.resetCache();
    require('./handlers/registration')(_assertThisInitialized(_this));
    require('./handlers/channel')(_assertThisInitialized(_this));
    require('./handlers/user')(_assertThisInitialized(_this));
    require('./handlers/messaging')(_assertThisInitialized(_this));
    require('./handlers/misc')(_assertThisInitialized(_this));
    require('./handlers/generics')(_assertThisInitialized(_this));
    return _this;
  }
  _createClass(IrcCommandHandler, [{
    key: "dispatch",
    value: function dispatch(message) {
      var irc_command = new IrcCommand(message.command.toUpperCase(), message);

      // Batched commands will be collected and executed as a transaction
      var batch_id = irc_command.getTag('batch');
      if (batch_id) {
        var cache_key = 'batch.' + batch_id;
        if (this.hasCache(cache_key)) {
          var cache = this.cache(cache_key);
          cache.commands.push(irc_command);
        } else {
          // If we don't have this batch ID in cache, it either means that the
          // server hasn't sent the starting batch command or that the server
          // has already sent the end batch command.
        }
      } else {
        this.executeCommand(irc_command);
      }
    }
  }, {
    key: "executeCommand",
    value: function executeCommand(irc_command) {
      var command_name = irc_command.command;

      // Check if we have a numeric->command name- mapping for this command
      if (irc_numerics[irc_command.command.toUpperCase()]) {
        command_name = irc_numerics[irc_command.command.toUpperCase()];
      }
      if (this.handlers[command_name]) {
        this.handlers[command_name](irc_command, this);
      } else {
        this.emitUnknownCommand(irc_command);
      }
    }
  }, {
    key: "requestExtraCaps",
    value: function requestExtraCaps(cap) {
      this.request_extra_caps = _.uniq(this.request_extra_caps.concat(cap));
    }
  }, {
    key: "addHandler",
    value: function addHandler(command, handler) {
      if (typeof handler !== 'function') {
        return false;
      }
      this.handlers[command] = handler;
    }
  }, {
    key: "emitUnknownCommand",
    value: function emitUnknownCommand(command) {
      this.emit('unknown command', command);
    }

    // Adds an 'all' event to .emit()
  }, {
    key: "addAllEventName",
    value: function addAllEventName() {
      var original_emit = this.emit;
      this.emit = function () {
        var args = Array.prototype.slice.call(arguments, 0);
        original_emit.apply(this, ['all'].concat(args));
        original_emit.apply(this, args);
      };
    }

    /**
    * Convert a mode string such as '+k pass', or '-i' to a readable
    * format.
    * [ { mode: '+k', param: 'pass' } ]
    * [ { mode: '-i', param: null } ]
    */
  }, {
    key: "parseModeList",
    value: function parseModeList(mode_string, mode_params) {
      var chanmodes = this.network.options.CHANMODES || [];
      var prefixes = this.network.options.PREFIX || [];
      var always_param = (chanmodes[0] || '').concat(chanmodes[1] || '');
      var modes = [];
      var i;
      var j;
      var add;
      if (!mode_string) {
        return modes;
      }
      prefixes = _.reduce(prefixes, function (list, prefix) {
        list.push(prefix.mode);
        return list;
      }, []);
      always_param = always_param.split('').concat(prefixes);
      var hasParam = function hasParam(mode, isAdd) {
        var matchMode = function matchMode(m) {
          return m === mode;
        };
        if (_.find(always_param, matchMode)) {
          return true;
        }
        if (isAdd && _.find((chanmodes[2] || '').split(''), matchMode)) {
          return true;
        }
        return false;
      };
      j = 0;
      for (i = 0; i < mode_string.length; i++) {
        switch (mode_string[i]) {
          case '+':
            add = true;
            break;
          case '-':
            add = false;
            break;
          default:
            if (hasParam(mode_string[i], add)) {
              modes.push({
                mode: (add ? '+' : '-') + mode_string[i],
                param: mode_params[j]
              });
              j++;
            } else {
              modes.push({
                mode: (add ? '+' : '-') + mode_string[i],
                param: null
              });
            }
        }
      }
      return modes;
    }

    /**
     * Cache object for commands buffering data before emitting them
     * eg.
     * var cache = this.cache('userlist');
     * cache.nicks = [];
     * cache.destroy();
     */
  }, {
    key: "cache",
    value: function cache(id) {
      var cache = this._caches[id];
      if (!cache) {
        var destroyCacheFn = function destroyCacheFn(cacheToDestroy, idInCache) {
          return function () {
            delete cacheToDestroy[idInCache];
          };
        };

        // We don't want the destoryCache to be iterable
        cache = Object.defineProperty({}, 'destroy', {
          enumerable: false,
          configurable: false,
          value: destroyCacheFn(this._caches, id)
        });
        this._caches[id] = cache;
      }
      return cache;
    }
  }, {
    key: "hasCache",
    value: function hasCache(id) {
      return this._caches && Object.prototype.hasOwnProperty.call(this._caches, id);
    }
  }, {
    key: "resetCache",
    value: function resetCache() {
      this._caches = Object.create(null);
    }
  }]);
  return IrcCommandHandler;
}(EventEmitter);