'use strict';

require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/es.date.to-string.js");
require("core-js/modules/es.regexp.exec.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/es.number.constructor.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _ = {
  clone: require('lodash/clone')
};
var numberRegex = /^[0-9.]{1,}$/;
module.exports = /*#__PURE__*/function () {
  function IrcCommand(command, data) {
    _classCallCheck(this, IrcCommand);
    this.command = command += '';
    this.params = _.clone(data.params);
    this.tags = _.clone(data.tags);
    this.prefix = data.prefix;
    this.nick = data.nick;
    this.ident = data.ident;
    this.hostname = data.hostname;
  }
  _createClass(IrcCommand, [{
    key: "getTag",
    value: function getTag(tag_name) {
      return this.tags[tag_name.toLowerCase()];
    }
  }, {
    key: "getServerTime",
    value: function getServerTime() {
      var timeTag = this.getTag('time');

      // Explicitly return undefined if theres no time
      // or the value is an empty string
      if (!timeTag) {
        return undefined;
      }

      // If parsing fails for some odd reason, also fallback to
      // undefined, instead of returning NaN
      var time = Date.parse(timeTag) || undefined;

      // Support for znc.in/server-time unix timestamps
      if (!time && numberRegex.test(timeTag)) {
        return new Date(timeTag * 1000).getTime();
      }
      return time;
    }
  }]);
  return IrcCommand;
}();