'use strict';

require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/es.function.name.js");
require("core-js/modules/es.function.bind.js");
require("core-js/modules/es.array.join.js");
require("core-js/modules/es.array.filter.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/es.array.find.js");
require("core-js/modules/es.date.to-string.js");
require("core-js/modules/es.regexp.to-string.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _ = {
  partial: require('lodash/partial'),
  filter: require('lodash/filter'),
  find: require('lodash/find'),
  each: require('lodash/each'),
  pull: require('lodash/pull'),
  extend: require('lodash/extend')
};
var DuplexStream = require('stream').Duplex;
module.exports = /*#__PURE__*/function () {
  function IrcChannel(irc_client, channel_name, key) {
    var _this = this;
    _classCallCheck(this, IrcChannel);
    this.irc_client = irc_client;
    this.name = channel_name;

    // TODO: Proxy channel related events from irc_bot to this instance

    this.say = _.partial(irc_client.say.bind(irc_client), channel_name);
    this.notice = _.partial(irc_client.notice.bind(irc_client), channel_name);
    // this.action = _.partial(irc_client.action.bind(irc_client), channel_name);
    this.part = _.partial(irc_client.part.bind(irc_client), channel_name);
    this.join = _.partial(irc_client.join.bind(irc_client), channel_name);
    this.mode = _.partial(irc_client.mode.bind(irc_client), channel_name);
    this.banlist = _.partial(irc_client.banlist.bind(irc_client), channel_name);
    this.ban = _.partial(irc_client.ban.bind(irc_client), channel_name);
    this.unban = _.partial(irc_client.unban.bind(irc_client), channel_name);
    this.users = [];
    irc_client.on('userlist', function (event) {
      if (irc_client.caseCompare(event.channel, _this.name)) {
        _this.users = event.users;
      }
    });
    irc_client.on('join', function (event) {
      if (irc_client.caseCompare(event.channel, _this.name)) {
        _this.users.push(event);
      }
    });
    irc_client.on('part', function (event) {
      if (irc_client.caseCompare(event.channel, _this.name)) {
        _this.users = _.filter(_this.users, function (o) {
          return !irc_client.caseCompare(event.nick, o.nick);
        });
      }
    });
    irc_client.on('kick', function (event) {
      if (irc_client.caseCompare(event.channel, _this.name)) {
        _this.users = _.filter(_this.users, function (o) {
          return !irc_client.caseCompare(event.kicked, o.nick);
        });
      }
    });
    irc_client.on('quit', function (event) {
      _this.users = _.filter(_this.users, function (o) {
        return !irc_client.caseCompare(event.nick, o.nick);
      });
    });
    irc_client.on('nick', function (event) {
      _.find(_this.users, function (o) {
        if (irc_client.caseCompare(event.nick, o.nick)) {
          o.nick = event.new_nick;
          return true;
        }
      });
    });
    irc_client.on('mode', function (event) {
      /* event will be something like:
      {
          target: '#prawnsalad',
          nick: 'ChanServ',
          modes: [ { mode: '+o', param: 'prawnsalad' } ],
          time: undefined
      }
      */

      if (!irc_client.caseCompare(event.target, _this.name)) {
        return;
      }

      // There can be multiple modes set at once, loop through
      _.each(event.modes, function (mode) {
        // If this mode has a user prefix then we need to update the user object
        // eg. +o +h +v
        var user_prefix = _.find(irc_client.network.options.PREFIX, {
          mode: mode.mode[1]
        });
        if (!user_prefix) {
          // TODO : manage channel mode changes
        } else {
          // It's a user mode
          // Find the user affected
          var user = _.find(_this.users, function (u) {
            return irc_client.caseCompare(u.nick, mode.param);
          });
          if (!user) {
            return;
          }
          if (mode.mode[0] === '+') {
            user.modes = user.modes || [];
            user.modes.push(mode.mode[1]);
          } else {
            _.pull(user.modes, mode.mode[1]);
          }
        }
      });
    });
    this.join(key);
  }

  /**
   * Relay messages between this channel to another
   * @param  {IrcChannel|String} target_chan Target channel
   * @param  {Object} opts        Extra options
   *
   * opts may contain the following properties:
   * one_way (false) Only relay messages to target_chan, not the reverse
   * replay_nicks (true) Include the sending nick as part of the relayed message
   */
  _createClass(IrcChannel, [{
    key: "relay",
    value: function relay(target_chan, opts) {
      opts = _.extend({
        one_way: false,
        replay_nicks: true
      }, opts);
      if (typeof target_chan === 'string') {
        target_chan = this.irc_client.channel(target_chan);
      }
      var this_stream = this.stream(opts);
      var other_stream = target_chan.stream(opts);
      this_stream.pipe(other_stream);
      if (!opts.one_way) {
        other_stream.pipe(this_stream);
      }
    }
  }, {
    key: "stream",
    value: function stream(stream_opts) {
      var _this2 = this;
      var read_queue = [];
      var is_reading = false;
      var stream = new DuplexStream({
        objectMode: true,
        write: function write(chunk, encoding, next) {
          // Support piping from one irc buffer to another
          if (_typeof(chunk) === 'object' && typeof chunk.message === 'string') {
            if (stream_opts.replay_nicks) {
              chunk = '<' + chunk.nick + '> ' + chunk.message;
            } else {
              chunk = chunk.message;
            }
          }
          _this2.say(chunk.toString());
          next();
        },
        read: function read() {
          is_reading = true;
          while (read_queue.length > 0) {
            var message = read_queue.shift();
            if (stream.push(message) === false) {
              is_reading = false;
              break;
            }
          }
        }
      });
      this.irc_client.on('privmsg', function (event) {
        if (_this2.irc_client.caseCompare(event.target, _this2.name)) {
          read_queue.push(event);
          if (is_reading) {
            stream._read();
          }
        }
      });
      return stream;
    }
  }, {
    key: "updateUsers",
    value: function updateUsers(cb) {
      var _this3 = this;
      var updateUserList = function updateUserList(event) {
        if (_this3.irc_client.caseCompare(event.channel, _this3.name)) {
          _this3.irc_client.removeListener('userlist', updateUserList);
          if (typeof cb === 'function') {
            cb(_this3);
          }
        }
      };
      this.irc_client.on('userlist', updateUserList);
      this.irc_client.raw('NAMES', this.name);
    }
  }]);
  return IrcChannel;
}();