/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;

public class GVector
implements Serializable,
Cloneable {
    private int length;
    double[] values;

    public GVector(int n) {
        this.length = n;
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = 0.0;
        }
    }

    public GVector(GVector gVector) {
        this.values = new double[gVector.length];
        this.length = gVector.length;
        for (int i = 0; i < this.length; ++i) {
            this.values[i] = gVector.values[i];
        }
    }

    public final double norm() {
        double d = 0.0;
        for (int i = 0; i < this.length; ++i) {
            d += this.values[i] * this.values[i];
        }
        return Math.sqrt(d);
    }

    public final void sub(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector7"));
        }
        for (int i = 0; i < this.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] - gVector.values[i];
        }
    }

    public final void zero() {
        for (int i = 0; i < this.length; ++i) {
            this.values[i] = 0.0;
        }
    }

    public final void set(GVector gVector) {
        if (this.length < gVector.length) {
            this.length = gVector.length;
            this.values = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.values[i] = gVector.values[i];
            }
        } else {
            int n;
            for (n = 0; n < gVector.length; ++n) {
                this.values[n] = gVector.values[n];
            }
            for (n = gVector.length; n < this.length; ++n) {
                this.values[n] = 0.0;
            }
        }
    }

    public final int getSize() {
        return this.values.length;
    }

    public final double getElement(int n) {
        return this.values[n];
    }

    public final void setElement(int n, double d) {
        this.values[n] = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.length * 8);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.values[i]).append(" ");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l = 1L;
        for (int i = 0; i < this.length; ++i) {
            l = 31L * l + VecMathUtil.doubleToLongBits(this.values[i]);
        }
        return (int)(l ^ l >> 32);
    }

    public boolean equals(Object object) {
        try {
            GVector gVector = (GVector)object;
            if (this.length != gVector.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.values[i] == gVector.values[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public Object clone() {
        GVector gVector = null;
        try {
            gVector = (GVector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        gVector.values = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            gVector.values[i] = this.values[i];
        }
        return gVector;
    }
}

