/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.SimpleDataLine;
import com.cleansine.sound.provider.SimpleMixer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleTargetDataLine
extends SimpleDataLine
implements TargetDataLine {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTargetDataLine.class);

    SimpleTargetDataLine(DataLine.Info info, AudioFormat format, int bufferSize, SimpleMixer mixer, @Nonnull Map<AudioFormat, AudioFormat> hwFormatByFormat) {
        super(info, mixer, format, bufferSize, mixer.getDeviceID(), false, hwFormatByFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] bytes, int offset, int len) {
        SimpleTargetDataLine simpleTargetDataLine = this;
        synchronized (simpleTargetDataLine) {
            this.flushing = false;
            if (len == 0) {
                return 0;
            }
            if (len % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Requesting to read non-integral number of frames (" + len + " bytes, frameBytes = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (!this.active && this.inIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int read = 0;
            while (this.inIO && !this.flushing) {
                int readInLoop;
                logger.trace("Trying to read " + len + " bytes");
                Object object = this.lockNative;
                synchronized (object) {
                    readInLoop = SimpleMixer.nRead(this.nativePtr, bytes, offset, len);
                    if (readInLoop < 0) {
                        break;
                    }
                    this.bytePos += (long)readInLoop;
                    if (readInLoop > 0) {
                        this.drained = false;
                    }
                }
                logger.trace("Read " + readInLoop + " bytes");
                read += readInLoop;
                if ((len -= readInLoop) <= 0) break;
                offset += readInLoop;
                object = this.lock;
                synchronized (object) {
                    try {
                        logger.trace("Waiting in read loop for " + this.checkTimeMS + "ms");
                        this.lock.wait(this.checkTimeMS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.flushing) {
                read = 0;
            }
            return read;
        }
    }
}

