/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.SimpleDataLine;
import com.cleansine.sound.provider.SimpleMixer;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleSourceDataLine
extends SimpleDataLine
implements SourceDataLine {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSourceDataLine.class);
    private volatile boolean writtenWhenStopped = false;

    SimpleSourceDataLine(DataLine.Info info, AudioFormat format, int bufferSize, SimpleMixer mixer, Map<AudioFormat, AudioFormat> hwFormatByFormat) {
        super(info, mixer, format, bufferSize, mixer.getDeviceID(), true, hwFormatByFormat);
    }

    @Override
    void doOpen(AudioFormat hwFormat, int bufferBytes) throws LineUnavailableException {
        super.doOpen(hwFormat, bufferBytes);
        this.writtenWhenStopped = false;
    }

    @Override
    void doStart() {
        super.doStart();
        if (this.writtenWhenStopped) {
            this.setStarted(true);
            this.setActive(true);
        }
    }

    @Override
    void doStop() {
        super.doStop();
        this.writtenWhenStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] bytes, int offset, int len) {
        SimpleSourceDataLine simpleSourceDataLine = this;
        synchronized (simpleSourceDataLine) {
            logger.trace("Starting to write " + len + " bytes");
            this.flushing = false;
            if (len == 0) {
                return 0;
            }
            if (len % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Requesting to write non-integral number of frames (" + len + " bytes, frameBytes = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (!this.active && this.inIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int written = 0;
            while (!this.flushing) {
                int writtenInLoop;
                logger.trace("In-loop: trying to write " + len + " bytes");
                Object object = this.lockNative;
                synchronized (object) {
                    writtenInLoop = SimpleMixer.nWrite(this.nativePtr, bytes, offset, len);
                    if (writtenInLoop < 0) {
                        break;
                    }
                    this.bytePos += (long)writtenInLoop;
                    if (writtenInLoop > 0) {
                        this.drained = false;
                    }
                }
                logger.trace("In-loop: wrote " + writtenInLoop + " bytes");
                written += writtenInLoop;
                if (!this.inIO || (len -= writtenInLoop) <= 0) break;
                offset += writtenInLoop;
                object = this.lock;
                synchronized (object) {
                    try {
                        logger.trace("Waiting in write loop for " + this.checkTimeMS + "ms");
                        this.lock.wait(this.checkTimeMS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (written > 0 && !this.inIO) {
                this.writtenWhenStopped = true;
            }
            logger.trace("Wrote total " + written + " bytes");
            return written;
        }
    }
}

