/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.SimpleMixer;
import com.cleansine.sound.provider.SimpleMixerInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleMixerProvider
extends MixerProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMixerProvider.class);
    private static final String LIBRARY_NAME = "csjsound";
    private static boolean isNativeLibLoaded;
    private static final Map<String, SimpleMixerInfo> infosByDeviceID;
    private static final Map<SimpleMixerInfo, SimpleMixer> mixersByInfo;
    private static final int LIB_LOG_LEVEL_ERROR = 0;
    private static final int LIB_LOG_LEVEL_WARN = 1;
    private static final int LIB_LOG_LEVEL_INFO = 2;
    private static final int LIB_LOG_LEVEL_DEBUG = 3;
    private static final int LIB_LOG_LEVEL_TRACE = 4;
    private static final int[] DEFAULT_RATES;
    private static final int[] DEFAULT_CHANNELS;
    private static final int MAX_RATE_LIMIT = 384000;
    private static final int MAX_CHANNELS_LIMIT = 8;
    private static int[] rates;
    private static int[] channels;

    private static int[] parsePropertyToIntArray(String propertyStr) throws NumberFormatException {
        String str = System.getProperty(propertyStr);
        if (str != null && !str.isEmpty()) {
            String[] strItems = str.split(",");
            int[] items = new int[strItems.length];
            int idx = 0;
            try {
                for (String item : strItems) {
                    item = item.trim();
                    items[idx] = Integer.parseInt(item);
                    ++idx;
                }
            }
            catch (NumberFormatException e) {
                logger.error("Cannot parse to int array: " + str);
                return null;
            }
            return (int[])(items.length > 0 ? items : null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMixerProvider() {
        Class<SimpleMixerProvider> clazz = SimpleMixerProvider.class;
        synchronized (SimpleMixerProvider.class) {
            if (isNativeLibLoaded) {
                SimpleMixerProvider.init();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<SimpleMixerProvider> clazz = SimpleMixerProvider.class;
        synchronized (SimpleMixerProvider.class) {
            int cnt = SimpleMixerProvider.nGetMixerCnt();
            if (cnt < 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (infosByDeviceID.isEmpty() || cnt != infosByDeviceID.size()) {
                SimpleMixerProvider.updateInfoCaches(cnt);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void updateInfoCaches(int cnt) {
        Collection<SimpleMixerInfo> origInfos = infosByDeviceID.values();
        HashMap<SimpleMixerInfo, SimpleMixer> mixersByInfoCopy = new HashMap<SimpleMixerInfo, SimpleMixer>(mixersByInfo);
        infosByDeviceID.clear();
        mixersByInfo.clear();
        for (int i = 0; i < cnt; ++i) {
            SimpleMixerInfo newInfo = SimpleMixerProvider.nCreateMixerInfo(i);
            logger.debug("Found device " + newInfo.toMyString());
            SimpleMixerInfo origInfo = SimpleMixerProvider.findOrigInfo(newInfo, origInfos);
            if (origInfo != null) {
                infosByDeviceID.put(origInfo.getDeviceID(), origInfo);
                SimpleMixer mixer = mixersByInfoCopy.get(origInfo);
                if (mixer == null) continue;
                mixersByInfo.put(origInfo, mixer);
                continue;
            }
            infosByDeviceID.put(newInfo.getDeviceID(), newInfo);
        }
    }

    @Nullable
    private static SimpleMixerInfo findOrigInfo(@Nonnull SimpleMixerInfo newInfo, @Nonnull Collection<SimpleMixerInfo> origInfos) {
        for (SimpleMixerInfo origInfo : origInfos) {
            if (!newInfo.isEqualTo(origInfo)) continue;
            return origInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<SimpleMixerProvider> clazz = SimpleMixerProvider.class;
        synchronized (SimpleMixerProvider.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return infosByDeviceID.values().toArray(new SimpleMixerInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(@Nullable Mixer.Info info) {
        Class<SimpleMixerProvider> clazz = SimpleMixerProvider.class;
        synchronized (SimpleMixerProvider.class) {
            if (info == null) {
                for (SimpleMixerInfo lInfo : infosByDeviceID.values()) {
                    SimpleMixer mixer = SimpleMixerProvider.getMixerFor(lInfo);
                    if (mixer.getSourceLineInfo().length <= 0) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return mixer;
                }
            }
            if (info instanceof SimpleMixerInfo) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return SimpleMixerProvider.getMixerFor((SimpleMixerInfo)info);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException("Mixer " + info + "is not supported by this provider");
        }
    }

    public static boolean isFullySpecifiedFormat(@Nonnull AudioFormat format) {
        return format.getSampleRate() != -1.0f && format.getSampleSizeInBits() != -1 && format.getChannels() != -1 && format.getFrameSize() != -1;
    }

    @Nonnull
    private static SimpleMixer getMixerFor(SimpleMixerInfo info) {
        SimpleMixer mixer = mixersByInfo.get(info);
        if (mixer == null) {
            mixer = new SimpleMixer(info);
            mixersByInfo.put(info, mixer);
        }
        return mixer;
    }

    private static native boolean nInit(int var0, @Nonnull String var1, @Nonnull int[] var2, @Nonnull int[] var3, int var4, int var5);

    public static native int nGetMixerCnt();

    public static native SimpleMixerInfo nCreateMixerInfo(int var0);

    static {
        infosByDeviceID = Collections.synchronizedMap(new LinkedHashMap());
        mixersByInfo = new ConcurrentHashMap<SimpleMixerInfo, SimpleMixer>();
        DEFAULT_RATES = new int[]{44100, 48000, 88200, 96000, 176400, 192000, 352800, 384000, 705600, 768000, 1411200, 0x177000};
        DEFAULT_CHANNELS = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 16};
        isNativeLibLoaded = true;
        try {
            String libLogTarget;
            String lib = "csjsound_" + System.getProperty("os.arch");
            logger.debug("Loading dynlib " + lib);
            System.loadLibrary(lib);
            String libLogLevel = System.getProperty("csjsoundLibLogLevel");
            Integer libLogLevelID = null;
            if (libLogLevel != null) {
                switch (libLogLevel = libLogLevel.toLowerCase()) {
                    case "error": {
                        libLogLevelID = 0;
                        break;
                    }
                    case "warn": {
                        libLogLevelID = 1;
                        break;
                    }
                    case "info": {
                        libLogLevelID = 2;
                        break;
                    }
                    case "debug": {
                        libLogLevelID = 3;
                        break;
                    }
                    case "trace": {
                        libLogLevelID = 4;
                        break;
                    }
                }
            }
            if (libLogLevelID == null) {
                libLogLevelID = logger.isTraceEnabled() ? Integer.valueOf(4) : (logger.isDebugEnabled() ? Integer.valueOf(3) : (logger.isInfoEnabled() ? Integer.valueOf(2) : (logger.isWarnEnabled() ? Integer.valueOf(1) : Integer.valueOf(3))));
            }
            if ((libLogTarget = System.getProperty("csjsoundLibLogFile")) == null || libLogTarget.isEmpty()) {
                libLogTarget = System.getProperty("user.home") + "/csjsound-lib.log";
            }
            boolean bothDefaults = true;
            rates = SimpleMixerProvider.parsePropertyToIntArray("csjsoundRates");
            if (rates == null) {
                logger.info("No usable property csjsoundRates found, will use default rates: " + Arrays.toString(DEFAULT_RATES));
                rates = DEFAULT_RATES;
            } else {
                bothDefaults = false;
            }
            channels = SimpleMixerProvider.parsePropertyToIntArray("csjsoundChannels");
            if (channels == null) {
                logger.info("No usable property csjsoundChannels found, will use default channels: " + Arrays.toString(DEFAULT_CHANNELS));
                channels = DEFAULT_CHANNELS;
            } else {
                bothDefaults = false;
            }
            if (bothDefaults) {
                logger.info("Both default rates and default channels used, will use maximum combined limit: rate 384000 vs. channels 8");
            }
            logger.debug("Calling nInit with libLogTarget " + libLogTarget + ", rates: " + Arrays.toString(rates) + ", channels: " + Arrays.toString(channels));
            if (!SimpleMixerProvider.nInit(libLogLevelID, libLogTarget, rates, channels, bothDefaults ? 384000 : 0, bothDefaults ? 8 : 0)) {
                throw new Exception("Initializing " + lib + " failed");
            }
        }
        catch (Throwable t) {
            isNativeLibLoaded = false;
            logger.error("Error loading dynlib:" + t);
        }
    }
}

