/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.DistinctableAudioFormat;
import com.cleansine.sound.provider.SimpleClip;
import com.cleansine.sound.provider.SimpleDataLine;
import com.cleansine.sound.provider.SimpleDataLineInfo;
import com.cleansine.sound.provider.SimpleLine;
import com.cleansine.sound.provider.SimpleMixerInfo;
import com.cleansine.sound.provider.SimpleMixerProvider;
import com.cleansine.sound.provider.SimpleSourceDataLine;
import com.cleansine.sound.provider.SimpleTargetDataLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleMixer
extends SimpleLine
implements Mixer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMixer.class);
    private final Mixer.Info mixerInfo;
    private final SimpleDataLineInfo[] sourceLineInfos;
    private final SimpleDataLineInfo[] targetLineInfos;
    private boolean isOpenedExplicitely = false;
    private boolean isStarted = false;
    private final Vector<Line> sourceLines = new Vector();
    private final Vector<Line> targetLines = new Vector();

    SimpleMixer(SimpleMixerInfo mInfo) {
        super(new Line.Info(Mixer.class), null);
        this.mixer = this;
        this.mixerInfo = mInfo;
        this.sourceLineInfos = this.initLineInfos(true);
        this.targetLineInfos = this.initLineInfos(false);
    }

    @Nonnull
    private SimpleDataLineInfo[] initLineInfos(boolean isSource) {
        SimpleDataLineInfo[] infos = this.createDataLineInfo(isSource);
        if (infos != null) {
            return infos;
        }
        return new SimpleDataLineInfo[0];
    }

    private boolean containsAlso32bitFormat(Collection<AudioFormat> deviceFormats, AudioFormat format24bits) {
        for (AudioFormat format : deviceFormats) {
            if (!format.getEncoding().equals(format24bits.getEncoding()) || format.getChannels() != format24bits.getChannels() || format.getSampleRate() != format24bits.getSampleRate() || format.getSampleSizeInBits() != 32 || format.getFrameRate() != format24bits.getFrameRate() || format.getFrameSize() != format24bits.getFrameSize() || format.isBigEndian() != format24bits.isBigEndian()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private SimpleDataLineInfo[] createDataLineInfo(boolean isSource) {
        Vector<AudioFormat> deviceFormats = new Vector<AudioFormat>();
        SimpleMixer.nGetFormats(this.getDeviceID(), isSource, deviceFormats);
        ArrayList<AudioFormat> reportedDeviceFormats = new ArrayList<AudioFormat>(deviceFormats);
        if (!deviceFormats.isEmpty()) {
            HashMap<AudioFormat, AudioFormat> hwFormatByFormat = new HashMap<AudioFormat, AudioFormat>();
            ArrayList<Integer> idsWithUnspecified24bits = new ArrayList<Integer>();
            for (int i = 0; i < reportedDeviceFormats.size(); ++i) {
                AudioFormat hwFormat = (AudioFormat)reportedDeviceFormats.get(i);
                if (hwFormat.getSampleSizeInBits() != 24) continue;
                if (hwFormat.getFrameSize() == 4 * hwFormat.getChannels()) {
                    DistinctableAudioFormat formatToReport = new DistinctableAudioFormat(hwFormat.getEncoding(), hwFormat.getSampleRate(), 32, hwFormat.getChannels(), hwFormat.getFrameSize(), hwFormat.isBigEndian());
                    reportedDeviceFormats.set(i, formatToReport);
                    if (!this.containsAlso32bitFormat(deviceFormats, hwFormat)) {
                        hwFormatByFormat.put(formatToReport, hwFormat);
                    }
                    logger.debug("Reporting modified 32bit format " + formatToReport + " instead of the hardware format " + hwFormat);
                    continue;
                }
                if (hwFormat.getFrameSize() != -1) continue;
                idsWithUnspecified24bits.add(i);
            }
            if (!hwFormatByFormat.isEmpty()) {
                for (Integer id : idsWithUnspecified24bits) {
                    AudioFormat format = (AudioFormat)reportedDeviceFormats.get(id);
                    DistinctableAudioFormat modifiedFormat = new DistinctableAudioFormat(format.getEncoding(), format.getSampleRate(), 32, -1, -1, format.isBigEndian());
                    reportedDeviceFormats.set(id, modifiedFormat);
                    logger.debug("Using modified 32bit format " + modifiedFormat + " instead of the hardware format " + format);
                }
            }
            AudioFormat[] formats = (AudioFormat[])reportedDeviceFormats.stream().distinct().toArray(AudioFormat[]::new);
            SimpleDataLineInfo[] infos = new SimpleDataLineInfo[isSource ? 2 : 1];
            if (isSource) {
                infos[0] = new SimpleDataLineInfo(SourceDataLine.class, formats, 32, -1, hwFormatByFormat);
                infos[1] = new SimpleDataLineInfo(Clip.class, formats, 32, -1, hwFormatByFormat);
            } else {
                infos[0] = new SimpleDataLineInfo(TargetDataLine.class, formats, 32, -1, hwFormatByFormat);
            }
            return infos;
        }
        return null;
    }

    @Override
    public Line getLine(@Nonnull Line.Info info) {
        SimpleDataLineInfo existingInfo = this.getLineInfo(info);
        if (existingInfo != null) {
            int lineBufferSize = ((DataLine.Info)info).getMaxBufferSize();
            AudioFormat lineFormat = this.getLastFullySpecifiedFormat(existingInfo);
            if (lineFormat != null) {
                if (existingInfo.getLineClass().isAssignableFrom(SimpleClip.class)) {
                    return new SimpleClip(existingInfo, lineFormat, lineBufferSize, this, existingInfo.gethwFormatByFormat());
                }
                if (existingInfo.getLineClass().isAssignableFrom(SimpleSourceDataLine.class)) {
                    return new SimpleSourceDataLine(existingInfo, lineFormat, lineBufferSize, this, existingInfo.gethwFormatByFormat());
                }
                if (existingInfo.getLineClass().isAssignableFrom(SimpleTargetDataLine.class)) {
                    return new SimpleTargetDataLine(existingInfo, lineFormat, lineBufferSize, this, existingInfo.gethwFormatByFormat());
                }
            } else {
                throw new IllegalArgumentException("line info " + info + " has no supported formats");
            }
        }
        throw new IllegalArgumentException("Unsupported line info: " + info);
    }

    @Nullable
    private AudioFormat getLastFullySpecifiedFormat(@Nonnull SimpleDataLineInfo info) {
        AudioFormat[] supportedFormats = info.getFormats();
        if (supportedFormats != null && supportedFormats.length != 0) {
            for (int i = supportedFormats.length - 1; i >= 0; --i) {
                AudioFormat format = supportedFormats[i];
                if (!SimpleMixerProvider.isFullySpecifiedFormat(format)) continue;
                return format;
            }
        }
        return null;
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (this.getLineInfo(info) != null) {
            return ((SimpleMixerInfo)this.getMixerInfo()).getMaxLines();
        }
        return 0;
    }

    String getDeviceID() {
        return ((SimpleMixerInfo)this.getMixerInfo()).getDeviceID();
    }

    private static void addFormat(Vector<AudioFormat> v, int bits, int frameBytes, int channels, int rate, int encoding, boolean isSigned, boolean isBigEndian) {
        AudioFormat.Encoding enc;
        if (encoding != 0) {
            logger.error("SimpleMixer.addFormat called with unsupported encoding: " + encoding);
            return;
        }
        AudioFormat.Encoding encoding2 = enc = isSigned ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        if (frameBytes <= 0) {
            frameBytes = channels > 0 ? (bits + 7) / 8 * channels : -1;
        }
        v.add(new DistinctableAudioFormat(enc, rate, bits, channels, frameBytes, isBigEndian));
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        return Arrays.copyOf(this.sourceLineInfos, this.sourceLineInfos.length);
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        return Arrays.copyOf(this.targetLineInfos, this.targetLineInfos.length);
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        return (Line.Info[])Arrays.stream(this.sourceLineInfos).filter(info::matches).toArray(Line.Info[]::new);
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        return (Line.Info[])Arrays.stream(this.targetLineInfos).filter(info::matches).toArray(Line.Info[]::new);
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        return this.getLineInfo(info) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line[] getSourceLines() {
        Vector<Line> vector = this.sourceLines;
        synchronized (vector) {
            return this.sourceLines.toArray(new Line[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line[] getTargetLines() {
        Vector<Line> vector = this.targetLines;
        synchronized (vector) {
            return this.targetLines.toArray(new Line[0]);
        }
    }

    @Override
    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported.");
    }

    @Override
    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported.");
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    @Override
    public synchronized void open() {
        this.openLine(true);
    }

    synchronized void openLine(boolean isExplicitely) {
        if (!this.isOpen()) {
            this.setOpen(true);
            if (isExplicitely) {
                this.isOpenedExplicitely = true;
            }
        }
    }

    synchronized void openLine(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.openLine(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.openLine(false);
                this.targetLines.addElement(line);
            }
        } else {
            logger.error("Unknown line received for AbstractMixer.open(Line): " + line);
        }
    }

    synchronized void closeLine(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.isOpenedExplicitely) {
            this.close();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            for (Line line : this.getSourceLines()) {
                line.close();
            }
            for (Line line : this.getTargetLines()) {
                line.close();
            }
            this.setOpen(false);
        }
        this.isOpenedExplicitely = false;
    }

    synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.isStarted) {
            this.isStarted = true;
        }
    }

    synchronized void stopLine(Line line) {
        if (this.equals(line)) {
            return;
        }
        for (Line l : new Vector<Line>(this.sourceLines)) {
            if (!((SimpleDataLine)l).running || l.equals(line)) continue;
            return;
        }
        for (Line l : new Vector<Line>(this.targetLines)) {
            if (!((SimpleDataLine)l).running || l.equals(line)) continue;
            return;
        }
        this.isStarted = false;
    }

    boolean isSourceLine(Line.Info info) {
        for (SimpleDataLineInfo i : this.sourceLineInfos) {
            if (!info.matches(i)) continue;
            return true;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        for (SimpleDataLineInfo i : this.targetLineInfos) {
            if (!info.matches(i)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    SimpleDataLineInfo getLineInfo(@Nonnull Line.Info info) {
        for (SimpleDataLineInfo i : this.sourceLineInfos) {
            if (!info.matches(i)) continue;
            return i;
        }
        for (SimpleDataLineInfo i : this.targetLineInfos) {
            if (!info.matches(i)) continue;
            return i;
        }
        return null;
    }

    public static native void nGetFormats(String var0, boolean var1, Vector<AudioFormat> var2);

    static native void nStart(long var0, boolean var2);

    static native void nStop(long var0, boolean var2);

    static native long nOpen(String var0, boolean var1, int var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9) throws LineUnavailableException;

    static native void nClose(long var0, boolean var2);

    static native int nRead(long var0, byte[] var2, int var3, int var4);

    static native int nWrite(long var0, byte[] var2, int var3, int var4);

    static native int nGetBufferBytes(long var0, boolean var2);

    static native int nGetAvailBytes(long var0, boolean var2);

    static native void nDrain(long var0);

    static native void nFlush(long var0, boolean var2);

    static native long nGetBytePos(long var0, boolean var2, long var3);
}

