/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.SimpleLine;
import com.cleansine.sound.provider.SimpleMixer;
import com.cleansine.sound.provider.SimpleMixerProvider;
import com.cleansine.sound.provider.SimpleSourceDataLine;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SimpleDataLine
extends SimpleLine
implements DataLine {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSourceDataLine.class);
    protected static final int PCM_ENCODING = 0;
    private static final int DEFAULT_BUFFER_TIME_MS = 500;
    protected final String deviceID;
    protected final boolean isSource;
    protected AudioFormat format;
    protected int bufferBytes;
    protected final Object lock = new Object();
    protected final Object lockNative = new Object();
    protected volatile boolean running;
    protected long nativePtr;
    protected int checkTimeMS;
    protected volatile boolean flushing = false;
    protected volatile long bytePos;
    protected volatile boolean inIO = false;
    protected volatile boolean started;
    protected volatile boolean drained = false;
    protected volatile boolean active;
    private final Map<AudioFormat, AudioFormat> hwFormatByFormat;

    protected SimpleDataLine(DataLine.Info info, SimpleMixer mixer, @Nonnull AudioFormat format, int bufferBytes, String deviceID, boolean isSource, @Nonnull Map<AudioFormat, AudioFormat> hwFormatByFormat) {
        super(info, mixer);
        this.format = format;
        this.bufferBytes = bufferBytes;
        this.deviceID = deviceID;
        this.checkTimeMS = 2;
        this.isSource = isSource;
        this.hwFormatByFormat = hwFormatByFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(@Nonnull AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (!SimpleMixerProvider.isFullySpecifiedFormat(format)) {
            throw new LineUnavailableException("Format " + format + " not fully specified, " + SimpleDataLine.class.getSimpleName() + " + supports only fully specified formats");
        }
        AudioFormat hwFormat = this.determineHwFormat(format);
        SimpleMixer simpleMixer = this.mixer;
        synchronized (simpleMixer) {
            if (!this.isOpen()) {
                this.mixer.openLine(this);
                try {
                    this.doOpen(hwFormat, bufferSize);
                    this.format = format;
                    this.setOpen(true);
                }
                catch (LineUnavailableException e) {
                    this.mixer.closeLine(this);
                    throw e;
                }
            } else {
                if (!format.matches(this.getFormat())) {
                    throw new IllegalStateException("Line is already open with format " + this.getFormat());
                }
                if (bufferSize != -1 && bufferSize != this.getBufferSize()) {
                    throw new IllegalStateException("Line is already open with buffer size " + this.getBufferSize());
                }
            }
        }
    }

    @Nonnull
    private AudioFormat determineHwFormat(@Nonnull AudioFormat format) {
        for (Map.Entry<AudioFormat, AudioFormat> entry : this.hwFormatByFormat.entrySet()) {
            if (!entry.getKey().matches(format)) continue;
            AudioFormat hwFormat = entry.getValue();
            logger.debug("Using HW format " + hwFormat + " instead of the requested format " + format);
            return hwFormat;
        }
        return format;
    }

    public void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && !this.running) {
                this.mixer.start(this);
                this.doStart();
                this.running = true;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && this.running) {
                this.doStop();
                this.mixer.stopLine(this);
                this.running = false;
                if (this.started && !this.active) {
                    this.setStarted(false);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getMicrosecondPosition() {
        long us = this.getLongFramePosition();
        if (us != -1L) {
            us = (long)((double)us / (double)this.format.getFrameRate() * 1000000.0);
        }
        return us;
    }

    @Override
    public int getBufferSize() {
        return this.bufferBytes;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public float getLevel() {
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStarted(boolean started) {
        SimpleDataLine simpleDataLine = this;
        synchronized (simpleDataLine) {
            if (this.started != started) {
                this.started = started;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setActive(boolean active) {
        SimpleDataLine simpleDataLine = this;
        synchronized (simpleDataLine) {
            if (this.active != active) {
                this.active = active;
            }
        }
    }

    @Override
    public final void open() throws LineUnavailableException {
        this.open(this.format, this.bufferBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        SimpleMixer simpleMixer = this.mixer;
        synchronized (simpleMixer) {
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.doClose();
                this.mixer.closeLine(this);
            }
        }
    }

    @Override
    public int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    void doOpen(AudioFormat hwFormat, int bufferBytes) throws LineUnavailableException {
        if (!this.isPCMEncoding(hwFormat)) {
            throw new IllegalArgumentException("Unsupported encoding " + hwFormat.getEncoding() + ", only PCM is supported");
        }
        if (hwFormat.getFrameSize() <= 0) {
            throw new IllegalArgumentException("Unsupported format frame size " + hwFormat.getFrameSize());
        }
        if (hwFormat.getFrameRate() <= 0.0f) {
            throw new IllegalArgumentException("Unsupported format frame rate " + hwFormat.getFrameRate());
        }
        if (bufferBytes <= -1) {
            bufferBytes = (int)(500.0f * hwFormat.getFrameRate() / 1000.0f * (float)hwFormat.getFrameSize());
            bufferBytes = bufferBytes / hwFormat.getFrameSize() * hwFormat.getFrameSize();
        }
        bufferBytes = bufferBytes / hwFormat.getFrameSize() * hwFormat.getFrameSize();
        boolean isSigned = hwFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        this.nativePtr = SimpleMixer.nOpen(this.deviceID, this.isSource, 0, (int)hwFormat.getSampleRate(), hwFormat.getSampleSizeInBits(), hwFormat.getFrameSize(), hwFormat.getChannels(), isSigned, hwFormat.isBigEndian(), bufferBytes);
        if (this.nativePtr <= 0L) {
            throw new LineUnavailableException("line with hwFormat " + hwFormat + " not supported.");
        }
        this.bufferBytes = SimpleMixer.nGetBufferBytes(this.nativePtr, this.isSource);
        if (this.bufferBytes < 1) {
            logger.warn("Native call nGetBufferBytes returned " + this.bufferBytes + "!");
            this.bufferBytes = bufferBytes;
        }
        this.checkTimeMS = (int)((float)this.bufferBytes / hwFormat.getFrameRate() * 1000.0f / (float)hwFormat.getFrameSize()) / 8;
        this.bytePos = 0L;
        this.inIO = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() {
        this.inIO = false;
        long prevID = this.nativePtr;
        this.nativePtr = 0L;
        Object object = this.lockNative;
        synchronized (object) {
            SimpleMixer.nClose(prevID, this.isSource);
        }
        this.bytePos = 0L;
    }

    private boolean isPCMEncoding(AudioFormat format) {
        return format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStart() {
        Object object = this.lockNative;
        synchronized (object) {
            SimpleMixer.nStart(this.nativePtr, this.isSource);
        }
        this.inIO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        Object object = this.lockNative;
        synchronized (object) {
            SimpleMixer.nStop(this.nativePtr, this.isSource);
        }
        object = this.lock;
        synchronized (object) {
            this.inIO = false;
            this.lock.notifyAll();
        }
        this.setActive(false);
        this.setStarted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        int a;
        if (this.nativePtr == 0L) {
            return 0;
        }
        Object object = this.lockNative;
        synchronized (object) {
            a = SimpleMixer.nGetAvailBytes(this.nativePtr, this.isSource);
        }
        logger.trace("Available: " + a + " bytes");
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drain() {
        if (this.nativePtr != 0L && this.inIO) {
            Object object = this.lockNative;
            synchronized (object) {
                SimpleMixer.nDrain(this.nativePtr);
            }
        }
        this.drained = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.nativePtr != 0L) {
            this.flushing = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            object = this.lockNative;
            synchronized (object) {
                if (this.nativePtr != 0L) {
                    SimpleMixer.nFlush(this.nativePtr, this.isSource);
                }
            }
            this.drained = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongFramePosition() {
        long pos;
        Object object = this.lockNative;
        synchronized (object) {
            pos = SimpleMixer.nGetBytePos(this.nativePtr, this.isSource, this.bytePos);
        }
        if (pos < 0L) {
            pos = 0L;
        }
        return pos / (long)this.getFormat().getFrameSize();
    }
}

