/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound.provider;

import com.cleansine.sound.provider.SimpleMixer;
import com.cleansine.sound.provider.SimpleSourceDataLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;

class SimpleClip
extends SimpleSourceDataLine
implements Clip,
Runnable {
    private static final long CLIP_BUFFER_TIME = 1000L;
    private volatile Thread thread;
    private volatile byte[] audioData = null;
    private volatile int frameSize;
    private volatile int m_lengthInFrames;
    private volatile int loopCount;
    private volatile int clipBytePosition;
    private volatile int newFramePosition;
    private volatile int loopStartFrame;
    private volatile int loopEndFrame;

    SimpleClip(DataLine.Info info, AudioFormat format, int bufferSize, SimpleMixer mixer, Map<AudioFormat, AudioFormat> hwFormatByFormat) {
        super(info, format, bufferSize, mixer, hwFormatByFormat);
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        this.isFullySpecifiedPCMFormat(format);
        if (bufferSize % format.getFrameSize() != 0) {
            String msg = String.format("Buffer size (%d) does not represent an integral number of sample frames (%d)", bufferSize, format.getFrameSize());
            throw new LineUnavailableException(msg);
        }
        byte[] newData = new byte[bufferSize];
        System.arraycopy(data, offset, newData, 0, bufferSize);
        this.open(format, newData, bufferSize / format.getFrameSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(AudioFormat format, byte[] data, int frameLength) throws LineUnavailableException {
        this.isFullySpecifiedPCMFormat(format);
        SimpleMixer simpleMixer = this.mixer;
        synchronized (simpleMixer) {
            if (this.isOpen()) {
                throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
            }
            this.audioData = data;
            this.frameSize = format.getFrameSize();
            this.m_lengthInFrames = frameLength;
            this.bytePos = 0L;
            this.clipBytePosition = 0;
            this.newFramePosition = -1;
            this.loopStartFrame = 0;
            this.loopEndFrame = frameLength - 1;
            this.loopCount = 0;
            try {
                this.open(format, (int)this.millis2bytes(format, 1000L));
            }
            catch (IllegalArgumentException | LineUnavailableException ex) {
                this.audioData = null;
                throw ex;
            }
            int priority = 6;
            this.thread = new Thread((Runnable)this, "Simple Clip");
            this.thread.setDaemon(true);
            this.thread.setPriority(priority);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        this.isFullySpecifiedPCMFormat(stream.getFormat());
        SimpleMixer simpleMixer = this.mixer;
        synchronized (simpleMixer) {
            byte[] streamData = null;
            if (this.isOpen()) {
                throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
            }
            int lengthInFrames = (int)stream.getFrameLength();
            int bytesRead = 0;
            int frameSize = stream.getFormat().getFrameSize();
            if (lengthInFrames != -1) {
                int arraysize = lengthInFrames * frameSize;
                if (arraysize < 0) {
                    throw new IllegalArgumentException("Audio data < 0");
                }
                try {
                    streamData = new byte[arraysize];
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("Audio data is too big");
                }
                int bytesRemaining = arraysize;
                int thisRead = 0;
                while (bytesRemaining > 0 && thisRead >= 0) {
                    thisRead = stream.read(streamData, bytesRead, bytesRemaining);
                    if (thisRead > 0) {
                        bytesRead += thisRead;
                        bytesRemaining -= thisRead;
                        continue;
                    }
                    if (thisRead != 0) continue;
                    Thread.yield();
                }
            } else {
                byte[] tmp;
                int maxReadLimit = Math.max(16384, frameSize);
                DirectBAOS dbaos = new DirectBAOS();
                try {
                    tmp = new byte[maxReadLimit];
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("Audio data is too big");
                }
                int thisRead = 0;
                while (thisRead >= 0) {
                    thisRead = stream.read(tmp, 0, tmp.length);
                    if (thisRead > 0) {
                        dbaos.write(tmp, 0, thisRead);
                        bytesRead += thisRead;
                        continue;
                    }
                    if (thisRead != 0) continue;
                    Thread.yield();
                }
                streamData = dbaos.getInternalBuffer();
            }
            lengthInFrames = bytesRead / frameSize;
            this.open(stream.getFormat(), streamData, lengthInFrames);
        }
    }

    @Override
    public int getFrameLength() {
        return this.m_lengthInFrames;
    }

    @Override
    public long getMicrosecondLength() {
        return this.frames2micros(this.getFormat(), this.getFrameLength());
    }

    @Override
    public void setFramePosition(int frames) {
        if (frames < 0) {
            frames = 0;
        } else if (frames >= this.getFrameLength()) {
            frames = this.getFrameLength();
        }
        if (this.inIO) {
            this.newFramePosition = frames;
        } else {
            this.clipBytePosition = frames * this.frameSize;
            this.newFramePosition = -1;
        }
        this.bytePos = frames * this.frameSize;
        this.flush();
    }

    @Override
    public long getLongFramePosition() {
        return super.getLongFramePosition();
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        long frames = this.micros2frames(this.getFormat(), microseconds);
        this.setFramePosition((int)frames);
    }

    @Override
    public void setLoopPoints(int start, int end) {
        if (start < 0 || start >= this.getFrameLength()) {
            throw new IllegalArgumentException("illegal value for start: " + start);
        }
        if (end >= this.getFrameLength()) {
            throw new IllegalArgumentException("illegal value for end: " + end);
        }
        if (end == -1 && (end = this.getFrameLength() - 1) < 0) {
            end = 0;
        }
        if (end < start) {
            throw new IllegalArgumentException("End position " + end + "  preceeds start position " + start);
        }
        this.loopStartFrame = start;
        this.loopEndFrame = end;
    }

    @Override
    public void loop(int count) {
        this.loopCount = count;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread curThread = Thread.currentThread();
        while (this.thread == curThread) {
            Object object = this.lock;
            synchronized (object) {
                while (!this.inIO && this.thread == curThread) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            while (this.inIO && this.thread == curThread) {
                long framePos;
                int toWriteFrames;
                int toWriteBytes;
                if (this.newFramePosition >= 0) {
                    this.clipBytePosition = this.newFramePosition * this.frameSize;
                    this.newFramePosition = -1;
                }
                int endFrame = this.getFrameLength() - 1;
                if (this.loopCount > 0 || this.loopCount == -1) {
                    endFrame = this.loopEndFrame;
                }
                if ((toWriteBytes = (toWriteFrames = (int)((long)endFrame - (framePos = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                    toWriteBytes = this.align(this.getBufferSize(), this.frameSize);
                }
                int written = this.write(this.audioData, this.clipBytePosition, toWriteBytes);
                this.clipBytePosition += written;
                if (!this.inIO || this.newFramePosition >= 0 || written < 0 || (framePos = (long)(this.clipBytePosition / this.frameSize)) <= (long)endFrame) continue;
                if (this.loopCount > 0 || this.loopCount == -1) {
                    if (this.loopCount != -1) {
                        --this.loopCount;
                    }
                    this.newFramePosition = this.loopStartFrame;
                    continue;
                }
                this.drain();
                this.stop();
            }
        }
    }

    void isFullySpecifiedPCMFormat(AudioFormat format) throws LineUnavailableException {
        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new LineUnavailableException("SimpleClip must be PCM format");
        }
        if (format.getFrameRate() <= 0.0f || format.getSampleRate() <= 0.0f || format.getSampleSizeInBits() <= 0 || format.getFrameSize() <= 0 || format.getChannels() <= 0) {
            throw new LineUnavailableException("Frame rate, Sample rate, Sample size in bits, Frame size or Channel count not specified");
        }
    }

    long millis2bytes(AudioFormat format, long millis) {
        long result = (long)((float)millis * format.getFrameRate() / 1000.0f * (float)format.getFrameSize());
        return this.align(result, format.getFrameSize());
    }

    long micros2frames(AudioFormat format, long micros) {
        return (long)((float)micros * format.getFrameRate() / 1000000.0f);
    }

    long frames2micros(AudioFormat format, long frames) {
        return (long)((double)frames / (double)format.getFrameRate() * 1000000.0);
    }

    long align(long bytes, int blockSize) {
        return blockSize <= 1 ? bytes : bytes - bytes % (long)blockSize;
    }

    int align(int bytes, int blockSize) {
        return blockSize <= 1 ? bytes : bytes - bytes % blockSize;
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        DirectBAOS() {
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

