/*
 * Decompiled with CFR 0.152.
 */
package com.cleansine.sound;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPlayerS16LE {
    private static final Logger logger = LoggerFactory.getLogger(TestPlayerS16LE.class);
    public static final int BUFFER_BYTES = 131072;
    private final int samplerate;
    private final int sampleBits;
    private final int channels;

    public TestPlayerS16LE(int samplerate, int channels) {
        this.samplerate = samplerate;
        this.sampleBits = 32;
        this.channels = channels;
    }

    public void play(@Nonnull Selector sourceSelector, @Nullable Selector targetSelector, @Nonnull Op what, int length_ms) {
        AudioFormat af = new AudioFormat(this.samplerate, this.sampleBits, this.channels, true, false);
        DataLine.Info sLineInfo = new DataLine.Info(SourceDataLine.class, af);
        DataLine.Info tLineInfo = new DataLine.Info(TargetDataLine.class, af);
        try {
            int bufferBytes;
            Mixer.Info[] infos = AudioSystem.getMixerInfo();
            Optional<Mixer.Info> sourceInfo = Arrays.stream(infos).filter(i -> sourceSelector.filter((Mixer.Info)i) && !i.getName().contains("Port")).findFirst();
            assert (sourceInfo.isPresent());
            assert (sourceInfo.get() instanceof SourceDataLine);
            Mixer sMixer = AudioSystem.getMixer(sourceInfo.get());
            SourceDataLine sLine = (SourceDataLine)sMixer.getLine(sLineInfo);
            sLine.open(af, 131072);
            TargetDataLine tLine = null;
            if (what.doLoopback) {
                Optional<Mixer.Info> targetInfo = Arrays.stream(infos).filter(i -> targetSelector.filter((Mixer.Info)i) && !i.getName().contains("Port")).findFirst();
                assert (targetInfo.isPresent());
                assert (targetInfo.get() instanceof TargetDataLine);
                tLine = (TargetDataLine)AudioSystem.getMixer(targetInfo.get()).getLine(tLineInfo);
                tLine.open(af, 131072);
                bufferBytes = tLine.getBufferSize();
                tLine.start();
            } else {
                bufferBytes = sLine.getBufferSize();
            }
            int frameBytes = af.getFrameSize();
            int framesInWrite = 6144;
            double[] samples = what.getSamples(this.samplerate, length_ms);
            int toneIdx = 0;
            while (toneIdx + framesInWrite < samples.length) {
                byte[] buffer;
                if (what.doLoopback) {
                    buffer = new byte[framesInWrite * frameBytes];
                    int n = tLine.read(buffer, 0, buffer.length);
                } else {
                    buffer = this.convertToBytes(samples, toneIdx, framesInWrite, frameBytes);
                }
                logger.debug("Playback before writing: availbytes " + sLine.available());
                int countWritten = sLine.write(buffer, 0, buffer.length);
                logger.debug("Playback after writing: availbytes " + sLine.available());
                toneIdx += framesInWrite;
            }
            sLine.flush();
            sLine.close();
            if (tLine != null) {
                tLine.close();
            }
        }
        catch (LineUnavailableException e) {
            logger.error(e.getLocalizedMessage());
        }
    }

    private byte[] convertToBytes(double[] sines, int toneIdx, int framesInWrite, int frameBytes) {
        byte[] buffer = new byte[framesInWrite * frameBytes];
        int limit = toneIdx + framesInWrite;
        int bufferIdx = 0;
        byte[] sampleBytes = new byte[4];
        for (int i = toneIdx; i < limit; ++i) {
            double sine = sines[i];
            int sample = (int)(sine * 2.147483647E9);
            sampleBytes[0] = (byte)(sample & 0xFF);
            sampleBytes[1] = (byte)(sample >> 8 & 0xFF);
            sampleBytes[2] = (byte)(sample >> 16 & 0xFF);
            sampleBytes[3] = (byte)(sample >> 24 & 0xFF);
            for (int ch = 0; ch < this.channels; ++ch) {
                byte[] byArray = sampleBytes;
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte sampleByte;
                    buffer[bufferIdx] = sampleByte = byArray[j];
                    ++bufferIdx;
                }
            }
        }
        return buffer;
    }

    private static double[] createSineSamples(double freq, int samplerate, int ms) {
        int samples = ms * samplerate / 1000;
        double[] output = new double[samples];
        double period = (double)samplerate / freq;
        for (int i = 0; i < output.length; ++i) {
            double angle = Math.PI * 2 * (double)i / period;
            output[i] = 0.2 * Math.sin(angle);
        }
        return output;
    }

    public static enum Op {
        SINE_1K(false){

            @Override
            public double[] getSamples(int samplerate, int ms) {
                return TestPlayerS16LE.createSineSamples(1000.0, samplerate, ms);
            }
        }
        ,
        SINE_10K(false){

            @Override
            public double[] getSamples(int samplerate, int ms) {
                return TestPlayerS16LE.createSineSamples(10000.0, samplerate, ms);
            }
        }
        ,
        LOOPBACK(true){

            @Override
            public double[] getSamples(int samplerate, int ms) {
                return new double[ms * samplerate / 1000];
            }
        };

        final boolean doLoopback;

        private Op(boolean doLoopback) {
            this.doLoopback = doLoopback;
        }

        public abstract double[] getSamples(int var1, int var2);
    }

    @FunctionalInterface
    static interface Selector {
        public boolean filter(Mixer.Info var1);
    }
}

