/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import us.hebi.matlab.mat.types.AbstractSource;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.util.Preconditions;
import us.hebi.matlab.mat.util.Unsafe9R;

public class Sources {
    public static Source openFile(String file) throws IOException {
        return Sources.openFile(new File(Sources.checkInputNotNull(file)));
    }

    public static Source openFile(File file) throws IOException {
        Sources.checkFileExists(file);
        if (file.length() > Integer.MAX_VALUE) {
            return Sources.openStreamingFile(file);
        }
        final FileChannel channel = new RandomAccessFile(file, "r").getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)channel.size()).load();
        buffer.order(ByteOrder.nativeOrder());
        return new ByteBufferSource((ByteBuffer)buffer, 512){

            @Override
            public void close() throws IOException {
                super.close();
                Unsafe9R.invokeCleaner(this.buffer);
                channel.close();
            }
        };
    }

    public static Source openStreamingFile(File file) throws IOException {
        return new BufferedFileSource(Sources.checkFileExists(file));
    }

    public static Source wrap(byte[] bytes) {
        return Sources.wrap(ByteBuffer.wrap(Sources.checkInputNotNull(bytes)));
    }

    public static Source wrap(ByteBuffer buffer) {
        return new ByteBufferSource(Sources.checkInputNotNull(buffer), 128);
    }

    public static Source wrapInputStream(InputStream inputStream) {
        return Sources.wrapInputStream(inputStream, 512);
    }

    public static Source wrapInputStream(InputStream inputStream, int bufferSize) {
        return new InputStreamSource(Sources.checkInputNotNull(inputStream), bufferSize);
    }

    private static <T> T checkInputNotNull(T input) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        return input;
    }

    private static File checkFileExists(File file) {
        if (file == null) {
            throw new NullPointerException("input file must not be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("input file does not exist: " + file.getPath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("input path is not a valid file: " + file.getPath());
        }
        return file;
    }

    private Sources() {
    }

    private static class BufferedFileSource
    extends AbstractSource {
        private final ByteBuffer directBuffer = ByteBuffer.allocateDirect(32768);
        private final FileChannel fileChannel;
        private long fileChannelPosition = 0L;

        protected BufferedFileSource(File file) throws IOException {
            super(512);
            this.fileChannel = new RandomAccessFile(file, "rw").getChannel();
            this.directBuffer.limit(0);
        }

        @Override
        protected InputStream readBytesAsStream(long numBytes) throws IOException {
            return new SourceInputStream(this, numBytes);
        }

        @Override
        public long getPosition() {
            return this.fileChannelPosition + (long)this.directBuffer.position();
        }

        @Override
        public void readByteBuffer(ByteBuffer buffer) throws IOException {
            if (buffer.hasArray()) {
                super.readByteBuffer(buffer);
                return;
            }
            if (this.directBuffer.remaining() > 0) {
                int oldLimit = this.directBuffer.limit();
                int limit = Math.min(oldLimit, this.directBuffer.position() + buffer.remaining());
                this.directBuffer.limit(limit);
                buffer.put(this.directBuffer);
                this.directBuffer.limit(oldLimit);
            }
            if (buffer.hasRemaining()) {
                Preconditions.checkState(!this.directBuffer.hasRemaining(), "Read buffer was not fully emptied");
                int numBytes = this.fileChannel.read(buffer);
                this.fileChannelPosition += (long)Math.max(0, numBytes);
                if (buffer.hasRemaining()) {
                    throw new EOFException();
                }
            }
        }

        @Override
        public void readBytes(byte[] buffer, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.directBuffer.remaining() == 0) {
                    this.fileChannelPosition += (long)this.directBuffer.position();
                    this.directBuffer.clear();
                    if (this.fileChannel.read(this.directBuffer) == -1) {
                        throw new EOFException();
                    }
                    this.directBuffer.flip();
                }
                int n = Math.min(this.directBuffer.remaining(), length);
                this.directBuffer.get(buffer, offset, n);
                offset += n;
                length -= n;
            }
        }

        @Override
        public boolean isMutatedByChildren() {
            return true;
        }

        @Override
        public void close() throws IOException {
            Unsafe9R.invokeCleaner(this.directBuffer);
            this.fileChannel.close();
        }
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buffer;

        private ByteBufferInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() {
            if (this.buffer.remaining() > 0) {
                return this.buffer.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if ((len = Math.min(len, this.buffer.remaining())) > 0) {
                this.buffer.get(b, off, len);
                return len;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    private static class ByteBufferSource
    extends AbstractSource {
        final ByteBuffer buffer;

        private ByteBufferSource(ByteBuffer buffer, int bufferSize) {
            super(bufferSize);
            this.buffer = buffer;
        }

        @Override
        public AbstractSource order(ByteOrder byteOrder) {
            super.order(byteOrder);
            this.buffer.order(byteOrder);
            return this;
        }

        @Override
        public ByteOrder order() {
            return this.buffer.order();
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.buffer.get();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return this.buffer.getShort();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.buffer.getInt();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.buffer.getLong();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                return this.buffer.getFloat();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                return this.buffer.getDouble();
            }
            catch (BufferUnderflowException underflow) {
                throw new EOFException();
            }
        }

        @Override
        public InputStream readBytesAsStream(long numBytes) throws IOException {
            if (numBytes > (long)this.buffer.remaining()) {
                throw new EOFException();
            }
            ByteBuffer slice = this.buffer.asReadOnlyBuffer();
            slice.limit(this.buffer.position() + (int)numBytes);
            this.buffer.position(this.buffer.position() + (int)numBytes);
            return new ByteBufferInputStream(slice);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isMutatedByChildren() {
            return false;
        }

        @Override
        public void readByteBuffer(ByteBuffer dst) throws IOException {
            if (dst.remaining() > this.buffer.remaining()) {
                throw new EOFException();
            }
            int limit = this.buffer.limit();
            try {
                this.buffer.limit(this.buffer.position() + dst.remaining());
                dst.put(this.buffer);
            }
            finally {
                this.buffer.limit(limit);
            }
        }

        @Override
        public void readBytes(byte[] bytes, int offset, int length) throws IOException {
            if (length > this.buffer.remaining()) {
                throw new EOFException();
            }
            this.buffer.get(bytes, offset, length);
        }

        @Override
        public long getPosition() {
            return this.buffer.position();
        }
    }

    private static class InputStreamSource
    extends AbstractSource {
        long position = 0L;
        final InputStream input;

        InputStreamSource(InputStream input, int bufferSize) {
            super(bufferSize);
            this.input = input;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public void readBytes(byte[] bytes, int offset, int length) throws IOException {
            int count;
            for (int n = 0; n < length; n += count) {
                count = this.input.read(bytes, offset + n, length - n);
                if (count >= 0) continue;
                String format = "Reached end of stream after reading %d bytes. Expected %d bytes.";
                throw new EOFException(String.format(format, n, length));
            }
            this.position += (long)length;
        }

        @Override
        public boolean isMutatedByChildren() {
            return true;
        }

        @Override
        protected InputStream readBytesAsStream(long numBytes) {
            return new SourceInputStream(this, numBytes);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class SourceInputStream
    extends InputStream {
        long position = 0L;
        final Source matInput;
        final long maxLength;

        private SourceInputStream(Source matInput, long maxLength) {
            this.matInput = matInput;
            this.maxLength = maxLength;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remaining = (int)(this.maxLength - this.position);
            if (remaining == 0) {
                return -1;
            }
            len = Math.min(len, remaining);
            this.matInput.readBytes(b, off, len);
            this.position += (long)len;
            return len;
        }

        @Override
        public int read() {
            throw new IllegalStateException("not implemented");
        }
    }
}

