/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import us.hebi.matlab.mat.types.AbstractSink;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;
import us.hebi.matlab.mat.util.Unsafe9R;

public class Sinks {
    static final int DISK_IO_BUFFER_SIZE = 32768;
    private static final int defaultCopyBufferSize = 4096;

    public static Sink newStreamingFile(File file) throws IOException {
        return Sinks.newStreamingFile(file, false);
    }

    public static Sink newStreamingFile(File file, boolean append) throws IOException {
        Sinks.checkOutputNotNull(file);
        if (!append) {
            Sinks.deleteFileIfExists(file);
        }
        Sinks.createParentDirs(file);
        final FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        final ByteBuffer directBuffer = ByteBuffer.allocateDirect(32768);
        if (append) {
            channel.position(file.length());
        }
        return new AbstractSink(4096){

            @Override
            public long position() throws IOException {
                return channel.position() + (long)directBuffer.position();
            }

            @Override
            public void position(long position) throws IOException {
                this.flush();
                channel.position(position);
            }

            @Override
            public void writeByteBuffer(ByteBuffer buffer) throws IOException {
                this.flush();
                channel.write(buffer);
            }

            @Override
            public void writeBytes(byte[] buffer, int offset, int length) throws IOException {
                while (length > 0) {
                    int n = Math.min(length, directBuffer.remaining());
                    directBuffer.put(buffer, offset, n);
                    offset += n;
                    length -= n;
                    if (directBuffer.remaining() != 0) continue;
                    this.flush();
                }
            }

            private void flush() throws IOException {
                if (directBuffer.position() == 0) {
                    return;
                }
                directBuffer.flip();
                channel.write(directBuffer);
                directBuffer.clear();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                channel.close();
                Unsafe9R.invokeCleaner(directBuffer);
            }
        };
    }

    public static Sink newStreamingFile(String file) throws IOException {
        return Sinks.newStreamingFile(new File(Sinks.checkOutputNotNull(file)));
    }

    public static Sink newStreamingFile(String file, boolean append) throws IOException {
        return Sinks.newStreamingFile(new File(Sinks.checkOutputNotNull(file)), append);
    }

    public static Sink newMappedFile(File file, int maxExpectedSize) throws IOException {
        Sinks.checkOutputNotNull(file);
        Sinks.deleteFileIfExists(file);
        Sinks.createParentDirs(file);
        final FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        final MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, maxExpectedSize).load();
        buffer.order(ByteOrder.nativeOrder());
        return new BufferSink(buffer, 4096){

            @Override
            public void close() throws IOException {
                super.close();
                long finalSize = buffer.position();
                Unsafe9R.invokeCleaner(buffer);
                channel.truncate(finalSize);
                channel.close();
            }
        };
    }

    public static Sink wrap(ByteBuffer buffer) {
        return new BufferSink(buffer, Math.min(buffer.remaining(), 4096));
    }

    public static Sink wrapNonSeeking(OutputStream outputStream) {
        return Sinks.wrapNonSeeking(outputStream, 4096);
    }

    public static Sink wrapNonSeeking(OutputStream outputStream, int copyBufferSize) {
        return new OutputStreamSink(Sinks.checkOutputNotNull(outputStream), copyBufferSize);
    }

    private static <T> T checkOutputNotNull(T output) {
        if (output == null) {
            throw new NullPointerException("output must not be null");
        }
        return output;
    }

    private static void deleteFileIfExists(File file) throws IOException {
        if (Preconditions.checkNotNull(file).exists() && !file.delete()) {
            throw new IOException("Failed to overwrite " + file.getAbsolutePath());
        }
    }

    private static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    private Sinks() {
    }

    private static class BufferSink
    extends AbstractSink {
        final ByteBuffer out;

        private BufferSink(ByteBuffer out, int writeBufferSize) {
            super(writeBufferSize);
            this.out = out;
        }

        @Override
        public ByteOrder order() {
            return this.out.order();
        }

        @Override
        public AbstractSink order(ByteOrder order) {
            this.out.order(order);
            return this;
        }

        @Override
        public long position() {
            return this.out.position();
        }

        @Override
        public void position(long position) {
            this.out.position(Casts.sint32(position));
        }

        @Override
        public void writeByteBuffer(ByteBuffer src) {
            this.out.put(src);
        }

        @Override
        public void writeBytes(byte[] buffer, int offset, int length) {
            this.out.put(buffer, offset, length);
        }

        @Override
        public void writeByte(byte value) throws IOException {
            this.out.put(value);
        }

        @Override
        public void writeShort(short value) throws IOException {
            this.out.putShort(value);
        }

        @Override
        public void writeInt(int value) throws IOException {
            this.out.putInt(value);
        }

        @Override
        public void writeLong(long value) throws IOException {
            this.out.putLong(value);
        }

        @Override
        public void writeFloat(float value) throws IOException {
            this.out.putFloat(value);
        }

        @Override
        public void writeDouble(double value) throws IOException {
            this.out.putDouble(value);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class OutputStreamSink
    extends AbstractSink {
        private long position = 0L;
        final OutputStream output;

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public void position(long position) throws IOException {
            throw new IllegalStateException("Sink does not implement position seeking");
        }

        @Override
        public void writeBytes(byte[] buffer, int offset, int length) throws IOException {
            this.output.write(buffer, offset, length);
            this.position += (long)length;
        }

        protected OutputStreamSink(OutputStream output, int bufferSize) {
            super(bufferSize);
            this.output = output;
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }

    static class SinkOutputStream
    extends OutputStream {
        private final Sink sink;

        @Override
        public void write(int b) throws IOException {
            this.sink.writeByte((byte)(b & 0xFF));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.sink.writeBytes(b, off, len);
        }

        SinkOutputStream(Sink sink) {
            this.sink = Preconditions.checkNotNull(sink);
        }
    }
}

