/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Reader;
import us.hebi.matlab.mat.format.MatOpaque;
import us.hebi.matlab.mat.format.McosObject;
import us.hebi.matlab.mat.format.McosReference;
import us.hebi.matlab.mat.format.McosRegistry;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;
import us.hebi.matlab.mat.util.Preconditions;

class McosFileWrapper
extends MatOpaque {
    private final ByteOrder order;
    int version = -1;
    String[] strings = null;
    int[] segmentIndices = null;
    List<ClassInfo> classInfo = null;
    List<ObjectInfo> objectInfo = null;
    List<Property[]> segment2Properties = null;
    List<Property[]> segment4Properties = null;
    McosRegistry mcosRegistry = null;

    McosFileWrapper(String objectType, String className, Array content, ByteOrder order) {
        super(objectType, className, content);
        if (!"MCOS".equals(objectType)) {
            throw new IllegalArgumentException("Expected MCOS object type. Found " + objectType);
        }
        if (!"FileWrapper__".equals(className)) {
            throw new IllegalArgumentException("Expected FileWrapper__ class. Found " + className);
        }
        this.order = order;
    }

    @Override
    public Cell getContent() {
        return (Cell)super.getContent();
    }

    List<McosObject> parseObjects(McosRegistry mcosRegistry) throws IOException {
        this.mcosRegistry = Preconditions.checkNotNull(mcosRegistry);
        Matrix mcos = (Matrix)this.getContent().get(0);
        if (mcos.getType() != MatlabType.UInt8) {
            throw Mat5Reader.readError("Unexpected MCOS data type. Expected: %s, Found: %s", new Object[]{MatlabType.UInt8, mcos.getType()});
        }
        ByteBuffer buffer = Mat5.exportBytes(mcos);
        buffer.order(this.order);
        this.version = buffer.getInt();
        if (this.version < 2 || this.version > 5) {
            throw Mat5Reader.readError("MAT file's MCOS data has an unknown version. Expected: 2 through 5, Found %d", this.version);
        }
        int numStrings = buffer.getInt();
        this.segmentIndices = new int[8];
        for (int i = 0; i < this.segmentIndices.length; ++i) {
            this.segmentIndices[i] = buffer.getInt();
        }
        if (this.segmentIndices[5] == buffer.limit()) {
            McosFileWrapper.checkUnknown(this.segmentIndices[6], 0L);
            McosFileWrapper.checkUnknown(this.segmentIndices[7], 0L);
        } else if (this.segmentIndices[7] != buffer.limit()) {
            throw Mat5Reader.readError("Unexpected end of segments. Expected: %d, Found: %s", buffer.limit(), Arrays.asList(new int[][]{this.segmentIndices}));
        }
        this.strings = McosFileWrapper.parseStrings(buffer, numStrings);
        if ((buffer.position() + 7 & 0xFFFFFFF8) != this.segmentIndices[0]) {
            throw new IllegalStateException("Data from the strings section was not all read!");
        }
        this.classInfo = this.parseSegment1(buffer);
        this.objectInfo = this.parseSegment3(buffer);
        this.segment2Properties = this.parseSegment2(buffer);
        this.segment4Properties = this.parseSegment4(buffer);
        return this.createObjects();
    }

    private List<McosObject> createObjects() {
        Cell sharedProperties = (Cell)this.getContent().get(this.getContent().getNumElements() - 1);
        ArrayList<McosObject> objects = new ArrayList<McosObject>(this.objectInfo.size());
        for (int i = 0; i < this.objectInfo.size(); ++i) {
            ObjectInfo objInfo = this.objectInfo.get(i);
            ClassInfo info = this.classInfo.get(objInfo.classId - 1);
            McosObject object = new McosObject(info.packageName, info.className);
            Struct shared = (Struct)sharedProperties.get(objInfo.classId);
            for (String name : shared.getFieldNames()) {
                object.set(name, (Array)shared.get(name));
            }
            if (objInfo.segment2PropertiesIndex > 0) {
                for (Property property : this.segment2Properties.get(objInfo.segment2PropertiesIndex - 1)) {
                    object.set(property.name, property.value);
                }
            }
            if (objInfo.segment4PropertiesIndex > 0) {
                for (Property property : this.segment4Properties.get(objInfo.segment4PropertiesIndex - 1)) {
                    object.set(property.name, property.value);
                }
            }
            objects.add(object);
        }
        return objects;
    }

    private static String[] parseStrings(ByteBuffer buffer, int numStrings) {
        String[] strings = new String[numStrings];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.setLength(0);
            char next = (char)buffer.get();
            while (next != '\u0000') {
                sb.append(next);
                next = (char)buffer.get();
            }
            strings[i] = sb.toString();
        }
        return strings;
    }

    private String getString(int index) {
        return index > 0 ? this.strings[index - 1] : "";
    }

    private List<ClassInfo> parseSegment1(ByteBuffer buffer) {
        buffer.position(this.segmentIndices[0]);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        ArrayList<ClassInfo> classNames = new ArrayList<ClassInfo>();
        while (buffer.position() < this.segmentIndices[1]) {
            String packageName = this.getString(buffer.getInt());
            String className = this.getString(buffer.getInt());
            McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
            classNames.add(new ClassInfo(packageName, className));
        }
        if (buffer.position() != this.segmentIndices[1]) {
            throw new IllegalStateException("Data from the class section was not all read!");
        }
        return classNames;
    }

    private List<Property[]> parseSegment2(ByteBuffer buffer) {
        return this.parseProperties(buffer, this.segmentIndices[1], this.segmentIndices[2]);
    }

    private List<Property[]> parseProperties(ByteBuffer buffer, int start, int end) {
        if (start == end) {
            return Collections.emptyList();
        }
        buffer.position(start);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        ArrayList<Property[]> perClassProperties = new ArrayList<Property[]>();
        while (buffer.position() < end) {
            int numProps = buffer.getInt();
            Property[] properties = new Property[numProps];
            for (int i = 0; i < numProps; ++i) {
                Array value;
                String name = this.getString(buffer.getInt());
                int flag = buffer.getInt();
                int heapIndex = buffer.getInt();
                switch (flag) {
                    case 0: {
                        value = Mat5.newString(this.getString(heapIndex));
                        break;
                    }
                    case 1: {
                        value = this.getContent().get(heapIndex + 2, 0);
                        break;
                    }
                    case 2: {
                        value = Mat5.newLogicalScalar(heapIndex != 0);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected flag value: " + flag);
                    }
                }
                if (McosReference.isMcosReference(value)) {
                    value = this.mcosRegistry.register(McosReference.parseMcosReference(value));
                }
                properties[i] = new Property(name, value);
            }
            perClassProperties.add(properties);
            if ((numProps * 3 + 1) % 2 == 0) continue;
            McosFileWrapper.checkUnknown(buffer.getInt(), 0L);
        }
        if (buffer.position() != end) {
            throw new IllegalStateException("Data from the class section was not all read!");
        }
        return perClassProperties;
    }

    private List<ObjectInfo> parseSegment3(ByteBuffer buffer) {
        buffer.position(this.segmentIndices[2]);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        McosFileWrapper.checkUnknown(buffer.getLong(), 0L);
        ArrayList<ObjectInfo> objectInfo = new ArrayList<ObjectInfo>();
        while (buffer.position() < this.segmentIndices[3]) {
            int classId = buffer.getInt();
            McosFileWrapper.checkUnknown(buffer.getInt(), 0L);
            McosFileWrapper.checkUnknown(buffer.getInt(), 0L);
            int segment2PropsIndex = buffer.getInt();
            int segment4PropsIndex = buffer.getInt();
            int supposedlyObjectId = buffer.getInt();
            objectInfo.add(new ObjectInfo(supposedlyObjectId, classId, segment2PropsIndex, segment4PropsIndex));
        }
        if (buffer.position() != this.segmentIndices[3]) {
            throw new IllegalStateException("Data from the class section was not all read!");
        }
        return objectInfo;
    }

    private List<Property[]> parseSegment4(ByteBuffer buffer) {
        return this.parseProperties(buffer, this.segmentIndices[3], this.segmentIndices[4]);
    }

    private List<Object> parseSegment5(ByteBuffer buffer) {
        if (this.segmentIndices[4] == this.segmentIndices[5]) {
            return Collections.emptyList();
        }
        byte[] bytes = new byte[this.segmentIndices[5] - this.segmentIndices[4]];
        buffer.position(this.segmentIndices[4]);
        buffer.get(bytes);
        System.out.println("\nSegment 5:\n" + Arrays.toString(bytes));
        throw new IllegalStateException("Segment 5 has data!");
    }

    private static void checkUnknown(long value, long expected) {
        if (value != expected) {
            throw new IllegalStateException("MAT file's MCOS data has different byte values for unknown fields!  Aborting!");
        }
    }

    private static class ClassInfo {
        final String packageName;
        final String className;

        ClassInfo(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }
    }

    private static class ObjectInfo {
        final int objectId;
        final int classId;
        final int segment2PropertiesIndex;
        final int segment4PropertiesIndex;

        ObjectInfo(int objectId, int classId, int segment2PropertiesIndex, int segment4PropertiesIndex) {
            this.objectId = objectId;
            this.classId = classId;
            this.segment2PropertiesIndex = segment2PropertiesIndex;
            this.segment4PropertiesIndex = segment4PropertiesIndex;
        }
    }

    private static class Property {
        final String name;
        final Array value;

        Property(String name, Array value) {
            this.name = name;
            this.value = value;
        }
    }
}

