/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Stack;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Mat5ArrayFlags;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.format.Mat5Tag;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;
import us.hebi.matlab.mat.util.IndentingAppendable;
import us.hebi.matlab.mat.util.Preconditions;

class Mat5TagStreamer {
    private boolean reduced = false;
    private TagConsumer consumer;
    private final Source source;
    private boolean nextIsSubsys = false;

    Mat5TagStreamer(Source source) {
        this.source = Preconditions.checkNotNull(source);
    }

    Mat5TagStreamer setReducedHeader(boolean reduced) {
        this.reduced = reduced;
        return this;
    }

    void printTags() throws IOException {
        this.printTags(System.out);
    }

    void printTags(Appendable appendable) throws IOException {
        this.forEach(new TagPrinter(appendable));
    }

    void forEach(TagConsumer consumer) throws IOException {
        this.consumer = consumer;
        this.source.order(ByteOrder.nativeOrder());
        Mat5File header = this.reduced ? Mat5File.readReducedFileHeader(this.source) : Mat5File.readFileHeader(this.source);
        this.source.order(header.getByteOrder());
        consumer.onFileStart(header);
        int numEntries = 0;
        boolean eof = false;
        while (!eof) {
            long position = this.source.getPosition();
            this.nextIsSubsys = this.reduced ? ++numEntries == 2 : position == header.getSubsysOffset();
            try {
                this.handleTag(Mat5Tag.readTag(this.source), this.source, position);
            }
            catch (EOFException ex) {
                consumer.onFileEnd();
                eof = true;
            }
        }
    }

    private void handleTag(Mat5Tag tag, Source source, long position) throws IOException {
        switch (tag.getType()) {
            case Matrix: {
                this.handleMatrixTag(source, position, tag.getNumBytes());
                break;
            }
            case Compressed: {
                this.handleCompressedTag(source, position, tag.getNumBytes());
                break;
            }
            default: {
                if (this.nextIsSubsys && tag.getType() == Mat5Type.UInt8) {
                    if (this.consumer.onSubsystemBegin(position, tag.getNumBytes())) {
                        Source subsys = Sources.wrap(tag.readAsBytes());
                        new Mat5TagStreamer(subsys).setReducedHeader(true).forEach(this.consumer);
                        this.consumer.onSubsystemEnd();
                        this.nextIsSubsys = false;
                        break;
                    }
                    this.nextIsSubsys = false;
                    this.handleTag(tag, source, position);
                    break;
                }
                if (this.consumer.onData(position, tag)) break;
                source.skip(tag.getNumBytes() + tag.getPadding());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompressedTag(Source source, long position, int numBytes) throws IOException {
        this.consumer.onCompressedBegin(position, numBytes);
        Source inflated = source.readInflated(numBytes, 2048);
        try {
            this.handleTag(Mat5Tag.readTag(inflated), inflated, 0L);
        }
        finally {
            inflated.close();
        }
        this.consumer.onCompressedEnd();
    }

    private void handleMatrixTag(Source source, long position, int numBytes) throws IOException {
        this.consumer.onMatrixBegin(position, numBytes);
        long end = source.getPosition() + (long)numBytes;
        long currentPos = source.getPosition();
        while (currentPos < end) {
            this.handleTag(Mat5Tag.readTag(source), source, currentPos);
            currentPos = source.getPosition();
        }
        this.consumer.onMatrixEnd();
    }

    static interface TagConsumer {
        public void onFileStart(Mat5File var1) throws IOException;

        public void onCompressedBegin(long var1, int var3) throws IOException;

        public void onCompressedEnd() throws IOException;

        public void onMatrixBegin(long var1, int var3) throws IOException;

        public void onMatrixEnd() throws IOException;

        public void onFileEnd() throws IOException;

        public boolean onSubsystemBegin(long var1, int var3) throws IOException;

        public void onSubsystemEnd() throws IOException;

        public boolean onData(long var1, Mat5Tag var3) throws IOException;
    }

    static class TagPrinter
    implements TagConsumer {
        private boolean nextIsArrayFlags = false;
        private int count = 0;
        Stack<Integer> prevCount = new Stack();
        private final IndentingAppendable out;

        public TagPrinter(Appendable out) {
            this.out = new IndentingAppendable(out);
        }

        @Override
        public void onFileStart(Mat5File fileHeader) throws IOException {
            this.out.append(String.valueOf(fileHeader));
        }

        @Override
        public void onCompressedBegin(long position, int numBytes) throws IOException {
            this.out.append("\n").append("[").append(Integer.toString(this.count)).append("] ").append(Mat5Type.Compressed.name()).append(" (").append(String.valueOf(numBytes)).append(" bytes,").append(" position = ").append(Long.toString(position)).append(")");
            this.indent();
        }

        @Override
        public void onCompressedEnd() {
            this.unindent();
        }

        @Override
        public void onMatrixBegin(long position, int numBytes) throws IOException {
            this.out.append("\n").append("[").append(Integer.toString(this.count)).append("] ").append(Mat5Type.Matrix.name()).append(" (").append(String.valueOf(numBytes)).append(" bytes,").append(" position = ").append(Long.toString(position)).append(")");
            this.indent();
            this.nextIsArrayFlags = true;
        }

        @Override
        public void onMatrixEnd() {
            this.unindent();
            this.nextIsArrayFlags = false;
        }

        @Override
        public boolean onSubsystemBegin(long position, int numBytes) throws IOException {
            this.out.append("\n--- Begin Subsystem ---").append("\n");
            this.indent();
            return true;
        }

        @Override
        public void onSubsystemEnd() throws IOException {
            this.unindent();
        }

        @Override
        public void onFileEnd() throws IOException {
            this.out.append("\n--- End of File ---");
        }

        private void indent() {
            this.out.indent();
            this.prevCount.push(this.count);
            this.count = 0;
        }

        private void unindent() {
            this.out.unindent();
            this.count = this.prevCount.pop() + 1;
        }

        @Override
        public boolean onData(long position, Mat5Tag tag) throws IOException {
            this.out.append("\n").append("[").append(Integer.toString(this.count)).append("] ").append(tag.getType().name()).append("[").append(Integer.toString(tag.getNumElements())).append("] = ");
            switch (tag.getType()) {
                case Int16: 
                case UInt16: {
                    this.out.append(Arrays.toString(tag.readAsShorts()));
                    break;
                }
                case Int32: 
                case UInt32: {
                    int[] data = tag.readAsInts();
                    this.out.append(Arrays.toString(data));
                    if (!this.nextIsArrayFlags || data.length != 2) break;
                    this.out.append(" // ").append(Mat5ArrayFlags.getType(data).name());
                    break;
                }
                case Int64: 
                case UInt64: {
                    this.out.append(Arrays.toString(tag.readAsLongs()));
                    break;
                }
                case Single: {
                    this.out.append(Arrays.toString(tag.readAsFloats()));
                    break;
                }
                case Double: {
                    this.out.append(Arrays.toString(tag.readAsDoubles()));
                    break;
                }
                case Int8: {
                    byte[] bytes = tag.readAsBytes();
                    this.out.append("['").append(CharEncoding.parseAsciiString(bytes)).append("']");
                    break;
                }
                default: {
                    this.out.append(Arrays.toString(tag.readAsBytes()));
                }
            }
            this.nextIsArrayFlags = false;
            ++this.count;
            return true;
        }
    }
}

