/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.utils;

import B.A.A.A.A;
import B.A.A.A.D;
import B.A.A.A.F;
import B.A.A.A.G;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CommonUtils {
    private static long THREADS_BEGIN_N_1D_FFT_2THREADS = 8192L;
    private static long THREADS_BEGIN_N_1D_FFT_4THREADS = 65536L;
    private static long THREADS_BEGIN_N_2D = 65536L;
    private static long THREADS_BEGIN_N_3D = 65536L;
    private static boolean useLargeArrays = false;

    public static long getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static long getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static boolean isUseLargeArrays() {
        return useLargeArrays;
    }

    public static int nextPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n + 1;
    }

    public static long nextPow2(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((l & l - 1L) == 0L) {
            return l;
        }
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return l + 1L;
    }

    public static boolean isPowerOf2(long l) {
        if (l <= 0L) {
            return false;
        }
        return (l & l - 1L) == 0L;
    }

    public static long getReminder(long l, int[] nArray) {
        long l2 = l;
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be positive integer");
        }
        for (int i = 0; i < nArray.length && l2 != 1L; ++i) {
            long l3 = nArray[i];
            while (l2 % l3 == 0L) {
                l2 /= l3;
            }
        }
        return l2;
    }

    public static void makeipt(int n, int[] nArray) {
        nArray[2] = 0;
        nArray[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                nArray[n2 + j] = n5 = nArray[j] << 2;
                nArray[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    public static void makeipt(long l, G g) {
        g.A(2L, 0L);
        g.A(3L, 16L);
        long l2 = 2L;
        for (long i = l; i > 32L; i >>= 2) {
            long l3 = l2 << 1;
            long l4 = l3 << 3;
            for (long j = l2; j < l3; ++j) {
                long l5 = g.D(j) << 2;
                g.A(l2 + j, l5);
                g.A(l3 + j, l5 + l4);
            }
            l2 = l3;
        }
    }

    public static void makewt(int n, int[] nArray, double[] dArray) {
        nArray[0] = n;
        nArray[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            double d2 = d * 2.0;
            double d3 = FastMath.cos(d * (double)n3);
            dArray[0] = 1.0;
            dArray[1] = d3;
            if (n3 == 4) {
                dArray[2] = FastMath.cos(d2);
                dArray[3] = FastMath.sin(d2);
            } else if (n3 > 4) {
                CommonUtils.makeipt(n, nArray);
                dArray[2] = 0.5 / FastMath.cos(d2);
                dArray[3] = 0.5 / FastMath.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    double d4 = d * (double)n2;
                    double d5 = 3.0 * d4;
                    dArray[n2] = FastMath.cos(d4);
                    dArray[n2 + 1] = FastMath.sin(d4);
                    dArray[n2 + 2] = FastMath.cos(d5);
                    dArray[n2 + 3] = -FastMath.sin(d5);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d6;
                double d7;
                int n5 = n4 + n3;
                dArray[n5] = 1.0;
                dArray[n5 + 1] = d3;
                if ((n3 >>= 1) == 4) {
                    d7 = dArray[n4 + 4];
                    d6 = dArray[n4 + 5];
                    dArray[n5 + 2] = d7;
                    dArray[n5 + 3] = d6;
                } else if (n3 > 4) {
                    d7 = dArray[n4 + 4];
                    double d8 = dArray[n4 + 6];
                    dArray[n5 + 2] = 0.5 / d7;
                    dArray[n5 + 3] = 0.5 / d8;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d7 = dArray[n6];
                        d6 = dArray[n6 + 1];
                        d8 = dArray[n6 + 2];
                        double d9 = dArray[n6 + 3];
                        dArray[n7] = d7;
                        dArray[n7 + 1] = d6;
                        dArray[n7 + 2] = d8;
                        dArray[n7 + 3] = d9;
                    }
                }
                n4 = n5;
            }
        }
    }

    public static void makewt(long l, G g, A a) {
        g.A(0L, l);
        g.A(1L, 1L);
        if (l > 2L) {
            long l2;
            long l3 = l >> 1;
            double d = 0.7853981633974483 / (double)l3;
            double d2 = d * 2.0;
            double d3 = FastMath.cos(d * (double)l3);
            a.B(0L, 1.0);
            a.B(1L, d3);
            if (l3 == 4L) {
                a.B(2L, FastMath.cos(d2));
                a.B(3L, FastMath.sin(d2));
            } else if (l3 > 4L) {
                CommonUtils.makeipt(l, g);
                a.B(2L, 0.5 / FastMath.cos(d2));
                a.B(3L, 0.5 / FastMath.cos(d * 6.0));
                for (l2 = 4L; l2 < l3; l2 += 4L) {
                    double d4 = d * (double)l2;
                    double d5 = 3.0 * d4;
                    a.B(l2, FastMath.cos(d4));
                    a.B(l2 + 1L, FastMath.sin(d4));
                    a.B(l2 + 2L, FastMath.cos(d5));
                    a.B(l2 + 3L, -FastMath.sin(d5));
                }
            }
            long l4 = 0L;
            while (l3 > 2L) {
                double d6;
                double d7;
                long l5 = l4 + l3;
                a.B(l5, 1.0);
                a.B(l5 + 1L, d3);
                if ((l3 >>= 1) == 4L) {
                    d7 = a.E(l4 + 4L);
                    d6 = a.E(l4 + 5L);
                    a.B(l5 + 2L, d7);
                    a.B(l5 + 3L, d6);
                } else if (l3 > 4L) {
                    d7 = a.E(l4 + 4L);
                    double d8 = a.E(l4 + 6L);
                    a.B(l5 + 2L, 0.5 / d7);
                    a.B(l5 + 3L, 0.5 / d8);
                    for (l2 = 4L; l2 < l3; l2 += 4L) {
                        long l6 = l4 + 2L * l2;
                        long l7 = l5 + l2;
                        d7 = a.E(l6);
                        d6 = a.E(l6 + 1L);
                        d8 = a.E(l6 + 2L);
                        double d9 = a.E(l6 + 3L);
                        a.B(l7, d7);
                        a.B(l7 + 1L, d6);
                        a.B(l7 + 2L, d8);
                        a.B(l7 + 3L, d9);
                    }
                }
                l4 = l5;
            }
        }
    }

    public static void makect(int n, double[] dArray, int n2, int[] nArray) {
        nArray[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = 0.7853981633974483 / (double)n3;
            dArray[n2] = FastMath.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                double d2 = d * (double)i;
                dArray[n2 + i] = 0.5 * FastMath.cos(d2);
                dArray[n2 + n - i] = 0.5 * FastMath.sin(d2);
            }
        }
    }

    public static void makect(long l, A a, long l2, G g) {
        g.A(1L, l);
        if (l > 1L) {
            long l3 = l >> 1;
            double d = 0.7853981633974483 / (double)l3;
            a.B(l2, FastMath.cos(d * (double)l3));
            a.B(l2 + l3, 0.5 * a.E(l2));
            for (long i = 1L; i < l3; ++i) {
                double d2 = d * (double)i;
                a.B(l2 + i, 0.5 * FastMath.cos(d2));
                a.B(l2 + l - i, 0.5 * FastMath.sin(d2));
            }
        }
    }

    public static void makect(int n, float[] fArray, int n2, int[] nArray) {
        nArray[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            float f = 0.7853982f / (float)n3;
            fArray[n2] = (float)FastMath.cos(f * (float)n3);
            fArray[n2 + n3] = 0.5f * fArray[n2];
            for (int i = 1; i < n3; ++i) {
                float f2 = f * (float)i;
                fArray[n2 + i] = 0.5f * (float)FastMath.cos(f2);
                fArray[n2 + n - i] = 0.5f * (float)FastMath.sin(f2);
            }
        }
    }

    public static void makect(long l, D d, long l2, G g) {
        g.A(1L, l);
        if (l > 1L) {
            long l3 = l >> 1;
            float f = 0.7853982f / (float)l3;
            d.A(l2, (float)FastMath.cos(f * (float)l3));
            d.A(l2 + l3, 0.5f * d.C(l2));
            for (long i = 1L; i < l3; ++i) {
                float f2 = f * (float)i;
                d.A(l2 + i, 0.5f * (float)FastMath.cos(f2));
                d.A(l2 + l - i, 0.5f * (float)FastMath.sin(f2));
            }
        }
    }

    public static void makewt(int n, int[] nArray, float[] fArray) {
        nArray[0] = n;
        nArray[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            float f = 0.7853982f / (float)n3;
            float f2 = f * 2.0f;
            float f3 = (float)FastMath.cos(f * (float)n3);
            fArray[0] = 1.0f;
            fArray[1] = f3;
            if (n3 == 4) {
                fArray[2] = (float)FastMath.cos(f2);
                fArray[3] = (float)FastMath.sin(f2);
            } else if (n3 > 4) {
                CommonUtils.makeipt(n, nArray);
                fArray[2] = 0.5f / (float)FastMath.cos(f2);
                fArray[3] = 0.5f / (float)FastMath.cos(f * 6.0f);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    float f4 = f * (float)n2;
                    float f5 = 3.0f * f4;
                    fArray[n2] = (float)FastMath.cos(f4);
                    fArray[n2 + 1] = (float)FastMath.sin(f4);
                    fArray[n2 + 2] = (float)FastMath.cos(f5);
                    fArray[n2 + 3] = -((float)FastMath.sin(f5));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f6;
                float f7;
                int n5 = n4 + n3;
                fArray[n5] = 1.0f;
                fArray[n5 + 1] = f3;
                if ((n3 >>= 1) == 4) {
                    f7 = fArray[n4 + 4];
                    f6 = fArray[n4 + 5];
                    fArray[n5 + 2] = f7;
                    fArray[n5 + 3] = f6;
                } else if (n3 > 4) {
                    f7 = fArray[n4 + 4];
                    float f8 = fArray[n4 + 6];
                    fArray[n5 + 2] = 0.5f / f7;
                    fArray[n5 + 3] = 0.5f / f8;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f7 = fArray[n6];
                        f6 = fArray[n6 + 1];
                        f8 = fArray[n6 + 2];
                        float f9 = fArray[n6 + 3];
                        fArray[n7] = f7;
                        fArray[n7 + 1] = f6;
                        fArray[n7 + 2] = f8;
                        fArray[n7 + 3] = f9;
                    }
                }
                n4 = n5;
            }
        }
    }

    public static void makewt(long l, G g, D d) {
        g.A(0L, l);
        g.A(1L, 1L);
        if (l > 2L) {
            long l2;
            long l3 = l >> 1;
            float f = 0.7853982f / (float)l3;
            float f2 = f * 2.0f;
            float f3 = (float)FastMath.cos(f * (float)l3);
            d.A(0L, 1.0f);
            d.A(1L, f3);
            if (l3 == 4L) {
                d.A(2L, (float)FastMath.cos(f2));
                d.A(3L, (float)FastMath.sin(f2));
            } else if (l3 > 4L) {
                CommonUtils.makeipt(l, g);
                d.A(2L, 0.5f / (float)FastMath.cos(f2));
                d.A(3L, 0.5f / (float)FastMath.cos(f * 6.0f));
                for (l2 = 4L; l2 < l3; l2 += 4L) {
                    float f4 = f * (float)l2;
                    float f5 = 3.0f * f4;
                    d.A(l2, (float)FastMath.cos(f4));
                    d.A(l2 + 1L, (float)FastMath.sin(f4));
                    d.A(l2 + 2L, (float)FastMath.cos(f5));
                    d.A(l2 + 3L, -((float)FastMath.sin(f5)));
                }
            }
            long l4 = 0L;
            while (l3 > 2L) {
                float f6;
                float f7;
                long l5 = l4 + l3;
                d.A(l5, 1.0f);
                d.A(l5 + 1L, f3);
                if ((l3 >>= 1) == 4L) {
                    f7 = d.C(l4 + 4L);
                    f6 = d.C(l4 + 5L);
                    d.A(l5 + 2L, f7);
                    d.A(l5 + 3L, f6);
                } else if (l3 > 4L) {
                    f7 = d.C(l4 + 4L);
                    float f8 = d.C(l4 + 6L);
                    d.A(l5 + 2L, 0.5f / f7);
                    d.A(l5 + 3L, 0.5f / f8);
                    for (l2 = 4L; l2 < l3; l2 += 4L) {
                        long l6 = l4 + 2L * l2;
                        long l7 = l5 + l2;
                        f7 = d.C(l6);
                        f6 = d.C(l6 + 1L);
                        f8 = d.C(l6 + 2L);
                        float f9 = d.C(l6 + 3L);
                        d.A(l7, f7);
                        d.A(l7 + 1L, f6);
                        d.A(l7 + 2L, f8);
                        d.A(l7 + 3L, f9);
                    }
                }
                l4 = l5;
            }
        }
    }

    public static void cftfsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                CommonUtils.cftf1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (F.A() > 1 && (long)n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    CommonUtils.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    CommonUtils.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    CommonUtils.cftfx41(n, dArray, n2, n3, dArray2);
                }
                CommonUtils.bitrv2(n, nArray, dArray, n2);
            } else if (n == 32) {
                CommonUtils.cftf161(dArray, n2, dArray2, n3 - 8);
                CommonUtils.bitrv216(dArray, n2);
            } else {
                CommonUtils.cftf081(dArray, n2, dArray2, 0);
                CommonUtils.bitrv208(dArray, n2);
            }
        } else if (n == 8) {
            CommonUtils.cftf040(dArray, n2);
        } else if (n == 4) {
            CommonUtils.cftxb020(dArray, n2);
        }
    }

    public static void cftfsub(long l, A a, long l2, G g, long l3, A a2) {
        if (l > 8L) {
            if (l > 32L) {
                CommonUtils.cftf1st(l, a, l2, a2, l3 - (l >> 2));
                if (F.A() > 1 && l >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(l, a, l2, l3, a2);
                } else if (l > 512L) {
                    CommonUtils.cftrec4(l, a, l2, l3, a2);
                } else if (l > 128L) {
                    CommonUtils.cftleaf(l, 1L, a, l2, l3, a2);
                } else {
                    CommonUtils.cftfx41(l, a, l2, l3, a2);
                }
                CommonUtils.bitrv2l(l, g, a, l2);
            } else if (l == 32L) {
                CommonUtils.cftf161(a, l2, a2, l3 - 8L);
                CommonUtils.bitrv216(a, l2);
            } else {
                CommonUtils.cftf081(a, l2, a2, 0L);
                CommonUtils.bitrv208(a, l2);
            }
        } else if (l == 8L) {
            CommonUtils.cftf040(a, l2);
        } else if (l == 4L) {
            CommonUtils.cftxb020(a, l2);
        }
    }

    public static void cftbsub(int n, double[] dArray, int n2, int[] nArray, int n3, double[] dArray2) {
        if (n > 8) {
            if (n > 32) {
                CommonUtils.cftb1st(n, dArray, n2, dArray2, n3 - (n >> 2));
                if (F.A() > 1 && (long)n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n, dArray, n2, n3, dArray2);
                } else if (n > 512) {
                    CommonUtils.cftrec4(n, dArray, n2, n3, dArray2);
                } else if (n > 128) {
                    CommonUtils.cftleaf(n, 1, dArray, n2, n3, dArray2);
                } else {
                    CommonUtils.cftfx41(n, dArray, n2, n3, dArray2);
                }
                CommonUtils.bitrv2conj(n, nArray, dArray, n2);
            } else if (n == 32) {
                CommonUtils.cftf161(dArray, n2, dArray2, n3 - 8);
                CommonUtils.bitrv216neg(dArray, n2);
            } else {
                CommonUtils.cftf081(dArray, n2, dArray2, 0);
                CommonUtils.bitrv208neg(dArray, n2);
            }
        } else if (n == 8) {
            CommonUtils.cftb040(dArray, n2);
        } else if (n == 4) {
            CommonUtils.cftxb020(dArray, n2);
        }
    }

    public static void cftbsub(long l, A a, long l2, G g, long l3, A a2) {
        if (l > 8L) {
            if (l > 32L) {
                CommonUtils.cftb1st(l, a, l2, a2, l3 - (l >> 2));
                if (F.A() > 1 && l >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(l, a, l2, l3, a2);
                } else if (l > 512L) {
                    CommonUtils.cftrec4(l, a, l2, l3, a2);
                } else if (l > 128L) {
                    CommonUtils.cftleaf(l, 1L, a, l2, l3, a2);
                } else {
                    CommonUtils.cftfx41(l, a, l2, l3, a2);
                }
                CommonUtils.bitrv2conj(l, g, a, l2);
            } else if (l == 32L) {
                CommonUtils.cftf161(a, l2, a2, l3 - 8L);
                CommonUtils.bitrv216neg(a, l2);
            } else {
                CommonUtils.cftf081(a, l2, a2, 0L);
                CommonUtils.bitrv208neg(a, l2);
            }
        } else if (l == 8L) {
            CommonUtils.cftb040(a, l2);
        } else if (l == 4L) {
            CommonUtils.cftxb020(a, l2);
        }
    }

    public static void bitrv2(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                d4 = dArray[n8];
                d3 = dArray[n8 + 1];
                d2 = dArray[n7];
                d = dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                d7 = dArray[n13];
                d6 = dArray[n13 + 1];
                d5 = dArray[n12];
                d = dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                d7 = dArray[n13];
                d6 = dArray[n13 + 1];
                d5 = dArray[n12];
                d = dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
            }
        }
    }

    public static void bitrv2l(long l, G g, A a, long l2) {
        long l3;
        long l4 = 1L;
        for (l3 = l >> 2; l3 > 8L; l3 >>= 2) {
            l4 <<= 1;
        }
        long l5 = l >> 1;
        long l6 = 4L * l4;
        if (l3 == 8L) {
            for (long i = 0L; i < l4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l10 = 4L * j + 2L * g.D(l4 + i);
                    l9 = l11 + 2L * g.D(l4 + j);
                    l8 = l2 + l10;
                    l7 = l2 + l9;
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l5);
                    l7 = l2 + (l9 += 2L);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += 2L);
                    l7 = l2 + (l9 += l5);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l5);
                    l7 = l2 + (l9 -= 2L);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                }
                l9 = l11 + 2L * g.D(l4 + i);
                l10 = l9 + 2L;
                l8 = l2 + l10;
                l7 = l2 + (l9 += l5);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 += 2L * l6);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 -= l6);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 -= 2L);
                l7 = l2 + (l9 -= l5);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 += l5 + 2L);
                l7 = l2 + (l9 += l5 + 2L);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 -= l5 - l6);
                l7 = l2 + (l9 += 2L * l6 - 2L);
                d4 = a.E(l8);
                d3 = a.E(l8 + 1L);
                d2 = a.E(l7);
                d = a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
            }
        } else {
            for (long i = 0L; i < l4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                long l12;
                long l13;
                long l14;
                long l15;
                long l16 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l15 = 4L * j + g.D(l4 + i);
                    l14 = l16 + g.D(l4 + j);
                    l13 = l2 + l15;
                    l12 = l2 + l14;
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l5);
                    l12 = l2 + (l14 += 2L);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += 2L);
                    l12 = l2 + (l14 += l5);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l5);
                    l12 = l2 + (l14 -= 2L);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    d7 = a.E(l13);
                    d6 = a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                }
                l14 = l16 + g.D(l4 + i);
                l15 = l14 + 2L;
                l13 = l2 + l15;
                l12 = l2 + (l14 += l5);
                d7 = a.E(l13);
                d6 = a.E(l13 + 1L);
                d5 = a.E(l12);
                d = a.E(l12 + 1L);
                a.B(l13, d5);
                a.B(l13 + 1L, d);
                a.B(l12, d7);
                a.B(l12 + 1L, d6);
                l13 = l2 + (l15 += l6);
                l12 = l2 + (l14 += l6);
                d7 = a.E(l13);
                d6 = a.E(l13 + 1L);
                d5 = a.E(l12);
                d = a.E(l12 + 1L);
                a.B(l13, d5);
                a.B(l13 + 1L, d);
                a.B(l12, d7);
                a.B(l12 + 1L, d6);
            }
        }
    }

    public static void bitrv2conj(int n, int[] nArray, double[] dArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    d4 = dArray[n8];
                    d3 = -dArray[n8 + 1];
                    d2 = dArray[n7];
                    d = -dArray[n7 + 1];
                    dArray[n8] = d2;
                    dArray[n8 + 1] = d;
                    dArray[n7] = d4;
                    dArray[n7 + 1] = d3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                dArray[n8 - 1] = -dArray[n8 - 1];
                d4 = dArray[n8];
                d3 = -dArray[n8 + 1];
                d2 = dArray[n7];
                d = -dArray[n7 + 1];
                dArray[n8] = d2;
                dArray[n8 + 1] = d;
                dArray[n7] = d4;
                dArray[n7 + 1] = d3;
                dArray[n7 + 3] = -dArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                double d;
                double d5;
                double d6;
                double d7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    d7 = dArray[n13];
                    d6 = -dArray[n13 + 1];
                    d5 = dArray[n12];
                    d = -dArray[n12 + 1];
                    dArray[n13] = d5;
                    dArray[n13 + 1] = d;
                    dArray[n12] = d7;
                    dArray[n12 + 1] = d6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                dArray[n13 - 1] = -dArray[n13 - 1];
                d7 = dArray[n13];
                d6 = -dArray[n13 + 1];
                d5 = dArray[n12];
                d = -dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                dArray[n12 + 3] = -dArray[n12 + 3];
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                dArray[n13 - 1] = -dArray[n13 - 1];
                d7 = dArray[n13];
                d6 = -dArray[n13 + 1];
                d5 = dArray[n12];
                d = -dArray[n12 + 1];
                dArray[n13] = d5;
                dArray[n13 + 1] = d;
                dArray[n12] = d7;
                dArray[n12 + 1] = d6;
                dArray[n12 + 3] = -dArray[n12 + 3];
            }
        }
    }

    public static void bitrv2conj(long l, G g, A a, long l2) {
        long l3;
        long l4 = 1L;
        for (l3 = l >> 2; l3 > 8L; l3 >>= 2) {
            l4 <<= 1;
        }
        long l5 = l >> 1;
        long l6 = 4L * l4;
        if (l3 == 8L) {
            for (long i = 0L; i < l4; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l10 = 4L * j + 2L * g.D(l4 + i);
                    l9 = l11 + 2L * g.D(l4 + j);
                    l8 = l2 + l10;
                    l7 = l2 + l9;
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l5);
                    l7 = l2 + (l9 += 2L);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += 2L);
                    l7 = l2 + (l9 += l5);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l5);
                    l7 = l2 + (l9 -= 2L);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    d4 = a.E(l8);
                    d3 = -a.E(l8 + 1L);
                    d2 = a.E(l7);
                    d = -a.E(l7 + 1L);
                    a.B(l8, d2);
                    a.B(l8 + 1L, d);
                    a.B(l7, d4);
                    a.B(l7 + 1L, d3);
                }
                l9 = l11 + 2L * g.D(l4 + i);
                l10 = l9 + 2L;
                l8 = l2 + l10;
                l7 = l2 + (l9 += l5);
                a.B(l8 - 1L, -a.E(l8 - 1L));
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                a.B(l7 + 3L, -a.E(l7 + 3L));
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 += 2L * l6);
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 -= l6);
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 -= 2L);
                l7 = l2 + (l9 -= l5);
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 += l5 + 2L);
                l7 = l2 + (l9 += l5 + 2L);
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                l8 = l2 + (l10 -= l5 - l6);
                l7 = l2 + (l9 += 2L * l6 - 2L);
                a.B(l8 - 1L, -a.E(l8 - 1L));
                d4 = a.E(l8);
                d3 = -a.E(l8 + 1L);
                d2 = a.E(l7);
                d = -a.E(l7 + 1L);
                a.B(l8, d2);
                a.B(l8 + 1L, d);
                a.B(l7, d4);
                a.B(l7 + 1L, d3);
                a.B(l7 + 3L, -a.E(l7 + 3L));
            }
        } else {
            int n = 0;
            while ((long)n < l4) {
                double d;
                double d5;
                double d6;
                double d7;
                long l12;
                long l13;
                long l14;
                long l15;
                long l16 = 4 * n;
                for (int i = 0; i < n; ++i) {
                    l15 = (long)(4 * i) + g.D(l4 + (long)n);
                    l14 = l16 + g.D(l4 + (long)i);
                    l13 = l2 + l15;
                    l12 = l2 + l14;
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l5);
                    l12 = l2 + (l14 += 2L);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += 2L);
                    l12 = l2 + (l14 += l5);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l5);
                    l12 = l2 + (l14 -= 2L);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    d7 = a.E(l13);
                    d6 = -a.E(l13 + 1L);
                    d5 = a.E(l12);
                    d = -a.E(l12 + 1L);
                    a.B(l13, d5);
                    a.B(l13 + 1L, d);
                    a.B(l12, d7);
                    a.B(l12 + 1L, d6);
                }
                l14 = l16 + g.D(l4 + (long)n);
                l15 = l14 + 2L;
                l13 = l2 + l15;
                l12 = l2 + (l14 += l5);
                a.B(l13 - 1L, -a.E(l13 - 1L));
                d7 = a.E(l13);
                d6 = -a.E(l13 + 1L);
                d5 = a.E(l12);
                d = -a.E(l12 + 1L);
                a.B(l13, d5);
                a.B(l13 + 1L, d);
                a.B(l12, d7);
                a.B(l12 + 1L, d6);
                a.B(l12 + 3L, -a.E(l12 + 3L));
                l13 = l2 + (l15 += l6);
                l12 = l2 + (l14 += l6);
                a.B(l13 - 1L, -a.E(l13 - 1L));
                d7 = a.E(l13);
                d6 = -a.E(l13 + 1L);
                d5 = a.E(l12);
                d = -a.E(l12 + 1L);
                a.B(l13, d5);
                a.B(l13 + 1L, d);
                a.B(l12, d7);
                a.B(l12 + 1L, d6);
                a.B(l12 + 3L, -a.E(l12 + 3L));
                ++n;
            }
        }
    }

    public static void bitrv216(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 14];
        double d12 = dArray[n + 15];
        double d13 = dArray[n + 16];
        double d14 = dArray[n + 17];
        double d15 = dArray[n + 20];
        double d16 = dArray[n + 21];
        double d17 = dArray[n + 22];
        double d18 = dArray[n + 23];
        double d19 = dArray[n + 24];
        double d20 = dArray[n + 25];
        double d21 = dArray[n + 26];
        double d22 = dArray[n + 27];
        double d23 = dArray[n + 28];
        double d24 = dArray[n + 29];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d7;
        dArray[n + 5] = d8;
        dArray[n + 6] = d19;
        dArray[n + 7] = d20;
        dArray[n + 8] = d3;
        dArray[n + 9] = d4;
        dArray[n + 10] = d15;
        dArray[n + 11] = d16;
        dArray[n + 14] = d23;
        dArray[n + 15] = d24;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 20] = d9;
        dArray[n + 21] = d10;
        dArray[n + 22] = d21;
        dArray[n + 23] = d22;
        dArray[n + 24] = d5;
        dArray[n + 25] = d6;
        dArray[n + 26] = d17;
        dArray[n + 27] = d18;
        dArray[n + 28] = d11;
        dArray[n + 29] = d12;
    }

    public static void bitrv216(A a, long l) {
        double d = a.E(l + 2L);
        double d2 = a.E(l + 3L);
        double d3 = a.E(l + 4L);
        double d4 = a.E(l + 5L);
        double d5 = a.E(l + 6L);
        double d6 = a.E(l + 7L);
        double d7 = a.E(l + 8L);
        double d8 = a.E(l + 9L);
        double d9 = a.E(l + 10L);
        double d10 = a.E(l + 11L);
        double d11 = a.E(l + 14L);
        double d12 = a.E(l + 15L);
        double d13 = a.E(l + 16L);
        double d14 = a.E(l + 17L);
        double d15 = a.E(l + 20L);
        double d16 = a.E(l + 21L);
        double d17 = a.E(l + 22L);
        double d18 = a.E(l + 23L);
        double d19 = a.E(l + 24L);
        double d20 = a.E(l + 25L);
        double d21 = a.E(l + 26L);
        double d22 = a.E(l + 27L);
        double d23 = a.E(l + 28L);
        double d24 = a.E(l + 29L);
        a.B(l + 2L, d13);
        a.B(l + 3L, d14);
        a.B(l + 4L, d7);
        a.B(l + 5L, d8);
        a.B(l + 6L, d19);
        a.B(l + 7L, d20);
        a.B(l + 8L, d3);
        a.B(l + 9L, d4);
        a.B(l + 10L, d15);
        a.B(l + 11L, d16);
        a.B(l + 14L, d23);
        a.B(l + 15L, d24);
        a.B(l + 16L, d);
        a.B(l + 17L, d2);
        a.B(l + 20L, d9);
        a.B(l + 21L, d10);
        a.B(l + 22L, d21);
        a.B(l + 23L, d22);
        a.B(l + 24L, d5);
        a.B(l + 25L, d6);
        a.B(l + 26L, d17);
        a.B(l + 27L, d18);
        a.B(l + 28L, d11);
        a.B(l + 29L, d12);
    }

    public static void bitrv216neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        double d15 = dArray[n + 16];
        double d16 = dArray[n + 17];
        double d17 = dArray[n + 18];
        double d18 = dArray[n + 19];
        double d19 = dArray[n + 20];
        double d20 = dArray[n + 21];
        double d21 = dArray[n + 22];
        double d22 = dArray[n + 23];
        double d23 = dArray[n + 24];
        double d24 = dArray[n + 25];
        double d25 = dArray[n + 26];
        double d26 = dArray[n + 27];
        double d27 = dArray[n + 28];
        double d28 = dArray[n + 29];
        double d29 = dArray[n + 30];
        double d30 = dArray[n + 31];
        dArray[n + 2] = d29;
        dArray[n + 3] = d30;
        dArray[n + 4] = d13;
        dArray[n + 5] = d14;
        dArray[n + 6] = d21;
        dArray[n + 7] = d22;
        dArray[n + 8] = d5;
        dArray[n + 9] = d6;
        dArray[n + 10] = d25;
        dArray[n + 11] = d26;
        dArray[n + 12] = d9;
        dArray[n + 13] = d10;
        dArray[n + 14] = d17;
        dArray[n + 15] = d18;
        dArray[n + 16] = d;
        dArray[n + 17] = d2;
        dArray[n + 18] = d27;
        dArray[n + 19] = d28;
        dArray[n + 20] = d11;
        dArray[n + 21] = d12;
        dArray[n + 22] = d19;
        dArray[n + 23] = d20;
        dArray[n + 24] = d3;
        dArray[n + 25] = d4;
        dArray[n + 26] = d23;
        dArray[n + 27] = d24;
        dArray[n + 28] = d7;
        dArray[n + 29] = d8;
        dArray[n + 30] = d15;
        dArray[n + 31] = d16;
    }

    public static void bitrv216neg(A a, long l) {
        double d = a.E(l + 2L);
        double d2 = a.E(l + 3L);
        double d3 = a.E(l + 4L);
        double d4 = a.E(l + 5L);
        double d5 = a.E(l + 6L);
        double d6 = a.E(l + 7L);
        double d7 = a.E(l + 8L);
        double d8 = a.E(l + 9L);
        double d9 = a.E(l + 10L);
        double d10 = a.E(l + 11L);
        double d11 = a.E(l + 12L);
        double d12 = a.E(l + 13L);
        double d13 = a.E(l + 14L);
        double d14 = a.E(l + 15L);
        double d15 = a.E(l + 16L);
        double d16 = a.E(l + 17L);
        double d17 = a.E(l + 18L);
        double d18 = a.E(l + 19L);
        double d19 = a.E(l + 20L);
        double d20 = a.E(l + 21L);
        double d21 = a.E(l + 22L);
        double d22 = a.E(l + 23L);
        double d23 = a.E(l + 24L);
        double d24 = a.E(l + 25L);
        double d25 = a.E(l + 26L);
        double d26 = a.E(l + 27L);
        double d27 = a.E(l + 28L);
        double d28 = a.E(l + 29L);
        double d29 = a.E(l + 30L);
        double d30 = a.E(l + 31L);
        a.B(l + 2L, d29);
        a.B(l + 3L, d30);
        a.B(l + 4L, d13);
        a.B(l + 5L, d14);
        a.B(l + 6L, d21);
        a.B(l + 7L, d22);
        a.B(l + 8L, d5);
        a.B(l + 9L, d6);
        a.B(l + 10L, d25);
        a.B(l + 11L, d26);
        a.B(l + 12L, d9);
        a.B(l + 13L, d10);
        a.B(l + 14L, d17);
        a.B(l + 15L, d18);
        a.B(l + 16L, d);
        a.B(l + 17L, d2);
        a.B(l + 18L, d27);
        a.B(l + 19L, d28);
        a.B(l + 20L, d11);
        a.B(l + 21L, d12);
        a.B(l + 22L, d19);
        a.B(l + 23L, d20);
        a.B(l + 24L, d3);
        a.B(l + 25L, d4);
        a.B(l + 26L, d23);
        a.B(l + 27L, d24);
        a.B(l + 28L, d7);
        a.B(l + 29L, d8);
        a.B(l + 30L, d15);
        a.B(l + 31L, d16);
    }

    public static void bitrv208(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 6];
        double d4 = dArray[n + 7];
        double d5 = dArray[n + 8];
        double d6 = dArray[n + 9];
        double d7 = dArray[n + 12];
        double d8 = dArray[n + 13];
        dArray[n + 2] = d5;
        dArray[n + 3] = d6;
        dArray[n + 6] = d7;
        dArray[n + 7] = d8;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
    }

    public static void bitrv208(A a, long l) {
        double d = a.E(l + 2L);
        double d2 = a.E(l + 3L);
        double d3 = a.E(l + 6L);
        double d4 = a.E(l + 7L);
        double d5 = a.E(l + 8L);
        double d6 = a.E(l + 9L);
        double d7 = a.E(l + 12L);
        double d8 = a.E(l + 13L);
        a.B(l + 2L, d5);
        a.B(l + 3L, d6);
        a.B(l + 6L, d7);
        a.B(l + 7L, d8);
        a.B(l + 8L, d);
        a.B(l + 9L, d2);
        a.B(l + 12L, d3);
        a.B(l + 13L, d4);
    }

    public static void bitrv208neg(double[] dArray, int n) {
        double d = dArray[n + 2];
        double d2 = dArray[n + 3];
        double d3 = dArray[n + 4];
        double d4 = dArray[n + 5];
        double d5 = dArray[n + 6];
        double d6 = dArray[n + 7];
        double d7 = dArray[n + 8];
        double d8 = dArray[n + 9];
        double d9 = dArray[n + 10];
        double d10 = dArray[n + 11];
        double d11 = dArray[n + 12];
        double d12 = dArray[n + 13];
        double d13 = dArray[n + 14];
        double d14 = dArray[n + 15];
        dArray[n + 2] = d13;
        dArray[n + 3] = d14;
        dArray[n + 4] = d5;
        dArray[n + 5] = d6;
        dArray[n + 6] = d9;
        dArray[n + 7] = d10;
        dArray[n + 8] = d;
        dArray[n + 9] = d2;
        dArray[n + 10] = d11;
        dArray[n + 11] = d12;
        dArray[n + 12] = d3;
        dArray[n + 13] = d4;
        dArray[n + 14] = d7;
        dArray[n + 15] = d8;
    }

    public static void bitrv208neg(A a, long l) {
        double d = a.E(l + 2L);
        double d2 = a.E(l + 3L);
        double d3 = a.E(l + 4L);
        double d4 = a.E(l + 5L);
        double d5 = a.E(l + 6L);
        double d6 = a.E(l + 7L);
        double d7 = a.E(l + 8L);
        double d8 = a.E(l + 9L);
        double d9 = a.E(l + 10L);
        double d10 = a.E(l + 11L);
        double d11 = a.E(l + 12L);
        double d12 = a.E(l + 13L);
        double d13 = a.E(l + 14L);
        double d14 = a.E(l + 15L);
        a.B(l + 2L, d13);
        a.B(l + 3L, d14);
        a.B(l + 4L, d5);
        a.B(l + 5L, d6);
        a.B(l + 6L, d9);
        a.B(l + 7L, d10);
        a.B(l + 8L, d);
        a.B(l + 9L, d2);
        a.B(l + 10L, d11);
        a.B(l + 11L, d12);
        a.B(l + 12L, d3);
        a.B(l + 13L, d4);
        a.B(l + 14L, d7);
        a.B(l + 15L, d8);
    }

    public static void cftf1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = dArray[n2 + 1] + dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = dArray[n2 + 1] - dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        dArray[n12] = d7 - d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 + d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = dArray[n16 + 1] + dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n12];
            d8 = dArray[n16 + 1] - dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = dArray[n16 + 3] + dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = dArray[n16 + 3] - dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 + d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = dArray[n4 + 1] + dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = dArray[n4 + 1] - dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = dArray[n4 - 1] + dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = dArray[n4 - 1] - dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 + d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 + d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 - d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 - d25;
            d5 = d7 - d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 - d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 + d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 + d27;
            d6 = d23 - d26;
            dArray[n2 + n10 - 2] = d19 * d5 + d18 * d6;
            dArray[n2 + n10 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = dArray[n4 - 1] + dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = dArray[n4 - 1] - dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 + d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = dArray[n4 + 1] + dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = dArray[n4 + 1] - dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 + d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = dArray[n4 + 3] + dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = dArray[n4 + 3] - dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 + d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 - d10;
        d5 = d7 - d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 + d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    public static void cftf1st(long l, A a, long l2, A a2, long l3) {
        long l4;
        long l5;
        double d;
        double d2;
        double d3;
        double d4;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        double d5 = a.E(l2) + a.E(l12);
        double d6 = a.E(l2 + 1L) + a.E(l12 + 1L);
        double d7 = a.E(l2) - a.E(l12);
        double d8 = a.E(l2 + 1L) - a.E(l12 + 1L);
        double d9 = a.E(l11) + a.E(l13);
        double d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
        double d11 = a.E(l11) - a.E(l13);
        double d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l2, d5 + d9);
        a.B(l2 + 1L, d6 + d10);
        a.B(l11, d5 - d9);
        a.B(l11 + 1L, d6 - d10);
        a.B(l12, d7 - d12);
        a.B(l12 + 1L, d8 + d11);
        a.B(l13, d7 + d12);
        a.B(l13 + 1L, d8 - d11);
        double d13 = a2.E(l3 + 1L);
        double d14 = a2.E(l3 + 2L);
        double d15 = a2.E(l3 + 3L);
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        long l14 = 0L;
        int n = 2;
        while ((long)n < l7 - 2L) {
            long l15 = l3 + (l14 += 4L);
            d4 = d14 * (d16 + a2.E(l15));
            d3 = d14 * (d17 + a2.E(l15 + 1L));
            d2 = d15 * (d18 + a2.E(l15 + 2L));
            d = d15 * (d19 + a2.E(l15 + 3L));
            d16 = a2.E(l15);
            d17 = a2.E(l15 + 1L);
            d18 = a2.E(l15 + 2L);
            d19 = a2.E(l15 + 3L);
            l8 = (long)n + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + (long)n;
            d5 = a.E(l16) + a.E(l12);
            d6 = a.E(l16 + 1L) + a.E(l12 + 1L);
            d7 = a.E(l16) - a.E(l12);
            d8 = a.E(l16 + 1L) - a.E(l12 + 1L);
            double d20 = a.E(l16 + 2L) + a.E(l12 + 2L);
            double d21 = a.E(l16 + 3L) + a.E(l12 + 3L);
            double d22 = a.E(l16 + 2L) - a.E(l12 + 2L);
            double d23 = a.E(l16 + 3L) - a.E(l12 + 3L);
            d9 = a.E(l11) + a.E(l13);
            d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d11 = a.E(l11) - a.E(l13);
            d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
            double d24 = a.E(l11 + 2L) + a.E(l13 + 2L);
            double d25 = a.E(l11 + 3L) + a.E(l13 + 3L);
            double d26 = a.E(l11 + 2L) - a.E(l13 + 2L);
            double d27 = a.E(l11 + 3L) - a.E(l13 + 3L);
            a.B(l16, d5 + d9);
            a.B(l16 + 1L, d6 + d10);
            a.B(l16 + 2L, d20 + d24);
            a.B(l16 + 3L, d21 + d25);
            a.B(l11, d5 - d9);
            a.B(l11 + 1L, d6 - d10);
            a.B(l11 + 2L, d20 - d24);
            a.B(l11 + 3L, d21 - d25);
            d5 = d7 - d12;
            d6 = d8 + d11;
            a.B(l12, d4 * d5 - d3 * d6);
            a.B(l12 + 1L, d4 * d6 + d3 * d5);
            d5 = d22 - d27;
            d6 = d23 + d26;
            a.B(l12 + 2L, d16 * d5 - d17 * d6);
            a.B(l12 + 3L, d16 * d6 + d17 * d5);
            d5 = d7 + d12;
            d6 = d8 - d11;
            a.B(l13, d2 * d5 + d * d6);
            a.B(l13 + 1L, d2 * d6 - d * d5);
            d5 = d22 + d27;
            d6 = d23 - d26;
            a.B(l13 + 2L, d18 * d5 + d19 * d6);
            a.B(l13 + 3L, d18 * d6 - d19 * d5);
            l5 = l6 - (long)n;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            d5 = a.E(l4) + a.E(l12);
            d6 = a.E(l4 + 1L) + a.E(l12 + 1L);
            d7 = a.E(l4) - a.E(l12);
            d8 = a.E(l4 + 1L) - a.E(l12 + 1L);
            d20 = a.E(l4 - 2L) + a.E(l12 - 2L);
            d21 = a.E(l4 - 1L) + a.E(l12 - 1L);
            d22 = a.E(l4 - 2L) - a.E(l12 - 2L);
            d23 = a.E(l4 - 1L) - a.E(l12 - 1L);
            d9 = a.E(l11) + a.E(l13);
            d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d11 = a.E(l11) - a.E(l13);
            d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
            d24 = a.E(l11 - 2L) + a.E(l13 - 2L);
            d25 = a.E(l11 - 1L) + a.E(l13 - 1L);
            d26 = a.E(l11 - 2L) - a.E(l13 - 2L);
            d27 = a.E(l11 - 1L) - a.E(l13 - 1L);
            a.B(l4, d5 + d9);
            a.B(l4 + 1L, d6 + d10);
            a.B(l4 - 2L, d20 + d24);
            a.B(l4 - 1L, d21 + d25);
            a.B(l11, d5 - d9);
            a.B(l11 + 1L, d6 - d10);
            a.B(l11 - 2L, d20 - d24);
            a.B(l11 - 1L, d21 - d25);
            d5 = d7 - d12;
            d6 = d8 + d11;
            a.B(l12, d3 * d5 - d4 * d6);
            a.B(l12 + 1L, d3 * d6 + d4 * d5);
            d5 = d22 - d27;
            d6 = d23 + d26;
            a.B(l12 - 2L, d17 * d5 - d16 * d6);
            a.B(l12 - 1L, d17 * d6 + d16 * d5);
            d5 = d7 + d12;
            d6 = d8 - d11;
            a.B(l13, d * d5 + d2 * d6);
            a.B(l13 + 1L, d * d6 - d2 * d5);
            d5 = d22 + d27;
            d6 = d23 - d26;
            a.B(l2 + l10 - 2L, d19 * d5 + d18 * d6);
            a.B(l2 + l10 - 1L, d19 * d6 - d18 * d5);
            n += 4;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        d5 = a.E(l4 - 2L) + a.E(l12 - 2L);
        d6 = a.E(l4 - 1L) + a.E(l12 - 1L);
        d7 = a.E(l4 - 2L) - a.E(l12 - 2L);
        d8 = a.E(l4 - 1L) - a.E(l12 - 1L);
        d9 = a.E(l11 - 2L) + a.E(l13 - 2L);
        d10 = a.E(l11 - 1L) + a.E(l13 - 1L);
        d11 = a.E(l11 - 2L) - a.E(l13 - 2L);
        d12 = a.E(l11 - 1L) - a.E(l13 - 1L);
        a.B(l4 - 2L, d5 + d9);
        a.B(l4 - 1L, d6 + d10);
        a.B(l11 - 2L, d5 - d9);
        a.B(l11 - 1L, d6 - d10);
        d5 = d7 - d12;
        d6 = d8 + d11;
        a.B(l12 - 2L, d4 * d5 - d3 * d6);
        a.B(l12 - 1L, d4 * d6 + d3 * d5);
        d5 = d7 + d12;
        d6 = d8 - d11;
        a.B(l13 - 2L, d2 * d5 + d * d6);
        a.B(l13 - 1L, d2 * d6 - d * d5);
        d5 = a.E(l4) + a.E(l12);
        d6 = a.E(l4 + 1L) + a.E(l12 + 1L);
        d7 = a.E(l4) - a.E(l12);
        d8 = a.E(l4 + 1L) - a.E(l12 + 1L);
        d9 = a.E(l11) + a.E(l13);
        d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
        d11 = a.E(l11) - a.E(l13);
        d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l4, d5 + d9);
        a.B(l4 + 1L, d6 + d10);
        a.B(l11, d5 - d9);
        a.B(l11 + 1L, d6 - d10);
        d5 = d7 - d12;
        d6 = d8 + d11;
        a.B(l12, d13 * (d5 - d6));
        a.B(l12 + 1L, d13 * (d6 + d5));
        d5 = d7 + d12;
        d6 = d8 - d11;
        a.B(l13, -d13 * (d5 + d6));
        a.B(l13 + 1L, -d13 * (d6 - d5));
        d5 = a.E(l4 + 2L) + a.E(l12 + 2L);
        d6 = a.E(l4 + 3L) + a.E(l12 + 3L);
        d7 = a.E(l4 + 2L) - a.E(l12 + 2L);
        d8 = a.E(l4 + 3L) - a.E(l12 + 3L);
        d9 = a.E(l11 + 2L) + a.E(l13 + 2L);
        d10 = a.E(l11 + 3L) + a.E(l13 + 3L);
        d11 = a.E(l11 + 2L) - a.E(l13 + 2L);
        d12 = a.E(l11 + 3L) - a.E(l13 + 3L);
        a.B(l4 + 2L, d5 + d9);
        a.B(l4 + 3L, d6 + d10);
        a.B(l11 + 2L, d5 - d9);
        a.B(l11 + 3L, d6 - d10);
        d5 = d7 - d12;
        d6 = d8 + d11;
        a.B(l12 + 2L, d3 * d5 - d4 * d6);
        a.B(l12 + 3L, d3 * d6 + d4 * d5);
        d5 = d7 + d12;
        d6 = d8 - d11;
        a.B(l13 + 2L, d * d5 + d2 * d6);
        a.B(l13 + 3L, d * d6 - d2 * d5);
    }

    public static void cftb1st(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d5 = dArray[n2] + dArray[n12];
        double d6 = -dArray[n2 + 1] - dArray[n12 + 1];
        double d7 = dArray[n2] - dArray[n12];
        double d8 = -dArray[n2 + 1] + dArray[n12 + 1];
        double d9 = dArray[n11] + dArray[n13];
        double d10 = dArray[n11 + 1] + dArray[n13 + 1];
        double d11 = dArray[n11] - dArray[n13];
        double d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d5 + d9;
        dArray[n2 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        dArray[n12] = d7 + d12;
        dArray[n12 + 1] = d8 + d11;
        dArray[n13] = d7 - d12;
        dArray[n13 + 1] = d8 - d11;
        double d13 = dArray2[n3 + 1];
        double d14 = dArray2[n3 + 2];
        double d15 = dArray2[n3 + 3];
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            d4 = d14 * (d16 + dArray2[n15]);
            d3 = d14 * (d17 + dArray2[n15 + 1]);
            d2 = d15 * (d18 + dArray2[n15 + 2]);
            d = d15 * (d19 + dArray2[n15 + 3]);
            d16 = dArray2[n15];
            d17 = dArray2[n15 + 1];
            d18 = dArray2[n15 + 2];
            d19 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d5 = dArray[n16] + dArray[n12];
            d6 = -dArray[n16 + 1] - dArray[n12 + 1];
            d7 = dArray[n16] - dArray[n2 + n9];
            d8 = -dArray[n16 + 1] + dArray[n12 + 1];
            double d20 = dArray[n16 + 2] + dArray[n12 + 2];
            double d21 = -dArray[n16 + 3] - dArray[n12 + 3];
            double d22 = dArray[n16 + 2] - dArray[n12 + 2];
            double d23 = -dArray[n16 + 3] + dArray[n12 + 3];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            double d24 = dArray[n11 + 2] + dArray[n13 + 2];
            double d25 = dArray[n11 + 3] + dArray[n13 + 3];
            double d26 = dArray[n11 + 2] - dArray[n13 + 2];
            double d27 = dArray[n11 + 3] - dArray[n13 + 3];
            dArray[n16] = d5 + d9;
            dArray[n16 + 1] = d6 - d10;
            dArray[n16 + 2] = d20 + d24;
            dArray[n16 + 3] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 + 2] = d20 - d24;
            dArray[n11 + 3] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d4 * d5 - d3 * d6;
            dArray[n12 + 1] = d4 * d6 + d3 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 + 2] = d16 * d5 - d17 * d6;
            dArray[n12 + 3] = d16 * d6 + d17 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d2 * d5 + d * d6;
            dArray[n13 + 1] = d2 * d6 - d * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 + 2] = d18 * d5 + d19 * d6;
            dArray[n13 + 3] = d18 * d6 - d19 * d5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d5 = dArray[n4] + dArray[n12];
            d6 = -dArray[n4 + 1] - dArray[n12 + 1];
            d7 = dArray[n4] - dArray[n12];
            d8 = -dArray[n4 + 1] + dArray[n12 + 1];
            d20 = dArray[n4 - 2] + dArray[n12 - 2];
            d21 = -dArray[n4 - 1] - dArray[n12 - 1];
            d22 = dArray[n4 - 2] - dArray[n12 - 2];
            d23 = -dArray[n4 - 1] + dArray[n12 - 1];
            d9 = dArray[n11] + dArray[n13];
            d10 = dArray[n11 + 1] + dArray[n13 + 1];
            d11 = dArray[n11] - dArray[n13];
            d12 = dArray[n11 + 1] - dArray[n13 + 1];
            d24 = dArray[n11 - 2] + dArray[n13 - 2];
            d25 = dArray[n11 - 1] + dArray[n13 - 1];
            d26 = dArray[n11 - 2] - dArray[n13 - 2];
            d27 = dArray[n11 - 1] - dArray[n13 - 1];
            dArray[n4] = d5 + d9;
            dArray[n4 + 1] = d6 - d10;
            dArray[n4 - 2] = d20 + d24;
            dArray[n4 - 1] = d21 - d25;
            dArray[n11] = d5 - d9;
            dArray[n11 + 1] = d6 + d10;
            dArray[n11 - 2] = d20 - d24;
            dArray[n11 - 1] = d21 + d25;
            d5 = d7 + d12;
            d6 = d8 + d11;
            dArray[n12] = d3 * d5 - d4 * d6;
            dArray[n12 + 1] = d3 * d6 + d4 * d5;
            d5 = d22 + d27;
            d6 = d23 + d26;
            dArray[n12 - 2] = d17 * d5 - d16 * d6;
            dArray[n12 - 1] = d17 * d6 + d16 * d5;
            d5 = d7 - d12;
            d6 = d8 - d11;
            dArray[n13] = d * d5 + d2 * d6;
            dArray[n13 + 1] = d * d6 - d2 * d5;
            d5 = d22 - d27;
            d6 = d23 - d26;
            dArray[n13 - 2] = d19 * d5 + d18 * d6;
            dArray[n13 - 1] = d19 * d6 - d18 * d5;
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d5 = dArray[n4 - 2] + dArray[n12 - 2];
        d6 = -dArray[n4 - 1] - dArray[n12 - 1];
        d7 = dArray[n4 - 2] - dArray[n12 - 2];
        d8 = -dArray[n4 - 1] + dArray[n12 - 1];
        d9 = dArray[n11 - 2] + dArray[n13 - 2];
        d10 = dArray[n11 - 1] + dArray[n13 - 1];
        d11 = dArray[n11 - 2] - dArray[n13 - 2];
        d12 = dArray[n11 - 1] - dArray[n13 - 1];
        dArray[n4 - 2] = d5 + d9;
        dArray[n4 - 1] = d6 - d10;
        dArray[n11 - 2] = d5 - d9;
        dArray[n11 - 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 - 2] = d4 * d5 - d3 * d6;
        dArray[n12 - 1] = d4 * d6 + d3 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 - 2] = d2 * d5 + d * d6;
        dArray[n13 - 1] = d2 * d6 - d * d5;
        d5 = dArray[n4] + dArray[n12];
        d6 = -dArray[n4 + 1] - dArray[n12 + 1];
        d7 = dArray[n4] - dArray[n12];
        d8 = -dArray[n4 + 1] + dArray[n12 + 1];
        d9 = dArray[n11] + dArray[n13];
        d10 = dArray[n11 + 1] + dArray[n13 + 1];
        d11 = dArray[n11] - dArray[n13];
        d12 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d5 + d9;
        dArray[n4 + 1] = d6 - d10;
        dArray[n11] = d5 - d9;
        dArray[n11 + 1] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12] = d13 * (d5 - d6);
        dArray[n12 + 1] = d13 * (d6 + d5);
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13] = -d13 * (d5 + d6);
        dArray[n13 + 1] = -d13 * (d6 - d5);
        d5 = dArray[n4 + 2] + dArray[n12 + 2];
        d6 = -dArray[n4 + 3] - dArray[n12 + 3];
        d7 = dArray[n4 + 2] - dArray[n12 + 2];
        d8 = -dArray[n4 + 3] + dArray[n12 + 3];
        d9 = dArray[n11 + 2] + dArray[n13 + 2];
        d10 = dArray[n11 + 3] + dArray[n13 + 3];
        d11 = dArray[n11 + 2] - dArray[n13 + 2];
        d12 = dArray[n11 + 3] - dArray[n13 + 3];
        dArray[n4 + 2] = d5 + d9;
        dArray[n4 + 3] = d6 - d10;
        dArray[n11 + 2] = d5 - d9;
        dArray[n11 + 3] = d6 + d10;
        d5 = d7 + d12;
        d6 = d8 + d11;
        dArray[n12 + 2] = d3 * d5 - d4 * d6;
        dArray[n12 + 3] = d3 * d6 + d4 * d5;
        d5 = d7 - d12;
        d6 = d8 - d11;
        dArray[n13 + 2] = d * d5 + d2 * d6;
        dArray[n13 + 3] = d * d6 - d2 * d5;
    }

    public static void cftb1st(long l, A a, long l2, A a2, long l3) {
        long l4;
        long l5;
        double d;
        double d2;
        double d3;
        double d4;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        double d5 = a.E(l2) + a.E(l12);
        double d6 = -a.E(l2 + 1L) - a.E(l12 + 1L);
        double d7 = a.E(l2) - a.E(l12);
        double d8 = -a.E(l2 + 1L) + a.E(l12 + 1L);
        double d9 = a.E(l11) + a.E(l13);
        double d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
        double d11 = a.E(l11) - a.E(l13);
        double d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l2, d5 + d9);
        a.B(l2 + 1L, d6 - d10);
        a.B(l11, d5 - d9);
        a.B(l11 + 1L, d6 + d10);
        a.B(l12, d7 + d12);
        a.B(l12 + 1L, d8 + d11);
        a.B(l13, d7 - d12);
        a.B(l13 + 1L, d8 - d11);
        double d13 = a2.E(l3 + 1L);
        double d14 = a2.E(l3 + 2L);
        double d15 = a2.E(l3 + 3L);
        double d16 = 1.0;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.0;
        long l14 = 0L;
        for (long i = 2L; i < l7 - 2L; i += 4L) {
            long l15 = l3 + (l14 += 4L);
            d4 = d14 * (d16 + a2.E(l15));
            d3 = d14 * (d17 + a2.E(l15 + 1L));
            d2 = d15 * (d18 + a2.E(l15 + 2L));
            d = d15 * (d19 + a2.E(l15 + 3L));
            d16 = a2.E(l15);
            d17 = a2.E(l15 + 1L);
            d18 = a2.E(l15 + 2L);
            d19 = a2.E(l15 + 3L);
            l8 = i + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + i;
            d5 = a.E(l16) + a.E(l12);
            d6 = -a.E(l16 + 1L) - a.E(l12 + 1L);
            d7 = a.E(l16) - a.E(l2 + l9);
            d8 = -a.E(l16 + 1L) + a.E(l12 + 1L);
            double d20 = a.E(l16 + 2L) + a.E(l12 + 2L);
            double d21 = -a.E(l16 + 3L) - a.E(l12 + 3L);
            double d22 = a.E(l16 + 2L) - a.E(l12 + 2L);
            double d23 = -a.E(l16 + 3L) + a.E(l12 + 3L);
            d9 = a.E(l11) + a.E(l13);
            d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d11 = a.E(l11) - a.E(l13);
            d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
            double d24 = a.E(l11 + 2L) + a.E(l13 + 2L);
            double d25 = a.E(l11 + 3L) + a.E(l13 + 3L);
            double d26 = a.E(l11 + 2L) - a.E(l13 + 2L);
            double d27 = a.E(l11 + 3L) - a.E(l13 + 3L);
            a.B(l16, d5 + d9);
            a.B(l16 + 1L, d6 - d10);
            a.B(l16 + 2L, d20 + d24);
            a.B(l16 + 3L, d21 - d25);
            a.B(l11, d5 - d9);
            a.B(l11 + 1L, d6 + d10);
            a.B(l11 + 2L, d20 - d24);
            a.B(l11 + 3L, d21 + d25);
            d5 = d7 + d12;
            d6 = d8 + d11;
            a.B(l12, d4 * d5 - d3 * d6);
            a.B(l12 + 1L, d4 * d6 + d3 * d5);
            d5 = d22 + d27;
            d6 = d23 + d26;
            a.B(l12 + 2L, d16 * d5 - d17 * d6);
            a.B(l12 + 3L, d16 * d6 + d17 * d5);
            d5 = d7 - d12;
            d6 = d8 - d11;
            a.B(l13, d2 * d5 + d * d6);
            a.B(l13 + 1L, d2 * d6 - d * d5);
            d5 = d22 - d27;
            d6 = d23 - d26;
            a.B(l13 + 2L, d18 * d5 + d19 * d6);
            a.B(l13 + 3L, d18 * d6 - d19 * d5);
            l5 = l6 - i;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            d5 = a.E(l4) + a.E(l12);
            d6 = -a.E(l4 + 1L) - a.E(l12 + 1L);
            d7 = a.E(l4) - a.E(l12);
            d8 = -a.E(l4 + 1L) + a.E(l12 + 1L);
            d20 = a.E(l4 - 2L) + a.E(l12 - 2L);
            d21 = -a.E(l4 - 1L) - a.E(l12 - 1L);
            d22 = a.E(l4 - 2L) - a.E(l12 - 2L);
            d23 = -a.E(l4 - 1L) + a.E(l12 - 1L);
            d9 = a.E(l11) + a.E(l13);
            d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d11 = a.E(l11) - a.E(l13);
            d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
            d24 = a.E(l11 - 2L) + a.E(l13 - 2L);
            d25 = a.E(l11 - 1L) + a.E(l13 - 1L);
            d26 = a.E(l11 - 2L) - a.E(l13 - 2L);
            d27 = a.E(l11 - 1L) - a.E(l13 - 1L);
            a.B(l4, d5 + d9);
            a.B(l4 + 1L, d6 - d10);
            a.B(l4 - 2L, d20 + d24);
            a.B(l4 - 1L, d21 - d25);
            a.B(l11, d5 - d9);
            a.B(l11 + 1L, d6 + d10);
            a.B(l11 - 2L, d20 - d24);
            a.B(l11 - 1L, d21 + d25);
            d5 = d7 + d12;
            d6 = d8 + d11;
            a.B(l12, d3 * d5 - d4 * d6);
            a.B(l12 + 1L, d3 * d6 + d4 * d5);
            d5 = d22 + d27;
            d6 = d23 + d26;
            a.B(l12 - 2L, d17 * d5 - d16 * d6);
            a.B(l12 - 1L, d17 * d6 + d16 * d5);
            d5 = d7 - d12;
            d6 = d8 - d11;
            a.B(l13, d * d5 + d2 * d6);
            a.B(l13 + 1L, d * d6 - d2 * d5);
            d5 = d22 - d27;
            d6 = d23 - d26;
            a.B(l13 - 2L, d19 * d5 + d18 * d6);
            a.B(l13 - 1L, d19 * d6 - d18 * d5);
        }
        d4 = d14 * (d16 + d13);
        d3 = d14 * (d17 + d13);
        d2 = d15 * (d18 - d13);
        d = d15 * (d19 - d13);
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        d5 = a.E(l4 - 2L) + a.E(l12 - 2L);
        d6 = -a.E(l4 - 1L) - a.E(l12 - 1L);
        d7 = a.E(l4 - 2L) - a.E(l12 - 2L);
        d8 = -a.E(l4 - 1L) + a.E(l12 - 1L);
        d9 = a.E(l11 - 2L) + a.E(l13 - 2L);
        d10 = a.E(l11 - 1L) + a.E(l13 - 1L);
        d11 = a.E(l11 - 2L) - a.E(l13 - 2L);
        d12 = a.E(l11 - 1L) - a.E(l13 - 1L);
        a.B(l4 - 2L, d5 + d9);
        a.B(l4 - 1L, d6 - d10);
        a.B(l11 - 2L, d5 - d9);
        a.B(l11 - 1L, d6 + d10);
        d5 = d7 + d12;
        d6 = d8 + d11;
        a.B(l12 - 2L, d4 * d5 - d3 * d6);
        a.B(l12 - 1L, d4 * d6 + d3 * d5);
        d5 = d7 - d12;
        d6 = d8 - d11;
        a.B(l13 - 2L, d2 * d5 + d * d6);
        a.B(l13 - 1L, d2 * d6 - d * d5);
        d5 = a.E(l4) + a.E(l12);
        d6 = -a.E(l4 + 1L) - a.E(l12 + 1L);
        d7 = a.E(l4) - a.E(l12);
        d8 = -a.E(l4 + 1L) + a.E(l12 + 1L);
        d9 = a.E(l11) + a.E(l13);
        d10 = a.E(l11 + 1L) + a.E(l13 + 1L);
        d11 = a.E(l11) - a.E(l13);
        d12 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l4, d5 + d9);
        a.B(l4 + 1L, d6 - d10);
        a.B(l11, d5 - d9);
        a.B(l11 + 1L, d6 + d10);
        d5 = d7 + d12;
        d6 = d8 + d11;
        a.B(l12, d13 * (d5 - d6));
        a.B(l12 + 1L, d13 * (d6 + d5));
        d5 = d7 - d12;
        d6 = d8 - d11;
        a.B(l13, -d13 * (d5 + d6));
        a.B(l13 + 1L, -d13 * (d6 - d5));
        d5 = a.E(l4 + 2L) + a.E(l12 + 2L);
        d6 = -a.E(l4 + 3L) - a.E(l12 + 3L);
        d7 = a.E(l4 + 2L) - a.E(l12 + 2L);
        d8 = -a.E(l4 + 3L) + a.E(l12 + 3L);
        d9 = a.E(l11 + 2L) + a.E(l13 + 2L);
        d10 = a.E(l11 + 3L) + a.E(l13 + 3L);
        d11 = a.E(l11 + 2L) - a.E(l13 + 2L);
        d12 = a.E(l11 + 3L) - a.E(l13 + 3L);
        a.B(l4 + 2L, d5 + d9);
        a.B(l4 + 3L, d6 - d10);
        a.B(l11 + 2L, d5 - d9);
        a.B(l11 + 3L, d6 + d10);
        d5 = d7 + d12;
        d6 = d8 + d11;
        a.B(l12 + 2L, d3 * d5 - d4 * d6);
        a.B(l12 + 3L, d3 * d6 + d4 * d5);
        d5 = d7 - d12;
        d6 = d8 - d11;
        a.B(l13 + 2L, d * d5 + d2 * d6);
        a.B(l13 + 3L, d * d6 - d2 * d5);
    }

    public static void cftrec4_th(final int n, final double[] dArray, int n2, final int n3, final double[] dArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if ((long)n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? F.A(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        CommonUtils.cftmdl1(n2 >>= 2, dArray, n6 - n2, dArray2, n3 - (n2 >> 1));
                    }
                    CommonUtils.cftleaf(n2, 1, dArray, n6 - n2, n3, dArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = CommonUtils.cfttree(n2, i, ++n32, dArray, n9, n3, dArray2);
                        CommonUtils.cftleaf(n2, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            }) : F.A(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        CommonUtils.cftmdl2(n32 >>= 2, dArray, n6 - n32, dArray2, n3 - n32);
                    }
                    CommonUtils.cftleaf(n32, 0, dArray, n6 - n32, n3, dArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = CommonUtils.cfttree(n32, i, ++n2, dArray, n9, n3, dArray2);
                        CommonUtils.cftleaf(n32, n5, dArray, n4 + i, n3, dArray2);
                    }
                }
            });
        }
        try {
            F.A(futureArray);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
        }
    }

    public static void cftrec4_th(final long l, final A a, long l2, final long l3, final A a2) {
        int n = 0;
        int n2 = 2;
        int n3 = 0;
        long l4 = l >> 1;
        if (l >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n2 = 4;
            n3 = 1;
            l4 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final long l5 = l4;
        for (int i = 0; i < n2; ++i) {
            final long l6 = l2 + (long)i * l4;
            futureArray[n++] = i != n3 ? F.A(new Runnable(){

                @Override
                public void run() {
                    long l7 = l6 + l5;
                    long l2 = l;
                    while (l2 > 512L) {
                        CommonUtils.cftmdl1(l2 >>= 2, a, l7 - l2, a2, l3 - (l2 >> 1));
                    }
                    CommonUtils.cftleaf(l2, 1L, a, l7 - l2, l3, a2);
                    long l32 = 0L;
                    long l4 = l6 - l2;
                    for (long i = l5 - l2; i > 0L; i -= l2) {
                        long l52 = CommonUtils.cfttree(l2, i, ++l32, a, l6, l3, a2);
                        CommonUtils.cftleaf(l2, l52, a, l4 + i, l3, a2);
                    }
                }
            }) : F.A(new Runnable(){

                @Override
                public void run() {
                    long l7 = l6 + l5;
                    long l2 = 1L;
                    long l32 = l;
                    while (l32 > 512L) {
                        l2 <<= 2;
                        CommonUtils.cftmdl2(l32 >>= 2, a, l7 - l32, a2, l3 - l32);
                    }
                    CommonUtils.cftleaf(l32, 0L, a, l7 - l32, l3, a2);
                    l2 >>= 1;
                    long l4 = l6 - l32;
                    for (long i = l5 - l32; i > 0L; i -= l32) {
                        long l52 = CommonUtils.cfttree(l32, i, ++l2, a, l6, l3, a2);
                        CommonUtils.cftleaf(l32, l52, a, l4 + i, l3, a2);
                    }
                }
            });
        }
        try {
            F.A(futureArray);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
        }
    }

    public static void cftrec4(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        int n4 = n;
        int n5 = n2 + n;
        while (n4 > 512) {
            CommonUtils.cftmdl1(n4 >>= 2, dArray, n5 - n4, dArray2, n3 - (n4 >> 1));
        }
        CommonUtils.cftleaf(n4, 1, dArray, n5 - n4, n3, dArray2);
        int n6 = 0;
        int n7 = n2 - n4;
        for (int i = n - n4; i > 0; i -= n4) {
            int n8 = CommonUtils.cfttree(n4, i, ++n6, dArray, n2, n3, dArray2);
            CommonUtils.cftleaf(n4, n8, dArray, n7 + i, n3, dArray2);
        }
    }

    public static void cftrec4(long l, A a, long l2, long l3, A a2) {
        long l4 = l;
        long l5 = l2 + l;
        while (l4 > 512L) {
            CommonUtils.cftmdl1(l4 >>= 2, a, l5 - l4, a2, l3 - (l4 >> 1));
        }
        CommonUtils.cftleaf(l4, 1L, a, l5 - l4, l3, a2);
        long l6 = 0L;
        long l7 = l2 - l4;
        for (long i = l - l4; i > 0L; i -= l4) {
            long l8 = CommonUtils.cfttree(l4, i, ++l6, a, l2, l3, a2);
            CommonUtils.cftleaf(l4, l8, a, l7 + i, l3, a2);
        }
    }

    public static int cfttree(int n, int n2, int n3, double[] dArray, int n4, int n5, double[] dArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                CommonUtils.cftmdl1(n, dArray, n7 + n2, dArray2, n5 - (n >> 1));
            } else {
                CommonUtils.cftmdl2(n, dArray, n7 + n2, dArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    CommonUtils.cftmdl1(n8, dArray, n10 - n8, dArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    CommonUtils.cftmdl2(n8, dArray, n10 - n8, dArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    public static long cfttree(long l, long l2, long l3, A a, long l4, long l5, A a2) {
        long l6;
        long l7 = l4 - l;
        if ((l3 & 3L) != 0L) {
            l6 = l3 & 1L;
            if (l6 != 0L) {
                CommonUtils.cftmdl1(l, a, l7 + l2, a2, l5 - (l >> 1));
            } else {
                CommonUtils.cftmdl2(l, a, l7 + l2, a2, l5 - l);
            }
        } else {
            long l8 = l;
            long l9 = l3;
            while ((l9 & 3L) == 0L) {
                l8 <<= 2;
                l9 >>= 2;
            }
            l6 = l9 & 1L;
            long l10 = l4 + l2;
            if (l6 != 0L) {
                while (l8 > 128L) {
                    CommonUtils.cftmdl1(l8, a, l10 - l8, a2, l5 - (l8 >> 1));
                    l8 >>= 2;
                }
            } else {
                while (l8 > 128L) {
                    CommonUtils.cftmdl2(l8, a, l10 - l8, a2, l5 - l8);
                    l8 >>= 2;
                }
            }
        }
        return l6;
    }

    public static void cftleaf(int n, int n2, double[] dArray, int n3, int n4, double[] dArray2) {
        if (n == 512) {
            CommonUtils.cftmdl1(128, dArray, n3, dArray2, n4 - 64);
            CommonUtils.cftf161(dArray, n3, dArray2, n4 - 8);
            CommonUtils.cftf162(dArray, n3 + 32, dArray2, n4 - 32);
            CommonUtils.cftf161(dArray, n3 + 64, dArray2, n4 - 8);
            CommonUtils.cftf161(dArray, n3 + 96, dArray2, n4 - 8);
            CommonUtils.cftmdl2(128, dArray, n3 + 128, dArray2, n4 - 128);
            CommonUtils.cftf161(dArray, n3 + 128, dArray2, n4 - 8);
            CommonUtils.cftf162(dArray, n3 + 160, dArray2, n4 - 32);
            CommonUtils.cftf161(dArray, n3 + 192, dArray2, n4 - 8);
            CommonUtils.cftf162(dArray, n3 + 224, dArray2, n4 - 32);
            CommonUtils.cftmdl1(128, dArray, n3 + 256, dArray2, n4 - 64);
            CommonUtils.cftf161(dArray, n3 + 256, dArray2, n4 - 8);
            CommonUtils.cftf162(dArray, n3 + 288, dArray2, n4 - 32);
            CommonUtils.cftf161(dArray, n3 + 320, dArray2, n4 - 8);
            CommonUtils.cftf161(dArray, n3 + 352, dArray2, n4 - 8);
            if (n2 != 0) {
                CommonUtils.cftmdl1(128, dArray, n3 + 384, dArray2, n4 - 64);
                CommonUtils.cftf161(dArray, n3 + 480, dArray2, n4 - 8);
            } else {
                CommonUtils.cftmdl2(128, dArray, n3 + 384, dArray2, n4 - 128);
                CommonUtils.cftf162(dArray, n3 + 480, dArray2, n4 - 32);
            }
            CommonUtils.cftf161(dArray, n3 + 384, dArray2, n4 - 8);
            CommonUtils.cftf162(dArray, n3 + 416, dArray2, n4 - 32);
            CommonUtils.cftf161(dArray, n3 + 448, dArray2, n4 - 8);
        } else {
            CommonUtils.cftmdl1(64, dArray, n3, dArray2, n4 - 32);
            CommonUtils.cftf081(dArray, n3, dArray2, n4 - 8);
            CommonUtils.cftf082(dArray, n3 + 16, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 32, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 48, dArray2, n4 - 8);
            CommonUtils.cftmdl2(64, dArray, n3 + 64, dArray2, n4 - 64);
            CommonUtils.cftf081(dArray, n3 + 64, dArray2, n4 - 8);
            CommonUtils.cftf082(dArray, n3 + 80, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 96, dArray2, n4 - 8);
            CommonUtils.cftf082(dArray, n3 + 112, dArray2, n4 - 8);
            CommonUtils.cftmdl1(64, dArray, n3 + 128, dArray2, n4 - 32);
            CommonUtils.cftf081(dArray, n3 + 128, dArray2, n4 - 8);
            CommonUtils.cftf082(dArray, n3 + 144, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 160, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 176, dArray2, n4 - 8);
            if (n2 != 0) {
                CommonUtils.cftmdl1(64, dArray, n3 + 192, dArray2, n4 - 32);
                CommonUtils.cftf081(dArray, n3 + 240, dArray2, n4 - 8);
            } else {
                CommonUtils.cftmdl2(64, dArray, n3 + 192, dArray2, n4 - 64);
                CommonUtils.cftf082(dArray, n3 + 240, dArray2, n4 - 8);
            }
            CommonUtils.cftf081(dArray, n3 + 192, dArray2, n4 - 8);
            CommonUtils.cftf082(dArray, n3 + 208, dArray2, n4 - 8);
            CommonUtils.cftf081(dArray, n3 + 224, dArray2, n4 - 8);
        }
    }

    public static void cftleaf(long l, long l2, A a, long l3, long l4, A a2) {
        if (l == 512L) {
            CommonUtils.cftmdl1(128L, a, l3, a2, l4 - 64L);
            CommonUtils.cftf161(a, l3, a2, l4 - 8L);
            CommonUtils.cftf162(a, l3 + 32L, a2, l4 - 32L);
            CommonUtils.cftf161(a, l3 + 64L, a2, l4 - 8L);
            CommonUtils.cftf161(a, l3 + 96L, a2, l4 - 8L);
            CommonUtils.cftmdl2(128L, a, l3 + 128L, a2, l4 - 128L);
            CommonUtils.cftf161(a, l3 + 128L, a2, l4 - 8L);
            CommonUtils.cftf162(a, l3 + 160L, a2, l4 - 32L);
            CommonUtils.cftf161(a, l3 + 192L, a2, l4 - 8L);
            CommonUtils.cftf162(a, l3 + 224L, a2, l4 - 32L);
            CommonUtils.cftmdl1(128L, a, l3 + 256L, a2, l4 - 64L);
            CommonUtils.cftf161(a, l3 + 256L, a2, l4 - 8L);
            CommonUtils.cftf162(a, l3 + 288L, a2, l4 - 32L);
            CommonUtils.cftf161(a, l3 + 320L, a2, l4 - 8L);
            CommonUtils.cftf161(a, l3 + 352L, a2, l4 - 8L);
            if (l2 != 0L) {
                CommonUtils.cftmdl1(128L, a, l3 + 384L, a2, l4 - 64L);
                CommonUtils.cftf161(a, l3 + 480L, a2, l4 - 8L);
            } else {
                CommonUtils.cftmdl2(128L, a, l3 + 384L, a2, l4 - 128L);
                CommonUtils.cftf162(a, l3 + 480L, a2, l4 - 32L);
            }
            CommonUtils.cftf161(a, l3 + 384L, a2, l4 - 8L);
            CommonUtils.cftf162(a, l3 + 416L, a2, l4 - 32L);
            CommonUtils.cftf161(a, l3 + 448L, a2, l4 - 8L);
        } else {
            CommonUtils.cftmdl1(64L, a, l3, a2, l4 - 32L);
            CommonUtils.cftf081(a, l3, a2, l4 - 8L);
            CommonUtils.cftf082(a, l3 + 16L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 32L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 48L, a2, l4 - 8L);
            CommonUtils.cftmdl2(64L, a, l3 + 64L, a2, l4 - 64L);
            CommonUtils.cftf081(a, l3 + 64L, a2, l4 - 8L);
            CommonUtils.cftf082(a, l3 + 80L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 96L, a2, l4 - 8L);
            CommonUtils.cftf082(a, l3 + 112L, a2, l4 - 8L);
            CommonUtils.cftmdl1(64L, a, l3 + 128L, a2, l4 - 32L);
            CommonUtils.cftf081(a, l3 + 128L, a2, l4 - 8L);
            CommonUtils.cftf082(a, l3 + 144L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 160L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 176L, a2, l4 - 8L);
            if (l2 != 0L) {
                CommonUtils.cftmdl1(64L, a, l3 + 192L, a2, l4 - 32L);
                CommonUtils.cftf081(a, l3 + 240L, a2, l4 - 8L);
            } else {
                CommonUtils.cftmdl2(64L, a, l3 + 192L, a2, l4 - 64L);
                CommonUtils.cftf082(a, l3 + 240L, a2, l4 - 8L);
            }
            CommonUtils.cftf081(a, l3 + 192L, a2, l4 - 8L);
            CommonUtils.cftf082(a, l3 + 208L, a2, l4 - 8L);
            CommonUtils.cftf081(a, l3 + 224L, a2, l4 - 8L);
        }
    }

    public static void cftmdl1(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d = dArray[n2] + dArray[n12];
        double d2 = dArray[n2 + 1] + dArray[n12 + 1];
        double d3 = dArray[n2] - dArray[n12];
        double d4 = dArray[n2 + 1] - dArray[n12 + 1];
        double d5 = dArray[n11] + dArray[n13];
        double d6 = dArray[n11 + 1] + dArray[n13 + 1];
        double d7 = dArray[n11] - dArray[n13];
        double d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n2] = d + d5;
        dArray[n2 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        dArray[n12] = d3 - d8;
        dArray[n12 + 1] = d4 + d7;
        dArray[n13] = d3 + d8;
        dArray[n13 + 1] = d4 - d7;
        double d9 = dArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            double d10 = dArray2[n15];
            double d11 = dArray2[n15 + 1];
            double d12 = dArray2[n15 + 2];
            double d13 = dArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            d = dArray[n16] + dArray[n12];
            d2 = dArray[n16 + 1] + dArray[n12 + 1];
            d3 = dArray[n16] - dArray[n12];
            d4 = dArray[n16 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n16] = d + d5;
            dArray[n16 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d10 * d - d11 * d2;
            dArray[n12 + 1] = d10 * d2 + d11 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d12 * d + d13 * d2;
            dArray[n13 + 1] = d12 * d2 - d13 * d;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d = dArray[n4] + dArray[n12];
            d2 = dArray[n4 + 1] + dArray[n12 + 1];
            d3 = dArray[n4] - dArray[n12];
            d4 = dArray[n4 + 1] - dArray[n12 + 1];
            d5 = dArray[n11] + dArray[n13];
            d6 = dArray[n11 + 1] + dArray[n13 + 1];
            d7 = dArray[n11] - dArray[n13];
            d8 = dArray[n11 + 1] - dArray[n13 + 1];
            dArray[n4] = d + d5;
            dArray[n4 + 1] = d2 + d6;
            dArray[n11] = d - d5;
            dArray[n11 + 1] = d2 - d6;
            d = d3 - d8;
            d2 = d4 + d7;
            dArray[n12] = d11 * d - d10 * d2;
            dArray[n12 + 1] = d11 * d2 + d10 * d;
            d = d3 + d8;
            d2 = d4 - d7;
            dArray[n13] = d13 * d + d12 * d2;
            dArray[n13 + 1] = d13 * d2 - d12 * d;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d = dArray[n4] + dArray[n12];
        d2 = dArray[n4 + 1] + dArray[n12 + 1];
        d3 = dArray[n4] - dArray[n12];
        d4 = dArray[n4 + 1] - dArray[n12 + 1];
        d5 = dArray[n11] + dArray[n13];
        d6 = dArray[n11 + 1] + dArray[n13 + 1];
        d7 = dArray[n11] - dArray[n13];
        d8 = dArray[n11 + 1] - dArray[n13 + 1];
        dArray[n4] = d + d5;
        dArray[n4 + 1] = d2 + d6;
        dArray[n11] = d - d5;
        dArray[n11 + 1] = d2 - d6;
        d = d3 - d8;
        d2 = d4 + d7;
        dArray[n12] = d9 * (d - d2);
        dArray[n12 + 1] = d9 * (d2 + d);
        d = d3 + d8;
        d2 = d4 - d7;
        dArray[n13] = -d9 * (d + d2);
        dArray[n13 + 1] = -d9 * (d2 - d);
    }

    public static void cftmdl1(long l, A a, long l2, A a2, long l3) {
        long l4;
        long l5;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        double d = a.E(l2) + a.E(l12);
        double d2 = a.E(l2 + 1L) + a.E(l12 + 1L);
        double d3 = a.E(l2) - a.E(l12);
        double d4 = a.E(l2 + 1L) - a.E(l12 + 1L);
        double d5 = a.E(l11) + a.E(l13);
        double d6 = a.E(l11 + 1L) + a.E(l13 + 1L);
        double d7 = a.E(l11) - a.E(l13);
        double d8 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l2, d + d5);
        a.B(l2 + 1L, d2 + d6);
        a.B(l11, d - d5);
        a.B(l11 + 1L, d2 - d6);
        a.B(l12, d3 - d8);
        a.B(l12 + 1L, d4 + d7);
        a.B(l13, d3 + d8);
        a.B(l13 + 1L, d4 - d7);
        double d9 = a2.E(l3 + 1L);
        long l14 = 0L;
        for (long i = 2L; i < l7; i += 2L) {
            long l15 = l3 + (l14 += 4L);
            double d10 = a2.E(l15);
            double d11 = a2.E(l15 + 1L);
            double d12 = a2.E(l15 + 2L);
            double d13 = a2.E(l15 + 3L);
            l8 = i + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + i;
            d = a.E(l16) + a.E(l12);
            d2 = a.E(l16 + 1L) + a.E(l12 + 1L);
            d3 = a.E(l16) - a.E(l12);
            d4 = a.E(l16 + 1L) - a.E(l12 + 1L);
            d5 = a.E(l11) + a.E(l13);
            d6 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d7 = a.E(l11) - a.E(l13);
            d8 = a.E(l11 + 1L) - a.E(l13 + 1L);
            a.B(l16, d + d5);
            a.B(l16 + 1L, d2 + d6);
            a.B(l11, d - d5);
            a.B(l11 + 1L, d2 - d6);
            d = d3 - d8;
            d2 = d4 + d7;
            a.B(l12, d10 * d - d11 * d2);
            a.B(l12 + 1L, d10 * d2 + d11 * d);
            d = d3 + d8;
            d2 = d4 - d7;
            a.B(l13, d12 * d + d13 * d2);
            a.B(l13 + 1L, d12 * d2 - d13 * d);
            l5 = l6 - i;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            d = a.E(l4) + a.E(l12);
            d2 = a.E(l4 + 1L) + a.E(l12 + 1L);
            d3 = a.E(l4) - a.E(l12);
            d4 = a.E(l4 + 1L) - a.E(l12 + 1L);
            d5 = a.E(l11) + a.E(l13);
            d6 = a.E(l11 + 1L) + a.E(l13 + 1L);
            d7 = a.E(l11) - a.E(l13);
            d8 = a.E(l11 + 1L) - a.E(l13 + 1L);
            a.B(l4, d + d5);
            a.B(l4 + 1L, d2 + d6);
            a.B(l11, d - d5);
            a.B(l11 + 1L, d2 - d6);
            d = d3 - d8;
            d2 = d4 + d7;
            a.B(l12, d11 * d - d10 * d2);
            a.B(l12 + 1L, d11 * d2 + d10 * d);
            d = d3 + d8;
            d2 = d4 - d7;
            a.B(l13, d13 * d + d12 * d2);
            a.B(l13 + 1L, d13 * d2 - d12 * d);
        }
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        d = a.E(l4) + a.E(l12);
        d2 = a.E(l4 + 1L) + a.E(l12 + 1L);
        d3 = a.E(l4) - a.E(l12);
        d4 = a.E(l4 + 1L) - a.E(l12 + 1L);
        d5 = a.E(l11) + a.E(l13);
        d6 = a.E(l11 + 1L) + a.E(l13 + 1L);
        d7 = a.E(l11) - a.E(l13);
        d8 = a.E(l11 + 1L) - a.E(l13 + 1L);
        a.B(l4, d + d5);
        a.B(l4 + 1L, d2 + d6);
        a.B(l11, d - d5);
        a.B(l11 + 1L, d2 - d6);
        d = d3 - d8;
        d2 = d4 + d7;
        a.B(l12, d9 * (d - d2));
        a.B(l12 + 1L, d9 * (d2 + d));
        d = d3 + d8;
        d2 = d4 - d7;
        a.B(l13, -d9 * (d + d2));
        a.B(l13 + 1L, -d9 * (d2 - d));
    }

    public static void cftmdl2(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        int n4;
        int n5;
        double d;
        double d2;
        double d3;
        double d4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        double d5 = dArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        double d6 = dArray[n2] - dArray[n12 + 1];
        double d7 = dArray[n2 + 1] + dArray[n12];
        double d8 = dArray[n2] + dArray[n12 + 1];
        double d9 = dArray[n2 + 1] - dArray[n12];
        double d10 = dArray[n11] - dArray[n13 + 1];
        double d11 = dArray[n11 + 1] + dArray[n13];
        double d12 = dArray[n11] + dArray[n13 + 1];
        double d13 = dArray[n11 + 1] - dArray[n13];
        double d14 = d5 * (d10 - d11);
        double d15 = d5 * (d11 + d10);
        dArray[n2] = d6 + d14;
        dArray[n2 + 1] = d7 + d15;
        dArray[n11] = d6 - d14;
        dArray[n11 + 1] = d7 - d15;
        d14 = d5 * (d12 - d13);
        d15 = d5 * (d13 + d12);
        dArray[n12] = d8 - d15;
        dArray[n12 + 1] = d9 + d14;
        dArray[n13] = d8 + d15;
        dArray[n13 + 1] = d9 - d14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            d4 = dArray2[n16];
            d3 = dArray2[n16 + 1];
            double d16 = dArray2[n16 + 2];
            double d17 = dArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            double d18 = dArray2[n17];
            double d19 = dArray2[n17 + 1];
            double d20 = dArray2[n17 + 2];
            double d21 = dArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            d6 = dArray[n18] - dArray[n12 + 1];
            d7 = dArray[n18 + 1] + dArray[n12];
            d8 = dArray[n18] + dArray[n12 + 1];
            d9 = dArray[n18 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d4 * d6 - d3 * d7;
            d15 = d4 * d7 + d3 * d6;
            d2 = d19 * d10 - d18 * d11;
            d = d19 * d11 + d18 * d10;
            dArray[n18] = d14 + d2;
            dArray[n18 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d16 * d8 + d17 * d9;
            d15 = d16 * d9 - d17 * d8;
            d2 = d21 * d12 + d20 * d13;
            d = d21 * d13 - d20 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            d6 = dArray[n4] - dArray[n12 + 1];
            d7 = dArray[n4 + 1] + dArray[n12];
            d8 = dArray[n4] + dArray[n12 + 1];
            d9 = dArray[n4 + 1] - dArray[n12];
            d10 = dArray[n11] - dArray[n13 + 1];
            d11 = dArray[n11 + 1] + dArray[n13];
            d12 = dArray[n11] + dArray[n13 + 1];
            d13 = dArray[n11 + 1] - dArray[n13];
            d14 = d18 * d6 - d19 * d7;
            d15 = d18 * d7 + d19 * d6;
            d2 = d3 * d10 - d4 * d11;
            d = d3 * d11 + d4 * d10;
            dArray[n4] = d14 + d2;
            dArray[n4 + 1] = d15 + d;
            dArray[n11] = d14 - d2;
            dArray[n11 + 1] = d15 - d;
            d14 = d20 * d8 + d21 * d9;
            d15 = d20 * d9 - d21 * d8;
            d2 = d17 * d12 + d16 * d13;
            d = d17 * d13 - d16 * d12;
            dArray[n12] = d14 + d2;
            dArray[n12 + 1] = d15 + d;
            dArray[n13] = d14 - d2;
            dArray[n13 + 1] = d15 - d;
        }
        d4 = dArray2[n3 + n7];
        d3 = dArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        d6 = dArray[n4] - dArray[n12 + 1];
        d7 = dArray[n4 + 1] + dArray[n12];
        d8 = dArray[n4] + dArray[n12 + 1];
        d9 = dArray[n4 + 1] - dArray[n12];
        d10 = dArray[n11] - dArray[n13 + 1];
        d11 = dArray[n11 + 1] + dArray[n13];
        d12 = dArray[n11] + dArray[n13 + 1];
        d13 = dArray[n11 + 1] - dArray[n13];
        d14 = d4 * d6 - d3 * d7;
        d15 = d4 * d7 + d3 * d6;
        d2 = d3 * d10 - d4 * d11;
        d = d3 * d11 + d4 * d10;
        dArray[n4] = d14 + d2;
        dArray[n4 + 1] = d15 + d;
        dArray[n11] = d14 - d2;
        dArray[n11 + 1] = d15 - d;
        d14 = d3 * d8 - d4 * d9;
        d15 = d3 * d9 + d4 * d8;
        d2 = d4 * d12 - d3 * d13;
        d = d4 * d13 + d3 * d12;
        dArray[n12] = d14 - d2;
        dArray[n12 + 1] = d15 - d;
        dArray[n13] = d14 + d2;
        dArray[n13 + 1] = d15 + d;
    }

    public static void cftmdl2(long l, A a, long l2, A a2, long l3) {
        long l4;
        long l5;
        double d;
        double d2;
        double d3;
        double d4;
        long l6 = l >> 3;
        long l7 = 2L * l6;
        double d5 = a2.E(l3 + 1L);
        long l8 = l7;
        long l9 = l8 + l7;
        long l10 = l9 + l7;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        double d6 = a.E(l2) - a.E(l12 + 1L);
        double d7 = a.E(l2 + 1L) + a.E(l12);
        double d8 = a.E(l2) + a.E(l12 + 1L);
        double d9 = a.E(l2 + 1L) - a.E(l12);
        double d10 = a.E(l11) - a.E(l13 + 1L);
        double d11 = a.E(l11 + 1L) + a.E(l13);
        double d12 = a.E(l11) + a.E(l13 + 1L);
        double d13 = a.E(l11 + 1L) - a.E(l13);
        double d14 = d5 * (d10 - d11);
        double d15 = d5 * (d11 + d10);
        a.B(l2, d6 + d14);
        a.B(l2 + 1L, d7 + d15);
        a.B(l11, d6 - d14);
        a.B(l11 + 1L, d7 - d15);
        d14 = d5 * (d12 - d13);
        d15 = d5 * (d13 + d12);
        a.B(l12, d8 - d15);
        a.B(l12 + 1L, d9 + d14);
        a.B(l13, d8 + d15);
        a.B(l13 + 1L, d9 - d14);
        long l14 = 0L;
        long l15 = 2L * l7;
        int n = 2;
        while ((long)n < l6) {
            long l16 = l3 + (l14 += 4L);
            d4 = a2.E(l16);
            d3 = a2.E(l16 + 1L);
            double d16 = a2.E(l16 + 2L);
            double d17 = a2.E(l16 + 3L);
            long l17 = l3 + (l15 -= 4L);
            double d18 = a2.E(l17);
            double d19 = a2.E(l17 + 1L);
            double d20 = a2.E(l17 + 2L);
            double d21 = a2.E(l17 + 3L);
            l8 = (long)n + l7;
            l9 = l8 + l7;
            l10 = l9 + l7;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l18 = l2 + (long)n;
            d6 = a.E(l18) - a.E(l12 + 1L);
            d7 = a.E(l18 + 1L) + a.E(l12);
            d8 = a.E(l18) + a.E(l12 + 1L);
            d9 = a.E(l18 + 1L) - a.E(l12);
            d10 = a.E(l11) - a.E(l13 + 1L);
            d11 = a.E(l11 + 1L) + a.E(l13);
            d12 = a.E(l11) + a.E(l13 + 1L);
            d13 = a.E(l11 + 1L) - a.E(l13);
            d14 = d4 * d6 - d3 * d7;
            d15 = d4 * d7 + d3 * d6;
            d2 = d19 * d10 - d18 * d11;
            d = d19 * d11 + d18 * d10;
            a.B(l18, d14 + d2);
            a.B(l18 + 1L, d15 + d);
            a.B(l11, d14 - d2);
            a.B(l11 + 1L, d15 - d);
            d14 = d16 * d8 + d17 * d9;
            d15 = d16 * d9 - d17 * d8;
            d2 = d21 * d12 + d20 * d13;
            d = d21 * d13 - d20 * d12;
            a.B(l12, d14 + d2);
            a.B(l12 + 1L, d15 + d);
            a.B(l13, d14 - d2);
            a.B(l13 + 1L, d15 - d);
            l5 = l7 - (long)n;
            l8 = l5 + l7;
            l9 = l8 + l7;
            l10 = l9 + l7;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            d6 = a.E(l4) - a.E(l12 + 1L);
            d7 = a.E(l4 + 1L) + a.E(l12);
            d8 = a.E(l4) + a.E(l12 + 1L);
            d9 = a.E(l4 + 1L) - a.E(l12);
            d10 = a.E(l11) - a.E(l13 + 1L);
            d11 = a.E(l11 + 1L) + a.E(l13);
            d12 = a.E(l11) + a.E(l13 + 1L);
            d13 = a.E(l11 + 1L) - a.E(l13);
            d14 = d18 * d6 - d19 * d7;
            d15 = d18 * d7 + d19 * d6;
            d2 = d3 * d10 - d4 * d11;
            d = d3 * d11 + d4 * d10;
            a.B(l4, d14 + d2);
            a.B(l4 + 1L, d15 + d);
            a.B(l11, d14 - d2);
            a.B(l11 + 1L, d15 - d);
            d14 = d20 * d8 + d21 * d9;
            d15 = d20 * d9 - d21 * d8;
            d2 = d17 * d12 + d16 * d13;
            d = d17 * d13 - d16 * d12;
            a.B(l12, d14 + d2);
            a.B(l12 + 1L, d15 + d);
            a.B(l13, d14 - d2);
            a.B(l13 + 1L, d15 - d);
            n += 2;
        }
        d4 = a2.E(l3 + l7);
        d3 = a2.E(l3 + l7 + 1L);
        l5 = l6;
        l8 = l5 + l7;
        l9 = l8 + l7;
        l10 = l9 + l7;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        d6 = a.E(l4) - a.E(l12 + 1L);
        d7 = a.E(l4 + 1L) + a.E(l12);
        d8 = a.E(l4) + a.E(l12 + 1L);
        d9 = a.E(l4 + 1L) - a.E(l12);
        d10 = a.E(l11) - a.E(l13 + 1L);
        d11 = a.E(l11 + 1L) + a.E(l13);
        d12 = a.E(l11) + a.E(l13 + 1L);
        d13 = a.E(l11 + 1L) - a.E(l13);
        d14 = d4 * d6 - d3 * d7;
        d15 = d4 * d7 + d3 * d6;
        d2 = d3 * d10 - d4 * d11;
        d = d3 * d11 + d4 * d10;
        a.B(l4, d14 + d2);
        a.B(l4 + 1L, d15 + d);
        a.B(l11, d14 - d2);
        a.B(l11 + 1L, d15 - d);
        d14 = d3 * d8 - d4 * d9;
        d15 = d3 * d9 + d4 * d8;
        d2 = d4 * d12 - d3 * d13;
        d = d4 * d13 + d3 * d12;
        a.B(l12, d14 - d2);
        a.B(l12 + 1L, d15 - d);
        a.B(l13, d14 + d2);
        a.B(l13 + 1L, d15 + d);
    }

    public static void cftfx41(int n, double[] dArray, int n2, int n3, double[] dArray2) {
        if (n == 128) {
            CommonUtils.cftf161(dArray, n2, dArray2, n3 - 8);
            CommonUtils.cftf162(dArray, n2 + 32, dArray2, n3 - 32);
            CommonUtils.cftf161(dArray, n2 + 64, dArray2, n3 - 8);
            CommonUtils.cftf161(dArray, n2 + 96, dArray2, n3 - 8);
        } else {
            CommonUtils.cftf081(dArray, n2, dArray2, n3 - 8);
            CommonUtils.cftf082(dArray, n2 + 16, dArray2, n3 - 8);
            CommonUtils.cftf081(dArray, n2 + 32, dArray2, n3 - 8);
            CommonUtils.cftf081(dArray, n2 + 48, dArray2, n3 - 8);
        }
    }

    public static void cftfx41(long l, A a, long l2, long l3, A a2) {
        if (l == 128L) {
            CommonUtils.cftf161(a, l2, a2, l3 - 8L);
            CommonUtils.cftf162(a, l2 + 32L, a2, l3 - 32L);
            CommonUtils.cftf161(a, l2 + 64L, a2, l3 - 8L);
            CommonUtils.cftf161(a, l2 + 96L, a2, l3 - 8L);
        } else {
            CommonUtils.cftf081(a, l2, a2, l3 - 8L);
            CommonUtils.cftf082(a, l2 + 16L, a2, l3 - 8L);
            CommonUtils.cftf081(a, l2 + 32L, a2, l3 - 8L);
            CommonUtils.cftf081(a, l2 + 48L, a2, l3 - 8L);
        }
    }

    public static void cftf161(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] + dArray[n + 16];
        double d5 = dArray[n + 1] + dArray[n + 17];
        double d6 = dArray[n] - dArray[n + 16];
        double d7 = dArray[n + 1] - dArray[n + 17];
        double d8 = dArray[n + 8] + dArray[n + 24];
        double d9 = dArray[n + 9] + dArray[n + 25];
        double d10 = dArray[n + 8] - dArray[n + 24];
        double d11 = dArray[n + 9] - dArray[n + 25];
        double d12 = d4 + d8;
        double d13 = d5 + d9;
        double d14 = d4 - d8;
        double d15 = d5 - d9;
        double d16 = d6 - d11;
        double d17 = d7 + d10;
        double d18 = d6 + d11;
        double d19 = d7 - d10;
        d4 = dArray[n + 2] + dArray[n + 18];
        d5 = dArray[n + 3] + dArray[n + 19];
        d6 = dArray[n + 2] - dArray[n + 18];
        d7 = dArray[n + 3] - dArray[n + 19];
        d8 = dArray[n + 10] + dArray[n + 26];
        d9 = dArray[n + 11] + dArray[n + 27];
        d10 = dArray[n + 10] - dArray[n + 26];
        d11 = dArray[n + 11] - dArray[n + 27];
        double d20 = d4 + d8;
        double d21 = d5 + d9;
        double d22 = d4 - d8;
        double d23 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d24 = d2 * d4 - d3 * d5;
        double d25 = d2 * d5 + d3 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d26 = d3 * d4 - d2 * d5;
        double d27 = d3 * d5 + d2 * d4;
        d4 = dArray[n + 4] + dArray[n + 20];
        d5 = dArray[n + 5] + dArray[n + 21];
        d6 = dArray[n + 4] - dArray[n + 20];
        d7 = dArray[n + 5] - dArray[n + 21];
        d8 = dArray[n + 12] + dArray[n + 28];
        d9 = dArray[n + 13] + dArray[n + 29];
        d10 = dArray[n + 12] - dArray[n + 28];
        d11 = dArray[n + 13] - dArray[n + 29];
        double d28 = d4 + d8;
        double d29 = d5 + d9;
        double d30 = d4 - d8;
        double d31 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d32 = d * (d4 - d5);
        double d33 = d * (d5 + d4);
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d34 = d * (d4 + d5);
        double d35 = d * (d5 - d4);
        d4 = dArray[n + 6] + dArray[n + 22];
        d5 = dArray[n + 7] + dArray[n + 23];
        d6 = dArray[n + 6] - dArray[n + 22];
        d7 = dArray[n + 7] - dArray[n + 23];
        d8 = dArray[n + 14] + dArray[n + 30];
        d9 = dArray[n + 15] + dArray[n + 31];
        d10 = dArray[n + 14] - dArray[n + 30];
        d11 = dArray[n + 15] - dArray[n + 31];
        double d36 = d4 + d8;
        double d37 = d5 + d9;
        double d38 = d4 - d8;
        double d39 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d40 = d3 * d4 - d2 * d5;
        double d41 = d3 * d5 + d2 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d42 = d2 * d4 - d3 * d5;
        double d43 = d2 * d5 + d3 * d4;
        d4 = d18 - d34;
        d5 = d19 - d35;
        d6 = d18 + d34;
        d7 = d19 + d35;
        d8 = d26 - d42;
        d9 = d27 - d43;
        d10 = d26 + d42;
        d11 = d27 + d43;
        dArray[n + 24] = d4 + d8;
        dArray[n + 25] = d5 + d9;
        dArray[n + 26] = d4 - d8;
        dArray[n + 27] = d5 - d9;
        dArray[n + 28] = d6 - d11;
        dArray[n + 29] = d7 + d10;
        dArray[n + 30] = d6 + d11;
        dArray[n + 31] = d7 - d10;
        d4 = d16 + d32;
        d5 = d17 + d33;
        d6 = d16 - d32;
        d7 = d17 - d33;
        d8 = d24 + d40;
        d9 = d25 + d41;
        d10 = d24 - d40;
        d11 = d25 - d41;
        dArray[n + 16] = d4 + d8;
        dArray[n + 17] = d5 + d9;
        dArray[n + 18] = d4 - d8;
        dArray[n + 19] = d5 - d9;
        dArray[n + 20] = d6 - d11;
        dArray[n + 21] = d7 + d10;
        dArray[n + 22] = d6 + d11;
        dArray[n + 23] = d7 - d10;
        d4 = d22 - d39;
        d5 = d23 + d38;
        d8 = d * (d4 - d5);
        d9 = d * (d5 + d4);
        d4 = d22 + d39;
        d5 = d23 - d38;
        d10 = d * (d4 - d5);
        d11 = d * (d5 + d4);
        d4 = d14 - d31;
        d5 = d15 + d30;
        d6 = d14 + d31;
        d7 = d15 - d30;
        dArray[n + 8] = d4 + d8;
        dArray[n + 9] = d5 + d9;
        dArray[n + 10] = d4 - d8;
        dArray[n + 11] = d5 - d9;
        dArray[n + 12] = d6 - d11;
        dArray[n + 13] = d7 + d10;
        dArray[n + 14] = d6 + d11;
        dArray[n + 15] = d7 - d10;
        d4 = d12 + d28;
        d5 = d13 + d29;
        d6 = d12 - d28;
        d7 = d13 - d29;
        d8 = d20 + d36;
        d9 = d21 + d37;
        d10 = d20 - d36;
        d11 = d21 - d37;
        dArray[n] = d4 + d8;
        dArray[n + 1] = d5 + d9;
        dArray[n + 2] = d4 - d8;
        dArray[n + 3] = d5 - d9;
        dArray[n + 4] = d6 - d11;
        dArray[n + 5] = d7 + d10;
        dArray[n + 6] = d6 + d11;
        dArray[n + 7] = d7 - d10;
    }

    public static void cftf161(A a, long l, A a2, long l2) {
        double d = a2.E(l2 + 1L);
        double d2 = a2.E(l2 + 2L);
        double d3 = a2.E(l2 + 3L);
        double d4 = a.E(l) + a.E(l + 16L);
        double d5 = a.E(l + 1L) + a.E(l + 17L);
        double d6 = a.E(l) - a.E(l + 16L);
        double d7 = a.E(l + 1L) - a.E(l + 17L);
        double d8 = a.E(l + 8L) + a.E(l + 24L);
        double d9 = a.E(l + 9L) + a.E(l + 25L);
        double d10 = a.E(l + 8L) - a.E(l + 24L);
        double d11 = a.E(l + 9L) - a.E(l + 25L);
        double d12 = d4 + d8;
        double d13 = d5 + d9;
        double d14 = d4 - d8;
        double d15 = d5 - d9;
        double d16 = d6 - d11;
        double d17 = d7 + d10;
        double d18 = d6 + d11;
        double d19 = d7 - d10;
        d4 = a.E(l + 2L) + a.E(l + 18L);
        d5 = a.E(l + 3L) + a.E(l + 19L);
        d6 = a.E(l + 2L) - a.E(l + 18L);
        d7 = a.E(l + 3L) - a.E(l + 19L);
        d8 = a.E(l + 10L) + a.E(l + 26L);
        d9 = a.E(l + 11L) + a.E(l + 27L);
        d10 = a.E(l + 10L) - a.E(l + 26L);
        d11 = a.E(l + 11L) - a.E(l + 27L);
        double d20 = d4 + d8;
        double d21 = d5 + d9;
        double d22 = d4 - d8;
        double d23 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d24 = d2 * d4 - d3 * d5;
        double d25 = d2 * d5 + d3 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d26 = d3 * d4 - d2 * d5;
        double d27 = d3 * d5 + d2 * d4;
        d4 = a.E(l + 4L) + a.E(l + 20L);
        d5 = a.E(l + 5L) + a.E(l + 21L);
        d6 = a.E(l + 4L) - a.E(l + 20L);
        d7 = a.E(l + 5L) - a.E(l + 21L);
        d8 = a.E(l + 12L) + a.E(l + 28L);
        d9 = a.E(l + 13L) + a.E(l + 29L);
        d10 = a.E(l + 12L) - a.E(l + 28L);
        d11 = a.E(l + 13L) - a.E(l + 29L);
        double d28 = d4 + d8;
        double d29 = d5 + d9;
        double d30 = d4 - d8;
        double d31 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d32 = d * (d4 - d5);
        double d33 = d * (d5 + d4);
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d34 = d * (d4 + d5);
        double d35 = d * (d5 - d4);
        d4 = a.E(l + 6L) + a.E(l + 22L);
        d5 = a.E(l + 7L) + a.E(l + 23L);
        d6 = a.E(l + 6L) - a.E(l + 22L);
        d7 = a.E(l + 7L) - a.E(l + 23L);
        d8 = a.E(l + 14L) + a.E(l + 30L);
        d9 = a.E(l + 15L) + a.E(l + 31L);
        d10 = a.E(l + 14L) - a.E(l + 30L);
        d11 = a.E(l + 15L) - a.E(l + 31L);
        double d36 = d4 + d8;
        double d37 = d5 + d9;
        double d38 = d4 - d8;
        double d39 = d5 - d9;
        d4 = d6 - d11;
        d5 = d7 + d10;
        double d40 = d3 * d4 - d2 * d5;
        double d41 = d3 * d5 + d2 * d4;
        d4 = d6 + d11;
        d5 = d7 - d10;
        double d42 = d2 * d4 - d3 * d5;
        double d43 = d2 * d5 + d3 * d4;
        d4 = d18 - d34;
        d5 = d19 - d35;
        d6 = d18 + d34;
        d7 = d19 + d35;
        d8 = d26 - d42;
        d9 = d27 - d43;
        d10 = d26 + d42;
        d11 = d27 + d43;
        a.B(l + 24L, d4 + d8);
        a.B(l + 25L, d5 + d9);
        a.B(l + 26L, d4 - d8);
        a.B(l + 27L, d5 - d9);
        a.B(l + 28L, d6 - d11);
        a.B(l + 29L, d7 + d10);
        a.B(l + 30L, d6 + d11);
        a.B(l + 31L, d7 - d10);
        d4 = d16 + d32;
        d5 = d17 + d33;
        d6 = d16 - d32;
        d7 = d17 - d33;
        d8 = d24 + d40;
        d9 = d25 + d41;
        d10 = d24 - d40;
        d11 = d25 - d41;
        a.B(l + 16L, d4 + d8);
        a.B(l + 17L, d5 + d9);
        a.B(l + 18L, d4 - d8);
        a.B(l + 19L, d5 - d9);
        a.B(l + 20L, d6 - d11);
        a.B(l + 21L, d7 + d10);
        a.B(l + 22L, d6 + d11);
        a.B(l + 23L, d7 - d10);
        d4 = d22 - d39;
        d5 = d23 + d38;
        d8 = d * (d4 - d5);
        d9 = d * (d5 + d4);
        d4 = d22 + d39;
        d5 = d23 - d38;
        d10 = d * (d4 - d5);
        d11 = d * (d5 + d4);
        d4 = d14 - d31;
        d5 = d15 + d30;
        d6 = d14 + d31;
        d7 = d15 - d30;
        a.B(l + 8L, d4 + d8);
        a.B(l + 9L, d5 + d9);
        a.B(l + 10L, d4 - d8);
        a.B(l + 11L, d5 - d9);
        a.B(l + 12L, d6 - d11);
        a.B(l + 13L, d7 + d10);
        a.B(l + 14L, d6 + d11);
        a.B(l + 15L, d7 - d10);
        d4 = d12 + d28;
        d5 = d13 + d29;
        d6 = d12 - d28;
        d7 = d13 - d29;
        d8 = d20 + d36;
        d9 = d21 + d37;
        d10 = d20 - d36;
        d11 = d21 - d37;
        a.B(l, d4 + d8);
        a.B(l + 1L, d5 + d9);
        a.B(l + 2L, d4 - d8);
        a.B(l + 3L, d5 - d9);
        a.B(l + 4L, d6 - d11);
        a.B(l + 5L, d7 + d10);
        a.B(l + 6L, d6 + d11);
        a.B(l + 7L, d7 - d10);
    }

    public static void cftf162(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 4];
        double d3 = dArray2[n2 + 5];
        double d4 = dArray2[n2 + 6];
        double d5 = -dArray2[n2 + 7];
        double d6 = dArray2[n2 + 8];
        double d7 = dArray2[n2 + 9];
        double d8 = dArray[n] - dArray[n + 17];
        double d9 = dArray[n + 1] + dArray[n + 16];
        double d10 = dArray[n + 8] - dArray[n + 25];
        double d11 = dArray[n + 9] + dArray[n + 24];
        double d12 = d * (d10 - d11);
        double d13 = d * (d11 + d10);
        double d14 = d8 + d12;
        double d15 = d9 + d13;
        double d16 = d8 - d12;
        double d17 = d9 - d13;
        d8 = dArray[n] + dArray[n + 17];
        d9 = dArray[n + 1] - dArray[n + 16];
        d10 = dArray[n + 8] + dArray[n + 25];
        d11 = dArray[n + 9] - dArray[n + 24];
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        double d18 = d8 - d13;
        double d19 = d9 + d12;
        double d20 = d8 + d13;
        double d21 = d9 - d12;
        d10 = dArray[n + 2] - dArray[n + 19];
        d11 = dArray[n + 3] + dArray[n + 18];
        d8 = d2 * d10 - d3 * d11;
        d9 = d2 * d11 + d3 * d10;
        d10 = dArray[n + 10] - dArray[n + 27];
        d11 = dArray[n + 11] + dArray[n + 26];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d22 = d8 + d12;
        double d23 = d9 + d13;
        double d24 = d8 - d12;
        double d25 = d9 - d13;
        d10 = dArray[n + 2] + dArray[n + 19];
        d11 = dArray[n + 3] - dArray[n + 18];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 10] + dArray[n + 27];
        d11 = dArray[n + 11] - dArray[n + 26];
        d12 = d2 * d10 + d3 * d11;
        d13 = d2 * d11 - d3 * d10;
        double d26 = d8 - d12;
        double d27 = d9 - d13;
        double d28 = d8 + d12;
        double d29 = d9 + d13;
        d10 = dArray[n + 4] - dArray[n + 21];
        d11 = dArray[n + 5] + dArray[n + 20];
        d8 = d6 * d10 - d7 * d11;
        d9 = d6 * d11 + d7 * d10;
        d10 = dArray[n + 12] - dArray[n + 29];
        d11 = dArray[n + 13] + dArray[n + 28];
        d12 = d7 * d10 - d6 * d11;
        d13 = d7 * d11 + d6 * d10;
        double d30 = d8 + d12;
        double d31 = d9 + d13;
        double d32 = d8 - d12;
        double d33 = d9 - d13;
        d10 = dArray[n + 4] + dArray[n + 21];
        d11 = dArray[n + 5] - dArray[n + 20];
        d8 = d7 * d10 - d6 * d11;
        d9 = d7 * d11 + d6 * d10;
        d10 = dArray[n + 12] + dArray[n + 29];
        d11 = dArray[n + 13] - dArray[n + 28];
        d12 = d6 * d10 - d7 * d11;
        d13 = d6 * d11 + d7 * d10;
        double d34 = d8 - d12;
        double d35 = d9 - d13;
        double d36 = d8 + d12;
        double d37 = d9 + d13;
        d10 = dArray[n + 6] - dArray[n + 23];
        d11 = dArray[n + 7] + dArray[n + 22];
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = dArray[n + 14] - dArray[n + 31];
        d11 = dArray[n + 15] + dArray[n + 30];
        d12 = d3 * d10 - d2 * d11;
        d13 = d3 * d11 + d2 * d10;
        double d38 = d8 + d12;
        double d39 = d9 + d13;
        double d40 = d8 - d12;
        double d41 = d9 - d13;
        d10 = dArray[n + 6] + dArray[n + 23];
        d11 = dArray[n + 7] - dArray[n + 22];
        d8 = d3 * d10 + d2 * d11;
        d9 = d3 * d11 - d2 * d10;
        d10 = dArray[n + 14] + dArray[n + 31];
        d11 = dArray[n + 15] - dArray[n + 30];
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d42 = d8 + d12;
        double d43 = d9 + d13;
        double d44 = d8 - d12;
        double d45 = d9 - d13;
        d8 = d14 + d30;
        d9 = d15 + d31;
        d12 = d22 + d38;
        d13 = d23 + d39;
        dArray[n] = d8 + d12;
        dArray[n + 1] = d9 + d13;
        dArray[n + 2] = d8 - d12;
        dArray[n + 3] = d9 - d13;
        d8 = d14 - d30;
        d9 = d15 - d31;
        d12 = d22 - d38;
        d13 = d23 - d39;
        dArray[n + 4] = d8 - d13;
        dArray[n + 5] = d9 + d12;
        dArray[n + 6] = d8 + d13;
        dArray[n + 7] = d9 - d12;
        d8 = d16 - d33;
        d9 = d17 + d32;
        d10 = d24 - d41;
        d11 = d25 + d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 8] = d8 + d12;
        dArray[n + 9] = d9 + d13;
        dArray[n + 10] = d8 - d12;
        dArray[n + 11] = d9 - d13;
        d8 = d16 + d33;
        d9 = d17 - d32;
        d10 = d24 + d41;
        d11 = d25 - d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 12] = d8 - d13;
        dArray[n + 13] = d9 + d12;
        dArray[n + 14] = d8 + d13;
        dArray[n + 15] = d9 - d12;
        d8 = d18 + d34;
        d9 = d19 + d35;
        d12 = d26 - d42;
        d13 = d27 - d43;
        dArray[n + 16] = d8 + d12;
        dArray[n + 17] = d9 + d13;
        dArray[n + 18] = d8 - d12;
        dArray[n + 19] = d9 - d13;
        d8 = d18 - d34;
        d9 = d19 - d35;
        d12 = d26 + d42;
        d13 = d27 + d43;
        dArray[n + 20] = d8 - d13;
        dArray[n + 21] = d9 + d12;
        dArray[n + 22] = d8 + d13;
        dArray[n + 23] = d9 - d12;
        d8 = d20 - d37;
        d9 = d21 + d36;
        d10 = d28 + d45;
        d11 = d29 - d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 24] = d8 + d12;
        dArray[n + 25] = d9 + d13;
        dArray[n + 26] = d8 - d12;
        dArray[n + 27] = d9 - d13;
        d8 = d20 + d37;
        d9 = d21 - d36;
        d10 = d28 - d45;
        d11 = d29 + d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        dArray[n + 28] = d8 - d13;
        dArray[n + 29] = d9 + d12;
        dArray[n + 30] = d8 + d13;
        dArray[n + 31] = d9 - d12;
    }

    public static void cftf162(A a, long l, A a2, long l2) {
        double d = a2.E(l2 + 1L);
        double d2 = a2.E(l2 + 4L);
        double d3 = a2.E(l2 + 5L);
        double d4 = a2.E(l2 + 6L);
        double d5 = -a2.E(l2 + 7L);
        double d6 = a2.E(l2 + 8L);
        double d7 = a2.E(l2 + 9L);
        double d8 = a.E(l) - a.E(l + 17L);
        double d9 = a.E(l + 1L) + a.E(l + 16L);
        double d10 = a.E(l + 8L) - a.E(l + 25L);
        double d11 = a.E(l + 9L) + a.E(l + 24L);
        double d12 = d * (d10 - d11);
        double d13 = d * (d11 + d10);
        double d14 = d8 + d12;
        double d15 = d9 + d13;
        double d16 = d8 - d12;
        double d17 = d9 - d13;
        d8 = a.E(l) + a.E(l + 17L);
        d9 = a.E(l + 1L) - a.E(l + 16L);
        d10 = a.E(l + 8L) + a.E(l + 25L);
        d11 = a.E(l + 9L) - a.E(l + 24L);
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        double d18 = d8 - d13;
        double d19 = d9 + d12;
        double d20 = d8 + d13;
        double d21 = d9 - d12;
        d10 = a.E(l + 2L) - a.E(l + 19L);
        d11 = a.E(l + 3L) + a.E(l + 18L);
        d8 = d2 * d10 - d3 * d11;
        d9 = d2 * d11 + d3 * d10;
        d10 = a.E(l + 10L) - a.E(l + 27L);
        d11 = a.E(l + 11L) + a.E(l + 26L);
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d22 = d8 + d12;
        double d23 = d9 + d13;
        double d24 = d8 - d12;
        double d25 = d9 - d13;
        d10 = a.E(l + 2L) + a.E(l + 19L);
        d11 = a.E(l + 3L) - a.E(l + 18L);
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = a.E(l + 10L) + a.E(l + 27L);
        d11 = a.E(l + 11L) - a.E(l + 26L);
        d12 = d2 * d10 + d3 * d11;
        d13 = d2 * d11 - d3 * d10;
        double d26 = d8 - d12;
        double d27 = d9 - d13;
        double d28 = d8 + d12;
        double d29 = d9 + d13;
        d10 = a.E(l + 4L) - a.E(l + 21L);
        d11 = a.E(l + 5L) + a.E(l + 20L);
        d8 = d6 * d10 - d7 * d11;
        d9 = d6 * d11 + d7 * d10;
        d10 = a.E(l + 12L) - a.E(l + 29L);
        d11 = a.E(l + 13L) + a.E(l + 28L);
        d12 = d7 * d10 - d6 * d11;
        d13 = d7 * d11 + d6 * d10;
        double d30 = d8 + d12;
        double d31 = d9 + d13;
        double d32 = d8 - d12;
        double d33 = d9 - d13;
        d10 = a.E(l + 4L) + a.E(l + 21L);
        d11 = a.E(l + 5L) - a.E(l + 20L);
        d8 = d7 * d10 - d6 * d11;
        d9 = d7 * d11 + d6 * d10;
        d10 = a.E(l + 12L) + a.E(l + 29L);
        d11 = a.E(l + 13L) - a.E(l + 28L);
        d12 = d6 * d10 - d7 * d11;
        d13 = d6 * d11 + d7 * d10;
        double d34 = d8 - d12;
        double d35 = d9 - d13;
        double d36 = d8 + d12;
        double d37 = d9 + d13;
        d10 = a.E(l + 6L) - a.E(l + 23L);
        d11 = a.E(l + 7L) + a.E(l + 22L);
        d8 = d4 * d10 - d5 * d11;
        d9 = d4 * d11 + d5 * d10;
        d10 = a.E(l + 14L) - a.E(l + 31L);
        d11 = a.E(l + 15L) + a.E(l + 30L);
        d12 = d3 * d10 - d2 * d11;
        d13 = d3 * d11 + d2 * d10;
        double d38 = d8 + d12;
        double d39 = d9 + d13;
        double d40 = d8 - d12;
        double d41 = d9 - d13;
        d10 = a.E(l + 6L) + a.E(l + 23L);
        d11 = a.E(l + 7L) - a.E(l + 22L);
        d8 = d3 * d10 + d2 * d11;
        d9 = d3 * d11 - d2 * d10;
        d10 = a.E(l + 14L) + a.E(l + 31L);
        d11 = a.E(l + 15L) - a.E(l + 30L);
        d12 = d5 * d10 - d4 * d11;
        d13 = d5 * d11 + d4 * d10;
        double d42 = d8 + d12;
        double d43 = d9 + d13;
        double d44 = d8 - d12;
        double d45 = d9 - d13;
        d8 = d14 + d30;
        d9 = d15 + d31;
        d12 = d22 + d38;
        d13 = d23 + d39;
        a.B(l, d8 + d12);
        a.B(l + 1L, d9 + d13);
        a.B(l + 2L, d8 - d12);
        a.B(l + 3L, d9 - d13);
        d8 = d14 - d30;
        d9 = d15 - d31;
        d12 = d22 - d38;
        d13 = d23 - d39;
        a.B(l + 4L, d8 - d13);
        a.B(l + 5L, d9 + d12);
        a.B(l + 6L, d8 + d13);
        a.B(l + 7L, d9 - d12);
        d8 = d16 - d33;
        d9 = d17 + d32;
        d10 = d24 - d41;
        d11 = d25 + d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        a.B(l + 8L, d8 + d12);
        a.B(l + 9L, d9 + d13);
        a.B(l + 10L, d8 - d12);
        a.B(l + 11L, d9 - d13);
        d8 = d16 + d33;
        d9 = d17 - d32;
        d10 = d24 + d41;
        d11 = d25 - d40;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        a.B(l + 12L, d8 - d13);
        a.B(l + 13L, d9 + d12);
        a.B(l + 14L, d8 + d13);
        a.B(l + 15L, d9 - d12);
        d8 = d18 + d34;
        d9 = d19 + d35;
        d12 = d26 - d42;
        d13 = d27 - d43;
        a.B(l + 16L, d8 + d12);
        a.B(l + 17L, d9 + d13);
        a.B(l + 18L, d8 - d12);
        a.B(l + 19L, d9 - d13);
        d8 = d18 - d34;
        d9 = d19 - d35;
        d12 = d26 + d42;
        d13 = d27 + d43;
        a.B(l + 20L, d8 - d13);
        a.B(l + 21L, d9 + d12);
        a.B(l + 22L, d8 + d13);
        a.B(l + 23L, d9 - d12);
        d8 = d20 - d37;
        d9 = d21 + d36;
        d10 = d28 + d45;
        d11 = d29 - d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        a.B(l + 24L, d8 + d12);
        a.B(l + 25L, d9 + d13);
        a.B(l + 26L, d8 - d12);
        a.B(l + 27L, d9 - d13);
        d8 = d20 + d37;
        d9 = d21 - d36;
        d10 = d28 - d45;
        d11 = d29 + d44;
        d12 = d * (d10 - d11);
        d13 = d * (d11 + d10);
        a.B(l + 28L, d8 - d13);
        a.B(l + 29L, d9 + d12);
        a.B(l + 30L, d8 + d13);
        a.B(l + 31L, d9 - d12);
    }

    public static void cftf081(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray[n] + dArray[n + 8];
        double d3 = dArray[n + 1] + dArray[n + 9];
        double d4 = dArray[n] - dArray[n + 8];
        double d5 = dArray[n + 1] - dArray[n + 9];
        double d6 = dArray[n + 4] + dArray[n + 12];
        double d7 = dArray[n + 5] + dArray[n + 13];
        double d8 = dArray[n + 4] - dArray[n + 12];
        double d9 = dArray[n + 5] - dArray[n + 13];
        double d10 = d2 + d6;
        double d11 = d3 + d7;
        double d12 = d2 - d6;
        double d13 = d3 - d7;
        double d14 = d4 - d9;
        double d15 = d5 + d8;
        double d16 = d4 + d9;
        double d17 = d5 - d8;
        d2 = dArray[n + 2] + dArray[n + 10];
        d3 = dArray[n + 3] + dArray[n + 11];
        d4 = dArray[n + 2] - dArray[n + 10];
        d5 = dArray[n + 3] - dArray[n + 11];
        d6 = dArray[n + 6] + dArray[n + 14];
        d7 = dArray[n + 7] + dArray[n + 15];
        d8 = dArray[n + 6] - dArray[n + 14];
        d9 = dArray[n + 7] - dArray[n + 15];
        double d18 = d2 + d6;
        double d19 = d3 + d7;
        double d20 = d2 - d6;
        double d21 = d3 - d7;
        d2 = d4 - d9;
        d3 = d5 + d8;
        d6 = d4 + d9;
        d7 = d5 - d8;
        double d22 = d * (d2 - d3);
        double d23 = d * (d2 + d3);
        double d24 = d * (d6 - d7);
        double d25 = d * (d6 + d7);
        dArray[n + 8] = d14 + d22;
        dArray[n + 9] = d15 + d23;
        dArray[n + 10] = d14 - d22;
        dArray[n + 11] = d15 - d23;
        dArray[n + 12] = d16 - d25;
        dArray[n + 13] = d17 + d24;
        dArray[n + 14] = d16 + d25;
        dArray[n + 15] = d17 - d24;
        dArray[n] = d10 + d18;
        dArray[n + 1] = d11 + d19;
        dArray[n + 2] = d10 - d18;
        dArray[n + 3] = d11 - d19;
        dArray[n + 4] = d12 - d21;
        dArray[n + 5] = d13 + d20;
        dArray[n + 6] = d12 + d21;
        dArray[n + 7] = d13 - d20;
    }

    public static void cftf081(A a, long l, A a2, long l2) {
        double d = a2.E(l2 + 1L);
        double d2 = a.E(l) + a.E(l + 8L);
        double d3 = a.E(l + 1L) + a.E(l + 9L);
        double d4 = a.E(l) - a.E(l + 8L);
        double d5 = a.E(l + 1L) - a.E(l + 9L);
        double d6 = a.E(l + 4L) + a.E(l + 12L);
        double d7 = a.E(l + 5L) + a.E(l + 13L);
        double d8 = a.E(l + 4L) - a.E(l + 12L);
        double d9 = a.E(l + 5L) - a.E(l + 13L);
        double d10 = d2 + d6;
        double d11 = d3 + d7;
        double d12 = d2 - d6;
        double d13 = d3 - d7;
        double d14 = d4 - d9;
        double d15 = d5 + d8;
        double d16 = d4 + d9;
        double d17 = d5 - d8;
        d2 = a.E(l + 2L) + a.E(l + 10L);
        d3 = a.E(l + 3L) + a.E(l + 11L);
        d4 = a.E(l + 2L) - a.E(l + 10L);
        d5 = a.E(l + 3L) - a.E(l + 11L);
        d6 = a.E(l + 6L) + a.E(l + 14L);
        d7 = a.E(l + 7L) + a.E(l + 15L);
        d8 = a.E(l + 6L) - a.E(l + 14L);
        d9 = a.E(l + 7L) - a.E(l + 15L);
        double d18 = d2 + d6;
        double d19 = d3 + d7;
        double d20 = d2 - d6;
        double d21 = d3 - d7;
        d2 = d4 - d9;
        d3 = d5 + d8;
        d6 = d4 + d9;
        d7 = d5 - d8;
        double d22 = d * (d2 - d3);
        double d23 = d * (d2 + d3);
        double d24 = d * (d6 - d7);
        double d25 = d * (d6 + d7);
        a.B(l + 8L, d14 + d22);
        a.B(l + 9L, d15 + d23);
        a.B(l + 10L, d14 - d22);
        a.B(l + 11L, d15 - d23);
        a.B(l + 12L, d16 - d25);
        a.B(l + 13L, d17 + d24);
        a.B(l + 14L, d16 + d25);
        a.B(l + 15L, d17 - d24);
        a.B(l, d10 + d18);
        a.B(l + 1L, d11 + d19);
        a.B(l + 2L, d10 - d18);
        a.B(l + 3L, d11 - d19);
        a.B(l + 4L, d12 - d21);
        a.B(l + 5L, d13 + d20);
        a.B(l + 6L, d12 + d21);
        a.B(l + 7L, d13 - d20);
    }

    public static void cftf082(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 1];
        double d2 = dArray2[n2 + 2];
        double d3 = dArray2[n2 + 3];
        double d4 = dArray[n] - dArray[n + 9];
        double d5 = dArray[n + 1] + dArray[n + 8];
        double d6 = dArray[n] + dArray[n + 9];
        double d7 = dArray[n + 1] - dArray[n + 8];
        double d8 = dArray[n + 4] - dArray[n + 13];
        double d9 = dArray[n + 5] + dArray[n + 12];
        double d10 = d * (d8 - d9);
        double d11 = d * (d9 + d8);
        d8 = dArray[n + 4] + dArray[n + 13];
        d9 = dArray[n + 5] - dArray[n + 12];
        double d12 = d * (d8 - d9);
        double d13 = d * (d9 + d8);
        d8 = dArray[n + 2] - dArray[n + 11];
        d9 = dArray[n + 3] + dArray[n + 10];
        double d14 = d2 * d8 - d3 * d9;
        double d15 = d2 * d9 + d3 * d8;
        d8 = dArray[n + 2] + dArray[n + 11];
        d9 = dArray[n + 3] - dArray[n + 10];
        double d16 = d3 * d8 - d2 * d9;
        double d17 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] - dArray[n + 15];
        d9 = dArray[n + 7] + dArray[n + 14];
        double d18 = d3 * d8 - d2 * d9;
        double d19 = d3 * d9 + d2 * d8;
        d8 = dArray[n + 6] + dArray[n + 15];
        d9 = dArray[n + 7] - dArray[n + 14];
        double d20 = d2 * d8 - d3 * d9;
        double d21 = d2 * d9 + d3 * d8;
        d8 = d4 + d10;
        d9 = d5 + d11;
        double d22 = d14 + d18;
        double d23 = d15 + d19;
        dArray[n] = d8 + d22;
        dArray[n + 1] = d9 + d23;
        dArray[n + 2] = d8 - d22;
        dArray[n + 3] = d9 - d23;
        d8 = d4 - d10;
        d9 = d5 - d11;
        d22 = d14 - d18;
        d23 = d15 - d19;
        dArray[n + 4] = d8 - d23;
        dArray[n + 5] = d9 + d22;
        dArray[n + 6] = d8 + d23;
        dArray[n + 7] = d9 - d22;
        d8 = d6 - d13;
        d9 = d7 + d12;
        d22 = d16 - d20;
        d23 = d17 - d21;
        dArray[n + 8] = d8 + d22;
        dArray[n + 9] = d9 + d23;
        dArray[n + 10] = d8 - d22;
        dArray[n + 11] = d9 - d23;
        d8 = d6 + d13;
        d9 = d7 - d12;
        d22 = d16 + d20;
        d23 = d17 + d21;
        dArray[n + 12] = d8 - d23;
        dArray[n + 13] = d9 + d22;
        dArray[n + 14] = d8 + d23;
        dArray[n + 15] = d9 - d22;
    }

    public static void cftf082(A a, long l, A a2, long l2) {
        double d = a2.E(l2 + 1L);
        double d2 = a2.E(l2 + 2L);
        double d3 = a2.E(l2 + 3L);
        double d4 = a.E(l) - a.E(l + 9L);
        double d5 = a.E(l + 1L) + a.E(l + 8L);
        double d6 = a.E(l) + a.E(l + 9L);
        double d7 = a.E(l + 1L) - a.E(l + 8L);
        double d8 = a.E(l + 4L) - a.E(l + 13L);
        double d9 = a.E(l + 5L) + a.E(l + 12L);
        double d10 = d * (d8 - d9);
        double d11 = d * (d9 + d8);
        d8 = a.E(l + 4L) + a.E(l + 13L);
        d9 = a.E(l + 5L) - a.E(l + 12L);
        double d12 = d * (d8 - d9);
        double d13 = d * (d9 + d8);
        d8 = a.E(l + 2L) - a.E(l + 11L);
        d9 = a.E(l + 3L) + a.E(l + 10L);
        double d14 = d2 * d8 - d3 * d9;
        double d15 = d2 * d9 + d3 * d8;
        d8 = a.E(l + 2L) + a.E(l + 11L);
        d9 = a.E(l + 3L) - a.E(l + 10L);
        double d16 = d3 * d8 - d2 * d9;
        double d17 = d3 * d9 + d2 * d8;
        d8 = a.E(l + 6L) - a.E(l + 15L);
        d9 = a.E(l + 7L) + a.E(l + 14L);
        double d18 = d3 * d8 - d2 * d9;
        double d19 = d3 * d9 + d2 * d8;
        d8 = a.E(l + 6L) + a.E(l + 15L);
        d9 = a.E(l + 7L) - a.E(l + 14L);
        double d20 = d2 * d8 - d3 * d9;
        double d21 = d2 * d9 + d3 * d8;
        d8 = d4 + d10;
        d9 = d5 + d11;
        double d22 = d14 + d18;
        double d23 = d15 + d19;
        a.B(l, d8 + d22);
        a.B(l + 1L, d9 + d23);
        a.B(l + 2L, d8 - d22);
        a.B(l + 3L, d9 - d23);
        d8 = d4 - d10;
        d9 = d5 - d11;
        d22 = d14 - d18;
        d23 = d15 - d19;
        a.B(l + 4L, d8 - d23);
        a.B(l + 5L, d9 + d22);
        a.B(l + 6L, d8 + d23);
        a.B(l + 7L, d9 - d22);
        d8 = d6 - d13;
        d9 = d7 + d12;
        d22 = d16 - d20;
        d23 = d17 - d21;
        a.B(l + 8L, d8 + d22);
        a.B(l + 9L, d9 + d23);
        a.B(l + 10L, d8 - d22);
        a.B(l + 11L, d9 - d23);
        d8 = d6 + d13;
        d9 = d7 - d12;
        d22 = d16 + d20;
        d23 = d17 + d21;
        a.B(l + 12L, d8 - d23);
        a.B(l + 13L, d9 + d22);
        a.B(l + 14L, d8 + d23);
        a.B(l + 15L, d9 - d22);
    }

    public static void cftf040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 - d8;
        dArray[n + 3] = d4 + d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 + d8;
        dArray[n + 7] = d4 - d7;
    }

    public static void cftf040(A a, long l) {
        double d = a.E(l) + a.E(l + 4L);
        double d2 = a.E(l + 1L) + a.E(l + 5L);
        double d3 = a.E(l) - a.E(l + 4L);
        double d4 = a.E(l + 1L) - a.E(l + 5L);
        double d5 = a.E(l + 2L) + a.E(l + 6L);
        double d6 = a.E(l + 3L) + a.E(l + 7L);
        double d7 = a.E(l + 2L) - a.E(l + 6L);
        double d8 = a.E(l + 3L) - a.E(l + 7L);
        a.B(l, d + d5);
        a.B(l + 1L, d2 + d6);
        a.B(l + 2L, d3 - d8);
        a.B(l + 3L, d4 + d7);
        a.B(l + 4L, d - d5);
        a.B(l + 5L, d2 - d6);
        a.B(l + 6L, d3 + d8);
        a.B(l + 7L, d4 - d7);
    }

    public static void cftb040(double[] dArray, int n) {
        double d = dArray[n] + dArray[n + 4];
        double d2 = dArray[n + 1] + dArray[n + 5];
        double d3 = dArray[n] - dArray[n + 4];
        double d4 = dArray[n + 1] - dArray[n + 5];
        double d5 = dArray[n + 2] + dArray[n + 6];
        double d6 = dArray[n + 3] + dArray[n + 7];
        double d7 = dArray[n + 2] - dArray[n + 6];
        double d8 = dArray[n + 3] - dArray[n + 7];
        dArray[n] = d + d5;
        dArray[n + 1] = d2 + d6;
        dArray[n + 2] = d3 + d8;
        dArray[n + 3] = d4 - d7;
        dArray[n + 4] = d - d5;
        dArray[n + 5] = d2 - d6;
        dArray[n + 6] = d3 - d8;
        dArray[n + 7] = d4 + d7;
    }

    public static void cftb040(A a, long l) {
        double d = a.E(l) + a.E(l + 4L);
        double d2 = a.E(l + 1L) + a.E(l + 5L);
        double d3 = a.E(l) - a.E(l + 4L);
        double d4 = a.E(l + 1L) - a.E(l + 5L);
        double d5 = a.E(l + 2L) + a.E(l + 6L);
        double d6 = a.E(l + 3L) + a.E(l + 7L);
        double d7 = a.E(l + 2L) - a.E(l + 6L);
        double d8 = a.E(l + 3L) - a.E(l + 7L);
        a.B(l, d + d5);
        a.B(l + 1L, d2 + d6);
        a.B(l + 2L, d3 + d8);
        a.B(l + 3L, d4 - d7);
        a.B(l + 4L, d - d5);
        a.B(l + 5L, d2 - d6);
        a.B(l + 6L, d3 - d8);
        a.B(l + 7L, d4 + d7);
    }

    public static void cftx020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = -dArray[n + 1] + dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] + dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    public static void cftx020(A a, long l) {
        double d = a.E(l) - a.E(l + 2L);
        double d2 = -a.E(l + 1L) + a.E(l + 3L);
        a.B(l, a.E(l) + a.E(l + 2L));
        a.B(l + 1L, a.E(l + 1L) + a.E(l + 3L));
        a.B(l + 2L, d);
        a.B(l + 3L, d2);
    }

    public static void cftxb020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = dArray[n + 1] - dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] + dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    public static void cftxb020(A a, long l) {
        double d = a.E(l) - a.E(l + 2L);
        double d2 = a.E(l + 1L) - a.E(l + 3L);
        a.B(l, a.E(l) + a.E(l + 2L));
        a.B(l + 1L, a.E(l + 1L) + a.E(l + 3L));
        a.B(l + 2L, d);
        a.B(l + 3L, d2);
    }

    public static void cftxc020(double[] dArray, int n) {
        double d = dArray[n] - dArray[n + 2];
        double d2 = dArray[n + 1] + dArray[n + 3];
        int n2 = n;
        dArray[n2] = dArray[n2] + dArray[n + 2];
        int n3 = n + 1;
        dArray[n3] = dArray[n3] - dArray[n + 3];
        dArray[n + 2] = d;
        dArray[n + 3] = d2;
    }

    public static void cftxc020(A a, long l) {
        double d = a.E(l) - a.E(l + 2L);
        double d2 = a.E(l + 1L) + a.E(l + 3L);
        a.B(l, a.E(l) + a.E(l + 2L));
        a.B(l + 1L, a.E(l + 1L) - a.E(l + 3L));
        a.B(l + 2L, d);
        a.B(l + 3L, d2);
    }

    public static void rftfsub(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            double d = 0.5 - dArray2[n4 + n3 - (n7 += n6)];
            double d2 = dArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            double d3 = dArray[n9] - dArray[n10];
            double d4 = dArray[n9 + 1] + dArray[n10 + 1];
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            int n11 = n9;
            dArray[n11] = dArray[n11] - d5;
            dArray[n9 + 1] = d6 - dArray[n9 + 1];
            int n12 = n10;
            dArray[n12] = dArray[n12] + d5;
            dArray[n10 + 1] = d6 - dArray[n10 + 1];
        }
        dArray[n2 + n5 + 1] = -dArray[n2 + n5 + 1];
    }

    public static void rftfsub(long l, A a, long l2, long l3, A a2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            double d = 0.5 - a2.E(l4 + l3 - (l7 += l6));
            double d2 = a2.E(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            double d3 = a.E(l9) - a.E(l10);
            double d4 = a.E(l9 + 1L) + a.E(l10 + 1L);
            double d5 = d * d3 - d2 * d4;
            double d6 = d * d4 + d2 * d3;
            a.B(l9, a.E(l9) - d5);
            a.B(l9 + 1L, d6 - a.E(l9 + 1L));
            a.B(l10, a.E(l10) + d5);
            a.B(l10 + 1L, d6 - a.E(l10 + 1L));
        }
        a.B(l2 + l5 + 1L, -a.E(l2 + l5 + 1L));
    }

    public static void cftfsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                CommonUtils.cftf1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (F.A() > 1 && (long)n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    CommonUtils.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    CommonUtils.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    CommonUtils.cftfx41(n, fArray, n2, n3, fArray2);
                }
                CommonUtils.bitrv2(n, nArray, fArray, n2);
            } else if (n == 32) {
                CommonUtils.cftf161(fArray, n2, fArray2, n3 - 8);
                CommonUtils.bitrv216(fArray, n2);
            } else {
                CommonUtils.cftf081(fArray, n2, fArray2, 0);
                CommonUtils.bitrv208(fArray, n2);
            }
        } else if (n == 8) {
            CommonUtils.cftf040(fArray, n2);
        } else if (n == 4) {
            CommonUtils.cftxb020(fArray, n2);
        }
    }

    public static void cftfsub(long l, D d, long l2, G g, long l3, D d2) {
        if (l > 8L) {
            if (l > 32L) {
                CommonUtils.cftf1st(l, d, l2, d2, l3 - (l >> 2));
                if (F.A() > 1 && l >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(l, d, l2, l3, d2);
                } else if (l > 512L) {
                    CommonUtils.cftrec4(l, d, l2, l3, d2);
                } else if (l > 128L) {
                    CommonUtils.cftleaf(l, 1L, d, l2, l3, d2);
                } else {
                    CommonUtils.cftfx41(l, d, l2, l3, d2);
                }
                CommonUtils.bitrv2l(l, g, d, l2);
            } else if (l == 32L) {
                CommonUtils.cftf161(d, l2, d2, l3 - 8L);
                CommonUtils.bitrv216(d, l2);
            } else {
                CommonUtils.cftf081(d, l2, d2, 0L);
                CommonUtils.bitrv208(d, l2);
            }
        } else if (l == 8L) {
            CommonUtils.cftf040(d, l2);
        } else if (l == 4L) {
            CommonUtils.cftxb020(d, l2);
        }
    }

    public static void cftbsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                CommonUtils.cftb1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (F.A() > 1 && (long)n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    CommonUtils.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    CommonUtils.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    CommonUtils.cftfx41(n, fArray, n2, n3, fArray2);
                }
                CommonUtils.bitrv2conj(n, nArray, fArray, n2);
            } else if (n == 32) {
                CommonUtils.cftf161(fArray, n2, fArray2, n3 - 8);
                CommonUtils.bitrv216neg(fArray, n2);
            } else {
                CommonUtils.cftf081(fArray, n2, fArray2, 0);
                CommonUtils.bitrv208neg(fArray, n2);
            }
        } else if (n == 8) {
            CommonUtils.cftb040(fArray, n2);
        } else if (n == 4) {
            CommonUtils.cftxb020(fArray, n2);
        }
    }

    public static void cftbsub(long l, D d, long l2, G g, long l3, D d2) {
        if (l > 8L) {
            if (l > 32L) {
                CommonUtils.cftb1st(l, d, l2, d2, l3 - (l >> 2));
                if (F.A() > 1 && l >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    CommonUtils.cftrec4_th(l, d, l2, l3, d2);
                } else if (l > 512L) {
                    CommonUtils.cftrec4(l, d, l2, l3, d2);
                } else if (l > 128L) {
                    CommonUtils.cftleaf(l, 1L, d, l2, l3, d2);
                } else {
                    CommonUtils.cftfx41(l, d, l2, l3, d2);
                }
                CommonUtils.bitrv2conj(l, g, d, l2);
            } else if (l == 32L) {
                CommonUtils.cftf161(d, l2, d2, l3 - 8L);
                CommonUtils.bitrv216neg(d, l2);
            } else {
                CommonUtils.cftf081(d, l2, d2, 0L);
                CommonUtils.bitrv208neg(d, l2);
            }
        } else if (l == 8L) {
            CommonUtils.cftb040(d, l2);
        } else if (l == 4L) {
            CommonUtils.cftxb020(d, l2);
        }
    }

    public static void bitrv2(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                f7 = fArray[n13];
                f6 = fArray[n13 + 1];
                f5 = fArray[n12];
                f = fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                f7 = fArray[n13];
                f6 = fArray[n13 + 1];
                f5 = fArray[n12];
                f = fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
            }
        }
    }

    public static void bitrv2l(long l, G g, D d, long l2) {
        long l3;
        long l4 = 1L;
        for (l3 = l >> 2; l3 > 8L; l3 >>= 2) {
            l4 <<= 1;
        }
        long l5 = l >> 1;
        long l6 = 4L * l4;
        if (l3 == 8L) {
            for (long i = 0L; i < l4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l10 = 4L * j + 2L * g.D(l4 + i);
                    l9 = l11 + 2L * g.D(l4 + j);
                    l8 = l2 + l10;
                    l7 = l2 + l9;
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l5);
                    l7 = l2 + (l9 += 2L);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += 2L);
                    l7 = l2 + (l9 += l5);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l5);
                    l7 = l2 + (l9 -= 2L);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                }
                l9 = l11 + 2L * g.D(l4 + i);
                l10 = l9 + 2L;
                l8 = l2 + l10;
                l7 = l2 + (l9 += l5);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 += 2L * l6);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 -= l6);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 -= 2L);
                l7 = l2 + (l9 -= l5);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 += l5 + 2L);
                l7 = l2 + (l9 += l5 + 2L);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 -= l5 - l6);
                l7 = l2 + (l9 += 2L * l6 - 2L);
                f4 = d.C(l8);
                f3 = d.C(l8 + 1L);
                f2 = d.C(l7);
                f = d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
            }
        } else {
            for (long i = 0L; i < l4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                long l12;
                long l13;
                long l14;
                long l15;
                long l16 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l15 = 4L * j + g.D(l4 + i);
                    l14 = l16 + g.D(l4 + j);
                    l13 = l2 + l15;
                    l12 = l2 + l14;
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l5);
                    l12 = l2 + (l14 += 2L);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += 2L);
                    l12 = l2 + (l14 += l5);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l5);
                    l12 = l2 + (l14 -= 2L);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    f7 = d.C(l13);
                    f6 = d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                }
                l14 = l16 + g.D(l4 + i);
                l15 = l14 + 2L;
                l13 = l2 + l15;
                l12 = l2 + (l14 += l5);
                f7 = d.C(l13);
                f6 = d.C(l13 + 1L);
                f5 = d.C(l12);
                f = d.C(l12 + 1L);
                d.A(l13, f5);
                d.A(l13 + 1L, f);
                d.A(l12, f7);
                d.A(l12 + 1L, f6);
                l13 = l2 + (l15 += l6);
                l12 = l2 + (l14 += l6);
                f7 = d.C(l13);
                f6 = d.C(l13 + 1L);
                f5 = d.C(l12);
                f = d.C(l12 + 1L);
                d.A(l13, f5);
                d.A(l13 + 1L, f);
                d.A(l12, f7);
                d.A(l12 + 1L, f6);
            }
        }
    }

    public static void bitrv2conj(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                fArray[n13 - 1] = -fArray[n13 - 1];
                f7 = fArray[n13];
                f6 = -fArray[n13 + 1];
                f5 = fArray[n12];
                f = -fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                fArray[n12 + 3] = -fArray[n12 + 3];
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                fArray[n13 - 1] = -fArray[n13 - 1];
                f7 = fArray[n13];
                f6 = -fArray[n13 + 1];
                f5 = fArray[n12];
                f = -fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                fArray[n12 + 3] = -fArray[n12 + 3];
            }
        }
    }

    public static void bitrv2conj(long l, G g, D d, long l2) {
        long l3;
        long l4 = 1L;
        for (l3 = l >> 2; l3 > 8L; l3 >>= 2) {
            l4 <<= 1;
        }
        long l5 = l >> 1;
        long l6 = 4L * l4;
        if (l3 == 8L) {
            for (long i = 0L; i < l4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                long l7;
                long l8;
                long l9;
                long l10;
                long l11 = 4L * i;
                for (long j = 0L; j < i; ++j) {
                    l10 = 4L * j + 2L * g.D(l4 + i);
                    l9 = l11 + 2L * g.D(l4 + j);
                    l8 = l2 + l10;
                    l7 = l2 + l9;
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l5);
                    l7 = l2 + (l9 += 2L);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += 2L);
                    l7 = l2 + (l9 += l5);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 -= l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 += l6);
                    l7 = l2 + (l9 += 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l5);
                    l7 = l2 + (l9 -= 2L);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 += l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                    l8 = l2 + (l10 -= l6);
                    l7 = l2 + (l9 -= 2L * l6);
                    f4 = d.C(l8);
                    f3 = -d.C(l8 + 1L);
                    f2 = d.C(l7);
                    f = -d.C(l7 + 1L);
                    d.A(l8, f2);
                    d.A(l8 + 1L, f);
                    d.A(l7, f4);
                    d.A(l7 + 1L, f3);
                }
                l9 = l11 + 2L * g.D(l4 + i);
                l10 = l9 + 2L;
                l8 = l2 + l10;
                l7 = l2 + (l9 += l5);
                d.A(l8 - 1L, -d.C(l8 - 1L));
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                d.A(l7 + 3L, -d.C(l7 + 3L));
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 += 2L * l6);
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 += l6);
                l7 = l2 + (l9 -= l6);
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 -= 2L);
                l7 = l2 + (l9 -= l5);
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 += l5 + 2L);
                l7 = l2 + (l9 += l5 + 2L);
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                l8 = l2 + (l10 -= l5 - l6);
                l7 = l2 + (l9 += 2L * l6 - 2L);
                d.A(l8 - 1L, -d.C(l8 - 1L));
                f4 = d.C(l8);
                f3 = -d.C(l8 + 1L);
                f2 = d.C(l7);
                f = -d.C(l7 + 1L);
                d.A(l8, f2);
                d.A(l8 + 1L, f);
                d.A(l7, f4);
                d.A(l7 + 1L, f3);
                d.A(l7 + 3L, -d.C(l7 + 3L));
            }
        } else {
            int n = 0;
            while ((long)n < l4) {
                float f;
                float f5;
                float f6;
                float f7;
                long l12;
                long l13;
                long l14;
                long l15;
                long l16 = 4 * n;
                for (int i = 0; i < n; ++i) {
                    l15 = (long)(4 * i) + g.D(l4 + (long)n);
                    l14 = l16 + g.D(l4 + (long)i);
                    l13 = l2 + l15;
                    l12 = l2 + l14;
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l5);
                    l12 = l2 + (l14 += 2L);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += 2L);
                    l12 = l2 + (l14 += l5);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 += l6);
                    l12 = l2 + (l14 += l6);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l5);
                    l12 = l2 + (l14 -= 2L);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                    l13 = l2 + (l15 -= l6);
                    l12 = l2 + (l14 -= l6);
                    f7 = d.C(l13);
                    f6 = -d.C(l13 + 1L);
                    f5 = d.C(l12);
                    f = -d.C(l12 + 1L);
                    d.A(l13, f5);
                    d.A(l13 + 1L, f);
                    d.A(l12, f7);
                    d.A(l12 + 1L, f6);
                }
                l14 = l16 + g.D(l4 + (long)n);
                l15 = l14 + 2L;
                l13 = l2 + l15;
                l12 = l2 + (l14 += l5);
                d.A(l13 - 1L, -d.C(l13 - 1L));
                f7 = d.C(l13);
                f6 = -d.C(l13 + 1L);
                f5 = d.C(l12);
                f = -d.C(l12 + 1L);
                d.A(l13, f5);
                d.A(l13 + 1L, f);
                d.A(l12, f7);
                d.A(l12 + 1L, f6);
                d.A(l12 + 3L, -d.C(l12 + 3L));
                l13 = l2 + (l15 += l6);
                l12 = l2 + (l14 += l6);
                d.A(l13 - 1L, -d.C(l13 - 1L));
                f7 = d.C(l13);
                f6 = -d.C(l13 + 1L);
                f5 = d.C(l12);
                f = -d.C(l12 + 1L);
                d.A(l13, f5);
                d.A(l13 + 1L, f);
                d.A(l12, f7);
                d.A(l12 + 1L, f6);
                d.A(l12 + 3L, -d.C(l12 + 3L));
                ++n;
            }
        }
    }

    public static void bitrv216(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 14];
        float f12 = fArray[n + 15];
        float f13 = fArray[n + 16];
        float f14 = fArray[n + 17];
        float f15 = fArray[n + 20];
        float f16 = fArray[n + 21];
        float f17 = fArray[n + 22];
        float f18 = fArray[n + 23];
        float f19 = fArray[n + 24];
        float f20 = fArray[n + 25];
        float f21 = fArray[n + 26];
        float f22 = fArray[n + 27];
        float f23 = fArray[n + 28];
        float f24 = fArray[n + 29];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f7;
        fArray[n + 5] = f8;
        fArray[n + 6] = f19;
        fArray[n + 7] = f20;
        fArray[n + 8] = f3;
        fArray[n + 9] = f4;
        fArray[n + 10] = f15;
        fArray[n + 11] = f16;
        fArray[n + 14] = f23;
        fArray[n + 15] = f24;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 20] = f9;
        fArray[n + 21] = f10;
        fArray[n + 22] = f21;
        fArray[n + 23] = f22;
        fArray[n + 24] = f5;
        fArray[n + 25] = f6;
        fArray[n + 26] = f17;
        fArray[n + 27] = f18;
        fArray[n + 28] = f11;
        fArray[n + 29] = f12;
    }

    public static void bitrv216(D d, long l) {
        float f = d.C(l + 2L);
        float f2 = d.C(l + 3L);
        float f3 = d.C(l + 4L);
        float f4 = d.C(l + 5L);
        float f5 = d.C(l + 6L);
        float f6 = d.C(l + 7L);
        float f7 = d.C(l + 8L);
        float f8 = d.C(l + 9L);
        float f9 = d.C(l + 10L);
        float f10 = d.C(l + 11L);
        float f11 = d.C(l + 14L);
        float f12 = d.C(l + 15L);
        float f13 = d.C(l + 16L);
        float f14 = d.C(l + 17L);
        float f15 = d.C(l + 20L);
        float f16 = d.C(l + 21L);
        float f17 = d.C(l + 22L);
        float f18 = d.C(l + 23L);
        float f19 = d.C(l + 24L);
        float f20 = d.C(l + 25L);
        float f21 = d.C(l + 26L);
        float f22 = d.C(l + 27L);
        float f23 = d.C(l + 28L);
        float f24 = d.C(l + 29L);
        d.A(l + 2L, f13);
        d.A(l + 3L, f14);
        d.A(l + 4L, f7);
        d.A(l + 5L, f8);
        d.A(l + 6L, f19);
        d.A(l + 7L, f20);
        d.A(l + 8L, f3);
        d.A(l + 9L, f4);
        d.A(l + 10L, f15);
        d.A(l + 11L, f16);
        d.A(l + 14L, f23);
        d.A(l + 15L, f24);
        d.A(l + 16L, f);
        d.A(l + 17L, f2);
        d.A(l + 20L, f9);
        d.A(l + 21L, f10);
        d.A(l + 22L, f21);
        d.A(l + 23L, f22);
        d.A(l + 24L, f5);
        d.A(l + 25L, f6);
        d.A(l + 26L, f17);
        d.A(l + 27L, f18);
        d.A(l + 28L, f11);
        d.A(l + 29L, f12);
    }

    public static void bitrv216neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        float f15 = fArray[n + 16];
        float f16 = fArray[n + 17];
        float f17 = fArray[n + 18];
        float f18 = fArray[n + 19];
        float f19 = fArray[n + 20];
        float f20 = fArray[n + 21];
        float f21 = fArray[n + 22];
        float f22 = fArray[n + 23];
        float f23 = fArray[n + 24];
        float f24 = fArray[n + 25];
        float f25 = fArray[n + 26];
        float f26 = fArray[n + 27];
        float f27 = fArray[n + 28];
        float f28 = fArray[n + 29];
        float f29 = fArray[n + 30];
        float f30 = fArray[n + 31];
        fArray[n + 2] = f29;
        fArray[n + 3] = f30;
        fArray[n + 4] = f13;
        fArray[n + 5] = f14;
        fArray[n + 6] = f21;
        fArray[n + 7] = f22;
        fArray[n + 8] = f5;
        fArray[n + 9] = f6;
        fArray[n + 10] = f25;
        fArray[n + 11] = f26;
        fArray[n + 12] = f9;
        fArray[n + 13] = f10;
        fArray[n + 14] = f17;
        fArray[n + 15] = f18;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 18] = f27;
        fArray[n + 19] = f28;
        fArray[n + 20] = f11;
        fArray[n + 21] = f12;
        fArray[n + 22] = f19;
        fArray[n + 23] = f20;
        fArray[n + 24] = f3;
        fArray[n + 25] = f4;
        fArray[n + 26] = f23;
        fArray[n + 27] = f24;
        fArray[n + 28] = f7;
        fArray[n + 29] = f8;
        fArray[n + 30] = f15;
        fArray[n + 31] = f16;
    }

    public static void bitrv216neg(D d, long l) {
        float f = d.C(l + 2L);
        float f2 = d.C(l + 3L);
        float f3 = d.C(l + 4L);
        float f4 = d.C(l + 5L);
        float f5 = d.C(l + 6L);
        float f6 = d.C(l + 7L);
        float f7 = d.C(l + 8L);
        float f8 = d.C(l + 9L);
        float f9 = d.C(l + 10L);
        float f10 = d.C(l + 11L);
        float f11 = d.C(l + 12L);
        float f12 = d.C(l + 13L);
        float f13 = d.C(l + 14L);
        float f14 = d.C(l + 15L);
        float f15 = d.C(l + 16L);
        float f16 = d.C(l + 17L);
        float f17 = d.C(l + 18L);
        float f18 = d.C(l + 19L);
        float f19 = d.C(l + 20L);
        float f20 = d.C(l + 21L);
        float f21 = d.C(l + 22L);
        float f22 = d.C(l + 23L);
        float f23 = d.C(l + 24L);
        float f24 = d.C(l + 25L);
        float f25 = d.C(l + 26L);
        float f26 = d.C(l + 27L);
        float f27 = d.C(l + 28L);
        float f28 = d.C(l + 29L);
        float f29 = d.C(l + 30L);
        float f30 = d.C(l + 31L);
        d.A(l + 2L, f29);
        d.A(l + 3L, f30);
        d.A(l + 4L, f13);
        d.A(l + 5L, f14);
        d.A(l + 6L, f21);
        d.A(l + 7L, f22);
        d.A(l + 8L, f5);
        d.A(l + 9L, f6);
        d.A(l + 10L, f25);
        d.A(l + 11L, f26);
        d.A(l + 12L, f9);
        d.A(l + 13L, f10);
        d.A(l + 14L, f17);
        d.A(l + 15L, f18);
        d.A(l + 16L, f);
        d.A(l + 17L, f2);
        d.A(l + 18L, f27);
        d.A(l + 19L, f28);
        d.A(l + 20L, f11);
        d.A(l + 21L, f12);
        d.A(l + 22L, f19);
        d.A(l + 23L, f20);
        d.A(l + 24L, f3);
        d.A(l + 25L, f4);
        d.A(l + 26L, f23);
        d.A(l + 27L, f24);
        d.A(l + 28L, f7);
        d.A(l + 29L, f8);
        d.A(l + 30L, f15);
        d.A(l + 31L, f16);
    }

    public static void bitrv208(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 6];
        float f4 = fArray[n + 7];
        float f5 = fArray[n + 8];
        float f6 = fArray[n + 9];
        float f7 = fArray[n + 12];
        float f8 = fArray[n + 13];
        fArray[n + 2] = f5;
        fArray[n + 3] = f6;
        fArray[n + 6] = f7;
        fArray[n + 7] = f8;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
    }

    public static void bitrv208(D d, long l) {
        float f = d.C(l + 2L);
        float f2 = d.C(l + 3L);
        float f3 = d.C(l + 6L);
        float f4 = d.C(l + 7L);
        float f5 = d.C(l + 8L);
        float f6 = d.C(l + 9L);
        float f7 = d.C(l + 12L);
        float f8 = d.C(l + 13L);
        d.A(l + 2L, f5);
        d.A(l + 3L, f6);
        d.A(l + 6L, f7);
        d.A(l + 7L, f8);
        d.A(l + 8L, f);
        d.A(l + 9L, f2);
        d.A(l + 12L, f3);
        d.A(l + 13L, f4);
    }

    public static void bitrv208neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f5;
        fArray[n + 5] = f6;
        fArray[n + 6] = f9;
        fArray[n + 7] = f10;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 10] = f11;
        fArray[n + 11] = f12;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
        fArray[n + 14] = f7;
        fArray[n + 15] = f8;
    }

    public static void bitrv208neg(D d, long l) {
        float f = d.C(l + 2L);
        float f2 = d.C(l + 3L);
        float f3 = d.C(l + 4L);
        float f4 = d.C(l + 5L);
        float f5 = d.C(l + 6L);
        float f6 = d.C(l + 7L);
        float f7 = d.C(l + 8L);
        float f8 = d.C(l + 9L);
        float f9 = d.C(l + 10L);
        float f10 = d.C(l + 11L);
        float f11 = d.C(l + 12L);
        float f12 = d.C(l + 13L);
        float f13 = d.C(l + 14L);
        float f14 = d.C(l + 15L);
        d.A(l + 2L, f13);
        d.A(l + 3L, f14);
        d.A(l + 4L, f5);
        d.A(l + 5L, f6);
        d.A(l + 6L, f9);
        d.A(l + 7L, f10);
        d.A(l + 8L, f);
        d.A(l + 9L, f2);
        d.A(l + 10L, f11);
        d.A(l + 11L, f12);
        d.A(l + 12L, f3);
        d.A(l + 13L, f4);
        d.A(l + 14L, f7);
        d.A(l + 15L, f8);
    }

    public static void cftf1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = fArray[n2 + 1] + fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = fArray[n2 + 1] - fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        fArray[n12] = f7 - f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 + f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = fArray[n16 + 1] + fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n12];
            f8 = fArray[n16 + 1] - fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = fArray[n16 + 3] + fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = fArray[n16 + 3] - fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 + f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = fArray[n4 + 1] + fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = fArray[n4 + 1] - fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = fArray[n4 - 1] + fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = fArray[n4 - 1] - fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 + f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n2 + n10 - 2] = f19 * f5 + f18 * f6;
            fArray[n2 + n10 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = fArray[n4 - 1] + fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = fArray[n4 - 1] - fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 + f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = fArray[n4 + 1] + fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = fArray[n4 + 1] - fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = fArray[n4 + 3] + fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = fArray[n4 + 3] - fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 + f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    public static void cftf1st(long l, D d, long l2, D d2, long l3) {
        long l4;
        long l5;
        float f;
        float f2;
        float f3;
        float f4;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        float f5 = d.C(l2) + d.C(l12);
        float f6 = d.C(l2 + 1L) + d.C(l12 + 1L);
        float f7 = d.C(l2) - d.C(l12);
        float f8 = d.C(l2 + 1L) - d.C(l12 + 1L);
        float f9 = d.C(l11) + d.C(l13);
        float f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
        float f11 = d.C(l11) - d.C(l13);
        float f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l2, f5 + f9);
        d.A(l2 + 1L, f6 + f10);
        d.A(l11, f5 - f9);
        d.A(l11 + 1L, f6 - f10);
        d.A(l12, f7 - f12);
        d.A(l12 + 1L, f8 + f11);
        d.A(l13, f7 + f12);
        d.A(l13 + 1L, f8 - f11);
        float f13 = d2.C(l3 + 1L);
        float f14 = d2.C(l3 + 2L);
        float f15 = d2.C(l3 + 3L);
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        long l14 = 0L;
        int n = 2;
        while ((long)n < l7 - 2L) {
            long l15 = l3 + (l14 += 4L);
            f4 = f14 * (f16 + d2.C(l15));
            f3 = f14 * (f17 + d2.C(l15 + 1L));
            f2 = f15 * (f18 + d2.C(l15 + 2L));
            f = f15 * (f19 + d2.C(l15 + 3L));
            f16 = d2.C(l15);
            f17 = d2.C(l15 + 1L);
            f18 = d2.C(l15 + 2L);
            f19 = d2.C(l15 + 3L);
            l8 = (long)n + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + (long)n;
            f5 = d.C(l16) + d.C(l12);
            f6 = d.C(l16 + 1L) + d.C(l12 + 1L);
            f7 = d.C(l16) - d.C(l12);
            f8 = d.C(l16 + 1L) - d.C(l12 + 1L);
            float f20 = d.C(l16 + 2L) + d.C(l12 + 2L);
            float f21 = d.C(l16 + 3L) + d.C(l12 + 3L);
            float f22 = d.C(l16 + 2L) - d.C(l12 + 2L);
            float f23 = d.C(l16 + 3L) - d.C(l12 + 3L);
            f9 = d.C(l11) + d.C(l13);
            f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f11 = d.C(l11) - d.C(l13);
            f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
            float f24 = d.C(l11 + 2L) + d.C(l13 + 2L);
            float f25 = d.C(l11 + 3L) + d.C(l13 + 3L);
            float f26 = d.C(l11 + 2L) - d.C(l13 + 2L);
            float f27 = d.C(l11 + 3L) - d.C(l13 + 3L);
            d.A(l16, f5 + f9);
            d.A(l16 + 1L, f6 + f10);
            d.A(l16 + 2L, f20 + f24);
            d.A(l16 + 3L, f21 + f25);
            d.A(l11, f5 - f9);
            d.A(l11 + 1L, f6 - f10);
            d.A(l11 + 2L, f20 - f24);
            d.A(l11 + 3L, f21 - f25);
            f5 = f7 - f12;
            f6 = f8 + f11;
            d.A(l12, f4 * f5 - f3 * f6);
            d.A(l12 + 1L, f4 * f6 + f3 * f5);
            f5 = f22 - f27;
            f6 = f23 + f26;
            d.A(l12 + 2L, f16 * f5 - f17 * f6);
            d.A(l12 + 3L, f16 * f6 + f17 * f5);
            f5 = f7 + f12;
            f6 = f8 - f11;
            d.A(l13, f2 * f5 + f * f6);
            d.A(l13 + 1L, f2 * f6 - f * f5);
            f5 = f22 + f27;
            f6 = f23 - f26;
            d.A(l13 + 2L, f18 * f5 + f19 * f6);
            d.A(l13 + 3L, f18 * f6 - f19 * f5);
            l5 = l6 - (long)n;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            f5 = d.C(l4) + d.C(l12);
            f6 = d.C(l4 + 1L) + d.C(l12 + 1L);
            f7 = d.C(l4) - d.C(l12);
            f8 = d.C(l4 + 1L) - d.C(l12 + 1L);
            f20 = d.C(l4 - 2L) + d.C(l12 - 2L);
            f21 = d.C(l4 - 1L) + d.C(l12 - 1L);
            f22 = d.C(l4 - 2L) - d.C(l12 - 2L);
            f23 = d.C(l4 - 1L) - d.C(l12 - 1L);
            f9 = d.C(l11) + d.C(l13);
            f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f11 = d.C(l11) - d.C(l13);
            f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
            f24 = d.C(l11 - 2L) + d.C(l13 - 2L);
            f25 = d.C(l11 - 1L) + d.C(l13 - 1L);
            f26 = d.C(l11 - 2L) - d.C(l13 - 2L);
            f27 = d.C(l11 - 1L) - d.C(l13 - 1L);
            d.A(l4, f5 + f9);
            d.A(l4 + 1L, f6 + f10);
            d.A(l4 - 2L, f20 + f24);
            d.A(l4 - 1L, f21 + f25);
            d.A(l11, f5 - f9);
            d.A(l11 + 1L, f6 - f10);
            d.A(l11 - 2L, f20 - f24);
            d.A(l11 - 1L, f21 - f25);
            f5 = f7 - f12;
            f6 = f8 + f11;
            d.A(l12, f3 * f5 - f4 * f6);
            d.A(l12 + 1L, f3 * f6 + f4 * f5);
            f5 = f22 - f27;
            f6 = f23 + f26;
            d.A(l12 - 2L, f17 * f5 - f16 * f6);
            d.A(l12 - 1L, f17 * f6 + f16 * f5);
            f5 = f7 + f12;
            f6 = f8 - f11;
            d.A(l13, f * f5 + f2 * f6);
            d.A(l13 + 1L, f * f6 - f2 * f5);
            f5 = f22 + f27;
            f6 = f23 - f26;
            d.A(l2 + l10 - 2L, f19 * f5 + f18 * f6);
            d.A(l2 + l10 - 1L, f19 * f6 - f18 * f5);
            n += 4;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        f5 = d.C(l4 - 2L) + d.C(l12 - 2L);
        f6 = d.C(l4 - 1L) + d.C(l12 - 1L);
        f7 = d.C(l4 - 2L) - d.C(l12 - 2L);
        f8 = d.C(l4 - 1L) - d.C(l12 - 1L);
        f9 = d.C(l11 - 2L) + d.C(l13 - 2L);
        f10 = d.C(l11 - 1L) + d.C(l13 - 1L);
        f11 = d.C(l11 - 2L) - d.C(l13 - 2L);
        f12 = d.C(l11 - 1L) - d.C(l13 - 1L);
        d.A(l4 - 2L, f5 + f9);
        d.A(l4 - 1L, f6 + f10);
        d.A(l11 - 2L, f5 - f9);
        d.A(l11 - 1L, f6 - f10);
        f5 = f7 - f12;
        f6 = f8 + f11;
        d.A(l12 - 2L, f4 * f5 - f3 * f6);
        d.A(l12 - 1L, f4 * f6 + f3 * f5);
        f5 = f7 + f12;
        f6 = f8 - f11;
        d.A(l13 - 2L, f2 * f5 + f * f6);
        d.A(l13 - 1L, f2 * f6 - f * f5);
        f5 = d.C(l4) + d.C(l12);
        f6 = d.C(l4 + 1L) + d.C(l12 + 1L);
        f7 = d.C(l4) - d.C(l12);
        f8 = d.C(l4 + 1L) - d.C(l12 + 1L);
        f9 = d.C(l11) + d.C(l13);
        f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
        f11 = d.C(l11) - d.C(l13);
        f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l4, f5 + f9);
        d.A(l4 + 1L, f6 + f10);
        d.A(l11, f5 - f9);
        d.A(l11 + 1L, f6 - f10);
        f5 = f7 - f12;
        f6 = f8 + f11;
        d.A(l12, f13 * (f5 - f6));
        d.A(l12 + 1L, f13 * (f6 + f5));
        f5 = f7 + f12;
        f6 = f8 - f11;
        d.A(l13, -f13 * (f5 + f6));
        d.A(l13 + 1L, -f13 * (f6 - f5));
        f5 = d.C(l4 + 2L) + d.C(l12 + 2L);
        f6 = d.C(l4 + 3L) + d.C(l12 + 3L);
        f7 = d.C(l4 + 2L) - d.C(l12 + 2L);
        f8 = d.C(l4 + 3L) - d.C(l12 + 3L);
        f9 = d.C(l11 + 2L) + d.C(l13 + 2L);
        f10 = d.C(l11 + 3L) + d.C(l13 + 3L);
        f11 = d.C(l11 + 2L) - d.C(l13 + 2L);
        f12 = d.C(l11 + 3L) - d.C(l13 + 3L);
        d.A(l4 + 2L, f5 + f9);
        d.A(l4 + 3L, f6 + f10);
        d.A(l11 + 2L, f5 - f9);
        d.A(l11 + 3L, f6 - f10);
        f5 = f7 - f12;
        f6 = f8 + f11;
        d.A(l12 + 2L, f3 * f5 - f4 * f6);
        d.A(l12 + 3L, f3 * f6 + f4 * f5);
        f5 = f7 + f12;
        f6 = f8 - f11;
        d.A(l13 + 2L, f * f5 + f2 * f6);
        d.A(l13 + 3L, f * f6 - f2 * f5);
    }

    public static void cftb1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = -fArray[n2 + 1] - fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = -fArray[n2 + 1] + fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        fArray[n12] = f7 + f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 - f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = -fArray[n16 + 1] - fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n2 + n9];
            f8 = -fArray[n16 + 1] + fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = -fArray[n16 + 3] - fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = -fArray[n16 + 3] + fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 - f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = -fArray[n4 + 1] - fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = -fArray[n4 + 1] + fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = -fArray[n4 - 1] - fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = -fArray[n4 - 1] + fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 - f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 - 2] = f19 * f5 + f18 * f6;
            fArray[n13 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = -fArray[n4 - 1] - fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = -fArray[n4 - 1] + fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 - f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = -fArray[n4 + 1] - fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = -fArray[n4 + 1] + fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = -fArray[n4 + 3] - fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = -fArray[n4 + 3] + fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 - f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    public static void cftb1st(long l, D d, long l2, D d2, long l3) {
        long l4;
        long l5;
        float f;
        float f2;
        float f3;
        float f4;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        float f5 = d.C(l2) + d.C(l12);
        float f6 = -d.C(l2 + 1L) - d.C(l12 + 1L);
        float f7 = d.C(l2) - d.C(l12);
        float f8 = -d.C(l2 + 1L) + d.C(l12 + 1L);
        float f9 = d.C(l11) + d.C(l13);
        float f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
        float f11 = d.C(l11) - d.C(l13);
        float f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l2, f5 + f9);
        d.A(l2 + 1L, f6 - f10);
        d.A(l11, f5 - f9);
        d.A(l11 + 1L, f6 + f10);
        d.A(l12, f7 + f12);
        d.A(l12 + 1L, f8 + f11);
        d.A(l13, f7 - f12);
        d.A(l13 + 1L, f8 - f11);
        float f13 = d2.C(l3 + 1L);
        float f14 = d2.C(l3 + 2L);
        float f15 = d2.C(l3 + 3L);
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        long l14 = 0L;
        for (long i = 2L; i < l7 - 2L; i += 4L) {
            long l15 = l3 + (l14 += 4L);
            f4 = f14 * (f16 + d2.C(l15));
            f3 = f14 * (f17 + d2.C(l15 + 1L));
            f2 = f15 * (f18 + d2.C(l15 + 2L));
            f = f15 * (f19 + d2.C(l15 + 3L));
            f16 = d2.C(l15);
            f17 = d2.C(l15 + 1L);
            f18 = d2.C(l15 + 2L);
            f19 = d2.C(l15 + 3L);
            l8 = i + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + i;
            f5 = d.C(l16) + d.C(l12);
            f6 = -d.C(l16 + 1L) - d.C(l12 + 1L);
            f7 = d.C(l16) - d.C(l2 + l9);
            f8 = -d.C(l16 + 1L) + d.C(l12 + 1L);
            float f20 = d.C(l16 + 2L) + d.C(l12 + 2L);
            float f21 = -d.C(l16 + 3L) - d.C(l12 + 3L);
            float f22 = d.C(l16 + 2L) - d.C(l12 + 2L);
            float f23 = -d.C(l16 + 3L) + d.C(l12 + 3L);
            f9 = d.C(l11) + d.C(l13);
            f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f11 = d.C(l11) - d.C(l13);
            f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
            float f24 = d.C(l11 + 2L) + d.C(l13 + 2L);
            float f25 = d.C(l11 + 3L) + d.C(l13 + 3L);
            float f26 = d.C(l11 + 2L) - d.C(l13 + 2L);
            float f27 = d.C(l11 + 3L) - d.C(l13 + 3L);
            d.A(l16, f5 + f9);
            d.A(l16 + 1L, f6 - f10);
            d.A(l16 + 2L, f20 + f24);
            d.A(l16 + 3L, f21 - f25);
            d.A(l11, f5 - f9);
            d.A(l11 + 1L, f6 + f10);
            d.A(l11 + 2L, f20 - f24);
            d.A(l11 + 3L, f21 + f25);
            f5 = f7 + f12;
            f6 = f8 + f11;
            d.A(l12, f4 * f5 - f3 * f6);
            d.A(l12 + 1L, f4 * f6 + f3 * f5);
            f5 = f22 + f27;
            f6 = f23 + f26;
            d.A(l12 + 2L, f16 * f5 - f17 * f6);
            d.A(l12 + 3L, f16 * f6 + f17 * f5);
            f5 = f7 - f12;
            f6 = f8 - f11;
            d.A(l13, f2 * f5 + f * f6);
            d.A(l13 + 1L, f2 * f6 - f * f5);
            f5 = f22 - f27;
            f6 = f23 - f26;
            d.A(l13 + 2L, f18 * f5 + f19 * f6);
            d.A(l13 + 3L, f18 * f6 - f19 * f5);
            l5 = l6 - i;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            f5 = d.C(l4) + d.C(l12);
            f6 = -d.C(l4 + 1L) - d.C(l12 + 1L);
            f7 = d.C(l4) - d.C(l12);
            f8 = -d.C(l4 + 1L) + d.C(l12 + 1L);
            f20 = d.C(l4 - 2L) + d.C(l12 - 2L);
            f21 = -d.C(l4 - 1L) - d.C(l12 - 1L);
            f22 = d.C(l4 - 2L) - d.C(l12 - 2L);
            f23 = -d.C(l4 - 1L) + d.C(l12 - 1L);
            f9 = d.C(l11) + d.C(l13);
            f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f11 = d.C(l11) - d.C(l13);
            f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
            f24 = d.C(l11 - 2L) + d.C(l13 - 2L);
            f25 = d.C(l11 - 1L) + d.C(l13 - 1L);
            f26 = d.C(l11 - 2L) - d.C(l13 - 2L);
            f27 = d.C(l11 - 1L) - d.C(l13 - 1L);
            d.A(l4, f5 + f9);
            d.A(l4 + 1L, f6 - f10);
            d.A(l4 - 2L, f20 + f24);
            d.A(l4 - 1L, f21 - f25);
            d.A(l11, f5 - f9);
            d.A(l11 + 1L, f6 + f10);
            d.A(l11 - 2L, f20 - f24);
            d.A(l11 - 1L, f21 + f25);
            f5 = f7 + f12;
            f6 = f8 + f11;
            d.A(l12, f3 * f5 - f4 * f6);
            d.A(l12 + 1L, f3 * f6 + f4 * f5);
            f5 = f22 + f27;
            f6 = f23 + f26;
            d.A(l12 - 2L, f17 * f5 - f16 * f6);
            d.A(l12 - 1L, f17 * f6 + f16 * f5);
            f5 = f7 - f12;
            f6 = f8 - f11;
            d.A(l13, f * f5 + f2 * f6);
            d.A(l13 + 1L, f * f6 - f2 * f5);
            f5 = f22 - f27;
            f6 = f23 - f26;
            d.A(l13 - 2L, f19 * f5 + f18 * f6);
            d.A(l13 - 1L, f19 * f6 - f18 * f5);
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        f5 = d.C(l4 - 2L) + d.C(l12 - 2L);
        f6 = -d.C(l4 - 1L) - d.C(l12 - 1L);
        f7 = d.C(l4 - 2L) - d.C(l12 - 2L);
        f8 = -d.C(l4 - 1L) + d.C(l12 - 1L);
        f9 = d.C(l11 - 2L) + d.C(l13 - 2L);
        f10 = d.C(l11 - 1L) + d.C(l13 - 1L);
        f11 = d.C(l11 - 2L) - d.C(l13 - 2L);
        f12 = d.C(l11 - 1L) - d.C(l13 - 1L);
        d.A(l4 - 2L, f5 + f9);
        d.A(l4 - 1L, f6 - f10);
        d.A(l11 - 2L, f5 - f9);
        d.A(l11 - 1L, f6 + f10);
        f5 = f7 + f12;
        f6 = f8 + f11;
        d.A(l12 - 2L, f4 * f5 - f3 * f6);
        d.A(l12 - 1L, f4 * f6 + f3 * f5);
        f5 = f7 - f12;
        f6 = f8 - f11;
        d.A(l13 - 2L, f2 * f5 + f * f6);
        d.A(l13 - 1L, f2 * f6 - f * f5);
        f5 = d.C(l4) + d.C(l12);
        f6 = -d.C(l4 + 1L) - d.C(l12 + 1L);
        f7 = d.C(l4) - d.C(l12);
        f8 = -d.C(l4 + 1L) + d.C(l12 + 1L);
        f9 = d.C(l11) + d.C(l13);
        f10 = d.C(l11 + 1L) + d.C(l13 + 1L);
        f11 = d.C(l11) - d.C(l13);
        f12 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l4, f5 + f9);
        d.A(l4 + 1L, f6 - f10);
        d.A(l11, f5 - f9);
        d.A(l11 + 1L, f6 + f10);
        f5 = f7 + f12;
        f6 = f8 + f11;
        d.A(l12, f13 * (f5 - f6));
        d.A(l12 + 1L, f13 * (f6 + f5));
        f5 = f7 - f12;
        f6 = f8 - f11;
        d.A(l13, -f13 * (f5 + f6));
        d.A(l13 + 1L, -f13 * (f6 - f5));
        f5 = d.C(l4 + 2L) + d.C(l12 + 2L);
        f6 = -d.C(l4 + 3L) - d.C(l12 + 3L);
        f7 = d.C(l4 + 2L) - d.C(l12 + 2L);
        f8 = -d.C(l4 + 3L) + d.C(l12 + 3L);
        f9 = d.C(l11 + 2L) + d.C(l13 + 2L);
        f10 = d.C(l11 + 3L) + d.C(l13 + 3L);
        f11 = d.C(l11 + 2L) - d.C(l13 + 2L);
        f12 = d.C(l11 + 3L) - d.C(l13 + 3L);
        d.A(l4 + 2L, f5 + f9);
        d.A(l4 + 3L, f6 - f10);
        d.A(l11 + 2L, f5 - f9);
        d.A(l11 + 3L, f6 + f10);
        f5 = f7 + f12;
        f6 = f8 + f11;
        d.A(l12 + 2L, f3 * f5 - f4 * f6);
        d.A(l12 + 3L, f3 * f6 + f4 * f5);
        f5 = f7 - f12;
        f6 = f8 - f11;
        d.A(l13 + 2L, f * f5 + f2 * f6);
        d.A(l13 + 3L, f * f6 - f2 * f5);
    }

    public static void cftrec4_th(final int n, final float[] fArray, int n2, final int n3, final float[] fArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if ((long)n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? F.A(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        CommonUtils.cftmdl1(n2 >>= 2, fArray, n6 - n2, fArray2, n3 - (n2 >> 1));
                    }
                    CommonUtils.cftleaf(n2, 1, fArray, n6 - n2, n3, fArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = CommonUtils.cfttree(n2, i, ++n32, fArray, n9, n3, fArray2);
                        CommonUtils.cftleaf(n2, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            }) : F.A(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        CommonUtils.cftmdl2(n32 >>= 2, fArray, n6 - n32, fArray2, n3 - n32);
                    }
                    CommonUtils.cftleaf(n32, 0, fArray, n6 - n32, n3, fArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = CommonUtils.cfttree(n32, i, ++n2, fArray, n9, n3, fArray2);
                        CommonUtils.cftleaf(n32, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            });
        }
        try {
            F.A(futureArray);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
        }
    }

    public static void cftrec4_th(final long l, final D d, long l2, final long l3, final D d2) {
        int n = 0;
        int n2 = 2;
        int n3 = 0;
        long l4 = l >> 1;
        if (l >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n2 = 4;
            n3 = 1;
            l4 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final long l5 = l4;
        for (int i = 0; i < n2; ++i) {
            final long l6 = l2 + (long)i * l4;
            futureArray[n++] = i != n3 ? F.A(new Runnable(){

                @Override
                public void run() {
                    long l7 = l6 + l5;
                    long l2 = l;
                    while (l2 > 512L) {
                        CommonUtils.cftmdl1(l2 >>= 2, d, l7 - l2, d2, l3 - (l2 >> 1));
                    }
                    CommonUtils.cftleaf(l2, 1L, d, l7 - l2, l3, d2);
                    long l32 = 0L;
                    long l4 = l6 - l2;
                    for (long i = l5 - l2; i > 0L; i -= l2) {
                        long l52 = CommonUtils.cfttree(l2, i, ++l32, d, l6, l3, d2);
                        CommonUtils.cftleaf(l2, l52, d, l4 + i, l3, d2);
                    }
                }
            }) : F.A(new Runnable(){

                @Override
                public void run() {
                    long l7 = l6 + l5;
                    long l2 = 1L;
                    long l32 = l;
                    while (l32 > 512L) {
                        l2 <<= 2;
                        CommonUtils.cftmdl2(l32 >>= 2, d, l7 - l32, d2, l3 - l32);
                    }
                    CommonUtils.cftleaf(l32, 0L, d, l7 - l32, l3, d2);
                    l2 >>= 1;
                    long l4 = l6 - l32;
                    for (long i = l5 - l32; i > 0L; i -= l32) {
                        long l52 = CommonUtils.cfttree(l32, i, ++l2, d, l6, l3, d2);
                        CommonUtils.cftleaf(l32, l52, d, l4 + i, l3, d2);
                    }
                }
            });
        }
        try {
            F.A(futureArray);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
        }
    }

    public static void cftrec4(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        int n4 = n;
        int n5 = n2 + n;
        while (n4 > 512) {
            CommonUtils.cftmdl1(n4 >>= 2, fArray, n5 - n4, fArray2, n3 - (n4 >> 1));
        }
        CommonUtils.cftleaf(n4, 1, fArray, n5 - n4, n3, fArray2);
        int n6 = 0;
        int n7 = n2 - n4;
        for (int i = n - n4; i > 0; i -= n4) {
            int n8 = CommonUtils.cfttree(n4, i, ++n6, fArray, n2, n3, fArray2);
            CommonUtils.cftleaf(n4, n8, fArray, n7 + i, n3, fArray2);
        }
    }

    public static void cftrec4(long l, D d, long l2, long l3, D d2) {
        long l4 = l;
        long l5 = l2 + l;
        while (l4 > 512L) {
            CommonUtils.cftmdl1(l4 >>= 2, d, l5 - l4, d2, l3 - (l4 >> 1));
        }
        CommonUtils.cftleaf(l4, 1L, d, l5 - l4, l3, d2);
        long l6 = 0L;
        long l7 = l2 - l4;
        for (long i = l - l4; i > 0L; i -= l4) {
            long l8 = CommonUtils.cfttree(l4, i, ++l6, d, l2, l3, d2);
            CommonUtils.cftleaf(l4, l8, d, l7 + i, l3, d2);
        }
    }

    public static int cfttree(int n, int n2, int n3, float[] fArray, int n4, int n5, float[] fArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                CommonUtils.cftmdl1(n, fArray, n7 + n2, fArray2, n5 - (n >> 1));
            } else {
                CommonUtils.cftmdl2(n, fArray, n7 + n2, fArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    CommonUtils.cftmdl1(n8, fArray, n10 - n8, fArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    CommonUtils.cftmdl2(n8, fArray, n10 - n8, fArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    public static long cfttree(long l, long l2, long l3, D d, long l4, long l5, D d2) {
        long l6;
        long l7 = l4 - l;
        if ((l3 & 3L) != 0L) {
            l6 = l3 & 1L;
            if (l6 != 0L) {
                CommonUtils.cftmdl1(l, d, l7 + l2, d2, l5 - (l >> 1));
            } else {
                CommonUtils.cftmdl2(l, d, l7 + l2, d2, l5 - l);
            }
        } else {
            long l8 = l;
            long l9 = l3;
            while ((l9 & 3L) == 0L) {
                l8 <<= 2;
                l9 >>= 2;
            }
            l6 = l9 & 1L;
            long l10 = l4 + l2;
            if (l6 != 0L) {
                while (l8 > 128L) {
                    CommonUtils.cftmdl1(l8, d, l10 - l8, d2, l5 - (l8 >> 1));
                    l8 >>= 2;
                }
            } else {
                while (l8 > 128L) {
                    CommonUtils.cftmdl2(l8, d, l10 - l8, d2, l5 - l8);
                    l8 >>= 2;
                }
            }
        }
        return l6;
    }

    public static void cftleaf(int n, int n2, float[] fArray, int n3, int n4, float[] fArray2) {
        if (n == 512) {
            CommonUtils.cftmdl1(128, fArray, n3, fArray2, n4 - 64);
            CommonUtils.cftf161(fArray, n3, fArray2, n4 - 8);
            CommonUtils.cftf162(fArray, n3 + 32, fArray2, n4 - 32);
            CommonUtils.cftf161(fArray, n3 + 64, fArray2, n4 - 8);
            CommonUtils.cftf161(fArray, n3 + 96, fArray2, n4 - 8);
            CommonUtils.cftmdl2(128, fArray, n3 + 128, fArray2, n4 - 128);
            CommonUtils.cftf161(fArray, n3 + 128, fArray2, n4 - 8);
            CommonUtils.cftf162(fArray, n3 + 160, fArray2, n4 - 32);
            CommonUtils.cftf161(fArray, n3 + 192, fArray2, n4 - 8);
            CommonUtils.cftf162(fArray, n3 + 224, fArray2, n4 - 32);
            CommonUtils.cftmdl1(128, fArray, n3 + 256, fArray2, n4 - 64);
            CommonUtils.cftf161(fArray, n3 + 256, fArray2, n4 - 8);
            CommonUtils.cftf162(fArray, n3 + 288, fArray2, n4 - 32);
            CommonUtils.cftf161(fArray, n3 + 320, fArray2, n4 - 8);
            CommonUtils.cftf161(fArray, n3 + 352, fArray2, n4 - 8);
            if (n2 != 0) {
                CommonUtils.cftmdl1(128, fArray, n3 + 384, fArray2, n4 - 64);
                CommonUtils.cftf161(fArray, n3 + 480, fArray2, n4 - 8);
            } else {
                CommonUtils.cftmdl2(128, fArray, n3 + 384, fArray2, n4 - 128);
                CommonUtils.cftf162(fArray, n3 + 480, fArray2, n4 - 32);
            }
            CommonUtils.cftf161(fArray, n3 + 384, fArray2, n4 - 8);
            CommonUtils.cftf162(fArray, n3 + 416, fArray2, n4 - 32);
            CommonUtils.cftf161(fArray, n3 + 448, fArray2, n4 - 8);
        } else {
            CommonUtils.cftmdl1(64, fArray, n3, fArray2, n4 - 32);
            CommonUtils.cftf081(fArray, n3, fArray2, n4 - 8);
            CommonUtils.cftf082(fArray, n3 + 16, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 32, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 48, fArray2, n4 - 8);
            CommonUtils.cftmdl2(64, fArray, n3 + 64, fArray2, n4 - 64);
            CommonUtils.cftf081(fArray, n3 + 64, fArray2, n4 - 8);
            CommonUtils.cftf082(fArray, n3 + 80, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 96, fArray2, n4 - 8);
            CommonUtils.cftf082(fArray, n3 + 112, fArray2, n4 - 8);
            CommonUtils.cftmdl1(64, fArray, n3 + 128, fArray2, n4 - 32);
            CommonUtils.cftf081(fArray, n3 + 128, fArray2, n4 - 8);
            CommonUtils.cftf082(fArray, n3 + 144, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 160, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 176, fArray2, n4 - 8);
            if (n2 != 0) {
                CommonUtils.cftmdl1(64, fArray, n3 + 192, fArray2, n4 - 32);
                CommonUtils.cftf081(fArray, n3 + 240, fArray2, n4 - 8);
            } else {
                CommonUtils.cftmdl2(64, fArray, n3 + 192, fArray2, n4 - 64);
                CommonUtils.cftf082(fArray, n3 + 240, fArray2, n4 - 8);
            }
            CommonUtils.cftf081(fArray, n3 + 192, fArray2, n4 - 8);
            CommonUtils.cftf082(fArray, n3 + 208, fArray2, n4 - 8);
            CommonUtils.cftf081(fArray, n3 + 224, fArray2, n4 - 8);
        }
    }

    public static void cftleaf(long l, long l2, D d, long l3, long l4, D d2) {
        if (l == 512L) {
            CommonUtils.cftmdl1(128L, d, l3, d2, l4 - 64L);
            CommonUtils.cftf161(d, l3, d2, l4 - 8L);
            CommonUtils.cftf162(d, l3 + 32L, d2, l4 - 32L);
            CommonUtils.cftf161(d, l3 + 64L, d2, l4 - 8L);
            CommonUtils.cftf161(d, l3 + 96L, d2, l4 - 8L);
            CommonUtils.cftmdl2(128L, d, l3 + 128L, d2, l4 - 128L);
            CommonUtils.cftf161(d, l3 + 128L, d2, l4 - 8L);
            CommonUtils.cftf162(d, l3 + 160L, d2, l4 - 32L);
            CommonUtils.cftf161(d, l3 + 192L, d2, l4 - 8L);
            CommonUtils.cftf162(d, l3 + 224L, d2, l4 - 32L);
            CommonUtils.cftmdl1(128L, d, l3 + 256L, d2, l4 - 64L);
            CommonUtils.cftf161(d, l3 + 256L, d2, l4 - 8L);
            CommonUtils.cftf162(d, l3 + 288L, d2, l4 - 32L);
            CommonUtils.cftf161(d, l3 + 320L, d2, l4 - 8L);
            CommonUtils.cftf161(d, l3 + 352L, d2, l4 - 8L);
            if (l2 != 0L) {
                CommonUtils.cftmdl1(128L, d, l3 + 384L, d2, l4 - 64L);
                CommonUtils.cftf161(d, l3 + 480L, d2, l4 - 8L);
            } else {
                CommonUtils.cftmdl2(128L, d, l3 + 384L, d2, l4 - 128L);
                CommonUtils.cftf162(d, l3 + 480L, d2, l4 - 32L);
            }
            CommonUtils.cftf161(d, l3 + 384L, d2, l4 - 8L);
            CommonUtils.cftf162(d, l3 + 416L, d2, l4 - 32L);
            CommonUtils.cftf161(d, l3 + 448L, d2, l4 - 8L);
        } else {
            CommonUtils.cftmdl1(64L, d, l3, d2, l4 - 32L);
            CommonUtils.cftf081(d, l3, d2, l4 - 8L);
            CommonUtils.cftf082(d, l3 + 16L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 32L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 48L, d2, l4 - 8L);
            CommonUtils.cftmdl2(64L, d, l3 + 64L, d2, l4 - 64L);
            CommonUtils.cftf081(d, l3 + 64L, d2, l4 - 8L);
            CommonUtils.cftf082(d, l3 + 80L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 96L, d2, l4 - 8L);
            CommonUtils.cftf082(d, l3 + 112L, d2, l4 - 8L);
            CommonUtils.cftmdl1(64L, d, l3 + 128L, d2, l4 - 32L);
            CommonUtils.cftf081(d, l3 + 128L, d2, l4 - 8L);
            CommonUtils.cftf082(d, l3 + 144L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 160L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 176L, d2, l4 - 8L);
            if (l2 != 0L) {
                CommonUtils.cftmdl1(64L, d, l3 + 192L, d2, l4 - 32L);
                CommonUtils.cftf081(d, l3 + 240L, d2, l4 - 8L);
            } else {
                CommonUtils.cftmdl2(64L, d, l3 + 192L, d2, l4 - 64L);
                CommonUtils.cftf082(d, l3 + 240L, d2, l4 - 8L);
            }
            CommonUtils.cftf081(d, l3 + 192L, d2, l4 - 8L);
            CommonUtils.cftf082(d, l3 + 208L, d2, l4 - 8L);
            CommonUtils.cftf081(d, l3 + 224L, d2, l4 - 8L);
        }
    }

    public static void cftmdl1(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f = fArray[n2] + fArray[n12];
        float f2 = fArray[n2 + 1] + fArray[n12 + 1];
        float f3 = fArray[n2] - fArray[n12];
        float f4 = fArray[n2 + 1] - fArray[n12 + 1];
        float f5 = fArray[n11] + fArray[n13];
        float f6 = fArray[n11 + 1] + fArray[n13 + 1];
        float f7 = fArray[n11] - fArray[n13];
        float f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f + f5;
        fArray[n2 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        fArray[n12] = f3 - f8;
        fArray[n12 + 1] = f4 + f7;
        fArray[n13] = f3 + f8;
        fArray[n13 + 1] = f4 - f7;
        float f9 = fArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            float f10 = fArray2[n15];
            float f11 = fArray2[n15 + 1];
            float f12 = fArray2[n15 + 2];
            float f13 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f = fArray[n16] + fArray[n12];
            f2 = fArray[n16 + 1] + fArray[n12 + 1];
            f3 = fArray[n16] - fArray[n12];
            f4 = fArray[n16 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n16] = f + f5;
            fArray[n16 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f10 * f - f11 * f2;
            fArray[n12 + 1] = f10 * f2 + f11 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f12 * f + f13 * f2;
            fArray[n13 + 1] = f12 * f2 - f13 * f;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f = fArray[n4] + fArray[n12];
            f2 = fArray[n4 + 1] + fArray[n12 + 1];
            f3 = fArray[n4] - fArray[n12];
            f4 = fArray[n4 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n4] = f + f5;
            fArray[n4 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f11 * f - f10 * f2;
            fArray[n12 + 1] = f11 * f2 + f10 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f13 * f + f12 * f2;
            fArray[n13 + 1] = f13 * f2 - f12 * f;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f = fArray[n4] + fArray[n12];
        f2 = fArray[n4 + 1] + fArray[n12 + 1];
        f3 = fArray[n4] - fArray[n12];
        f4 = fArray[n4 + 1] - fArray[n12 + 1];
        f5 = fArray[n11] + fArray[n13];
        f6 = fArray[n11 + 1] + fArray[n13 + 1];
        f7 = fArray[n11] - fArray[n13];
        f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f + f5;
        fArray[n4 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        f = f3 - f8;
        f2 = f4 + f7;
        fArray[n12] = f9 * (f - f2);
        fArray[n12 + 1] = f9 * (f2 + f);
        f = f3 + f8;
        f2 = f4 - f7;
        fArray[n13] = -f9 * (f + f2);
        fArray[n13 + 1] = -f9 * (f2 - f);
    }

    public static void cftmdl1(long l, D d, long l2, D d2, long l3) {
        long l4;
        long l5;
        long l6;
        long l7 = l >> 3;
        long l8 = l6 = 2L * l7;
        long l9 = l8 + l6;
        long l10 = l9 + l6;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        float f = d.C(l2) + d.C(l12);
        float f2 = d.C(l2 + 1L) + d.C(l12 + 1L);
        float f3 = d.C(l2) - d.C(l12);
        float f4 = d.C(l2 + 1L) - d.C(l12 + 1L);
        float f5 = d.C(l11) + d.C(l13);
        float f6 = d.C(l11 + 1L) + d.C(l13 + 1L);
        float f7 = d.C(l11) - d.C(l13);
        float f8 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l2, f + f5);
        d.A(l2 + 1L, f2 + f6);
        d.A(l11, f - f5);
        d.A(l11 + 1L, f2 - f6);
        d.A(l12, f3 - f8);
        d.A(l12 + 1L, f4 + f7);
        d.A(l13, f3 + f8);
        d.A(l13 + 1L, f4 - f7);
        float f9 = d2.C(l3 + 1L);
        long l14 = 0L;
        for (long i = 2L; i < l7; i += 2L) {
            long l15 = l3 + (l14 += 4L);
            float f10 = d2.C(l15);
            float f11 = d2.C(l15 + 1L);
            float f12 = d2.C(l15 + 2L);
            float f13 = d2.C(l15 + 3L);
            l8 = i + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l16 = l2 + i;
            f = d.C(l16) + d.C(l12);
            f2 = d.C(l16 + 1L) + d.C(l12 + 1L);
            f3 = d.C(l16) - d.C(l12);
            f4 = d.C(l16 + 1L) - d.C(l12 + 1L);
            f5 = d.C(l11) + d.C(l13);
            f6 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f7 = d.C(l11) - d.C(l13);
            f8 = d.C(l11 + 1L) - d.C(l13 + 1L);
            d.A(l16, f + f5);
            d.A(l16 + 1L, f2 + f6);
            d.A(l11, f - f5);
            d.A(l11 + 1L, f2 - f6);
            f = f3 - f8;
            f2 = f4 + f7;
            d.A(l12, f10 * f - f11 * f2);
            d.A(l12 + 1L, f10 * f2 + f11 * f);
            f = f3 + f8;
            f2 = f4 - f7;
            d.A(l13, f12 * f + f13 * f2);
            d.A(l13 + 1L, f12 * f2 - f13 * f);
            l5 = l6 - i;
            l8 = l5 + l6;
            l9 = l8 + l6;
            l10 = l9 + l6;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            f = d.C(l4) + d.C(l12);
            f2 = d.C(l4 + 1L) + d.C(l12 + 1L);
            f3 = d.C(l4) - d.C(l12);
            f4 = d.C(l4 + 1L) - d.C(l12 + 1L);
            f5 = d.C(l11) + d.C(l13);
            f6 = d.C(l11 + 1L) + d.C(l13 + 1L);
            f7 = d.C(l11) - d.C(l13);
            f8 = d.C(l11 + 1L) - d.C(l13 + 1L);
            d.A(l4, f + f5);
            d.A(l4 + 1L, f2 + f6);
            d.A(l11, f - f5);
            d.A(l11 + 1L, f2 - f6);
            f = f3 - f8;
            f2 = f4 + f7;
            d.A(l12, f11 * f - f10 * f2);
            d.A(l12 + 1L, f11 * f2 + f10 * f);
            f = f3 + f8;
            f2 = f4 - f7;
            d.A(l13, f13 * f + f12 * f2);
            d.A(l13 + 1L, f13 * f2 - f12 * f);
        }
        l5 = l7;
        l8 = l5 + l6;
        l9 = l8 + l6;
        l10 = l9 + l6;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        f = d.C(l4) + d.C(l12);
        f2 = d.C(l4 + 1L) + d.C(l12 + 1L);
        f3 = d.C(l4) - d.C(l12);
        f4 = d.C(l4 + 1L) - d.C(l12 + 1L);
        f5 = d.C(l11) + d.C(l13);
        f6 = d.C(l11 + 1L) + d.C(l13 + 1L);
        f7 = d.C(l11) - d.C(l13);
        f8 = d.C(l11 + 1L) - d.C(l13 + 1L);
        d.A(l4, f + f5);
        d.A(l4 + 1L, f2 + f6);
        d.A(l11, f - f5);
        d.A(l11 + 1L, f2 - f6);
        f = f3 - f8;
        f2 = f4 + f7;
        d.A(l12, f9 * (f - f2));
        d.A(l12 + 1L, f9 * (f2 + f));
        f = f3 + f8;
        f2 = f4 - f7;
        d.A(l13, -f9 * (f + f2));
        d.A(l13 + 1L, -f9 * (f2 - f));
    }

    public static void cftmdl2(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        float f5 = fArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f6 = fArray[n2] - fArray[n12 + 1];
        float f7 = fArray[n2 + 1] + fArray[n12];
        float f8 = fArray[n2] + fArray[n12 + 1];
        float f9 = fArray[n2 + 1] - fArray[n12];
        float f10 = fArray[n11] - fArray[n13 + 1];
        float f11 = fArray[n11 + 1] + fArray[n13];
        float f12 = fArray[n11] + fArray[n13 + 1];
        float f13 = fArray[n11 + 1] - fArray[n13];
        float f14 = f5 * (f10 - f11);
        float f15 = f5 * (f11 + f10);
        fArray[n2] = f6 + f14;
        fArray[n2 + 1] = f7 + f15;
        fArray[n11] = f6 - f14;
        fArray[n11 + 1] = f7 - f15;
        f14 = f5 * (f12 - f13);
        f15 = f5 * (f13 + f12);
        fArray[n12] = f8 - f15;
        fArray[n12 + 1] = f9 + f14;
        fArray[n13] = f8 + f15;
        fArray[n13 + 1] = f9 - f14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            f4 = fArray2[n16];
            f3 = fArray2[n16 + 1];
            float f16 = fArray2[n16 + 2];
            float f17 = fArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            float f18 = fArray2[n17];
            float f19 = fArray2[n17 + 1];
            float f20 = fArray2[n17 + 2];
            float f21 = fArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            f6 = fArray[n18] - fArray[n12 + 1];
            f7 = fArray[n18 + 1] + fArray[n12];
            f8 = fArray[n18] + fArray[n12 + 1];
            f9 = fArray[n18 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f4 * f6 - f3 * f7;
            f15 = f4 * f7 + f3 * f6;
            f2 = f19 * f10 - f18 * f11;
            f = f19 * f11 + f18 * f10;
            fArray[n18] = f14 + f2;
            fArray[n18 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f16 * f8 + f17 * f9;
            f15 = f16 * f9 - f17 * f8;
            f2 = f21 * f12 + f20 * f13;
            f = f21 * f13 - f20 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f6 = fArray[n4] - fArray[n12 + 1];
            f7 = fArray[n4 + 1] + fArray[n12];
            f8 = fArray[n4] + fArray[n12 + 1];
            f9 = fArray[n4 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f18 * f6 - f19 * f7;
            f15 = f18 * f7 + f19 * f6;
            f2 = f3 * f10 - f4 * f11;
            f = f3 * f11 + f4 * f10;
            fArray[n4] = f14 + f2;
            fArray[n4 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f20 * f8 + f21 * f9;
            f15 = f20 * f9 - f21 * f8;
            f2 = f17 * f12 + f16 * f13;
            f = f17 * f13 - f16 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
        }
        f4 = fArray2[n3 + n7];
        f3 = fArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f6 = fArray[n4] - fArray[n12 + 1];
        f7 = fArray[n4 + 1] + fArray[n12];
        f8 = fArray[n4] + fArray[n12 + 1];
        f9 = fArray[n4 + 1] - fArray[n12];
        f10 = fArray[n11] - fArray[n13 + 1];
        f11 = fArray[n11 + 1] + fArray[n13];
        f12 = fArray[n11] + fArray[n13 + 1];
        f13 = fArray[n11 + 1] - fArray[n13];
        f14 = f4 * f6 - f3 * f7;
        f15 = f4 * f7 + f3 * f6;
        f2 = f3 * f10 - f4 * f11;
        f = f3 * f11 + f4 * f10;
        fArray[n4] = f14 + f2;
        fArray[n4 + 1] = f15 + f;
        fArray[n11] = f14 - f2;
        fArray[n11 + 1] = f15 - f;
        f14 = f3 * f8 - f4 * f9;
        f15 = f3 * f9 + f4 * f8;
        f2 = f4 * f12 - f3 * f13;
        f = f4 * f13 + f3 * f12;
        fArray[n12] = f14 - f2;
        fArray[n12 + 1] = f15 - f;
        fArray[n13] = f14 + f2;
        fArray[n13 + 1] = f15 + f;
    }

    public static void cftmdl2(long l, D d, long l2, D d2, long l3) {
        long l4;
        long l5;
        float f;
        float f2;
        float f3;
        float f4;
        long l6 = l >> 3;
        long l7 = 2L * l6;
        float f5 = d2.C(l3 + 1L);
        long l8 = l7;
        long l9 = l8 + l7;
        long l10 = l9 + l7;
        long l11 = l2 + l8;
        long l12 = l2 + l9;
        long l13 = l2 + l10;
        float f6 = d.C(l2) - d.C(l12 + 1L);
        float f7 = d.C(l2 + 1L) + d.C(l12);
        float f8 = d.C(l2) + d.C(l12 + 1L);
        float f9 = d.C(l2 + 1L) - d.C(l12);
        float f10 = d.C(l11) - d.C(l13 + 1L);
        float f11 = d.C(l11 + 1L) + d.C(l13);
        float f12 = d.C(l11) + d.C(l13 + 1L);
        float f13 = d.C(l11 + 1L) - d.C(l13);
        float f14 = f5 * (f10 - f11);
        float f15 = f5 * (f11 + f10);
        d.A(l2, f6 + f14);
        d.A(l2 + 1L, f7 + f15);
        d.A(l11, f6 - f14);
        d.A(l11 + 1L, f7 - f15);
        f14 = f5 * (f12 - f13);
        f15 = f5 * (f13 + f12);
        d.A(l12, f8 - f15);
        d.A(l12 + 1L, f9 + f14);
        d.A(l13, f8 + f15);
        d.A(l13 + 1L, f9 - f14);
        long l14 = 0L;
        long l15 = 2L * l7;
        int n = 2;
        while ((long)n < l6) {
            long l16 = l3 + (l14 += 4L);
            f4 = d2.C(l16);
            f3 = d2.C(l16 + 1L);
            float f16 = d2.C(l16 + 2L);
            float f17 = d2.C(l16 + 3L);
            long l17 = l3 + (l15 -= 4L);
            float f18 = d2.C(l17);
            float f19 = d2.C(l17 + 1L);
            float f20 = d2.C(l17 + 2L);
            float f21 = d2.C(l17 + 3L);
            l8 = (long)n + l7;
            l9 = l8 + l7;
            l10 = l9 + l7;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            long l18 = l2 + (long)n;
            f6 = d.C(l18) - d.C(l12 + 1L);
            f7 = d.C(l18 + 1L) + d.C(l12);
            f8 = d.C(l18) + d.C(l12 + 1L);
            f9 = d.C(l18 + 1L) - d.C(l12);
            f10 = d.C(l11) - d.C(l13 + 1L);
            f11 = d.C(l11 + 1L) + d.C(l13);
            f12 = d.C(l11) + d.C(l13 + 1L);
            f13 = d.C(l11 + 1L) - d.C(l13);
            f14 = f4 * f6 - f3 * f7;
            f15 = f4 * f7 + f3 * f6;
            f2 = f19 * f10 - f18 * f11;
            f = f19 * f11 + f18 * f10;
            d.A(l18, f14 + f2);
            d.A(l18 + 1L, f15 + f);
            d.A(l11, f14 - f2);
            d.A(l11 + 1L, f15 - f);
            f14 = f16 * f8 + f17 * f9;
            f15 = f16 * f9 - f17 * f8;
            f2 = f21 * f12 + f20 * f13;
            f = f21 * f13 - f20 * f12;
            d.A(l12, f14 + f2);
            d.A(l12 + 1L, f15 + f);
            d.A(l13, f14 - f2);
            d.A(l13 + 1L, f15 - f);
            l5 = l7 - (long)n;
            l8 = l5 + l7;
            l9 = l8 + l7;
            l10 = l9 + l7;
            l4 = l2 + l5;
            l11 = l2 + l8;
            l12 = l2 + l9;
            l13 = l2 + l10;
            f6 = d.C(l4) - d.C(l12 + 1L);
            f7 = d.C(l4 + 1L) + d.C(l12);
            f8 = d.C(l4) + d.C(l12 + 1L);
            f9 = d.C(l4 + 1L) - d.C(l12);
            f10 = d.C(l11) - d.C(l13 + 1L);
            f11 = d.C(l11 + 1L) + d.C(l13);
            f12 = d.C(l11) + d.C(l13 + 1L);
            f13 = d.C(l11 + 1L) - d.C(l13);
            f14 = f18 * f6 - f19 * f7;
            f15 = f18 * f7 + f19 * f6;
            f2 = f3 * f10 - f4 * f11;
            f = f3 * f11 + f4 * f10;
            d.A(l4, f14 + f2);
            d.A(l4 + 1L, f15 + f);
            d.A(l11, f14 - f2);
            d.A(l11 + 1L, f15 - f);
            f14 = f20 * f8 + f21 * f9;
            f15 = f20 * f9 - f21 * f8;
            f2 = f17 * f12 + f16 * f13;
            f = f17 * f13 - f16 * f12;
            d.A(l12, f14 + f2);
            d.A(l12 + 1L, f15 + f);
            d.A(l13, f14 - f2);
            d.A(l13 + 1L, f15 - f);
            n += 2;
        }
        f4 = d2.C(l3 + l7);
        f3 = d2.C(l3 + l7 + 1L);
        l5 = l6;
        l8 = l5 + l7;
        l9 = l8 + l7;
        l10 = l9 + l7;
        l4 = l2 + l5;
        l11 = l2 + l8;
        l12 = l2 + l9;
        l13 = l2 + l10;
        f6 = d.C(l4) - d.C(l12 + 1L);
        f7 = d.C(l4 + 1L) + d.C(l12);
        f8 = d.C(l4) + d.C(l12 + 1L);
        f9 = d.C(l4 + 1L) - d.C(l12);
        f10 = d.C(l11) - d.C(l13 + 1L);
        f11 = d.C(l11 + 1L) + d.C(l13);
        f12 = d.C(l11) + d.C(l13 + 1L);
        f13 = d.C(l11 + 1L) - d.C(l13);
        f14 = f4 * f6 - f3 * f7;
        f15 = f4 * f7 + f3 * f6;
        f2 = f3 * f10 - f4 * f11;
        f = f3 * f11 + f4 * f10;
        d.A(l4, f14 + f2);
        d.A(l4 + 1L, f15 + f);
        d.A(l11, f14 - f2);
        d.A(l11 + 1L, f15 - f);
        f14 = f3 * f8 - f4 * f9;
        f15 = f3 * f9 + f4 * f8;
        f2 = f4 * f12 - f3 * f13;
        f = f4 * f13 + f3 * f12;
        d.A(l12, f14 - f2);
        d.A(l12 + 1L, f15 - f);
        d.A(l13, f14 + f2);
        d.A(l13 + 1L, f15 + f);
    }

    public static void cftfx41(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        if (n == 128) {
            CommonUtils.cftf161(fArray, n2, fArray2, n3 - 8);
            CommonUtils.cftf162(fArray, n2 + 32, fArray2, n3 - 32);
            CommonUtils.cftf161(fArray, n2 + 64, fArray2, n3 - 8);
            CommonUtils.cftf161(fArray, n2 + 96, fArray2, n3 - 8);
        } else {
            CommonUtils.cftf081(fArray, n2, fArray2, n3 - 8);
            CommonUtils.cftf082(fArray, n2 + 16, fArray2, n3 - 8);
            CommonUtils.cftf081(fArray, n2 + 32, fArray2, n3 - 8);
            CommonUtils.cftf081(fArray, n2 + 48, fArray2, n3 - 8);
        }
    }

    public static void cftfx41(long l, D d, long l2, long l3, D d2) {
        if (l == 128L) {
            CommonUtils.cftf161(d, l2, d2, l3 - 8L);
            CommonUtils.cftf162(d, l2 + 32L, d2, l3 - 32L);
            CommonUtils.cftf161(d, l2 + 64L, d2, l3 - 8L);
            CommonUtils.cftf161(d, l2 + 96L, d2, l3 - 8L);
        } else {
            CommonUtils.cftf081(d, l2, d2, l3 - 8L);
            CommonUtils.cftf082(d, l2 + 16L, d2, l3 - 8L);
            CommonUtils.cftf081(d, l2 + 32L, d2, l3 - 8L);
            CommonUtils.cftf081(d, l2 + 48L, d2, l3 - 8L);
        }
    }

    public static void cftf161(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] + fArray[n + 16];
        float f5 = fArray[n + 1] + fArray[n + 17];
        float f6 = fArray[n] - fArray[n + 16];
        float f7 = fArray[n + 1] - fArray[n + 17];
        float f8 = fArray[n + 8] + fArray[n + 24];
        float f9 = fArray[n + 9] + fArray[n + 25];
        float f10 = fArray[n + 8] - fArray[n + 24];
        float f11 = fArray[n + 9] - fArray[n + 25];
        float f12 = f4 + f8;
        float f13 = f5 + f9;
        float f14 = f4 - f8;
        float f15 = f5 - f9;
        float f16 = f6 - f11;
        float f17 = f7 + f10;
        float f18 = f6 + f11;
        float f19 = f7 - f10;
        f4 = fArray[n + 2] + fArray[n + 18];
        f5 = fArray[n + 3] + fArray[n + 19];
        f6 = fArray[n + 2] - fArray[n + 18];
        f7 = fArray[n + 3] - fArray[n + 19];
        f8 = fArray[n + 10] + fArray[n + 26];
        f9 = fArray[n + 11] + fArray[n + 27];
        f10 = fArray[n + 10] - fArray[n + 26];
        f11 = fArray[n + 11] - fArray[n + 27];
        float f20 = f4 + f8;
        float f21 = f5 + f9;
        float f22 = f4 - f8;
        float f23 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f24 = f2 * f4 - f3 * f5;
        float f25 = f2 * f5 + f3 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f26 = f3 * f4 - f2 * f5;
        float f27 = f3 * f5 + f2 * f4;
        f4 = fArray[n + 4] + fArray[n + 20];
        f5 = fArray[n + 5] + fArray[n + 21];
        f6 = fArray[n + 4] - fArray[n + 20];
        f7 = fArray[n + 5] - fArray[n + 21];
        f8 = fArray[n + 12] + fArray[n + 28];
        f9 = fArray[n + 13] + fArray[n + 29];
        f10 = fArray[n + 12] - fArray[n + 28];
        f11 = fArray[n + 13] - fArray[n + 29];
        float f28 = f4 + f8;
        float f29 = f5 + f9;
        float f30 = f4 - f8;
        float f31 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f32 = f * (f4 - f5);
        float f33 = f * (f5 + f4);
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f34 = f * (f4 + f5);
        float f35 = f * (f5 - f4);
        f4 = fArray[n + 6] + fArray[n + 22];
        f5 = fArray[n + 7] + fArray[n + 23];
        f6 = fArray[n + 6] - fArray[n + 22];
        f7 = fArray[n + 7] - fArray[n + 23];
        f8 = fArray[n + 14] + fArray[n + 30];
        f9 = fArray[n + 15] + fArray[n + 31];
        f10 = fArray[n + 14] - fArray[n + 30];
        f11 = fArray[n + 15] - fArray[n + 31];
        float f36 = f4 + f8;
        float f37 = f5 + f9;
        float f38 = f4 - f8;
        float f39 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f40 = f3 * f4 - f2 * f5;
        float f41 = f3 * f5 + f2 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f42 = f2 * f4 - f3 * f5;
        float f43 = f2 * f5 + f3 * f4;
        f4 = f18 - f34;
        f5 = f19 - f35;
        f6 = f18 + f34;
        f7 = f19 + f35;
        f8 = f26 - f42;
        f9 = f27 - f43;
        f10 = f26 + f42;
        f11 = f27 + f43;
        fArray[n + 24] = f4 + f8;
        fArray[n + 25] = f5 + f9;
        fArray[n + 26] = f4 - f8;
        fArray[n + 27] = f5 - f9;
        fArray[n + 28] = f6 - f11;
        fArray[n + 29] = f7 + f10;
        fArray[n + 30] = f6 + f11;
        fArray[n + 31] = f7 - f10;
        f4 = f16 + f32;
        f5 = f17 + f33;
        f6 = f16 - f32;
        f7 = f17 - f33;
        f8 = f24 + f40;
        f9 = f25 + f41;
        f10 = f24 - f40;
        f11 = f25 - f41;
        fArray[n + 16] = f4 + f8;
        fArray[n + 17] = f5 + f9;
        fArray[n + 18] = f4 - f8;
        fArray[n + 19] = f5 - f9;
        fArray[n + 20] = f6 - f11;
        fArray[n + 21] = f7 + f10;
        fArray[n + 22] = f6 + f11;
        fArray[n + 23] = f7 - f10;
        f4 = f22 - f39;
        f5 = f23 + f38;
        f8 = f * (f4 - f5);
        f9 = f * (f5 + f4);
        f4 = f22 + f39;
        f5 = f23 - f38;
        f10 = f * (f4 - f5);
        f11 = f * (f5 + f4);
        f4 = f14 - f31;
        f5 = f15 + f30;
        f6 = f14 + f31;
        f7 = f15 - f30;
        fArray[n + 8] = f4 + f8;
        fArray[n + 9] = f5 + f9;
        fArray[n + 10] = f4 - f8;
        fArray[n + 11] = f5 - f9;
        fArray[n + 12] = f6 - f11;
        fArray[n + 13] = f7 + f10;
        fArray[n + 14] = f6 + f11;
        fArray[n + 15] = f7 - f10;
        f4 = f12 + f28;
        f5 = f13 + f29;
        f6 = f12 - f28;
        f7 = f13 - f29;
        f8 = f20 + f36;
        f9 = f21 + f37;
        f10 = f20 - f36;
        f11 = f21 - f37;
        fArray[n] = f4 + f8;
        fArray[n + 1] = f5 + f9;
        fArray[n + 2] = f4 - f8;
        fArray[n + 3] = f5 - f9;
        fArray[n + 4] = f6 - f11;
        fArray[n + 5] = f7 + f10;
        fArray[n + 6] = f6 + f11;
        fArray[n + 7] = f7 - f10;
    }

    public static void cftf161(D d, long l, D d2, long l2) {
        float f = d2.C(l2 + 1L);
        float f2 = d2.C(l2 + 2L);
        float f3 = d2.C(l2 + 3L);
        float f4 = d.C(l) + d.C(l + 16L);
        float f5 = d.C(l + 1L) + d.C(l + 17L);
        float f6 = d.C(l) - d.C(l + 16L);
        float f7 = d.C(l + 1L) - d.C(l + 17L);
        float f8 = d.C(l + 8L) + d.C(l + 24L);
        float f9 = d.C(l + 9L) + d.C(l + 25L);
        float f10 = d.C(l + 8L) - d.C(l + 24L);
        float f11 = d.C(l + 9L) - d.C(l + 25L);
        float f12 = f4 + f8;
        float f13 = f5 + f9;
        float f14 = f4 - f8;
        float f15 = f5 - f9;
        float f16 = f6 - f11;
        float f17 = f7 + f10;
        float f18 = f6 + f11;
        float f19 = f7 - f10;
        f4 = d.C(l + 2L) + d.C(l + 18L);
        f5 = d.C(l + 3L) + d.C(l + 19L);
        f6 = d.C(l + 2L) - d.C(l + 18L);
        f7 = d.C(l + 3L) - d.C(l + 19L);
        f8 = d.C(l + 10L) + d.C(l + 26L);
        f9 = d.C(l + 11L) + d.C(l + 27L);
        f10 = d.C(l + 10L) - d.C(l + 26L);
        f11 = d.C(l + 11L) - d.C(l + 27L);
        float f20 = f4 + f8;
        float f21 = f5 + f9;
        float f22 = f4 - f8;
        float f23 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f24 = f2 * f4 - f3 * f5;
        float f25 = f2 * f5 + f3 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f26 = f3 * f4 - f2 * f5;
        float f27 = f3 * f5 + f2 * f4;
        f4 = d.C(l + 4L) + d.C(l + 20L);
        f5 = d.C(l + 5L) + d.C(l + 21L);
        f6 = d.C(l + 4L) - d.C(l + 20L);
        f7 = d.C(l + 5L) - d.C(l + 21L);
        f8 = d.C(l + 12L) + d.C(l + 28L);
        f9 = d.C(l + 13L) + d.C(l + 29L);
        f10 = d.C(l + 12L) - d.C(l + 28L);
        f11 = d.C(l + 13L) - d.C(l + 29L);
        float f28 = f4 + f8;
        float f29 = f5 + f9;
        float f30 = f4 - f8;
        float f31 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f32 = f * (f4 - f5);
        float f33 = f * (f5 + f4);
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f34 = f * (f4 + f5);
        float f35 = f * (f5 - f4);
        f4 = d.C(l + 6L) + d.C(l + 22L);
        f5 = d.C(l + 7L) + d.C(l + 23L);
        f6 = d.C(l + 6L) - d.C(l + 22L);
        f7 = d.C(l + 7L) - d.C(l + 23L);
        f8 = d.C(l + 14L) + d.C(l + 30L);
        f9 = d.C(l + 15L) + d.C(l + 31L);
        f10 = d.C(l + 14L) - d.C(l + 30L);
        f11 = d.C(l + 15L) - d.C(l + 31L);
        float f36 = f4 + f8;
        float f37 = f5 + f9;
        float f38 = f4 - f8;
        float f39 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f40 = f3 * f4 - f2 * f5;
        float f41 = f3 * f5 + f2 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f42 = f2 * f4 - f3 * f5;
        float f43 = f2 * f5 + f3 * f4;
        f4 = f18 - f34;
        f5 = f19 - f35;
        f6 = f18 + f34;
        f7 = f19 + f35;
        f8 = f26 - f42;
        f9 = f27 - f43;
        f10 = f26 + f42;
        f11 = f27 + f43;
        d.A(l + 24L, f4 + f8);
        d.A(l + 25L, f5 + f9);
        d.A(l + 26L, f4 - f8);
        d.A(l + 27L, f5 - f9);
        d.A(l + 28L, f6 - f11);
        d.A(l + 29L, f7 + f10);
        d.A(l + 30L, f6 + f11);
        d.A(l + 31L, f7 - f10);
        f4 = f16 + f32;
        f5 = f17 + f33;
        f6 = f16 - f32;
        f7 = f17 - f33;
        f8 = f24 + f40;
        f9 = f25 + f41;
        f10 = f24 - f40;
        f11 = f25 - f41;
        d.A(l + 16L, f4 + f8);
        d.A(l + 17L, f5 + f9);
        d.A(l + 18L, f4 - f8);
        d.A(l + 19L, f5 - f9);
        d.A(l + 20L, f6 - f11);
        d.A(l + 21L, f7 + f10);
        d.A(l + 22L, f6 + f11);
        d.A(l + 23L, f7 - f10);
        f4 = f22 - f39;
        f5 = f23 + f38;
        f8 = f * (f4 - f5);
        f9 = f * (f5 + f4);
        f4 = f22 + f39;
        f5 = f23 - f38;
        f10 = f * (f4 - f5);
        f11 = f * (f5 + f4);
        f4 = f14 - f31;
        f5 = f15 + f30;
        f6 = f14 + f31;
        f7 = f15 - f30;
        d.A(l + 8L, f4 + f8);
        d.A(l + 9L, f5 + f9);
        d.A(l + 10L, f4 - f8);
        d.A(l + 11L, f5 - f9);
        d.A(l + 12L, f6 - f11);
        d.A(l + 13L, f7 + f10);
        d.A(l + 14L, f6 + f11);
        d.A(l + 15L, f7 - f10);
        f4 = f12 + f28;
        f5 = f13 + f29;
        f6 = f12 - f28;
        f7 = f13 - f29;
        f8 = f20 + f36;
        f9 = f21 + f37;
        f10 = f20 - f36;
        f11 = f21 - f37;
        d.A(l, f4 + f8);
        d.A(l + 1L, f5 + f9);
        d.A(l + 2L, f4 - f8);
        d.A(l + 3L, f5 - f9);
        d.A(l + 4L, f6 - f11);
        d.A(l + 5L, f7 + f10);
        d.A(l + 6L, f6 + f11);
        d.A(l + 7L, f7 - f10);
    }

    public static void cftf162(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 4];
        float f3 = fArray2[n2 + 5];
        float f4 = fArray2[n2 + 6];
        float f5 = -fArray2[n2 + 7];
        float f6 = fArray2[n2 + 8];
        float f7 = fArray2[n2 + 9];
        float f8 = fArray[n] - fArray[n + 17];
        float f9 = fArray[n + 1] + fArray[n + 16];
        float f10 = fArray[n + 8] - fArray[n + 25];
        float f11 = fArray[n + 9] + fArray[n + 24];
        float f12 = f * (f10 - f11);
        float f13 = f * (f11 + f10);
        float f14 = f8 + f12;
        float f15 = f9 + f13;
        float f16 = f8 - f12;
        float f17 = f9 - f13;
        f8 = fArray[n] + fArray[n + 17];
        f9 = fArray[n + 1] - fArray[n + 16];
        f10 = fArray[n + 8] + fArray[n + 25];
        f11 = fArray[n + 9] - fArray[n + 24];
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        float f18 = f8 - f13;
        float f19 = f9 + f12;
        float f20 = f8 + f13;
        float f21 = f9 - f12;
        f10 = fArray[n + 2] - fArray[n + 19];
        f11 = fArray[n + 3] + fArray[n + 18];
        f8 = f2 * f10 - f3 * f11;
        f9 = f2 * f11 + f3 * f10;
        f10 = fArray[n + 10] - fArray[n + 27];
        f11 = fArray[n + 11] + fArray[n + 26];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f22 = f8 + f12;
        float f23 = f9 + f13;
        float f24 = f8 - f12;
        float f25 = f9 - f13;
        f10 = fArray[n + 2] + fArray[n + 19];
        f11 = fArray[n + 3] - fArray[n + 18];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 10] + fArray[n + 27];
        f11 = fArray[n + 11] - fArray[n + 26];
        f12 = f2 * f10 + f3 * f11;
        f13 = f2 * f11 - f3 * f10;
        float f26 = f8 - f12;
        float f27 = f9 - f13;
        float f28 = f8 + f12;
        float f29 = f9 + f13;
        f10 = fArray[n + 4] - fArray[n + 21];
        f11 = fArray[n + 5] + fArray[n + 20];
        f8 = f6 * f10 - f7 * f11;
        f9 = f6 * f11 + f7 * f10;
        f10 = fArray[n + 12] - fArray[n + 29];
        f11 = fArray[n + 13] + fArray[n + 28];
        f12 = f7 * f10 - f6 * f11;
        f13 = f7 * f11 + f6 * f10;
        float f30 = f8 + f12;
        float f31 = f9 + f13;
        float f32 = f8 - f12;
        float f33 = f9 - f13;
        f10 = fArray[n + 4] + fArray[n + 21];
        f11 = fArray[n + 5] - fArray[n + 20];
        f8 = f7 * f10 - f6 * f11;
        f9 = f7 * f11 + f6 * f10;
        f10 = fArray[n + 12] + fArray[n + 29];
        f11 = fArray[n + 13] - fArray[n + 28];
        f12 = f6 * f10 - f7 * f11;
        f13 = f6 * f11 + f7 * f10;
        float f34 = f8 - f12;
        float f35 = f9 - f13;
        float f36 = f8 + f12;
        float f37 = f9 + f13;
        f10 = fArray[n + 6] - fArray[n + 23];
        f11 = fArray[n + 7] + fArray[n + 22];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 14] - fArray[n + 31];
        f11 = fArray[n + 15] + fArray[n + 30];
        f12 = f3 * f10 - f2 * f11;
        f13 = f3 * f11 + f2 * f10;
        float f38 = f8 + f12;
        float f39 = f9 + f13;
        float f40 = f8 - f12;
        float f41 = f9 - f13;
        f10 = fArray[n + 6] + fArray[n + 23];
        f11 = fArray[n + 7] - fArray[n + 22];
        f8 = f3 * f10 + f2 * f11;
        f9 = f3 * f11 - f2 * f10;
        f10 = fArray[n + 14] + fArray[n + 31];
        f11 = fArray[n + 15] - fArray[n + 30];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f42 = f8 + f12;
        float f43 = f9 + f13;
        float f44 = f8 - f12;
        float f45 = f9 - f13;
        f8 = f14 + f30;
        f9 = f15 + f31;
        f12 = f22 + f38;
        f13 = f23 + f39;
        fArray[n] = f8 + f12;
        fArray[n + 1] = f9 + f13;
        fArray[n + 2] = f8 - f12;
        fArray[n + 3] = f9 - f13;
        f8 = f14 - f30;
        f9 = f15 - f31;
        f12 = f22 - f38;
        f13 = f23 - f39;
        fArray[n + 4] = f8 - f13;
        fArray[n + 5] = f9 + f12;
        fArray[n + 6] = f8 + f13;
        fArray[n + 7] = f9 - f12;
        f8 = f16 - f33;
        f9 = f17 + f32;
        f10 = f24 - f41;
        f11 = f25 + f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 8] = f8 + f12;
        fArray[n + 9] = f9 + f13;
        fArray[n + 10] = f8 - f12;
        fArray[n + 11] = f9 - f13;
        f8 = f16 + f33;
        f9 = f17 - f32;
        f10 = f24 + f41;
        f11 = f25 - f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 12] = f8 - f13;
        fArray[n + 13] = f9 + f12;
        fArray[n + 14] = f8 + f13;
        fArray[n + 15] = f9 - f12;
        f8 = f18 + f34;
        f9 = f19 + f35;
        f12 = f26 - f42;
        f13 = f27 - f43;
        fArray[n + 16] = f8 + f12;
        fArray[n + 17] = f9 + f13;
        fArray[n + 18] = f8 - f12;
        fArray[n + 19] = f9 - f13;
        f8 = f18 - f34;
        f9 = f19 - f35;
        f12 = f26 + f42;
        f13 = f27 + f43;
        fArray[n + 20] = f8 - f13;
        fArray[n + 21] = f9 + f12;
        fArray[n + 22] = f8 + f13;
        fArray[n + 23] = f9 - f12;
        f8 = f20 - f37;
        f9 = f21 + f36;
        f10 = f28 + f45;
        f11 = f29 - f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 24] = f8 + f12;
        fArray[n + 25] = f9 + f13;
        fArray[n + 26] = f8 - f12;
        fArray[n + 27] = f9 - f13;
        f8 = f20 + f37;
        f9 = f21 - f36;
        f10 = f28 - f45;
        f11 = f29 + f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 28] = f8 - f13;
        fArray[n + 29] = f9 + f12;
        fArray[n + 30] = f8 + f13;
        fArray[n + 31] = f9 - f12;
    }

    public static void cftf162(D d, long l, D d2, long l2) {
        float f = d2.C(l2 + 1L);
        float f2 = d2.C(l2 + 4L);
        float f3 = d2.C(l2 + 5L);
        float f4 = d2.C(l2 + 6L);
        float f5 = -d2.C(l2 + 7L);
        float f6 = d2.C(l2 + 8L);
        float f7 = d2.C(l2 + 9L);
        float f8 = d.C(l) - d.C(l + 17L);
        float f9 = d.C(l + 1L) + d.C(l + 16L);
        float f10 = d.C(l + 8L) - d.C(l + 25L);
        float f11 = d.C(l + 9L) + d.C(l + 24L);
        float f12 = f * (f10 - f11);
        float f13 = f * (f11 + f10);
        float f14 = f8 + f12;
        float f15 = f9 + f13;
        float f16 = f8 - f12;
        float f17 = f9 - f13;
        f8 = d.C(l) + d.C(l + 17L);
        f9 = d.C(l + 1L) - d.C(l + 16L);
        f10 = d.C(l + 8L) + d.C(l + 25L);
        f11 = d.C(l + 9L) - d.C(l + 24L);
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        float f18 = f8 - f13;
        float f19 = f9 + f12;
        float f20 = f8 + f13;
        float f21 = f9 - f12;
        f10 = d.C(l + 2L) - d.C(l + 19L);
        f11 = d.C(l + 3L) + d.C(l + 18L);
        f8 = f2 * f10 - f3 * f11;
        f9 = f2 * f11 + f3 * f10;
        f10 = d.C(l + 10L) - d.C(l + 27L);
        f11 = d.C(l + 11L) + d.C(l + 26L);
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f22 = f8 + f12;
        float f23 = f9 + f13;
        float f24 = f8 - f12;
        float f25 = f9 - f13;
        f10 = d.C(l + 2L) + d.C(l + 19L);
        f11 = d.C(l + 3L) - d.C(l + 18L);
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = d.C(l + 10L) + d.C(l + 27L);
        f11 = d.C(l + 11L) - d.C(l + 26L);
        f12 = f2 * f10 + f3 * f11;
        f13 = f2 * f11 - f3 * f10;
        float f26 = f8 - f12;
        float f27 = f9 - f13;
        float f28 = f8 + f12;
        float f29 = f9 + f13;
        f10 = d.C(l + 4L) - d.C(l + 21L);
        f11 = d.C(l + 5L) + d.C(l + 20L);
        f8 = f6 * f10 - f7 * f11;
        f9 = f6 * f11 + f7 * f10;
        f10 = d.C(l + 12L) - d.C(l + 29L);
        f11 = d.C(l + 13L) + d.C(l + 28L);
        f12 = f7 * f10 - f6 * f11;
        f13 = f7 * f11 + f6 * f10;
        float f30 = f8 + f12;
        float f31 = f9 + f13;
        float f32 = f8 - f12;
        float f33 = f9 - f13;
        f10 = d.C(l + 4L) + d.C(l + 21L);
        f11 = d.C(l + 5L) - d.C(l + 20L);
        f8 = f7 * f10 - f6 * f11;
        f9 = f7 * f11 + f6 * f10;
        f10 = d.C(l + 12L) + d.C(l + 29L);
        f11 = d.C(l + 13L) - d.C(l + 28L);
        f12 = f6 * f10 - f7 * f11;
        f13 = f6 * f11 + f7 * f10;
        float f34 = f8 - f12;
        float f35 = f9 - f13;
        float f36 = f8 + f12;
        float f37 = f9 + f13;
        f10 = d.C(l + 6L) - d.C(l + 23L);
        f11 = d.C(l + 7L) + d.C(l + 22L);
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = d.C(l + 14L) - d.C(l + 31L);
        f11 = d.C(l + 15L) + d.C(l + 30L);
        f12 = f3 * f10 - f2 * f11;
        f13 = f3 * f11 + f2 * f10;
        float f38 = f8 + f12;
        float f39 = f9 + f13;
        float f40 = f8 - f12;
        float f41 = f9 - f13;
        f10 = d.C(l + 6L) + d.C(l + 23L);
        f11 = d.C(l + 7L) - d.C(l + 22L);
        f8 = f3 * f10 + f2 * f11;
        f9 = f3 * f11 - f2 * f10;
        f10 = d.C(l + 14L) + d.C(l + 31L);
        f11 = d.C(l + 15L) - d.C(l + 30L);
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f42 = f8 + f12;
        float f43 = f9 + f13;
        float f44 = f8 - f12;
        float f45 = f9 - f13;
        f8 = f14 + f30;
        f9 = f15 + f31;
        f12 = f22 + f38;
        f13 = f23 + f39;
        d.A(l, f8 + f12);
        d.A(l + 1L, f9 + f13);
        d.A(l + 2L, f8 - f12);
        d.A(l + 3L, f9 - f13);
        f8 = f14 - f30;
        f9 = f15 - f31;
        f12 = f22 - f38;
        f13 = f23 - f39;
        d.A(l + 4L, f8 - f13);
        d.A(l + 5L, f9 + f12);
        d.A(l + 6L, f8 + f13);
        d.A(l + 7L, f9 - f12);
        f8 = f16 - f33;
        f9 = f17 + f32;
        f10 = f24 - f41;
        f11 = f25 + f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        d.A(l + 8L, f8 + f12);
        d.A(l + 9L, f9 + f13);
        d.A(l + 10L, f8 - f12);
        d.A(l + 11L, f9 - f13);
        f8 = f16 + f33;
        f9 = f17 - f32;
        f10 = f24 + f41;
        f11 = f25 - f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        d.A(l + 12L, f8 - f13);
        d.A(l + 13L, f9 + f12);
        d.A(l + 14L, f8 + f13);
        d.A(l + 15L, f9 - f12);
        f8 = f18 + f34;
        f9 = f19 + f35;
        f12 = f26 - f42;
        f13 = f27 - f43;
        d.A(l + 16L, f8 + f12);
        d.A(l + 17L, f9 + f13);
        d.A(l + 18L, f8 - f12);
        d.A(l + 19L, f9 - f13);
        f8 = f18 - f34;
        f9 = f19 - f35;
        f12 = f26 + f42;
        f13 = f27 + f43;
        d.A(l + 20L, f8 - f13);
        d.A(l + 21L, f9 + f12);
        d.A(l + 22L, f8 + f13);
        d.A(l + 23L, f9 - f12);
        f8 = f20 - f37;
        f9 = f21 + f36;
        f10 = f28 + f45;
        f11 = f29 - f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        d.A(l + 24L, f8 + f12);
        d.A(l + 25L, f9 + f13);
        d.A(l + 26L, f8 - f12);
        d.A(l + 27L, f9 - f13);
        f8 = f20 + f37;
        f9 = f21 - f36;
        f10 = f28 - f45;
        f11 = f29 + f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        d.A(l + 28L, f8 - f13);
        d.A(l + 29L, f9 + f12);
        d.A(l + 30L, f8 + f13);
        d.A(l + 31L, f9 - f12);
    }

    public static void cftf081(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray[n] + fArray[n + 8];
        float f3 = fArray[n + 1] + fArray[n + 9];
        float f4 = fArray[n] - fArray[n + 8];
        float f5 = fArray[n + 1] - fArray[n + 9];
        float f6 = fArray[n + 4] + fArray[n + 12];
        float f7 = fArray[n + 5] + fArray[n + 13];
        float f8 = fArray[n + 4] - fArray[n + 12];
        float f9 = fArray[n + 5] - fArray[n + 13];
        float f10 = f2 + f6;
        float f11 = f3 + f7;
        float f12 = f2 - f6;
        float f13 = f3 - f7;
        float f14 = f4 - f9;
        float f15 = f5 + f8;
        float f16 = f4 + f9;
        float f17 = f5 - f8;
        f2 = fArray[n + 2] + fArray[n + 10];
        f3 = fArray[n + 3] + fArray[n + 11];
        f4 = fArray[n + 2] - fArray[n + 10];
        f5 = fArray[n + 3] - fArray[n + 11];
        f6 = fArray[n + 6] + fArray[n + 14];
        f7 = fArray[n + 7] + fArray[n + 15];
        f8 = fArray[n + 6] - fArray[n + 14];
        f9 = fArray[n + 7] - fArray[n + 15];
        float f18 = f2 + f6;
        float f19 = f3 + f7;
        float f20 = f2 - f6;
        float f21 = f3 - f7;
        f2 = f4 - f9;
        f3 = f5 + f8;
        f6 = f4 + f9;
        f7 = f5 - f8;
        float f22 = f * (f2 - f3);
        float f23 = f * (f2 + f3);
        float f24 = f * (f6 - f7);
        float f25 = f * (f6 + f7);
        fArray[n + 8] = f14 + f22;
        fArray[n + 9] = f15 + f23;
        fArray[n + 10] = f14 - f22;
        fArray[n + 11] = f15 - f23;
        fArray[n + 12] = f16 - f25;
        fArray[n + 13] = f17 + f24;
        fArray[n + 14] = f16 + f25;
        fArray[n + 15] = f17 - f24;
        fArray[n] = f10 + f18;
        fArray[n + 1] = f11 + f19;
        fArray[n + 2] = f10 - f18;
        fArray[n + 3] = f11 - f19;
        fArray[n + 4] = f12 - f21;
        fArray[n + 5] = f13 + f20;
        fArray[n + 6] = f12 + f21;
        fArray[n + 7] = f13 - f20;
    }

    public static void cftf081(D d, long l, D d2, long l2) {
        float f = d2.C(l2 + 1L);
        float f2 = d.C(l) + d.C(l + 8L);
        float f3 = d.C(l + 1L) + d.C(l + 9L);
        float f4 = d.C(l) - d.C(l + 8L);
        float f5 = d.C(l + 1L) - d.C(l + 9L);
        float f6 = d.C(l + 4L) + d.C(l + 12L);
        float f7 = d.C(l + 5L) + d.C(l + 13L);
        float f8 = d.C(l + 4L) - d.C(l + 12L);
        float f9 = d.C(l + 5L) - d.C(l + 13L);
        float f10 = f2 + f6;
        float f11 = f3 + f7;
        float f12 = f2 - f6;
        float f13 = f3 - f7;
        float f14 = f4 - f9;
        float f15 = f5 + f8;
        float f16 = f4 + f9;
        float f17 = f5 - f8;
        f2 = d.C(l + 2L) + d.C(l + 10L);
        f3 = d.C(l + 3L) + d.C(l + 11L);
        f4 = d.C(l + 2L) - d.C(l + 10L);
        f5 = d.C(l + 3L) - d.C(l + 11L);
        f6 = d.C(l + 6L) + d.C(l + 14L);
        f7 = d.C(l + 7L) + d.C(l + 15L);
        f8 = d.C(l + 6L) - d.C(l + 14L);
        f9 = d.C(l + 7L) - d.C(l + 15L);
        float f18 = f2 + f6;
        float f19 = f3 + f7;
        float f20 = f2 - f6;
        float f21 = f3 - f7;
        f2 = f4 - f9;
        f3 = f5 + f8;
        f6 = f4 + f9;
        f7 = f5 - f8;
        float f22 = f * (f2 - f3);
        float f23 = f * (f2 + f3);
        float f24 = f * (f6 - f7);
        float f25 = f * (f6 + f7);
        d.A(l + 8L, f14 + f22);
        d.A(l + 9L, f15 + f23);
        d.A(l + 10L, f14 - f22);
        d.A(l + 11L, f15 - f23);
        d.A(l + 12L, f16 - f25);
        d.A(l + 13L, f17 + f24);
        d.A(l + 14L, f16 + f25);
        d.A(l + 15L, f17 - f24);
        d.A(l, f10 + f18);
        d.A(l + 1L, f11 + f19);
        d.A(l + 2L, f10 - f18);
        d.A(l + 3L, f11 - f19);
        d.A(l + 4L, f12 - f21);
        d.A(l + 5L, f13 + f20);
        d.A(l + 6L, f12 + f21);
        d.A(l + 7L, f13 - f20);
    }

    public static void cftf082(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] - fArray[n + 9];
        float f5 = fArray[n + 1] + fArray[n + 8];
        float f6 = fArray[n] + fArray[n + 9];
        float f7 = fArray[n + 1] - fArray[n + 8];
        float f8 = fArray[n + 4] - fArray[n + 13];
        float f9 = fArray[n + 5] + fArray[n + 12];
        float f10 = f * (f8 - f9);
        float f11 = f * (f9 + f8);
        f8 = fArray[n + 4] + fArray[n + 13];
        f9 = fArray[n + 5] - fArray[n + 12];
        float f12 = f * (f8 - f9);
        float f13 = f * (f9 + f8);
        f8 = fArray[n + 2] - fArray[n + 11];
        f9 = fArray[n + 3] + fArray[n + 10];
        float f14 = f2 * f8 - f3 * f9;
        float f15 = f2 * f9 + f3 * f8;
        f8 = fArray[n + 2] + fArray[n + 11];
        f9 = fArray[n + 3] - fArray[n + 10];
        float f16 = f3 * f8 - f2 * f9;
        float f17 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] - fArray[n + 15];
        f9 = fArray[n + 7] + fArray[n + 14];
        float f18 = f3 * f8 - f2 * f9;
        float f19 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] + fArray[n + 15];
        f9 = fArray[n + 7] - fArray[n + 14];
        float f20 = f2 * f8 - f3 * f9;
        float f21 = f2 * f9 + f3 * f8;
        f8 = f4 + f10;
        f9 = f5 + f11;
        float f22 = f14 + f18;
        float f23 = f15 + f19;
        fArray[n] = f8 + f22;
        fArray[n + 1] = f9 + f23;
        fArray[n + 2] = f8 - f22;
        fArray[n + 3] = f9 - f23;
        f8 = f4 - f10;
        f9 = f5 - f11;
        f22 = f14 - f18;
        f23 = f15 - f19;
        fArray[n + 4] = f8 - f23;
        fArray[n + 5] = f9 + f22;
        fArray[n + 6] = f8 + f23;
        fArray[n + 7] = f9 - f22;
        f8 = f6 - f13;
        f9 = f7 + f12;
        f22 = f16 - f20;
        f23 = f17 - f21;
        fArray[n + 8] = f8 + f22;
        fArray[n + 9] = f9 + f23;
        fArray[n + 10] = f8 - f22;
        fArray[n + 11] = f9 - f23;
        f8 = f6 + f13;
        f9 = f7 - f12;
        f22 = f16 + f20;
        f23 = f17 + f21;
        fArray[n + 12] = f8 - f23;
        fArray[n + 13] = f9 + f22;
        fArray[n + 14] = f8 + f23;
        fArray[n + 15] = f9 - f22;
    }

    public static void cftf082(D d, long l, D d2, long l2) {
        float f = d2.C(l2 + 1L);
        float f2 = d2.C(l2 + 2L);
        float f3 = d2.C(l2 + 3L);
        float f4 = d.C(l) - d.C(l + 9L);
        float f5 = d.C(l + 1L) + d.C(l + 8L);
        float f6 = d.C(l) + d.C(l + 9L);
        float f7 = d.C(l + 1L) - d.C(l + 8L);
        float f8 = d.C(l + 4L) - d.C(l + 13L);
        float f9 = d.C(l + 5L) + d.C(l + 12L);
        float f10 = f * (f8 - f9);
        float f11 = f * (f9 + f8);
        f8 = d.C(l + 4L) + d.C(l + 13L);
        f9 = d.C(l + 5L) - d.C(l + 12L);
        float f12 = f * (f8 - f9);
        float f13 = f * (f9 + f8);
        f8 = d.C(l + 2L) - d.C(l + 11L);
        f9 = d.C(l + 3L) + d.C(l + 10L);
        float f14 = f2 * f8 - f3 * f9;
        float f15 = f2 * f9 + f3 * f8;
        f8 = d.C(l + 2L) + d.C(l + 11L);
        f9 = d.C(l + 3L) - d.C(l + 10L);
        float f16 = f3 * f8 - f2 * f9;
        float f17 = f3 * f9 + f2 * f8;
        f8 = d.C(l + 6L) - d.C(l + 15L);
        f9 = d.C(l + 7L) + d.C(l + 14L);
        float f18 = f3 * f8 - f2 * f9;
        float f19 = f3 * f9 + f2 * f8;
        f8 = d.C(l + 6L) + d.C(l + 15L);
        f9 = d.C(l + 7L) - d.C(l + 14L);
        float f20 = f2 * f8 - f3 * f9;
        float f21 = f2 * f9 + f3 * f8;
        f8 = f4 + f10;
        f9 = f5 + f11;
        float f22 = f14 + f18;
        float f23 = f15 + f19;
        d.A(l, f8 + f22);
        d.A(l + 1L, f9 + f23);
        d.A(l + 2L, f8 - f22);
        d.A(l + 3L, f9 - f23);
        f8 = f4 - f10;
        f9 = f5 - f11;
        f22 = f14 - f18;
        f23 = f15 - f19;
        d.A(l + 4L, f8 - f23);
        d.A(l + 5L, f9 + f22);
        d.A(l + 6L, f8 + f23);
        d.A(l + 7L, f9 - f22);
        f8 = f6 - f13;
        f9 = f7 + f12;
        f22 = f16 - f20;
        f23 = f17 - f21;
        d.A(l + 8L, f8 + f22);
        d.A(l + 9L, f9 + f23);
        d.A(l + 10L, f8 - f22);
        d.A(l + 11L, f9 - f23);
        f8 = f6 + f13;
        f9 = f7 - f12;
        f22 = f16 + f20;
        f23 = f17 + f21;
        d.A(l + 12L, f8 - f23);
        d.A(l + 13L, f9 + f22);
        d.A(l + 14L, f8 + f23);
        d.A(l + 15L, f9 - f22);
    }

    public static void cftf040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 - f8;
        fArray[n + 3] = f4 + f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 + f8;
        fArray[n + 7] = f4 - f7;
    }

    public static void cftf040(D d, long l) {
        float f = d.C(l) + d.C(l + 4L);
        float f2 = d.C(l + 1L) + d.C(l + 5L);
        float f3 = d.C(l) - d.C(l + 4L);
        float f4 = d.C(l + 1L) - d.C(l + 5L);
        float f5 = d.C(l + 2L) + d.C(l + 6L);
        float f6 = d.C(l + 3L) + d.C(l + 7L);
        float f7 = d.C(l + 2L) - d.C(l + 6L);
        float f8 = d.C(l + 3L) - d.C(l + 7L);
        d.A(l, f + f5);
        d.A(l + 1L, f2 + f6);
        d.A(l + 2L, f3 - f8);
        d.A(l + 3L, f4 + f7);
        d.A(l + 4L, f - f5);
        d.A(l + 5L, f2 - f6);
        d.A(l + 6L, f3 + f8);
        d.A(l + 7L, f4 - f7);
    }

    public static void cftb040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 + f8;
        fArray[n + 3] = f4 - f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 - f8;
        fArray[n + 7] = f4 + f7;
    }

    public static void cftb040(D d, long l) {
        float f = d.C(l) + d.C(l + 4L);
        float f2 = d.C(l + 1L) + d.C(l + 5L);
        float f3 = d.C(l) - d.C(l + 4L);
        float f4 = d.C(l + 1L) - d.C(l + 5L);
        float f5 = d.C(l + 2L) + d.C(l + 6L);
        float f6 = d.C(l + 3L) + d.C(l + 7L);
        float f7 = d.C(l + 2L) - d.C(l + 6L);
        float f8 = d.C(l + 3L) - d.C(l + 7L);
        d.A(l, f + f5);
        d.A(l + 1L, f2 + f6);
        d.A(l + 2L, f3 + f8);
        d.A(l + 3L, f4 - f7);
        d.A(l + 4L, f - f5);
        d.A(l + 5L, f2 - f6);
        d.A(l + 6L, f3 - f8);
        d.A(l + 7L, f4 + f7);
    }

    public static void cftx020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = -fArray[n + 1] + fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    public static void cftx020(D d, long l) {
        float f = d.C(l) - d.C(l + 2L);
        float f2 = -d.C(l + 1L) + d.C(l + 3L);
        d.A(l, d.C(l) + d.C(l + 2L));
        d.A(l + 1L, d.C(l + 1L) + d.C(l + 3L));
        d.A(l + 2L, f);
        d.A(l + 3L, f2);
    }

    public static void cftxb020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = fArray[n + 1] - fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    public static void cftxb020(D d, long l) {
        float f = d.C(l) - d.C(l + 2L);
        float f2 = d.C(l + 1L) - d.C(l + 3L);
        d.A(l, d.C(l) + d.C(l + 2L));
        d.A(l + 1L, d.C(l + 1L) + d.C(l + 3L));
        d.A(l + 2L, f);
        d.A(l + 3L, f2);
    }

    public static void cftxc020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = fArray[n + 1] + fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] - fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    public static void cftxc020(D d, long l) {
        float f = d.C(l) - d.C(l + 2L);
        float f2 = d.C(l + 1L) + d.C(l + 3L);
        d.A(l, d.C(l) + d.C(l + 2L));
        d.A(l + 1L, d.C(l + 1L) - d.C(l + 3L));
        d.A(l + 2L, f);
        d.A(l + 3L, f2);
    }

    public static void rftfsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = 0.5f - fArray2[n4 + n3 - (n7 += n6)];
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            fArray[n9 + 1] = f6 - fArray[n9 + 1];
            int n12 = n10;
            fArray[n12] = fArray[n12] + f5;
            fArray[n10 + 1] = f6 - fArray[n10 + 1];
        }
        fArray[n2 + n5 + 1] = -fArray[n2 + n5 + 1];
    }

    public static void rftfsub(long l, D d, long l2, long l3, D d2, long l4) {
        long l5 = l >> 1;
        long l6 = 2L * l3 / l5;
        long l7 = 0L;
        for (long i = 2L; i < l5; i += 2L) {
            long l8 = l - i;
            float f = 0.5f - d2.C(l4 + l3 - (l7 += l6));
            float f2 = d2.C(l4 + l7);
            long l9 = l2 + i;
            long l10 = l2 + l8;
            float f3 = d.C(l9) - d.C(l10);
            float f4 = d.C(l9 + 1L) + d.C(l10 + 1L);
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            d.A(l9, d.C(l9) - f5);
            d.A(l9 + 1L, f6 - d.C(l9 + 1L));
            d.A(l10, d.C(l10) + f5);
            d.A(l10 + 1L, f6 - d.C(l10 + 1L));
        }
        d.A(l2 + l5 + 1L, -d.C(l2 + l5 + 1L));
    }

    public static void scale(int n, final double d, final double[] dArray, int n2, boolean bl) {
        int n3 = F.A();
        int n4 = bl ? 2 * n : n;
        if (n3 > 1 && (long)n4 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n3 = 2;
            int n5 = n4 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n6 = n2 + i * n5;
                final int n7 = i == n3 - 1 ? n2 + n4 : n6 + n5;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        int n = n6;
                        while (n < n7) {
                            int n2 = n++;
                            dArray[n2] = dArray[n2] * d;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n8 = n2;
            int n9 = n2 + n4;
            int n10 = n8;
            while (n10 < n9) {
                int n11 = n10++;
                dArray[n11] = dArray[n11] * d;
            }
        }
    }

    public static void scale(long l, final double d, final A a, long l2, boolean bl) {
        int n = F.A();
        long l3 = bl ? 2L * l : l;
        if (n > 1 && l3 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l4 = l3 / (long)n;
            Future[] futureArray = new Future[n];
            for (int i = 0; i < n; ++i) {
                final long l5 = l2 + (long)i * l4;
                final long l6 = i == n - 1 ? l2 + l3 : l5 + l4;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l5; i < l6; ++i) {
                            a.B(i, a.E(i) * d);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            for (long i = l2; i < l2 + l3; ++i) {
                a.B(i, a.E(i) * d);
            }
        }
    }

    public static void scale(int n, final float f, final float[] fArray, int n2, boolean bl) {
        int n3 = F.A();
        int n4 = bl ? 2 * n : n;
        if (n3 > 1 && (long)n4 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n3 = 2;
            int n5 = n4 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n6 = n2 + i * n5;
                final int n7 = i == n3 - 1 ? n2 + n4 : n6 + n5;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        int n = n6;
                        while (n < n7) {
                            int n2 = n++;
                            fArray[n2] = fArray[n2] * f;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n8 = n2;
            int n9 = n2 + n4;
            int n10 = n8;
            while (n10 < n9) {
                int n11 = n10++;
                fArray[n11] = fArray[n11] * f;
            }
        }
    }

    public static void scale(long l, final float f, final D d, long l2, boolean bl) {
        int n = F.A();
        long l3 = bl ? 2L * l : l;
        if (n > 1 && l3 >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l4 = l3 / (long)n;
            Future[] futureArray = new Future[n];
            for (int i = 0; i < n; ++i) {
                final long l5 = l2 + (long)i * l4;
                final long l6 = i == n - 1 ? l2 + l3 : l5 + l4;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l5; i < l6; ++i) {
                            d.A(i, d.B(i) * (double)f);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(CommonUtils.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            for (long i = l2; i < l2 + l3; ++i) {
                d.A(i, d.B(i) * (double)f);
            }
        }
    }
}

