/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import B.A.A.A.C;
import B.A.A.A.D;
import B.A.A.A.E;
import B.A.A.A.F;
import B.A.A.A.G;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.utils.CommonUtils;

public final class FloatFFT_1D {
    private int n;
    private long nl;
    private int nBluestein;
    private long nBluesteinl;
    private int[] ip;
    private G ipl;
    private float[] w;
    private D wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private float[] wtable;
    private D wtablel;
    private float[] wtable_r;
    private D wtable_rl;
    private float[] bk1;
    private D bk1l;
    private float[] bk2;
    private D bk2l;
    private Plans plan;
    private boolean useLargeArrays;
    private static final int[] factors = new int[]{4, 2, 3, 5};

    public FloatFFT_1D(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || 2L * l > (long)E.C();
        this.n = (int)l;
        this.nl = l;
        if (!this.useLargeArrays) {
            if (!CommonUtils.isPowerOf2(l)) {
                if (CommonUtils.getReminder(l, factors) >= 211L) {
                    this.plan = Plans.BLUESTEIN;
                    this.nBluestein = CommonUtils.nextPow2(this.n * 2 - 1);
                    this.bk1 = new float[2 * this.nBluestein];
                    this.bk2 = new float[2 * this.nBluestein];
                    this.ip = new int[2 + (int)FastMath.ceil(2 + (1 << (int)(FastMath.log((float)this.nBluestein + 0.5f) / FastMath.log(2.0)) / 2))];
                    this.w = new float[this.nBluestein];
                    int n = 2 * this.nBluestein;
                    this.nw = n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                    this.nc = this.nBluestein >> 2;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                    this.bluesteini();
                } else {
                    this.plan = Plans.MIXED_RADIX;
                    this.wtable = new float[4 * this.n + 15];
                    this.wtable_r = new float[2 * this.n + 15];
                    this.cffti();
                    this.rffti();
                }
            } else {
                this.plan = Plans.SPLIT_RADIX;
                this.ip = new int[2 + (int)FastMath.ceil(2 + (1 << (int)(FastMath.log((float)l + 0.5f) / FastMath.log(2.0)) / 2))];
                this.w = new float[this.n];
                int n = 2 * this.n;
                this.nw = n >> 2;
                CommonUtils.makewt(this.nw, this.ip, this.w);
                this.nc = this.n >> 2;
                CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
            }
        } else if (!CommonUtils.isPowerOf2(this.nl)) {
            if (CommonUtils.getReminder(this.nl, factors) >= 211L) {
                this.plan = Plans.BLUESTEIN;
                this.nBluesteinl = CommonUtils.nextPow2(this.nl * 2L - 1L);
                this.bk1l = new D(2L * this.nBluesteinl);
                this.bk2l = new D(2L * this.nBluesteinl);
                this.ipl = new G(2L + (long)FastMath.ceil(2L + (1L << (int)((long)(FastMath.log((float)this.nBluesteinl + 0.5f) / FastMath.log(2.0)) / 2L))));
                this.wl = new D(this.nBluesteinl);
                long l2 = 2L * this.nBluesteinl;
                this.nwl = l2 >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                this.ncl = this.nBluesteinl >> 2;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                this.bluesteinil();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtablel = new D(4L * this.nl + 15L);
                this.wtable_rl = new D(2L * this.nl + 15L);
                this.cfftil();
                this.rfftil();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ipl = new G(2L + (long)FastMath.ceil(2L + (1L << (int)((long)(FastMath.log((float)this.nl + 0.5f) / FastMath.log(2.0)) / 2L))));
            this.wl = new D(this.nl);
            long l3 = 2L * this.nl;
            this.nwl = l3 >> 2;
            CommonUtils.makewt(this.nwl, this.ipl, this.wl);
            this.ncl = this.nl >> 2;
            CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
        }
    }

    public void complexInverse(float[] fArray, boolean bl) {
        this.complexInverse(fArray, 0, bl);
    }

    public void complexInverse(float[] fArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.complexInverse(new D(fArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2 * this.n, fArray, n, this.ip, this.nw, this.w);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(fArray, n, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(fArray, n, 1);
                }
            }
            if (bl) {
                CommonUtils.scale(this.n, 1.0f / (float)this.n, fArray, n, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complexInverse(D d, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.complexInverse(d.F(), (int)l, bl);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    CommonUtils.cftfsub(2L * this.nl, d, l, this.ipl, this.nwl, this.wl);
                    break;
                }
                case MIXED_RADIX: {
                    this.cfftf(d, l, 1);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_complex(d, l, 1);
                }
            }
            if (!bl) return;
            CommonUtils.scale(this.nl, 1.0f / (float)this.nl, d, l, true);
        }
    }

    public void realForward(float[] fArray) {
        this.realForward(fArray, 0);
    }

    public void realForward(float[] fArray, int n) {
        if (this.useLargeArrays) {
            this.realForward(new D(fArray), (long)n);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
                        CommonUtils.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftx020(fArray, n);
                    }
                    float f = fArray[n] - fArray[n + 1];
                    int n2 = n;
                    fArray[n2] = fArray[n2] + fArray[n + 1];
                    fArray[n + 1] = f;
                    break;
                }
                case MIXED_RADIX: {
                    this.rfftf(fArray, n);
                    for (int i = this.n - 1; i >= 2; --i) {
                        int n3 = n + i;
                        float f = fArray[n3];
                        fArray[n3] = fArray[n3 - 1];
                        fArray[n3 - 1] = f;
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(fArray, n);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForward(D d, long l) {
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForward(d.F(), (int)l);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.nl > 4L) {
                        CommonUtils.cftfsub(this.nl, d, l, this.ipl, this.nwl, this.wl);
                        CommonUtils.rftfsub(this.nl, d, l, this.ncl, this.wl, this.nwl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftx020(d, l);
                    }
                    float f = d.C(l) - d.C(l + 1L);
                    d.A(l, d.C(l) + d.C(l + 1L));
                    d.A(l + 1L, f);
                    return;
                }
                case MIXED_RADIX: {
                    this.rfftf(d, l);
                    for (long i = this.nl - 1L; i >= 2L; --i) {
                        long l2 = l + i;
                        float f = d.C(l2);
                        d.A(l2, d.C(l2 - 1L));
                        d.A(l2 - 1L, f);
                    }
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(d, l);
                }
            }
        }
    }

    public void realForwardFull(float[] fArray) {
        this.realForwardFull(fArray, 0);
    }

    public void realForwardFull(final float[] fArray, final int n) {
        if (this.useLargeArrays) {
            this.realForwardFull(new D(fArray), (long)n);
        } else {
            final int n2 = 2 * this.n;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(fArray, n);
                    int n3 = F.A();
                    if (n3 > 1 && (long)(this.n / 2) > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n3];
                        int n4 = this.n / 2 / n3;
                        for (int i = 0; i < n3; ++i) {
                            final int n5 = i * n4;
                            final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                            futureArray[i] = F.A(new Runnable(){

                                @Override
                                public void run() {
                                    for (int i = n5; i < n6; ++i) {
                                        int n3 = 2 * i;
                                        int n22 = n + (n2 - n3) % n2;
                                        fArray[n22] = fArray[n + n3];
                                        fArray[n22 + 1] = -fArray[n + n3 + 1];
                                    }
                                }
                            });
                        }
                        try {
                            F.A(futureArray);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
                        }
                    } else {
                        for (int i = 0; i < this.n / 2; ++i) {
                            int n7 = 2 * i;
                            int n8 = n + (n2 - n7) % n2;
                            fArray[n8] = fArray[n + n7];
                            fArray[n8 + 1] = -fArray[n + n7 + 1];
                        }
                    }
                    fArray[n + this.n] = -fArray[n + 1];
                    fArray[n + 1] = 0.0f;
                    break;
                }
                case MIXED_RADIX: {
                    int n9;
                    int n10;
                    this.rfftf(fArray, n);
                    int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                    for (n10 = 1; n10 < n11; ++n10) {
                        n9 = n + n2 - 2 * n10;
                        int n12 = n + 2 * n10;
                        fArray[n9 + 1] = -fArray[n12];
                        fArray[n9] = fArray[n12 - 1];
                    }
                    for (n10 = 1; n10 < this.n; ++n10) {
                        n9 = n + this.n - n10;
                        float f = fArray[n9 + 1];
                        fArray[n9 + 1] = fArray[n9];
                        fArray[n9] = f;
                    }
                    fArray[n + 1] = 0.0f;
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(fArray, n, -1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForwardFull(final D d, final long l) {
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForwardFull(d.F(), (int)l);
            return;
        } else {
            final long l2 = 2L * this.nl;
            switch (this.plan) {
                case SPLIT_RADIX: {
                    this.realForward(d, l);
                    int n = F.A();
                    if (n > 1 && this.nl / 2L > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                        Future[] futureArray = new Future[n];
                        long l3 = this.nl / 2L / (long)n;
                        for (int i = 0; i < n; ++i) {
                            final long l4 = (long)i * l3;
                            final long l5 = i == n - 1 ? this.nl / 2L : l4 + l3;
                            futureArray[i] = F.A(new Runnable(){

                                @Override
                                public void run() {
                                    for (long i = l4; i < l5; ++i) {
                                        long l3 = 2L * i;
                                        long l22 = l + (l2 - l3) % l2;
                                        d.A(l22, d.C(l + l3));
                                        d.A(l22 + 1L, -d.C(l + l3 + 1L));
                                    }
                                }
                            });
                        }
                        try {
                            F.A(futureArray);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
                        }
                    } else {
                        for (long i = 0L; i < this.nl / 2L; ++i) {
                            long l6 = 2L * i;
                            long l7 = l + (l2 - l6) % l2;
                            d.A(l7, d.C(l + l6));
                            d.A(l7 + 1L, -d.C(l + l6 + 1L));
                        }
                    }
                    d.A(l + this.nl, -d.C(l + 1L));
                    d.A(l + 1L, 0.0f);
                    return;
                }
                case MIXED_RADIX: {
                    long l8;
                    long l9;
                    this.rfftf(d, l);
                    long l10 = this.nl % 2L == 0L ? this.nl / 2L : (this.nl + 1L) / 2L;
                    for (l9 = 1L; l9 < l10; ++l9) {
                        l8 = l + l2 - 2L * l9;
                        long l11 = l + 2L * l9;
                        d.A(l8 + 1L, -d.C(l11));
                        d.A(l8, d.C(l11 - 1L));
                    }
                    for (l9 = 1L; l9 < this.nl; ++l9) {
                        l8 = l + this.nl - l9;
                        float f = d.C(l8 + 1L);
                        d.A(l8 + 1L, d.C(l8));
                        d.A(l8, f);
                    }
                    d.A(l + 1L, 0.0f);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_full(d, l, -1L);
                }
            }
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        this.realInverse(fArray, 0, bl);
    }

    public void realInverse(float[] fArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.realInverse(new D(fArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    fArray[n + 1] = 0.5f * (fArray[n] - fArray[n + 1]);
                    int n2 = n;
                    fArray[n2] = fArray[n2] - fArray[n + 1];
                    if (this.n > 4) {
                        CommonUtils.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
                        CommonUtils.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
                    } else if (this.n == 4) {
                        CommonUtils.cftxc020(fArray, n);
                    }
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0f / ((float)this.n / 2.0f), fArray, n, false);
                    break;
                }
                case MIXED_RADIX: {
                    for (int i = 2; i < this.n; ++i) {
                        int n3 = n + i;
                        float f = fArray[n3 - 1];
                        fArray[n3 - 1] = fArray[n3];
                        fArray[n3] = f;
                    }
                    this.rfftb(fArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, fArray, n, false);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(fArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0f / (float)this.n, fArray, n, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverse(D d, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse(d.F(), (int)l, bl);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    d.A(l + 1L, 0.5f * (d.C(l) - d.C(l + 1L)));
                    d.A(l, d.C(l) - d.C(l + 1L));
                    if (this.nl > 4L) {
                        CommonUtils.rftfsub(this.nl, d, l, this.ncl, this.wl, this.nwl);
                        CommonUtils.cftbsub(this.nl, d, l, this.ipl, this.nwl, this.wl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftxc020(d, l);
                    }
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0f / ((float)this.nl / 2.0f), d, l, false);
                    return;
                }
                case MIXED_RADIX: {
                    for (long i = 2L; i < this.nl; ++i) {
                        long l2 = l + i;
                        float f = d.C(l2 - 1L);
                        d.A(l2 - 1L, d.C(l2));
                        d.A(l2, f);
                    }
                    this.rfftb(d, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, d, l, false);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(d, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0f / (float)this.nl, d, l, false);
                }
            }
        }
    }

    final void cffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 4 * this.n;
        int n5 = 0;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        block0: while (true) {
            n5 = ++n8 <= 4 ? factors[n8 - 1] : (n5 += 2);
            do {
                int n9;
                int n10;
                if ((n10 = n6 - n5 * (n9 = n6 / n5)) != 0) continue block0;
                this.wtable[++n7 + 1 + n4] = n5;
                n6 = n9;
                if (n5 != 2 || n7 == 1) continue;
                for (n2 = 2; n2 <= n7; ++n2) {
                    int n11 = n7 - n2 + 2;
                    n = n11 + n4;
                    this.wtable[n + 1] = this.wtable[n];
                }
                this.wtable[2 + n4] = 2.0f;
            } while (n6 != 1);
            break;
        }
        this.wtable[n4] = this.n;
        this.wtable[1 + n4] = n7;
        float f = (float)Math.PI * 2 / (float)this.n;
        n2 = 1;
        int n12 = 1;
        for (int i = 1; i <= n7; ++i) {
            int n13 = (int)this.wtable[i + 1 + n4];
            int n14 = 0;
            int n15 = n12 * n13;
            int n16 = this.n / n15;
            int n17 = n16 + n16 + 2;
            int n18 = n13 - 1;
            for (n8 = 1; n8 <= n18; ++n8) {
                int n19 = n2;
                this.wtable[n2 - 1 + n3] = 1.0f;
                this.wtable[n2 + n3] = 0.0f;
                float f2 = 0.0f;
                float f3 = (float)(n14 += n12) * f;
                for (int j = 4; j <= n17; j += 2) {
                    float f4 = (f2 += 1.0f) * f3;
                    n = (n2 += 2) + n3;
                    this.wtable[n - 1] = (float)FastMath.cos(f4);
                    this.wtable[n] = (float)FastMath.sin(f4);
                }
                if (n13 <= 5) continue;
                n = n19 + n3;
                int n20 = n2 + n3;
                this.wtable[n - 1] = this.wtable[n20 - 1];
                this.wtable[n] = this.wtable[n20];
            }
            n12 = n15;
        }
    }

    final void cfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 4L * this.nl;
        long l5 = 0L;
        long l6 = this.nl;
        long l7 = 0L;
        long l8 = 0L;
        block0: while (true) {
            l5 = ++l8 <= 4L ? (long)factors[(int)(l8 - 1L)] : (l5 += 2L);
            do {
                long l9;
                long l10;
                if ((l10 = l6 - l5 * (l9 = l6 / l5)) != 0L) continue block0;
                this.wtablel.A(++l7 + 1L + l4, l5);
                l6 = l9;
                if (l5 != 2L || l7 == 1L) continue;
                for (l2 = 2L; l2 <= l7; ++l2) {
                    long l11 = l7 - l2 + 2L;
                    l = l11 + l4;
                    this.wtablel.A(l + 1L, this.wtablel.C(l));
                }
                this.wtablel.A(2L + l4, 2.0f);
            } while (l6 != 1L);
            break;
        }
        this.wtablel.A(l4, this.nl);
        this.wtablel.A(1L + l4, l7);
        float f = (float)Math.PI * 2 / (float)this.nl;
        l2 = 1L;
        long l12 = 1L;
        for (long i = 1L; i <= l7; ++i) {
            long l13 = (long)this.wtablel.C(i + 1L + l4);
            long l14 = 0L;
            long l15 = l12 * l13;
            long l16 = this.nl / l15;
            long l17 = l16 + l16 + 2L;
            long l18 = l13 - 1L;
            for (l8 = 1L; l8 <= l18; ++l8) {
                long l19 = l2;
                this.wtablel.A(l2 - 1L + l3, 1.0f);
                this.wtablel.A(l2 + l3, 0.0f);
                float f2 = 0.0f;
                float f3 = (float)(l14 += l12) * f;
                for (long j = 4L; j <= l17; j += 2L) {
                    float f4 = (f2 += 1.0f) * f3;
                    l = (l2 += 2L) + l3;
                    this.wtablel.A(l - 1L, (float)FastMath.cos(f4));
                    this.wtablel.A(l, (float)FastMath.sin(f4));
                }
                if (l13 <= 5L) continue;
                l = l19 + l3;
                long l20 = l2 + l3;
                this.wtablel.A(l - 1L, this.wtablel.C(l20 - 1L));
                this.wtablel.A(l, this.wtablel.C(l20));
            }
            l12 = l15;
        }
    }

    void rffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 0;
        int n5 = this.n;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            n4 = ++n7 <= 4 ? factors[n7 - 1] : (n4 += 2);
            do {
                int n8;
                int n9;
                if ((n9 = n5 - n4 * (n8 = n5 / n4)) != 0) continue block0;
                this.wtable_r[++n6 + 1 + n3] = n4;
                n5 = n8;
                if (n4 != 2 || n6 == 1) continue;
                for (n2 = 2; n2 <= n6; ++n2) {
                    int n10 = n6 - n2 + 2;
                    n = n10 + n3;
                    this.wtable_r[n + 1] = this.wtable_r[n];
                }
                this.wtable_r[2 + n3] = 2.0f;
            } while (n5 != 1);
            break;
        }
        this.wtable_r[n3] = this.n;
        this.wtable_r[1 + n3] = n6;
        float f = (float)Math.PI * 2 / (float)this.n;
        int n11 = 0;
        int n12 = n6 - 1;
        int n13 = 1;
        if (n12 == 0) {
            return;
        }
        for (int i = 1; i <= n12; ++i) {
            int n14 = (int)this.wtable_r[i + 1 + n3];
            int n15 = 0;
            int n16 = n13 * n14;
            int n17 = this.n / n16;
            int n18 = n14 - 1;
            for (n7 = 1; n7 <= n18; ++n7) {
                n2 = n11;
                float f2 = (float)(n15 += n13) * f;
                float f3 = 0.0f;
                for (int j = 3; j <= n17; j += 2) {
                    float f4 = (f3 += 1.0f) * f2;
                    n = (n2 += 2) + this.n;
                    this.wtable_r[n - 2] = (float)FastMath.cos(f4);
                    this.wtable_r[n - 1] = (float)FastMath.sin(f4);
                }
                n11 += n17;
            }
            n13 = n16;
        }
    }

    void rfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 0L;
        long l5 = this.nl;
        long l6 = 0L;
        long l7 = 0L;
        block0: while (true) {
            l4 = ++l7 <= 4L ? (long)factors[(int)(l7 - 1L)] : (l4 += 2L);
            do {
                long l8;
                long l9;
                if ((l9 = l5 - l4 * (l8 = l5 / l4)) != 0L) continue block0;
                this.wtable_rl.A(++l6 + 1L + l3, l4);
                l5 = l8;
                if (l4 != 2L || l6 == 1L) continue;
                for (l2 = 2L; l2 <= l6; ++l2) {
                    long l10 = l6 - l2 + 2L;
                    l = l10 + l3;
                    this.wtable_rl.A(l + 1L, this.wtable_rl.C(l));
                }
                this.wtable_rl.A(2L + l3, 2.0f);
            } while (l5 != 1L);
            break;
        }
        this.wtable_rl.A(l3, this.nl);
        this.wtable_rl.A(1L + l3, l6);
        float f = (float)Math.PI * 2 / (float)this.nl;
        long l11 = 0L;
        long l12 = l6 - 1L;
        long l13 = 1L;
        if (l12 == 0L) {
            return;
        }
        for (long i = 1L; i <= l12; ++i) {
            long l14 = (long)this.wtable_rl.C(i + 1L + l3);
            long l15 = 0L;
            long l16 = l13 * l14;
            long l17 = this.nl / l16;
            long l18 = l14 - 1L;
            for (l7 = 1L; l7 <= l18; ++l7) {
                l2 = l11;
                float f2 = (float)(l15 += l13) * f;
                float f3 = 0.0f;
                for (long j = 3L; j <= l17; j += 2L) {
                    float f4 = (f3 += 1.0f) * f2;
                    l = (l2 += 2L) + this.nl;
                    this.wtable_rl.A(l - 2L, (float)FastMath.cos(f4));
                    this.wtable_rl.A(l - 1L, (float)FastMath.sin(f4));
                }
                l11 += l17;
            }
            l13 = l16;
        }
    }

    private void bluesteini() {
        int n = 0;
        float f = (float)Math.PI / (float)this.n;
        this.bk1[0] = 1.0f;
        this.bk1[1] = 0.0f;
        for (int i = 1; i < this.n; ++i) {
            if ((n += 2 * i - 1) >= 2 * this.n) {
                n -= 2 * this.n;
            }
            float f2 = f * (float)n;
            this.bk1[2 * i] = (float)FastMath.cos(f2);
            this.bk1[2 * i + 1] = (float)FastMath.sin(f2);
        }
        float f3 = 1.0f / (float)this.nBluestein;
        this.bk2[0] = this.bk1[0] * f3;
        this.bk2[1] = this.bk1[1] * f3;
        for (int i = 2; i < 2 * this.n; i += 2) {
            this.bk2[i] = this.bk1[i] * f3;
            this.bk2[i + 1] = this.bk1[i + 1] * f3;
            this.bk2[2 * this.nBluestein - i] = this.bk2[i];
            this.bk2[2 * this.nBluestein - i + 1] = this.bk2[i + 1];
        }
        CommonUtils.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void bluesteinil() {
        long l = 0L;
        float f = (float)Math.PI / (float)this.nl;
        this.bk1l.A(0L, 1.0f);
        this.bk1l.A(1L, 0.0f);
        int n = 1;
        while ((long)n < this.nl) {
            if ((l += (long)(2 * n - 1)) >= 2L * this.nl) {
                l -= 2L * this.nl;
            }
            float f2 = f * (float)l;
            this.bk1l.A((long)(2 * n), (float)FastMath.cos(f2));
            this.bk1l.A((long)(2 * n + 1), (float)FastMath.sin(f2));
            ++n;
        }
        float f3 = 1.0f / (float)this.nBluesteinl;
        this.bk2l.A(0L, this.bk1l.C(0L) * f3);
        this.bk2l.A(1L, this.bk1l.C(1L) * f3);
        int n2 = 2;
        while ((long)n2 < 2L * this.nl) {
            this.bk2l.A((long)n2, this.bk1l.C(n2) * f3);
            this.bk2l.A((long)(n2 + 1), this.bk1l.C(n2 + 1) * f3);
            this.bk2l.A(2L * this.nBluesteinl - (long)n2, this.bk2l.C(n2));
            this.bk2l.A(2L * this.nBluesteinl - (long)n2 + 1L, this.bk2l.C(n2 + 1));
            n2 += 2;
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, this.bk2l, 0L, this.ipl, this.nwl, this.wl);
    }

    private void bluestein_complex(final float[] fArray, final int n, final int n2) {
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n3 = F.A();
        if (n3 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6 = 2;
            if (n3 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n6 = 4;
            }
            Future[] futureArray = new Future[n6];
            int n7 = this.n / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.n : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                fArray2[n8] = fArray[n3] * FloatFFT_1D.this.bk1[n8] - fArray[n42] * FloatFFT_1D.this.bk1[n22];
                                fArray2[n22] = fArray[n3] * FloatFFT_1D.this.bk1[n22] + fArray[n42] * FloatFFT_1D.this.bk1[n8];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                fArray2[n9] = fArray[n6] * FloatFFT_1D.this.bk1[n9] + fArray[n7] * FloatFFT_1D.this.bk1[n52];
                                fArray2[n52] = -fArray[n6] * FloatFFT_1D.this.bk1[n52] + fArray[n7] * FloatFFT_1D.this.bk1[n9];
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.nBluestein : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                float f = -fArray2[n] * FloatFFT_1D.this.bk2[n22] + fArray2[n22] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n22] * FloatFFT_1D.this.bk2[n22];
                                fArray2[n22] = f;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                float f = fArray2[n] * FloatFFT_1D.this.bk2[n3] + fArray2[n3] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n3] * FloatFFT_1D.this.bk2[n3];
                                fArray2[n3] = f;
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.n : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                fArray[n3] = FloatFFT_1D.this.bk1[n8] * fArray2[n8] - FloatFFT_1D.this.bk1[n22] * fArray2[n22];
                                fArray[n42] = FloatFFT_1D.this.bk1[n22] * fArray2[n8] + FloatFFT_1D.this.bk1[n8] * fArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                fArray[n6] = FloatFFT_1D.this.bk1[n9] * fArray2[n9] + FloatFFT_1D.this.bk1[n52] * fArray2[n52];
                                fArray[n7] = -FloatFFT_1D.this.bk1[n52] * fArray2[n9] + FloatFFT_1D.this.bk1[n9] * fArray2[n52];
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    fArray2[n11] = fArray[n9] * this.bk1[n11] - fArray[n8] * this.bk1[n10];
                    fArray2[n10] = fArray[n9] * this.bk1[n10] + fArray[n8] * this.bk1[n11];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    fArray2[n11] = fArray[n9] * this.bk1[n11] + fArray[n8] * this.bk1[n10];
                    fArray2[n10] = -fArray[n9] * this.bk1[n10] + fArray[n8] * this.bk1[n11];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    float f = -fArray2[n11] * this.bk2[n10] + fArray2[n10] * this.bk2[n11];
                    fArray2[n11] = fArray2[n11] * this.bk2[n11] + fArray2[n10] * this.bk2[n10];
                    fArray2[n10] = f;
                }
            } else {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    float f = fArray2[n11] * this.bk2[n10] + fArray2[n10] * this.bk2[n11];
                    fArray2[n11] = fArray2[n11] * this.bk2[n11] - fArray2[n10] * this.bk2[n10];
                    fArray2[n10] = f;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n13 = n + n11;
                    n8 = n + n10;
                    fArray[n13] = this.bk1[n11] * fArray2[n11] - this.bk1[n10] * fArray2[n10];
                    fArray[n8] = this.bk1[n10] * fArray2[n11] + this.bk1[n11] * fArray2[n10];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n14 = n + n11;
                    n8 = n + n10;
                    fArray[n14] = this.bk1[n11] * fArray2[n11] + this.bk1[n10] * fArray2[n10];
                    fArray[n8] = -this.bk1[n10] * fArray2[n11] + this.bk1[n11] * fArray2[n10];
                }
            }
        }
    }

    private void bluestein_complex(final D d, final long l, final int n) {
        final D d2 = new D(2L * this.nBluesteinl);
        int n2 = F.A();
        if (n2 > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l2;
            long l3;
            int n3 = 2;
            if (n2 >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            long l4 = this.nl / (long)n3;
            for (int i = 0; i < n3; ++i) {
                l3 = (long)i * l4;
                l2 = i == n3 - 1 ? this.nl : l3 + l4;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l8 = 2L * i;
                                long l22 = l8 + 1L;
                                long l32 = l + l8;
                                long l4 = l + l22;
                                d2.A(l8, d.C(l32) * FloatFFT_1D.this.bk1l.C(l8) - d.C(l4) * FloatFFT_1D.this.bk1l.C(l22));
                                d2.A(l22, d.C(l32) * FloatFFT_1D.this.bk1l.C(l22) + d.C(l4) * FloatFFT_1D.this.bk1l.C(l8));
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l9 = 2L * i;
                                long l5 = l9 + 1L;
                                long l6 = l + l9;
                                long l7 = l + l5;
                                d2.A(l9, d.C(l6) * FloatFFT_1D.this.bk1l.C(l9) + d.C(l7) * FloatFFT_1D.this.bk1l.C(l5));
                                d2.A(l5, -d.C(l6) * FloatFFT_1D.this.bk1l.C(l5) + d.C(l7) * FloatFFT_1D.this.bk1l.C(l9));
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l4 = this.nBluesteinl / (long)n3;
            for (int i = 0; i < n3; ++i) {
                l3 = (long)i * l4;
                l2 = i == n3 - 1 ? this.nBluesteinl : l3 + l4;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l = 2L * i;
                                long l22 = l + 1L;
                                float f = -d2.C(l) * FloatFFT_1D.this.bk2l.C(l22) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l);
                                d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l22));
                                d2.A(l22, f);
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l = 2L * i;
                                long l32 = l + 1L;
                                float f = d2.C(l) * FloatFFT_1D.this.bk2l.C(l32) + d2.C(l32) * FloatFFT_1D.this.bk2l.C(l);
                                d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) - d2.C(l32) * FloatFFT_1D.this.bk2l.C(l32));
                                d2.A(l32, f);
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l4 = this.nl / (long)n3;
            for (int i = 0; i < n3; ++i) {
                l3 = (long)i * l4;
                l2 = i == n3 - 1 ? this.nl : l3 + l4;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n > 0) {
                            for (long i = l3; i < l2; ++i) {
                                long l8 = 2L * i;
                                long l22 = l8 + 1L;
                                long l32 = l + l8;
                                long l4 = l + l22;
                                d.A(l32, FloatFFT_1D.this.bk1l.C(l8) * d2.C(l8) - FloatFFT_1D.this.bk1l.C(l22) * d2.C(l22));
                                d.A(l4, FloatFFT_1D.this.bk1l.C(l22) * d2.C(l8) + FloatFFT_1D.this.bk1l.C(l8) * d2.C(l22));
                            }
                        } else {
                            for (long i = l3; i < l2; ++i) {
                                long l9 = 2L * i;
                                long l5 = l9 + 1L;
                                long l6 = l + l9;
                                long l7 = l + l5;
                                d.A(l6, FloatFFT_1D.this.bk1l.C(l9) * d2.C(l9) + FloatFFT_1D.this.bk1l.C(l5) * d2.C(l5));
                                d.A(l7, -FloatFFT_1D.this.bk1l.C(l5) * d2.C(l9) + FloatFFT_1D.this.bk1l.C(l9) * d2.C(l5));
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l5;
            long l6;
            long l7;
            long l8;
            long l9;
            if (n > 0) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l8;
                    l5 = l + l7;
                    d2.A(l8, d.C(l6) * this.bk1l.C(l8) - d.C(l5) * this.bk1l.C(l7));
                    d2.A(l7, d.C(l6) * this.bk1l.C(l7) + d.C(l5) * this.bk1l.C(l8));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l8;
                    l5 = l + l7;
                    d2.A(l8, d.C(l6) * this.bk1l.C(l8) + d.C(l5) * this.bk1l.C(l7));
                    d2.A(l7, -d.C(l6) * this.bk1l.C(l7) + d.C(l5) * this.bk1l.C(l8));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            if (n > 0) {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    float f = -d2.C(l8) * this.bk2l.C(l7) + d2.C(l7) * this.bk2l.C(l8);
                    d2.A(l8, d2.C(l8) * this.bk2l.C(l8) + d2.C(l7) * this.bk2l.C(l7));
                    d2.A(l7, f);
                }
            } else {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    float f = d2.C(l8) * this.bk2l.C(l7) + d2.C(l7) * this.bk2l.C(l8);
                    d2.A(l8, d2.C(l8) * this.bk2l.C(l8) - d2.C(l7) * this.bk2l.C(l7));
                    d2.A(l7, f);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            if (n > 0) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    long l10 = l + l8;
                    l5 = l + l7;
                    d.A(l10, this.bk1l.C(l8) * d2.C(l8) - this.bk1l.C(l7) * d2.C(l7));
                    d.A(l5, this.bk1l.C(l7) * d2.C(l8) + this.bk1l.C(l8) * d2.C(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    long l11 = l + l8;
                    l5 = l + l7;
                    d.A(l11, this.bk1l.C(l8) * d2.C(l8) + this.bk1l.C(l7) * d2.C(l7));
                    d.A(l5, -this.bk1l.C(l7) * d2.C(l8) + this.bk1l.C(l8) * d2.C(l7));
                }
            }
        }
    }

    private void bluestein_real_full(final float[] fArray, final int n, final int n2) {
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n3 = F.A();
        if (n3 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6 = 2;
            if (n3 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n6 = 4;
            }
            Future[] futureArray = new Future[n6];
            int n7 = this.n / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.n : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                int n3 = n + i;
                                fArray2[n6] = fArray[n3] * FloatFFT_1D.this.bk1[n6];
                                fArray2[n22] = fArray[n3] * FloatFFT_1D.this.bk1[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n42 = n7 + 1;
                                int n52 = n + i;
                                fArray2[n7] = fArray[n52] * FloatFFT_1D.this.bk1[n7];
                                fArray2[n42] = -fArray[n52] * FloatFFT_1D.this.bk1[n42];
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.nBluestein : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                float f = -fArray2[n] * FloatFFT_1D.this.bk2[n22] + fArray2[n22] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n22] * FloatFFT_1D.this.bk2[n22];
                                fArray2[n22] = f;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                float f = fArray2[n] * FloatFFT_1D.this.bk2[n3] + fArray2[n3] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n3] * FloatFFT_1D.this.bk2[n3];
                                fArray2[n3] = f;
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n6;
            for (int i = 0; i < n6; ++i) {
                n5 = i * n7;
                n4 = i == n6 - 1 ? this.n : n5 + n7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                fArray[n + n6] = FloatFFT_1D.this.bk1[n6] * fArray2[n6] - FloatFFT_1D.this.bk1[n22] * fArray2[n22];
                                fArray[n + n22] = FloatFFT_1D.this.bk1[n22] * fArray2[n6] + FloatFFT_1D.this.bk1[n6] * fArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n3 = n7 + 1;
                                fArray[n + n7] = FloatFFT_1D.this.bk1[n7] * fArray2[n7] + FloatFFT_1D.this.bk1[n3] * fArray2[n3];
                                fArray[n + n3] = -FloatFFT_1D.this.bk1[n3] * fArray2[n7] + FloatFFT_1D.this.bk1[n7] * fArray2[n3];
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    fArray2[n10] = fArray[n8] * this.bk1[n10];
                    fArray2[n9] = fArray[n8] * this.bk1[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    fArray2[n10] = fArray[n8] * this.bk1[n10];
                    fArray2[n9] = -fArray[n8] * this.bk1[n9];
                }
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    float f = -fArray2[n10] * this.bk2[n9] + fArray2[n9] * this.bk2[n10];
                    fArray2[n10] = fArray2[n10] * this.bk2[n10] + fArray2[n9] * this.bk2[n9];
                    fArray2[n9] = f;
                }
            } else {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    float f = fArray2[n10] * this.bk2[n9] + fArray2[n9] * this.bk2[n10];
                    fArray2[n10] = fArray2[n10] * this.bk2[n10] - fArray2[n9] * this.bk2[n9];
                    fArray2[n9] = f;
                }
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    fArray[n + n10] = this.bk1[n10] * fArray2[n10] - this.bk1[n9] * fArray2[n9];
                    fArray[n + n9] = this.bk1[n9] * fArray2[n10] + this.bk1[n10] * fArray2[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    fArray[n + n10] = this.bk1[n10] * fArray2[n10] + this.bk1[n9] * fArray2[n9];
                    fArray[n + n9] = -this.bk1[n9] * fArray2[n10] + this.bk1[n10] * fArray2[n9];
                }
            }
        }
    }

    private void bluestein_real_full(final D d, final long l, final long l2) {
        final D d2 = new D(2L * this.nBluesteinl);
        int n = F.A();
        if (n > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2 = 2;
            if (n >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n2 = 4;
            }
            Future[] futureArray = new Future[n2];
            long l5 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l5;
                l3 = i == n2 - 1 ? this.nl : l4 + l5;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l6 = 2L * i;
                                long l22 = l6 + 1L;
                                long l32 = l + i;
                                d2.A(l6, d.C(l32) * FloatFFT_1D.this.bk1l.C(l6));
                                d2.A(l22, d.C(l32) * FloatFFT_1D.this.bk1l.C(l22));
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l7 = 2L * i;
                                long l42 = l7 + 1L;
                                long l5 = l + i;
                                d2.A(l7, d.C(l5) * FloatFFT_1D.this.bk1l.C(l7));
                                d2.A(l42, -d.C(l5) * FloatFFT_1D.this.bk1l.C(l42));
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l5 = this.nBluesteinl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l5;
                l3 = i == n2 - 1 ? this.nBluesteinl : l4 + l5;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l = 2L * i;
                                long l22 = l + 1L;
                                float f = -d2.C(l) * FloatFFT_1D.this.bk2l.C(l22) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l);
                                d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l22));
                                d2.A(l22, f);
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l = 2L * i;
                                long l32 = l + 1L;
                                float f = d2.C(l) * FloatFFT_1D.this.bk2l.C(l32) + d2.C(l32) * FloatFFT_1D.this.bk2l.C(l);
                                d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) - d2.C(l32) * FloatFFT_1D.this.bk2l.C(l32));
                                d2.A(l32, f);
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l5 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l5;
                l3 = i == n2 - 1 ? this.nl : l4 + l5;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        if (l2 > 0L) {
                            for (long i = l4; i < l3; ++i) {
                                long l5 = 2L * i;
                                long l22 = l5 + 1L;
                                d.A(l + l5, FloatFFT_1D.this.bk1l.C(l5) * d2.C(l5) - FloatFFT_1D.this.bk1l.C(l22) * d2.C(l22));
                                d.A(l + l22, FloatFFT_1D.this.bk1l.C(l22) * d2.C(l5) + FloatFFT_1D.this.bk1l.C(l5) * d2.C(l22));
                            }
                        } else {
                            for (long i = l4; i < l3; ++i) {
                                long l6 = 2L * i;
                                long l32 = l6 + 1L;
                                d.A(l + l6, FloatFFT_1D.this.bk1l.C(l6) * d2.C(l6) + FloatFFT_1D.this.bk1l.C(l32) * d2.C(l32));
                                d.A(l + l32, -FloatFFT_1D.this.bk1l.C(l32) * d2.C(l6) + FloatFFT_1D.this.bk1l.C(l6) * d2.C(l32));
                            }
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l6;
            long l7;
            long l8;
            long l9;
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l9;
                    d2.A(l8, d.C(l6) * this.bk1l.C(l8));
                    d2.A(l7, d.C(l6) * this.bk1l.C(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    l6 = l + l9;
                    d2.A(l8, d.C(l6) * this.bk1l.C(l8));
                    d2.A(l7, -d.C(l6) * this.bk1l.C(l7));
                }
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    float f = -d2.C(l8) * this.bk2l.C(l7) + d2.C(l7) * this.bk2l.C(l8);
                    d2.A(l8, d2.C(l8) * this.bk2l.C(l8) + d2.C(l7) * this.bk2l.C(l7));
                    d2.A(l7, f);
                }
            } else {
                for (l9 = 0L; l9 < this.nBluesteinl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    float f = d2.C(l8) * this.bk2l.C(l7) + d2.C(l7) * this.bk2l.C(l8);
                    d2.A(l8, d2.C(l8) * this.bk2l.C(l8) - d2.C(l7) * this.bk2l.C(l7));
                    d2.A(l7, f);
                }
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            if (l2 > 0L) {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    d.A(l + l8, this.bk1l.C(l8) * d2.C(l8) - this.bk1l.C(l7) * d2.C(l7));
                    d.A(l + l7, this.bk1l.C(l7) * d2.C(l8) + this.bk1l.C(l8) * d2.C(l7));
                }
            } else {
                for (l9 = 0L; l9 < this.nl; ++l9) {
                    l8 = 2L * l9;
                    l7 = l8 + 1L;
                    d.A(l + l8, this.bk1l.C(l8) * d2.C(l8) + this.bk1l.C(l7) * d2.C(l7));
                    d.A(l + l7, -this.bk1l.C(l7) * d2.C(l8) + this.bk1l.C(l8) * d2.C(l7));
                }
            }
        }
    }

    private void bluestein_real_forward(final float[] fArray, final int n) {
        int n2;
        int n3;
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n4 = F.A();
        if (n4 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n3 = 2;
            if (n4 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            n2 = this.n / n3;
            for (int i = 0; i < n3; ++i) {
                n6 = i * n2;
                n5 = i == n3 - 1 ? this.n : n6 + n2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            fArray2[n4] = fArray[n3] * FloatFFT_1D.this.bk1[n4];
                            fArray2[n2] = -fArray[n3] * FloatFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n2 = this.nBluestein / n3;
            for (int i = 0; i < n3; ++i) {
                n6 = i * n2;
                n5 = i == n3 - 1 ? this.nBluestein : n6 + n2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            float f = fArray2[n] * FloatFFT_1D.this.bk2[n2] + fArray2[n2] * FloatFFT_1D.this.bk2[n];
                            fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n2] * FloatFFT_1D.this.bk2[n2];
                            fArray2[n2] = f;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n7;
            for (n3 = 0; n3 < this.n; ++n3) {
                n7 = 2 * n3;
                n2 = n7 + 1;
                int n8 = n + n3;
                fArray2[n7] = fArray[n8] * this.bk1[n7];
                fArray2[n2] = -fArray[n8] * this.bk1[n2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            for (n3 = 0; n3 < this.nBluestein; ++n3) {
                n7 = 2 * n3;
                n2 = n7 + 1;
                float f = fArray2[n7] * this.bk2[n2] + fArray2[n2] * this.bk2[n7];
                fArray2[n7] = fArray2[n7] * this.bk2[n7] - fArray2[n2] * this.bk2[n2];
                fArray2[n2] = f;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            fArray[n] = this.bk1[0] * fArray2[0] + this.bk1[1] * fArray2[1];
            fArray[n + 1] = this.bk1[this.n] * fArray2[this.n] + this.bk1[this.n + 1] * fArray2[this.n + 1];
            for (n3 = 1; n3 < this.n / 2; ++n3) {
                int n9 = 2 * n3;
                n2 = n9 + 1;
                fArray[n + n9] = this.bk1[n9] * fArray2[n9] + this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = -this.bk1[n2] * fArray2[n9] + this.bk1[n9] * fArray2[n2];
            }
        } else {
            fArray[n] = this.bk1[0] * fArray2[0] + this.bk1[1] * fArray2[1];
            fArray[n + 1] = -this.bk1[this.n] * fArray2[this.n - 1] + this.bk1[this.n - 1] * fArray2[this.n];
            for (n3 = 1; n3 < (this.n - 1) / 2; ++n3) {
                int n10 = 2 * n3;
                n2 = n10 + 1;
                fArray[n + n10] = this.bk1[n10] * fArray2[n10] + this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = -this.bk1[n2] * fArray2[n10] + this.bk1[n10] * fArray2[n2];
            }
            fArray[n + this.n - 1] = this.bk1[this.n - 1] * fArray2[this.n - 1] + this.bk1[this.n] * fArray2[this.n];
        }
    }

    private void bluestein_real_forward(final D d, final long l) {
        long l2;
        final D d2 = new D(2L * this.nBluesteinl);
        int n = F.A();
        if (n > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2 = 2;
            if (n >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n2 = 4;
            }
            Future[] futureArray = new Future[n2];
            l2 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l2;
                l3 = i == n2 - 1 ? this.nl : l4 + l2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l5 = 2L * i;
                            long l2 = l5 + 1L;
                            long l32 = l + i;
                            d2.A(l5, d.C(l32) * FloatFFT_1D.this.bk1l.C(l5));
                            d2.A(l2, -d.C(l32) * FloatFFT_1D.this.bk1l.C(l2));
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l2 = this.nBluesteinl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l2;
                l3 = i == n2 - 1 ? this.nBluesteinl : l4 + l2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l = 2L * i;
                            long l2 = l + 1L;
                            float f = d2.C(l) * FloatFFT_1D.this.bk2l.C(l2) + d2.C(l2) * FloatFFT_1D.this.bk2l.C(l);
                            d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) - d2.C(l2) * FloatFFT_1D.this.bk2l.C(l2));
                            d2.A(l2, f);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l5;
            long l6;
            for (l6 = 0L; l6 < this.nl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                long l7 = l + l6;
                d2.A(l2, d.C(l7) * this.bk1l.C(l2));
                d2.A(l5, -d.C(l7) * this.bk1l.C(l5));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            for (l6 = 0L; l6 < this.nBluesteinl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                float f = d2.C(l2) * this.bk2l.C(l5) + d2.C(l5) * this.bk2l.C(l2);
                d2.A(l2, d2.C(l2) * this.bk2l.C(l2) - d2.C(l5) * this.bk2l.C(l5));
                d2.A(l5, f);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            d.A(l, this.bk1l.C(0L) * d2.C(0L) + this.bk1l.C(1L) * d2.C(1L));
            d.A(l + 1L, this.bk1l.C(this.nl) * d2.C(this.nl) + this.bk1l.C(this.nl + 1L) * d2.C(this.nl + 1L));
            for (long i = 1L; i < this.nl / 2L; ++i) {
                l2 = 2L * i;
                long l8 = l2 + 1L;
                d.A(l + l2, this.bk1l.C(l2) * d2.C(l2) + this.bk1l.C(l8) * d2.C(l8));
                d.A(l + l8, -this.bk1l.C(l8) * d2.C(l2) + this.bk1l.C(l2) * d2.C(l8));
            }
        } else {
            d.A(l, this.bk1l.C(0L) * d2.C(0L) + this.bk1l.C(1L) * d2.C(1L));
            d.A(l + 1L, -this.bk1l.C(this.nl) * d2.C(this.nl - 1L) + this.bk1l.C(this.nl - 1L) * d2.C(this.nl));
            for (long i = 1L; i < (this.nl - 1L) / 2L; ++i) {
                l2 = 2L * i;
                long l9 = l2 + 1L;
                d.A(l + l2, this.bk1l.C(l2) * d2.C(l2) + this.bk1l.C(l9) * d2.C(l9));
                d.A(l + l9, -this.bk1l.C(l9) * d2.C(l2) + this.bk1l.C(l2) * d2.C(l9));
            }
            d.A(l + this.nl - 1L, this.bk1l.C(this.nl - 1L) * d2.C(this.nl - 1L) + this.bk1l.C(this.nl) * d2.C(this.nl));
        }
    }

    private void bluestein_real_inverse(final float[] fArray, final int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        final float[] fArray2 = new float[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            fArray2[0] = fArray[n] * this.bk1[0];
            fArray2[1] = fArray[n] * this.bk1[1];
            for (n6 = 1; n6 < this.n / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                fArray2[n5] = fArray[n3] * this.bk1[n5] - fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] + fArray[n2] * this.bk1[n5];
            }
            fArray2[this.n] = fArray[n + 1] * this.bk1[this.n];
            fArray2[this.n + 1] = fArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = this.n / 2 + 1; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                fArray2[n5] = fArray[n3] * this.bk1[n5] + fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] - fArray[n2] * this.bk1[n5];
            }
        } else {
            fArray2[0] = fArray[n] * this.bk1[0];
            fArray2[1] = fArray[n] * this.bk1[1];
            for (n6 = 1; n6 < (this.n - 1) / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                fArray2[n5] = fArray[n3] * this.bk1[n5] - fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] + fArray[n2] * this.bk1[n5];
            }
            fArray2[this.n - 1] = fArray[n + this.n - 1] * this.bk1[this.n - 1] - fArray[n + 1] * this.bk1[this.n];
            fArray2[this.n] = fArray[n + this.n - 1] * this.bk1[this.n] + fArray[n + 1] * this.bk1[this.n - 1];
            fArray2[this.n + 1] = fArray[n + this.n - 1] * this.bk1[this.n + 1] + fArray[n + 1] * this.bk1[this.n + 2];
            fArray2[this.n + 2] = fArray[n + this.n - 1] * this.bk1[this.n + 2] - fArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = (this.n - 1) / 2 + 2; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                fArray2[n5] = fArray[n3] * this.bk1[n5] + fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] - fArray[n2] * this.bk1[n5];
            }
        }
        CommonUtils.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
        n6 = F.A();
        if (n6 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            int n8;
            n5 = 2;
            if (n6 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n5 = 4;
            }
            Future[] futureArray = new Future[n5];
            n3 = this.nBluestein / n5;
            for (n2 = 0; n2 < n5; ++n2) {
                n8 = n2 * n3;
                n7 = n2 == n5 - 1 ? this.nBluestein : n8 + n3;
                futureArray[n2] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            float f = -fArray2[n] * FloatFFT_1D.this.bk2[n2] + fArray2[n2] * FloatFFT_1D.this.bk2[n];
                            fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n2] * FloatFFT_1D.this.bk2[n2];
                            fArray2[n2] = f;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n3 = this.n / n5;
            for (int i = 0; i < n5; ++i) {
                n8 = i * n3;
                n7 = i == n5 - 1 ? this.n : n8 + n3;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            fArray[n + i] = FloatFFT_1D.this.bk1[n3] * fArray2[n3] - FloatFFT_1D.this.bk1[n2] * fArray2[n2];
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            for (n5 = 0; n5 < this.nBluestein; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                float f = -fArray2[n4] * this.bk2[n3] + fArray2[n3] * this.bk2[n4];
                fArray2[n4] = fArray2[n4] * this.bk2[n4] + fArray2[n3] * this.bk2[n3];
                fArray2[n3] = f;
            }
            CommonUtils.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            for (n5 = 0; n5 < this.n; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                fArray[n + n5] = this.bk1[n4] * fArray2[n4] - this.bk1[n3] * fArray2[n3];
            }
        }
    }

    private void bluestein_real_inverse(final D d, final long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        final D d2 = new D(2L * this.nBluesteinl);
        if (this.nl % 2L == 0L) {
            d2.A(0L, d.C(l) * this.bk1l.C(0L));
            d2.A(1L, d.C(l) * this.bk1l.C(1L));
            for (l6 = 1L; l6 < this.nl / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                d2.A(l5, d.C(l3) * this.bk1l.C(l5) - d.C(l2) * this.bk1l.C(l4));
                d2.A(l4, d.C(l3) * this.bk1l.C(l4) + d.C(l2) * this.bk1l.C(l5));
            }
            d2.A(this.nl, d.C(l + 1L) * this.bk1l.C(this.nl));
            d2.A(this.nl + 1L, d.C(l + 1L) * this.bk1l.C(this.nl + 1L));
            for (l6 = this.nl / 2L + 1L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                d2.A(l5, d.C(l3) * this.bk1l.C(l5) + d.C(l2) * this.bk1l.C(l4));
                d2.A(l4, d.C(l3) * this.bk1l.C(l4) - d.C(l2) * this.bk1l.C(l5));
            }
        } else {
            d2.A(0L, d.C(l) * this.bk1l.C(0L));
            d2.A(1L, d.C(l) * this.bk1l.C(1L));
            for (l6 = 1L; l6 < (this.nl - 1L) / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                d2.A(l5, d.C(l3) * this.bk1l.C(l5) - d.C(l2) * this.bk1l.C(l4));
                d2.A(l4, d.C(l3) * this.bk1l.C(l4) + d.C(l2) * this.bk1l.C(l5));
            }
            d2.A(this.nl - 1L, d.C(l + this.nl - 1L) * this.bk1l.C(this.nl - 1L) - d.C(l + 1L) * this.bk1l.C(this.nl));
            d2.A(this.nl, d.C(l + this.nl - 1L) * this.bk1l.C(this.nl) + d.C(l + 1L) * this.bk1l.C(this.nl - 1L));
            d2.A(this.nl + 1L, d.C(l + this.nl - 1L) * this.bk1l.C(this.nl + 1L) + d.C(l + 1L) * this.bk1l.C(this.nl + 2L));
            d2.A(this.nl + 2L, d.C(l + this.nl - 1L) * this.bk1l.C(this.nl + 2L) - d.C(l + 1L) * this.bk1l.C(this.nl + 1L));
            for (l6 = (this.nl - 1L) / 2L + 2L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                d2.A(l5, d.C(l3) * this.bk1l.C(l5) + d.C(l2) * this.bk1l.C(l4));
                d2.A(l4, d.C(l3) * this.bk1l.C(l4) - d.C(l2) * this.bk1l.C(l5));
            }
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
        int n = F.A();
        if (n > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n2 = 2;
            if (n >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n2 = 4;
            }
            Future[] futureArray = new Future[n2];
            long l7 = this.nBluesteinl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l3 = (long)i * l7;
                l2 = i == n2 - 1 ? this.nBluesteinl : l3 + l7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l = 2L * i;
                            long l22 = l + 1L;
                            float f = -d2.C(l) * FloatFFT_1D.this.bk2l.C(l22) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l);
                            d2.A(l, d2.C(l) * FloatFFT_1D.this.bk2l.C(l) + d2.C(l22) * FloatFFT_1D.this.bk2l.C(l22));
                            d2.A(l22, f);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            l7 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l3 = (long)i * l7;
                l2 = i == n2 - 1 ? this.nl : l3 + l7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l4 = 2L * i;
                            long l22 = l4 + 1L;
                            d.A(l + i, FloatFFT_1D.this.bk1l.C(l4) * d2.C(l4) - FloatFFT_1D.this.bk1l.C(l22) * d2.C(l22));
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(FloatFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l8;
            long l9;
            long l10;
            for (l10 = 0L; l10 < this.nBluesteinl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                float f = -d2.C(l9) * this.bk2l.C(l8) + d2.C(l8) * this.bk2l.C(l9);
                d2.A(l9, d2.C(l9) * this.bk2l.C(l9) + d2.C(l8) * this.bk2l.C(l8));
                d2.A(l8, f);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, d2, 0L, this.ipl, this.nwl, this.wl);
            for (l10 = 0L; l10 < this.nl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                d.A(l + l10, this.bk1l.C(l9) * d2.C(l9) - this.bk1l.C(l8) * d2.C(l8));
            }
        }
    }

    void rfftf(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        float[] fArray2 = new float[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 1;
        int n5 = this.n;
        int n6 = n2 - 1;
        for (int i = 1; i <= n3; ++i) {
            int n7 = n3 - i;
            int n8 = (int)this.wtable_r[n7 + 2 + n2];
            int n9 = n5 / n8;
            int n10 = this.n / n5;
            int n11 = n10 * n9;
            n6 -= (n8 - 1) * n10;
            n4 = 1 - n4;
            switch (n8) {
                case 2: {
                    if (n4 == 0) {
                        this.radf2(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf2(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radf3(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf3(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radf4(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf4(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radf5(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf5(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                default: {
                    if (n10 == 1) {
                        n4 = 1 - n4;
                    }
                    if (n4 == 0) {
                        this.radfg(n10, n8, n9, n11, fArray, n, fArray2, 0, n6);
                        n4 = 1;
                        break;
                    }
                    this.radfg(n10, n8, n9, n11, fArray2, 0, fArray, n, n6);
                    n4 = 0;
                }
            }
            n5 = n9;
        }
        if (n4 == 1) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, this.n);
    }

    void rfftf(D d, long l) {
        if (this.nl == 1L) {
            return;
        }
        D d2 = new D(this.nl);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.C(1L + l2);
        long l4 = 1L;
        long l5 = this.nl;
        long l6 = l2 - 1L;
        for (long i = 1L; i <= l3; ++i) {
            long l7 = l3 - i;
            int n = (int)this.wtable_rl.C(l7 + 2L + l2);
            long l8 = l5 / (long)n;
            long l9 = this.nl / l5;
            long l10 = l9 * l8;
            l6 -= (long)(n - 1) * l9;
            l4 = 1L - l4;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radf2(l9, l8, d, l, d2, 0L, l6);
                        break;
                    }
                    this.radf2(l9, l8, d2, 0L, d, l, l6);
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radf3(l9, l8, d, l, d2, 0L, l6);
                        break;
                    }
                    this.radf3(l9, l8, d2, 0L, d, l, l6);
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radf4(l9, l8, d, l, d2, 0L, l6);
                        break;
                    }
                    this.radf4(l9, l8, d2, 0L, d, l, l6);
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radf5(l9, l8, d, l, d2, 0L, l6);
                        break;
                    }
                    this.radf5(l9, l8, d2, 0L, d, l, l6);
                    break;
                }
                default: {
                    if (l9 == 1L) {
                        l4 = 1L - l4;
                    }
                    if (l4 == 0L) {
                        this.radfg(l9, (long)n, l8, l10, d, l, d2, 0L, l6);
                        l4 = 1L;
                        break;
                    }
                    this.radfg(l9, (long)n, l8, l10, d2, 0L, d, l, l6);
                    l4 = 0L;
                }
            }
            l5 = l8;
        }
        if (l4 == 1L) {
            return;
        }
        C.A(d2, 0L, d, l, this.nl);
    }

    void rfftb(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        float[] fArray2 = new float[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 0;
        int n5 = 1;
        int n6 = this.n;
        for (int i = 1; i <= n3; ++i) {
            int n7 = (int)this.wtable_r[i + 1 + n2];
            int n8 = n7 * n5;
            int n9 = this.n / n8;
            int n10 = n9 * n5;
            switch (n7) {
                case 2: {
                    if (n4 == 0) {
                        this.radb2(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb2(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radb3(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb3(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radb4(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb4(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radb5(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb5(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                default: {
                    if (n4 == 0) {
                        this.radbg(n9, n7, n5, n10, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radbg(n9, n7, n5, n10, fArray2, 0, fArray, n, n6);
                    }
                    if (n9 != 1) break;
                    n4 = 1 - n4;
                }
            }
            n5 = n8;
            n6 += (n7 - 1) * n9;
        }
        if (n4 == 0) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, this.n);
    }

    void rfftb(D d, long l) {
        if (this.nl == 1L) {
            return;
        }
        D d2 = new D(this.nl);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.C(1L + l2);
        long l4 = 0L;
        long l5 = 1L;
        long l6 = this.nl;
        for (long i = 1L; i <= l3; ++i) {
            int n = (int)this.wtable_rl.C(i + 1L + l2);
            long l7 = (long)n * l5;
            long l8 = this.nl / l7;
            long l9 = l8 * l5;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radb2(l8, l5, d, l, d2, 0L, l6);
                    } else {
                        this.radb2(l8, l5, d2, 0L, d, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radb3(l8, l5, d, l, d2, 0L, l6);
                    } else {
                        this.radb3(l8, l5, d2, 0L, d, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radb4(l8, l5, d, l, d2, 0L, l6);
                    } else {
                        this.radb4(l8, l5, d2, 0L, d, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radb5(l8, l5, d, l, d2, 0L, l6);
                    } else {
                        this.radb5(l8, l5, d2, 0L, d, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                default: {
                    if (l4 == 0L) {
                        this.radbg(l8, (long)n, l5, l9, d, l, d2, 0L, l6);
                    } else {
                        this.radbg(l8, (long)n, l5, l9, d2, 0L, d, l, l6);
                    }
                    if (l8 != 1L) break;
                    l4 = 1L - l4;
                }
            }
            l5 = l7;
            l6 += (long)(n - 1) * l8;
        }
        if (l4 == 0L) {
            return;
        }
        C.A(d2, 0L, d, l, this.nl);
    }

    void radf2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        int n6;
        float f;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n5;
        int n13 = n2 * n;
        int n14 = 2 * n;
        for (n11 = 0; n11 < n2; ++n11) {
            n10 = n4 + n11 * n14;
            n9 = n10 + n14 - 1;
            n8 = n3 + n11 * n;
            n7 = n8 + n13;
            float f2 = fArray[n8];
            f = fArray[n7];
            fArray2[n10] = f2 + f;
            fArray2[n9] = f2 - f;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n11 = 0; n11 < n2; ++n11) {
                n14 = n11 * n;
                n6 = 2 * n14;
                int n15 = n6 + n;
                int n16 = n14 + n13;
                for (int i = 2; i < n; i += 2) {
                    int n17 = n - i;
                    n10 = i - 1 + n12;
                    n9 = n4 + i + n6;
                    n8 = n4 + n17 + n15;
                    n7 = n3 + i + n14;
                    int n18 = n3 + i + n16;
                    f = fArray[n7 - 1];
                    float f3 = fArray[n7];
                    float f4 = fArray[n18 - 1];
                    float f5 = fArray[n18];
                    float f6 = this.wtable_r[n10 - 1];
                    float f7 = this.wtable_r[n10];
                    float f8 = f6 * f4 + f7 * f5;
                    float f9 = f6 * f5 - f7 * f4;
                    fArray2[n9] = f3 + f9;
                    fArray2[n9 - 1] = f + f8;
                    fArray2[n8] = f9 - f3;
                    fArray2[n8 - 1] = f - f8;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        n6 = 2 * n14;
        for (n11 = 0; n11 < n2; ++n11) {
            n14 = n11 * n;
            n10 = n4 + n6 + n;
            n9 = n3 + n - 1 + n14;
            fArray2[n10] = -fArray[n9 + n13];
            fArray2[n10 - 1] = fArray[n9];
        }
    }

    void radf2(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12 = l5;
        long l13 = l2 * l;
        long l14 = 2L * l;
        for (l11 = 0L; l11 < l2; ++l11) {
            l10 = l4 + l11 * l14;
            l9 = l10 + l14 - 1L;
            l8 = l3 + l11 * l;
            l7 = l8 + l13;
            float f = d.C(l8);
            float f2 = d.C(l7);
            d2.A(l10, f + f2);
            d2.A(l9, f - f2);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l11 = 0L; l11 < l2; ++l11) {
                l14 = l11 * l;
                l6 = 2L * l14;
                long l15 = l6 + l;
                long l16 = l14 + l13;
                for (long i = 2L; i < l; i += 2L) {
                    long l17 = l - i;
                    l10 = i - 1L + l12;
                    l9 = l4 + i + l6;
                    l8 = l4 + l17 + l15;
                    l7 = l3 + i + l14;
                    long l18 = l3 + i + l16;
                    float f = d.C(l7 - 1L);
                    float f3 = d.C(l7);
                    float f4 = d.C(l18 - 1L);
                    float f5 = d.C(l18);
                    float f6 = this.wtable_rl.C(l10 - 1L);
                    float f7 = this.wtable_rl.C(l10);
                    float f8 = f6 * f4 + f7 * f5;
                    float f9 = f6 * f5 - f7 * f4;
                    d2.A(l9, f3 + f9);
                    d2.A(l9 - 1L, f + f8);
                    d2.A(l8, f9 - f3);
                    d2.A(l8 - 1L, f - f8);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        l6 = 2L * l14;
        for (l11 = 0L; l11 < l2; ++l11) {
            l14 = l11 * l;
            l10 = l4 + l6 + l;
            l9 = l3 + l - 1L + l14;
            d2.A(l10, -d.C(l9 + l13));
            d2.A(l10 - 1L, d.C(l9));
        }
    }

    void radb2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n10 + n;
            n8 = n4 + n11;
            n7 = n3 + n10;
            n6 = n3 + n - 1 + n9;
            float f = fArray[n7];
            float f2 = fArray[n6];
            fArray2[n8] = f + f2;
            fArray2[n8 + n14] = f - f2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n12 * n;
                n10 = 2 * n11;
                n9 = n10 + n;
                n8 = n11 + n14;
                for (int i = 2; i < n; i += 2) {
                    int n15 = n - i;
                    n7 = i - 1 + n13;
                    n6 = n4 + i;
                    int n16 = n3 + i;
                    int n17 = n3 + n15;
                    float f = this.wtable_r[n7 - 1];
                    float f3 = this.wtable_r[n7];
                    int n18 = n16 + n10;
                    int n19 = n17 + n9;
                    int n20 = n6 + n11;
                    int n21 = n6 + n8;
                    float f4 = fArray[n18 - 1] - fArray[n19 - 1];
                    float f5 = fArray[n18] + fArray[n19];
                    float f6 = fArray[n18];
                    float f7 = fArray[n18 - 1];
                    float f8 = fArray[n19];
                    float f9 = fArray[n19 - 1];
                    fArray2[n20 - 1] = f7 + f9;
                    fArray2[n20] = f6 - f8;
                    fArray2[n21 - 1] = f * f4 - f3 * f5;
                    fArray2[n21] = f * f5 + f3 * f4;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n4 + n - 1 + n11;
            n8 = n3 + n10 + n;
            fArray2[n9] = 2.0f * fArray[n8 - 1];
            fArray2[n9 + n14] = -2.0f * fArray[n8];
        }
    }

    void radb2(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13 = l5;
        long l14 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l10 + l;
            l8 = l4 + l11;
            l7 = l3 + l10;
            l6 = l3 + l - 1L + l9;
            float f = d.C(l7);
            float f2 = d.C(l6);
            d2.A(l8, f + f2);
            d2.A(l8 + l14, f - f2);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l12 = 0L; l12 < l2; ++l12) {
                l11 = l12 * l;
                l10 = 2L * l11;
                l9 = l10 + l;
                l8 = l11 + l14;
                for (long i = 2L; i < l; i += 2L) {
                    long l15 = l - i;
                    l7 = i - 1L + l13;
                    l6 = l4 + i;
                    long l16 = l3 + i;
                    long l17 = l3 + l15;
                    float f = this.wtable_rl.C(l7 - 1L);
                    float f3 = this.wtable_rl.C(l7);
                    long l18 = l16 + l10;
                    long l19 = l17 + l9;
                    long l20 = l6 + l11;
                    long l21 = l6 + l8;
                    float f4 = d.C(l18 - 1L) - d.C(l19 - 1L);
                    float f5 = d.C(l18) + d.C(l19);
                    float f6 = d.C(l18);
                    float f7 = d.C(l18 - 1L);
                    float f8 = d.C(l19);
                    float f9 = d.C(l19 - 1L);
                    d2.A(l20 - 1L, f7 + f9);
                    d2.A(l20, f6 - f8);
                    d2.A(l21 - 1L, f * f4 - f3 * f5);
                    d2.A(l21, f * f5 + f3 * f4);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l4 + l - 1L + l11;
            l8 = l3 + l10 + l;
            d2.A(l9, 2.0f * d.C(l8 - 1L));
            d2.A(l9 + l14, -2.0f * d.C(l8));
        }
    }

    void radf3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        float f2 = -0.5f;
        float f3 = 0.8660254f;
        int n13 = n5;
        int n14 = n13 + n;
        int n15 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n15;
            n9 = (3 * n12 + 1) * n;
            n8 = n3 + n11;
            n7 = n8 + n15;
            n6 = n8 + n10;
            float f4 = fArray[n8];
            float f5 = fArray[n7];
            float f6 = fArray[n6];
            f = f5 + f6;
            fArray2[n4 + 3 * n11] = f4 + f;
            fArray2[n4 + n9 + n] = 0.8660254f * (f6 - f5);
            fArray2[n4 + n - 1 + n9] = f4 + -0.5f * f;
        }
        if (n == 1) {
            return;
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 3 * n11;
            n9 = n11 + n15;
            n8 = n9 + n15;
            n7 = n10 + n;
            n6 = n7 + n;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = i - 1 + n13;
                int n18 = i - 1 + n14;
                float f7 = this.wtable_r[n17 - 1];
                float f8 = this.wtable_r[n17];
                float f9 = this.wtable_r[n18 - 1];
                float f10 = this.wtable_r[n18];
                int n19 = n3 + i;
                int n20 = n4 + i;
                int n21 = n4 + n16;
                int n22 = n19 + n11;
                int n23 = n19 + n9;
                int n24 = n19 + n8;
                float f11 = fArray[n22 - 1];
                float f12 = fArray[n22];
                float f13 = fArray[n23 - 1];
                float f14 = fArray[n23];
                float f15 = fArray[n24 - 1];
                float f16 = fArray[n24];
                float f17 = f7 * f13 + f8 * f14;
                float f18 = f7 * f14 - f8 * f13;
                float f19 = f9 * f15 + f10 * f16;
                float f20 = f9 * f16 - f10 * f15;
                f = f17 + f19;
                float f21 = f18 + f20;
                float f22 = f11 + -0.5f * f;
                float f23 = f12 + -0.5f * f21;
                float f24 = 0.8660254f * (f18 - f20);
                float f25 = 0.8660254f * (f19 - f17);
                int n25 = n20 + n10;
                int n26 = n21 + n7;
                int n27 = n20 + n6;
                fArray2[n25 - 1] = f11 + f;
                fArray2[n25] = f12 + f21;
                fArray2[n26 - 1] = f22 - f24;
                fArray2[n26] = f25 - f23;
                fArray2[n27 - 1] = f22 + f24;
                fArray2[n27] = f23 + f25;
            }
        }
    }

    void radf3(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        float f2 = -0.5f;
        float f3 = 0.8660254f;
        long l13 = l5;
        long l14 = l13 + l;
        long l15 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l15;
            l9 = (3L * l12 + 1L) * l;
            l8 = l3 + l11;
            l7 = l8 + l15;
            l6 = l8 + l10;
            float f4 = d.C(l8);
            float f5 = d.C(l7);
            float f6 = d.C(l6);
            f = f5 + f6;
            d2.A(l4 + 3L * l11, f4 + f);
            d2.A(l4 + l9 + l, 0.8660254f * (f6 - f5));
            d2.A(l4 + l - 1L + l9, f4 + -0.5f * f);
        }
        if (l == 1L) {
            return;
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 3L * l11;
            l9 = l11 + l15;
            l8 = l9 + l15;
            l7 = l10 + l;
            l6 = l7 + l;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = i - 1L + l13;
                long l18 = i - 1L + l14;
                float f7 = this.wtable_rl.C(l17 - 1L);
                float f8 = this.wtable_rl.C(l17);
                float f9 = this.wtable_rl.C(l18 - 1L);
                float f10 = this.wtable_rl.C(l18);
                long l19 = l3 + i;
                long l20 = l4 + i;
                long l21 = l4 + l16;
                long l22 = l19 + l11;
                long l23 = l19 + l9;
                long l24 = l19 + l8;
                float f11 = d.C(l22 - 1L);
                float f12 = d.C(l22);
                float f13 = d.C(l23 - 1L);
                float f14 = d.C(l23);
                float f15 = d.C(l24 - 1L);
                float f16 = d.C(l24);
                float f17 = f7 * f13 + f8 * f14;
                float f18 = f7 * f14 - f8 * f13;
                float f19 = f9 * f15 + f10 * f16;
                float f20 = f9 * f16 - f10 * f15;
                f = f17 + f19;
                float f21 = f18 + f20;
                float f22 = f11 + -0.5f * f;
                float f23 = f12 + -0.5f * f21;
                float f24 = 0.8660254f * (f18 - f20);
                float f25 = 0.8660254f * (f19 - f17);
                long l25 = l20 + l10;
                long l26 = l21 + l7;
                long l27 = l20 + l6;
                d2.A(l25 - 1L, f11 + f);
                d2.A(l25, f12 + f21);
                d2.A(l26 - 1L, f22 - f24);
                d2.A(l26, f25 - f23);
                d2.A(l27 - 1L, f22 + f24);
                d2.A(l27, f23 + f25);
            }
        }
    }

    void radb3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        int n6;
        int n7;
        int n8;
        int n9;
        float f4 = -0.5f;
        float f5 = 0.8660254f;
        int n10 = n5;
        int n11 = n10 + n;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = n9 * n;
            n7 = n3 + 3 * n8;
            n6 = n7 + 2 * n;
            float f6 = fArray[n7];
            f3 = 2.0f * fArray[n6 - 1];
            f2 = f6 + -0.5f * f3;
            f = 1.7320508f * fArray[n6];
            fArray2[n4 + n8] = f6 + f3;
            fArray2[n4 + (n9 + n2) * n] = f2 - f;
            fArray2[n4 + (n9 + 2 * n2) * n] = f2 + f;
        }
        if (n == 1) {
            return;
        }
        n9 = n2 * n;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n8 * n;
            n6 = 3 * n7;
            int n12 = n6 + n;
            int n13 = n12 + n;
            int n14 = n7 + n9;
            int n15 = n14 + n9;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = n3 + i;
                int n18 = n3 + n16;
                int n19 = n4 + i;
                int n20 = n17 + n6;
                int n21 = n17 + n13;
                int n22 = n18 + n12;
                float f7 = fArray[n20 - 1];
                float f8 = fArray[n20];
                float f9 = fArray[n21 - 1];
                float f10 = fArray[n21];
                float f11 = fArray[n22 - 1];
                float f12 = fArray[n22];
                f3 = f9 + f11;
                f2 = f7 + -0.5f * f3;
                float f13 = f10 - f12;
                float f14 = f8 + -0.5f * f13;
                float f15 = 0.8660254f * (f9 - f11);
                f = 0.8660254f * (f10 + f12);
                float f16 = f2 - f;
                float f17 = f2 + f;
                float f18 = f14 + f15;
                float f19 = f14 - f15;
                int n23 = i - 1 + n10;
                int n24 = i - 1 + n11;
                float f20 = this.wtable_r[n23 - 1];
                float f21 = this.wtable_r[n23];
                float f22 = this.wtable_r[n24 - 1];
                float f23 = this.wtable_r[n24];
                int n25 = n19 + n7;
                int n26 = n19 + n14;
                int n27 = n19 + n15;
                fArray2[n25 - 1] = f7 + f3;
                fArray2[n25] = f8 + f13;
                fArray2[n26 - 1] = f20 * f16 - f21 * f18;
                fArray2[n26] = f20 * f18 + f21 * f16;
                fArray2[n27 - 1] = f22 * f17 - f23 * f19;
                fArray2[n27] = f22 * f19 + f23 * f17;
            }
        }
    }

    void radb3(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        float f2;
        float f3;
        long l6;
        long l7;
        long l8;
        long l9;
        float f4 = -0.5f;
        float f5 = 0.8660254f;
        long l10 = l5;
        long l11 = l10 + l;
        for (l9 = 0L; l9 < l2; ++l9) {
            l8 = l9 * l;
            l7 = l3 + 3L * l8;
            l6 = l7 + 2L * l;
            float f6 = d.C(l7);
            f3 = 2.0f * d.C(l6 - 1L);
            f2 = f6 + -0.5f * f3;
            f = 1.7320508f * d.C(l6);
            d2.A(l4 + l8, f6 + f3);
            d2.A(l4 + (l9 + l2) * l, f2 - f);
            d2.A(l4 + (l9 + 2L * l2) * l, f2 + f);
        }
        if (l == 1L) {
            return;
        }
        l9 = l2 * l;
        for (l8 = 0L; l8 < l2; ++l8) {
            l7 = l8 * l;
            l6 = 3L * l7;
            long l12 = l6 + l;
            long l13 = l12 + l;
            long l14 = l7 + l9;
            long l15 = l14 + l9;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = l3 + i;
                long l18 = l3 + l16;
                long l19 = l4 + i;
                long l20 = l17 + l6;
                long l21 = l17 + l13;
                long l22 = l18 + l12;
                float f7 = d.C(l20 - 1L);
                float f8 = d.C(l20);
                float f9 = d.C(l21 - 1L);
                float f10 = d.C(l21);
                float f11 = d.C(l22 - 1L);
                float f12 = d.C(l22);
                f3 = f9 + f11;
                f2 = f7 + -0.5f * f3;
                float f13 = f10 - f12;
                float f14 = f8 + -0.5f * f13;
                float f15 = 0.8660254f * (f9 - f11);
                f = 0.8660254f * (f10 + f12);
                float f16 = f2 - f;
                float f17 = f2 + f;
                float f18 = f14 + f15;
                float f19 = f14 - f15;
                long l23 = i - 1L + l10;
                long l24 = i - 1L + l11;
                float f20 = this.wtable_rl.C(l23 - 1L);
                float f21 = this.wtable_rl.C(l23);
                float f22 = this.wtable_rl.C(l24 - 1L);
                float f23 = this.wtable_rl.C(l24);
                long l25 = l19 + l7;
                long l26 = l19 + l14;
                long l27 = l19 + l15;
                d2.A(l25 - 1L, f7 + f3);
                d2.A(l25, f8 + f13);
                d2.A(l26 - 1L, f20 * f16 - f21 * f18);
                d2.A(l26, f20 * f18 + f21 * f16);
                d2.A(l27 - 1L, f22 * f17 - f23 * f19);
                d2.A(l27, f22 * f19 + f23 * f17);
            }
        }
    }

    void radf4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        int n6;
        int n7;
        float f2;
        float f3;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        float f4 = 0.70710677f;
        int n15 = n5;
        int n16 = n5 + n;
        int n17 = n16 + n;
        int n18 = n2 * n;
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            float f5 = fArray[n3 + n13];
            float f6 = fArray[n3 + n11];
            float f7 = fArray[n3 + n10];
            float f8 = fArray[n3 + n9];
            f3 = f6 + f8;
            f2 = f5 + f7;
            n7 = n4 + n12;
            n6 = n4 + n8 + n;
            fArray2[n7] = f3 + f2;
            fArray2[n6 - 1 + n + n] = f2 - f3;
            fArray2[n6 - 1] = f5 - f7;
            fArray2[n6] = f8 - f6;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n14 = 0; n14 < n2; ++n14) {
                n13 = n14 * n;
                n12 = n13 + n18;
                n11 = n12 + n18;
                n10 = n11 + n18;
                n9 = 4 * n13;
                n8 = n9 + n;
                int n19 = n8 + n;
                int n20 = n19 + n;
                for (int i = 2; i < n; i += 2) {
                    int n21 = n - i;
                    int n22 = i - 1 + n15;
                    int n23 = i - 1 + n16;
                    n7 = i - 1 + n17;
                    float f9 = this.wtable_r[n22 - 1];
                    float f10 = this.wtable_r[n22];
                    float f11 = this.wtable_r[n23 - 1];
                    float f12 = this.wtable_r[n23];
                    float f13 = this.wtable_r[n7 - 1];
                    float f14 = this.wtable_r[n7];
                    n6 = n3 + i;
                    int n24 = n4 + i;
                    int n25 = n4 + n21;
                    int n26 = n6 + n13;
                    int n27 = n6 + n12;
                    int n28 = n6 + n11;
                    int n29 = n6 + n10;
                    float f15 = fArray[n26 - 1];
                    float f16 = fArray[n26];
                    float f17 = fArray[n27 - 1];
                    float f18 = fArray[n27];
                    float f19 = fArray[n28 - 1];
                    float f20 = fArray[n28];
                    float f21 = fArray[n29 - 1];
                    float f22 = fArray[n29];
                    float f23 = f9 * f17 + f10 * f18;
                    float f24 = f9 * f18 - f10 * f17;
                    float f25 = f11 * f19 + f12 * f20;
                    float f26 = f11 * f20 - f12 * f19;
                    float f27 = f13 * f21 + f14 * f22;
                    float f28 = f13 * f22 - f14 * f21;
                    f3 = f23 + f27;
                    float f29 = f27 - f23;
                    f = f24 + f28;
                    float f30 = f24 - f28;
                    float f31 = f16 + f26;
                    float f32 = f16 - f26;
                    f2 = f15 + f25;
                    float f33 = f15 - f25;
                    int n30 = n24 + n9;
                    int n31 = n25 + n8;
                    int n32 = n24 + n19;
                    int n33 = n25 + n20;
                    fArray2[n30 - 1] = f3 + f2;
                    fArray2[n33 - 1] = f2 - f3;
                    fArray2[n30] = f + f31;
                    fArray2[n33] = f - f31;
                    fArray2[n32 - 1] = f30 + f33;
                    fArray2[n31 - 1] = f33 - f30;
                    fArray2[n32] = f29 + f32;
                    fArray2[n31] = f29 - f32;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            int n34 = n8 + n;
            int n35 = n34 + n;
            int n36 = n3 + n;
            int n37 = n4 + n;
            float f34 = fArray[n36 - 1 + n13];
            float f35 = fArray[n36 - 1 + n11];
            float f36 = fArray[n36 - 1 + n10];
            float f37 = fArray[n36 - 1 + n9];
            f = -0.70710677f * (f35 + f37);
            f3 = 0.70710677f * (f35 - f37);
            fArray2[n37 - 1 + n12] = f3 + f34;
            fArray2[n37 - 1 + n34] = f34 - f3;
            fArray2[n4 + n8] = f - f36;
            fArray2[n4 + n35] = f + f36;
        }
    }

    void radf4(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        long l6;
        long l7;
        float f2;
        float f3;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        float f4 = 0.70710677f;
        long l15 = l5;
        long l16 = l5 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            float f5 = d.C(l3 + l13);
            float f6 = d.C(l3 + l11);
            float f7 = d.C(l3 + l10);
            float f8 = d.C(l3 + l9);
            f3 = f6 + f8;
            f2 = f5 + f7;
            l7 = l4 + l12;
            l6 = l4 + l8 + l;
            d2.A(l7, f3 + f2);
            d2.A(l6 - 1L + l + l, f2 - f3);
            d2.A(l6 - 1L, f5 - f7);
            d2.A(l6, f8 - f6);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                long l19 = l8 + l;
                long l20 = l19 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l21 = l - i;
                    l7 = i - 1L + l15;
                    l6 = i - 1L + l16;
                    long l22 = i - 1L + l17;
                    float f9 = this.wtable_rl.C(l7 - 1L);
                    float f10 = this.wtable_rl.C(l7);
                    float f11 = this.wtable_rl.C(l6 - 1L);
                    float f12 = this.wtable_rl.C(l6);
                    float f13 = this.wtable_rl.C(l22 - 1L);
                    float f14 = this.wtable_rl.C(l22);
                    long l23 = l3 + i;
                    long l24 = l4 + i;
                    long l25 = l4 + l21;
                    long l26 = l23 + l13;
                    long l27 = l23 + l12;
                    long l28 = l23 + l11;
                    long l29 = l23 + l10;
                    float f15 = d.C(l26 - 1L);
                    float f16 = d.C(l26);
                    float f17 = d.C(l27 - 1L);
                    float f18 = d.C(l27);
                    float f19 = d.C(l28 - 1L);
                    float f20 = d.C(l28);
                    float f21 = d.C(l29 - 1L);
                    float f22 = d.C(l29);
                    float f23 = f9 * f17 + f10 * f18;
                    float f24 = f9 * f18 - f10 * f17;
                    float f25 = f11 * f19 + f12 * f20;
                    float f26 = f11 * f20 - f12 * f19;
                    float f27 = f13 * f21 + f14 * f22;
                    float f28 = f13 * f22 - f14 * f21;
                    f3 = f23 + f27;
                    float f29 = f27 - f23;
                    f = f24 + f28;
                    float f30 = f24 - f28;
                    float f31 = f16 + f26;
                    float f32 = f16 - f26;
                    f2 = f15 + f25;
                    float f33 = f15 - f25;
                    long l30 = l24 + l9;
                    long l31 = l25 + l8;
                    long l32 = l24 + l19;
                    long l33 = l25 + l20;
                    d2.A(l30 - 1L, f3 + f2);
                    d2.A(l33 - 1L, f2 - f3);
                    d2.A(l30, f + f31);
                    d2.A(l33, f - f31);
                    d2.A(l32 - 1L, f30 + f33);
                    d2.A(l31 - 1L, f33 - f30);
                    d2.A(l32, f29 + f32);
                    d2.A(l31, f29 - f32);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            long l34 = l8 + l;
            long l35 = l34 + l;
            l7 = l3 + l;
            l6 = l4 + l;
            float f34 = d.C(l7 - 1L + l13);
            float f35 = d.C(l7 - 1L + l11);
            float f36 = d.C(l7 - 1L + l10);
            float f37 = d.C(l7 - 1L + l9);
            f = -0.70710677f * (f35 + f37);
            f3 = 0.70710677f * (f35 - f37);
            d2.A(l6 - 1L + l12, f3 + f34);
            d2.A(l6 - 1L + l34, f34 - f3);
            d2.A(l4 + l8, f - f36);
            d2.A(l4 + l35, f + f36);
        }
    }

    void radb4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        float f9 = 1.4142135f;
        int n15 = n5;
        int n16 = n15 + n;
        int n17 = n16 + n;
        int n18 = n2 * n;
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            n7 = n8 + n;
            n6 = n7 + n;
            float f10 = fArray[n3 + n12];
            float f11 = fArray[n3 + n7];
            f8 = fArray[n3 + n - 1 + n6];
            f7 = fArray[n3 + n - 1 + n8];
            f6 = f10 - f8;
            f5 = f10 + f8;
            f4 = f7 + f7;
            f3 = f11 + f11;
            fArray2[n4 + n13] = f5 + f4;
            fArray2[n4 + n11] = f6 - f3;
            fArray2[n4 + n10] = f5 - f4;
            fArray2[n4 + n9] = f6 + f3;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n14 = 0; n14 < n2; ++n14) {
                n13 = n14 * n;
                n12 = n13 + n18;
                n11 = n12 + n18;
                n10 = n11 + n18;
                n9 = 4 * n13;
                n8 = n9 + n;
                n7 = n8 + n;
                n6 = n7 + n;
                for (int i = 2; i < n; i += 2) {
                    int n19 = n - i;
                    int n20 = i - 1 + n15;
                    int n21 = i - 1 + n16;
                    int n22 = i - 1 + n17;
                    float f12 = this.wtable_r[n20 - 1];
                    float f13 = this.wtable_r[n20];
                    float f14 = this.wtable_r[n21 - 1];
                    float f15 = this.wtable_r[n21];
                    float f16 = this.wtable_r[n22 - 1];
                    float f17 = this.wtable_r[n22];
                    int n23 = n3 + i;
                    int n24 = n3 + n19;
                    int n25 = n4 + i;
                    int n26 = n23 + n9;
                    int n27 = n24 + n8;
                    int n28 = n23 + n7;
                    int n29 = n24 + n6;
                    float f18 = fArray[n26 - 1];
                    float f19 = fArray[n26];
                    float f20 = fArray[n27 - 1];
                    float f21 = fArray[n27];
                    float f22 = fArray[n28 - 1];
                    float f23 = fArray[n28];
                    float f24 = fArray[n29 - 1];
                    float f25 = fArray[n29];
                    f2 = f19 + f25;
                    f = f19 - f25;
                    float f26 = f23 - f21;
                    f3 = f23 + f21;
                    f6 = f18 - f24;
                    f5 = f18 + f24;
                    float f27 = f22 - f20;
                    f4 = f22 + f20;
                    float f28 = f5 - f4;
                    float f29 = f - f26;
                    float f30 = f6 - f3;
                    float f31 = f6 + f3;
                    float f32 = f2 + f27;
                    float f33 = f2 - f27;
                    int n30 = n25 + n13;
                    int n31 = n25 + n12;
                    int n32 = n25 + n11;
                    int n33 = n25 + n10;
                    fArray2[n30 - 1] = f5 + f4;
                    fArray2[n30] = f + f26;
                    fArray2[n31 - 1] = f12 * f30 - f13 * f32;
                    fArray2[n31] = f12 * f32 + f13 * f30;
                    fArray2[n32 - 1] = f14 * f28 - f15 * f29;
                    fArray2[n32] = f14 * f29 + f15 * f28;
                    fArray2[n33 - 1] = f16 * f31 - f17 * f33;
                    fArray2[n33] = f16 * f33 + f17 * f31;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            n7 = n8 + n;
            n6 = n7 + n;
            int n34 = n3 + n;
            int n35 = n4 + n;
            f8 = fArray[n34 - 1 + n12];
            f7 = fArray[n34 - 1 + n7];
            float f34 = fArray[n3 + n8];
            float f35 = fArray[n3 + n6];
            f2 = f34 + f35;
            f = f35 - f34;
            f6 = f8 - f7;
            f5 = f8 + f7;
            fArray2[n35 - 1 + n13] = f5 + f5;
            fArray2[n35 - 1 + n11] = 1.4142135f * (f6 - f2);
            fArray2[n35 - 1 + n10] = f + f;
            fArray2[n35 - 1 + n9] = -1.4142135f * (f6 + f2);
        }
    }

    void radb4(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        float f7 = 1.4142135f;
        long l15 = l5;
        long l16 = l15 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            float f8 = d.C(l3 + l12);
            float f9 = d.C(l3 + l7);
            float f10 = d.C(l3 + l - 1L + l6);
            float f11 = d.C(l3 + l - 1L + l8);
            f6 = f8 - f10;
            f5 = f8 + f10;
            f4 = f11 + f11;
            f3 = f9 + f9;
            d2.A(l4 + l13, f5 + f4);
            d2.A(l4 + l11, f6 - f3);
            d2.A(l4 + l10, f5 - f4);
            d2.A(l4 + l9, f6 + f3);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                l7 = l8 + l;
                l6 = l7 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l19 = l - i;
                    long l20 = i - 1L + l15;
                    long l21 = i - 1L + l16;
                    long l22 = i - 1L + l17;
                    float f12 = this.wtable_rl.C(l20 - 1L);
                    float f13 = this.wtable_rl.C(l20);
                    float f14 = this.wtable_rl.C(l21 - 1L);
                    float f15 = this.wtable_rl.C(l21);
                    float f16 = this.wtable_rl.C(l22 - 1L);
                    float f17 = this.wtable_rl.C(l22);
                    long l23 = l3 + i;
                    long l24 = l3 + l19;
                    long l25 = l4 + i;
                    long l26 = l23 + l9;
                    long l27 = l24 + l8;
                    long l28 = l23 + l7;
                    long l29 = l24 + l6;
                    float f18 = d.C(l26 - 1L);
                    float f19 = d.C(l26);
                    float f20 = d.C(l27 - 1L);
                    float f21 = d.C(l27);
                    float f22 = d.C(l28 - 1L);
                    float f23 = d.C(l28);
                    float f24 = d.C(l29 - 1L);
                    float f25 = d.C(l29);
                    f2 = f19 + f25;
                    f = f19 - f25;
                    float f26 = f23 - f21;
                    f3 = f23 + f21;
                    f6 = f18 - f24;
                    f5 = f18 + f24;
                    float f27 = f22 - f20;
                    f4 = f22 + f20;
                    float f28 = f5 - f4;
                    float f29 = f - f26;
                    float f30 = f6 - f3;
                    float f31 = f6 + f3;
                    float f32 = f2 + f27;
                    float f33 = f2 - f27;
                    long l30 = l25 + l13;
                    long l31 = l25 + l12;
                    long l32 = l25 + l11;
                    long l33 = l25 + l10;
                    d2.A(l30 - 1L, f5 + f4);
                    d2.A(l30, f + f26);
                    d2.A(l31 - 1L, f12 * f30 - f13 * f32);
                    d2.A(l31, f12 * f32 + f13 * f30);
                    d2.A(l32 - 1L, f14 * f28 - f15 * f29);
                    d2.A(l32, f14 * f29 + f15 * f28);
                    d2.A(l33 - 1L, f16 * f31 - f17 * f33);
                    d2.A(l33, f16 * f33 + f17 * f31);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            long l34 = l3 + l;
            long l35 = l4 + l;
            float f34 = d.C(l34 - 1L + l12);
            float f35 = d.C(l34 - 1L + l7);
            float f36 = d.C(l3 + l8);
            float f37 = d.C(l3 + l6);
            f2 = f36 + f37;
            f = f37 - f36;
            f6 = f34 - f35;
            f5 = f34 + f35;
            d2.A(l35 - 1L + l13, f5 + f5);
            d2.A(l35 - 1L + l11, 1.4142135f * (f6 - f2));
            d2.A(l35 - 1L + l10, f + f);
            d2.A(l35 - 1L + l9, -1.4142135f * (f6 + f2));
        }
    }

    void radf5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        float f5 = 0.309017f;
        float f6 = 0.95105654f;
        float f7 = -0.809017f;
        float f8 = 0.58778524f;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n4 + n - 1;
            float f9 = fArray[n3 + n16];
            float f10 = fArray[n3 + n10];
            float f11 = fArray[n3 + n9];
            float f12 = fArray[n3 + n8];
            float f13 = fArray[n3 + n7];
            f4 = f13 + f10;
            f3 = f13 - f10;
            f2 = f12 + f11;
            f = f12 - f11;
            fArray2[n4 + n15] = f9 + f4 + f2;
            fArray2[n6 + n14] = f9 + 0.309017f * f4 + -0.809017f * f2;
            fArray2[n4 + n13] = 0.95105654f * f3 + 0.58778524f * f;
            fArray2[n6 + n12] = f9 + -0.809017f * f4 + 0.309017f * f2;
            fArray2[n4 + n11] = 0.58778524f * f3 - 0.95105654f * f;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                n6 = i - 1 + n18;
                int n23 = i - 1 + n19;
                int n24 = i - 1 + n20;
                int n25 = i - 1 + n21;
                float f14 = this.wtable_r[n6 - 1];
                float f15 = this.wtable_r[n6];
                float f16 = this.wtable_r[n23 - 1];
                float f17 = this.wtable_r[n23];
                float f18 = this.wtable_r[n24 - 1];
                float f19 = this.wtable_r[n24];
                float f20 = this.wtable_r[n25 - 1];
                float f21 = this.wtable_r[n25];
                int n26 = n - i;
                int n27 = n3 + i;
                int n28 = n4 + i;
                int n29 = n4 + n26;
                int n30 = n27 + n16;
                int n31 = n27 + n10;
                int n32 = n27 + n9;
                int n33 = n27 + n8;
                int n34 = n27 + n7;
                float f22 = fArray[n30 - 1];
                float f23 = fArray[n30];
                float f24 = fArray[n31 - 1];
                float f25 = fArray[n31];
                float f26 = fArray[n32 - 1];
                float f27 = fArray[n32];
                float f28 = fArray[n33 - 1];
                float f29 = fArray[n33];
                float f30 = fArray[n34 - 1];
                float f31 = fArray[n34];
                float f32 = f14 * f24 + f15 * f25;
                float f33 = f14 * f25 - f15 * f24;
                float f34 = f16 * f26 + f17 * f27;
                float f35 = f16 * f27 - f17 * f26;
                float f36 = f18 * f28 + f19 * f29;
                float f37 = f18 * f29 - f19 * f28;
                float f38 = f20 * f30 + f21 * f31;
                float f39 = f20 * f31 - f21 * f30;
                f4 = f32 + f38;
                f3 = f38 - f32;
                float f40 = f33 - f39;
                float f41 = f33 + f39;
                f2 = f34 + f36;
                f = f36 - f34;
                float f42 = f35 - f37;
                float f43 = f35 + f37;
                float f44 = f22 + 0.309017f * f4 + -0.809017f * f2;
                float f45 = f23 + 0.309017f * f41 + -0.809017f * f43;
                float f46 = f22 + -0.809017f * f4 + 0.309017f * f2;
                float f47 = f23 + -0.809017f * f41 + 0.309017f * f43;
                float f48 = 0.95105654f * f40 + 0.58778524f * f42;
                float f49 = 0.95105654f * f3 + 0.58778524f * f;
                float f50 = 0.58778524f * f40 - 0.95105654f * f42;
                float f51 = 0.58778524f * f3 - 0.95105654f * f;
                int n35 = n28 + n15;
                int n36 = n29 + n14;
                int n37 = n28 + n13;
                int n38 = n29 + n12;
                int n39 = n28 + n11;
                fArray2[n35 - 1] = f22 + f4 + f2;
                fArray2[n35] = f23 + f41 + f43;
                fArray2[n37 - 1] = f44 + f48;
                fArray2[n36 - 1] = f44 - f48;
                fArray2[n37] = f45 + f49;
                fArray2[n36] = f49 - f45;
                fArray2[n39 - 1] = f46 + f50;
                fArray2[n38 - 1] = f46 - f50;
                fArray2[n39] = f47 + f51;
                fArray2[n38] = f51 - f47;
            }
        }
    }

    void radf5(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        float f2;
        float f3;
        float f4;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        float f5 = 0.309017f;
        float f6 = 0.95105654f;
        float f7 = -0.809017f;
        float f8 = 0.58778524f;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l4 + l - 1L;
            float f9 = d.C(l3 + l16);
            float f10 = d.C(l3 + l10);
            float f11 = d.C(l3 + l9);
            float f12 = d.C(l3 + l8);
            float f13 = d.C(l3 + l7);
            f4 = f13 + f10;
            f3 = f13 - f10;
            f2 = f12 + f11;
            f = f12 - f11;
            d2.A(l4 + l15, f9 + f4 + f2);
            d2.A(l6 + l14, f9 + 0.309017f * f4 + -0.809017f * f2);
            d2.A(l4 + l13, 0.95105654f * f3 + 0.58778524f * f);
            d2.A(l6 + l12, f9 + -0.809017f * f4 + 0.309017f * f2);
            d2.A(l4 + l11, 0.58778524f * f3 - 0.95105654f * f);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                l6 = i - 1L + l18;
                long l23 = i - 1L + l19;
                long l24 = i - 1L + l20;
                long l25 = i - 1L + l21;
                float f14 = this.wtable_rl.C(l6 - 1L);
                float f15 = this.wtable_rl.C(l6);
                float f16 = this.wtable_rl.C(l23 - 1L);
                float f17 = this.wtable_rl.C(l23);
                float f18 = this.wtable_rl.C(l24 - 1L);
                float f19 = this.wtable_rl.C(l24);
                float f20 = this.wtable_rl.C(l25 - 1L);
                float f21 = this.wtable_rl.C(l25);
                long l26 = l - i;
                long l27 = l3 + i;
                long l28 = l4 + i;
                long l29 = l4 + l26;
                long l30 = l27 + l16;
                long l31 = l27 + l10;
                long l32 = l27 + l9;
                long l33 = l27 + l8;
                long l34 = l27 + l7;
                float f22 = d.C(l30 - 1L);
                float f23 = d.C(l30);
                float f24 = d.C(l31 - 1L);
                float f25 = d.C(l31);
                float f26 = d.C(l32 - 1L);
                float f27 = d.C(l32);
                float f28 = d.C(l33 - 1L);
                float f29 = d.C(l33);
                float f30 = d.C(l34 - 1L);
                float f31 = d.C(l34);
                float f32 = f14 * f24 + f15 * f25;
                float f33 = f14 * f25 - f15 * f24;
                float f34 = f16 * f26 + f17 * f27;
                float f35 = f16 * f27 - f17 * f26;
                float f36 = f18 * f28 + f19 * f29;
                float f37 = f18 * f29 - f19 * f28;
                float f38 = f20 * f30 + f21 * f31;
                float f39 = f20 * f31 - f21 * f30;
                f4 = f32 + f38;
                f3 = f38 - f32;
                float f40 = f33 - f39;
                float f41 = f33 + f39;
                f2 = f34 + f36;
                f = f36 - f34;
                float f42 = f35 - f37;
                float f43 = f35 + f37;
                float f44 = f22 + 0.309017f * f4 + -0.809017f * f2;
                float f45 = f23 + 0.309017f * f41 + -0.809017f * f43;
                float f46 = f22 + -0.809017f * f4 + 0.309017f * f2;
                float f47 = f23 + -0.809017f * f41 + 0.309017f * f43;
                float f48 = 0.95105654f * f40 + 0.58778524f * f42;
                float f49 = 0.95105654f * f3 + 0.58778524f * f;
                float f50 = 0.58778524f * f40 - 0.95105654f * f42;
                float f51 = 0.58778524f * f3 - 0.95105654f * f;
                long l35 = l28 + l15;
                long l36 = l29 + l14;
                long l37 = l28 + l13;
                long l38 = l29 + l12;
                long l39 = l28 + l11;
                d2.A(l35 - 1L, f22 + f4 + f2);
                d2.A(l35, f23 + f41 + f43);
                d2.A(l37 - 1L, f44 + f48);
                d2.A(l36 - 1L, f44 - f48);
                d2.A(l37, f45 + f49);
                d2.A(l36, f49 - f45);
                d2.A(l39 - 1L, f46 + f50);
                d2.A(l38 - 1L, f46 - f50);
                d2.A(l39, f47 + f51);
                d2.A(l38, f51 - f47);
            }
        }
    }

    void radb5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        float f9 = 0.309017f;
        float f10 = 0.95105654f;
        float f11 = -0.809017f;
        float f12 = 0.58778524f;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n3 + n - 1;
            float f13 = fArray[n3 + n15];
            f8 = 2.0f * fArray[n3 + n13];
            f7 = 2.0f * fArray[n3 + n11];
            f6 = 2.0f * fArray[n6 + n14];
            f5 = 2.0f * fArray[n6 + n12];
            f4 = f13 + 0.309017f * f6 + -0.809017f * f5;
            f3 = f13 + -0.809017f * f6 + 0.309017f * f5;
            f2 = 0.95105654f * f8 + 0.58778524f * f7;
            f = 0.58778524f * f8 - 0.95105654f * f7;
            fArray2[n4 + n16] = f13 + f6 + f5;
            fArray2[n4 + n10] = f4 - f2;
            fArray2[n4 + n9] = f3 - f;
            fArray2[n4 + n8] = f3 + f;
            fArray2[n4 + n7] = f4 + f2;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                int n23 = n - i;
                n6 = i - 1 + n18;
                int n24 = i - 1 + n19;
                int n25 = i - 1 + n20;
                int n26 = i - 1 + n21;
                float f14 = this.wtable_r[n6 - 1];
                float f15 = this.wtable_r[n6];
                float f16 = this.wtable_r[n24 - 1];
                float f17 = this.wtable_r[n24];
                float f18 = this.wtable_r[n25 - 1];
                float f19 = this.wtable_r[n25];
                float f20 = this.wtable_r[n26 - 1];
                float f21 = this.wtable_r[n26];
                int n27 = n3 + i;
                int n28 = n3 + n23;
                int n29 = n4 + i;
                int n30 = n27 + n15;
                int n31 = n28 + n14;
                int n32 = n27 + n13;
                int n33 = n28 + n12;
                int n34 = n27 + n11;
                float f22 = fArray[n30 - 1];
                float f23 = fArray[n30];
                float f24 = fArray[n31 - 1];
                float f25 = fArray[n31];
                float f26 = fArray[n32 - 1];
                float f27 = fArray[n32];
                float f28 = fArray[n33 - 1];
                float f29 = fArray[n33];
                float f30 = fArray[n34 - 1];
                float f31 = fArray[n34];
                f8 = f27 + f25;
                float f32 = f27 - f25;
                f7 = f31 + f29;
                float f33 = f31 - f29;
                float f34 = f26 - f24;
                f6 = f26 + f24;
                float f35 = f30 - f28;
                f5 = f30 + f28;
                f4 = f22 + 0.309017f * f6 + -0.809017f * f5;
                float f36 = f23 + 0.309017f * f32 + -0.809017f * f33;
                f3 = f22 + -0.809017f * f6 + 0.309017f * f5;
                float f37 = f23 + -0.809017f * f32 + 0.309017f * f33;
                float f38 = 0.95105654f * f34 + 0.58778524f * f35;
                f2 = 0.95105654f * f8 + 0.58778524f * f7;
                float f39 = 0.58778524f * f34 - 0.95105654f * f35;
                f = 0.58778524f * f8 - 0.95105654f * f7;
                float f40 = f3 - f;
                float f41 = f3 + f;
                float f42 = f37 + f39;
                float f43 = f37 - f39;
                float f44 = f4 + f2;
                float f45 = f4 - f2;
                float f46 = f36 - f38;
                float f47 = f36 + f38;
                int n35 = n29 + n16;
                int n36 = n29 + n10;
                int n37 = n29 + n9;
                int n38 = n29 + n8;
                int n39 = n29 + n7;
                fArray2[n35 - 1] = f22 + f6 + f5;
                fArray2[n35] = f23 + f32 + f33;
                fArray2[n36 - 1] = f14 * f45 - f15 * f47;
                fArray2[n36] = f14 * f47 + f15 * f45;
                fArray2[n37 - 1] = f16 * f40 - f17 * f42;
                fArray2[n37] = f16 * f42 + f17 * f40;
                fArray2[n38 - 1] = f18 * f41 - f19 * f43;
                fArray2[n38] = f18 * f43 + f19 * f41;
                fArray2[n39 - 1] = f20 * f44 - f21 * f46;
                fArray2[n39] = f20 * f46 + f21 * f44;
            }
        }
    }

    void radb5(long l, long l2, D d, long l3, D d2, long l4, long l5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        float f9 = 0.309017f;
        float f10 = 0.95105654f;
        float f11 = -0.809017f;
        float f12 = 0.58778524f;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l3 + l - 1L;
            float f13 = d.C(l3 + l15);
            f8 = 2.0f * d.C(l3 + l13);
            f7 = 2.0f * d.C(l3 + l11);
            f6 = 2.0f * d.C(l6 + l14);
            f5 = 2.0f * d.C(l6 + l12);
            f4 = f13 + 0.309017f * f6 + -0.809017f * f5;
            f3 = f13 + -0.809017f * f6 + 0.309017f * f5;
            f2 = 0.95105654f * f8 + 0.58778524f * f7;
            f = 0.58778524f * f8 - 0.95105654f * f7;
            d2.A(l4 + l16, f13 + f6 + f5);
            d2.A(l4 + l10, f4 - f2);
            d2.A(l4 + l9, f3 - f);
            d2.A(l4 + l8, f3 + f);
            d2.A(l4 + l7, f4 + f2);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                long l23 = l - i;
                l6 = i - 1L + l18;
                long l24 = i - 1L + l19;
                long l25 = i - 1L + l20;
                long l26 = i - 1L + l21;
                float f14 = this.wtable_rl.C(l6 - 1L);
                float f15 = this.wtable_rl.C(l6);
                float f16 = this.wtable_rl.C(l24 - 1L);
                float f17 = this.wtable_rl.C(l24);
                float f18 = this.wtable_rl.C(l25 - 1L);
                float f19 = this.wtable_rl.C(l25);
                float f20 = this.wtable_rl.C(l26 - 1L);
                float f21 = this.wtable_rl.C(l26);
                long l27 = l3 + i;
                long l28 = l3 + l23;
                long l29 = l4 + i;
                long l30 = l27 + l15;
                long l31 = l28 + l14;
                long l32 = l27 + l13;
                long l33 = l28 + l12;
                long l34 = l27 + l11;
                float f22 = d.C(l30 - 1L);
                float f23 = d.C(l30);
                float f24 = d.C(l31 - 1L);
                float f25 = d.C(l31);
                float f26 = d.C(l32 - 1L);
                float f27 = d.C(l32);
                float f28 = d.C(l33 - 1L);
                float f29 = d.C(l33);
                float f30 = d.C(l34 - 1L);
                float f31 = d.C(l34);
                f8 = f27 + f25;
                float f32 = f27 - f25;
                f7 = f31 + f29;
                float f33 = f31 - f29;
                float f34 = f26 - f24;
                f6 = f26 + f24;
                float f35 = f30 - f28;
                f5 = f30 + f28;
                f4 = f22 + 0.309017f * f6 + -0.809017f * f5;
                float f36 = f23 + 0.309017f * f32 + -0.809017f * f33;
                f3 = f22 + -0.809017f * f6 + 0.309017f * f5;
                float f37 = f23 + -0.809017f * f32 + 0.309017f * f33;
                float f38 = 0.95105654f * f34 + 0.58778524f * f35;
                f2 = 0.95105654f * f8 + 0.58778524f * f7;
                float f39 = 0.58778524f * f34 - 0.95105654f * f35;
                f = 0.58778524f * f8 - 0.95105654f * f7;
                float f40 = f3 - f;
                float f41 = f3 + f;
                float f42 = f37 + f39;
                float f43 = f37 - f39;
                float f44 = f4 + f2;
                float f45 = f4 - f2;
                float f46 = f36 - f38;
                float f47 = f36 + f38;
                long l35 = l29 + l16;
                long l36 = l29 + l10;
                long l37 = l29 + l9;
                long l38 = l29 + l8;
                long l39 = l29 + l7;
                d2.A(l35 - 1L, f22 + f6 + f5);
                d2.A(l35, f23 + f32 + f33);
                d2.A(l36 - 1L, f14 * f45 - f15 * f47);
                d2.A(l36, f14 * f47 + f15 * f45);
                d2.A(l37 - 1L, f16 * f40 - f17 * f42);
                d2.A(l37, f16 * f42 + f17 * f40);
                d2.A(l38 - 1L, f18 * f41 - f19 * f43);
                d2.A(l38, f18 * f43 + f19 * f41);
                d2.A(l39 - 1L, f20 * f44 - f21 * f46);
                d2.A(l39, f20 * f46 + f21 * f44);
            }
        }
    }

    void radfg(int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19 = n7;
        float f = (float)Math.PI * 2 / (float)n2;
        float f2 = (float)FastMath.cos(f);
        float f3 = (float)FastMath.sin(f);
        int n20 = (n2 + 1) / 2;
        int n21 = (n - 1) / 2;
        if (n != 1) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n22;
            int n23;
            float f8;
            float f9;
            int n24;
            int n25;
            for (n18 = 0; n18 < n4; ++n18) {
                fArray2[n6 + n18] = fArray[n5 + n18];
            }
            for (n18 = 1; n18 < n2; ++n18) {
                n17 = n18 * n3 * n;
                for (n16 = 0; n16 < n3; ++n16) {
                    n15 = n16 * n + n17;
                    fArray2[n6 + n15] = fArray[n5 + n15];
                }
            }
            if (n21 <= n3) {
                n25 = -n;
                for (n18 = 1; n18 < n2; ++n18) {
                    n24 = (n25 += n) - 1;
                    n17 = n18 * n3 * n;
                    for (n16 = 2; n16 < n; n16 += 2) {
                        n15 = (n24 += 2) + n19;
                        n14 = n5 + n16;
                        n13 = n6 + n16;
                        f9 = this.wtable_r[n15 - 1];
                        f8 = this.wtable_r[n15];
                        for (n12 = 0; n12 < n3; ++n12) {
                            n11 = n12 * n + n17;
                            n23 = n13 + n11;
                            n22 = n14 + n11;
                            float f10 = fArray[n22 - 1];
                            float f11 = fArray[n22];
                            fArray2[n23 - 1] = f9 * f10 + f8 * f11;
                            fArray2[n23] = f9 * f11 - f8 * f10;
                        }
                    }
                }
            } else {
                n25 = -n;
                for (n18 = 1; n18 < n2; ++n18) {
                    n25 += n;
                    n17 = n18 * n3 * n;
                    for (n16 = 0; n16 < n3; ++n16) {
                        n24 = n25 - 1;
                        n15 = n16 * n + n17;
                        for (n14 = 2; n14 < n; n14 += 2) {
                            n13 = (n24 += 2) + n19;
                            f9 = this.wtable_r[n13 - 1];
                            f8 = this.wtable_r[n13];
                            n12 = n6 + n14 + n15;
                            n11 = n5 + n14 + n15;
                            float f12 = fArray[n11 - 1];
                            float f13 = fArray[n11];
                            fArray2[n12 - 1] = f9 * f12 + f8 * f13;
                            fArray2[n12] = f9 * f13 - f8 * f12;
                        }
                    }
                }
            }
            if (n21 >= n3) {
                for (n18 = 1; n18 < n20; ++n18) {
                    n10 = n2 - n18;
                    n17 = n18 * n3 * n;
                    n16 = n10 * n3 * n;
                    for (n15 = 0; n15 < n3; ++n15) {
                        n14 = n15 * n + n17;
                        n13 = n15 * n + n16;
                        for (n12 = 2; n12 < n; n12 += 2) {
                            n11 = n5 + n12;
                            n23 = n6 + n12;
                            n22 = n11 + n14;
                            int n26 = n11 + n13;
                            int n27 = n23 + n14;
                            n9 = n23 + n13;
                            f7 = fArray2[n27 - 1];
                            f6 = fArray2[n27];
                            f5 = fArray2[n9 - 1];
                            f4 = fArray2[n9];
                            fArray[n22 - 1] = f7 + f5;
                            fArray[n22] = f6 + f4;
                            fArray[n26 - 1] = f6 - f4;
                            fArray[n26] = f5 - f7;
                        }
                    }
                }
            } else {
                for (n18 = 1; n18 < n20; ++n18) {
                    n10 = n2 - n18;
                    n17 = n18 * n3 * n;
                    n16 = n10 * n3 * n;
                    for (n15 = 2; n15 < n; n15 += 2) {
                        n14 = n5 + n15;
                        n13 = n6 + n15;
                        for (n12 = 0; n12 < n3; ++n12) {
                            n11 = n12 * n + n17;
                            n23 = n12 * n + n16;
                            n22 = n14 + n11;
                            int n28 = n14 + n23;
                            int n29 = n13 + n11;
                            n9 = n13 + n23;
                            f7 = fArray2[n29 - 1];
                            f6 = fArray2[n29];
                            f5 = fArray2[n9 - 1];
                            f4 = fArray2[n9];
                            fArray[n22 - 1] = f7 + f5;
                            fArray[n22] = f6 + f4;
                            fArray[n28 - 1] = f6 - f4;
                            fArray[n28] = f5 - f7;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(fArray2, n6, fArray, n5, n4);
        }
        for (n18 = 1; n18 < n20; ++n18) {
            n10 = n2 - n18;
            n17 = n18 * n3 * n;
            n16 = n10 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                n13 = n15 * n + n16;
                n12 = n6 + n14;
                n11 = n6 + n13;
                float f14 = fArray2[n12];
                float f15 = fArray2[n11];
                fArray[n5 + n14] = f14 + f15;
                fArray[n5 + n13] = f15 - f14;
            }
        }
        float f16 = 1.0f;
        float f17 = 0.0f;
        n18 = (n2 - 1) * n4;
        for (n17 = 1; n17 < n20; ++n17) {
            int n30 = n2 - n17;
            float f18 = f2 * f16 - f3 * f17;
            f17 = f2 * f17 + f3 * f16;
            f16 = f18;
            n16 = n17 * n4;
            n15 = n30 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                fArray2[n13 + n16] = fArray[n12] + f16 * fArray[n12 + n4];
                fArray2[n13 + n15] = f17 * fArray[n12 + n18];
            }
            float f19 = f16;
            float f20 = f17;
            float f21 = f16;
            float f22 = f17;
            for (n14 = 2; n14 < n20; ++n14) {
                n10 = n2 - n14;
                float f23 = f19 * f21 - f20 * f22;
                f22 = f19 * f22 + f20 * f21;
                f21 = f23;
                n13 = n14 * n4;
                n12 = n10 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    int n31 = n6 + n11;
                    int n32 = n5 + n11;
                    int n33 = n31 + n16;
                    fArray2[n33] = fArray2[n33] + f21 * fArray[n32 + n13];
                    int n34 = n31 + n15;
                    fArray2[n34] = fArray2[n34] + f22 * fArray[n32 + n12];
                }
            }
        }
        for (n17 = 1; n17 < n20; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n35 = n6 + n15;
                fArray2[n35] = fArray2[n35] + fArray[n5 + n15 + n16];
            }
        }
        if (n >= n3) {
            for (n17 = 0; n17 < n3; ++n17) {
                n16 = n17 * n;
                n15 = n16 * n2;
                for (n14 = 0; n14 < n; ++n14) {
                    fArray[n5 + n14 + n15] = fArray2[n6 + n14 + n16];
                }
            }
        } else {
            for (n17 = 0; n17 < n; ++n17) {
                for (n16 = 0; n16 < n3; ++n16) {
                    n15 = n16 * n;
                    fArray[n5 + n17 + n15 * n2] = fArray2[n6 + n17 + n15];
                }
            }
        }
        n17 = n2 * n;
        for (n16 = 1; n16 < n20; ++n16) {
            n10 = n2 - n16;
            n8 = 2 * n16;
            n15 = n16 * n3 * n;
            n14 = n10 * n3 * n;
            n13 = n8 * n;
            for (n12 = 0; n12 < n3; ++n12) {
                n11 = n12 * n;
                int n36 = n11 + n15;
                int n37 = n11 + n14;
                int n38 = n12 * n17;
                fArray[n5 + n - 1 + n13 - n + n38] = fArray2[n6 + n36];
                fArray[n5 + n13 + n38] = fArray2[n6 + n37];
            }
        }
        if (n == 1) {
            return;
        }
        if (n21 >= n3) {
            for (n16 = 1; n16 < n20; ++n16) {
                n10 = n2 - n16;
                n8 = 2 * n16;
                n15 = n16 * n3 * n;
                n14 = n10 * n3 * n;
                n13 = n8 * n;
                for (n12 = 0; n12 < n3; ++n12) {
                    n11 = n12 * n17;
                    int n39 = n12 * n;
                    for (int i = 2; i < n; i += 2) {
                        int n40 = n - i;
                        int n41 = n5 + i;
                        int n42 = n5 + n40;
                        n9 = n6 + i;
                        int n43 = n41 + n13 + n11;
                        int n44 = n42 + n13 - n + n11;
                        int n45 = n9 + n39 + n15;
                        int n46 = n9 + n39 + n14;
                        float f24 = fArray2[n45 - 1];
                        float f25 = fArray2[n45];
                        float f26 = fArray2[n46 - 1];
                        float f27 = fArray2[n46];
                        fArray[n43 - 1] = f24 + f26;
                        fArray[n44 - 1] = f24 - f26;
                        fArray[n43] = f25 + f27;
                        fArray[n44] = f27 - f25;
                    }
                }
            }
        } else {
            for (n16 = 1; n16 < n20; ++n16) {
                n10 = n2 - n16;
                n8 = 2 * n16;
                n15 = n16 * n3 * n;
                n14 = n10 * n3 * n;
                n13 = n8 * n;
                for (n12 = 2; n12 < n; n12 += 2) {
                    int n47 = n - n12;
                    n11 = n5 + n12;
                    int n48 = n5 + n47;
                    int n49 = n6 + n12;
                    for (int i = 0; i < n3; ++i) {
                        int n50 = i * n17;
                        n9 = i * n;
                        int n51 = n11 + n13 + n50;
                        int n52 = n48 + n13 - n + n50;
                        int n53 = n49 + n9 + n15;
                        int n54 = n49 + n9 + n14;
                        float f28 = fArray2[n53 - 1];
                        float f29 = fArray2[n53];
                        float f30 = fArray2[n54 - 1];
                        float f31 = fArray2[n54];
                        fArray[n51 - 1] = f28 + f30;
                        fArray[n52 - 1] = f28 - f30;
                        fArray[n51] = f29 + f31;
                        fArray[n52] = f31 - f29;
                    }
                }
            }
        }
    }

    void radfg(long l, long l2, long l3, long l4, D d, long l5, D d2, long l6, long l7) {
        long l8;
        long l9;
        long l10;
        long l11;
        float f;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20;
        long l21 = l7;
        float f2 = (float)Math.PI * 2 / (float)l2;
        float f3 = (float)FastMath.cos(f2);
        float f4 = (float)FastMath.sin(f2);
        long l22 = (l2 + 1L) / 2L;
        long l23 = (l - 1L) / 2L;
        if (l != 1L) {
            float f5;
            float f6;
            float f7;
            float f8;
            long l24;
            float f9;
            float f10;
            long l25;
            long l26;
            for (l20 = 0L; l20 < l4; ++l20) {
                d2.A(l6 + l20, d.C(l5 + l20));
            }
            for (l20 = 1L; l20 < l2; ++l20) {
                l19 = l20 * l3 * l;
                for (l18 = 0L; l18 < l3; ++l18) {
                    l17 = l18 * l + l19;
                    d2.A(l6 + l17, d.C(l5 + l17));
                }
            }
            if (l23 <= l3) {
                l26 = -l;
                for (l20 = 1L; l20 < l2; ++l20) {
                    l25 = (l26 += l) - 1L;
                    l19 = l20 * l3 * l;
                    for (l18 = 2L; l18 < l; l18 += 2L) {
                        l17 = (l25 += 2L) + l21;
                        l16 = l5 + l18;
                        l15 = l6 + l18;
                        f10 = this.wtable_rl.C(l17 - 1L);
                        f9 = this.wtable_rl.C(l17);
                        for (l14 = 0L; l14 < l3; ++l14) {
                            l13 = l14 * l + l19;
                            l24 = l15 + l13;
                            l12 = l16 + l13;
                            float f11 = d.C(l12 - 1L);
                            float f12 = d.C(l12);
                            d2.A(l24 - 1L, f10 * f11 + f9 * f12);
                            d2.A(l24, f10 * f12 - f9 * f11);
                        }
                    }
                }
            } else {
                l26 = -l;
                for (l20 = 1L; l20 < l2; ++l20) {
                    l26 += l;
                    l19 = l20 * l3 * l;
                    for (l18 = 0L; l18 < l3; ++l18) {
                        l25 = l26 - 1L;
                        l17 = l18 * l + l19;
                        for (l16 = 2L; l16 < l; l16 += 2L) {
                            l15 = (l25 += 2L) + l21;
                            f10 = this.wtable_rl.C(l15 - 1L);
                            f9 = this.wtable_rl.C(l15);
                            l14 = l6 + l16 + l17;
                            l13 = l5 + l16 + l17;
                            float f13 = d.C(l13 - 1L);
                            f = d.C(l13);
                            d2.A(l14 - 1L, f10 * f13 + f9 * f);
                            d2.A(l14, f10 * f - f9 * f13);
                        }
                    }
                }
            }
            if (l23 >= l3) {
                for (l20 = 1L; l20 < l22; ++l20) {
                    l11 = l2 - l20;
                    l19 = l20 * l3 * l;
                    l18 = l11 * l3 * l;
                    for (l17 = 0L; l17 < l3; ++l17) {
                        l16 = l17 * l + l19;
                        l15 = l17 * l + l18;
                        for (l14 = 2L; l14 < l; l14 += 2L) {
                            l13 = l5 + l14;
                            l24 = l6 + l14;
                            l12 = l13 + l16;
                            long l27 = l13 + l15;
                            l10 = l24 + l16;
                            l9 = l24 + l15;
                            f8 = d2.C(l10 - 1L);
                            f7 = d2.C(l10);
                            f6 = d2.C(l9 - 1L);
                            f5 = d2.C(l9);
                            d.A(l12 - 1L, f8 + f6);
                            d.A(l12, f7 + f5);
                            d.A(l27 - 1L, f7 - f5);
                            d.A(l27, f6 - f8);
                        }
                    }
                }
            } else {
                for (l20 = 1L; l20 < l22; ++l20) {
                    l11 = l2 - l20;
                    l19 = l20 * l3 * l;
                    l18 = l11 * l3 * l;
                    for (l17 = 2L; l17 < l; l17 += 2L) {
                        l16 = l5 + l17;
                        l15 = l6 + l17;
                        for (l14 = 0L; l14 < l3; ++l14) {
                            l13 = l14 * l + l19;
                            l24 = l14 * l + l18;
                            l12 = l16 + l13;
                            long l28 = l16 + l24;
                            l10 = l15 + l13;
                            l9 = l15 + l24;
                            f8 = d2.C(l10 - 1L);
                            f7 = d2.C(l10);
                            f6 = d2.C(l9 - 1L);
                            f5 = d2.C(l9);
                            d.A(l12 - 1L, f8 + f6);
                            d.A(l12, f7 + f5);
                            d.A(l28 - 1L, f7 - f5);
                            d.A(l28, f6 - f8);
                        }
                    }
                }
            }
        } else {
            C.A(d2, l6, d, l5, l4);
        }
        for (l20 = 1L; l20 < l22; ++l20) {
            l11 = l2 - l20;
            l19 = l20 * l3 * l;
            l18 = l11 * l3 * l;
            for (l17 = 0L; l17 < l3; ++l17) {
                l16 = l17 * l + l19;
                l15 = l17 * l + l18;
                l14 = l6 + l16;
                l13 = l6 + l15;
                float f14 = d2.C(l14);
                f = d2.C(l13);
                d.A(l5 + l16, f14 + f);
                d.A(l5 + l15, f - f14);
            }
        }
        float f15 = 1.0f;
        float f16 = 0.0f;
        l20 = (l2 - 1L) * l4;
        for (l19 = 1L; l19 < l22; ++l19) {
            long l29 = l2 - l19;
            float f17 = f3 * f15 - f4 * f16;
            f16 = f3 * f16 + f4 * f15;
            f15 = f17;
            l18 = l19 * l4;
            l17 = l29 * l4;
            for (l16 = 0L; l16 < l4; ++l16) {
                l15 = l6 + l16;
                l14 = l5 + l16;
                d2.A(l15 + l18, d.C(l14) + f15 * d.C(l14 + l4));
                d2.A(l15 + l17, f16 * d.C(l14 + l20));
            }
            float f18 = f15;
            float f19 = f16;
            float f20 = f15;
            float f21 = f16;
            for (l16 = 2L; l16 < l22; ++l16) {
                l11 = l2 - l16;
                float f22 = f18 * f20 - f19 * f21;
                f21 = f18 * f21 + f19 * f20;
                f20 = f22;
                l15 = l16 * l4;
                l14 = l11 * l4;
                for (l13 = 0L; l13 < l4; ++l13) {
                    long l30 = l6 + l13;
                    l12 = l5 + l13;
                    d2.A(l30 + l18, d2.C(l30 + l18) + f20 * d.C(l12 + l15));
                    d2.A(l30 + l17, d2.C(l30 + l17) + f21 * d.C(l12 + l14));
                }
            }
        }
        for (l19 = 1L; l19 < l22; ++l19) {
            l18 = l19 * l4;
            for (l17 = 0L; l17 < l4; ++l17) {
                d2.A(l6 + l17, d2.C(l6 + l17) + d.C(l5 + l17 + l18));
            }
        }
        if (l >= l3) {
            for (l19 = 0L; l19 < l3; ++l19) {
                l18 = l19 * l;
                l17 = l18 * l2;
                for (l16 = 0L; l16 < l; ++l16) {
                    d.A(l5 + l16 + l17, d2.C(l6 + l16 + l18));
                }
            }
        } else {
            for (l19 = 0L; l19 < l; ++l19) {
                for (l18 = 0L; l18 < l3; ++l18) {
                    l17 = l18 * l;
                    d.A(l5 + l19 + l17 * l2, d2.C(l6 + l19 + l17));
                }
            }
        }
        l19 = l2 * l;
        for (l18 = 1L; l18 < l22; ++l18) {
            l11 = l2 - l18;
            l8 = 2L * l18;
            l17 = l18 * l3 * l;
            l16 = l11 * l3 * l;
            l15 = l8 * l;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                long l31 = l13 + l17;
                l12 = l13 + l16;
                long l32 = l14 * l19;
                d.A(l5 + l - 1L + l15 - l + l32, d2.C(l6 + l31));
                d.A(l5 + l15 + l32, d2.C(l6 + l12));
            }
        }
        if (l == 1L) {
            return;
        }
        if (l23 >= l3) {
            for (l18 = 1L; l18 < l22; ++l18) {
                l11 = l2 - l18;
                l8 = 2L * l18;
                l17 = l18 * l3 * l;
                l16 = l11 * l3 * l;
                l15 = l8 * l;
                for (l14 = 0L; l14 < l3; ++l14) {
                    l13 = l14 * l19;
                    long l33 = l14 * l;
                    for (l12 = 2L; l12 < l; l12 += 2L) {
                        long l34 = l - l12;
                        long l35 = l5 + l12;
                        l10 = l5 + l34;
                        l9 = l6 + l12;
                        long l36 = l35 + l15 + l13;
                        long l37 = l10 + l15 - l + l13;
                        long l38 = l9 + l33 + l17;
                        long l39 = l9 + l33 + l16;
                        float f23 = d2.C(l38 - 1L);
                        float f24 = d2.C(l38);
                        float f25 = d2.C(l39 - 1L);
                        float f26 = d2.C(l39);
                        d.A(l36 - 1L, f23 + f25);
                        d.A(l37 - 1L, f23 - f25);
                        d.A(l36, f24 + f26);
                        d.A(l37, f26 - f24);
                    }
                }
            }
        } else {
            for (l18 = 1L; l18 < l22; ++l18) {
                l11 = l2 - l18;
                l8 = 2L * l18;
                l17 = l18 * l3 * l;
                l16 = l11 * l3 * l;
                l15 = l8 * l;
                for (l14 = 2L; l14 < l; l14 += 2L) {
                    long l40 = l - l14;
                    l13 = l5 + l14;
                    long l41 = l5 + l40;
                    l12 = l6 + l14;
                    for (long i = 0L; i < l3; ++i) {
                        l10 = i * l19;
                        l9 = i * l;
                        long l42 = l13 + l15 + l10;
                        long l43 = l41 + l15 - l + l10;
                        long l44 = l12 + l9 + l17;
                        long l45 = l12 + l9 + l16;
                        float f27 = d2.C(l44 - 1L);
                        float f28 = d2.C(l44);
                        float f29 = d2.C(l45 - 1L);
                        float f30 = d2.C(l45);
                        d.A(l42 - 1L, f27 + f29);
                        d.A(l43 - 1L, f27 - f29);
                        d.A(l42, f28 + f30);
                        d.A(l43, f30 - f28);
                    }
                }
            }
        }
    }

    void radbg(int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7) {
        float f;
        int n8;
        int n9;
        float f2;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = n7;
        float f3 = (float)Math.PI * 2 / (float)n2;
        float f4 = (float)FastMath.cos(f3);
        float f5 = (float)FastMath.sin(f3);
        int n22 = (n - 1) / 2;
        int n23 = (n2 + 1) / 2;
        int n24 = n2 * n;
        if (n >= n3) {
            for (n20 = 0; n20 < n3; ++n20) {
                n19 = n20 * n;
                n18 = n20 * n24;
                for (n17 = 0; n17 < n; ++n17) {
                    fArray2[n6 + n17 + n19] = fArray[n5 + n17 + n18];
                }
            }
        } else {
            for (n20 = 0; n20 < n; ++n20) {
                n19 = n6 + n20;
                n18 = n5 + n20;
                for (n17 = 0; n17 < n3; ++n17) {
                    fArray2[n19 + n17 * n] = fArray[n18 + n17 * n24];
                }
            }
        }
        n20 = n5 + n - 1;
        for (n19 = 1; n19 < n23; ++n19) {
            n16 = n2 - n19;
            int n25 = 2 * n19;
            n18 = n19 * n3 * n;
            n17 = n16 * n3 * n;
            n15 = n25 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n13 * n2;
                n11 = n20 + n15 + n12 - n;
                n10 = n5 + n15 + n12;
                float f6 = fArray[n11];
                f2 = fArray[n10];
                fArray2[n6 + n13 + n18] = f6 + f6;
                fArray2[n6 + n13 + n17] = f2 + f2;
            }
        }
        if (n != 1) {
            float f7;
            float f8;
            float f9;
            int n26;
            int n27;
            int n28;
            int n29;
            if (n22 >= n3) {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 0; n14 < n3; ++n14) {
                        n13 = n14 * n + n18;
                        n12 = n14 * n + n17;
                        n11 = n14 * n2 * n + n15;
                        for (n10 = 2; n10 < n; n10 += 2) {
                            n29 = n - n10;
                            int n30 = n6 + n10;
                            int n31 = n5 + n29;
                            n9 = n5 + n10;
                            n8 = n30 + n13;
                            n28 = n30 + n12;
                            n27 = n9 + n11;
                            n26 = n31 + n11 - n;
                            f = fArray[n27 - 1];
                            f9 = fArray[n27];
                            f8 = fArray[n26 - 1];
                            f7 = fArray[n26];
                            fArray2[n8 - 1] = f + f8;
                            fArray2[n28 - 1] = f - f8;
                            fArray2[n8] = f9 - f7;
                            fArray2[n28] = f9 + f7;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 2; n14 < n; n14 += 2) {
                        n29 = n - n14;
                        n13 = n6 + n14;
                        n12 = n5 + n29;
                        n11 = n5 + n14;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n32 = n10 * n + n18;
                            int n33 = n10 * n + n17;
                            n9 = n10 * n2 * n + n15;
                            n8 = n13 + n32;
                            n28 = n13 + n33;
                            n27 = n11 + n9;
                            n26 = n12 + n9 - n;
                            f = fArray[n27 - 1];
                            f9 = fArray[n27];
                            f8 = fArray[n26 - 1];
                            f7 = fArray[n26];
                            fArray2[n8 - 1] = f + f8;
                            fArray2[n28 - 1] = f - f8;
                            fArray2[n8] = f9 - f7;
                            fArray2[n28] = f9 + f7;
                        }
                    }
                }
            }
        }
        float f10 = 1.0f;
        float f11 = 0.0f;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n23; ++n18) {
            int n34 = n2 - n18;
            float f12 = f4 * f10 - f5 * f11;
            f11 = f4 * f11 + f5 * f10;
            f10 = f12;
            n17 = n18 * n4;
            n15 = n34 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                fArray[n13 + n17] = fArray2[n12] + f10 * fArray2[n12 + n4];
                fArray[n13 + n15] = f11 * fArray2[n12 + n19];
            }
            float f13 = f10;
            float f14 = f11;
            float f15 = f10;
            float f16 = f11;
            for (n14 = 2; n14 < n23; ++n14) {
                n16 = n2 - n14;
                float f17 = f13 * f15 - f14 * f16;
                f16 = f13 * f16 + f14 * f15;
                f15 = f17;
                n13 = n14 * n4;
                n12 = n16 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    n10 = n5 + n11;
                    int n35 = n6 + n11;
                    int n36 = n10 + n17;
                    fArray[n36] = fArray[n36] + f15 * fArray2[n35 + n13];
                    int n37 = n10 + n15;
                    fArray[n37] = fArray[n37] + f16 * fArray2[n35 + n12];
                }
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n17 = n18 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n38 = n14 = n6 + n15;
                fArray2[n38] = fArray2[n38] + fArray2[n14 + n17];
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n16 = n2 - n18;
            n17 = n18 * n3 * n;
            n15 = n16 * n3 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13;
                n11 = n5 + n13 + n17;
                n10 = n5 + n13 + n15;
                float f18 = fArray[n11];
                f2 = fArray[n10];
                fArray2[n12 + n17] = f18 - f2;
                fArray2[n12 + n15] = f18 + f2;
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    n13 = n14 * n;
                    for (n12 = 2; n12 < n; n12 += 2) {
                        n11 = n6 + n12;
                        n10 = n5 + n12;
                        int n39 = n11 + n13 + n17;
                        int n40 = n11 + n13 + n15;
                        n9 = n10 + n13 + n17;
                        n8 = n10 + n13 + n15;
                        float f19 = fArray[n9 - 1];
                        float f20 = fArray[n9];
                        float f21 = fArray[n8 - 1];
                        f = fArray[n8];
                        fArray2[n39 - 1] = f19 - f;
                        fArray2[n40 - 1] = f19 + f;
                        fArray2[n39] = f20 + f21;
                        fArray2[n40] = f20 - f21;
                    }
                }
            }
        } else {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 2; n14 < n; n14 += 2) {
                    n13 = n6 + n14;
                    n12 = n5 + n14;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n;
                        int n41 = n13 + n10 + n17;
                        int n42 = n13 + n10 + n15;
                        n9 = n12 + n10 + n17;
                        n8 = n12 + n10 + n15;
                        float f22 = fArray[n9 - 1];
                        float f23 = fArray[n9];
                        float f24 = fArray[n8 - 1];
                        f = fArray[n8];
                        fArray2[n41 - 1] = f22 - f;
                        fArray2[n42 - 1] = f22 + f;
                        fArray2[n41] = f23 + f24;
                        fArray2[n42] = f23 - f24;
                    }
                }
            }
        }
        System.arraycopy(fArray2, n6, fArray, n5, n4);
        for (n18 = 1; n18 < n2; ++n18) {
            n17 = n18 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                fArray[n5 + n14] = fArray2[n6 + n14];
            }
        }
        if (n22 <= n3) {
            int n43 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                int n44 = (n43 += n) - 1;
                n17 = n18 * n3 * n;
                for (n15 = 2; n15 < n; n15 += 2) {
                    n14 = (n44 += 2) + n21;
                    float f25 = this.wtable_r[n14 - 1];
                    float f26 = this.wtable_r[n14];
                    n13 = n5 + n15;
                    n12 = n6 + n15;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n + n17;
                        int n45 = n13 + n10;
                        int n46 = n12 + n10;
                        float f27 = fArray2[n46 - 1];
                        float f28 = fArray2[n46];
                        fArray[n45 - 1] = f25 * f27 - f26 * f28;
                        fArray[n45] = f25 * f28 + f26 * f27;
                    }
                }
            }
        } else {
            int n47 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                n47 += n;
                n17 = n18 * n3 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    int n48 = n47 - 1;
                    n14 = n15 * n + n17;
                    for (n13 = 2; n13 < n; n13 += 2) {
                        n12 = (n48 += 2) + n21;
                        float f29 = this.wtable_r[n12 - 1];
                        float f30 = this.wtable_r[n12];
                        n11 = n5 + n13;
                        n10 = n6 + n13;
                        int n49 = n11 + n14;
                        int n50 = n10 + n14;
                        float f31 = fArray2[n50 - 1];
                        float f32 = fArray2[n50];
                        fArray[n49 - 1] = f29 * f31 - f30 * f32;
                        fArray[n49] = f29 * f32 + f30 * f31;
                    }
                }
            }
        }
    }

    void radbg(long l, long l2, long l3, long l4, D d, long l5, D d2, long l6, long l7) {
        float f;
        float f2;
        long l8;
        long l9;
        long l10;
        float f3;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20;
        long l21;
        long l22 = l7;
        float f4 = (float)Math.PI * 2 / (float)l2;
        float f5 = (float)FastMath.cos(f4);
        float f6 = (float)FastMath.sin(f4);
        long l23 = (l - 1L) / 2L;
        long l24 = (l2 + 1L) / 2L;
        long l25 = l2 * l;
        if (l >= l3) {
            for (l21 = 0L; l21 < l3; ++l21) {
                l20 = l21 * l;
                l19 = l21 * l25;
                for (l18 = 0L; l18 < l; ++l18) {
                    d2.A(l6 + l18 + l20, d.C(l5 + l18 + l19));
                }
            }
        } else {
            for (l21 = 0L; l21 < l; ++l21) {
                l20 = l6 + l21;
                l19 = l5 + l21;
                for (l18 = 0L; l18 < l3; ++l18) {
                    d2.A(l20 + l18 * l, d.C(l19 + l18 * l25));
                }
            }
        }
        l21 = l5 + l - 1L;
        for (l20 = 1L; l20 < l24; ++l20) {
            l17 = l2 - l20;
            long l26 = 2L * l20;
            l19 = l20 * l3 * l;
            l18 = l17 * l3 * l;
            l16 = l26 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l;
                l13 = l14 * l2;
                l12 = l21 + l16 + l13 - l;
                l11 = l5 + l16 + l13;
                float f7 = d.C(l12);
                f3 = d.C(l11);
                d2.A(l6 + l14 + l19, f7 + f7);
                d2.A(l6 + l14 + l18, f3 + f3);
            }
        }
        if (l != 1L) {
            float f8;
            float f9;
            float f10;
            float f11;
            long l27;
            long l28;
            long l29;
            long l30;
            if (l23 >= l3) {
                for (l20 = 1L; l20 < l24; ++l20) {
                    l17 = l2 - l20;
                    l19 = l20 * l3 * l;
                    l18 = l17 * l3 * l;
                    l16 = 2L * l20 * l;
                    for (l15 = 0L; l15 < l3; ++l15) {
                        l14 = l15 * l + l19;
                        l13 = l15 * l + l18;
                        l12 = l15 * l2 * l + l16;
                        for (l11 = 2L; l11 < l; l11 += 2L) {
                            l30 = l - l11;
                            long l31 = l6 + l11;
                            l10 = l5 + l30;
                            l9 = l5 + l11;
                            l8 = l31 + l14;
                            l29 = l31 + l13;
                            l28 = l9 + l12;
                            l27 = l10 + l12 - l;
                            f11 = d.C(l28 - 1L);
                            f10 = d.C(l28);
                            f9 = d.C(l27 - 1L);
                            f8 = d.C(l27);
                            d2.A(l8 - 1L, f11 + f9);
                            d2.A(l29 - 1L, f11 - f9);
                            d2.A(l8, f10 - f8);
                            d2.A(l29, f10 + f8);
                        }
                    }
                }
            } else {
                for (l20 = 1L; l20 < l24; ++l20) {
                    l17 = l2 - l20;
                    l19 = l20 * l3 * l;
                    l18 = l17 * l3 * l;
                    l16 = 2L * l20 * l;
                    for (l15 = 2L; l15 < l; l15 += 2L) {
                        l30 = l - l15;
                        l14 = l6 + l15;
                        l13 = l5 + l30;
                        l12 = l5 + l15;
                        for (l11 = 0L; l11 < l3; ++l11) {
                            long l32 = l11 * l + l19;
                            l10 = l11 * l + l18;
                            l9 = l11 * l2 * l + l16;
                            l8 = l14 + l32;
                            l29 = l14 + l10;
                            l28 = l12 + l9;
                            l27 = l13 + l9 - l;
                            f11 = d.C(l28 - 1L);
                            f10 = d.C(l28);
                            f9 = d.C(l27 - 1L);
                            f8 = d.C(l27);
                            d2.A(l8 - 1L, f11 + f9);
                            d2.A(l29 - 1L, f11 - f9);
                            d2.A(l8, f10 - f8);
                            d2.A(l29, f10 + f8);
                        }
                    }
                }
            }
        }
        float f12 = 1.0f;
        float f13 = 0.0f;
        l20 = (l2 - 1L) * l4;
        for (l19 = 1L; l19 < l24; ++l19) {
            long l33 = l2 - l19;
            float f14 = f5 * f12 - f6 * f13;
            f13 = f5 * f13 + f6 * f12;
            f12 = f14;
            l18 = l19 * l4;
            l16 = l33 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                l14 = l5 + l15;
                l13 = l6 + l15;
                d.A(l14 + l18, d2.C(l13) + f12 * d2.C(l13 + l4));
                d.A(l14 + l16, f13 * d2.C(l13 + l20));
            }
            float f15 = f12;
            float f16 = f13;
            float f17 = f12;
            float f18 = f13;
            for (l15 = 2L; l15 < l24; ++l15) {
                l17 = l2 - l15;
                float f19 = f15 * f17 - f16 * f18;
                f18 = f15 * f18 + f16 * f17;
                f17 = f19;
                l14 = l15 * l4;
                l13 = l17 * l4;
                for (l12 = 0L; l12 < l4; ++l12) {
                    l11 = l5 + l12;
                    long l34 = l6 + l12;
                    d.A(l11 + l18, d.C(l11 + l18) + f17 * d2.C(l34 + l14));
                    d.A(l11 + l16, d.C(l11 + l16) + f18 * d2.C(l34 + l13));
                }
            }
        }
        for (l19 = 1L; l19 < l24; ++l19) {
            l18 = l19 * l4;
            for (l16 = 0L; l16 < l4; ++l16) {
                l15 = l6 + l16;
                d2.A(l15, d2.C(l15) + d2.C(l15 + l18));
            }
        }
        for (l19 = 1L; l19 < l24; ++l19) {
            l17 = l2 - l19;
            l18 = l19 * l3 * l;
            l16 = l17 * l3 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l;
                l13 = l6 + l14;
                l12 = l5 + l14 + l18;
                l11 = l5 + l14 + l16;
                float f20 = d.C(l12);
                f3 = d.C(l11);
                d2.A(l13 + l18, f20 - f3);
                d2.A(l13 + l16, f20 + f3);
            }
        }
        if (l == 1L) {
            return;
        }
        if (l23 >= l3) {
            for (l19 = 1L; l19 < l24; ++l19) {
                l17 = l2 - l19;
                l18 = l19 * l3 * l;
                l16 = l17 * l3 * l;
                for (l15 = 0L; l15 < l3; ++l15) {
                    l14 = l15 * l;
                    for (l13 = 2L; l13 < l; l13 += 2L) {
                        l12 = l6 + l13;
                        l11 = l5 + l13;
                        long l35 = l12 + l14 + l18;
                        l10 = l12 + l14 + l16;
                        l9 = l11 + l14 + l18;
                        l8 = l11 + l14 + l16;
                        float f21 = d.C(l9 - 1L);
                        f2 = d.C(l9);
                        float f22 = d.C(l8 - 1L);
                        f = d.C(l8);
                        d2.A(l35 - 1L, f21 - f);
                        d2.A(l10 - 1L, f21 + f);
                        d2.A(l35, f2 + f22);
                        d2.A(l10, f2 - f22);
                    }
                }
            }
        } else {
            for (l19 = 1L; l19 < l24; ++l19) {
                l17 = l2 - l19;
                l18 = l19 * l3 * l;
                l16 = l17 * l3 * l;
                for (l15 = 2L; l15 < l; l15 += 2L) {
                    l14 = l6 + l15;
                    l13 = l5 + l15;
                    for (l12 = 0L; l12 < l3; ++l12) {
                        l11 = l12 * l;
                        long l36 = l14 + l11 + l18;
                        l10 = l14 + l11 + l16;
                        l9 = l13 + l11 + l18;
                        l8 = l13 + l11 + l16;
                        float f23 = d.C(l9 - 1L);
                        f2 = d.C(l9);
                        float f24 = d.C(l8 - 1L);
                        f = d.C(l8);
                        d2.A(l36 - 1L, f23 - f);
                        d2.A(l10 - 1L, f23 + f);
                        d2.A(l36, f2 + f24);
                        d2.A(l10, f2 - f24);
                    }
                }
            }
        }
        C.A(d2, l6, d, l5, l4);
        for (l19 = 1L; l19 < l2; ++l19) {
            l18 = l19 * l3 * l;
            for (l16 = 0L; l16 < l3; ++l16) {
                l15 = l16 * l + l18;
                d.A(l5 + l15, d2.C(l6 + l15));
            }
        }
        if (l23 <= l3) {
            long l37 = -l;
            for (l19 = 1L; l19 < l2; ++l19) {
                long l38 = (l37 += l) - 1L;
                l18 = l19 * l3 * l;
                for (l16 = 2L; l16 < l; l16 += 2L) {
                    l15 = (l38 += 2L) + l22;
                    float f25 = this.wtable_rl.C(l15 - 1L);
                    float f26 = this.wtable_rl.C(l15);
                    l14 = l5 + l16;
                    l13 = l6 + l16;
                    for (l12 = 0L; l12 < l3; ++l12) {
                        l11 = l12 * l + l18;
                        long l39 = l14 + l11;
                        l10 = l13 + l11;
                        float f27 = d2.C(l10 - 1L);
                        float f28 = d2.C(l10);
                        d.A(l39 - 1L, f25 * f27 - f26 * f28);
                        d.A(l39, f25 * f28 + f26 * f27);
                    }
                }
            }
        } else {
            long l40 = -l;
            for (l19 = 1L; l19 < l2; ++l19) {
                l40 += l;
                l18 = l19 * l3 * l;
                for (l16 = 0L; l16 < l3; ++l16) {
                    long l41 = l40 - 1L;
                    l15 = l16 * l + l18;
                    for (l14 = 2L; l14 < l; l14 += 2L) {
                        l13 = (l41 += 2L) + l22;
                        float f29 = this.wtable_rl.C(l13 - 1L);
                        float f30 = this.wtable_rl.C(l13);
                        l12 = l5 + l14;
                        l11 = l6 + l14;
                        long l42 = l12 + l15;
                        l10 = l11 + l15;
                        float f31 = d2.C(l10 - 1L);
                        float f32 = d2.C(l10);
                        d.A(l42 - 1L, f29 * f31 - f30 * f32);
                        d.A(l42, f29 * f32 + f30 * f31);
                    }
                }
            }
        }
    }

    void cfftf(float[] fArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = 2 * this.n;
        float[] fArray2 = new float[n3];
        int n4 = n3;
        int n5 = 4 * this.n;
        nArray[0] = 0;
        int n6 = (int)this.wtable[1 + n5];
        int n7 = 0;
        int n8 = 1;
        int n9 = n4;
        for (int i = 2; i <= n6 + 1; ++i) {
            int n10 = (int)this.wtable[i + n5];
            int n11 = n10 * n8;
            int n12 = this.n / n11;
            int n13 = n12 + n12;
            int n14 = n13 * n8;
            switch (n10) {
                case 4: {
                    if (n7 == 0) {
                        this.passf4(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf4(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 2: {
                    if (n7 == 0) {
                        this.passf2(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf2(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 3: {
                    if (n7 == 0) {
                        this.passf3(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf3(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 5: {
                    if (n7 == 0) {
                        this.passf5(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf5(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                default: {
                    if (n7 == 0) {
                        this.passfg(nArray, n13, n10, n8, n14, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passfg(nArray, n13, n10, n8, n14, fArray2, 0, fArray, n, n9, n2);
                    }
                    if (nArray[0] == 0) break;
                    n7 = 1 - n7;
                }
            }
            n8 = n11;
            n9 += (n10 - 1) * n13;
        }
        if (n7 == 0) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, n3);
    }

    void cfftf(D d, long l, int n) {
        int[] nArray = new int[1];
        long l2 = 2L * this.nl;
        D d2 = new D(l2);
        long l3 = l2;
        long l4 = 4L * this.nl;
        nArray[0] = 0;
        long l5 = (long)this.wtablel.C(1L + l4);
        long l6 = 0L;
        long l7 = 1L;
        long l8 = l3;
        for (long i = 2L; i <= l5 + 1L; ++i) {
            int n2 = (int)this.wtablel.C(i + l4);
            long l9 = (long)n2 * l7;
            long l10 = this.nl / l9;
            long l11 = l10 + l10;
            long l12 = l11 * l7;
            switch (n2) {
                case 4: {
                    if (l6 == 0L) {
                        this.passf4(l11, l7, d, l, d2, 0L, l8, n);
                    } else {
                        this.passf4(l11, l7, d2, 0L, d, l, l8, n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 2: {
                    if (l6 == 0L) {
                        this.passf2(l11, l7, d, l, d2, 0L, l8, (long)n);
                    } else {
                        this.passf2(l11, l7, d2, 0L, d, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 3: {
                    if (l6 == 0L) {
                        this.passf3(l11, l7, d, l, d2, 0L, l8, (long)n);
                    } else {
                        this.passf3(l11, l7, d2, 0L, d, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                case 5: {
                    if (l6 == 0L) {
                        this.passf5(l11, l7, d, l, d2, 0L, l8, (long)n);
                    } else {
                        this.passf5(l11, l7, d2, 0L, d, l, l8, (long)n);
                    }
                    l6 = 1L - l6;
                    break;
                }
                default: {
                    if (l6 == 0L) {
                        this.passfg(nArray, l11, (long)n2, l7, l12, d, l, d2, 0L, l8, (long)n);
                    } else {
                        this.passfg(nArray, l11, (long)n2, l7, l12, d2, 0L, d, l, l8, (long)n);
                    }
                    if (nArray[0] == 0) break;
                    l6 = 1L - l6;
                }
            }
            l7 = l9;
            l8 += (long)(n2 - 1) * l11;
        }
        if (l6 == 0L) {
            return;
        }
        C.A(d2, 0L, d, l, l2);
    }

    void passf2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n * n2;
        if (n <= 2) {
            for (int i = 0; i < n2; ++i) {
                int n9 = i * n;
                int n10 = n3 + 2 * n9;
                int n11 = n10 + n;
                float f = fArray[n10];
                float f2 = fArray[n10 + 1];
                float f3 = fArray[n11];
                float f4 = fArray[n11 + 1];
                int n12 = n4 + n9;
                int n13 = n12 + n8;
                fArray2[n12] = f + f3;
                fArray2[n12 + 1] = f2 + f4;
                fArray2[n13] = f - f3;
                fArray2[n13 + 1] = f2 - f4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n - 1; j += 2) {
                    int n14 = i * n;
                    int n15 = n3 + j + 2 * n14;
                    int n16 = n15 + n;
                    float f = fArray[n15];
                    float f5 = fArray[n15 + 1];
                    float f6 = fArray[n16];
                    float f7 = fArray[n16 + 1];
                    int n17 = j + n7;
                    float f8 = this.wtable[n17];
                    float f9 = (float)n6 * this.wtable[n17 + 1];
                    float f10 = f - f6;
                    float f11 = f5 - f7;
                    int n18 = n4 + j + n14;
                    int n19 = n18 + n8;
                    fArray2[n18] = f + f6;
                    fArray2[n18 + 1] = f5 + f7;
                    fArray2[n19] = f8 * f10 - f9 * f11;
                    fArray2[n19 + 1] = f8 * f11 + f9 * f10;
                }
            }
        }
    }

    void passf2(long l, long l2, D d, long l3, D d2, long l4, long l5, long l6) {
        long l7 = l5;
        long l8 = l * l2;
        if (l <= 2L) {
            for (long i = 0L; i < l2; ++i) {
                long l9 = i * l;
                long l10 = l3 + 2L * l9;
                long l11 = l10 + l;
                float f = d.C(l10);
                float f2 = d.C(l10 + 1L);
                float f3 = d.C(l11);
                float f4 = d.C(l11 + 1L);
                long l12 = l4 + l9;
                long l13 = l12 + l8;
                d2.A(l12, f + f3);
                d2.A(l12 + 1L, f2 + f4);
                d2.A(l13, f - f3);
                d2.A(l13 + 1L, f2 - f4);
            }
        } else {
            for (long i = 0L; i < l2; ++i) {
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l14 = i * l;
                    long l15 = l3 + j + 2L * l14;
                    long l16 = l15 + l;
                    float f = d.C(l15);
                    float f5 = d.C(l15 + 1L);
                    float f6 = d.C(l16);
                    float f7 = d.C(l16 + 1L);
                    long l17 = j + l7;
                    float f8 = this.wtablel.C(l17);
                    float f9 = (float)l6 * this.wtablel.C(l17 + 1L);
                    float f10 = f - f6;
                    float f11 = f5 - f7;
                    long l18 = l4 + j + l14;
                    long l19 = l18 + l8;
                    d2.A(l18, f + f6);
                    d2.A(l18 + 1L, f5 + f7);
                    d2.A(l19, f8 * f10 - f9 * f11);
                    d2.A(l19 + 1L, f8 * f11 + f9 * f10);
                }
            }
        }
    }

    void passf3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        float f = -0.5f;
        float f2 = 0.8660254f;
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n10 = n3 + (3 * i - 2) * n;
                int n11 = n10 + n;
                int n12 = n10 - n;
                float f3 = fArray[n10];
                float f4 = fArray[n10 + 1];
                float f5 = fArray[n11];
                float f6 = fArray[n11 + 1];
                float f7 = fArray[n12];
                float f8 = fArray[n12 + 1];
                float f9 = f3 + f5;
                float f10 = f7 + -0.5f * f9;
                float f11 = f4 + f6;
                float f12 = f8 + -0.5f * f11;
                float f13 = (float)n6 * 0.8660254f * (f3 - f5);
                float f14 = (float)n6 * 0.8660254f * (f4 - f6);
                int n13 = n4 + (i - 1) * n;
                int n14 = n13 + n9;
                int n15 = n14 + n9;
                fArray2[n13] = fArray[n12] + f9;
                fArray2[n13 + 1] = f8 + f11;
                fArray2[n14] = f10 - f14;
                fArray2[n14 + 1] = f12 + f13;
                fArray2[n15] = f10 + f14;
                fArray2[n15 + 1] = f12 - f13;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n16 = n3 + (3 * i - 2) * n;
                int n17 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n18 = j + n16;
                    int n19 = n18 + n;
                    int n20 = n18 - n;
                    float f15 = fArray[n18];
                    float f16 = fArray[n18 + 1];
                    float f17 = fArray[n19];
                    float f18 = fArray[n19 + 1];
                    float f19 = fArray[n20];
                    float f20 = fArray[n20 + 1];
                    float f21 = f15 + f17;
                    float f22 = f19 + -0.5f * f21;
                    float f23 = f16 + f18;
                    float f24 = f20 + -0.5f * f23;
                    float f25 = (float)n6 * 0.8660254f * (f15 - f17);
                    float f26 = (float)n6 * 0.8660254f * (f16 - f18);
                    float f27 = f22 - f26;
                    float f28 = f22 + f26;
                    float f29 = f24 + f25;
                    float f30 = f24 - f25;
                    int n21 = j + n7;
                    int n22 = j + n8;
                    float f31 = this.wtable[n21];
                    float f32 = (float)n6 * this.wtable[n21 + 1];
                    float f33 = this.wtable[n22];
                    float f34 = (float)n6 * this.wtable[n22 + 1];
                    int n23 = j + n17;
                    int n24 = n23 + n9;
                    int n25 = n24 + n9;
                    fArray2[n23] = f19 + f21;
                    fArray2[n23 + 1] = f20 + f23;
                    fArray2[n24] = f31 * f27 - f32 * f29;
                    fArray2[n24 + 1] = f31 * f29 + f32 * f27;
                    fArray2[n25] = f33 * f28 - f34 * f30;
                    fArray2[n25 + 1] = f33 * f30 + f34 * f28;
                }
            }
        }
    }

    void passf3(long l, long l2, D d, long l3, D d2, long l4, long l5, long l6) {
        float f = -0.5f;
        float f2 = 0.8660254f;
        long l7 = l5;
        long l8 = l7 + l;
        long l9 = l2 * l;
        if (l == 2L) {
            for (long i = 1L; i <= l2; ++i) {
                long l10 = l3 + (3L * i - 2L) * l;
                long l11 = l10 + l;
                long l12 = l10 - l;
                float f3 = d.C(l10);
                float f4 = d.C(l10 + 1L);
                float f5 = d.C(l11);
                float f6 = d.C(l11 + 1L);
                float f7 = d.C(l12);
                float f8 = d.C(l12 + 1L);
                float f9 = f3 + f5;
                float f10 = f7 + -0.5f * f9;
                float f11 = f4 + f6;
                float f12 = f8 + -0.5f * f11;
                float f13 = (float)l6 * 0.8660254f * (f3 - f5);
                float f14 = (float)l6 * 0.8660254f * (f4 - f6);
                long l13 = l4 + (i - 1L) * l;
                long l14 = l13 + l9;
                long l15 = l14 + l9;
                d2.A(l13, d.C(l12) + f9);
                d2.A(l13 + 1L, f8 + f11);
                d2.A(l14, f10 - f14);
                d2.A(l14 + 1L, f12 + f13);
                d2.A(l15, f10 + f14);
                d2.A(l15 + 1L, f12 - f13);
            }
        } else {
            for (long i = 1L; i <= l2; ++i) {
                long l16 = l3 + (3L * i - 2L) * l;
                long l17 = l4 + (i - 1L) * l;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l18 = j + l16;
                    long l19 = l18 + l;
                    long l20 = l18 - l;
                    float f15 = d.C(l18);
                    float f16 = d.C(l18 + 1L);
                    float f17 = d.C(l19);
                    float f18 = d.C(l19 + 1L);
                    float f19 = d.C(l20);
                    float f20 = d.C(l20 + 1L);
                    float f21 = f15 + f17;
                    float f22 = f19 + -0.5f * f21;
                    float f23 = f16 + f18;
                    float f24 = f20 + -0.5f * f23;
                    float f25 = (float)l6 * 0.8660254f * (f15 - f17);
                    float f26 = (float)l6 * 0.8660254f * (f16 - f18);
                    float f27 = f22 - f26;
                    float f28 = f22 + f26;
                    float f29 = f24 + f25;
                    float f30 = f24 - f25;
                    long l21 = j + l7;
                    long l22 = j + l8;
                    float f31 = this.wtablel.C(l21);
                    float f32 = (float)l6 * this.wtablel.C(l21 + 1L);
                    float f33 = this.wtablel.C(l22);
                    float f34 = (float)l6 * this.wtablel.C(l22 + 1L);
                    long l23 = j + l17;
                    long l24 = l23 + l9;
                    long l25 = l24 + l9;
                    d2.A(l23, f19 + f21);
                    d2.A(l23 + 1L, f20 + f23);
                    d2.A(l24, f31 * f27 - f32 * f29);
                    d2.A(l24 + 1L, f31 * f29 + f32 * f27);
                    d2.A(l25, f33 * f28 - f34 * f30);
                    d2.A(l25 + 1L, f33 * f30 + f34 * f28);
                }
            }
        }
    }

    void passf4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n2 * n;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                int n11 = i * n;
                int n12 = n3 + 4 * n11 + 1;
                int n13 = n12 + n;
                int n14 = n13 + n;
                int n15 = n14 + n;
                float f = fArray[n12 - 1];
                float f2 = fArray[n12];
                float f3 = fArray[n13 - 1];
                float f4 = fArray[n13];
                float f5 = fArray[n14 - 1];
                float f6 = fArray[n14];
                float f7 = fArray[n15 - 1];
                float f8 = fArray[n15];
                float f9 = f2 - f6;
                float f10 = f2 + f6;
                float f11 = f8 - f4;
                float f12 = f4 + f8;
                float f13 = f - f5;
                float f14 = f + f5;
                float f15 = f3 - f7;
                float f16 = f3 + f7;
                int n16 = n4 + n11;
                int n17 = n16 + n10;
                int n18 = n17 + n10;
                int n19 = n18 + n10;
                fArray2[n16] = f14 + f16;
                fArray2[n16 + 1] = f10 + f12;
                fArray2[n17] = f13 + (float)n6 * f11;
                fArray2[n17 + 1] = f9 + (float)n6 * f15;
                fArray2[n18] = f14 - f16;
                fArray2[n18 + 1] = f10 - f12;
                fArray2[n19] = f13 - (float)n6 * f11;
                fArray2[n19 + 1] = f9 - (float)n6 * f15;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n20 = i * n;
                int n21 = n3 + 1 + 4 * n20;
                for (int j = 0; j < n - 1; j += 2) {
                    int n22 = j + n21;
                    int n23 = n22 + n;
                    int n24 = n23 + n;
                    int n25 = n24 + n;
                    float f = fArray[n22 - 1];
                    float f17 = fArray[n22];
                    float f18 = fArray[n23 - 1];
                    float f19 = fArray[n23];
                    float f20 = fArray[n24 - 1];
                    float f21 = fArray[n24];
                    float f22 = fArray[n25 - 1];
                    float f23 = fArray[n25];
                    float f24 = f17 - f21;
                    float f25 = f17 + f21;
                    float f26 = f19 + f23;
                    float f27 = f23 - f19;
                    float f28 = f - f20;
                    float f29 = f + f20;
                    float f30 = f18 - f22;
                    float f31 = f18 + f22;
                    float f32 = f29 - f31;
                    float f33 = f25 - f26;
                    float f34 = f28 + (float)n6 * f27;
                    float f35 = f28 - (float)n6 * f27;
                    float f36 = f24 + (float)n6 * f30;
                    float f37 = f24 - (float)n6 * f30;
                    int n26 = j + n7;
                    int n27 = j + n8;
                    int n28 = j + n9;
                    float f38 = this.wtable[n26];
                    float f39 = (float)n6 * this.wtable[n26 + 1];
                    float f40 = this.wtable[n27];
                    float f41 = (float)n6 * this.wtable[n27 + 1];
                    float f42 = this.wtable[n28];
                    float f43 = (float)n6 * this.wtable[n28 + 1];
                    int n29 = n4 + j + n20;
                    int n30 = n29 + n10;
                    int n31 = n30 + n10;
                    int n32 = n31 + n10;
                    fArray2[n29] = f29 + f31;
                    fArray2[n29 + 1] = f25 + f26;
                    fArray2[n30] = f38 * f34 - f39 * f36;
                    fArray2[n30 + 1] = f38 * f36 + f39 * f34;
                    fArray2[n31] = f40 * f32 - f41 * f33;
                    fArray2[n31 + 1] = f40 * f33 + f41 * f32;
                    fArray2[n32] = f42 * f35 - f43 * f37;
                    fArray2[n32 + 1] = f42 * f37 + f43 * f35;
                }
            }
        }
    }

    void passf4(long l, long l2, D d, long l3, D d2, long l4, long l5, int n) {
        long l6 = l5;
        long l7 = l6 + l;
        long l8 = l7 + l;
        long l9 = l2 * l;
        if (l == 2L) {
            for (long i = 0L; i < l2; ++i) {
                long l10 = i * l;
                long l11 = l3 + 4L * l10 + 1L;
                long l12 = l11 + l;
                long l13 = l12 + l;
                long l14 = l13 + l;
                float f = d.C(l11 - 1L);
                float f2 = d.C(l11);
                float f3 = d.C(l12 - 1L);
                float f4 = d.C(l12);
                float f5 = d.C(l13 - 1L);
                float f6 = d.C(l13);
                float f7 = d.C(l14 - 1L);
                float f8 = d.C(l14);
                float f9 = f2 - f6;
                float f10 = f2 + f6;
                float f11 = f8 - f4;
                float f12 = f4 + f8;
                float f13 = f - f5;
                float f14 = f + f5;
                float f15 = f3 - f7;
                float f16 = f3 + f7;
                long l15 = l4 + l10;
                long l16 = l15 + l9;
                long l17 = l16 + l9;
                long l18 = l17 + l9;
                d2.A(l15, f14 + f16);
                d2.A(l15 + 1L, f10 + f12);
                d2.A(l16, f13 + (float)n * f11);
                d2.A(l16 + 1L, f9 + (float)n * f15);
                d2.A(l17, f14 - f16);
                d2.A(l17 + 1L, f10 - f12);
                d2.A(l18, f13 - (float)n * f11);
                d2.A(l18 + 1L, f9 - (float)n * f15);
            }
        } else {
            for (long i = 0L; i < l2; ++i) {
                long l19 = i * l;
                long l20 = l3 + 1L + 4L * l19;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l21 = j + l20;
                    long l22 = l21 + l;
                    long l23 = l22 + l;
                    long l24 = l23 + l;
                    float f = d.C(l21 - 1L);
                    float f17 = d.C(l21);
                    float f18 = d.C(l22 - 1L);
                    float f19 = d.C(l22);
                    float f20 = d.C(l23 - 1L);
                    float f21 = d.C(l23);
                    float f22 = d.C(l24 - 1L);
                    float f23 = d.C(l24);
                    float f24 = f17 - f21;
                    float f25 = f17 + f21;
                    float f26 = f19 + f23;
                    float f27 = f23 - f19;
                    float f28 = f - f20;
                    float f29 = f + f20;
                    float f30 = f18 - f22;
                    float f31 = f18 + f22;
                    float f32 = f29 - f31;
                    float f33 = f25 - f26;
                    float f34 = f28 + (float)n * f27;
                    float f35 = f28 - (float)n * f27;
                    float f36 = f24 + (float)n * f30;
                    float f37 = f24 - (float)n * f30;
                    long l25 = j + l6;
                    long l26 = j + l7;
                    long l27 = j + l8;
                    float f38 = this.wtablel.C(l25);
                    float f39 = (float)n * this.wtablel.C(l25 + 1L);
                    float f40 = this.wtablel.C(l26);
                    float f41 = (float)n * this.wtablel.C(l26 + 1L);
                    float f42 = this.wtablel.C(l27);
                    float f43 = (float)n * this.wtablel.C(l27 + 1L);
                    long l28 = l4 + j + l19;
                    long l29 = l28 + l9;
                    long l30 = l29 + l9;
                    long l31 = l30 + l9;
                    d2.A(l28, f29 + f31);
                    d2.A(l28 + 1L, f25 + f26);
                    d2.A(l29, f38 * f34 - f39 * f36);
                    d2.A(l29 + 1L, f38 * f36 + f39 * f34);
                    d2.A(l30, f40 * f32 - f41 * f33);
                    d2.A(l30 + 1L, f40 * f33 + f41 * f32);
                    d2.A(l31, f42 * f35 - f43 * f37);
                    d2.A(l31 + 1L, f42 * f37 + f43 * f35);
                }
            }
        }
    }

    void passf5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        float f = 0.309017f;
        float f2 = 0.95105654f;
        float f3 = -0.809017f;
        float f4 = 0.58778524f;
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n9 + n;
        int n11 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n12 = n3 + (5 * i - 4) * n + 1;
                int n13 = n12 + n;
                int n14 = n12 - n;
                int n15 = n13 + n;
                int n16 = n15 + n;
                float f5 = fArray[n12 - 1];
                float f6 = fArray[n12];
                float f7 = fArray[n13 - 1];
                float f8 = fArray[n13];
                float f9 = fArray[n14 - 1];
                float f10 = fArray[n14];
                float f11 = fArray[n15 - 1];
                float f12 = fArray[n15];
                float f13 = fArray[n16 - 1];
                float f14 = fArray[n16];
                float f15 = f6 - f14;
                float f16 = f6 + f14;
                float f17 = f8 - f12;
                float f18 = f8 + f12;
                float f19 = f5 - f13;
                float f20 = f5 + f13;
                float f21 = f7 - f11;
                float f22 = f7 + f11;
                float f23 = f9 + 0.309017f * f20 + -0.809017f * f22;
                float f24 = f10 + 0.309017f * f16 + -0.809017f * f18;
                float f25 = f9 + -0.809017f * f20 + 0.309017f * f22;
                float f26 = f10 + -0.809017f * f16 + 0.309017f * f18;
                float f27 = (float)n6 * (0.95105654f * f19 + 0.58778524f * f21);
                float f28 = (float)n6 * (0.95105654f * f15 + 0.58778524f * f17);
                float f29 = (float)n6 * (0.58778524f * f19 - 0.95105654f * f21);
                float f30 = (float)n6 * (0.58778524f * f15 - 0.95105654f * f17);
                int n17 = n4 + (i - 1) * n;
                int n18 = n17 + n11;
                int n19 = n18 + n11;
                int n20 = n19 + n11;
                int n21 = n20 + n11;
                fArray2[n17] = f9 + f20 + f22;
                fArray2[n17 + 1] = f10 + f16 + f18;
                fArray2[n18] = f23 - f28;
                fArray2[n18 + 1] = f24 + f27;
                fArray2[n19] = f25 - f30;
                fArray2[n19 + 1] = f26 + f29;
                fArray2[n20] = f25 + f30;
                fArray2[n20 + 1] = f26 - f29;
                fArray2[n21] = f23 + f28;
                fArray2[n21 + 1] = f24 - f27;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n22 = n3 + 1 + (i * 5 - 4) * n;
                int n23 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n24 = j + n22;
                    int n25 = n24 + n;
                    int n26 = n24 - n;
                    int n27 = n25 + n;
                    int n28 = n27 + n;
                    float f31 = fArray[n24 - 1];
                    float f32 = fArray[n24];
                    float f33 = fArray[n25 - 1];
                    float f34 = fArray[n25];
                    float f35 = fArray[n26 - 1];
                    float f36 = fArray[n26];
                    float f37 = fArray[n27 - 1];
                    float f38 = fArray[n27];
                    float f39 = fArray[n28 - 1];
                    float f40 = fArray[n28];
                    float f41 = f32 - f40;
                    float f42 = f32 + f40;
                    float f43 = f34 - f38;
                    float f44 = f34 + f38;
                    float f45 = f31 - f39;
                    float f46 = f31 + f39;
                    float f47 = f33 - f37;
                    float f48 = f33 + f37;
                    float f49 = f35 + 0.309017f * f46 + -0.809017f * f48;
                    float f50 = f36 + 0.309017f * f42 + -0.809017f * f44;
                    float f51 = f35 + -0.809017f * f46 + 0.309017f * f48;
                    float f52 = f36 + -0.809017f * f42 + 0.309017f * f44;
                    float f53 = (float)n6 * (0.95105654f * f45 + 0.58778524f * f47);
                    float f54 = (float)n6 * (0.95105654f * f41 + 0.58778524f * f43);
                    float f55 = (float)n6 * (0.58778524f * f45 - 0.95105654f * f47);
                    float f56 = (float)n6 * (0.58778524f * f41 - 0.95105654f * f43);
                    float f57 = f51 - f56;
                    float f58 = f51 + f56;
                    float f59 = f52 + f55;
                    float f60 = f52 - f55;
                    float f61 = f49 + f54;
                    float f62 = f49 - f54;
                    float f63 = f50 - f53;
                    float f64 = f50 + f53;
                    int n29 = j + n7;
                    int n30 = j + n8;
                    int n31 = j + n9;
                    int n32 = j + n10;
                    float f65 = this.wtable[n29];
                    float f66 = (float)n6 * this.wtable[n29 + 1];
                    float f67 = this.wtable[n30];
                    float f68 = (float)n6 * this.wtable[n30 + 1];
                    float f69 = this.wtable[n31];
                    float f70 = (float)n6 * this.wtable[n31 + 1];
                    float f71 = this.wtable[n32];
                    float f72 = (float)n6 * this.wtable[n32 + 1];
                    int n33 = j + n23;
                    int n34 = n33 + n11;
                    int n35 = n34 + n11;
                    int n36 = n35 + n11;
                    int n37 = n36 + n11;
                    fArray2[n33] = f35 + f46 + f48;
                    fArray2[n33 + 1] = f36 + f42 + f44;
                    fArray2[n34] = f65 * f62 - f66 * f64;
                    fArray2[n34 + 1] = f65 * f64 + f66 * f62;
                    fArray2[n35] = f67 * f57 - f68 * f59;
                    fArray2[n35 + 1] = f67 * f59 + f68 * f57;
                    fArray2[n36] = f69 * f58 - f70 * f60;
                    fArray2[n36 + 1] = f69 * f60 + f70 * f58;
                    fArray2[n37] = f71 * f61 - f72 * f63;
                    fArray2[n37 + 1] = f71 * f63 + f72 * f61;
                }
            }
        }
    }

    void passf5(long l, long l2, D d, long l3, D d2, long l4, long l5, long l6) {
        float f = 0.309017f;
        float f2 = 0.95105654f;
        float f3 = -0.809017f;
        float f4 = 0.58778524f;
        long l7 = l5;
        long l8 = l7 + l;
        long l9 = l8 + l;
        long l10 = l9 + l;
        long l11 = l2 * l;
        if (l == 2L) {
            for (long i = 1L; i <= l2; ++i) {
                long l12 = l3 + (5L * i - 4L) * l + 1L;
                long l13 = l12 + l;
                long l14 = l12 - l;
                long l15 = l13 + l;
                long l16 = l15 + l;
                float f5 = d.C(l12 - 1L);
                float f6 = d.C(l12);
                float f7 = d.C(l13 - 1L);
                float f8 = d.C(l13);
                float f9 = d.C(l14 - 1L);
                float f10 = d.C(l14);
                float f11 = d.C(l15 - 1L);
                float f12 = d.C(l15);
                float f13 = d.C(l16 - 1L);
                float f14 = d.C(l16);
                float f15 = f6 - f14;
                float f16 = f6 + f14;
                float f17 = f8 - f12;
                float f18 = f8 + f12;
                float f19 = f5 - f13;
                float f20 = f5 + f13;
                float f21 = f7 - f11;
                float f22 = f7 + f11;
                float f23 = f9 + 0.309017f * f20 + -0.809017f * f22;
                float f24 = f10 + 0.309017f * f16 + -0.809017f * f18;
                float f25 = f9 + -0.809017f * f20 + 0.309017f * f22;
                float f26 = f10 + -0.809017f * f16 + 0.309017f * f18;
                float f27 = (float)l6 * (0.95105654f * f19 + 0.58778524f * f21);
                float f28 = (float)l6 * (0.95105654f * f15 + 0.58778524f * f17);
                float f29 = (float)l6 * (0.58778524f * f19 - 0.95105654f * f21);
                float f30 = (float)l6 * (0.58778524f * f15 - 0.95105654f * f17);
                long l17 = l4 + (i - 1L) * l;
                long l18 = l17 + l11;
                long l19 = l18 + l11;
                long l20 = l19 + l11;
                long l21 = l20 + l11;
                d2.A(l17, f9 + f20 + f22);
                d2.A(l17 + 1L, f10 + f16 + f18);
                d2.A(l18, f23 - f28);
                d2.A(l18 + 1L, f24 + f27);
                d2.A(l19, f25 - f30);
                d2.A(l19 + 1L, f26 + f29);
                d2.A(l20, f25 + f30);
                d2.A(l20 + 1L, f26 - f29);
                d2.A(l21, f23 + f28);
                d2.A(l21 + 1L, f24 - f27);
            }
        } else {
            for (long i = 1L; i <= l2; ++i) {
                long l22 = l3 + 1L + (i * 5L - 4L) * l;
                long l23 = l4 + (i - 1L) * l;
                for (long j = 0L; j < l - 1L; j += 2L) {
                    long l24 = j + l22;
                    long l25 = l24 + l;
                    long l26 = l24 - l;
                    long l27 = l25 + l;
                    long l28 = l27 + l;
                    float f31 = d.C(l24 - 1L);
                    float f32 = d.C(l24);
                    float f33 = d.C(l25 - 1L);
                    float f34 = d.C(l25);
                    float f35 = d.C(l26 - 1L);
                    float f36 = d.C(l26);
                    float f37 = d.C(l27 - 1L);
                    float f38 = d.C(l27);
                    float f39 = d.C(l28 - 1L);
                    float f40 = d.C(l28);
                    float f41 = f32 - f40;
                    float f42 = f32 + f40;
                    float f43 = f34 - f38;
                    float f44 = f34 + f38;
                    float f45 = f31 - f39;
                    float f46 = f31 + f39;
                    float f47 = f33 - f37;
                    float f48 = f33 + f37;
                    float f49 = f35 + 0.309017f * f46 + -0.809017f * f48;
                    float f50 = f36 + 0.309017f * f42 + -0.809017f * f44;
                    float f51 = f35 + -0.809017f * f46 + 0.309017f * f48;
                    float f52 = f36 + -0.809017f * f42 + 0.309017f * f44;
                    float f53 = (float)l6 * (0.95105654f * f45 + 0.58778524f * f47);
                    float f54 = (float)l6 * (0.95105654f * f41 + 0.58778524f * f43);
                    float f55 = (float)l6 * (0.58778524f * f45 - 0.95105654f * f47);
                    float f56 = (float)l6 * (0.58778524f * f41 - 0.95105654f * f43);
                    float f57 = f51 - f56;
                    float f58 = f51 + f56;
                    float f59 = f52 + f55;
                    float f60 = f52 - f55;
                    float f61 = f49 + f54;
                    float f62 = f49 - f54;
                    float f63 = f50 - f53;
                    float f64 = f50 + f53;
                    long l29 = j + l7;
                    long l30 = j + l8;
                    long l31 = j + l9;
                    long l32 = j + l10;
                    float f65 = this.wtablel.C(l29);
                    float f66 = (float)l6 * this.wtablel.C(l29 + 1L);
                    float f67 = this.wtablel.C(l30);
                    float f68 = (float)l6 * this.wtablel.C(l30 + 1L);
                    float f69 = this.wtablel.C(l31);
                    float f70 = (float)l6 * this.wtablel.C(l31 + 1L);
                    float f71 = this.wtablel.C(l32);
                    float f72 = (float)l6 * this.wtablel.C(l32 + 1L);
                    long l33 = j + l23;
                    long l34 = l33 + l11;
                    long l35 = l34 + l11;
                    long l36 = l35 + l11;
                    long l37 = l36 + l11;
                    d2.A(l33, f35 + f46 + f48);
                    d2.A(l33 + 1L, f36 + f42 + f44);
                    d2.A(l34, f65 * f62 - f66 * f64);
                    d2.A(l34 + 1L, f65 * f64 + f66 * f62);
                    d2.A(l35, f67 * f57 - f68 * f59);
                    d2.A(l35 + 1L, f67 * f59 + f68 * f57);
                    d2.A(l36, f69 * f58 - f70 * f60);
                    d2.A(l36 + 1L, f69 * f60 + f70 * f58);
                    d2.A(l37, f71 * f61 - f72 * f63);
                    d2.A(l37 + 1L, f71 * f63 + f72 * f61);
                }
            }
        }
    }

    void passfg(int[] nArray, int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7, int n8) {
        float f;
        float f2;
        float f3;
        float f4;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        int n21 = n / 2;
        int n22 = (n2 + 1) / 2;
        int n23 = n2 * n;
        if (n >= n3) {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n;
                n16 = n18 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    n14 = n15 * n;
                    n13 = n14 + n17 * n3;
                    n12 = n14 + n16 * n3;
                    n11 = n14 * n2;
                    for (n10 = 0; n10 < n; ++n10) {
                        n9 = n6 + n10;
                        float f5 = fArray[n5 + n10 + n17 + n11];
                        f4 = fArray[n5 + n10 + n16 + n11];
                        fArray2[n9 + n13] = f5 + f4;
                        fArray2[n9 + n12] = f5 - f4;
                    }
                }
            }
            for (n19 = 0; n19 < n3; ++n19) {
                n17 = n19 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    fArray2[n6 + n15 + n17] = fArray[n5 + n15 + n16];
                }
            }
        } else {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n3 * n;
                n16 = n18 * n3 * n;
                n15 = n19 * n;
                n14 = n18 * n;
                for (n13 = 0; n13 < n; ++n13) {
                    for (n12 = 0; n12 < n3; ++n12) {
                        n11 = n12 * n;
                        n10 = n11 * n2;
                        n9 = n6 + n13;
                        int n24 = n5 + n13;
                        f4 = fArray[n24 + n15 + n10];
                        f3 = fArray[n24 + n14 + n10];
                        fArray2[n9 + n11 + n17] = f4 + f3;
                        fArray2[n9 + n11 + n16] = f4 - f3;
                    }
                }
            }
            for (n19 = 0; n19 < n; ++n19) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    fArray2[n6 + n19 + n16] = fArray[n5 + n19 + n16 * n2];
                }
            }
        }
        int n25 = 2 - n;
        int n26 = 0;
        n19 = (n2 - 1) * n4;
        for (int i = 1; i < n22; ++i) {
            int n27 = n2 - i;
            n17 = i * n4;
            n16 = n27 * n4;
            n15 = (n25 += n) + n20;
            f2 = this.wtable[n15 - 2];
            f = (float)n8 * this.wtable[n15 - 1];
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                fArray[n13 + n17] = fArray2[n12] + f2 * fArray2[n12 + n4];
                fArray[n13 + n16] = f * fArray2[n12 + n19];
            }
            int n28 = n25;
            n26 += n;
            for (n14 = 2; n14 < n22; ++n14) {
                n18 = n2 - n14;
                if ((n28 += n26) > n23) {
                    n28 -= n23;
                }
                n13 = n28 + n20;
                float f6 = this.wtable[n13 - 2];
                float f7 = (float)n8 * this.wtable[n13 - 1];
                n12 = n14 * n4;
                n11 = n18 * n4;
                for (n10 = 0; n10 < n4; ++n10) {
                    n9 = n5 + n10;
                    int n29 = n6 + n10;
                    int n30 = n9 + n17;
                    fArray[n30] = fArray[n30] + f6 * fArray2[n29 + n12];
                    int n31 = n9 + n16;
                    fArray[n31] = fArray[n31] + f7 * fArray2[n29 + n11];
                }
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n32 = n14 = n6 + n15;
                fArray2[n32] = fArray2[n32] + fArray2[n14 + n16];
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n18 = n2 - n17;
            n16 = n17 * n4;
            n15 = n18 * n4;
            for (n14 = 1; n14 < n4; n14 += 2) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                n11 = n12 + n16;
                n10 = n12 + n15;
                float f8 = fArray[n11 - 1];
                float f9 = fArray[n11];
                f4 = fArray[n10 - 1];
                f3 = fArray[n10];
                int n33 = n13 + n16;
                int n34 = n13 + n15;
                fArray2[n33 - 1] = f8 - f3;
                fArray2[n34 - 1] = f8 + f3;
                fArray2[n33] = f9 + f4;
                fArray2[n34] = f9 - f4;
            }
        }
        nArray[0] = 1;
        if (n == 2) {
            return;
        }
        nArray[0] = 0;
        System.arraycopy(fArray2, n6, fArray, n5, n4);
        n17 = n3 * n;
        for (n16 = 1; n16 < n2; ++n16) {
            n15 = n16 * n17;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13 + n15;
                n11 = n5 + n13 + n15;
                fArray[n11] = fArray2[n12];
                fArray[n11 + 1] = fArray2[n12 + 1];
            }
        }
        if (n21 <= n3) {
            int n35 = 0;
            for (n16 = 1; n16 < n2; ++n16) {
                n35 += 2;
                n15 = n16 * n3 * n;
                for (n14 = 3; n14 < n; n14 += 2) {
                    n13 = (n35 += 2) + n20 - 1;
                    f2 = this.wtable[n13 - 1];
                    f = (float)n8 * this.wtable[n13];
                    n12 = n5 + n14;
                    n11 = n6 + n14;
                    for (n10 = 0; n10 < n3; ++n10) {
                        int n36 = n10 * n + n15;
                        int n37 = n12 + n36;
                        int n38 = n11 + n36;
                        f3 = fArray2[n38 - 1];
                        float f10 = fArray2[n38];
                        fArray[n37 - 1] = f2 * f3 - f * f10;
                        fArray[n37] = f2 * f10 + f * f3;
                    }
                }
            }
        } else {
            int n39 = 2 - n;
            for (n16 = 1; n16 < n2; ++n16) {
                n39 += n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    int n40 = n39;
                    n13 = n14 * n + n15;
                    for (n12 = 3; n12 < n; n12 += 2) {
                        n11 = (n40 += 2) - 1 + n20;
                        f2 = this.wtable[n11 - 1];
                        f = (float)n8 * this.wtable[n11];
                        n10 = n5 + n12 + n13;
                        int n41 = n6 + n12 + n13;
                        float f11 = fArray2[n41 - 1];
                        f4 = fArray2[n41];
                        fArray[n10 - 1] = f2 * f11 - f * f4;
                        fArray[n10] = f2 * f4 + f * f11;
                    }
                }
            }
        }
    }

    void passfg(int[] nArray, long l, long l2, long l3, long l4, D d, long l5, D d2, long l6, long l7, long l8) {
        float f;
        float f2;
        float f3;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20 = l7;
        long l21 = l / 2L;
        long l22 = (l2 + 1L) / 2L;
        long l23 = l2 * l;
        if (l >= l3) {
            for (l19 = 1L; l19 < l22; ++l19) {
                l18 = l2 - l19;
                l17 = l19 * l;
                l16 = l18 * l;
                for (l15 = 0L; l15 < l3; ++l15) {
                    l14 = l15 * l;
                    l13 = l14 + l17 * l3;
                    l12 = l14 + l16 * l3;
                    l11 = l14 * l2;
                    for (l10 = 0L; l10 < l; ++l10) {
                        l9 = l6 + l10;
                        float f4 = d.C(l5 + l10 + l17 + l11);
                        f3 = d.C(l5 + l10 + l16 + l11);
                        d2.A(l9 + l13, f4 + f3);
                        d2.A(l9 + l12, f4 - f3);
                    }
                }
            }
            for (l19 = 0L; l19 < l3; ++l19) {
                l17 = l19 * l;
                l16 = l17 * l2;
                for (l15 = 0L; l15 < l; ++l15) {
                    d2.A(l6 + l15 + l17, d.C(l5 + l15 + l16));
                }
            }
        } else {
            for (l19 = 1L; l19 < l22; ++l19) {
                l18 = l2 - l19;
                l17 = l19 * l3 * l;
                l16 = l18 * l3 * l;
                l15 = l19 * l;
                l14 = l18 * l;
                for (l13 = 0L; l13 < l; ++l13) {
                    for (l12 = 0L; l12 < l3; ++l12) {
                        l11 = l12 * l;
                        l10 = l11 * l2;
                        l9 = l6 + l13;
                        long l24 = l5 + l13;
                        float f5 = d.C(l24 + l15 + l10);
                        float f6 = d.C(l24 + l14 + l10);
                        d2.A(l9 + l11 + l17, f5 + f6);
                        d2.A(l9 + l11 + l16, f5 - f6);
                    }
                }
            }
            for (l19 = 0L; l19 < l; ++l19) {
                for (l17 = 0L; l17 < l3; ++l17) {
                    l16 = l17 * l;
                    d2.A(l6 + l19 + l16, d.C(l5 + l19 + l16 * l2));
                }
            }
        }
        long l25 = 2L - l;
        long l26 = 0L;
        l19 = (l2 - 1L) * l4;
        for (long i = 1L; i < l22; ++i) {
            long l27 = l2 - i;
            l17 = i * l4;
            l16 = l27 * l4;
            l15 = (l25 += l) + l20;
            f2 = this.wtablel.C(l15 - 2L);
            f = (float)l8 * this.wtablel.C(l15 - 1L);
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l5 + l14;
                l12 = l6 + l14;
                d.A(l13 + l17, d2.C(l12) + f2 * d2.C(l12 + l4));
                d.A(l13 + l16, f * d2.C(l12 + l19));
            }
            long l28 = l25;
            l26 += l;
            for (l14 = 2L; l14 < l22; ++l14) {
                l18 = l2 - l14;
                if ((l28 += l26) > l23) {
                    l28 -= l23;
                }
                l13 = l28 + l20;
                float f7 = this.wtablel.C(l13 - 2L);
                float f8 = (float)l8 * this.wtablel.C(l13 - 1L);
                l12 = l14 * l4;
                l11 = l18 * l4;
                for (l10 = 0L; l10 < l4; ++l10) {
                    l9 = l5 + l10;
                    long l29 = l6 + l10;
                    d.A(l9 + l17, d.C(l9 + l17) + f7 * d2.C(l29 + l12));
                    d.A(l9 + l16, d.C(l9 + l16) + f8 * d2.C(l29 + l11));
                }
            }
        }
        for (l17 = 1L; l17 < l22; ++l17) {
            l16 = l17 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                l14 = l6 + l15;
                d2.A(l14, d2.C(l14) + d2.C(l14 + l16));
            }
        }
        for (l17 = 1L; l17 < l22; ++l17) {
            l18 = l2 - l17;
            l16 = l17 * l4;
            l15 = l18 * l4;
            for (l14 = 1L; l14 < l4; l14 += 2L) {
                l13 = l6 + l14;
                l12 = l5 + l14;
                l11 = l12 + l16;
                l10 = l12 + l15;
                float f9 = d.C(l11 - 1L);
                float f10 = d.C(l11);
                float f11 = d.C(l10 - 1L);
                f3 = d.C(l10);
                long l30 = l13 + l16;
                long l31 = l13 + l15;
                d2.A(l30 - 1L, f9 - f3);
                d2.A(l31 - 1L, f9 + f3);
                d2.A(l30, f10 + f11);
                d2.A(l31, f10 - f11);
            }
        }
        nArray[0] = 1;
        if (l == 2L) {
            return;
        }
        nArray[0] = 0;
        C.A(d2, l6, d, l5, l4);
        l17 = l3 * l;
        for (l16 = 1L; l16 < l2; ++l16) {
            l15 = l16 * l17;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l6 + l13 + l15;
                l11 = l5 + l13 + l15;
                d.A(l11, d2.C(l12));
                d.A(l11 + 1L, d2.C(l12 + 1L));
            }
        }
        if (l21 <= l3) {
            long l32 = 0L;
            for (l16 = 1L; l16 < l2; ++l16) {
                l32 += 2L;
                l15 = l16 * l3 * l;
                for (l14 = 3L; l14 < l; l14 += 2L) {
                    l13 = (l32 += 2L) + l20 - 1L;
                    f2 = this.wtablel.C(l13 - 1L);
                    f = (float)l8 * this.wtablel.C(l13);
                    l12 = l5 + l14;
                    l11 = l6 + l14;
                    for (l10 = 0L; l10 < l3; ++l10) {
                        long l33 = l10 * l + l15;
                        long l34 = l12 + l33;
                        long l35 = l11 + l33;
                        float f12 = d2.C(l35 - 1L);
                        float f13 = d2.C(l35);
                        d.A(l34 - 1L, f2 * f12 - f * f13);
                        d.A(l34, f2 * f13 + f * f12);
                    }
                }
            }
        } else {
            long l36 = 2L - l;
            for (l16 = 1L; l16 < l2; ++l16) {
                l36 += l;
                l15 = l16 * l3 * l;
                for (l14 = 0L; l14 < l3; ++l14) {
                    long l37 = l36;
                    l13 = l14 * l + l15;
                    for (l12 = 3L; l12 < l; l12 += 2L) {
                        l11 = (l37 += 2L) - 1L + l20;
                        f2 = this.wtablel.C(l11 - 1L);
                        f = (float)l8 * this.wtablel.C(l11);
                        l10 = l5 + l12 + l13;
                        long l38 = l6 + l12 + l13;
                        float f14 = d2.C(l38 - 1L);
                        f3 = d2.C(l38);
                        d.A(l10 - 1L, f2 * f14 - f * f3);
                        d.A(l10, f2 * f3 + f * f14);
                    }
                }
            }
        }
    }

    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

