/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import B.A.A.A.A;
import B.A.A.A.C;
import B.A.A.A.E;
import B.A.A.A.F;
import B.A.A.A.G;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.utils.CommonUtils;

public final class DoubleFFT_1D {
    private int n;
    private long nl;
    private int nBluestein;
    private long nBluesteinl;
    private int[] ip;
    private G ipl;
    private double[] w;
    private A wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private double[] wtable;
    private A wtablel;
    private double[] wtable_r;
    private A wtable_rl;
    private double[] bk1;
    private A bk1l;
    private double[] bk2;
    private A bk2l;
    private Plans plan;
    private boolean useLargeArrays;
    private static final int[] factors = new int[]{4, 2, 3, 5};

    public DoubleFFT_1D(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || 2L * l > (long)E.C();
        this.n = (int)l;
        this.nl = l;
        if (!this.useLargeArrays) {
            if (!CommonUtils.isPowerOf2(l)) {
                if (CommonUtils.getReminder(l, factors) >= 211L) {
                    this.plan = Plans.BLUESTEIN;
                    this.nBluestein = CommonUtils.nextPow2(this.n * 2 - 1);
                    this.bk1 = new double[2 * this.nBluestein];
                    this.bk2 = new double[2 * this.nBluestein];
                    this.ip = new int[2 + (int)FastMath.ceil(2 + (1 << (int)(FastMath.log((double)this.nBluestein + 0.5) / FastMath.log(2.0)) / 2))];
                    this.w = new double[this.nBluestein];
                    int n = 2 * this.nBluestein;
                    this.nw = n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                    this.nc = this.nBluestein >> 2;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                    this.bluesteini();
                } else {
                    this.plan = Plans.MIXED_RADIX;
                    this.wtable = new double[4 * this.n + 15];
                    this.wtable_r = new double[2 * this.n + 15];
                    this.cffti();
                    this.rffti();
                }
            } else {
                this.plan = Plans.SPLIT_RADIX;
                this.ip = new int[2 + (int)FastMath.ceil(2 + (1 << (int)(FastMath.log((double)l + 0.5) / FastMath.log(2.0)) / 2))];
                this.w = new double[this.n];
                int n = 2 * this.n;
                this.nw = n >> 2;
                CommonUtils.makewt(this.nw, this.ip, this.w);
                this.nc = this.n >> 2;
                CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
            }
        } else if (!CommonUtils.isPowerOf2(this.nl)) {
            if (CommonUtils.getReminder(this.nl, factors) >= 211L) {
                this.plan = Plans.BLUESTEIN;
                this.nBluesteinl = CommonUtils.nextPow2(this.nl * 2L - 1L);
                this.bk1l = new A(2L * this.nBluesteinl);
                this.bk2l = new A(2L * this.nBluesteinl);
                this.ipl = new G(2L + (long)FastMath.ceil(2L + (1L << (int)((long)(FastMath.log((double)this.nBluesteinl + 0.5) / FastMath.log(2.0)) / 2L))));
                this.wl = new A(this.nBluesteinl);
                long l2 = 2L * this.nBluesteinl;
                this.nwl = l2 >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
                this.ncl = this.nBluesteinl >> 2;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
                this.bluesteinil();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtablel = new A(4L * this.nl + 15L);
                this.wtable_rl = new A(2L * this.nl + 15L);
                this.cfftil();
                this.rfftil();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ipl = new G(2L + (long)FastMath.ceil(2L + (1L << (int)((long)(FastMath.log((double)this.nl + 0.5) / FastMath.log(2.0)) / 2L))));
            this.wl = new A(this.nl);
            long l3 = 2L * this.nl;
            this.nwl = l3 >> 2;
            CommonUtils.makewt(this.nwl, this.ipl, this.wl);
            this.ncl = this.nl >> 2;
            CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
        }
    }

    public void realForward(double[] dArray) {
        this.realForward(dArray, 0);
    }

    public void realForward(double[] dArray, int n) {
        if (this.useLargeArrays) {
            this.realForward(new A(dArray), (long)n);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.n > 4) {
                        CommonUtils.cftfsub(this.n, dArray, n, this.ip, this.nw, this.w);
                        CommonUtils.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                    } else if (this.n == 4) {
                        CommonUtils.cftx020(dArray, n);
                    }
                    double d = dArray[n] - dArray[n + 1];
                    int n2 = n;
                    dArray[n2] = dArray[n2] + dArray[n + 1];
                    dArray[n + 1] = d;
                    break;
                }
                case MIXED_RADIX: {
                    this.rfftf(dArray, n);
                    for (int i = this.n - 1; i >= 2; --i) {
                        int n3 = n + i;
                        double d = dArray[n3];
                        dArray[n3] = dArray[n3 - 1];
                        dArray[n3 - 1] = d;
                    }
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(dArray, n);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realForward(A a, long l) {
        if (!this.useLargeArrays) {
            if (a.A() || a.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realForward(a.H(), (int)l);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    if (this.nl > 4L) {
                        CommonUtils.cftfsub(this.nl, a, l, this.ipl, this.nwl, this.wl);
                        CommonUtils.rftfsub(this.nl, a, l, this.ncl, this.wl, this.nwl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftx020(a, l);
                    }
                    double d = a.E(l) - a.E(l + 1L);
                    a.B(l, a.E(l) + a.E(l + 1L));
                    a.B(l + 1L, d);
                    return;
                }
                case MIXED_RADIX: {
                    this.rfftf(a, l);
                    for (long i = this.nl - 1L; i >= 2L; --i) {
                        long l2 = l + i;
                        double d = a.E(l2);
                        a.B(l2, a.E(l2 - 1L));
                        a.B(l2 - 1L, d);
                    }
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_forward(a, l);
                }
            }
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        this.realInverse(dArray, 0, bl);
    }

    public void realInverse(double[] dArray, int n, boolean bl) {
        if (this.useLargeArrays) {
            this.realInverse(new A(dArray), (long)n, bl);
        } else {
            if (this.n == 1) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    dArray[n + 1] = 0.5 * (dArray[n] - dArray[n + 1]);
                    int n2 = n;
                    dArray[n2] = dArray[n2] - dArray[n + 1];
                    if (this.n > 4) {
                        CommonUtils.rftfsub(this.n, dArray, n, this.nc, this.w, this.nw);
                        CommonUtils.cftbsub(this.n, dArray, n, this.ip, this.nw, this.w);
                    } else if (this.n == 4) {
                        CommonUtils.cftxc020(dArray, n);
                    }
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / ((double)this.n / 2.0), dArray, n, false);
                    break;
                }
                case MIXED_RADIX: {
                    for (int i = 2; i < this.n; ++i) {
                        int n3 = n + i;
                        double d = dArray[n3 - 1];
                        dArray[n3 - 1] = dArray[n3];
                        dArray[n3] = d;
                    }
                    this.rfftb(dArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                    break;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(dArray, n);
                    if (!bl) break;
                    CommonUtils.scale(this.n, 1.0 / (double)this.n, dArray, n, false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realInverse(A a, long l, boolean bl) {
        if (!this.useLargeArrays) {
            if (a.A() || a.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.realInverse(a.H(), (int)l, bl);
            return;
        } else {
            if (this.nl == 1L) {
                return;
            }
            switch (this.plan) {
                case SPLIT_RADIX: {
                    a.B(l + 1L, 0.5 * (a.E(l) - a.E(l + 1L)));
                    a.B(l, a.E(l) - a.E(l + 1L));
                    if (this.nl > 4L) {
                        CommonUtils.rftfsub(this.nl, a, l, this.ncl, this.wl, this.nwl);
                        CommonUtils.cftbsub(this.nl, a, l, this.ipl, this.nwl, this.wl);
                    } else if (this.nl == 4L) {
                        CommonUtils.cftxc020(a, l);
                    }
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / ((double)this.nl / 2.0), a, l, false);
                    return;
                }
                case MIXED_RADIX: {
                    for (long i = 2L; i < this.nl; ++i) {
                        long l2 = l + i;
                        double d = a.E(l2 - 1L);
                        a.B(l2 - 1L, a.E(l2));
                        a.B(l2, d);
                    }
                    this.rfftb(a, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, a, l, false);
                    return;
                }
                case BLUESTEIN: {
                    this.bluestein_real_inverse(a, l);
                    if (!bl) return;
                    CommonUtils.scale(this.nl, 1.0 / (double)this.nl, a, l, false);
                }
            }
        }
    }

    final void cffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 4 * this.n;
        int n5 = 0;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        block0: while (true) {
            n5 = ++n8 <= 4 ? factors[n8 - 1] : (n5 += 2);
            do {
                int n9;
                int n10;
                if ((n10 = n6 - n5 * (n9 = n6 / n5)) != 0) continue block0;
                this.wtable[++n7 + 1 + n4] = n5;
                n6 = n9;
                if (n5 != 2 || n7 == 1) continue;
                for (n2 = 2; n2 <= n7; ++n2) {
                    int n11 = n7 - n2 + 2;
                    n = n11 + n4;
                    this.wtable[n + 1] = this.wtable[n];
                }
                this.wtable[2 + n4] = 2.0;
            } while (n6 != 1);
            break;
        }
        this.wtable[n4] = this.n;
        this.wtable[1 + n4] = n7;
        double d = Math.PI * 2 / (double)this.n;
        n2 = 1;
        int n12 = 1;
        for (int i = 1; i <= n7; ++i) {
            int n13 = (int)this.wtable[i + 1 + n4];
            int n14 = 0;
            int n15 = n12 * n13;
            int n16 = this.n / n15;
            int n17 = n16 + n16 + 2;
            int n18 = n13 - 1;
            for (n8 = 1; n8 <= n18; ++n8) {
                int n19 = n2;
                this.wtable[n2 - 1 + n3] = 1.0;
                this.wtable[n2 + n3] = 0.0;
                double d2 = 0.0;
                double d3 = (double)(n14 += n12) * d;
                for (int j = 4; j <= n17; j += 2) {
                    double d4 = (d2 += 1.0) * d3;
                    n = (n2 += 2) + n3;
                    this.wtable[n - 1] = FastMath.cos(d4);
                    this.wtable[n] = FastMath.sin(d4);
                }
                if (n13 <= 5) continue;
                n = n19 + n3;
                int n20 = n2 + n3;
                this.wtable[n - 1] = this.wtable[n20 - 1];
                this.wtable[n] = this.wtable[n20];
            }
            n12 = n15;
        }
    }

    final void cfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 4L * this.nl;
        long l5 = 0L;
        long l6 = this.nl;
        long l7 = 0L;
        long l8 = 0L;
        block0: while (true) {
            l5 = ++l8 <= 4L ? (long)factors[(int)(l8 - 1L)] : (l5 += 2L);
            do {
                long l9;
                long l10;
                if ((l10 = l6 - l5 * (l9 = l6 / l5)) != 0L) continue block0;
                this.wtablel.B(++l7 + 1L + l4, l5);
                l6 = l9;
                if (l5 != 2L || l7 == 1L) continue;
                for (l2 = 2L; l2 <= l7; ++l2) {
                    long l11 = l7 - l2 + 2L;
                    l = l11 + l4;
                    this.wtablel.B(l + 1L, this.wtablel.E(l));
                }
                this.wtablel.B(2L + l4, 2.0);
            } while (l6 != 1L);
            break;
        }
        this.wtablel.B(l4, this.nl);
        this.wtablel.B(1L + l4, l7);
        double d = Math.PI * 2 / (double)this.nl;
        l2 = 1L;
        long l12 = 1L;
        for (long i = 1L; i <= l7; ++i) {
            long l13 = (long)this.wtablel.E(i + 1L + l4);
            long l14 = 0L;
            long l15 = l12 * l13;
            long l16 = this.nl / l15;
            long l17 = l16 + l16 + 2L;
            long l18 = l13 - 1L;
            for (l8 = 1L; l8 <= l18; ++l8) {
                long l19 = l2;
                this.wtablel.B(l2 - 1L + l3, 1.0);
                this.wtablel.B(l2 + l3, 0.0);
                double d2 = 0.0;
                double d3 = (double)(l14 += l12) * d;
                for (long j = 4L; j <= l17; j += 2L) {
                    double d4 = (d2 += 1.0) * d3;
                    l = (l2 += 2L) + l3;
                    this.wtablel.B(l - 1L, FastMath.cos(d4));
                    this.wtablel.B(l, FastMath.sin(d4));
                }
                if (l13 <= 5L) continue;
                l = l19 + l3;
                long l20 = l2 + l3;
                this.wtablel.B(l - 1L, this.wtablel.E(l20 - 1L));
                this.wtablel.B(l, this.wtablel.E(l20));
            }
            l12 = l15;
        }
    }

    void rffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 0;
        int n5 = this.n;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            n4 = ++n7 <= 4 ? factors[n7 - 1] : (n4 += 2);
            do {
                int n8;
                int n9;
                if ((n9 = n5 - n4 * (n8 = n5 / n4)) != 0) continue block0;
                this.wtable_r[++n6 + 1 + n3] = n4;
                n5 = n8;
                if (n4 != 2 || n6 == 1) continue;
                for (n2 = 2; n2 <= n6; ++n2) {
                    int n10 = n6 - n2 + 2;
                    n = n10 + n3;
                    this.wtable_r[n + 1] = this.wtable_r[n];
                }
                this.wtable_r[2 + n3] = 2.0;
            } while (n5 != 1);
            break;
        }
        this.wtable_r[n3] = this.n;
        this.wtable_r[1 + n3] = n6;
        double d = Math.PI * 2 / (double)this.n;
        int n11 = 0;
        int n12 = n6 - 1;
        int n13 = 1;
        if (n12 == 0) {
            return;
        }
        for (int i = 1; i <= n12; ++i) {
            int n14 = (int)this.wtable_r[i + 1 + n3];
            int n15 = 0;
            int n16 = n13 * n14;
            int n17 = this.n / n16;
            int n18 = n14 - 1;
            for (n7 = 1; n7 <= n18; ++n7) {
                n2 = n11;
                double d2 = (double)(n15 += n13) * d;
                double d3 = 0.0;
                for (int j = 3; j <= n17; j += 2) {
                    double d4 = (d3 += 1.0) * d2;
                    n = (n2 += 2) + this.n;
                    this.wtable_r[n - 2] = FastMath.cos(d4);
                    this.wtable_r[n - 1] = FastMath.sin(d4);
                }
                n11 += n17;
            }
            n13 = n16;
        }
    }

    void rfftil() {
        long l;
        long l2;
        if (this.nl == 1L) {
            return;
        }
        long l3 = 2L * this.nl;
        long l4 = 0L;
        long l5 = this.nl;
        long l6 = 0L;
        long l7 = 0L;
        block0: while (true) {
            l4 = ++l7 <= 4L ? (long)factors[(int)(l7 - 1L)] : (l4 += 2L);
            do {
                long l8;
                long l9;
                if ((l9 = l5 - l4 * (l8 = l5 / l4)) != 0L) continue block0;
                this.wtable_rl.B(++l6 + 1L + l3, l4);
                l5 = l8;
                if (l4 != 2L || l6 == 1L) continue;
                for (l2 = 2L; l2 <= l6; ++l2) {
                    long l10 = l6 - l2 + 2L;
                    l = l10 + l3;
                    this.wtable_rl.B(l + 1L, this.wtable_rl.E(l));
                }
                this.wtable_rl.B(2L + l3, 2.0);
            } while (l5 != 1L);
            break;
        }
        this.wtable_rl.B(l3, this.nl);
        this.wtable_rl.B(1L + l3, l6);
        double d = Math.PI * 2 / (double)this.nl;
        long l11 = 0L;
        long l12 = l6 - 1L;
        long l13 = 1L;
        if (l12 == 0L) {
            return;
        }
        for (long i = 1L; i <= l12; ++i) {
            long l14 = (long)this.wtable_rl.E(i + 1L + l3);
            long l15 = 0L;
            long l16 = l13 * l14;
            long l17 = this.nl / l16;
            long l18 = l14 - 1L;
            for (l7 = 1L; l7 <= l18; ++l7) {
                l2 = l11;
                double d2 = (double)(l15 += l13) * d;
                double d3 = 0.0;
                for (long j = 3L; j <= l17; j += 2L) {
                    double d4 = (d3 += 1.0) * d2;
                    l = (l2 += 2L) + this.nl;
                    this.wtable_rl.B(l - 2L, FastMath.cos(d4));
                    this.wtable_rl.B(l - 1L, FastMath.sin(d4));
                }
                l11 += l17;
            }
            l13 = l16;
        }
    }

    private void bluesteini() {
        int n = 0;
        double d = Math.PI / (double)this.n;
        this.bk1[0] = 1.0;
        this.bk1[1] = 0.0;
        for (int i = 1; i < this.n; ++i) {
            if ((n += 2 * i - 1) >= 2 * this.n) {
                n -= 2 * this.n;
            }
            double d2 = d * (double)n;
            this.bk1[2 * i] = FastMath.cos(d2);
            this.bk1[2 * i + 1] = FastMath.sin(d2);
        }
        double d3 = 1.0 / (double)this.nBluestein;
        this.bk2[0] = this.bk1[0] * d3;
        this.bk2[1] = this.bk1[1] * d3;
        for (int i = 2; i < 2 * this.n; i += 2) {
            this.bk2[i] = this.bk1[i] * d3;
            this.bk2[i + 1] = this.bk1[i + 1] * d3;
            this.bk2[2 * this.nBluestein - i] = this.bk2[i];
            this.bk2[2 * this.nBluestein - i + 1] = this.bk2[i + 1];
        }
        CommonUtils.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void bluesteinil() {
        long l = 0L;
        double d = Math.PI / (double)this.nl;
        this.bk1l.B(0L, 1.0);
        this.bk1l.B(1L, 0.0);
        int n = 1;
        while ((long)n < this.nl) {
            if ((l += (long)(2 * n - 1)) >= 2L * this.nl) {
                l -= 2L * this.nl;
            }
            double d2 = d * (double)l;
            this.bk1l.B(2 * n, FastMath.cos(d2));
            this.bk1l.B(2 * n + 1, FastMath.sin(d2));
            ++n;
        }
        double d3 = 1.0 / (double)this.nBluesteinl;
        this.bk2l.B(0L, this.bk1l.E(0L) * d3);
        this.bk2l.B(1L, this.bk1l.E(1L) * d3);
        int n2 = 2;
        while ((long)n2 < 2L * this.nl) {
            this.bk2l.B(n2, this.bk1l.E(n2) * d3);
            this.bk2l.B(n2 + 1, this.bk1l.E(n2 + 1) * d3);
            this.bk2l.B(2L * this.nBluesteinl - (long)n2, this.bk2l.E(n2));
            this.bk2l.B(2L * this.nBluesteinl - (long)n2 + 1L, this.bk2l.E(n2 + 1));
            n2 += 2;
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, this.bk2l, 0L, this.ipl, this.nwl, this.wl);
    }

    private void bluestein_real_forward(final double[] dArray, final int n) {
        int n2;
        int n3;
        final double[] dArray2 = new double[2 * this.nBluestein];
        int n4 = F.A();
        if (n4 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n3 = 2;
            if (n4 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            n2 = this.n / n3;
            for (int i = 0; i < n3; ++i) {
                n6 = i * n2;
                n5 = i == n3 - 1 ? this.n : n6 + n2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            dArray2[n4] = dArray[n3] * DoubleFFT_1D.this.bk1[n4];
                            dArray2[n2] = -dArray[n3] * DoubleFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n2 = this.nBluestein / n3;
            for (int i = 0; i < n3; ++i) {
                n6 = i * n2;
                n5 = i == n3 - 1 ? this.nBluestein : n6 + n2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] - dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            int n7;
            for (n3 = 0; n3 < this.n; ++n3) {
                n7 = 2 * n3;
                n2 = n7 + 1;
                int n8 = n + n3;
                dArray2[n7] = dArray[n8] * this.bk1[n7];
                dArray2[n2] = -dArray[n8] * this.bk1[n2];
            }
            CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n3 = 0; n3 < this.nBluestein; ++n3) {
                n7 = 2 * n3;
                n2 = n7 + 1;
                double d = dArray2[n7] * this.bk2[n2] + dArray2[n2] * this.bk2[n7];
                dArray2[n7] = dArray2[n7] * this.bk2[n7] - dArray2[n2] * this.bk2[n2];
                dArray2[n2] = d;
            }
        }
        CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = this.bk1[this.n] * dArray2[this.n] + this.bk1[this.n + 1] * dArray2[this.n + 1];
            for (n3 = 1; n3 < this.n / 2; ++n3) {
                int n9 = 2 * n3;
                n2 = n9 + 1;
                dArray[n + n9] = this.bk1[n9] * dArray2[n9] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n9] + this.bk1[n9] * dArray2[n2];
            }
        } else {
            dArray[n] = this.bk1[0] * dArray2[0] + this.bk1[1] * dArray2[1];
            dArray[n + 1] = -this.bk1[this.n] * dArray2[this.n - 1] + this.bk1[this.n - 1] * dArray2[this.n];
            for (n3 = 1; n3 < (this.n - 1) / 2; ++n3) {
                int n10 = 2 * n3;
                n2 = n10 + 1;
                dArray[n + n10] = this.bk1[n10] * dArray2[n10] + this.bk1[n2] * dArray2[n2];
                dArray[n + n2] = -this.bk1[n2] * dArray2[n10] + this.bk1[n10] * dArray2[n2];
            }
            dArray[n + this.n - 1] = this.bk1[this.n - 1] * dArray2[this.n - 1] + this.bk1[this.n] * dArray2[this.n];
        }
    }

    private void bluestein_real_forward(final A a, final long l) {
        long l2;
        final A a2 = new A(2L * this.nBluesteinl);
        int n = F.A();
        if (n > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            long l3;
            long l4;
            int n2 = 2;
            if (n >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n2 = 4;
            }
            Future[] futureArray = new Future[n2];
            l2 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l2;
                l3 = i == n2 - 1 ? this.nl : l4 + l2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l5 = 2L * i;
                            long l2 = l5 + 1L;
                            long l32 = l + i;
                            a2.B(l5, a.E(l32) * DoubleFFT_1D.this.bk1l.E(l5));
                            a2.B(l2, -a.E(l32) * DoubleFFT_1D.this.bk1l.E(l2));
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
            l2 = this.nBluesteinl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l4 = (long)i * l2;
                l3 = i == n2 - 1 ? this.nBluesteinl : l4 + l2;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l4; i < l3; ++i) {
                            long l = 2L * i;
                            long l2 = l + 1L;
                            double d = a2.E(l) * DoubleFFT_1D.this.bk2l.E(l2) + a2.E(l2) * DoubleFFT_1D.this.bk2l.E(l);
                            a2.B(l, a2.E(l) * DoubleFFT_1D.this.bk2l.E(l) - a2.E(l2) * DoubleFFT_1D.this.bk2l.E(l2));
                            a2.B(l2, d);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l5;
            long l6;
            for (l6 = 0L; l6 < this.nl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                long l7 = l + l6;
                a2.B(l2, a.E(l7) * this.bk1l.E(l2));
                a2.B(l5, -a.E(l7) * this.bk1l.E(l5));
            }
            CommonUtils.cftbsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
            for (l6 = 0L; l6 < this.nBluesteinl; ++l6) {
                l2 = 2L * l6;
                l5 = l2 + 1L;
                double d = a2.E(l2) * this.bk2l.E(l5) + a2.E(l5) * this.bk2l.E(l2);
                a2.B(l2, a2.E(l2) * this.bk2l.E(l2) - a2.E(l5) * this.bk2l.E(l5));
                a2.B(l5, d);
            }
        }
        CommonUtils.cftfsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
        if (this.nl % 2L == 0L) {
            a.B(l, this.bk1l.E(0L) * a2.E(0L) + this.bk1l.E(1L) * a2.E(1L));
            a.B(l + 1L, this.bk1l.E(this.nl) * a2.E(this.nl) + this.bk1l.E(this.nl + 1L) * a2.E(this.nl + 1L));
            for (long i = 1L; i < this.nl / 2L; ++i) {
                l2 = 2L * i;
                long l8 = l2 + 1L;
                a.B(l + l2, this.bk1l.E(l2) * a2.E(l2) + this.bk1l.E(l8) * a2.E(l8));
                a.B(l + l8, -this.bk1l.E(l8) * a2.E(l2) + this.bk1l.E(l2) * a2.E(l8));
            }
        } else {
            a.B(l, this.bk1l.E(0L) * a2.E(0L) + this.bk1l.E(1L) * a2.E(1L));
            a.B(l + 1L, -this.bk1l.E(this.nl) * a2.E(this.nl - 1L) + this.bk1l.E(this.nl - 1L) * a2.E(this.nl));
            for (long i = 1L; i < (this.nl - 1L) / 2L; ++i) {
                l2 = 2L * i;
                long l9 = l2 + 1L;
                a.B(l + l2, this.bk1l.E(l2) * a2.E(l2) + this.bk1l.E(l9) * a2.E(l9));
                a.B(l + l9, -this.bk1l.E(l9) * a2.E(l2) + this.bk1l.E(l2) * a2.E(l9));
            }
            a.B(l + this.nl - 1L, this.bk1l.E(this.nl - 1L) * a2.E(this.nl - 1L) + this.bk1l.E(this.nl) * a2.E(this.nl));
        }
    }

    private void bluestein_real_inverse(final double[] dArray, final int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        final double[] dArray2 = new double[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < this.n / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n] = dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n + 1] = dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = this.n / 2 + 1; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        } else {
            dArray2[0] = dArray[n] * this.bk1[0];
            dArray2[1] = dArray[n] * this.bk1[1];
            for (n6 = 1; n6 < (this.n - 1) / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                dArray2[n5] = dArray[n3] * this.bk1[n5] - dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] + dArray[n2] * this.bk1[n5];
            }
            dArray2[this.n - 1] = dArray[n + this.n - 1] * this.bk1[this.n - 1] - dArray[n + 1] * this.bk1[this.n];
            dArray2[this.n] = dArray[n + this.n - 1] * this.bk1[this.n] + dArray[n + 1] * this.bk1[this.n - 1];
            dArray2[this.n + 1] = dArray[n + this.n - 1] * this.bk1[this.n + 1] + dArray[n + 1] * this.bk1[this.n + 2];
            dArray2[this.n + 2] = dArray[n + this.n - 1] * this.bk1[this.n + 2] - dArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = (this.n - 1) / 2 + 2; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                dArray2[n5] = dArray[n3] * this.bk1[n5] + dArray[n2] * this.bk1[n4];
                dArray2[n4] = dArray[n3] * this.bk1[n4] - dArray[n2] * this.bk1[n5];
            }
        }
        CommonUtils.cftbsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
        n6 = F.A();
        if (n6 > 1 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            int n8;
            n5 = 2;
            if (n6 >= 4 && (long)this.n >= CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n5 = 4;
            }
            Future[] futureArray = new Future[n5];
            n3 = this.nBluestein / n5;
            for (n2 = 0; n2 < n5; ++n2) {
                n8 = n2 * n3;
                n7 = n2 == n5 - 1 ? this.nBluestein : n8 + n3;
                futureArray[n2] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            double d = -dArray2[n] * DoubleFFT_1D.this.bk2[n2] + dArray2[n2] * DoubleFFT_1D.this.bk2[n];
                            dArray2[n] = dArray2[n] * DoubleFFT_1D.this.bk2[n] + dArray2[n2] * DoubleFFT_1D.this.bk2[n2];
                            dArray2[n2] = d;
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            n3 = this.n / n5;
            for (int i = 0; i < n5; ++i) {
                n8 = i * n3;
                n7 = i == n5 - 1 ? this.n : n8 + n3;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n8; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            dArray[n + i] = DoubleFFT_1D.this.bk1[n3] * dArray2[n3] - DoubleFFT_1D.this.bk1[n2] * dArray2[n2];
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            for (n5 = 0; n5 < this.nBluestein; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                double d = -dArray2[n4] * this.bk2[n3] + dArray2[n3] * this.bk2[n4];
                dArray2[n4] = dArray2[n4] * this.bk2[n4] + dArray2[n3] * this.bk2[n3];
                dArray2[n3] = d;
            }
            CommonUtils.cftfsub(2 * this.nBluestein, dArray2, 0, this.ip, this.nw, this.w);
            for (n5 = 0; n5 < this.n; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                dArray[n + n5] = this.bk1[n4] * dArray2[n4] - this.bk1[n3] * dArray2[n3];
            }
        }
    }

    private void bluestein_real_inverse(final A a, final long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        final A a2 = new A(2L * this.nBluesteinl);
        if (this.nl % 2L == 0L) {
            a2.B(0L, a.E(l) * this.bk1l.E(0L));
            a2.B(1L, a.E(l) * this.bk1l.E(1L));
            for (l6 = 1L; l6 < this.nl / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                a2.B(l5, a.E(l3) * this.bk1l.E(l5) - a.E(l2) * this.bk1l.E(l4));
                a2.B(l4, a.E(l3) * this.bk1l.E(l4) + a.E(l2) * this.bk1l.E(l5));
            }
            a2.B(this.nl, a.E(l + 1L) * this.bk1l.E(this.nl));
            a2.B(this.nl + 1L, a.E(l + 1L) * this.bk1l.E(this.nl + 1L));
            for (l6 = this.nl / 2L + 1L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                a2.B(l5, a.E(l3) * this.bk1l.E(l5) + a.E(l2) * this.bk1l.E(l4));
                a2.B(l4, a.E(l3) * this.bk1l.E(l4) - a.E(l2) * this.bk1l.E(l5));
            }
        } else {
            a2.B(0L, a.E(l) * this.bk1l.E(0L));
            a2.B(1L, a.E(l) * this.bk1l.E(1L));
            for (l6 = 1L; l6 < (this.nl - 1L) / 2L; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + l5;
                l2 = l + l4;
                a2.B(l5, a.E(l3) * this.bk1l.E(l5) - a.E(l2) * this.bk1l.E(l4));
                a2.B(l4, a.E(l3) * this.bk1l.E(l4) + a.E(l2) * this.bk1l.E(l5));
            }
            a2.B(this.nl - 1L, a.E(l + this.nl - 1L) * this.bk1l.E(this.nl - 1L) - a.E(l + 1L) * this.bk1l.E(this.nl));
            a2.B(this.nl, a.E(l + this.nl - 1L) * this.bk1l.E(this.nl) + a.E(l + 1L) * this.bk1l.E(this.nl - 1L));
            a2.B(this.nl + 1L, a.E(l + this.nl - 1L) * this.bk1l.E(this.nl + 1L) + a.E(l + 1L) * this.bk1l.E(this.nl + 2L));
            a2.B(this.nl + 2L, a.E(l + this.nl - 1L) * this.bk1l.E(this.nl + 2L) - a.E(l + 1L) * this.bk1l.E(this.nl + 1L));
            for (l6 = (this.nl - 1L) / 2L + 2L; l6 < this.nl; ++l6) {
                l5 = 2L * l6;
                l4 = l5 + 1L;
                l3 = l + 2L * this.nl - l5;
                l2 = l3 + 1L;
                a2.B(l5, a.E(l3) * this.bk1l.E(l5) + a.E(l2) * this.bk1l.E(l4));
                a2.B(l4, a.E(l3) * this.bk1l.E(l4) - a.E(l2) * this.bk1l.E(l5));
            }
        }
        CommonUtils.cftbsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
        int n = F.A();
        if (n > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n2 = 2;
            if (n >= 4 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n2 = 4;
            }
            Future[] futureArray = new Future[n2];
            long l7 = this.nBluesteinl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l3 = (long)i * l7;
                l2 = i == n2 - 1 ? this.nBluesteinl : l3 + l7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l = 2L * i;
                            long l22 = l + 1L;
                            double d = -a2.E(l) * DoubleFFT_1D.this.bk2l.E(l22) + a2.E(l22) * DoubleFFT_1D.this.bk2l.E(l);
                            a2.B(l, a2.E(l) * DoubleFFT_1D.this.bk2l.E(l) + a2.E(l22) * DoubleFFT_1D.this.bk2l.E(l22));
                            a2.B(l22, d);
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
            l7 = this.nl / (long)n2;
            for (int i = 0; i < n2; ++i) {
                l3 = (long)i * l7;
                l2 = i == n2 - 1 ? this.nl : l3 + l7;
                futureArray[i] = F.A(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l3; i < l2; ++i) {
                            long l4 = 2L * i;
                            long l22 = l4 + 1L;
                            a.B(l + i, DoubleFFT_1D.this.bk1l.E(l4) * a2.E(l4) - DoubleFFT_1D.this.bk1l.E(l22) * a2.E(l22));
                        }
                    }
                });
            }
            try {
                F.A(futureArray);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(DoubleFFT_1D.class.getName()).log(Level.SEVERE, null, executionException);
            }
        } else {
            long l8;
            long l9;
            long l10;
            for (l10 = 0L; l10 < this.nBluesteinl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                double d = -a2.E(l9) * this.bk2l.E(l8) + a2.E(l8) * this.bk2l.E(l9);
                a2.B(l9, a2.E(l9) * this.bk2l.E(l9) + a2.E(l8) * this.bk2l.E(l8));
                a2.B(l8, d);
            }
            CommonUtils.cftfsub(2L * this.nBluesteinl, a2, 0L, this.ipl, this.nwl, this.wl);
            for (l10 = 0L; l10 < this.nl; ++l10) {
                l9 = 2L * l10;
                l8 = l9 + 1L;
                a.B(l + l10, this.bk1l.E(l9) * a2.E(l9) - this.bk1l.E(l8) * a2.E(l8));
            }
        }
    }

    void rfftf(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 1;
        int n5 = this.n;
        int n6 = n2 - 1;
        for (int i = 1; i <= n3; ++i) {
            int n7 = n3 - i;
            int n8 = (int)this.wtable_r[n7 + 2 + n2];
            int n9 = n5 / n8;
            int n10 = this.n / n5;
            int n11 = n10 * n9;
            n6 -= (n8 - 1) * n10;
            n4 = 1 - n4;
            switch (n8) {
                case 2: {
                    if (n4 == 0) {
                        this.radf2(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf2(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radf3(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf3(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radf4(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf4(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radf5(n10, n9, dArray, n, dArray2, 0, n6);
                        break;
                    }
                    this.radf5(n10, n9, dArray2, 0, dArray, n, n6);
                    break;
                }
                default: {
                    if (n10 == 1) {
                        n4 = 1 - n4;
                    }
                    if (n4 == 0) {
                        this.radfg(n10, n8, n9, n11, dArray, n, dArray2, 0, n6);
                        n4 = 1;
                        break;
                    }
                    this.radfg(n10, n8, n9, n11, dArray2, 0, dArray, n, n6);
                    n4 = 0;
                }
            }
            n5 = n9;
        }
        if (n4 == 1) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void rfftf(A a, long l) {
        if (this.nl == 1L) {
            return;
        }
        A a2 = new A(this.nl);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.E(1L + l2);
        long l4 = 1L;
        long l5 = this.nl;
        long l6 = l2 - 1L;
        for (long i = 1L; i <= l3; ++i) {
            long l7 = l3 - i;
            int n = (int)this.wtable_rl.E(l7 + 2L + l2);
            long l8 = l5 / (long)n;
            long l9 = this.nl / l5;
            long l10 = l9 * l8;
            l6 -= (long)(n - 1) * l9;
            l4 = 1L - l4;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radf2(l9, l8, a, l, a2, 0L, l6);
                        break;
                    }
                    this.radf2(l9, l8, a2, 0L, a, l, l6);
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radf3(l9, l8, a, l, a2, 0L, l6);
                        break;
                    }
                    this.radf3(l9, l8, a2, 0L, a, l, l6);
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radf4(l9, l8, a, l, a2, 0L, l6);
                        break;
                    }
                    this.radf4(l9, l8, a2, 0L, a, l, l6);
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radf5(l9, l8, a, l, a2, 0L, l6);
                        break;
                    }
                    this.radf5(l9, l8, a2, 0L, a, l, l6);
                    break;
                }
                default: {
                    if (l9 == 1L) {
                        l4 = 1L - l4;
                    }
                    if (l4 == 0L) {
                        this.radfg(l9, (long)n, l8, l10, a, l, a2, 0L, l6);
                        l4 = 1L;
                        break;
                    }
                    this.radfg(l9, (long)n, l8, l10, a2, 0L, a, l, l6);
                    l4 = 0L;
                }
            }
            l5 = l8;
        }
        if (l4 == 1L) {
            return;
        }
        C.A(a2, 0L, a, l, this.nl);
    }

    void rfftb(double[] dArray, int n) {
        if (this.n == 1) {
            return;
        }
        double[] dArray2 = new double[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 0;
        int n5 = 1;
        int n6 = this.n;
        for (int i = 1; i <= n3; ++i) {
            int n7 = (int)this.wtable_r[i + 1 + n2];
            int n8 = n7 * n5;
            int n9 = this.n / n8;
            int n10 = n9 * n5;
            switch (n7) {
                case 2: {
                    if (n4 == 0) {
                        this.radb2(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb2(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radb3(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb3(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radb4(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb4(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radb5(n9, n5, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radb5(n9, n5, dArray2, 0, dArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                default: {
                    if (n4 == 0) {
                        this.radbg(n9, n7, n5, n10, dArray, n, dArray2, 0, n6);
                    } else {
                        this.radbg(n9, n7, n5, n10, dArray2, 0, dArray, n, n6);
                    }
                    if (n9 != 1) break;
                    n4 = 1 - n4;
                }
            }
            n5 = n8;
            n6 += (n7 - 1) * n9;
        }
        if (n4 == 0) {
            return;
        }
        System.arraycopy(dArray2, 0, dArray, n, this.n);
    }

    void rfftb(A a, long l) {
        if (this.nl == 1L) {
            return;
        }
        A a2 = new A(this.nl);
        long l2 = 2L * this.nl;
        long l3 = (long)this.wtable_rl.E(1L + l2);
        long l4 = 0L;
        long l5 = 1L;
        long l6 = this.nl;
        for (long i = 1L; i <= l3; ++i) {
            int n = (int)this.wtable_rl.E(i + 1L + l2);
            long l7 = (long)n * l5;
            long l8 = this.nl / l7;
            long l9 = l8 * l5;
            switch (n) {
                case 2: {
                    if (l4 == 0L) {
                        this.radb2(l8, l5, a, l, a2, 0L, l6);
                    } else {
                        this.radb2(l8, l5, a2, 0L, a, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 3: {
                    if (l4 == 0L) {
                        this.radb3(l8, l5, a, l, a2, 0L, l6);
                    } else {
                        this.radb3(l8, l5, a2, 0L, a, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 4: {
                    if (l4 == 0L) {
                        this.radb4(l8, l5, a, l, a2, 0L, l6);
                    } else {
                        this.radb4(l8, l5, a2, 0L, a, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                case 5: {
                    if (l4 == 0L) {
                        this.radb5(l8, l5, a, l, a2, 0L, l6);
                    } else {
                        this.radb5(l8, l5, a2, 0L, a, l, l6);
                    }
                    l4 = 1L - l4;
                    break;
                }
                default: {
                    if (l4 == 0L) {
                        this.radbg(l8, (long)n, l5, l9, a, l, a2, 0L, l6);
                    } else {
                        this.radbg(l8, (long)n, l5, l9, a2, 0L, a, l, l6);
                    }
                    if (l8 != 1L) break;
                    l4 = 1L - l4;
                }
            }
            l5 = l7;
            l6 += (long)(n - 1) * l8;
        }
        if (l4 == 0L) {
            return;
        }
        C.A(a2, 0L, a, l, this.nl);
    }

    void radf2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n5;
        int n13 = n2 * n;
        int n14 = 2 * n;
        for (n11 = 0; n11 < n2; ++n11) {
            n10 = n4 + n11 * n14;
            n9 = n10 + n14 - 1;
            n8 = n3 + n11 * n;
            n7 = n8 + n13;
            double d = dArray[n8];
            double d2 = dArray[n7];
            dArray2[n10] = d + d2;
            dArray2[n9] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n11 = 0; n11 < n2; ++n11) {
                n14 = n11 * n;
                n6 = 2 * n14;
                int n15 = n6 + n;
                int n16 = n14 + n13;
                for (int i = 2; i < n; i += 2) {
                    int n17 = n - i;
                    n10 = i - 1 + n12;
                    n9 = n4 + i + n6;
                    n8 = n4 + n17 + n15;
                    n7 = n3 + i + n14;
                    int n18 = n3 + i + n16;
                    double d = dArray[n7 - 1];
                    double d3 = dArray[n7];
                    double d4 = dArray[n18 - 1];
                    double d5 = dArray[n18];
                    double d6 = this.wtable_r[n10 - 1];
                    double d7 = this.wtable_r[n10];
                    double d8 = d6 * d4 + d7 * d5;
                    double d9 = d6 * d5 - d7 * d4;
                    dArray2[n9] = d3 + d9;
                    dArray2[n9 - 1] = d + d8;
                    dArray2[n8] = d9 - d3;
                    dArray2[n8 - 1] = d - d8;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        n6 = 2 * n14;
        for (n11 = 0; n11 < n2; ++n11) {
            n14 = n11 * n;
            n10 = n4 + n6 + n;
            n9 = n3 + n - 1 + n14;
            dArray2[n10] = -dArray[n9 + n13];
            dArray2[n10 - 1] = dArray[n9];
        }
    }

    void radf2(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        long l6;
        double d;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12 = l5;
        long l13 = l2 * l;
        long l14 = 2L * l;
        for (l11 = 0L; l11 < l2; ++l11) {
            l10 = l4 + l11 * l14;
            l9 = l10 + l14 - 1L;
            l8 = l3 + l11 * l;
            l7 = l8 + l13;
            double d2 = a.E(l8);
            d = a.E(l7);
            a2.B(l10, d2 + d);
            a2.B(l9, d2 - d);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l11 = 0L; l11 < l2; ++l11) {
                l14 = l11 * l;
                l6 = 2L * l14;
                long l15 = l6 + l;
                long l16 = l14 + l13;
                for (long i = 2L; i < l; i += 2L) {
                    long l17 = l - i;
                    l10 = i - 1L + l12;
                    l9 = l4 + i + l6;
                    l8 = l4 + l17 + l15;
                    l7 = l3 + i + l14;
                    long l18 = l3 + i + l16;
                    d = a.E(l7 - 1L);
                    double d3 = a.E(l7);
                    double d4 = a.E(l18 - 1L);
                    double d5 = a.E(l18);
                    double d6 = this.wtable_rl.E(l10 - 1L);
                    double d7 = this.wtable_rl.E(l10);
                    double d8 = d6 * d4 + d7 * d5;
                    double d9 = d6 * d5 - d7 * d4;
                    a2.B(l9, d3 + d9);
                    a2.B(l9 - 1L, d + d8);
                    a2.B(l8, d9 - d3);
                    a2.B(l8 - 1L, d - d8);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        l6 = 2L * l14;
        for (l11 = 0L; l11 < l2; ++l11) {
            l14 = l11 * l;
            l10 = l4 + l6 + l;
            l9 = l3 + l - 1L + l14;
            a2.B(l10, -a.E(l9 + l13));
            a2.B(l10 - 1L, a.E(l9));
        }
    }

    void radb2(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n10 + n;
            n8 = n4 + n11;
            n7 = n3 + n10;
            n6 = n3 + n - 1 + n9;
            double d = dArray[n7];
            double d2 = dArray[n6];
            dArray2[n8] = d + d2;
            dArray2[n8 + n14] = d - d2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n12 * n;
                n10 = 2 * n11;
                n9 = n10 + n;
                n8 = n11 + n14;
                for (int i = 2; i < n; i += 2) {
                    int n15 = n - i;
                    n7 = i - 1 + n13;
                    n6 = n4 + i;
                    int n16 = n3 + i;
                    int n17 = n3 + n15;
                    double d = this.wtable_r[n7 - 1];
                    double d3 = this.wtable_r[n7];
                    int n18 = n16 + n10;
                    int n19 = n17 + n9;
                    int n20 = n6 + n11;
                    int n21 = n6 + n8;
                    double d4 = dArray[n18 - 1] - dArray[n19 - 1];
                    double d5 = dArray[n18] + dArray[n19];
                    double d6 = dArray[n18];
                    double d7 = dArray[n18 - 1];
                    double d8 = dArray[n19];
                    double d9 = dArray[n19 - 1];
                    dArray2[n20 - 1] = d7 + d9;
                    dArray2[n20] = d6 - d8;
                    dArray2[n21 - 1] = d * d4 - d3 * d5;
                    dArray2[n21] = d * d5 + d3 * d4;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n4 + n - 1 + n11;
            n8 = n3 + n10 + n;
            dArray2[n9] = 2.0 * dArray[n8 - 1];
            dArray2[n9 + n14] = -2.0 * dArray[n8];
        }
    }

    void radb2(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13 = l5;
        long l14 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l10 + l;
            l8 = l4 + l11;
            l7 = l3 + l10;
            l6 = l3 + l - 1L + l9;
            double d = a.E(l7);
            double d2 = a.E(l6);
            a2.B(l8, d + d2);
            a2.B(l8 + l14, d - d2);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l12 = 0L; l12 < l2; ++l12) {
                l11 = l12 * l;
                l10 = 2L * l11;
                l9 = l10 + l;
                l8 = l11 + l14;
                for (long i = 2L; i < l; i += 2L) {
                    long l15 = l - i;
                    l7 = i - 1L + l13;
                    l6 = l4 + i;
                    long l16 = l3 + i;
                    long l17 = l3 + l15;
                    double d = this.wtable_rl.E(l7 - 1L);
                    double d3 = this.wtable_rl.E(l7);
                    long l18 = l16 + l10;
                    long l19 = l17 + l9;
                    long l20 = l6 + l11;
                    long l21 = l6 + l8;
                    double d4 = a.E(l18 - 1L) - a.E(l19 - 1L);
                    double d5 = a.E(l18) + a.E(l19);
                    double d6 = a.E(l18);
                    double d7 = a.E(l18 - 1L);
                    double d8 = a.E(l19);
                    double d9 = a.E(l19 - 1L);
                    a2.B(l20 - 1L, d7 + d9);
                    a2.B(l20, d6 - d8);
                    a2.B(l21 - 1L, d * d4 - d3 * d5);
                    a2.B(l21, d * d5 + d3 * d4);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l11;
            l9 = l4 + l - 1L + l11;
            l8 = l3 + l10 + l;
            a2.B(l9, 2.0 * a.E(l8 - 1L));
            a2.B(l9 + l14, -2.0 * a.E(l8));
        }
    }

    void radf3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        double d2 = -0.5;
        double d3 = 0.8660254037844387;
        int n13 = n5;
        int n14 = n13 + n;
        int n15 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n15;
            n9 = (3 * n12 + 1) * n;
            n8 = n3 + n11;
            n7 = n8 + n15;
            n6 = n8 + n10;
            double d4 = dArray[n8];
            double d5 = dArray[n7];
            double d6 = dArray[n6];
            d = d5 + d6;
            dArray2[n4 + 3 * n11] = d4 + d;
            dArray2[n4 + n9 + n] = 0.8660254037844387 * (d6 - d5);
            dArray2[n4 + n - 1 + n9] = d4 + -0.5 * d;
        }
        if (n == 1) {
            return;
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 3 * n11;
            n9 = n11 + n15;
            n8 = n9 + n15;
            n7 = n10 + n;
            n6 = n7 + n;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = i - 1 + n13;
                int n18 = i - 1 + n14;
                double d7 = this.wtable_r[n17 - 1];
                double d8 = this.wtable_r[n17];
                double d9 = this.wtable_r[n18 - 1];
                double d10 = this.wtable_r[n18];
                int n19 = n3 + i;
                int n20 = n4 + i;
                int n21 = n4 + n16;
                int n22 = n19 + n11;
                int n23 = n19 + n9;
                int n24 = n19 + n8;
                double d11 = dArray[n22 - 1];
                double d12 = dArray[n22];
                double d13 = dArray[n23 - 1];
                double d14 = dArray[n23];
                double d15 = dArray[n24 - 1];
                double d16 = dArray[n24];
                double d17 = d7 * d13 + d8 * d14;
                double d18 = d7 * d14 - d8 * d13;
                double d19 = d9 * d15 + d10 * d16;
                double d20 = d9 * d16 - d10 * d15;
                d = d17 + d19;
                double d21 = d18 + d20;
                double d22 = d11 + -0.5 * d;
                double d23 = d12 + -0.5 * d21;
                double d24 = 0.8660254037844387 * (d18 - d20);
                double d25 = 0.8660254037844387 * (d19 - d17);
                int n25 = n20 + n10;
                int n26 = n21 + n7;
                int n27 = n20 + n6;
                dArray2[n25 - 1] = d11 + d;
                dArray2[n25] = d12 + d21;
                dArray2[n26 - 1] = d22 - d24;
                dArray2[n26] = d25 - d23;
                dArray2[n27 - 1] = d22 + d24;
                dArray2[n27] = d23 + d25;
            }
        }
    }

    void radf3(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        double d2 = -0.5;
        double d3 = 0.8660254037844387;
        long l13 = l5;
        long l14 = l13 + l;
        long l15 = l2 * l;
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 2L * l15;
            l9 = (3L * l12 + 1L) * l;
            l8 = l3 + l11;
            l7 = l8 + l15;
            l6 = l8 + l10;
            double d4 = a.E(l8);
            double d5 = a.E(l7);
            double d6 = a.E(l6);
            d = d5 + d6;
            a2.B(l4 + 3L * l11, d4 + d);
            a2.B(l4 + l9 + l, 0.8660254037844387 * (d6 - d5));
            a2.B(l4 + l - 1L + l9, d4 + -0.5 * d);
        }
        if (l == 1L) {
            return;
        }
        for (l12 = 0L; l12 < l2; ++l12) {
            l11 = l12 * l;
            l10 = 3L * l11;
            l9 = l11 + l15;
            l8 = l9 + l15;
            l7 = l10 + l;
            l6 = l7 + l;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = i - 1L + l13;
                long l18 = i - 1L + l14;
                double d7 = this.wtable_rl.E(l17 - 1L);
                double d8 = this.wtable_rl.E(l17);
                double d9 = this.wtable_rl.E(l18 - 1L);
                double d10 = this.wtable_rl.E(l18);
                long l19 = l3 + i;
                long l20 = l4 + i;
                long l21 = l4 + l16;
                long l22 = l19 + l11;
                long l23 = l19 + l9;
                long l24 = l19 + l8;
                double d11 = a.E(l22 - 1L);
                double d12 = a.E(l22);
                double d13 = a.E(l23 - 1L);
                double d14 = a.E(l23);
                double d15 = a.E(l24 - 1L);
                double d16 = a.E(l24);
                double d17 = d7 * d13 + d8 * d14;
                double d18 = d7 * d14 - d8 * d13;
                double d19 = d9 * d15 + d10 * d16;
                double d20 = d9 * d16 - d10 * d15;
                d = d17 + d19;
                double d21 = d18 + d20;
                double d22 = d11 + -0.5 * d;
                double d23 = d12 + -0.5 * d21;
                double d24 = 0.8660254037844387 * (d18 - d20);
                double d25 = 0.8660254037844387 * (d19 - d17);
                long l25 = l20 + l10;
                long l26 = l21 + l7;
                long l27 = l20 + l6;
                a2.B(l25 - 1L, d11 + d);
                a2.B(l25, d12 + d21);
                a2.B(l26 - 1L, d22 - d24);
                a2.B(l26, d25 - d23);
                a2.B(l27 - 1L, d22 + d24);
                a2.B(l27, d23 + d25);
            }
        }
    }

    void radb3(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        int n6;
        int n7;
        int n8;
        int n9;
        double d4 = -0.5;
        double d5 = 0.8660254037844387;
        int n10 = n5;
        int n11 = n10 + n;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = n9 * n;
            n7 = n3 + 3 * n8;
            n6 = n7 + 2 * n;
            double d6 = dArray[n7];
            d3 = 2.0 * dArray[n6 - 1];
            d2 = d6 + -0.5 * d3;
            d = 1.7320508075688774 * dArray[n6];
            dArray2[n4 + n8] = d6 + d3;
            dArray2[n4 + (n9 + n2) * n] = d2 - d;
            dArray2[n4 + (n9 + 2 * n2) * n] = d2 + d;
        }
        if (n == 1) {
            return;
        }
        n9 = n2 * n;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n8 * n;
            n6 = 3 * n7;
            int n12 = n6 + n;
            int n13 = n12 + n;
            int n14 = n7 + n9;
            int n15 = n14 + n9;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = n3 + i;
                int n18 = n3 + n16;
                int n19 = n4 + i;
                int n20 = n17 + n6;
                int n21 = n17 + n13;
                int n22 = n18 + n12;
                double d7 = dArray[n20 - 1];
                double d8 = dArray[n20];
                double d9 = dArray[n21 - 1];
                double d10 = dArray[n21];
                double d11 = dArray[n22 - 1];
                double d12 = dArray[n22];
                d3 = d9 + d11;
                d2 = d7 + -0.5 * d3;
                double d13 = d10 - d12;
                double d14 = d8 + -0.5 * d13;
                double d15 = 0.8660254037844387 * (d9 - d11);
                d = 0.8660254037844387 * (d10 + d12);
                double d16 = d2 - d;
                double d17 = d2 + d;
                double d18 = d14 + d15;
                double d19 = d14 - d15;
                int n23 = i - 1 + n10;
                int n24 = i - 1 + n11;
                double d20 = this.wtable_r[n23 - 1];
                double d21 = this.wtable_r[n23];
                double d22 = this.wtable_r[n24 - 1];
                double d23 = this.wtable_r[n24];
                int n25 = n19 + n7;
                int n26 = n19 + n14;
                int n27 = n19 + n15;
                dArray2[n25 - 1] = d7 + d3;
                dArray2[n25] = d8 + d13;
                dArray2[n26 - 1] = d20 * d16 - d21 * d18;
                dArray2[n26] = d20 * d18 + d21 * d16;
                dArray2[n27 - 1] = d22 * d17 - d23 * d19;
                dArray2[n27] = d22 * d19 + d23 * d17;
            }
        }
    }

    void radb3(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        long l6;
        long l7;
        long l8;
        long l9;
        double d4 = -0.5;
        double d5 = 0.8660254037844387;
        long l10 = l5;
        long l11 = l10 + l;
        for (l9 = 0L; l9 < l2; ++l9) {
            l8 = l9 * l;
            l7 = l3 + 3L * l8;
            l6 = l7 + 2L * l;
            double d6 = a.E(l7);
            d3 = 2.0 * a.E(l6 - 1L);
            d2 = d6 + -0.5 * d3;
            d = 1.7320508075688774 * a.E(l6);
            a2.B(l4 + l8, d6 + d3);
            a2.B(l4 + (l9 + l2) * l, d2 - d);
            a2.B(l4 + (l9 + 2L * l2) * l, d2 + d);
        }
        if (l == 1L) {
            return;
        }
        l9 = l2 * l;
        for (l8 = 0L; l8 < l2; ++l8) {
            l7 = l8 * l;
            l6 = 3L * l7;
            long l12 = l6 + l;
            long l13 = l12 + l;
            long l14 = l7 + l9;
            long l15 = l14 + l9;
            for (long i = 2L; i < l; i += 2L) {
                long l16 = l - i;
                long l17 = l3 + i;
                long l18 = l3 + l16;
                long l19 = l4 + i;
                long l20 = l17 + l6;
                long l21 = l17 + l13;
                long l22 = l18 + l12;
                double d7 = a.E(l20 - 1L);
                double d8 = a.E(l20);
                double d9 = a.E(l21 - 1L);
                double d10 = a.E(l21);
                double d11 = a.E(l22 - 1L);
                double d12 = a.E(l22);
                d3 = d9 + d11;
                d2 = d7 + -0.5 * d3;
                double d13 = d10 - d12;
                double d14 = d8 + -0.5 * d13;
                double d15 = 0.8660254037844387 * (d9 - d11);
                d = 0.8660254037844387 * (d10 + d12);
                double d16 = d2 - d;
                double d17 = d2 + d;
                double d18 = d14 + d15;
                double d19 = d14 - d15;
                long l23 = i - 1L + l10;
                long l24 = i - 1L + l11;
                double d20 = this.wtable_rl.E(l23 - 1L);
                double d21 = this.wtable_rl.E(l23);
                double d22 = this.wtable_rl.E(l24 - 1L);
                double d23 = this.wtable_rl.E(l24);
                long l25 = l19 + l7;
                long l26 = l19 + l14;
                long l27 = l19 + l15;
                a2.B(l25 - 1L, d7 + d3);
                a2.B(l25, d8 + d13);
                a2.B(l26 - 1L, d20 * d16 - d21 * d18);
                a2.B(l26, d20 * d18 + d21 * d16);
                a2.B(l27 - 1L, d22 * d17 - d23 * d19);
                a2.B(l27, d22 * d19 + d23 * d17);
            }
        }
    }

    void radf4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        int n6;
        int n7;
        int n8;
        int n9;
        double d2;
        double d3;
        double d4;
        double d5;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        double d6 = 0.7071067811865476;
        int n17 = n5;
        int n18 = n5 + n;
        int n19 = n18 + n;
        int n20 = n2 * n;
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            double d7 = dArray[n3 + n15];
            double d8 = dArray[n3 + n13];
            d5 = dArray[n3 + n12];
            d4 = dArray[n3 + n11];
            d3 = d8 + d4;
            d2 = d7 + d5;
            n9 = n4 + n14;
            n8 = n4 + n10 + n;
            dArray2[n9] = d3 + d2;
            dArray2[n8 - 1 + n + n] = d2 - d3;
            dArray2[n8 - 1] = d7 - d5;
            dArray2[n8] = d4 - d8;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n16 = 0; n16 < n2; ++n16) {
                n15 = n16 * n;
                n14 = n15 + n20;
                n13 = n14 + n20;
                n12 = n13 + n20;
                n11 = 4 * n15;
                n10 = n11 + n;
                int n21 = n10 + n;
                n7 = n21 + n;
                for (int i = 2; i < n; i += 2) {
                    int n22 = n - i;
                    int n23 = i - 1 + n17;
                    n6 = i - 1 + n18;
                    int n24 = i - 1 + n19;
                    double d9 = this.wtable_r[n23 - 1];
                    double d10 = this.wtable_r[n23];
                    double d11 = this.wtable_r[n6 - 1];
                    double d12 = this.wtable_r[n6];
                    double d13 = this.wtable_r[n24 - 1];
                    double d14 = this.wtable_r[n24];
                    int n25 = n3 + i;
                    int n26 = n4 + i;
                    int n27 = n4 + n22;
                    n9 = n25 + n15;
                    n8 = n25 + n14;
                    int n28 = n25 + n13;
                    int n29 = n25 + n12;
                    double d15 = dArray[n9 - 1];
                    double d16 = dArray[n9];
                    double d17 = dArray[n8 - 1];
                    double d18 = dArray[n8];
                    double d19 = dArray[n28 - 1];
                    double d20 = dArray[n28];
                    double d21 = dArray[n29 - 1];
                    double d22 = dArray[n29];
                    double d23 = d9 * d17 + d10 * d18;
                    double d24 = d9 * d18 - d10 * d17;
                    double d25 = d11 * d19 + d12 * d20;
                    double d26 = d11 * d20 - d12 * d19;
                    double d27 = d13 * d21 + d14 * d22;
                    double d28 = d13 * d22 - d14 * d21;
                    d3 = d23 + d27;
                    double d29 = d27 - d23;
                    d = d24 + d28;
                    double d30 = d24 - d28;
                    double d31 = d16 + d26;
                    double d32 = d16 - d26;
                    d2 = d15 + d25;
                    double d33 = d15 - d25;
                    int n30 = n26 + n11;
                    int n31 = n27 + n10;
                    int n32 = n26 + n21;
                    int n33 = n27 + n7;
                    dArray2[n30 - 1] = d3 + d2;
                    dArray2[n33 - 1] = d2 - d3;
                    dArray2[n30] = d + d31;
                    dArray2[n33] = d - d31;
                    dArray2[n32 - 1] = d30 + d33;
                    dArray2[n31 - 1] = d33 - d30;
                    dArray2[n32] = d29 + d32;
                    dArray2[n31] = d29 - d32;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n16 = 0; n16 < n2; ++n16) {
            n15 = n16 * n;
            n14 = 4 * n15;
            n13 = n15 + n20;
            n12 = n13 + n20;
            n11 = n12 + n20;
            n10 = n14 + n;
            int n34 = n10 + n;
            n7 = n34 + n;
            int n35 = n3 + n;
            n6 = n4 + n;
            d5 = dArray[n35 - 1 + n15];
            d4 = dArray[n35 - 1 + n13];
            double d34 = dArray[n35 - 1 + n12];
            double d35 = dArray[n35 - 1 + n11];
            d = -0.7071067811865476 * (d4 + d35);
            d3 = 0.7071067811865476 * (d4 - d35);
            dArray2[n6 - 1 + n14] = d3 + d5;
            dArray2[n6 - 1 + n34] = d5 - d3;
            dArray2[n4 + n10] = d - d34;
            dArray2[n4 + n7] = d + d34;
        }
    }

    void radf4(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        long l6;
        long l7;
        double d2;
        double d3;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        double d4 = 0.7071067811865476;
        long l15 = l5;
        long l16 = l5 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            double d5 = a.E(l3 + l13);
            double d6 = a.E(l3 + l11);
            double d7 = a.E(l3 + l10);
            double d8 = a.E(l3 + l9);
            d3 = d6 + d8;
            d2 = d5 + d7;
            l7 = l4 + l12;
            l6 = l4 + l8 + l;
            a2.B(l7, d3 + d2);
            a2.B(l6 - 1L + l + l, d2 - d3);
            a2.B(l6 - 1L, d5 - d7);
            a2.B(l6, d8 - d6);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                long l19 = l8 + l;
                long l20 = l19 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l21 = l - i;
                    long l22 = i - 1L + l15;
                    long l23 = i - 1L + l16;
                    l7 = i - 1L + l17;
                    double d9 = this.wtable_rl.E(l22 - 1L);
                    double d10 = this.wtable_rl.E(l22);
                    double d11 = this.wtable_rl.E(l23 - 1L);
                    double d12 = this.wtable_rl.E(l23);
                    double d13 = this.wtable_rl.E(l7 - 1L);
                    double d14 = this.wtable_rl.E(l7);
                    l6 = l3 + i;
                    long l24 = l4 + i;
                    long l25 = l4 + l21;
                    long l26 = l6 + l13;
                    long l27 = l6 + l12;
                    long l28 = l6 + l11;
                    long l29 = l6 + l10;
                    double d15 = a.E(l26 - 1L);
                    double d16 = a.E(l26);
                    double d17 = a.E(l27 - 1L);
                    double d18 = a.E(l27);
                    double d19 = a.E(l28 - 1L);
                    double d20 = a.E(l28);
                    double d21 = a.E(l29 - 1L);
                    double d22 = a.E(l29);
                    double d23 = d9 * d17 + d10 * d18;
                    double d24 = d9 * d18 - d10 * d17;
                    double d25 = d11 * d19 + d12 * d20;
                    double d26 = d11 * d20 - d12 * d19;
                    double d27 = d13 * d21 + d14 * d22;
                    double d28 = d13 * d22 - d14 * d21;
                    d3 = d23 + d27;
                    double d29 = d27 - d23;
                    d = d24 + d28;
                    double d30 = d24 - d28;
                    double d31 = d16 + d26;
                    double d32 = d16 - d26;
                    d2 = d15 + d25;
                    double d33 = d15 - d25;
                    long l30 = l24 + l9;
                    long l31 = l25 + l8;
                    long l32 = l24 + l19;
                    long l33 = l25 + l20;
                    a2.B(l30 - 1L, d3 + d2);
                    a2.B(l33 - 1L, d2 - d3);
                    a2.B(l30, d + d31);
                    a2.B(l33, d - d31);
                    a2.B(l32 - 1L, d30 + d33);
                    a2.B(l31 - 1L, d33 - d30);
                    a2.B(l32, d29 + d32);
                    a2.B(l31, d29 - d32);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            long l34 = l8 + l;
            long l35 = l34 + l;
            long l36 = l3 + l;
            long l37 = l4 + l;
            double d34 = a.E(l36 - 1L + l13);
            double d35 = a.E(l36 - 1L + l11);
            double d36 = a.E(l36 - 1L + l10);
            double d37 = a.E(l36 - 1L + l9);
            d = -0.7071067811865476 * (d35 + d37);
            d3 = 0.7071067811865476 * (d35 - d37);
            a2.B(l37 - 1L + l12, d3 + d34);
            a2.B(l37 - 1L + l34, d34 - d3);
            a2.B(l4 + l8, d - d36);
            a2.B(l4 + l35, d + d36);
        }
    }

    void radb4(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        int n6;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        double d10 = 1.4142135623730951;
        int n16 = n5;
        int n17 = n16 + n;
        int n18 = n17 + n;
        int n19 = n2 * n;
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            double d11 = dArray[n3 + n13];
            d9 = dArray[n3 + n8];
            d8 = dArray[n3 + n - 1 + n7];
            d7 = dArray[n3 + n - 1 + n9];
            d6 = d11 - d8;
            d5 = d11 + d8;
            d4 = d7 + d7;
            d3 = d9 + d9;
            dArray2[n4 + n14] = d5 + d4;
            dArray2[n4 + n12] = d6 - d3;
            dArray2[n4 + n11] = d5 - d4;
            dArray2[n4 + n10] = d6 + d3;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n15 = 0; n15 < n2; ++n15) {
                n14 = n15 * n;
                n13 = n14 + n19;
                n12 = n13 + n19;
                n11 = n12 + n19;
                n10 = 4 * n14;
                n9 = n10 + n;
                n8 = n9 + n;
                n7 = n8 + n;
                for (int i = 2; i < n; i += 2) {
                    int n20 = n - i;
                    int n21 = i - 1 + n16;
                    n6 = i - 1 + n17;
                    int n22 = i - 1 + n18;
                    double d12 = this.wtable_r[n21 - 1];
                    double d13 = this.wtable_r[n21];
                    double d14 = this.wtable_r[n6 - 1];
                    double d15 = this.wtable_r[n6];
                    double d16 = this.wtable_r[n22 - 1];
                    double d17 = this.wtable_r[n22];
                    int n23 = n3 + i;
                    int n24 = n3 + n20;
                    int n25 = n4 + i;
                    int n26 = n23 + n10;
                    int n27 = n24 + n9;
                    int n28 = n23 + n8;
                    int n29 = n24 + n7;
                    double d18 = dArray[n26 - 1];
                    double d19 = dArray[n26];
                    double d20 = dArray[n27 - 1];
                    double d21 = dArray[n27];
                    double d22 = dArray[n28 - 1];
                    double d23 = dArray[n28];
                    double d24 = dArray[n29 - 1];
                    double d25 = dArray[n29];
                    d2 = d19 + d25;
                    d = d19 - d25;
                    double d26 = d23 - d21;
                    d3 = d23 + d21;
                    d6 = d18 - d24;
                    d5 = d18 + d24;
                    double d27 = d22 - d20;
                    d4 = d22 + d20;
                    double d28 = d5 - d4;
                    double d29 = d - d26;
                    double d30 = d6 - d3;
                    double d31 = d6 + d3;
                    double d32 = d2 + d27;
                    double d33 = d2 - d27;
                    int n30 = n25 + n14;
                    int n31 = n25 + n13;
                    int n32 = n25 + n12;
                    int n33 = n25 + n11;
                    dArray2[n30 - 1] = d5 + d4;
                    dArray2[n30] = d + d26;
                    dArray2[n31 - 1] = d12 * d30 - d13 * d32;
                    dArray2[n31] = d12 * d32 + d13 * d30;
                    dArray2[n32 - 1] = d14 * d28 - d15 * d29;
                    dArray2[n32] = d14 * d29 + d15 * d28;
                    dArray2[n33 - 1] = d16 * d31 - d17 * d33;
                    dArray2[n33] = d16 * d33 + d17 * d31;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n15 = 0; n15 < n2; ++n15) {
            n14 = n15 * n;
            n13 = 4 * n14;
            n12 = n14 + n19;
            n11 = n12 + n19;
            n10 = n11 + n19;
            n9 = n13 + n;
            n8 = n9 + n;
            n7 = n8 + n;
            int n34 = n3 + n;
            n6 = n4 + n;
            d9 = dArray[n34 - 1 + n13];
            d8 = dArray[n34 - 1 + n8];
            d7 = dArray[n3 + n9];
            double d34 = dArray[n3 + n7];
            d2 = d7 + d34;
            d = d34 - d7;
            d6 = d9 - d8;
            d5 = d9 + d8;
            dArray2[n6 - 1 + n14] = d5 + d5;
            dArray2[n6 - 1 + n12] = 1.4142135623730951 * (d6 - d2);
            dArray2[n6 - 1 + n11] = d + d;
            dArray2[n6 - 1 + n10] = -1.4142135623730951 * (d6 + d2);
        }
    }

    void radb4(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        double d9 = 1.4142135623730951;
        long l15 = l5;
        long l16 = l15 + l;
        long l17 = l16 + l;
        long l18 = l2 * l;
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            double d10 = a.E(l3 + l12);
            double d11 = a.E(l3 + l7);
            d8 = a.E(l3 + l - 1L + l6);
            d7 = a.E(l3 + l - 1L + l8);
            d6 = d10 - d8;
            d5 = d10 + d8;
            d4 = d7 + d7;
            d3 = d11 + d11;
            a2.B(l4 + l13, d5 + d4);
            a2.B(l4 + l11, d6 - d3);
            a2.B(l4 + l10, d5 - d4);
            a2.B(l4 + l9, d6 + d3);
        }
        if (l < 2L) {
            return;
        }
        if (l != 2L) {
            for (l14 = 0L; l14 < l2; ++l14) {
                l13 = l14 * l;
                l12 = l13 + l18;
                l11 = l12 + l18;
                l10 = l11 + l18;
                l9 = 4L * l13;
                l8 = l9 + l;
                l7 = l8 + l;
                l6 = l7 + l;
                for (long i = 2L; i < l; i += 2L) {
                    long l19 = l - i;
                    long l20 = i - 1L + l15;
                    long l21 = i - 1L + l16;
                    long l22 = i - 1L + l17;
                    double d12 = this.wtable_rl.E(l20 - 1L);
                    double d13 = this.wtable_rl.E(l20);
                    double d14 = this.wtable_rl.E(l21 - 1L);
                    double d15 = this.wtable_rl.E(l21);
                    double d16 = this.wtable_rl.E(l22 - 1L);
                    double d17 = this.wtable_rl.E(l22);
                    long l23 = l3 + i;
                    long l24 = l3 + l19;
                    long l25 = l4 + i;
                    long l26 = l23 + l9;
                    long l27 = l24 + l8;
                    long l28 = l23 + l7;
                    long l29 = l24 + l6;
                    double d18 = a.E(l26 - 1L);
                    double d19 = a.E(l26);
                    double d20 = a.E(l27 - 1L);
                    double d21 = a.E(l27);
                    double d22 = a.E(l28 - 1L);
                    double d23 = a.E(l28);
                    double d24 = a.E(l29 - 1L);
                    double d25 = a.E(l29);
                    d2 = d19 + d25;
                    d = d19 - d25;
                    double d26 = d23 - d21;
                    d3 = d23 + d21;
                    d6 = d18 - d24;
                    d5 = d18 + d24;
                    double d27 = d22 - d20;
                    d4 = d22 + d20;
                    double d28 = d5 - d4;
                    double d29 = d - d26;
                    double d30 = d6 - d3;
                    double d31 = d6 + d3;
                    double d32 = d2 + d27;
                    double d33 = d2 - d27;
                    long l30 = l25 + l13;
                    long l31 = l25 + l12;
                    long l32 = l25 + l11;
                    long l33 = l25 + l10;
                    a2.B(l30 - 1L, d5 + d4);
                    a2.B(l30, d + d26);
                    a2.B(l31 - 1L, d12 * d30 - d13 * d32);
                    a2.B(l31, d12 * d32 + d13 * d30);
                    a2.B(l32 - 1L, d14 * d28 - d15 * d29);
                    a2.B(l32, d14 * d29 + d15 * d28);
                    a2.B(l33 - 1L, d16 * d31 - d17 * d33);
                    a2.B(l33, d16 * d33 + d17 * d31);
                }
            }
            if (l % 2L == 1L) {
                return;
            }
        }
        for (l14 = 0L; l14 < l2; ++l14) {
            l13 = l14 * l;
            l12 = 4L * l13;
            l11 = l13 + l18;
            l10 = l11 + l18;
            l9 = l10 + l18;
            l8 = l12 + l;
            l7 = l8 + l;
            l6 = l7 + l;
            long l34 = l3 + l;
            long l35 = l4 + l;
            d8 = a.E(l34 - 1L + l12);
            d7 = a.E(l34 - 1L + l7);
            double d34 = a.E(l3 + l8);
            double d35 = a.E(l3 + l6);
            d2 = d34 + d35;
            d = d35 - d34;
            d6 = d8 - d7;
            d5 = d8 + d7;
            a2.B(l35 - 1L + l13, d5 + d5);
            a2.B(l35 - 1L + l11, 1.4142135623730951 * (d6 - d2));
            a2.B(l35 - 1L + l10, d + d);
            a2.B(l35 - 1L + l9, -1.4142135623730951 * (d6 + d2));
        }
    }

    void radf5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        double d5 = 0.30901699437494745;
        double d6 = 0.9510565162951535;
        double d7 = -0.8090169943749473;
        double d8 = 0.5877852522924732;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n4 + n - 1;
            double d9 = dArray[n3 + n16];
            double d10 = dArray[n3 + n10];
            double d11 = dArray[n3 + n9];
            double d12 = dArray[n3 + n8];
            double d13 = dArray[n3 + n7];
            d4 = d13 + d10;
            d3 = d13 - d10;
            d2 = d12 + d11;
            d = d12 - d11;
            dArray2[n4 + n15] = d9 + d4 + d2;
            dArray2[n6 + n14] = d9 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
            dArray2[n4 + n13] = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
            dArray2[n6 + n12] = d9 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
            dArray2[n4 + n11] = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                n6 = i - 1 + n18;
                int n23 = i - 1 + n19;
                int n24 = i - 1 + n20;
                int n25 = i - 1 + n21;
                double d14 = this.wtable_r[n6 - 1];
                double d15 = this.wtable_r[n6];
                double d16 = this.wtable_r[n23 - 1];
                double d17 = this.wtable_r[n23];
                double d18 = this.wtable_r[n24 - 1];
                double d19 = this.wtable_r[n24];
                double d20 = this.wtable_r[n25 - 1];
                double d21 = this.wtable_r[n25];
                int n26 = n - i;
                int n27 = n3 + i;
                int n28 = n4 + i;
                int n29 = n4 + n26;
                int n30 = n27 + n16;
                int n31 = n27 + n10;
                int n32 = n27 + n9;
                int n33 = n27 + n8;
                int n34 = n27 + n7;
                double d22 = dArray[n30 - 1];
                double d23 = dArray[n30];
                double d24 = dArray[n31 - 1];
                double d25 = dArray[n31];
                double d26 = dArray[n32 - 1];
                double d27 = dArray[n32];
                double d28 = dArray[n33 - 1];
                double d29 = dArray[n33];
                double d30 = dArray[n34 - 1];
                double d31 = dArray[n34];
                double d32 = d14 * d24 + d15 * d25;
                double d33 = d14 * d25 - d15 * d24;
                double d34 = d16 * d26 + d17 * d27;
                double d35 = d16 * d27 - d17 * d26;
                double d36 = d18 * d28 + d19 * d29;
                double d37 = d18 * d29 - d19 * d28;
                double d38 = d20 * d30 + d21 * d31;
                double d39 = d20 * d31 - d21 * d30;
                d4 = d32 + d38;
                d3 = d38 - d32;
                double d40 = d33 - d39;
                double d41 = d33 + d39;
                d2 = d34 + d36;
                d = d36 - d34;
                double d42 = d35 - d37;
                double d43 = d35 + d37;
                double d44 = d22 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
                double d45 = d23 + 0.30901699437494745 * d41 + -0.8090169943749473 * d43;
                double d46 = d22 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
                double d47 = d23 + -0.8090169943749473 * d41 + 0.30901699437494745 * d43;
                double d48 = 0.9510565162951535 * d40 + 0.5877852522924732 * d42;
                double d49 = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
                double d50 = 0.5877852522924732 * d40 - 0.9510565162951535 * d42;
                double d51 = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
                int n35 = n28 + n15;
                int n36 = n29 + n14;
                int n37 = n28 + n13;
                int n38 = n29 + n12;
                int n39 = n28 + n11;
                dArray2[n35 - 1] = d22 + d4 + d2;
                dArray2[n35] = d23 + d41 + d43;
                dArray2[n37 - 1] = d44 + d48;
                dArray2[n36 - 1] = d44 - d48;
                dArray2[n37] = d45 + d49;
                dArray2[n36] = d49 - d45;
                dArray2[n39 - 1] = d46 + d50;
                dArray2[n38 - 1] = d46 - d50;
                dArray2[n39] = d47 + d51;
                dArray2[n38] = d51 - d47;
            }
        }
    }

    void radf5(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        double d5 = 0.30901699437494745;
        double d6 = 0.9510565162951535;
        double d7 = -0.8090169943749473;
        double d8 = 0.5877852522924732;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l4 + l - 1L;
            double d9 = a.E(l3 + l16);
            double d10 = a.E(l3 + l10);
            double d11 = a.E(l3 + l9);
            double d12 = a.E(l3 + l8);
            double d13 = a.E(l3 + l7);
            d4 = d13 + d10;
            d3 = d13 - d10;
            d2 = d12 + d11;
            d = d12 - d11;
            a2.B(l4 + l15, d9 + d4 + d2);
            a2.B(l6 + l14, d9 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2);
            a2.B(l4 + l13, 0.9510565162951535 * d3 + 0.5877852522924732 * d);
            a2.B(l6 + l12, d9 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2);
            a2.B(l4 + l11, 0.5877852522924732 * d3 - 0.9510565162951535 * d);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                l6 = i - 1L + l18;
                long l23 = i - 1L + l19;
                long l24 = i - 1L + l20;
                long l25 = i - 1L + l21;
                double d14 = this.wtable_rl.E(l6 - 1L);
                double d15 = this.wtable_rl.E(l6);
                double d16 = this.wtable_rl.E(l23 - 1L);
                double d17 = this.wtable_rl.E(l23);
                double d18 = this.wtable_rl.E(l24 - 1L);
                double d19 = this.wtable_rl.E(l24);
                double d20 = this.wtable_rl.E(l25 - 1L);
                double d21 = this.wtable_rl.E(l25);
                long l26 = l - i;
                long l27 = l3 + i;
                long l28 = l4 + i;
                long l29 = l4 + l26;
                long l30 = l27 + l16;
                long l31 = l27 + l10;
                long l32 = l27 + l9;
                long l33 = l27 + l8;
                long l34 = l27 + l7;
                double d22 = a.E(l30 - 1L);
                double d23 = a.E(l30);
                double d24 = a.E(l31 - 1L);
                double d25 = a.E(l31);
                double d26 = a.E(l32 - 1L);
                double d27 = a.E(l32);
                double d28 = a.E(l33 - 1L);
                double d29 = a.E(l33);
                double d30 = a.E(l34 - 1L);
                double d31 = a.E(l34);
                double d32 = d14 * d24 + d15 * d25;
                double d33 = d14 * d25 - d15 * d24;
                double d34 = d16 * d26 + d17 * d27;
                double d35 = d16 * d27 - d17 * d26;
                double d36 = d18 * d28 + d19 * d29;
                double d37 = d18 * d29 - d19 * d28;
                double d38 = d20 * d30 + d21 * d31;
                double d39 = d20 * d31 - d21 * d30;
                d4 = d32 + d38;
                d3 = d38 - d32;
                double d40 = d33 - d39;
                double d41 = d33 + d39;
                d2 = d34 + d36;
                d = d36 - d34;
                double d42 = d35 - d37;
                double d43 = d35 + d37;
                double d44 = d22 + 0.30901699437494745 * d4 + -0.8090169943749473 * d2;
                double d45 = d23 + 0.30901699437494745 * d41 + -0.8090169943749473 * d43;
                double d46 = d22 + -0.8090169943749473 * d4 + 0.30901699437494745 * d2;
                double d47 = d23 + -0.8090169943749473 * d41 + 0.30901699437494745 * d43;
                double d48 = 0.9510565162951535 * d40 + 0.5877852522924732 * d42;
                double d49 = 0.9510565162951535 * d3 + 0.5877852522924732 * d;
                double d50 = 0.5877852522924732 * d40 - 0.9510565162951535 * d42;
                double d51 = 0.5877852522924732 * d3 - 0.9510565162951535 * d;
                long l35 = l28 + l15;
                long l36 = l29 + l14;
                long l37 = l28 + l13;
                long l38 = l29 + l12;
                long l39 = l28 + l11;
                a2.B(l35 - 1L, d22 + d4 + d2);
                a2.B(l35, d23 + d41 + d43);
                a2.B(l37 - 1L, d44 + d48);
                a2.B(l36 - 1L, d44 - d48);
                a2.B(l37, d45 + d49);
                a2.B(l36, d49 - d45);
                a2.B(l39 - 1L, d46 + d50);
                a2.B(l38 - 1L, d46 - d50);
                a2.B(l39, d47 + d51);
                a2.B(l38, d51 - d47);
            }
        }
    }

    void radb5(int n, int n2, double[] dArray, int n3, double[] dArray2, int n4, int n5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        double d9 = 0.30901699437494745;
        double d10 = 0.9510565162951535;
        double d11 = -0.8090169943749473;
        double d12 = 0.5877852522924732;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n3 + n - 1;
            double d13 = dArray[n3 + n15];
            d8 = 2.0 * dArray[n3 + n13];
            d7 = 2.0 * dArray[n3 + n11];
            d6 = 2.0 * dArray[n6 + n14];
            d5 = 2.0 * dArray[n6 + n12];
            d4 = d13 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
            d3 = d13 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
            d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
            d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
            dArray2[n4 + n16] = d13 + d6 + d5;
            dArray2[n4 + n10] = d4 - d2;
            dArray2[n4 + n9] = d3 - d;
            dArray2[n4 + n8] = d3 + d;
            dArray2[n4 + n7] = d4 + d2;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                int n23 = n - i;
                n6 = i - 1 + n18;
                int n24 = i - 1 + n19;
                int n25 = i - 1 + n20;
                int n26 = i - 1 + n21;
                double d14 = this.wtable_r[n6 - 1];
                double d15 = this.wtable_r[n6];
                double d16 = this.wtable_r[n24 - 1];
                double d17 = this.wtable_r[n24];
                double d18 = this.wtable_r[n25 - 1];
                double d19 = this.wtable_r[n25];
                double d20 = this.wtable_r[n26 - 1];
                double d21 = this.wtable_r[n26];
                int n27 = n3 + i;
                int n28 = n3 + n23;
                int n29 = n4 + i;
                int n30 = n27 + n15;
                int n31 = n28 + n14;
                int n32 = n27 + n13;
                int n33 = n28 + n12;
                int n34 = n27 + n11;
                double d22 = dArray[n30 - 1];
                double d23 = dArray[n30];
                double d24 = dArray[n31 - 1];
                double d25 = dArray[n31];
                double d26 = dArray[n32 - 1];
                double d27 = dArray[n32];
                double d28 = dArray[n33 - 1];
                double d29 = dArray[n33];
                double d30 = dArray[n34 - 1];
                double d31 = dArray[n34];
                d8 = d27 + d25;
                double d32 = d27 - d25;
                d7 = d31 + d29;
                double d33 = d31 - d29;
                double d34 = d26 - d24;
                d6 = d26 + d24;
                double d35 = d30 - d28;
                d5 = d30 + d28;
                d4 = d22 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
                double d36 = d23 + 0.30901699437494745 * d32 + -0.8090169943749473 * d33;
                d3 = d22 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
                double d37 = d23 + -0.8090169943749473 * d32 + 0.30901699437494745 * d33;
                double d38 = 0.9510565162951535 * d34 + 0.5877852522924732 * d35;
                d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
                double d39 = 0.5877852522924732 * d34 - 0.9510565162951535 * d35;
                d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
                double d40 = d3 - d;
                double d41 = d3 + d;
                double d42 = d37 + d39;
                double d43 = d37 - d39;
                double d44 = d4 + d2;
                double d45 = d4 - d2;
                double d46 = d36 - d38;
                double d47 = d36 + d38;
                int n35 = n29 + n16;
                int n36 = n29 + n10;
                int n37 = n29 + n9;
                int n38 = n29 + n8;
                int n39 = n29 + n7;
                dArray2[n35 - 1] = d22 + d6 + d5;
                dArray2[n35] = d23 + d32 + d33;
                dArray2[n36 - 1] = d14 * d45 - d15 * d47;
                dArray2[n36] = d14 * d47 + d15 * d45;
                dArray2[n37 - 1] = d16 * d40 - d17 * d42;
                dArray2[n37] = d16 * d42 + d17 * d40;
                dArray2[n38 - 1] = d18 * d41 - d19 * d43;
                dArray2[n38] = d18 * d43 + d19 * d41;
                dArray2[n39 - 1] = d20 * d44 - d21 * d46;
                dArray2[n39] = d20 * d46 + d21 * d44;
            }
        }
    }

    void radb5(long l, long l2, A a, long l3, A a2, long l4, long l5) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        long l6;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        double d9 = 0.30901699437494745;
        double d10 = 0.9510565162951535;
        double d11 = -0.8090169943749473;
        double d12 = 0.5877852522924732;
        long l18 = l5;
        long l19 = l18 + l;
        long l20 = l19 + l;
        long l21 = l20 + l;
        long l22 = l2 * l;
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            l6 = l3 + l - 1L;
            double d13 = a.E(l3 + l15);
            d8 = 2.0 * a.E(l3 + l13);
            d7 = 2.0 * a.E(l3 + l11);
            d6 = 2.0 * a.E(l6 + l14);
            d5 = 2.0 * a.E(l6 + l12);
            d4 = d13 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
            d3 = d13 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
            d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
            d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
            a2.B(l4 + l16, d13 + d6 + d5);
            a2.B(l4 + l10, d4 - d2);
            a2.B(l4 + l9, d3 - d);
            a2.B(l4 + l8, d3 + d);
            a2.B(l4 + l7, d4 + d2);
        }
        if (l == 1L) {
            return;
        }
        for (l17 = 0L; l17 < l2; ++l17) {
            l16 = l17 * l;
            l15 = 5L * l16;
            l14 = l15 + l;
            l13 = l14 + l;
            l12 = l13 + l;
            l11 = l12 + l;
            l10 = l16 + l22;
            l9 = l10 + l22;
            l8 = l9 + l22;
            l7 = l8 + l22;
            for (long i = 2L; i < l; i += 2L) {
                long l23 = l - i;
                l6 = i - 1L + l18;
                long l24 = i - 1L + l19;
                long l25 = i - 1L + l20;
                long l26 = i - 1L + l21;
                double d14 = this.wtable_rl.E(l6 - 1L);
                double d15 = this.wtable_rl.E(l6);
                double d16 = this.wtable_rl.E(l24 - 1L);
                double d17 = this.wtable_rl.E(l24);
                double d18 = this.wtable_rl.E(l25 - 1L);
                double d19 = this.wtable_rl.E(l25);
                double d20 = this.wtable_rl.E(l26 - 1L);
                double d21 = this.wtable_rl.E(l26);
                long l27 = l3 + i;
                long l28 = l3 + l23;
                long l29 = l4 + i;
                long l30 = l27 + l15;
                long l31 = l28 + l14;
                long l32 = l27 + l13;
                long l33 = l28 + l12;
                long l34 = l27 + l11;
                double d22 = a.E(l30 - 1L);
                double d23 = a.E(l30);
                double d24 = a.E(l31 - 1L);
                double d25 = a.E(l31);
                double d26 = a.E(l32 - 1L);
                double d27 = a.E(l32);
                double d28 = a.E(l33 - 1L);
                double d29 = a.E(l33);
                double d30 = a.E(l34 - 1L);
                double d31 = a.E(l34);
                d8 = d27 + d25;
                double d32 = d27 - d25;
                d7 = d31 + d29;
                double d33 = d31 - d29;
                double d34 = d26 - d24;
                d6 = d26 + d24;
                double d35 = d30 - d28;
                d5 = d30 + d28;
                d4 = d22 + 0.30901699437494745 * d6 + -0.8090169943749473 * d5;
                double d36 = d23 + 0.30901699437494745 * d32 + -0.8090169943749473 * d33;
                d3 = d22 + -0.8090169943749473 * d6 + 0.30901699437494745 * d5;
                double d37 = d23 + -0.8090169943749473 * d32 + 0.30901699437494745 * d33;
                double d38 = 0.9510565162951535 * d34 + 0.5877852522924732 * d35;
                d2 = 0.9510565162951535 * d8 + 0.5877852522924732 * d7;
                double d39 = 0.5877852522924732 * d34 - 0.9510565162951535 * d35;
                d = 0.5877852522924732 * d8 - 0.9510565162951535 * d7;
                double d40 = d3 - d;
                double d41 = d3 + d;
                double d42 = d37 + d39;
                double d43 = d37 - d39;
                double d44 = d4 + d2;
                double d45 = d4 - d2;
                double d46 = d36 - d38;
                double d47 = d36 + d38;
                long l35 = l29 + l16;
                long l36 = l29 + l10;
                long l37 = l29 + l9;
                long l38 = l29 + l8;
                long l39 = l29 + l7;
                a2.B(l35 - 1L, d22 + d6 + d5);
                a2.B(l35, d23 + d32 + d33);
                a2.B(l36 - 1L, d14 * d45 - d15 * d47);
                a2.B(l36, d14 * d47 + d15 * d45);
                a2.B(l37 - 1L, d16 * d40 - d17 * d42);
                a2.B(l37, d16 * d42 + d17 * d40);
                a2.B(l38 - 1L, d18 * d41 - d19 * d43);
                a2.B(l38, d18 * d43 + d19 * d41);
                a2.B(l39 - 1L, d20 * d44 - d21 * d46);
                a2.B(l39, d20 * d46 + d21 * d44);
            }
        }
    }

    void radfg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        int n8;
        double d;
        double d2;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        double d3 = Math.PI * 2 / (double)n2;
        double d4 = FastMath.cos(d3);
        double d5 = FastMath.sin(d3);
        int n21 = (n2 + 1) / 2;
        int n22 = (n - 1) / 2;
        if (n != 1) {
            double d6;
            double d7;
            double d8;
            int n23;
            double d9;
            double d10;
            int n24;
            int n25;
            for (n19 = 0; n19 < n4; ++n19) {
                dArray2[n6 + n19] = dArray[n5 + n19];
            }
            for (n19 = 1; n19 < n2; ++n19) {
                n18 = n19 * n3 * n;
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n + n18;
                    dArray2[n6 + n16] = dArray[n5 + n16];
                }
            }
            if (n22 <= n3) {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n24 = (n25 += n) - 1;
                    n18 = n19 * n3 * n;
                    for (n17 = 2; n17 < n; n17 += 2) {
                        n16 = (n24 += 2) + n20;
                        n15 = n5 + n17;
                        n14 = n6 + n17;
                        d10 = this.wtable_r[n16 - 1];
                        d9 = this.wtable_r[n16];
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n14 + n12;
                            n11 = n15 + n12;
                            d8 = dArray[n11 - 1];
                            double d11 = dArray[n11];
                            dArray2[n23 - 1] = d10 * d8 + d9 * d11;
                            dArray2[n23] = d10 * d11 - d9 * d8;
                        }
                    }
                }
            } else {
                n25 = -n;
                for (n19 = 1; n19 < n2; ++n19) {
                    n25 += n;
                    n18 = n19 * n3 * n;
                    for (n17 = 0; n17 < n3; ++n17) {
                        n24 = n25 - 1;
                        n16 = n17 * n + n18;
                        for (n15 = 2; n15 < n; n15 += 2) {
                            n14 = (n24 += 2) + n20;
                            d10 = this.wtable_r[n14 - 1];
                            d9 = this.wtable_r[n14];
                            n13 = n6 + n15 + n16;
                            n12 = n5 + n15 + n16;
                            double d12 = dArray[n12 - 1];
                            d8 = dArray[n12];
                            dArray2[n13 - 1] = d10 * d12 + d9 * d8;
                            dArray2[n13] = d10 * d8 - d9 * d12;
                        }
                    }
                }
            }
            if (n22 >= n3) {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 0; n16 < n3; ++n16) {
                        n15 = n16 * n + n18;
                        n14 = n16 * n + n17;
                        for (n13 = 2; n13 < n; n13 += 2) {
                            n12 = n5 + n13;
                            n23 = n6 + n13;
                            n11 = n12 + n15;
                            int n26 = n12 + n14;
                            n9 = n23 + n15;
                            int n27 = n23 + n14;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n27 - 1];
                            d = dArray2[n27];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n26 - 1] = d6 - d;
                            dArray[n26] = d2 - d7;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n21; ++n19) {
                    n10 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n10 * n3 * n;
                    for (n16 = 2; n16 < n; n16 += 2) {
                        n15 = n5 + n16;
                        n14 = n6 + n16;
                        for (n13 = 0; n13 < n3; ++n13) {
                            n12 = n13 * n + n18;
                            n23 = n13 * n + n17;
                            n11 = n15 + n12;
                            int n28 = n15 + n23;
                            n9 = n14 + n12;
                            int n29 = n14 + n23;
                            d7 = dArray2[n9 - 1];
                            d6 = dArray2[n9];
                            d2 = dArray2[n29 - 1];
                            d = dArray2[n29];
                            dArray[n11 - 1] = d7 + d2;
                            dArray[n11] = d6 + d;
                            dArray[n28 - 1] = d6 - d;
                            dArray[n28] = d2 - d7;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(dArray2, n6, dArray, n5, n4);
        }
        for (n19 = 1; n19 < n21; ++n19) {
            n10 = n2 - n19;
            n18 = n19 * n3 * n;
            n17 = n10 * n3 * n;
            for (n16 = 0; n16 < n3; ++n16) {
                n15 = n16 * n + n18;
                n14 = n16 * n + n17;
                n13 = n6 + n15;
                n12 = n6 + n14;
                double d13 = dArray2[n13];
                double d14 = dArray2[n12];
                dArray[n5 + n15] = d13 + d14;
                dArray[n5 + n14] = d14 - d13;
            }
        }
        double d15 = 1.0;
        double d16 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n21; ++n18) {
            int n30 = n2 - n18;
            double d17 = d4 * d15 - d5 * d16;
            d16 = d4 * d16 + d5 * d15;
            d15 = d17;
            n17 = n18 * n4;
            n16 = n30 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                n14 = n6 + n15;
                n13 = n5 + n15;
                dArray2[n14 + n17] = dArray[n13] + d15 * dArray[n13 + n4];
                dArray2[n14 + n16] = d16 * dArray[n13 + n19];
            }
            double d18 = d15;
            double d19 = d16;
            double d20 = d15;
            double d21 = d16;
            for (n15 = 2; n15 < n21; ++n15) {
                n10 = n2 - n15;
                double d22 = d18 * d20 - d19 * d21;
                d21 = d18 * d21 + d19 * d20;
                d20 = d22;
                n14 = n15 * n4;
                n13 = n10 * n4;
                for (n12 = 0; n12 < n4; ++n12) {
                    int n31 = n6 + n12;
                    n11 = n5 + n12;
                    int n32 = n31 + n17;
                    dArray2[n32] = dArray2[n32] + d20 * dArray[n11 + n14];
                    int n33 = n31 + n16;
                    dArray2[n33] = dArray2[n33] + d21 * dArray[n11 + n13];
                }
            }
        }
        for (n18 = 1; n18 < n21; ++n18) {
            n17 = n18 * n4;
            for (n16 = 0; n16 < n4; ++n16) {
                int n34 = n6 + n16;
                dArray2[n34] = dArray2[n34] + dArray[n5 + n16 + n17];
            }
        }
        if (n >= n3) {
            for (n18 = 0; n18 < n3; ++n18) {
                n17 = n18 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    dArray[n5 + n15 + n16] = dArray2[n6 + n15 + n17];
                }
            }
        } else {
            for (n18 = 0; n18 < n; ++n18) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    dArray[n5 + n18 + n16 * n2] = dArray2[n6 + n18 + n16];
                }
            }
        }
        n18 = n2 * n;
        for (n17 = 1; n17 < n21; ++n17) {
            n10 = n2 - n17;
            n8 = 2 * n17;
            n16 = n17 * n3 * n;
            n15 = n10 * n3 * n;
            n14 = n8 * n;
            for (n13 = 0; n13 < n3; ++n13) {
                n12 = n13 * n;
                int n35 = n12 + n16;
                n11 = n12 + n15;
                int n36 = n13 * n18;
                dArray[n5 + n - 1 + n14 - n + n36] = dArray2[n6 + n35];
                dArray[n5 + n14 + n36] = dArray2[n6 + n11];
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 0; n13 < n3; ++n13) {
                    n12 = n13 * n18;
                    int n37 = n13 * n;
                    for (n11 = 2; n11 < n; n11 += 2) {
                        int n38 = n - n11;
                        int n39 = n5 + n11;
                        n9 = n5 + n38;
                        int n40 = n6 + n11;
                        int n41 = n39 + n14 + n12;
                        int n42 = n9 + n14 - n + n12;
                        int n43 = n40 + n37 + n16;
                        int n44 = n40 + n37 + n15;
                        d2 = dArray2[n43 - 1];
                        d = dArray2[n43];
                        double d23 = dArray2[n44 - 1];
                        double d24 = dArray2[n44];
                        dArray[n41 - 1] = d2 + d23;
                        dArray[n42 - 1] = d2 - d23;
                        dArray[n41] = d + d24;
                        dArray[n42] = d24 - d;
                    }
                }
            }
        } else {
            for (n17 = 1; n17 < n21; ++n17) {
                n10 = n2 - n17;
                n8 = 2 * n17;
                n16 = n17 * n3 * n;
                n15 = n10 * n3 * n;
                n14 = n8 * n;
                for (n13 = 2; n13 < n; n13 += 2) {
                    int n45 = n - n13;
                    n12 = n5 + n13;
                    int n46 = n5 + n45;
                    n11 = n6 + n13;
                    for (int i = 0; i < n3; ++i) {
                        n9 = i * n18;
                        int n47 = i * n;
                        int n48 = n12 + n14 + n9;
                        int n49 = n46 + n14 - n + n9;
                        int n50 = n11 + n47 + n16;
                        int n51 = n11 + n47 + n15;
                        d2 = dArray2[n50 - 1];
                        d = dArray2[n50];
                        double d25 = dArray2[n51 - 1];
                        double d26 = dArray2[n51];
                        dArray[n48 - 1] = d2 + d25;
                        dArray[n49 - 1] = d2 - d25;
                        dArray[n48] = d + d26;
                        dArray[n49] = d26 - d;
                    }
                }
            }
        }
    }

    void radfg(long l, long l2, long l3, long l4, A a, long l5, A a2, long l6, long l7) {
        long l8;
        long l9;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19 = l7;
        double d = Math.PI * 2 / (double)l2;
        double d2 = FastMath.cos(d);
        double d3 = FastMath.sin(d);
        long l20 = (l2 + 1L) / 2L;
        long l21 = (l - 1L) / 2L;
        if (l != 1L) {
            double d4;
            double d5;
            double d6;
            double d7;
            long l22;
            long l23;
            double d8;
            double d9;
            long l24;
            long l25;
            for (l18 = 0L; l18 < l4; ++l18) {
                a2.B(l6 + l18, a.E(l5 + l18));
            }
            for (l18 = 1L; l18 < l2; ++l18) {
                l17 = l18 * l3 * l;
                for (l16 = 0L; l16 < l3; ++l16) {
                    l15 = l16 * l + l17;
                    a2.B(l6 + l15, a.E(l5 + l15));
                }
            }
            if (l21 <= l3) {
                l25 = -l;
                for (l18 = 1L; l18 < l2; ++l18) {
                    l24 = (l25 += l) - 1L;
                    l17 = l18 * l3 * l;
                    for (l16 = 2L; l16 < l; l16 += 2L) {
                        l15 = (l24 += 2L) + l19;
                        l14 = l5 + l16;
                        l13 = l6 + l16;
                        d9 = this.wtable_rl.E(l15 - 1L);
                        d8 = this.wtable_rl.E(l15);
                        for (l12 = 0L; l12 < l3; ++l12) {
                            l11 = l12 * l + l17;
                            l23 = l13 + l11;
                            l22 = l14 + l11;
                            double d10 = a.E(l22 - 1L);
                            double d11 = a.E(l22);
                            a2.B(l23 - 1L, d9 * d10 + d8 * d11);
                            a2.B(l23, d9 * d11 - d8 * d10);
                        }
                    }
                }
            } else {
                l25 = -l;
                for (l18 = 1L; l18 < l2; ++l18) {
                    l25 += l;
                    l17 = l18 * l3 * l;
                    for (l16 = 0L; l16 < l3; ++l16) {
                        l24 = l25 - 1L;
                        l15 = l16 * l + l17;
                        for (l14 = 2L; l14 < l; l14 += 2L) {
                            l13 = (l24 += 2L) + l19;
                            d9 = this.wtable_rl.E(l13 - 1L);
                            d8 = this.wtable_rl.E(l13);
                            l12 = l6 + l14 + l15;
                            l11 = l5 + l14 + l15;
                            double d12 = a.E(l11 - 1L);
                            double d13 = a.E(l11);
                            a2.B(l12 - 1L, d9 * d12 + d8 * d13);
                            a2.B(l12, d9 * d13 - d8 * d12);
                        }
                    }
                }
            }
            if (l21 >= l3) {
                for (l18 = 1L; l18 < l20; ++l18) {
                    l10 = l2 - l18;
                    l17 = l18 * l3 * l;
                    l16 = l10 * l3 * l;
                    for (l15 = 0L; l15 < l3; ++l15) {
                        l14 = l15 * l + l17;
                        l13 = l15 * l + l16;
                        for (l12 = 2L; l12 < l; l12 += 2L) {
                            l11 = l5 + l12;
                            l23 = l6 + l12;
                            l22 = l11 + l14;
                            long l26 = l11 + l13;
                            long l27 = l23 + l14;
                            l9 = l23 + l13;
                            d7 = a2.E(l27 - 1L);
                            d6 = a2.E(l27);
                            d5 = a2.E(l9 - 1L);
                            d4 = a2.E(l9);
                            a.B(l22 - 1L, d7 + d5);
                            a.B(l22, d6 + d4);
                            a.B(l26 - 1L, d6 - d4);
                            a.B(l26, d5 - d7);
                        }
                    }
                }
            } else {
                for (l18 = 1L; l18 < l20; ++l18) {
                    l10 = l2 - l18;
                    l17 = l18 * l3 * l;
                    l16 = l10 * l3 * l;
                    for (l15 = 2L; l15 < l; l15 += 2L) {
                        l14 = l5 + l15;
                        l13 = l6 + l15;
                        for (l12 = 0L; l12 < l3; ++l12) {
                            l11 = l12 * l + l17;
                            l23 = l12 * l + l16;
                            l22 = l14 + l11;
                            long l28 = l14 + l23;
                            long l29 = l13 + l11;
                            l9 = l13 + l23;
                            d7 = a2.E(l29 - 1L);
                            d6 = a2.E(l29);
                            d5 = a2.E(l9 - 1L);
                            d4 = a2.E(l9);
                            a.B(l22 - 1L, d7 + d5);
                            a.B(l22, d6 + d4);
                            a.B(l28 - 1L, d6 - d4);
                            a.B(l28, d5 - d7);
                        }
                    }
                }
            }
        } else {
            C.A(a2, l6, a, l5, l4);
        }
        for (l18 = 1L; l18 < l20; ++l18) {
            l10 = l2 - l18;
            l17 = l18 * l3 * l;
            l16 = l10 * l3 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l + l17;
                l13 = l15 * l + l16;
                l12 = l6 + l14;
                l11 = l6 + l13;
                double d14 = a2.E(l12);
                double d15 = a2.E(l11);
                a.B(l5 + l14, d14 + d15);
                a.B(l5 + l13, d15 - d14);
            }
        }
        double d16 = 1.0;
        double d17 = 0.0;
        l18 = (l2 - 1L) * l4;
        for (l17 = 1L; l17 < l20; ++l17) {
            long l30 = l2 - l17;
            double d18 = d2 * d16 - d3 * d17;
            d17 = d2 * d17 + d3 * d16;
            d16 = d18;
            l16 = l17 * l4;
            l15 = l30 * l4;
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l6 + l14;
                l12 = l5 + l14;
                a2.B(l13 + l16, a.E(l12) + d16 * a.E(l12 + l4));
                a2.B(l13 + l15, d17 * a.E(l12 + l18));
            }
            double d19 = d16;
            double d20 = d17;
            double d21 = d16;
            double d22 = d17;
            for (l14 = 2L; l14 < l20; ++l14) {
                l10 = l2 - l14;
                double d23 = d19 * d21 - d20 * d22;
                d22 = d19 * d22 + d20 * d21;
                d21 = d23;
                l13 = l14 * l4;
                l12 = l10 * l4;
                for (l11 = 0L; l11 < l4; ++l11) {
                    long l31 = l6 + l11;
                    long l32 = l5 + l11;
                    a2.B(l31 + l16, a2.E(l31 + l16) + d21 * a.E(l32 + l13));
                    a2.B(l31 + l15, a2.E(l31 + l15) + d22 * a.E(l32 + l12));
                }
            }
        }
        for (l17 = 1L; l17 < l20; ++l17) {
            l16 = l17 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                a2.B(l6 + l15, a2.E(l6 + l15) + a.E(l5 + l15 + l16));
            }
        }
        if (l >= l3) {
            for (l17 = 0L; l17 < l3; ++l17) {
                l16 = l17 * l;
                l15 = l16 * l2;
                for (l14 = 0L; l14 < l; ++l14) {
                    a.B(l5 + l14 + l15, a2.E(l6 + l14 + l16));
                }
            }
        } else {
            for (l17 = 0L; l17 < l; ++l17) {
                for (l16 = 0L; l16 < l3; ++l16) {
                    l15 = l16 * l;
                    a.B(l5 + l17 + l15 * l2, a2.E(l6 + l17 + l15));
                }
            }
        }
        l17 = l2 * l;
        for (l16 = 1L; l16 < l20; ++l16) {
            l10 = l2 - l16;
            l8 = 2L * l16;
            l15 = l16 * l3 * l;
            l14 = l10 * l3 * l;
            l13 = l8 * l;
            for (l12 = 0L; l12 < l3; ++l12) {
                l11 = l12 * l;
                long l33 = l11 + l15;
                long l34 = l11 + l14;
                long l35 = l12 * l17;
                a.B(l5 + l - 1L + l13 - l + l35, a2.E(l6 + l33));
                a.B(l5 + l13 + l35, a2.E(l6 + l34));
            }
        }
        if (l == 1L) {
            return;
        }
        if (l21 >= l3) {
            for (l16 = 1L; l16 < l20; ++l16) {
                l10 = l2 - l16;
                l8 = 2L * l16;
                l15 = l16 * l3 * l;
                l14 = l10 * l3 * l;
                l13 = l8 * l;
                for (l12 = 0L; l12 < l3; ++l12) {
                    l11 = l12 * l17;
                    long l36 = l12 * l;
                    for (long i = 2L; i < l; i += 2L) {
                        long l37 = l - i;
                        long l38 = l5 + i;
                        long l39 = l5 + l37;
                        l9 = l6 + i;
                        long l40 = l38 + l13 + l11;
                        long l41 = l39 + l13 - l + l11;
                        long l42 = l9 + l36 + l15;
                        long l43 = l9 + l36 + l14;
                        double d24 = a2.E(l42 - 1L);
                        double d25 = a2.E(l42);
                        double d26 = a2.E(l43 - 1L);
                        double d27 = a2.E(l43);
                        a.B(l40 - 1L, d24 + d26);
                        a.B(l41 - 1L, d24 - d26);
                        a.B(l40, d25 + d27);
                        a.B(l41, d27 - d25);
                    }
                }
            }
        } else {
            for (l16 = 1L; l16 < l20; ++l16) {
                l10 = l2 - l16;
                l8 = 2L * l16;
                l15 = l16 * l3 * l;
                l14 = l10 * l3 * l;
                l13 = l8 * l;
                for (l12 = 2L; l12 < l; l12 += 2L) {
                    long l44 = l - l12;
                    l11 = l5 + l12;
                    long l45 = l5 + l44;
                    long l46 = l6 + l12;
                    for (long i = 0L; i < l3; ++i) {
                        long l47 = i * l17;
                        l9 = i * l;
                        long l48 = l11 + l13 + l47;
                        long l49 = l45 + l13 - l + l47;
                        long l50 = l46 + l9 + l15;
                        long l51 = l46 + l9 + l14;
                        double d28 = a2.E(l50 - 1L);
                        double d29 = a2.E(l50);
                        double d30 = a2.E(l51 - 1L);
                        double d31 = a2.E(l51);
                        a.B(l48 - 1L, d28 + d30);
                        a.B(l49 - 1L, d28 - d30);
                        a.B(l48, d29 + d31);
                        a.B(l49, d31 - d29);
                    }
                }
            }
        }
    }

    void radbg(int n, int n2, int n3, int n4, double[] dArray, int n5, double[] dArray2, int n6, int n7) {
        double d;
        double d2;
        int n8;
        int n9;
        double d3;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = n7;
        double d4 = Math.PI * 2 / (double)n2;
        double d5 = FastMath.cos(d4);
        double d6 = FastMath.sin(d4);
        int n22 = (n - 1) / 2;
        int n23 = (n2 + 1) / 2;
        int n24 = n2 * n;
        if (n >= n3) {
            for (n20 = 0; n20 < n3; ++n20) {
                n19 = n20 * n;
                n18 = n20 * n24;
                for (n17 = 0; n17 < n; ++n17) {
                    dArray2[n6 + n17 + n19] = dArray[n5 + n17 + n18];
                }
            }
        } else {
            for (n20 = 0; n20 < n; ++n20) {
                n19 = n6 + n20;
                n18 = n5 + n20;
                for (n17 = 0; n17 < n3; ++n17) {
                    dArray2[n19 + n17 * n] = dArray[n18 + n17 * n24];
                }
            }
        }
        n20 = n5 + n - 1;
        for (n19 = 1; n19 < n23; ++n19) {
            n16 = n2 - n19;
            int n25 = 2 * n19;
            n18 = n19 * n3 * n;
            n17 = n16 * n3 * n;
            n15 = n25 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n13 * n2;
                n11 = n20 + n15 + n12 - n;
                n10 = n5 + n15 + n12;
                double d7 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n6 + n13 + n18] = d7 + d7;
                dArray2[n6 + n13 + n17] = d3 + d3;
            }
        }
        if (n != 1) {
            double d8;
            double d9;
            double d10;
            double d11;
            int n26;
            int n27;
            int n28;
            int n29;
            if (n22 >= n3) {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 0; n14 < n3; ++n14) {
                        n13 = n14 * n + n18;
                        n12 = n14 * n + n17;
                        n11 = n14 * n2 * n + n15;
                        for (n10 = 2; n10 < n; n10 += 2) {
                            n29 = n - n10;
                            int n30 = n6 + n10;
                            n9 = n5 + n29;
                            int n31 = n5 + n10;
                            n8 = n30 + n13;
                            n28 = n30 + n12;
                            n27 = n31 + n11;
                            n26 = n9 + n11 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 2; n14 < n; n14 += 2) {
                        n29 = n - n14;
                        n13 = n6 + n14;
                        n12 = n5 + n29;
                        n11 = n5 + n14;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n32 = n10 * n + n18;
                            n9 = n10 * n + n17;
                            int n33 = n10 * n2 * n + n15;
                            n8 = n13 + n32;
                            n28 = n13 + n9;
                            n27 = n11 + n33;
                            n26 = n12 + n33 - n;
                            d11 = dArray[n27 - 1];
                            d10 = dArray[n27];
                            d9 = dArray[n26 - 1];
                            d8 = dArray[n26];
                            dArray2[n8 - 1] = d11 + d9;
                            dArray2[n28 - 1] = d11 - d9;
                            dArray2[n8] = d10 - d8;
                            dArray2[n28] = d10 + d8;
                        }
                    }
                }
            }
        }
        double d12 = 1.0;
        double d13 = 0.0;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n23; ++n18) {
            int n34 = n2 - n18;
            double d14 = d5 * d12 - d6 * d13;
            d13 = d5 * d13 + d6 * d12;
            d12 = d14;
            n17 = n18 * n4;
            n15 = n34 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                dArray[n13 + n17] = dArray2[n12] + d12 * dArray2[n12 + n4];
                dArray[n13 + n15] = d13 * dArray2[n12 + n19];
            }
            double d15 = d12;
            double d16 = d13;
            double d17 = d12;
            double d18 = d13;
            for (n14 = 2; n14 < n23; ++n14) {
                n16 = n2 - n14;
                double d19 = d15 * d17 - d16 * d18;
                d18 = d15 * d18 + d16 * d17;
                d17 = d19;
                n13 = n14 * n4;
                n12 = n16 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    n10 = n5 + n11;
                    int n35 = n6 + n11;
                    int n36 = n10 + n17;
                    dArray[n36] = dArray[n36] + d17 * dArray2[n35 + n13];
                    int n37 = n10 + n15;
                    dArray[n37] = dArray[n37] + d18 * dArray2[n35 + n12];
                }
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n17 = n18 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n38 = n14 = n6 + n15;
                dArray2[n38] = dArray2[n38] + dArray2[n14 + n17];
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n16 = n2 - n18;
            n17 = n18 * n3 * n;
            n15 = n16 * n3 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13;
                n11 = n5 + n13 + n17;
                n10 = n5 + n13 + n15;
                double d20 = dArray[n11];
                d3 = dArray[n10];
                dArray2[n12 + n17] = d20 - d3;
                dArray2[n12 + n15] = d20 + d3;
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    n13 = n14 * n;
                    for (n12 = 2; n12 < n; n12 += 2) {
                        n11 = n6 + n12;
                        n10 = n5 + n12;
                        int n39 = n11 + n13 + n17;
                        n9 = n11 + n13 + n15;
                        int n40 = n10 + n13 + n17;
                        n8 = n10 + n13 + n15;
                        double d21 = dArray[n40 - 1];
                        double d22 = dArray[n40];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n39 - 1] = d21 - d;
                        dArray2[n9 - 1] = d21 + d;
                        dArray2[n39] = d22 + d2;
                        dArray2[n9] = d22 - d2;
                    }
                }
            }
        } else {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 2; n14 < n; n14 += 2) {
                    n13 = n6 + n14;
                    n12 = n5 + n14;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n;
                        int n41 = n13 + n10 + n17;
                        n9 = n13 + n10 + n15;
                        int n42 = n12 + n10 + n17;
                        n8 = n12 + n10 + n15;
                        double d23 = dArray[n42 - 1];
                        double d24 = dArray[n42];
                        d2 = dArray[n8 - 1];
                        d = dArray[n8];
                        dArray2[n41 - 1] = d23 - d;
                        dArray2[n9 - 1] = d23 + d;
                        dArray2[n41] = d24 + d2;
                        dArray2[n9] = d24 - d2;
                    }
                }
            }
        }
        System.arraycopy(dArray2, n6, dArray, n5, n4);
        for (n18 = 1; n18 < n2; ++n18) {
            n17 = n18 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                dArray[n5 + n14] = dArray2[n6 + n14];
            }
        }
        if (n22 <= n3) {
            int n43 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                int n44 = (n43 += n) - 1;
                n17 = n18 * n3 * n;
                for (n15 = 2; n15 < n; n15 += 2) {
                    n14 = (n44 += 2) + n21;
                    double d25 = this.wtable_r[n14 - 1];
                    double d26 = this.wtable_r[n14];
                    n13 = n5 + n15;
                    n12 = n6 + n15;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n + n17;
                        int n45 = n13 + n10;
                        n9 = n12 + n10;
                        double d27 = dArray2[n9 - 1];
                        double d28 = dArray2[n9];
                        dArray[n45 - 1] = d25 * d27 - d26 * d28;
                        dArray[n45] = d25 * d28 + d26 * d27;
                    }
                }
            }
        } else {
            int n46 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                n46 += n;
                n17 = n18 * n3 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    int n47 = n46 - 1;
                    n14 = n15 * n + n17;
                    for (n13 = 2; n13 < n; n13 += 2) {
                        n12 = (n47 += 2) + n21;
                        double d29 = this.wtable_r[n12 - 1];
                        double d30 = this.wtable_r[n12];
                        n11 = n5 + n13;
                        n10 = n6 + n13;
                        int n48 = n11 + n14;
                        n9 = n10 + n14;
                        double d31 = dArray2[n9 - 1];
                        double d32 = dArray2[n9];
                        dArray[n48 - 1] = d29 * d31 - d30 * d32;
                        dArray[n48] = d29 * d32 + d30 * d31;
                    }
                }
            }
        }
    }

    void radbg(long l, long l2, long l3, long l4, A a, long l5, A a2, long l6, long l7) {
        double d;
        long l8;
        long l9;
        double d2;
        long l10;
        long l11;
        long l12;
        long l13;
        long l14;
        long l15;
        long l16;
        long l17;
        long l18;
        long l19;
        long l20;
        long l21 = l7;
        double d3 = Math.PI * 2 / (double)l2;
        double d4 = FastMath.cos(d3);
        double d5 = FastMath.sin(d3);
        long l22 = (l - 1L) / 2L;
        long l23 = (l2 + 1L) / 2L;
        long l24 = l2 * l;
        if (l >= l3) {
            for (l20 = 0L; l20 < l3; ++l20) {
                l19 = l20 * l;
                l18 = l20 * l24;
                for (l17 = 0L; l17 < l; ++l17) {
                    a2.B(l6 + l17 + l19, a.E(l5 + l17 + l18));
                }
            }
        } else {
            for (l20 = 0L; l20 < l; ++l20) {
                l19 = l6 + l20;
                l18 = l5 + l20;
                for (l17 = 0L; l17 < l3; ++l17) {
                    a2.B(l19 + l17 * l, a.E(l18 + l17 * l24));
                }
            }
        }
        l20 = l5 + l - 1L;
        for (l19 = 1L; l19 < l23; ++l19) {
            l16 = l2 - l19;
            long l25 = 2L * l19;
            l18 = l19 * l3 * l;
            l17 = l16 * l3 * l;
            l15 = l25 * l;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l13 * l2;
                l11 = l20 + l15 + l12 - l;
                l10 = l5 + l15 + l12;
                double d6 = a.E(l11);
                d2 = a.E(l10);
                a2.B(l6 + l13 + l18, d6 + d6);
                a2.B(l6 + l13 + l17, d2 + d2);
            }
        }
        if (l != 1L) {
            double d7;
            double d8;
            double d9;
            long l26;
            long l27;
            long l28;
            long l29;
            if (l22 >= l3) {
                for (l19 = 1L; l19 < l23; ++l19) {
                    l16 = l2 - l19;
                    l18 = l19 * l3 * l;
                    l17 = l16 * l3 * l;
                    l15 = 2L * l19 * l;
                    for (l14 = 0L; l14 < l3; ++l14) {
                        l13 = l14 * l + l18;
                        l12 = l14 * l + l17;
                        l11 = l14 * l2 * l + l15;
                        for (l10 = 2L; l10 < l; l10 += 2L) {
                            l29 = l - l10;
                            long l30 = l6 + l10;
                            long l31 = l5 + l29;
                            l9 = l5 + l10;
                            l8 = l30 + l13;
                            l28 = l30 + l12;
                            l27 = l9 + l11;
                            l26 = l31 + l11 - l;
                            d = a.E(l27 - 1L);
                            d9 = a.E(l27);
                            d8 = a.E(l26 - 1L);
                            d7 = a.E(l26);
                            a2.B(l8 - 1L, d + d8);
                            a2.B(l28 - 1L, d - d8);
                            a2.B(l8, d9 - d7);
                            a2.B(l28, d9 + d7);
                        }
                    }
                }
            } else {
                for (l19 = 1L; l19 < l23; ++l19) {
                    l16 = l2 - l19;
                    l18 = l19 * l3 * l;
                    l17 = l16 * l3 * l;
                    l15 = 2L * l19 * l;
                    for (l14 = 2L; l14 < l; l14 += 2L) {
                        l29 = l - l14;
                        l13 = l6 + l14;
                        l12 = l5 + l29;
                        l11 = l5 + l14;
                        for (l10 = 0L; l10 < l3; ++l10) {
                            long l32 = l10 * l + l18;
                            long l33 = l10 * l + l17;
                            l9 = l10 * l2 * l + l15;
                            l8 = l13 + l32;
                            l28 = l13 + l33;
                            l27 = l11 + l9;
                            l26 = l12 + l9 - l;
                            d = a.E(l27 - 1L);
                            d9 = a.E(l27);
                            d8 = a.E(l26 - 1L);
                            d7 = a.E(l26);
                            a2.B(l8 - 1L, d + d8);
                            a2.B(l28 - 1L, d - d8);
                            a2.B(l8, d9 - d7);
                            a2.B(l28, d9 + d7);
                        }
                    }
                }
            }
        }
        double d10 = 1.0;
        double d11 = 0.0;
        l19 = (l2 - 1L) * l4;
        for (l18 = 1L; l18 < l23; ++l18) {
            long l34 = l2 - l18;
            double d12 = d4 * d10 - d5 * d11;
            d11 = d4 * d11 + d5 * d10;
            d10 = d12;
            l17 = l18 * l4;
            l15 = l34 * l4;
            for (l14 = 0L; l14 < l4; ++l14) {
                l13 = l5 + l14;
                l12 = l6 + l14;
                a.B(l13 + l17, a2.E(l12) + d10 * a2.E(l12 + l4));
                a.B(l13 + l15, d11 * a2.E(l12 + l19));
            }
            double d13 = d10;
            double d14 = d11;
            double d15 = d10;
            double d16 = d11;
            for (l14 = 2L; l14 < l23; ++l14) {
                l16 = l2 - l14;
                double d17 = d13 * d15 - d14 * d16;
                d16 = d13 * d16 + d14 * d15;
                d15 = d17;
                l13 = l14 * l4;
                l12 = l16 * l4;
                for (l11 = 0L; l11 < l4; ++l11) {
                    l10 = l5 + l11;
                    long l35 = l6 + l11;
                    a.B(l10 + l17, a.E(l10 + l17) + d15 * a2.E(l35 + l13));
                    a.B(l10 + l15, a.E(l10 + l15) + d16 * a2.E(l35 + l12));
                }
            }
        }
        for (l18 = 1L; l18 < l23; ++l18) {
            l17 = l18 * l4;
            for (l15 = 0L; l15 < l4; ++l15) {
                l14 = l6 + l15;
                a2.B(l14, a2.E(l14) + a2.E(l14 + l17));
            }
        }
        for (l18 = 1L; l18 < l23; ++l18) {
            l16 = l2 - l18;
            l17 = l18 * l3 * l;
            l15 = l16 * l3 * l;
            for (l14 = 0L; l14 < l3; ++l14) {
                l13 = l14 * l;
                l12 = l6 + l13;
                l11 = l5 + l13 + l17;
                l10 = l5 + l13 + l15;
                double d18 = a.E(l11);
                d2 = a.E(l10);
                a2.B(l12 + l17, d18 - d2);
                a2.B(l12 + l15, d18 + d2);
            }
        }
        if (l == 1L) {
            return;
        }
        if (l22 >= l3) {
            for (l18 = 1L; l18 < l23; ++l18) {
                l16 = l2 - l18;
                l17 = l18 * l3 * l;
                l15 = l16 * l3 * l;
                for (l14 = 0L; l14 < l3; ++l14) {
                    l13 = l14 * l;
                    for (l12 = 2L; l12 < l; l12 += 2L) {
                        l11 = l6 + l12;
                        l10 = l5 + l12;
                        long l36 = l11 + l13 + l17;
                        long l37 = l11 + l13 + l15;
                        l9 = l10 + l13 + l17;
                        l8 = l10 + l13 + l15;
                        double d19 = a.E(l9 - 1L);
                        double d20 = a.E(l9);
                        double d21 = a.E(l8 - 1L);
                        d = a.E(l8);
                        a2.B(l36 - 1L, d19 - d);
                        a2.B(l37 - 1L, d19 + d);
                        a2.B(l36, d20 + d21);
                        a2.B(l37, d20 - d21);
                    }
                }
            }
        } else {
            for (l18 = 1L; l18 < l23; ++l18) {
                l16 = l2 - l18;
                l17 = l18 * l3 * l;
                l15 = l16 * l3 * l;
                for (l14 = 2L; l14 < l; l14 += 2L) {
                    l13 = l6 + l14;
                    l12 = l5 + l14;
                    for (l11 = 0L; l11 < l3; ++l11) {
                        l10 = l11 * l;
                        long l38 = l13 + l10 + l17;
                        long l39 = l13 + l10 + l15;
                        l9 = l12 + l10 + l17;
                        l8 = l12 + l10 + l15;
                        double d22 = a.E(l9 - 1L);
                        double d23 = a.E(l9);
                        double d24 = a.E(l8 - 1L);
                        d = a.E(l8);
                        a2.B(l38 - 1L, d22 - d);
                        a2.B(l39 - 1L, d22 + d);
                        a2.B(l38, d23 + d24);
                        a2.B(l39, d23 - d24);
                    }
                }
            }
        }
        C.A(a2, l6, a, l5, l4);
        for (l18 = 1L; l18 < l2; ++l18) {
            l17 = l18 * l3 * l;
            for (l15 = 0L; l15 < l3; ++l15) {
                l14 = l15 * l + l17;
                a.B(l5 + l14, a2.E(l6 + l14));
            }
        }
        if (l22 <= l3) {
            long l40 = -l;
            for (l18 = 1L; l18 < l2; ++l18) {
                long l41 = (l40 += l) - 1L;
                l17 = l18 * l3 * l;
                for (l15 = 2L; l15 < l; l15 += 2L) {
                    l14 = (l41 += 2L) + l21;
                    double d25 = this.wtable_rl.E(l14 - 1L);
                    double d26 = this.wtable_rl.E(l14);
                    l13 = l5 + l15;
                    l12 = l6 + l15;
                    for (l11 = 0L; l11 < l3; ++l11) {
                        l10 = l11 * l + l17;
                        long l42 = l13 + l10;
                        long l43 = l12 + l10;
                        double d27 = a2.E(l43 - 1L);
                        double d28 = a2.E(l43);
                        a.B(l42 - 1L, d25 * d27 - d26 * d28);
                        a.B(l42, d25 * d28 + d26 * d27);
                    }
                }
            }
        } else {
            long l44 = -l;
            for (l18 = 1L; l18 < l2; ++l18) {
                l44 += l;
                l17 = l18 * l3 * l;
                for (l15 = 0L; l15 < l3; ++l15) {
                    long l45 = l44 - 1L;
                    l14 = l15 * l + l17;
                    for (l13 = 2L; l13 < l; l13 += 2L) {
                        l12 = (l45 += 2L) + l21;
                        double d29 = this.wtable_rl.E(l12 - 1L);
                        double d30 = this.wtable_rl.E(l12);
                        l11 = l5 + l13;
                        l10 = l6 + l13;
                        long l46 = l11 + l14;
                        long l47 = l10 + l14;
                        double d31 = a2.E(l47 - 1L);
                        double d32 = a2.E(l47);
                        a.B(l46 - 1L, d29 * d31 - d30 * d32);
                        a.B(l46, d29 * d32 + d30 * d31);
                    }
                }
            }
        }
    }

    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

