/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import B.A.A.A.C;
import B.A.A.A.D;
import B.A.A.A.E;
import B.A.A.A.F;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;

public class FloatDHT_1D {
    private final int n;
    private final long nl;
    private final FloatFFT_1D fft;
    private final boolean useLargeArrays;

    public FloatDHT_1D(long l) {
        this.n = (int)l;
        this.nl = l;
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || l > (long)E.C();
        this.fft = new FloatFFT_1D(l);
    }

    public void forward(float[] fArray) {
        this.forward(fArray, 0);
    }

    public void forward(final float[] fArray, final int n) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new D(fArray), (long)n);
        } else {
            this.fft.realForward(fArray, n);
            final float[] fArray2 = new float[this.n];
            System.arraycopy(fArray, n, fArray2, 0, this.n);
            int n2 = this.n / 2;
            int n3 = F.A();
            if (n3 > 1 && (long)n2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n3 = 2;
                int n4 = n2 / n3;
                Future[] futureArray = new Future[n3];
                for (int i = 0; i < n3; ++i) {
                    final int n5 = 1 + i * n4;
                    final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                    futureArray[i] = F.A(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = 2 * i;
                                int n2 = n3 + 1;
                                fArray[n + i] = fArray2[n3] - fArray2[n2];
                                fArray[n + ((FloatDHT_1D)FloatDHT_1D.this).n - i] = fArray2[n3] + fArray2[n2];
                            }
                        }
                    });
                }
                try {
                    F.A(futureArray);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(FloatDHT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(FloatDHT_1D.class.getName()).log(Level.SEVERE, null, executionException);
                }
            } else {
                for (int i = 1; i < n2; ++i) {
                    int n7 = 2 * i;
                    int n8 = n7 + 1;
                    fArray[n + i] = fArray2[n7] - fArray2[n8];
                    fArray[n + this.n - i] = fArray2[n7] + fArray2[n8];
                }
            }
            if (this.n % 2 == 0) {
                fArray[n + n2] = fArray2[1];
            } else {
                fArray[n + n2] = fArray2[this.n - 1] - fArray2[1];
                fArray[n + n2 + 1] = fArray2[this.n - 1] + fArray2[1];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final D d, final long l) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(d.F(), (int)l);
            return;
        } else {
            this.fft.realForward(d, l);
            final D d2 = new D(this.nl, false);
            C.A(d, l, d2, 0L, this.nl);
            long l2 = this.nl / 2L;
            int n = F.A();
            if (n > 1 && l2 > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l3 = l2 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l4 = 1L + (long)i * l3;
                    final long l5 = i == n - 1 ? l2 : l4 + l3;
                    futureArray[i] = F.A(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                long l3 = 2L * i;
                                long l2 = l3 + 1L;
                                d.A(l + i, d2.C(l3) - d2.C(l2));
                                d.A(l + FloatDHT_1D.this.nl - i, d2.C(l3) + d2.C(l2));
                            }
                        }
                    });
                }
                try {
                    F.A(futureArray);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(FloatDHT_1D.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(FloatDHT_1D.class.getName()).log(Level.SEVERE, null, executionException);
                }
            } else {
                for (long i = 1L; i < l2; ++i) {
                    long l6 = 2L * i;
                    long l7 = l6 + 1L;
                    d.A(l + i, d2.C(l6) - d2.C(l7));
                    d.A(l + this.nl - i, d2.C(l6) + d2.C(l7));
                }
            }
            if (this.nl % 2L == 0L) {
                d.A(l + l2, d2.C(1L));
                return;
            } else {
                d.A(l + l2, d2.C(this.nl - 1L) - d2.C(1L));
                d.A(l + l2 + 1L, d2.C(this.nl - 1L) + d2.C(1L));
            }
        }
    }

    public void inverse(float[] fArray, boolean bl) {
        this.inverse(fArray, 0, bl);
    }

    public void inverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new D(fArray), (long)n, bl);
        } else {
            this.forward(fArray, n);
            if (bl) {
                CommonUtils.scale(this.n, 1.0f / (float)this.n, fArray, n, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(D d, long l, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (!this.useLargeArrays) {
            if (d.A() || d.B() || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(d.F(), (int)l, bl);
            return;
        } else {
            this.forward(d, l);
            if (!bl) return;
            CommonUtils.scale((long)this.n, 1.0f / (float)this.n, d, l, false);
        }
    }
}

