/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.util.FastMathLiteralArrays;

public class FastMath {
    private static final double LOG_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    private static final double[][] LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};
    private static final double[][] LN_HI_PREC_COEF = new double[][]{{1.0, -6.032174644509064E-23}, {-0.25, -0.25}, {0.3333333134651184, 1.9868161777724352E-8}, {-0.2499999701976776, -2.957007209750105E-8}, {0.19999954104423523, 1.5830993332061267E-10}, {-0.1662488f, -2.6033824355191673E-8}};
    private static final double[] SINE_TABLE_A = new double[]{0.0, 0.1246747374534607, 0.24740394949913025, 0.366272509098053, 0.4794255495071411, 0.5850973129272461, 0.6816387176513672, 0.7675435543060303, 0.8414709568023682, 0.902267575263977, 0.9489846229553223, 0.980893f, 0.9974949359893799, 0.9985313415527344};
    private static final double[] SINE_TABLE_B = new double[]{0.0, -4.068233003401932E-9, 9.755392680573412E-9, 1.9987994582857286E-8, -1.0902938113007961E-8, -3.9986783938944604E-8, 4.23719669792332E-8, -5.207000323380292E-8, 2.800552834259E-8, 1.883511811213715E-8, -3.5997360512765566E-9, 4.116164446561962E-8, 5.0614674548127384E-8, -1.0129027912496858E-9};
    private static final double[] COSINE_TABLE_A = new double[]{1.0, 0.9921976327896118, 0.9689123630523682, 0.9305076599121094, 0.8775825500488281, 0.8109631538391113, 0.7316888570785522, 0.6409968137741089, 0.5403022766113281, 0.4311765432357788, 0.3153223395347595, 0.19454771280288696, 0.0707372f, -0.05417713522911072};
    private static final double[] COSINE_TABLE_B = new double[]{0.0, 3.4439717236742845E-8, 5.865827662008209E-8, -3.7999795083850525E-8, 1.184154459111628E-8, -3.43338934259355E-8, 1.1795268640216787E-8, 4.438921624363781E-8, 2.925681159240093E-8, -2.6437112632041807E-8, 2.2860509143963117E-8, -4.813899778443457E-9, 3.6725170580355583E-9, 2.0217439756338078E-10};
    private static final double[] TANGENT_TABLE_A = new double[]{0.0, 0.1256551444530487, 0.25534194707870483, 0.3936265707015991, 0.5463024377822876, 0.7214844226837158, 0.9315965175628662, 1.1974215507507324, 1.5574076175689697, 2.092571258544922, 3.0095696449279785, 5.041914939880371, 14.101419448852539, -18.430862426757812};
    private static final double[] TANGENT_TABLE_B = new double[]{0.0, -7.877917738262007E-9, -2.5857668567479893E-8, 5.2240336371356666E-9, 5.206150291559893E-8, 1.8307188599677033E-8, -5.7618793749770706E-8, 7.848361555046424E-8, 1.0708593250394448E-7, 1.7827257129423813E-8, 2.893485277253286E-8, 3.1660099222737955E-7, 4.983191803254889E-7, -3.356118100840571E-7};
    private static final long[] RECIP_2PI = new long[]{2935890503282001226L, 9154082963658192752L, 3952090531849364496L, 9193070505571053912L, 7910884519577875640L, 113236205062349959L, 4577762542105553359L, -5034868814120038111L, 4208363204685324176L, 5648769086999809661L, 2819561105158720014L, -4035746434778044925L, -302932621132653753L, -2644281811660520851L, -3183605296591799669L, 6722166367014452318L, -3512299194304650054L, -7278142539171889152L};
    private static final long[] PI_O_4_BITS = new long[]{-3958705157555305932L, -4267615245585081135L};
    private static final double[] EIGHTHS = new double[]{0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0, 1.125, 1.25, 1.375, 1.5, 1.625};
    private static final double[] CBRTTWO = new double[]{0.6299605249474366, 0.7937005259840998, 1.0, 1.2599210498948732, 1.5874010519681994};

    public static double log(double d) {
        return FastMath.log(d, null);
    }

    private static double log(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        long l = Double.doubleToRawLongBits(d);
        if (((l & Long.MIN_VALUE) != 0L || d != d) && d != 0.0) {
            if (dArray != null) {
                dArray[0] = Double.NaN;
            }
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            if (dArray != null) {
                dArray[0] = Double.POSITIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        int n = (int)(l >> 52) - 1023;
        if ((l & 0x7FF0000000000000L) == 0L) {
            if (d == 0.0) {
                if (dArray != null) {
                    dArray[0] = Double.NEGATIVE_INFINITY;
                }
                return Double.NEGATIVE_INFINITY;
            }
            l <<= 1;
            while ((l & 0x10000000000000L) == 0L) {
                --n;
                l <<= 1;
            }
        }
        if ((n == -1 || n == 0) && d < 1.01 && d > 0.99 && dArray == null) {
            double d6 = d - 1.0;
            double d7 = d6 - d + 1.0;
            double d8 = d6 * 1.073741824E9;
            double d9 = d6 + d8 - d8;
            double d10 = d6 - d9;
            d6 = d9;
            d7 = d10;
            double[] dArray2 = LN_QUICK_COEF[LN_QUICK_COEF.length - 1];
            double d11 = dArray2[0];
            double d12 = dArray2[1];
            for (int i = LN_QUICK_COEF.length - 2; i >= 0; --i) {
                d9 = d11 * d6;
                d10 = d11 * d7 + d12 * d6 + d12 * d7;
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
                double[] dArray3 = LN_QUICK_COEF[i];
                d9 = d11 + dArray3[0];
                d10 = d12 + dArray3[1];
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
            }
            d9 = d11 * d6;
            d10 = d11 * d7 + d12 * d6 + d12 * d7;
            d8 = d9 * 1.073741824E9;
            d11 = d9 + d8 - d8;
            d12 = d9 - d11 + d10;
            return d11 + d12;
        }
        double[] dArray4 = lnMant.LN_MANT[(int)((l & 0xFFC0000000000L) >> 42)];
        double d13 = (double)(l & 0x3FFFFFFFFFFL) / (4.503599627370496E15 + (double)(l & 0xFFC0000000000L));
        double d14 = 0.0;
        double d15 = 0.0;
        if (dArray != null) {
            d5 = d13 * 1.073741824E9;
            d4 = d13 + d5 - d5;
            d3 = d13 - d4;
            d2 = d4;
            double d16 = d3;
            double d17 = l & 0x3FFFFFFFFFFL;
            double d18 = 4.503599627370496E15 + (double)(l & 0xFFC0000000000L);
            d4 = d17 - d2 * d18 - d16 * d18;
            d16 += d4 / d18;
            double[] dArray5 = LN_HI_PREC_COEF[LN_HI_PREC_COEF.length - 1];
            double d19 = dArray5[0];
            double d20 = dArray5[1];
            for (int i = LN_HI_PREC_COEF.length - 2; i >= 0; --i) {
                d4 = d19 * d2;
                d3 = d19 * d16 + d20 * d2 + d20 * d16;
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
                double[] dArray6 = LN_HI_PREC_COEF[i];
                d4 = d19 + dArray6[0];
                d3 = d20 + dArray6[1];
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
            }
            d4 = d19 * d2;
            d3 = d19 * d16 + d20 * d2 + d20 * d16;
            d14 = d4 + d3;
            d15 = -(d14 - d4 - d3);
        } else {
            d14 = -0.16624882440418567;
            d14 = d14 * d13 + 0.19999954120254515;
            d14 = d14 * d13 + -0.2499999997677497;
            d14 = d14 * d13 + 0.3333333333332802;
            d14 = d14 * d13 + -0.5;
            d14 = d14 * d13 + 1.0;
            d14 *= d13;
        }
        d5 = 0.6931470632553101 * (double)n;
        d4 = 0.0;
        d3 = d5 + dArray4[0];
        d2 = -(d3 - d5 - dArray4[0]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d14;
        d2 = -(d3 - d5 - d14);
        d5 = d3;
        d4 += d2;
        d3 = d5 + 1.1730463525082348E-7 * (double)n;
        d2 = -(d3 - d5 - 1.1730463525082348E-7 * (double)n);
        d5 = d3;
        d4 += d2;
        d3 = d5 + dArray4[1];
        d2 = -(d3 - d5 - dArray4[1]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d15;
        d2 = -(d3 - d5 - d15);
        d5 = d3;
        d4 += d2;
        if (dArray != null) {
            dArray[0] = d5;
            dArray[1] = d4;
        }
        return d5 + d4;
    }

    private static double polySine(double d) {
        double d2 = d * d;
        double d3 = 2.7553817452272217E-6;
        d3 = d3 * d2 + -1.9841269659586505E-4;
        d3 = d3 * d2 + 0.008333333333329196;
        d3 = d3 * d2 + -0.16666666666666666;
        d3 = d3 * d2 * d;
        return d3;
    }

    private static double polyCosine(double d) {
        double d2 = d * d;
        double d3 = 2.479773539153719E-5;
        d3 = d3 * d2 + -0.0013888888689039883;
        d3 = d3 * d2 + 0.041666666666621166;
        d3 = d3 * d2 + -0.49999999999999994;
        return d3 *= d2;
    }

    private static double sinQ(double d, double d2) {
        int n = (int)(d * 8.0 + 0.5);
        double d3 = d - EIGHTHS[n];
        double d4 = SINE_TABLE_A[n];
        double d5 = SINE_TABLE_B[n];
        double d6 = COSINE_TABLE_A[n];
        double d7 = COSINE_TABLE_B[n];
        double d8 = d3;
        double d9 = FastMath.polySine(d3);
        double d10 = 1.0;
        double d11 = FastMath.polyCosine(d3);
        double d12 = d8 * 1.073741824E9;
        double d13 = d8 + d12 - d12;
        d9 += d8 - d13;
        d8 = d13;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d4;
        double d17 = d14 + d16;
        double d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d16 = d6 * d8;
        d17 = d14 + d16;
        d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d15 = d15 + d4 * d11 + d6 * d9;
        d15 = d15 + d5 + d7 * d8 + d5 * d11 + d7 * d9;
        if (d2 != 0.0) {
            d16 = ((d6 + d7) * (1.0 + d11) - (d4 + d5) * (d8 + d9)) * d2;
            d17 = d14 + d16;
            d18 = -(d17 - d14 - d16);
            d14 = d17;
            d15 += d18;
        }
        double d19 = d14 + d15;
        return d19;
    }

    private static double cosQ(double d, double d2) {
        double d3 = 1.5707963267948966;
        double d4 = 6.123233995736766E-17;
        double d5 = 1.5707963267948966 - d;
        double d6 = -(d5 - 1.5707963267948966 + d);
        return FastMath.sinQ(d5, d6 += 6.123233995736766E-17 - d2);
    }

    private static void reducePayneHanek(double d, double[] dArray) {
        boolean bl;
        long l;
        long l2;
        long l3;
        int n;
        int n2;
        long l4 = Double.doubleToRawLongBits(d);
        int n3 = (int)(l4 >> 52 & 0x7FFL) - 1023;
        l4 &= 0xFFFFFFFFFFFFFL;
        l4 |= 0x10000000000000L;
        l4 <<= 11;
        if ((n2 = ++n3 - ((n = n3 >> 6) << 6)) != 0) {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1] << n2;
            l3 |= RECIP_2PI[n] >>> 64 - n2;
            l2 = RECIP_2PI[n] << n2 | RECIP_2PI[n + 1] >>> 64 - n2;
            l = RECIP_2PI[n + 1] << n2 | RECIP_2PI[n + 2] >>> 64 - n2;
        } else {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1];
            l2 = RECIP_2PI[n];
            l = RECIP_2PI[n + 1];
        }
        long l5 = l4 >>> 32;
        long l6 = l4 & 0xFFFFFFFFL;
        long l7 = l2 >>> 32;
        long l8 = l2 & 0xFFFFFFFFL;
        long l9 = l5 * l7;
        long l10 = l6 * l8;
        long l11 = l6 * l7;
        long l12 = l5 * l8;
        long l13 = l10 + (l12 << 32);
        long l14 = l9 + (l12 >>> 32);
        boolean bl2 = (l10 & Long.MIN_VALUE) != 0L;
        boolean bl3 = (l12 & 0x80000000L) != 0L;
        boolean bl4 = bl = (l13 & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        bl2 = (l13 & Long.MIN_VALUE) != 0L;
        bl3 = (l11 & 0x80000000L) != 0L;
        l14 += l11 >>> 32;
        boolean bl5 = bl = ((l13 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        l7 = l >>> 32;
        l8 = l & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l13 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl6 = bl = ((l13 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        l7 = l3 >>> 32;
        l8 = l3 & 0xFFFFFFFFL;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        int n4 = (int)((l14 += l10 + (l11 + l12 << 32)) >>> 62);
        l14 <<= 2;
        l14 |= l13 >>> 62;
        l13 <<= 2;
        l5 = l14 >>> 32;
        l6 = l14 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        long l15 = l10 + (l12 << 32);
        long l16 = l9 + (l12 >>> 32);
        bl2 = (l10 & Long.MIN_VALUE) != 0L;
        bl3 = (l12 & 0x80000000L) != 0L;
        boolean bl7 = bl = (l15 & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = (l11 & 0x80000000L) != 0L;
        l16 += l11 >>> 32;
        boolean bl8 = bl = ((l15 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        l7 = PI_O_4_BITS[1] >>> 32;
        l8 = PI_O_4_BITS[1] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl9 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        l5 = l13 >>> 32;
        l6 = l13 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl10 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        double d2 = (double)(l16 >>> 12) / 4.503599627370496E15;
        double d3 = (double)(((l16 & 0xFFFL) << 40) + (l15 >>> 24)) / 4.503599627370496E15 / 4.503599627370496E15;
        double d4 = d2 + d3;
        double d5 = -(d4 - d2 - d3);
        dArray[0] = n4;
        dArray[1] = d4 * 2.0;
        dArray[2] = d5 * 2.0;
    }

    public static double sin(double d) {
        boolean bl = false;
        int n = 0;
        double d2 = 0.0;
        double d3 = d;
        if (d < 0.0) {
            bl = true;
            d3 = -d3;
        }
        if (d3 == 0.0) {
            long l = Double.doubleToRawLongBits(d);
            if (l < 0L) {
                return -0.0;
            }
            return 0.0;
        }
        if (d3 != d3 || d3 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        if (d3 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d3, dArray);
            n = (int)dArray[0] & 3;
            d3 = dArray[1];
            d2 = dArray[2];
        } else if (d3 > 1.5707963267948966) {
            CodyWaite codyWaite = new CodyWaite(d3);
            n = codyWaite.getK() & 3;
            d3 = codyWaite.getRemA();
            d2 = codyWaite.getRemB();
        }
        if (bl) {
            n ^= 2;
        }
        switch (n) {
            case 0: {
                return FastMath.sinQ(d3, d2);
            }
            case 1: {
                return FastMath.cosQ(d3, d2);
            }
            case 2: {
                return -FastMath.sinQ(d3, d2);
            }
            case 3: {
                return -FastMath.cosQ(d3, d2);
            }
        }
        return Double.NaN;
    }

    public static double cos(double d) {
        int n = 0;
        double d2 = d;
        if (d < 0.0) {
            d2 = -d2;
        }
        if (d2 != d2 || d2 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        double d3 = 0.0;
        if (d2 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d2, dArray);
            n = (int)dArray[0] & 3;
            d2 = dArray[1];
            d3 = dArray[2];
        } else if (d2 > 1.5707963267948966) {
            CodyWaite codyWaite = new CodyWaite(d2);
            n = codyWaite.getK() & 3;
            d2 = codyWaite.getRemA();
            d3 = codyWaite.getRemB();
        }
        switch (n) {
            case 0: {
                return FastMath.cosQ(d2, d3);
            }
            case 1: {
                return -FastMath.sinQ(d2, d3);
            }
            case 2: {
                return -FastMath.cosQ(d2, d3);
            }
            case 3: {
                return FastMath.sinQ(d2, d3);
            }
        }
        return Double.NaN;
    }

    public static double floor(double d) {
        if (d != d) {
            return d;
        }
        if (d >= 4.503599627370496E15 || d <= -4.503599627370496E15) {
            return d;
        }
        long l = (long)d;
        if (d < 0.0 && (double)l != d) {
            --l;
        }
        if (l == 0L) {
            return d * (double)l;
        }
        return l;
    }

    public static double ceil(double d) {
        if (d != d) {
            return d;
        }
        double d2 = FastMath.floor(d);
        if (d2 == d) {
            return d2;
        }
        if ((d2 += 1.0) == 0.0) {
            return d * d2;
        }
        return d2;
    }

    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    private static class CodyWaite {
        private final int finalK;
        private final double finalRemA;
        private final double finalRemB;

        CodyWaite(double d) {
            double d2;
            double d3;
            int n = (int)(d * 0.6366197723675814);
            while (true) {
                double d4 = (double)(-n) * 1.570796251296997;
                d3 = d + d4;
                d2 = -(d3 - d - d4);
                d4 = (double)(-n) * 7.549789948768648E-8;
                double d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                d4 = (double)(-n) * 6.123233995736766E-17;
                d5 = d3;
                d3 = d4 + d5;
                d2 += -(d3 - d5 - d4);
                if (d3 > 0.0) break;
                --n;
            }
            this.finalK = n;
            this.finalRemA = d3;
            this.finalRemB = d2;
        }

        int getK() {
            return this.finalK;
        }

        double getRemA() {
            return this.finalRemA;
        }

        double getRemB() {
            return this.finalRemB;
        }
    }

    private static class lnMant {
        private static final double[][] LN_MANT = FastMathLiteralArrays.loadLnMant();
    }
}

