/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class SquareConfiguration {
    private final Double frequency;
    private final Integer dutyCyclePercent;
    private final Boolean bandLimit;
    private final Boolean addDither;
    private final Integer ditherBits;

    SquareConfiguration(Double d2, Integer n2, Boolean bl, Boolean bl2, Integer n3) {
        this.frequency = d2;
        this.dutyCyclePercent = n2;
        this.bandLimit = bl;
        this.addDither = bl2;
        this.ditherBits = n3;
    }

    public static SquareConfigurationBuilder builder() {
        return new SquareConfigurationBuilder();
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public Integer getDutyCyclePercent() {
        return this.dutyCyclePercent;
    }

    public Boolean getBandLimit() {
        return this.bandLimit;
    }

    public Boolean getAddDither() {
        return this.addDither;
    }

    public Integer getDitherBits() {
        return this.ditherBits;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SquareConfiguration)) {
            return false;
        }
        SquareConfiguration squareConfiguration = (SquareConfiguration)object;
        if (!squareConfiguration.canEqual(this)) {
            return false;
        }
        Double d2 = this.getFrequency();
        Double d3 = squareConfiguration.getFrequency();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Integer n2 = this.getDutyCyclePercent();
        Integer n3 = squareConfiguration.getDutyCyclePercent();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Boolean bl = this.getBandLimit();
        Boolean bl2 = squareConfiguration.getBandLimit();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Boolean bl3 = this.getAddDither();
        Boolean bl4 = squareConfiguration.getAddDither();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        Integer n4 = this.getDitherBits();
        Integer n5 = squareConfiguration.getDitherBits();
        return !(n4 == null ? n5 != null : !((Object)n4).equals(n5));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SquareConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Double d2 = this.getFrequency();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Integer n4 = this.getDutyCyclePercent();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Boolean bl = this.getBandLimit();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Boolean bl2 = this.getAddDither();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        Integer n5 = this.getDitherBits();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        return n3;
    }

    public String toString() {
        return "SquareConfiguration(frequency=" + this.getFrequency() + ", dutyCyclePercent=" + this.getDutyCyclePercent() + ", bandLimit=" + this.getBandLimit() + ", addDither=" + this.getAddDither() + ", ditherBits=" + this.getDitherBits() + ")";
    }

    public static class SquareConfigurationBuilder {
        private Double frequency;
        private Integer dutyCyclePercent;
        private Boolean bandLimit;
        private Boolean addDither;
        private Integer ditherBits;

        SquareConfigurationBuilder() {
        }

        public SquareConfigurationBuilder frequency(Double d2) {
            this.frequency = d2;
            return this;
        }

        public SquareConfigurationBuilder dutyCyclePercent(Integer n2) {
            this.dutyCyclePercent = n2;
            return this;
        }

        public SquareConfigurationBuilder bandLimit(Boolean bl) {
            this.bandLimit = bl;
            return this;
        }

        public SquareConfigurationBuilder addDither(Boolean bl) {
            this.addDither = bl;
            return this;
        }

        public SquareConfigurationBuilder ditherBits(Integer n2) {
            this.ditherBits = n2;
            return this;
        }

        public SquareConfiguration build() {
            return new SquareConfiguration(this.frequency, this.dutyCyclePercent, this.bandLimit, this.addDither, this.ditherBits);
        }

        public String toString() {
            return "SquareConfiguration.SquareConfigurationBuilder(frequency=" + this.frequency + ", dutyCyclePercent=" + this.dutyCyclePercent + ", bandLimit=" + this.bandLimit + ", addDither=" + this.addDither + ", ditherBits=" + this.ditherBits + ")";
        }
    }
}

