/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public enum SingleMeasurementCommand {
    SAVE("Save"),
    MIN_PHASE("Minimum phase version"),
    EXCESS_PHASE("Excess phase version"),
    MIC_IN_BOX("Mic in box correction"),
    RESPONSE_COPY("Response copy"),
    MERGE_CAL("Merge cal data to IR"),
    TRIM_IR("Trim IR to windows"),
    APPLY_SMOOTHING("Smooth"),
    GENERATE_WATERFALL("Generate waterfall"),
    GENERATE_EQ_WATERFALL("Generate equalised waterfall"),
    GENERATE_SPECTROGRAM("Generate spectrogram"),
    GENERATE_EQ_SPECTROGRAM("Generate equalised spectrogram"),
    ESTIMATE_IR_DELAY("Estimate IR delay"),
    OFFSET_T_ZERO("Offset t=0"),
    ADD_SPL_OFFSET("Add SPL offset");

    private String commandName;

    private SingleMeasurementCommand(String string2) {
        this.commandName = string2;
    }

    public String commandName() {
        return this.commandName;
    }

    public boolean generatesCSD() {
        switch (this) {
            case GENERATE_EQ_SPECTROGRAM: 
            case GENERATE_EQ_WATERFALL: 
            case GENERATE_SPECTROGRAM: 
            case GENERATE_WATERFALL: {
                return true;
            }
        }
        return false;
    }

    public static SingleMeasurementCommand getFromCommandName(String string) {
        for (SingleMeasurementCommand singleMeasurementCommand : SingleMeasurementCommand.values()) {
            if (!singleMeasurementCommand.commandName().equalsIgnoreCase(string)) continue;
            return singleMeasurementCommand;
        }
        return null;
    }
}

