/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class SineConfiguration {
    private final Double frequency;
    private final Boolean lockFrequencyToRTAFFT;
    private final Boolean addHarmonicDistortion;
    private final Boolean addDither;
    private final Integer ditherBits;

    SineConfiguration(Double d2, Boolean bl, Boolean bl2, Boolean bl3, Integer n2) {
        this.frequency = d2;
        this.lockFrequencyToRTAFFT = bl;
        this.addHarmonicDistortion = bl2;
        this.addDither = bl3;
        this.ditherBits = n2;
    }

    public static SineConfigurationBuilder builder() {
        return new SineConfigurationBuilder();
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public Boolean getLockFrequencyToRTAFFT() {
        return this.lockFrequencyToRTAFFT;
    }

    public Boolean getAddHarmonicDistortion() {
        return this.addHarmonicDistortion;
    }

    public Boolean getAddDither() {
        return this.addDither;
    }

    public Integer getDitherBits() {
        return this.ditherBits;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SineConfiguration)) {
            return false;
        }
        SineConfiguration sineConfiguration = (SineConfiguration)object;
        if (!sineConfiguration.canEqual(this)) {
            return false;
        }
        Double d2 = this.getFrequency();
        Double d3 = sineConfiguration.getFrequency();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Boolean bl = this.getLockFrequencyToRTAFFT();
        Boolean bl2 = sineConfiguration.getLockFrequencyToRTAFFT();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Boolean bl3 = this.getAddHarmonicDistortion();
        Boolean bl4 = sineConfiguration.getAddHarmonicDistortion();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        Boolean bl5 = this.getAddDither();
        Boolean bl6 = sineConfiguration.getAddDither();
        if (bl5 == null ? bl6 != null : !((Object)bl5).equals(bl6)) {
            return false;
        }
        Integer n2 = this.getDitherBits();
        Integer n3 = sineConfiguration.getDitherBits();
        return !(n2 == null ? n3 != null : !((Object)n2).equals(n3));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SineConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Double d2 = this.getFrequency();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Boolean bl = this.getLockFrequencyToRTAFFT();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Boolean bl2 = this.getAddHarmonicDistortion();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        Boolean bl3 = this.getAddDither();
        n3 = n3 * 59 + (bl3 == null ? 43 : ((Object)bl3).hashCode());
        Integer n4 = this.getDitherBits();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        return n3;
    }

    public String toString() {
        return "SineConfiguration(frequency=" + this.getFrequency() + ", lockFrequencyToRTAFFT=" + this.getLockFrequencyToRTAFFT() + ", addHarmonicDistortion=" + this.getAddHarmonicDistortion() + ", addDither=" + this.getAddDither() + ", ditherBits=" + this.getDitherBits() + ")";
    }

    public static class SineConfigurationBuilder {
        private Double frequency;
        private Boolean lockFrequencyToRTAFFT;
        private Boolean addHarmonicDistortion;
        private Boolean addDither;
        private Integer ditherBits;

        SineConfigurationBuilder() {
        }

        public SineConfigurationBuilder frequency(Double d2) {
            this.frequency = d2;
            return this;
        }

        public SineConfigurationBuilder lockFrequencyToRTAFFT(Boolean bl) {
            this.lockFrequencyToRTAFFT = bl;
            return this;
        }

        public SineConfigurationBuilder addHarmonicDistortion(Boolean bl) {
            this.addHarmonicDistortion = bl;
            return this;
        }

        public SineConfigurationBuilder addDither(Boolean bl) {
            this.addDither = bl;
            return this;
        }

        public SineConfigurationBuilder ditherBits(Integer n2) {
            this.ditherBits = n2;
            return this;
        }

        public SineConfiguration build() {
            return new SineConfiguration(this.frequency, this.lockFrequencyToRTAFFT, this.addHarmonicDistortion, this.addDither, this.ditherBits);
        }

        public String toString() {
            return "SineConfiguration.SineConfigurationBuilder(frequency=" + this.frequency + ", lockFrequencyToRTAFFT=" + this.lockFrequencyToRTAFFT + ", addHarmonicDistortion=" + this.addHarmonicDistortion + ", addDither=" + this.addDither + ", ditherBits=" + this.ditherBits + ")";
        }
    }
}

