/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class SawtoothConfiguration {
    private final Double frequency;
    private final Boolean bandLimit;
    private final Boolean invert;
    private final Boolean addDither;
    private final Integer ditherBits;

    SawtoothConfiguration(Double d2, Boolean bl, Boolean bl2, Boolean bl3, Integer n2) {
        this.frequency = d2;
        this.bandLimit = bl;
        this.invert = bl2;
        this.addDither = bl3;
        this.ditherBits = n2;
    }

    public static SawtoothConfigurationBuilder builder() {
        return new SawtoothConfigurationBuilder();
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public Boolean getBandLimit() {
        return this.bandLimit;
    }

    public Boolean getInvert() {
        return this.invert;
    }

    public Boolean getAddDither() {
        return this.addDither;
    }

    public Integer getDitherBits() {
        return this.ditherBits;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SawtoothConfiguration)) {
            return false;
        }
        SawtoothConfiguration sawtoothConfiguration = (SawtoothConfiguration)object;
        if (!sawtoothConfiguration.canEqual(this)) {
            return false;
        }
        Double d2 = this.getFrequency();
        Double d3 = sawtoothConfiguration.getFrequency();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Boolean bl = this.getBandLimit();
        Boolean bl2 = sawtoothConfiguration.getBandLimit();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Boolean bl3 = this.getInvert();
        Boolean bl4 = sawtoothConfiguration.getInvert();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        Boolean bl5 = this.getAddDither();
        Boolean bl6 = sawtoothConfiguration.getAddDither();
        if (bl5 == null ? bl6 != null : !((Object)bl5).equals(bl6)) {
            return false;
        }
        Integer n2 = this.getDitherBits();
        Integer n3 = sawtoothConfiguration.getDitherBits();
        return !(n2 == null ? n3 != null : !((Object)n2).equals(n3));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SawtoothConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Double d2 = this.getFrequency();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Boolean bl = this.getBandLimit();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Boolean bl2 = this.getInvert();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        Boolean bl3 = this.getAddDither();
        n3 = n3 * 59 + (bl3 == null ? 43 : ((Object)bl3).hashCode());
        Integer n4 = this.getDitherBits();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        return n3;
    }

    public String toString() {
        return "SawtoothConfiguration(frequency=" + this.getFrequency() + ", bandLimit=" + this.getBandLimit() + ", invert=" + this.getInvert() + ", addDither=" + this.getAddDither() + ", ditherBits=" + this.getDitherBits() + ")";
    }

    public static class SawtoothConfigurationBuilder {
        private Double frequency;
        private Boolean bandLimit;
        private Boolean invert;
        private Boolean addDither;
        private Integer ditherBits;

        SawtoothConfigurationBuilder() {
        }

        public SawtoothConfigurationBuilder frequency(Double d2) {
            this.frequency = d2;
            return this;
        }

        public SawtoothConfigurationBuilder bandLimit(Boolean bl) {
            this.bandLimit = bl;
            return this;
        }

        public SawtoothConfigurationBuilder invert(Boolean bl) {
            this.invert = bl;
            return this;
        }

        public SawtoothConfigurationBuilder addDither(Boolean bl) {
            this.addDither = bl;
            return this;
        }

        public SawtoothConfigurationBuilder ditherBits(Integer n2) {
            this.ditherBits = n2;
            return this;
        }

        public SawtoothConfiguration build() {
            return new SawtoothConfiguration(this.frequency, this.bandLimit, this.invert, this.addDither, this.ditherBits);
        }

        public String toString() {
            return "SawtoothConfiguration.SawtoothConfigurationBuilder(frequency=" + this.frequency + ", bandLimit=" + this.bandLimit + ", invert=" + this.invert + ", addDither=" + this.addDither + ", ditherBits=" + this.ditherBits + ")";
        }
    }
}

