/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class RoomPosition {
    private final String unit;
    private final Double fromRear;
    private final Double fromLeft;
    private final Double fromFloor;

    RoomPosition(String string, Double d2, Double d3, Double d4) {
        this.unit = string;
        this.fromRear = d2;
        this.fromLeft = d3;
        this.fromFloor = d4;
    }

    public static RoomPositionBuilder builder() {
        return new RoomPositionBuilder();
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getFromRear() {
        return this.fromRear;
    }

    public Double getFromLeft() {
        return this.fromLeft;
    }

    public Double getFromFloor() {
        return this.fromFloor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RoomPosition)) {
            return false;
        }
        RoomPosition roomPosition = (RoomPosition)object;
        if (!roomPosition.canEqual(this)) {
            return false;
        }
        Double d2 = this.getFromRear();
        Double d3 = roomPosition.getFromRear();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Double d4 = this.getFromLeft();
        Double d5 = roomPosition.getFromLeft();
        if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
            return false;
        }
        Double d6 = this.getFromFloor();
        Double d7 = roomPosition.getFromFloor();
        if (d6 == null ? d7 != null : !((Object)d6).equals(d7)) {
            return false;
        }
        String string = this.getUnit();
        String string2 = roomPosition.getUnit();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof RoomPosition;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Double d2 = this.getFromRear();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Double d3 = this.getFromLeft();
        n3 = n3 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
        Double d4 = this.getFromFloor();
        n3 = n3 * 59 + (d4 == null ? 43 : ((Object)d4).hashCode());
        String string = this.getUnit();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        return n3;
    }

    public String toString() {
        return "RoomPosition(unit=" + this.getUnit() + ", fromRear=" + this.getFromRear() + ", fromLeft=" + this.getFromLeft() + ", fromFloor=" + this.getFromFloor() + ")";
    }

    public static class RoomPositionBuilder {
        private String unit;
        private Double fromRear;
        private Double fromLeft;
        private Double fromFloor;

        RoomPositionBuilder() {
        }

        public RoomPositionBuilder unit(String string) {
            this.unit = string;
            return this;
        }

        public RoomPositionBuilder fromRear(Double d2) {
            this.fromRear = d2;
            return this;
        }

        public RoomPositionBuilder fromLeft(Double d2) {
            this.fromLeft = d2;
            return this;
        }

        public RoomPositionBuilder fromFloor(Double d2) {
            this.fromFloor = d2;
            return this;
        }

        public RoomPosition build() {
            return new RoomPosition(this.unit, this.fromRear, this.fromLeft, this.fromFloor);
        }

        public String toString() {
            return "RoomPosition.RoomPositionBuilder(unit=" + this.unit + ", fromRear=" + this.fromRear + ", fromLeft=" + this.fromLeft + ", fromFloor=" + this.fromFloor + ")";
        }
    }
}

