/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class RTAConfiguration {
    private final String mode;
    private final String smoothing;
    private final String fftLength;
    private final String window;
    private final String averaging;
    private final Boolean stopAt;
    private final Integer stopAtValue;
    private final String maximumOverlap;
    private final Boolean calcDistortionEnabled;
    private final Boolean restartCaptureOnGeneratorChange;
    private final Boolean use64BitFFT;
    private final Boolean adjustRTALevels;
    private final Boolean fundamentalFromSineGen;

    RTAConfiguration(String string, String string2, String string3, String string4, String string5, Boolean bl, Integer n2, String string6, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6) {
        this.mode = string;
        this.smoothing = string2;
        this.fftLength = string3;
        this.window = string4;
        this.averaging = string5;
        this.stopAt = bl;
        this.stopAtValue = n2;
        this.maximumOverlap = string6;
        this.calcDistortionEnabled = bl2;
        this.restartCaptureOnGeneratorChange = bl3;
        this.use64BitFFT = bl4;
        this.adjustRTALevels = bl5;
        this.fundamentalFromSineGen = bl6;
    }

    public static RTAConfigurationBuilder builder() {
        return new RTAConfigurationBuilder();
    }

    public String getMode() {
        return this.mode;
    }

    public String getSmoothing() {
        return this.smoothing;
    }

    public String getFftLength() {
        return this.fftLength;
    }

    public String getWindow() {
        return this.window;
    }

    public String getAveraging() {
        return this.averaging;
    }

    public Boolean getStopAt() {
        return this.stopAt;
    }

    public Integer getStopAtValue() {
        return this.stopAtValue;
    }

    public String getMaximumOverlap() {
        return this.maximumOverlap;
    }

    public Boolean getCalcDistortionEnabled() {
        return this.calcDistortionEnabled;
    }

    public Boolean getRestartCaptureOnGeneratorChange() {
        return this.restartCaptureOnGeneratorChange;
    }

    public Boolean getUse64BitFFT() {
        return this.use64BitFFT;
    }

    public Boolean getAdjustRTALevels() {
        return this.adjustRTALevels;
    }

    public Boolean getFundamentalFromSineGen() {
        return this.fundamentalFromSineGen;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RTAConfiguration)) {
            return false;
        }
        RTAConfiguration rTAConfiguration = (RTAConfiguration)object;
        if (!rTAConfiguration.canEqual(this)) {
            return false;
        }
        Boolean bl = this.getStopAt();
        Boolean bl2 = rTAConfiguration.getStopAt();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Integer n2 = this.getStopAtValue();
        Integer n3 = rTAConfiguration.getStopAtValue();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Boolean bl3 = this.getCalcDistortionEnabled();
        Boolean bl4 = rTAConfiguration.getCalcDistortionEnabled();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        Boolean bl5 = this.getRestartCaptureOnGeneratorChange();
        Boolean bl6 = rTAConfiguration.getRestartCaptureOnGeneratorChange();
        if (bl5 == null ? bl6 != null : !((Object)bl5).equals(bl6)) {
            return false;
        }
        Boolean bl7 = this.getUse64BitFFT();
        Boolean bl8 = rTAConfiguration.getUse64BitFFT();
        if (bl7 == null ? bl8 != null : !((Object)bl7).equals(bl8)) {
            return false;
        }
        Boolean bl9 = this.getAdjustRTALevels();
        Boolean bl10 = rTAConfiguration.getAdjustRTALevels();
        if (bl9 == null ? bl10 != null : !((Object)bl9).equals(bl10)) {
            return false;
        }
        Boolean bl11 = this.getFundamentalFromSineGen();
        Boolean bl12 = rTAConfiguration.getFundamentalFromSineGen();
        if (bl11 == null ? bl12 != null : !((Object)bl11).equals(bl12)) {
            return false;
        }
        String string = this.getMode();
        String string2 = rTAConfiguration.getMode();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getSmoothing();
        String string4 = rTAConfiguration.getSmoothing();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getFftLength();
        String string6 = rTAConfiguration.getFftLength();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getWindow();
        String string8 = rTAConfiguration.getWindow();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getAveraging();
        String string10 = rTAConfiguration.getAveraging();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.getMaximumOverlap();
        String string12 = rTAConfiguration.getMaximumOverlap();
        return !(string11 == null ? string12 != null : !string11.equals(string12));
    }

    protected boolean canEqual(Object object) {
        return object instanceof RTAConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Boolean bl = this.getStopAt();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Integer n4 = this.getStopAtValue();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Boolean bl2 = this.getCalcDistortionEnabled();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        Boolean bl3 = this.getRestartCaptureOnGeneratorChange();
        n3 = n3 * 59 + (bl3 == null ? 43 : ((Object)bl3).hashCode());
        Boolean bl4 = this.getUse64BitFFT();
        n3 = n3 * 59 + (bl4 == null ? 43 : ((Object)bl4).hashCode());
        Boolean bl5 = this.getAdjustRTALevels();
        n3 = n3 * 59 + (bl5 == null ? 43 : ((Object)bl5).hashCode());
        Boolean bl6 = this.getFundamentalFromSineGen();
        n3 = n3 * 59 + (bl6 == null ? 43 : ((Object)bl6).hashCode());
        String string = this.getMode();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getSmoothing();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getFftLength();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getWindow();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getAveraging();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.getMaximumOverlap();
        n3 = n3 * 59 + (string6 == null ? 43 : string6.hashCode());
        return n3;
    }

    public String toString() {
        return "RTAConfiguration(mode=" + this.getMode() + ", smoothing=" + this.getSmoothing() + ", fftLength=" + this.getFftLength() + ", window=" + this.getWindow() + ", averaging=" + this.getAveraging() + ", stopAt=" + this.getStopAt() + ", stopAtValue=" + this.getStopAtValue() + ", maximumOverlap=" + this.getMaximumOverlap() + ", calcDistortionEnabled=" + this.getCalcDistortionEnabled() + ", restartCaptureOnGeneratorChange=" + this.getRestartCaptureOnGeneratorChange() + ", use64BitFFT=" + this.getUse64BitFFT() + ", adjustRTALevels=" + this.getAdjustRTALevels() + ", fundamentalFromSineGen=" + this.getFundamentalFromSineGen() + ")";
    }

    public static class RTAConfigurationBuilder {
        private String mode;
        private String smoothing;
        private String fftLength;
        private String window;
        private String averaging;
        private Boolean stopAt;
        private Integer stopAtValue;
        private String maximumOverlap;
        private Boolean calcDistortionEnabled;
        private Boolean restartCaptureOnGeneratorChange;
        private Boolean use64BitFFT;
        private Boolean adjustRTALevels;
        private Boolean fundamentalFromSineGen;

        RTAConfigurationBuilder() {
        }

        public RTAConfigurationBuilder mode(String string) {
            this.mode = string;
            return this;
        }

        public RTAConfigurationBuilder smoothing(String string) {
            this.smoothing = string;
            return this;
        }

        public RTAConfigurationBuilder fftLength(String string) {
            this.fftLength = string;
            return this;
        }

        public RTAConfigurationBuilder window(String string) {
            this.window = string;
            return this;
        }

        public RTAConfigurationBuilder averaging(String string) {
            this.averaging = string;
            return this;
        }

        public RTAConfigurationBuilder stopAt(Boolean bl) {
            this.stopAt = bl;
            return this;
        }

        public RTAConfigurationBuilder stopAtValue(Integer n2) {
            this.stopAtValue = n2;
            return this;
        }

        public RTAConfigurationBuilder maximumOverlap(String string) {
            this.maximumOverlap = string;
            return this;
        }

        public RTAConfigurationBuilder calcDistortionEnabled(Boolean bl) {
            this.calcDistortionEnabled = bl;
            return this;
        }

        public RTAConfigurationBuilder restartCaptureOnGeneratorChange(Boolean bl) {
            this.restartCaptureOnGeneratorChange = bl;
            return this;
        }

        public RTAConfigurationBuilder use64BitFFT(Boolean bl) {
            this.use64BitFFT = bl;
            return this;
        }

        public RTAConfigurationBuilder adjustRTALevels(Boolean bl) {
            this.adjustRTALevels = bl;
            return this;
        }

        public RTAConfigurationBuilder fundamentalFromSineGen(Boolean bl) {
            this.fundamentalFromSineGen = bl;
            return this;
        }

        public RTAConfiguration build() {
            return new RTAConfiguration(this.mode, this.smoothing, this.fftLength, this.window, this.averaging, this.stopAt, this.stopAtValue, this.maximumOverlap, this.calcDistortionEnabled, this.restartCaptureOnGeneratorChange, this.use64BitFFT, this.adjustRTALevels, this.fundamentalFromSineGen);
        }

        public String toString() {
            return "RTAConfiguration.RTAConfigurationBuilder(mode=" + this.mode + ", smoothing=" + this.smoothing + ", fftLength=" + this.fftLength + ", window=" + this.window + ", averaging=" + this.averaging + ", stopAt=" + this.stopAt + ", stopAtValue=" + this.stopAtValue + ", maximumOverlap=" + this.maximumOverlap + ", calcDistortionEnabled=" + this.calcDistortionEnabled + ", restartCaptureOnGeneratorChange=" + this.restartCaptureOnGeneratorChange + ", use64BitFFT=" + this.use64BitFFT + ", adjustRTALevels=" + this.adjustRTALevels + ", fundamentalFromSineGen=" + this.fundamentalFromSineGen + ")";
        }
    }
}

