/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class MultitoneDetails {
    private final Double firstFreq;
    private final Double lastFreq;
    private final Integer numTones;
    private final Double crestFactordB;
    private final Double kurtosis;

    MultitoneDetails(Double d2, Double d3, Integer n2, Double d4, Double d5) {
        this.firstFreq = d2;
        this.lastFreq = d3;
        this.numTones = n2;
        this.crestFactordB = d4;
        this.kurtosis = d5;
    }

    public static MultitoneDetailsBuilder builder() {
        return new MultitoneDetailsBuilder();
    }

    public Double getFirstFreq() {
        return this.firstFreq;
    }

    public Double getLastFreq() {
        return this.lastFreq;
    }

    public Integer getNumTones() {
        return this.numTones;
    }

    public Double getCrestFactordB() {
        return this.crestFactordB;
    }

    public Double getKurtosis() {
        return this.kurtosis;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultitoneDetails)) {
            return false;
        }
        MultitoneDetails multitoneDetails = (MultitoneDetails)object;
        if (!multitoneDetails.canEqual(this)) {
            return false;
        }
        Double d2 = this.getFirstFreq();
        Double d3 = multitoneDetails.getFirstFreq();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Double d4 = this.getLastFreq();
        Double d5 = multitoneDetails.getLastFreq();
        if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
            return false;
        }
        Integer n2 = this.getNumTones();
        Integer n3 = multitoneDetails.getNumTones();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Double d6 = this.getCrestFactordB();
        Double d7 = multitoneDetails.getCrestFactordB();
        if (d6 == null ? d7 != null : !((Object)d6).equals(d7)) {
            return false;
        }
        Double d8 = this.getKurtosis();
        Double d9 = multitoneDetails.getKurtosis();
        return !(d8 == null ? d9 != null : !((Object)d8).equals(d9));
    }

    protected boolean canEqual(Object object) {
        return object instanceof MultitoneDetails;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Double d2 = this.getFirstFreq();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Double d3 = this.getLastFreq();
        n3 = n3 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
        Integer n4 = this.getNumTones();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Double d4 = this.getCrestFactordB();
        n3 = n3 * 59 + (d4 == null ? 43 : ((Object)d4).hashCode());
        Double d5 = this.getKurtosis();
        n3 = n3 * 59 + (d5 == null ? 43 : ((Object)d5).hashCode());
        return n3;
    }

    public String toString() {
        return "MultitoneDetails(firstFreq=" + this.getFirstFreq() + ", lastFreq=" + this.getLastFreq() + ", numTones=" + this.getNumTones() + ", crestFactordB=" + this.getCrestFactordB() + ", kurtosis=" + this.getKurtosis() + ")";
    }

    public static class MultitoneDetailsBuilder {
        private Double firstFreq;
        private Double lastFreq;
        private Integer numTones;
        private Double crestFactordB;
        private Double kurtosis;

        MultitoneDetailsBuilder() {
        }

        public MultitoneDetailsBuilder firstFreq(Double d2) {
            this.firstFreq = d2;
            return this;
        }

        public MultitoneDetailsBuilder lastFreq(Double d2) {
            this.lastFreq = d2;
            return this;
        }

        public MultitoneDetailsBuilder numTones(Integer n2) {
            this.numTones = n2;
            return this;
        }

        public MultitoneDetailsBuilder crestFactordB(Double d2) {
            this.crestFactordB = d2;
            return this;
        }

        public MultitoneDetailsBuilder kurtosis(Double d2) {
            this.kurtosis = d2;
            return this;
        }

        public MultitoneDetails build() {
            return new MultitoneDetails(this.firstFreq, this.lastFreq, this.numTones, this.crestFactordB, this.kurtosis);
        }

        public String toString() {
            return "MultitoneDetails.MultitoneDetailsBuilder(firstFreq=" + this.firstFreq + ", lastFreq=" + this.lastFreq + ", numTones=" + this.numTones + ", crestFactordB=" + this.crestFactordB + ", kurtosis=" + this.kurtosis + ")";
        }
    }
}

