/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class MultitoneConfiguration {
    private final Integer startFreq;
    private final Integer endFreq;
    private final String sequenceLength;
    private final String spectrum;
    private final String spacing;
    private final Integer linearSpacingHz;
    private final String octaveSpacing;
    private final String decadeSpacing;
    private final Boolean minimiseCrestFactor;
    private final Boolean addDither;
    private final Integer ditherBits;

    MultitoneConfiguration(Integer n2, Integer n3, String string, String string2, String string3, Integer n4, String string4, String string5, Boolean bl, Boolean bl2, Integer n5) {
        this.startFreq = n2;
        this.endFreq = n3;
        this.sequenceLength = string;
        this.spectrum = string2;
        this.spacing = string3;
        this.linearSpacingHz = n4;
        this.octaveSpacing = string4;
        this.decadeSpacing = string5;
        this.minimiseCrestFactor = bl;
        this.addDither = bl2;
        this.ditherBits = n5;
    }

    public static MultitoneConfigurationBuilder builder() {
        return new MultitoneConfigurationBuilder();
    }

    public Integer getStartFreq() {
        return this.startFreq;
    }

    public Integer getEndFreq() {
        return this.endFreq;
    }

    public String getSequenceLength() {
        return this.sequenceLength;
    }

    public String getSpectrum() {
        return this.spectrum;
    }

    public String getSpacing() {
        return this.spacing;
    }

    public Integer getLinearSpacingHz() {
        return this.linearSpacingHz;
    }

    public String getOctaveSpacing() {
        return this.octaveSpacing;
    }

    public String getDecadeSpacing() {
        return this.decadeSpacing;
    }

    public Boolean getMinimiseCrestFactor() {
        return this.minimiseCrestFactor;
    }

    public Boolean getAddDither() {
        return this.addDither;
    }

    public Integer getDitherBits() {
        return this.ditherBits;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultitoneConfiguration)) {
            return false;
        }
        MultitoneConfiguration multitoneConfiguration = (MultitoneConfiguration)object;
        if (!multitoneConfiguration.canEqual(this)) {
            return false;
        }
        Integer n2 = this.getStartFreq();
        Integer n3 = multitoneConfiguration.getStartFreq();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Integer n4 = this.getEndFreq();
        Integer n5 = multitoneConfiguration.getEndFreq();
        if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
            return false;
        }
        Integer n6 = this.getLinearSpacingHz();
        Integer n7 = multitoneConfiguration.getLinearSpacingHz();
        if (n6 == null ? n7 != null : !((Object)n6).equals(n7)) {
            return false;
        }
        Boolean bl = this.getMinimiseCrestFactor();
        Boolean bl2 = multitoneConfiguration.getMinimiseCrestFactor();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        Boolean bl3 = this.getAddDither();
        Boolean bl4 = multitoneConfiguration.getAddDither();
        if (bl3 == null ? bl4 != null : !((Object)bl3).equals(bl4)) {
            return false;
        }
        Integer n8 = this.getDitherBits();
        Integer n9 = multitoneConfiguration.getDitherBits();
        if (n8 == null ? n9 != null : !((Object)n8).equals(n9)) {
            return false;
        }
        String string = this.getSequenceLength();
        String string2 = multitoneConfiguration.getSequenceLength();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getSpectrum();
        String string4 = multitoneConfiguration.getSpectrum();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getSpacing();
        String string6 = multitoneConfiguration.getSpacing();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getOctaveSpacing();
        String string8 = multitoneConfiguration.getOctaveSpacing();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getDecadeSpacing();
        String string10 = multitoneConfiguration.getDecadeSpacing();
        return !(string9 == null ? string10 != null : !string9.equals(string10));
    }

    protected boolean canEqual(Object object) {
        return object instanceof MultitoneConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Integer n4 = this.getStartFreq();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getEndFreq();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Integer n6 = this.getLinearSpacingHz();
        n3 = n3 * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        Boolean bl = this.getMinimiseCrestFactor();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Boolean bl2 = this.getAddDither();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        Integer n7 = this.getDitherBits();
        n3 = n3 * 59 + (n7 == null ? 43 : ((Object)n7).hashCode());
        String string = this.getSequenceLength();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getSpectrum();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getSpacing();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getOctaveSpacing();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getDecadeSpacing();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        return n3;
    }

    public String toString() {
        return "MultitoneConfiguration(startFreq=" + this.getStartFreq() + ", endFreq=" + this.getEndFreq() + ", sequenceLength=" + this.getSequenceLength() + ", spectrum=" + this.getSpectrum() + ", spacing=" + this.getSpacing() + ", linearSpacingHz=" + this.getLinearSpacingHz() + ", octaveSpacing=" + this.getOctaveSpacing() + ", decadeSpacing=" + this.getDecadeSpacing() + ", minimiseCrestFactor=" + this.getMinimiseCrestFactor() + ", addDither=" + this.getAddDither() + ", ditherBits=" + this.getDitherBits() + ")";
    }

    public static class MultitoneConfigurationBuilder {
        private Integer startFreq;
        private Integer endFreq;
        private String sequenceLength;
        private String spectrum;
        private String spacing;
        private Integer linearSpacingHz;
        private String octaveSpacing;
        private String decadeSpacing;
        private Boolean minimiseCrestFactor;
        private Boolean addDither;
        private Integer ditherBits;

        MultitoneConfigurationBuilder() {
        }

        public MultitoneConfigurationBuilder startFreq(Integer n2) {
            this.startFreq = n2;
            return this;
        }

        public MultitoneConfigurationBuilder endFreq(Integer n2) {
            this.endFreq = n2;
            return this;
        }

        public MultitoneConfigurationBuilder sequenceLength(String string) {
            this.sequenceLength = string;
            return this;
        }

        public MultitoneConfigurationBuilder spectrum(String string) {
            this.spectrum = string;
            return this;
        }

        public MultitoneConfigurationBuilder spacing(String string) {
            this.spacing = string;
            return this;
        }

        public MultitoneConfigurationBuilder linearSpacingHz(Integer n2) {
            this.linearSpacingHz = n2;
            return this;
        }

        public MultitoneConfigurationBuilder octaveSpacing(String string) {
            this.octaveSpacing = string;
            return this;
        }

        public MultitoneConfigurationBuilder decadeSpacing(String string) {
            this.decadeSpacing = string;
            return this;
        }

        public MultitoneConfigurationBuilder minimiseCrestFactor(Boolean bl) {
            this.minimiseCrestFactor = bl;
            return this;
        }

        public MultitoneConfigurationBuilder addDither(Boolean bl) {
            this.addDither = bl;
            return this;
        }

        public MultitoneConfigurationBuilder ditherBits(Integer n2) {
            this.ditherBits = n2;
            return this;
        }

        public MultitoneConfiguration build() {
            return new MultitoneConfiguration(this.startFreq, this.endFreq, this.sequenceLength, this.spectrum, this.spacing, this.linearSpacingHz, this.octaveSpacing, this.decadeSpacing, this.minimiseCrestFactor, this.addDither, this.ditherBits);
        }

        public String toString() {
            return "MultitoneConfiguration.MultitoneConfigurationBuilder(startFreq=" + this.startFreq + ", endFreq=" + this.endFreq + ", sequenceLength=" + this.sequenceLength + ", spectrum=" + this.spectrum + ", spacing=" + this.spacing + ", linearSpacingHz=" + this.linearSpacingHz + ", octaveSpacing=" + this.octaveSpacing + ", decadeSpacing=" + this.decadeSpacing + ", minimiseCrestFactor=" + this.minimiseCrestFactor + ", addDither=" + this.addDither + ", ditherBits=" + this.ditherBits + ")";
        }
    }
}

