/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class MeasSweepConfiguration {
    private final Integer startFrequency;
    private final Integer endFrequency;
    private final String length;
    private final Boolean fillSilenceWithDither;

    MeasSweepConfiguration(Integer n2, Integer n3, String string, Boolean bl) {
        this.startFrequency = n2;
        this.endFrequency = n3;
        this.length = string;
        this.fillSilenceWithDither = bl;
    }

    public static MeasSweepConfigurationBuilder builder() {
        return new MeasSweepConfigurationBuilder();
    }

    public Integer getStartFrequency() {
        return this.startFrequency;
    }

    public Integer getEndFrequency() {
        return this.endFrequency;
    }

    public String getLength() {
        return this.length;
    }

    public Boolean getFillSilenceWithDither() {
        return this.fillSilenceWithDither;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MeasSweepConfiguration)) {
            return false;
        }
        MeasSweepConfiguration measSweepConfiguration = (MeasSweepConfiguration)object;
        if (!measSweepConfiguration.canEqual(this)) {
            return false;
        }
        Integer n2 = this.getStartFrequency();
        Integer n3 = measSweepConfiguration.getStartFrequency();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Integer n4 = this.getEndFrequency();
        Integer n5 = measSweepConfiguration.getEndFrequency();
        if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
            return false;
        }
        Boolean bl = this.getFillSilenceWithDither();
        Boolean bl2 = measSweepConfiguration.getFillSilenceWithDither();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        String string = this.getLength();
        String string2 = measSweepConfiguration.getLength();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof MeasSweepConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Integer n4 = this.getStartFrequency();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getEndFrequency();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Boolean bl = this.getFillSilenceWithDither();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        String string = this.getLength();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        return n3;
    }

    public String toString() {
        return "MeasSweepConfiguration(startFrequency=" + this.getStartFrequency() + ", endFrequency=" + this.getEndFrequency() + ", length=" + this.getLength() + ", fillSilenceWithDither=" + this.getFillSilenceWithDither() + ")";
    }

    public static class MeasSweepConfigurationBuilder {
        private Integer startFrequency;
        private Integer endFrequency;
        private String length;
        private Boolean fillSilenceWithDither;

        MeasSweepConfigurationBuilder() {
        }

        public MeasSweepConfigurationBuilder startFrequency(Integer n2) {
            this.startFrequency = n2;
            return this;
        }

        public MeasSweepConfigurationBuilder endFrequency(Integer n2) {
            this.endFrequency = n2;
            return this;
        }

        public MeasSweepConfigurationBuilder length(String string) {
            this.length = string;
            return this;
        }

        public MeasSweepConfigurationBuilder fillSilenceWithDither(Boolean bl) {
            this.fillSilenceWithDither = bl;
            return this;
        }

        public MeasSweepConfiguration build() {
            return new MeasSweepConfiguration(this.startFrequency, this.endFrequency, this.length, this.fillSilenceWithDither);
        }

        public String toString() {
            return "MeasSweepConfiguration.MeasSweepConfigurationBuilder(startFrequency=" + this.startFrequency + ", endFrequency=" + this.endFrequency + ", length=" + this.length + ", fillSilenceWithDither=" + this.fillSilenceWithDither + ")";
        }
    }
}

