/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public class LinearSweepConfiguration {
    private final Integer startFrequency;
    private final Integer endFrequency;
    private final Integer fadeInMilliseconds;
    private final Integer fadeOutMilliseconds;
    private final Double durationSeconds;
    private final Boolean loop;

    LinearSweepConfiguration(Integer n2, Integer n3, Integer n4, Integer n5, Double d2, Boolean bl) {
        this.startFrequency = n2;
        this.endFrequency = n3;
        this.fadeInMilliseconds = n4;
        this.fadeOutMilliseconds = n5;
        this.durationSeconds = d2;
        this.loop = bl;
    }

    public static LinearSweepConfigurationBuilder builder() {
        return new LinearSweepConfigurationBuilder();
    }

    public Integer getStartFrequency() {
        return this.startFrequency;
    }

    public Integer getEndFrequency() {
        return this.endFrequency;
    }

    public Integer getFadeInMilliseconds() {
        return this.fadeInMilliseconds;
    }

    public Integer getFadeOutMilliseconds() {
        return this.fadeOutMilliseconds;
    }

    public Double getDurationSeconds() {
        return this.durationSeconds;
    }

    public Boolean getLoop() {
        return this.loop;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LinearSweepConfiguration)) {
            return false;
        }
        LinearSweepConfiguration linearSweepConfiguration = (LinearSweepConfiguration)object;
        if (!linearSweepConfiguration.canEqual(this)) {
            return false;
        }
        Integer n2 = this.getStartFrequency();
        Integer n3 = linearSweepConfiguration.getStartFrequency();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Integer n4 = this.getEndFrequency();
        Integer n5 = linearSweepConfiguration.getEndFrequency();
        if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
            return false;
        }
        Integer n6 = this.getFadeInMilliseconds();
        Integer n7 = linearSweepConfiguration.getFadeInMilliseconds();
        if (n6 == null ? n7 != null : !((Object)n6).equals(n7)) {
            return false;
        }
        Integer n8 = this.getFadeOutMilliseconds();
        Integer n9 = linearSweepConfiguration.getFadeOutMilliseconds();
        if (n8 == null ? n9 != null : !((Object)n8).equals(n9)) {
            return false;
        }
        Double d2 = this.getDurationSeconds();
        Double d3 = linearSweepConfiguration.getDurationSeconds();
        if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
            return false;
        }
        Boolean bl = this.getLoop();
        Boolean bl2 = linearSweepConfiguration.getLoop();
        return !(bl == null ? bl2 != null : !((Object)bl).equals(bl2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof LinearSweepConfiguration;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Integer n4 = this.getStartFrequency();
        n3 = n3 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getEndFrequency();
        n3 = n3 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Integer n6 = this.getFadeInMilliseconds();
        n3 = n3 * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        Integer n7 = this.getFadeOutMilliseconds();
        n3 = n3 * 59 + (n7 == null ? 43 : ((Object)n7).hashCode());
        Double d2 = this.getDurationSeconds();
        n3 = n3 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
        Boolean bl = this.getLoop();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        return n3;
    }

    public String toString() {
        return "LinearSweepConfiguration(startFrequency=" + this.getStartFrequency() + ", endFrequency=" + this.getEndFrequency() + ", fadeInMilliseconds=" + this.getFadeInMilliseconds() + ", fadeOutMilliseconds=" + this.getFadeOutMilliseconds() + ", durationSeconds=" + this.getDurationSeconds() + ", loop=" + this.getLoop() + ")";
    }

    public static class LinearSweepConfigurationBuilder {
        private Integer startFrequency;
        private Integer endFrequency;
        private Integer fadeInMilliseconds;
        private Integer fadeOutMilliseconds;
        private Double durationSeconds;
        private Boolean loop;

        LinearSweepConfigurationBuilder() {
        }

        public LinearSweepConfigurationBuilder startFrequency(Integer n2) {
            this.startFrequency = n2;
            return this;
        }

        public LinearSweepConfigurationBuilder endFrequency(Integer n2) {
            this.endFrequency = n2;
            return this;
        }

        public LinearSweepConfigurationBuilder fadeInMilliseconds(Integer n2) {
            this.fadeInMilliseconds = n2;
            return this;
        }

        public LinearSweepConfigurationBuilder fadeOutMilliseconds(Integer n2) {
            this.fadeOutMilliseconds = n2;
            return this;
        }

        public LinearSweepConfigurationBuilder durationSeconds(Double d2) {
            this.durationSeconds = d2;
            return this;
        }

        public LinearSweepConfigurationBuilder loop(Boolean bl) {
            this.loop = bl;
            return this;
        }

        public LinearSweepConfiguration build() {
            return new LinearSweepConfiguration(this.startFrequency, this.endFrequency, this.fadeInMilliseconds, this.fadeOutMilliseconds, this.durationSeconds, this.loop);
        }

        public String toString() {
            return "LinearSweepConfiguration.LinearSweepConfigurationBuilder(startFrequency=" + this.startFrequency + ", endFrequency=" + this.endFrequency + ", fadeInMilliseconds=" + this.fadeInMilliseconds + ", fadeOutMilliseconds=" + this.fadeOutMilliseconds + ", durationSeconds=" + this.durationSeconds + ", loop=" + this.loop + ")";
        }
    }
}

