/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.model;

public enum AlignmentToolCommand {
    LEVEL_PHASE("Level phase"),
    UNDO_LEVEL_PHASE("Undo level phase"),
    ALIGN_PHASE_SLOPES("Align phase slopes"),
    ALIGN_PHASE("Align phase"),
    FILTER_IRS("Filter IRs"),
    ALIGN_IRS("Align IRs"),
    CLEAR_FILTER("Clear filter"),
    ALIGNED_COPY_A("Aligned copy of A"),
    ALIGNED_COPY_B("Aligned copy of B"),
    ALIGNED_SUM("Aligned sum"),
    RESET("Reset all");

    private final String commandName;

    private AlignmentToolCommand(String string2) {
        this.commandName = string2;
    }

    public boolean requiresFrequency() {
        switch (this) {
            case LEVEL_PHASE: 
            case ALIGN_PHASE_SLOPES: 
            case ALIGN_PHASE: 
            case FILTER_IRS: 
            case ALIGN_IRS: {
                return true;
            }
        }
        return false;
    }

    public boolean producesResult() {
        switch (this) {
            case ALIGN_PHASE_SLOPES: 
            case ALIGN_PHASE: 
            case ALIGN_IRS: {
                return true;
            }
        }
        return false;
    }

    public String commandName() {
        return this.commandName;
    }

    public static AlignmentToolCommand getFromCommandName(String string) {
        for (AlignmentToolCommand alignmentToolCommand : AlignmentToolCommand.values()) {
            if (!alignmentToolCommand.commandName().equalsIgnoreCase(string)) continue;
            return alignmentToolCommand;
        }
        return null;
    }
}

