/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.RTAService;
import roomeqwizard.api.SteppedService;
import roomeqwizard.api.model.CommandWithMap;
import roomeqwizard.api.model.SteppedFFTConfiguration;
import roomeqwizard.api.model.SteppedFreqSpan;
import roomeqwizard.api.model.SteppedLevelSpan;
import roomeqwizard.api.model.SteppedOptions;
import roomeqwizard.api.model.SteppedProgress;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import spark.Request;
import spark.Response;

public class SteppedEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/stepped-measurement";
    private final SteppedService service = SteppedService.getInstance();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("API to configure and run stepped measurements "), null).get(MethodDescriptor.path("/types").withDescription("Get the accepted stepped measurement types ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedService.getTypes());
            }
        }).get(MethodDescriptor.path("/type").withDescription("Get the selected stepped measurement type ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getType());
            }
        }).post(MethodDescriptor.path("/type").withDescription("Select a stepped measurement type ").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return SteppedEndpoint.this.service.setType(string, response);
            }
        }).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a command  ").withRequestType(CommandWithMap.class).withResponseType(APIResponse.class), new TypedRoute<CommandWithMap>(){

            @Override
            public Object onRequest(CommandWithMap commandWithMap, Request request, Response response) {
                return SteppedEndpoint.this.service.runCommand(commandWithMap, response);
            }
        }).get(MethodDescriptor.path("/imd-stimuli").withDescription("Get the list of signals that can be used for IMD versus level ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getIMDStimuli());
            }
        }).get(MethodDescriptor.path("/frequency-span").withDescription("Get the frequency span and step for a stepped measurement versus frequency").withResponseType(SteppedFreqSpan.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getSteppedFreqSpan());
            }
        }).get(MethodDescriptor.path("/ppo-values").withDescription("Get the accepted frequency span ppo values for a stepped measurement versus frequency").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedService.getPPOValues());
            }
        }).post(MethodDescriptor.path("/frequency-span").withDescription("Set the frequency span and step for a stepped measurement versus frequency").withRequestType(SteppedFreqSpan.class).withResponseType(APIResponse.class), new TypedRoute<SteppedFreqSpan>(){

            @Override
            public Object onRequest(SteppedFreqSpan steppedFreqSpan, Request request, Response response) {
                return SteppedEndpoint.this.service.setSteppedFreqSpan(steppedFreqSpan, response);
            }
        }).put(MethodDescriptor.path("/frequency-span").withDescription("Set the frequency span and step for a stepped measurement versus frequency").withRequestType(SteppedFreqSpan.class).withResponseType(APIResponse.class), new TypedRoute<SteppedFreqSpan>(){

            @Override
            public Object onRequest(SteppedFreqSpan steppedFreqSpan, Request request, Response response) {
                return SteppedEndpoint.this.service.setSteppedFreqSpan(steppedFreqSpan, response);
            }
        }).get(MethodDescriptor.path("/level-span").withDescription("Get the level span and step for a stepped measurement versus level").withResponseType(SteppedLevelSpan.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getSteppedLevelSpan());
            }
        }).post(MethodDescriptor.path("/level-span").withDescription("Set the level span and step for a stepped measurement versus level").withRequestType(SteppedLevelSpan.class).withResponseType(APIResponse.class), new TypedRoute<SteppedLevelSpan>(){

            @Override
            public Object onRequest(SteppedLevelSpan steppedLevelSpan, Request request, Response response) {
                return SteppedEndpoint.this.service.setSteppedLevelSpan(steppedLevelSpan, response);
            }
        }).put(MethodDescriptor.path("/level-span").withDescription("Set the level span and step for a stepped measurement versus level").withRequestType(SteppedLevelSpan.class).withResponseType(APIResponse.class), new TypedRoute<SteppedLevelSpan>(){

            @Override
            public Object onRequest(SteppedLevelSpan steppedLevelSpan, Request request, Response response) {
                return SteppedEndpoint.this.service.setSteppedLevelSpan(steppedLevelSpan, response);
            }
        }).get(MethodDescriptor.path("/fft-configuration").withDescription("Get the FFT configuration ").withResponseType(SteppedFFTConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getFFTConfiguration());
            }
        }).post(MethodDescriptor.path("/fft-configuration").withDescription("Set the FFT configuration ").withRequestType(SteppedFFTConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SteppedFFTConfiguration>(){

            @Override
            public Object onRequest(SteppedFFTConfiguration steppedFFTConfiguration, Request request, Response response) {
                return SteppedEndpoint.this.service.setFFTConfiguration(steppedFFTConfiguration, response);
            }
        }).put(MethodDescriptor.path("/fft-configuration").withDescription("Set some FFT configuration choices ").withRequestType(SteppedFFTConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SteppedFFTConfiguration>(){

            @Override
            public Object onRequest(SteppedFFTConfiguration steppedFFTConfiguration, Request request, Response response) {
                return SteppedEndpoint.this.service.setFFTConfiguration(steppedFFTConfiguration, response);
            }
        }).get(MethodDescriptor.path("/fft-configuration/fft-lengths").withDescription("Get the list of FFT lengths ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getRTALengths());
            }
        }).get(MethodDescriptor.path("/fft-configuration/window-choices").withDescription("Get the list of window choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getWindowChoices());
            }
        }).get(MethodDescriptor.path("/fft-configuration/overlap-choices").withDescription("Get the list of maximum overlap choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getOverlapChoices());
            }
        }).get(MethodDescriptor.path("/fft-configuration/averaging-choices").withDescription("Get the list of averaging choices ").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedService.getNumAverageChoices());
            }
        }).get(MethodDescriptor.path("/options").withDescription("Get the option settings ").withResponseType(SteppedOptions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getOptions());
            }
        }).post(MethodDescriptor.path("/options").withDescription("Set the options ").withRequestType(SteppedOptions.class).withResponseType(APIResponse.class), new TypedRoute<SteppedOptions>(){

            @Override
            public Object onRequest(SteppedOptions steppedOptions, Request request, Response response) {
                return SteppedEndpoint.this.service.setOptions(steppedOptions, response);
            }
        }).put(MethodDescriptor.path("/options").withDescription("Set some options ").withRequestType(SteppedOptions.class).withResponseType(APIResponse.class), new TypedRoute<SteppedOptions>(){

            @Override
            public Object onRequest(SteppedOptions steppedOptions, Request request, Response response) {
                return SteppedEndpoint.this.service.setOptions(steppedOptions, response);
            }
        }).get(MethodDescriptor.path("/progress").withDescription("Get the latest progress update ").withResponseType(SteppedProgress.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getProgress());
            }
        }).post(MethodDescriptor.path("/progress/subscribe").withDescription("Subscribe to progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return SteppedEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.STEPPED_PROGRESS, response);
            }
        }).post(MethodDescriptor.path("/progress/unsubscribe").withDescription("Unsubscribe from progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return SteppedEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.STEPPED_PROGRESS, response);
            }
        }).get(MethodDescriptor.path("/progress/subscribers").withDescription("Get the progress subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getSubscribers(SubscriptionType.STEPPED_PROGRESS));
            }
        }).post(MethodDescriptor.path("/results/subscribe").withDescription("Subscribe to result updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return SteppedEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.STEPPED_RESULTS, response);
            }
        }).post(MethodDescriptor.path("/results/unsubscribe").withDescription("Unsubscribe from result updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return SteppedEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.STEPPED_RESULTS, response);
            }
        }).get(MethodDescriptor.path("/results/subscribers").withDescription("Get the result subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SteppedEndpoint.this.service.getSubscribers(SubscriptionType.STEPPED_RESULTS));
            }
        });
    }
}

