/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.SPLMeterService;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.SPLMeterConfiguration;
import roomeqwizard.api.model.SPLValues;
import roomeqwizard.api.model.Subscriber;
import spark.Request;
import spark.Response;

public class SPLMeterEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/spl-meter";
    private final SPLMeterService service = SPLMeterService.getInstance();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("API to configure and monitor SPL meters "), null).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SPLMeterEndpoint.this.service.getCommands());
            }
        }).get(MethodDescriptor.path("/modes").withDescription("Get the accepted display modes ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SPLMeterService.getModes());
            }
        }).get(MethodDescriptor.path("/weightings").withDescription("Get the accepted weightings ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SPLMeterService.getWeightings());
            }
        }).get(MethodDescriptor.path("/filters").withDescription("Get the accepted filters ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, SPLMeterService.getFilters());
            }
        }).post(MethodDescriptor.path("/:id/command").withDescription("Send a command  ").withRequestType(Command.class).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.runCommand(n2, command, response);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/configuration").withDescription("Get the configuration options for the SPL meter ").withResponseType(SPLMeterConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return APIResponse.ok(response, SPLMeterEndpoint.this.service.getSPLMeterConfiguration(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/configuration").withDescription("Send a configuration for the SPL meter ").withRequestType(SPLMeterConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SPLMeterConfiguration>(){

            @Override
            public Object onRequest(SPLMeterConfiguration sPLMeterConfiguration, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.setConfiguration(n2, sPLMeterConfiguration, response);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id/configuration").withDescription("Send some configuration settings for the SPL meter ").withRequestType(SPLMeterConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SPLMeterConfiguration>(){

            @Override
            public Object onRequest(SPLMeterConfiguration sPLMeterConfiguration, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.setConfiguration(n2, sPLMeterConfiguration, response);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/levels").withDescription("Get the latest SPL update ").withResponseType(SPLValues.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.getLevels(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/subscribe").withDescription("Subscribe to updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.addSubscriber(subscriber, SPLMeterService.getSubscriptionType(n2), response);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/unsubscribe").withDescription("Unsubscribe from updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return SPLMeterEndpoint.this.service.removeSubscriber(subscriber, SPLMeterService.getSubscriptionType(n2), response);
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/subscribers").withDescription("Get the subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!SPLMeterEndpoint.this.meterExists(n2)) {
                        return SPLMeterEndpoint.this.meterNotFound(response, n2);
                    }
                    return APIResponse.ok(response, SPLMeterEndpoint.this.service.getSubscribers(SPLMeterService.getSubscriptionType(n2)));
                }
                catch (NumberFormatException numberFormatException) {
                    return SPLMeterEndpoint.this.badIndex(request, response);
                }
            }
        });
    }

    private boolean meterExists(int n2) {
        return n2 >= 0 && n2 < SPLMeterService.numMeters();
    }

    private APIResponse meterNotFound(Response response, int n2) {
        int n3 = SPLMeterService.numMeters();
        String string = n3 > 1 ? "are " + n3 + " SPL meters" : "is one SPL meter";
        return APIResponse.notFound(response, "There is no SPL meter at index " + (n2 + 1) + ", there " + string);
    }

    private APIResponse badIndex(Request request, Response response) {
        return APIResponse.badRequest(response, "SPL meter indices are numeric, this is not a valid index: " + request.params(":id"));
    }
}

