/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.LengthUnit;
import roomeqwizard.SpeakerID;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.RoomSimService;
import roomeqwizard.api.model.Absorptions;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.MicPositionOffsets;
import roomeqwizard.api.model.RoomDimensions;
import roomeqwizard.api.model.RoomPosition;
import roomeqwizard.api.model.RoomSimOptions;
import roomeqwizard.api.model.RoomSimSources;
import roomeqwizard.api.model.SourceConfiguration;
import roomeqwizard.api.model.ValidValues;
import spark.Request;
import spark.Response;

public class RoomSimEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/roomsim";
    private final RoomSimService service = new RoomSimService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Room simulator API "), null).get(MethodDescriptor.path("/length-units").withDescription("Get the list of length units ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RoomSimService.getLengthUnits());
            }
        }).get(MethodDescriptor.path("/source-names").withDescription("Get the list of recognised source names ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RoomSimService.getSourceNames());
            }
        }).get(MethodDescriptor.path("/room-size").withDescription("Get the room dimensions ").withQueryParam().withName(RoomSimService.getLengthUnitKey()).withDescription("Specify the length unit  e.g. ?unit=metres, default is " + RoomSimService.getDefaultLengthUnit().apiName()).and().withResponseType(RoomDimensions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.queryParamOrDefault(RoomSimService.getLengthUnitKey(), RoomSimService.getDefaultLengthUnit().apiName());
                LengthUnit lengthUnit = LengthUnit.getFromApiName(string);
                if (lengthUnit == null) {
                    return APIResponse.badRequest(response, (Object)((Object)lengthUnit) + " is not a valid unit");
                }
                return RoomSimEndpoint.this.service.getRoomDimensions(lengthUnit);
            }
        }).post(MethodDescriptor.path("/room-size").withDescription("Set the room dimensions, if the unit is omitted values will be treated as " + RoomSimService.getDefaultLengthUnit().apiName()).withRequestType(RoomDimensions.class).withResponseType(APIResponse.class), new TypedRoute<RoomDimensions>(){

            @Override
            public Object onRequest(RoomDimensions roomDimensions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setRoomDimensions(roomDimensions, response);
            }
        }).put(MethodDescriptor.path("/room-size").withDescription("Set some room dimensions, if the unit is omitted values will be treated as " + RoomSimService.getDefaultLengthUnit().apiName()).withRequestType(RoomDimensions.class).withResponseType(APIResponse.class), new TypedRoute<RoomDimensions>(){

            @Override
            public Object onRequest(RoomDimensions roomDimensions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setRoomDimensions(roomDimensions, response);
            }
        }).get(MethodDescriptor.path("/room-is-sealed").withDescription("Get whether the room is sealed").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return RoomSimEndpoint.this.service.getRoomIsSealed();
            }
        }).post(MethodDescriptor.path("/room-is-sealed").withDescription("Set whether the room is sealed").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return RoomSimEndpoint.this.service.setRoomIsSealed(bl, response);
            }
        }).get(MethodDescriptor.path("/absorptions").withDescription("Get the absorptions ").withResponseType(Absorptions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return RoomSimEndpoint.this.service.getAbsorptions();
            }
        }).post(MethodDescriptor.path("/absorptions").withDescription("Set the absorptions ").withRequestType(Absorptions.class).withResponseType(APIResponse.class), new TypedRoute<Absorptions>(){

            @Override
            public Object onRequest(Absorptions absorptions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setAbsorptions(absorptions, response);
            }
        }).put(MethodDescriptor.path("/absorptions").withDescription("Set some absorptions ").withRequestType(Absorptions.class).withResponseType(APIResponse.class), new TypedRoute<Absorptions>(){

            @Override
            public Object onRequest(Absorptions absorptions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setAbsorptions(absorptions, response);
            }
        }).get(MethodDescriptor.path("/options").withDescription("Get the options ").withResponseType(RoomSimOptions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return RoomSimEndpoint.this.service.getOptions();
            }
        }).post(MethodDescriptor.path("/options").withDescription("Set the options ").withRequestType(RoomSimOptions.class).withResponseType(APIResponse.class), new TypedRoute<RoomSimOptions>(){

            @Override
            public Object onRequest(RoomSimOptions roomSimOptions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setOptions(roomSimOptions, response);
            }
        }).put(MethodDescriptor.path("/options").withDescription("Set some options ").withRequestType(RoomSimOptions.class).withResponseType(APIResponse.class), new TypedRoute<RoomSimOptions>(){

            @Override
            public Object onRequest(RoomSimOptions roomSimOptions, Request request, Response response) {
                return RoomSimEndpoint.this.service.setOptions(roomSimOptions, response);
            }
        }).get(MethodDescriptor.path("/head-position").withDescription("Get the head position ").withQueryParam().withName(RoomSimService.getLengthUnitKey()).withDescription("Specify the length unit  e.g. ?unit=metres, default is " + RoomSimService.getDefaultLengthUnit().apiName()).and().withResponseType(RoomPosition.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.queryParamOrDefault(RoomSimService.getLengthUnitKey(), RoomSimService.getDefaultLengthUnit().apiName());
                LengthUnit lengthUnit = LengthUnit.getFromApiName(string);
                if (lengthUnit == null) {
                    return APIResponse.badRequest(response, (Object)((Object)lengthUnit) + " is not a valid unit");
                }
                return APIResponse.ok(response, RoomSimEndpoint.this.service.getHeadPosition(lengthUnit));
            }
        }).post(MethodDescriptor.path("/head-position").withDescription("Set the head position ").withRequestType(RoomPosition.class).withResponseType(APIResponse.class), new TypedRoute<RoomPosition>(){

            @Override
            public Object onRequest(RoomPosition roomPosition, Request request, Response response) {
                return RoomSimEndpoint.this.service.setHeadPosition(roomPosition, response);
            }
        }).get(MethodDescriptor.path("/mic-posn-offsets").withDescription("Get the mic position offsets ").withQueryParam().withName(RoomSimService.getLengthUnitKey()).withDescription("Specify the length unit  e.g. ?unit=metres, default is " + RoomSimService.getDefaultLengthUnit().apiName()).and().withResponseType(MicPositionOffsets.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.queryParamOrDefault(RoomSimService.getLengthUnitKey(), RoomSimService.getDefaultLengthUnit().apiName());
                LengthUnit lengthUnit = LengthUnit.getFromApiName(string);
                if (lengthUnit == null) {
                    return APIResponse.badRequest(response, (Object)((Object)lengthUnit) + " is not a valid unit");
                }
                return RoomSimEndpoint.this.service.getMicPositionOffsets(lengthUnit);
            }
        }).post(MethodDescriptor.path("/mic-posn-offsets").withDescription("Set the mic position offsets, if the unit is omitted values will be treated as " + RoomSimService.getDefaultLengthUnit().apiName()).withRequestType(MicPositionOffsets.class).withResponseType(APIResponse.class), new TypedRoute<MicPositionOffsets>(){

            @Override
            public Object onRequest(MicPositionOffsets micPositionOffsets, Request request, Response response) {
                return RoomSimEndpoint.this.service.setMicPositionOffsets(micPositionOffsets, response);
            }
        }).put(MethodDescriptor.path("/mic-posn-offsets").withDescription("Set some mic position offsets, if the unit is omitted values will be treated as " + RoomSimService.getDefaultLengthUnit().apiName()).withRequestType(MicPositionOffsets.class).withResponseType(APIResponse.class), new TypedRoute<MicPositionOffsets>(){

            @Override
            public Object onRequest(MicPositionOffsets micPositionOffsets, Request request, Response response) {
                return RoomSimEndpoint.this.service.setMicPositionOffsets(micPositionOffsets, response);
            }
        }).get(MethodDescriptor.path("/sources").withDescription("Get the sources ").withResponseType(RoomSimSources.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return RoomSimEndpoint.this.service.getSources();
            }
        }).post(MethodDescriptor.path("/sources").withDescription("Set the sources ").withRequestType(RoomSimSources.class).withResponseType(APIResponse.class), new TypedRoute<RoomSimSources>(){

            @Override
            public Object onRequest(RoomSimSources roomSimSources, Request request, Response response) {
                return RoomSimEndpoint.this.service.setSources(roomSimSources, response);
            }
        }).get(MethodDescriptor.path("/mic-positions").withDescription("Get the list of mic position names ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return RoomSimService.getMicPositions();
            }
        }).get(MethodDescriptor.path("/frequency-response").withDescription("Gets the summed dB SPL frequency response for a mic position ").withQueryParam().withName(RoomSimService.getMicPosnKey()).withDescription("Specify the mic position  e.g. ?micposition=\"Main\"").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                if (!request.queryParams().contains(RoomSimService.getMicPosnKey())) {
                    return APIResponse.badRequest(response, "The request must have a query parameter for the mic position");
                }
                String string = request.queryParams(RoomSimService.getMicPosnKey());
                if (!RoomSimService.hasMicPosition(string)) {
                    return RoomSimEndpoint.this.micPosnNotFound(response, string);
                }
                return APIResponse.ok(response, RoomSimEndpoint.this.service.getFrequencyResponse(request, response, null));
            }
        }).get(MethodDescriptor.path("/:src/frequency-response").withDescription("Gets the dB SPL frequency response for the source at a mic position ").withQueryParam().withName(RoomSimService.getMicPosnKey()).withDescription("Specify the mic position  e.g. ?micposition=\"Main\"").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.params(":src");
                SpeakerID speakerID = SpeakerID.getFromApiName(string);
                if (speakerID == null) {
                    return RoomSimEndpoint.this.sourceNotFound(response, string);
                }
                if (!request.queryParams().contains(RoomSimService.getMicPosnKey())) {
                    return APIResponse.badRequest(response, "The request must have a query parameter for the mic position");
                }
                String string2 = request.queryParams(RoomSimService.getMicPosnKey());
                if (!RoomSimService.hasMicPosition(string2)) {
                    return RoomSimEndpoint.this.micPosnNotFound(response, string2);
                }
                return APIResponse.ok(response, RoomSimEndpoint.this.service.getFrequencyResponse(request, response, speakerID));
            }
        }).get(MethodDescriptor.path("/:src/position").withDescription("Get the position for src ").withQueryParam().withName(RoomSimService.getLengthUnitKey()).withDescription("Specify the length unit  e.g. ?unit=metres, default is " + RoomSimService.getDefaultLengthUnit().apiName()).and().withResponseType(RoomPosition.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.params(":src");
                SpeakerID speakerID = SpeakerID.getFromApiName(string);
                if (speakerID == null) {
                    return RoomSimEndpoint.this.sourceNotFound(response, string);
                }
                String string2 = request.queryParamOrDefault(RoomSimService.getLengthUnitKey(), RoomSimService.getDefaultLengthUnit().apiName());
                LengthUnit lengthUnit = LengthUnit.getFromApiName(string2);
                if (lengthUnit == null) {
                    return APIResponse.badRequest(response, (Object)((Object)lengthUnit) + " is not a valid unit");
                }
                return APIResponse.ok(response, RoomSimEndpoint.this.service.getSourcePosition(speakerID, lengthUnit));
            }
        }).post(MethodDescriptor.path("/:src/position").withDescription("Set the position for src ").withRequestType(RoomPosition.class).withResponseType(APIResponse.class), new TypedRoute<RoomPosition>(){

            @Override
            public Object onRequest(RoomPosition roomPosition, Request request, Response response) {
                String string = request.params(":src");
                SpeakerID speakerID = SpeakerID.getFromApiName(string);
                if (speakerID == null) {
                    return RoomSimEndpoint.this.sourceNotFound(response, string);
                }
                return RoomSimEndpoint.this.service.setSourcePosition(roomPosition, response, speakerID);
            }
        }).get(MethodDescriptor.path("/:src/configuration").withDescription("Get the configuration for src ").withResponseType(SourceConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                String string = request.params(":src");
                SpeakerID speakerID = SpeakerID.getFromApiName(string);
                if (speakerID == null) {
                    return RoomSimEndpoint.this.sourceNotFound(response, string);
                }
                return APIResponse.ok(response, RoomSimEndpoint.this.service.getSourceConfiguration(speakerID));
            }
        }).post(MethodDescriptor.path("/:src/configuration").withDescription("Set the configuration for src ").withRequestType(SourceConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SourceConfiguration>(){

            @Override
            public Object onRequest(SourceConfiguration sourceConfiguration, Request request, Response response) {
                String string = request.params(":src");
                SpeakerID speakerID = SpeakerID.getFromApiName(string);
                if (speakerID == null) {
                    return RoomSimEndpoint.this.sourceNotFound(response, string);
                }
                return RoomSimEndpoint.this.service.setSourceConfiguration(sourceConfiguration, response, speakerID);
            }
        });
    }

    private APIResponse sourceNotFound(Response response, String string) {
        ValidValues validValues = ValidValues.builder().message(string + " is not a recognised source name").validValues(RoomSimService.getSourceNames()).build();
        return APIResponse.badRequest(response, validValues);
    }

    private APIResponse micPosnNotFound(Response response, String string) {
        ValidValues validValues = ValidValues.builder().message(string + " is not a recognised mic position").validValues(RoomSimService.getMicPositions()).build();
        return APIResponse.badRequest(response, validValues);
    }
}

