/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.RTAService;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.RTAAppearanceConfiguration;
import roomeqwizard.api.model.RTAConfiguration;
import roomeqwizard.api.model.RTADistortion;
import roomeqwizard.api.model.RTADistortionConfiguration;
import roomeqwizard.api.model.RTALevel;
import roomeqwizard.api.model.RTAStatus;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.sE;
import spark.Request;
import spark.Response;

public class RTAEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/rta";
    private final RTAService service = new RTAService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("RTA settings and commands "), null).get(MethodDescriptor.path("/status").withDescription("Get the RTA status ").withResponseType(RTAStatus.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getStatus());
            }
        }).post(MethodDescriptor.path("/status/subscribe").withDescription("Subscribe to RTA status updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.RTA_STATUS, response);
            }
        }).post(MethodDescriptor.path("/status/unsubscribe").withDescription("Unsubscribe from RTA status updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.RTA_STATUS, response);
            }
        }).get(MethodDescriptor.path("/status/subscribers").withDescription("Get the RTA status subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getSubscribers(SubscriptionType.RTA_STATUS));
            }
        }).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send an RTA command  ").withRequestType(Command.class).withResponseStatus(200, 202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return RTAEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/configuration").withDescription("Get the configuration options for the RTA ").withResponseType(RTAConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getConfiguration());
            }
        }).post(MethodDescriptor.path("/configuration").withDescription("Configure the RTA ").withRequestType(RTAConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTAConfiguration>(){

            @Override
            public Object onRequest(RTAConfiguration rTAConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setConfiguration(rTAConfiguration, response);
            }
        }).put(MethodDescriptor.path("/configuration").withDescription("Configure some settings of the RTA ").withRequestType(RTAConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTAConfiguration>(){

            @Override
            public Object onRequest(RTAConfiguration rTAConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setConfiguration(rTAConfiguration, response);
            }
        }).get(MethodDescriptor.path("/configuration/modes").withDescription("Get the list of RTA modes ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getModes());
            }
        }).get(MethodDescriptor.path("/configuration/fft-lengths").withDescription("Get the list of FFT lengths ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getRTALengths());
            }
        }).get(MethodDescriptor.path("/configuration/averaging-choices").withDescription("Get the list of averaging choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getAveragingChoices());
            }
        }).get(MethodDescriptor.path("/configuration/smoothing-choices").withDescription("Get the list of smoothing choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getSmoothingChoices());
            }
        }).get(MethodDescriptor.path("/configuration/window-choices").withDescription("Get the list of window choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getWindowChoices());
            }
        }).get(MethodDescriptor.path("/configuration/overlap-choices").withDescription("Get the list of maximum overlap choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getOverlapChoices());
            }
        }).get(MethodDescriptor.path("/captured-data/units").withDescription("Get the list of Y axis unit choices for captured data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getUnits());
            }
        }).get(MethodDescriptor.path("/captured-data").withDescription("Get the captured data, with the float array of values encoded as a Base64 string").withQueryParam().withName(RTAService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + sE.\u013e().C()).and().withQueryParam().withName(RTAService.getINDEX_KEY()).withDescription("Specify the indx of the input whose data is to be returned ?index=1. Only applicable for multi-input capture. Input indices start at 1. No index returns the rms average of the inputs.").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTAData(request, response));
            }
        }).post(MethodDescriptor.path("/captured-data/subscribe").withDescription("Subscribe to RTA captured data updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.RTA_CURRENT, response);
            }
        }).post(MethodDescriptor.path("/captured-data/unsubscribe").withDescription("Unsubscribe from RTA captured data updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.RTA_CURRENT, response);
            }
        }).get(MethodDescriptor.path("/captured-data/subscribers").withDescription("Get the RTA captured data subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getSubscribers(SubscriptionType.RTA_CURRENT));
            }
        }).get(MethodDescriptor.path("/captured-peak-data").withDescription("Get the captured peak data, with the float array of values encoded as a Base64 string").withQueryParam().withName(RTAService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + sE.\u013e().C()).and().withQueryParam().withName(RTAService.getINDEX_KEY()).withDescription("Specify the index of the input whose data is to be returned ?input=1. Only applicable for multi-input capture. Input indices start at 1. No index returns the rms average of the inputs.").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTAPeakData(request, response));
            }
        }).post(MethodDescriptor.path("/captured-peak-data/subscribe").withDescription("Subscribe to RTA captured peak data updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.RTA_PEAK, response);
            }
        }).post(MethodDescriptor.path("/captured-peak-data/unsubscribe").withDescription("Unsubscribe from RTA captured peak data updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.RTA_PEAK, response);
            }
        }).get(MethodDescriptor.path("/captured-peak-data/subscribers").withDescription("Get the RTA captured peak data subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getSubscribers(SubscriptionType.RTA_PEAK));
            }
        }).get(MethodDescriptor.path("/distortion-configuration").withDescription("Get the RTA distortion configuration options").withResponseType(RTADistortionConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTADistortionConfiguration());
            }
        }).post(MethodDescriptor.path("/distortion-configuration").withDescription("Configure the RTA distortion settings").withRequestType(RTADistortionConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTADistortionConfiguration>(){

            @Override
            public Object onRequest(RTADistortionConfiguration rTADistortionConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setDistortionConfiguration(rTADistortionConfiguration, response);
            }
        }).put(MethodDescriptor.path("/distortion-configuration").withDescription("Configure some RTA distortion settings").withRequestType(RTADistortionConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTADistortionConfiguration>(){

            @Override
            public Object onRequest(RTADistortionConfiguration rTADistortionConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setDistortionConfiguration(rTADistortionConfiguration, response);
            }
        }).get(MethodDescriptor.path("/distortion-configuration/distortion-units").withDescription("Get the list of distortion unit choices  ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getDistortionUnits());
            }
        }).get(MethodDescriptor.path("/appearance-configuration").withDescription("Get the RTA appearance configuration options").withResponseType(RTAAppearanceConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTAAppearanceConfiguration());
            }
        }).post(MethodDescriptor.path("/appearance-configuration").withDescription("Configure the RTA appearance settings").withRequestType(RTAAppearanceConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTAAppearanceConfiguration>(){

            @Override
            public Object onRequest(RTAAppearanceConfiguration rTAAppearanceConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setAppearanceConfiguration(rTAAppearanceConfiguration, response);
            }
        }).put(MethodDescriptor.path("/appearance-configuration").withDescription("Configure some RTA appearance settings").withRequestType(RTAAppearanceConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RTAAppearanceConfiguration>(){

            @Override
            public Object onRequest(RTAAppearanceConfiguration rTAAppearanceConfiguration, Request request, Response response) {
                return RTAEndpoint.this.service.setAppearanceConfiguration(rTAAppearanceConfiguration, response);
            }
        }).get(MethodDescriptor.path("/appearance-configuration/update-intervals").withDescription("Get the list of update interval choices  ").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getUpdateIntervals());
            }
        }).get(MethodDescriptor.path("/appearance-configuration/peak-holds").withDescription("Get the list of peak hold choices  ").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getPeakHolds());
            }
        }).get(MethodDescriptor.path("/appearance-configuration/peak-decays").withDescription("Get the list of peak decay choices  ").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getPeakDecays());
            }
        }).get(MethodDescriptor.path("/appearance-configuration/noise-curves").withDescription("Get the list of noise curve choices  ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getNoiseCurves());
            }
        }).get(MethodDescriptor.path("/appearance-configuration/cea-limits").withDescription("Get the list of CEA max SPL limit choices  ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getCEALimits());
            }
        }).get(MethodDescriptor.path("/levels").withDescription("Get the RTA input levels ").withQueryParam().withName(RTAService.getAXIS_UNIT_KEY()).withDescription("Specify the levels data unit  e.g. ?unit=dBFS, default is " + sE.\u013e().C()).and().withResponseAsCollection(RTALevel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTALevels(request, response));
            }
        }).post(MethodDescriptor.path("/levels/subscribe").withDescription("Subscribe to RTA input level updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.RTA_LEVEL, response);
            }
        }).post(MethodDescriptor.path("/levels/unsubscribe").withDescription("Unsubscribe from RTA input level updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.RTA_LEVEL, response);
            }
        }).get(MethodDescriptor.path("/levels/subscribers").withDescription("Get the RTA input level subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getSubscribers(SubscriptionType.RTA_LEVEL));
            }
        }).get(MethodDescriptor.path("/levels/units").withDescription("Get the list of Y axis unit choices for levels data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getUnits());
            }
        }).get(MethodDescriptor.path("/distortion").withDescription("Get the RTA distortion results").withQueryParam().withName(RTAService.getAXIS_UNIT_KEY()).withDescription("Specify the distortion value unit  e.g. ?unit=SPL, default is " + sE.\u013e().C()).and().withQueryParam().withName(RTAService.getDIST_UNIT_KEY()).withDescription("Specify the relative distortion unit  e.g. ?distortion=percent, default is " + sE.\u0154().apiName()).and().withResponseAsCollection(RTADistortion.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getRTADistortion(request, response));
            }
        }).post(MethodDescriptor.path("/distortion/subscribe").withDescription("Subscribe to RTA distortion updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.RTA_DISTORTION, response);
            }
        }).post(MethodDescriptor.path("/distortion/unsubscribe").withDescription("Unsubscribe from RTA input distortion updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return RTAEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.RTA_DISTORTION, response);
            }
        }).get(MethodDescriptor.path("/distortion/subscribers").withDescription("Get the RTA input distortion subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAEndpoint.this.service.getSubscribers(SubscriptionType.RTA_DISTORTION));
            }
        }).get(MethodDescriptor.path("/distortion/units").withDescription("Get the list of Y axis unit choices for distortion data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getUnits());
            }
        }).get(MethodDescriptor.path("/distortion/relative-units").withDescription("Get the list of relative distortion unit choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, RTAService.getDistortionUnits());
            }
        });
    }
}

