/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.$B;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.MeasurementsService;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.EqualiserEntry;
import roomeqwizard.api.model.FilterList;
import roomeqwizard.api.model.FilterSetting;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.IRWindows;
import roomeqwizard.api.model.ImpulseResponse;
import roomeqwizard.api.model.MeasurementSummary;
import roomeqwizard.api.model.ProcessMeasurements;
import roomeqwizard.api.model.ProcessResult;
import roomeqwizard.api.model.ProcessSingleMeasurement;
import roomeqwizard.api.model.RoomCurveSettings;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.TargetSettings;
import roomeqwizard.uB;
import spark.Request;
import spark.Response;

public class MeasurementsEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/measurements";
    private static final String SAMPLE_RATE_KEY = "samplerate";
    private static final String LENGTH_KEY = "length";
    private final MeasurementsService service = new MeasurementsService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Measurements API exposing all measurements "), null).get(MethodDescriptor.path("").withDescription("Gets a summary list of all measurements").withResponseAsMap(MeasurementSummary.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                Gson gson = new GsonBuilder().disableHtmlEscaping().serializeSpecialFloatingPointValues().create();
                return APIResponse.ok(response, gson.toJsonTree(MeasurementsEndpoint.this.service.getMeasurementSummaries()));
            }
        }).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a measurements command  ").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return MeasurementsEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/process-commands").withDescription("Get the list of process commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getProcessCommands());
            }
        }).get(MethodDescriptor.path("/process-result").withDescription("Get the result of the last process command ").withResponseType(ProcessResult.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getProcessResult());
            }
        }).get(MethodDescriptor.path("/arithmetic-functions").withDescription("Get the list of functions for the Arithmetic process command ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getArithmeticFunctions());
            }
        }).post(MethodDescriptor.path("/process-measurements").withDescription("Send a command to process a list of measuremnts ").withRequestType(ProcessMeasurements.class).withResponseStatus(200, 202).withResponseType(APIResponse.class), new TypedRoute<ProcessMeasurements>(){

            @Override
            public Object onRequest(ProcessMeasurements processMeasurements, Request request, Response response) {
                return MeasurementsEndpoint.this.service.runProcessMeasurements(processMeasurements, response);
            }
        }).get(MethodDescriptor.path("/selected").withDescription("Get the index of the selected measurement ").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getSelectedIndex());
            }
        }).post(MethodDescriptor.path("/selected").withDescription("Select the measurement at the provided index ").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasurementsEndpoint.this.service.setSelectedIndex(n2, response);
            }
        }).get(MethodDescriptor.path("/frequency-response/units").withDescription("Get the list of Y axis unit choices for frequency response data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsService.getFrequencyResponseUnits());
            }
        }).get(MethodDescriptor.path("/frequency-response/smoothing-choices").withDescription("Get the list of smoothing choices for frequency response data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsService.getSmoothingChoices());
            }
        }).get(MethodDescriptor.path("/impulse-response/units").withDescription("Get the list of Y axis unit choices for impulse response data ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsService.getImpulseResponseUnits());
            }
        }).post(MethodDescriptor.path("/subscribe").withDescription("Subscribe to measurement updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return MeasurementsEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.MEASUREMENT, response);
            }
        }).post(MethodDescriptor.path("/unsubscribe").withDescription("Unsubscribe from measurement updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return MeasurementsEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.MEASUREMENT, response);
            }
        }).get(MethodDescriptor.path("/subscribers").withDescription("Get the measurement subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getSubscribers(SubscriptionType.MEASUREMENT));
            }
        }).get(MethodDescriptor.path("/eq/commands").withDescription("Get the list of EQ commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getEQCommands());
            }
        }).get(MethodDescriptor.path("/spectrogram-window-choices").withDescription("Get the list of spectrogram window type choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsService.getWindowChoices());
            }
        }).get(MethodDescriptor.path("/spectrogram-amplitude-choices").withDescription("Get the list of spectrogram amplitude choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsService.getAmplitudeChoices());
            }
        }).get(MethodDescriptor.path("/:id").withDescription("Gets the summary for the measurement at index id, index starts from 1").withResponseType(MeasurementSummary.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getMeasurementSummary(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id").withDescription("Change measurement title and/or notes ").withRequestType(MeasurementSummary.class).withResponseType(APIResponse.class), new TypedRoute<MeasurementSummary>(){

            @Override
            public Object onRequest(MeasurementSummary measurementSummary, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    MeasurementSummary measurementSummary2 = MeasurementsEndpoint.this.service.getMeasurementSummary(n2);
                    if (measurementSummary2 != null) {
                        return MeasurementsEndpoint.this.service.setSummary(measurementSummary, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/commands").withDescription("Get the list of commands for an individual measurement").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasurementsEndpoint.this.service.getSingleCommands());
            }
        }).post(MethodDescriptor.path("/:id/command").withDescription("Send a command for the measurement at index id, index starts from 1 ").withRequestType(ProcessSingleMeasurement.class).withResponseStatus(200, 202).withResponseType(APIResponse.class), new TypedRoute<ProcessSingleMeasurement>(){

            @Override
            public Object onRequest(ProcessSingleMeasurement processSingleMeasurement, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return MeasurementsEndpoint.this.service.runSingleCommand(processSingleMeasurement, response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/ir-windows").withDescription("Get the IR window settings for the measurement at index id, index starts from 1").withResponseType(IRWindows.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    if (!MeasurementsEndpoint.this.service.measurementHasIR(n2)) {
                        return MeasurementsEndpoint.this.measurementHasNoIR(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getIRWindows(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/ir-windows").withDescription("Change the IR window settings for the measurement at index id, index starts from 1").withRequestType(IRWindows.class).withResponseType(APIResponse.class), new TypedRoute<IRWindows>(){

            @Override
            public Object onRequest(IRWindows iRWindows, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    if (!MeasurementsEndpoint.this.service.measurementHasIR(n2)) {
                        return MeasurementsEndpoint.this.measurementHasNoIR(response, n2);
                    }
                    return MeasurementsEndpoint.this.service.setIRWindows(iRWindows, response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id/ir-windows").withDescription("Change some IR window settings for the measurement at index id, index starts from 1").withRequestType(IRWindows.class).withResponseType(APIResponse.class), new TypedRoute<IRWindows>(){

            @Override
            public Object onRequest(IRWindows iRWindows, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    if (!MeasurementsEndpoint.this.service.measurementHasIR(n2)) {
                        return MeasurementsEndpoint.this.measurementHasNoIR(response, n2);
                    }
                    return MeasurementsEndpoint.this.service.setIRWindows(iRWindows, response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/equaliser").withDescription("Get the equaliser for the measurement at index id, index starts from 1").withResponseType(EqualiserEntry.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getEqualiser(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/equaliser").withDescription("Change the equaliser selection for the measurement at index id, index starts from 1").withRequestType(EqualiserEntry.class).withResponseType(APIResponse.class), new TypedRoute<EqualiserEntry>(){

            @Override
            public Object onRequest(EqualiserEntry equaliserEntry, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setEqualiser(equaliserEntry, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/target-settings").withDescription("Get the target settings for the measurement at index id, index starts from 1").withResponseType(TargetSettings.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getTargetSettings(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/target-settings").withDescription("Change the target settings for the measurement at index id, index starts from 1").withRequestType(TargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<TargetSettings>(){

            @Override
            public Object onRequest(TargetSettings targetSettings, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setTargetSettings(targetSettings, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id/target-settings").withDescription("Change some target settings for the measurement at index id, index starts from 1").withRequestType(TargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<TargetSettings>(){

            @Override
            public Object onRequest(TargetSettings targetSettings, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setTargetSettings(targetSettings, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/target-level").withDescription("Get the target level in dB SPL for the measurement at index id, index starts from 1").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getTargetLevel(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/target-level").withDescription("Set the target level in dB SPL for the measurement at index id, index starts from 1").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setTargetLevel(d2, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/room-curve-settings").withDescription("Get the room curve settings for the measurement at index id, index starts from 1").withResponseType(RoomCurveSettings.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getRoomCurveSettings(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/room-curve-settings").withDescription("Change the room curve settings for the measurement at index id, index starts from 1").withRequestType(RoomCurveSettings.class).withResponseType(APIResponse.class), new TypedRoute<RoomCurveSettings>(){

            @Override
            public Object onRequest(RoomCurveSettings roomCurveSettings, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setRoomCurveSettings(roomCurveSettings, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id/room-curve-settings").withDescription("Change some room curve settings for the measurement at index id, index starts from 1").withRequestType(RoomCurveSettings.class).withResponseType(APIResponse.class), new TypedRoute<RoomCurveSettings>(){

            @Override
            public Object onRequest(RoomCurveSettings roomCurveSettings, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setRoomCurveSettings(roomCurveSettings, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/filters").withDescription("Get the filters for the measurement at index id, index starts from 1").withResponseAsCollection(FilterSetting.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getFilters(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/filters").withDescription("Change the filters for the measurement at index id, index starts from 1").withRequestType(FilterList.class).withResponseType(APIResponse.class), new TypedRoute<FilterList>(){

            @Override
            public Object onRequest(FilterList filterList, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setFilters(filterList, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).put(MethodDescriptor.path("/:id/filters").withDescription("Change a filter for the measurement at index id, index starts from 1").withRequestType(FilterSetting.class).withResponseType(APIResponse.class), new TypedRoute<FilterSetting>(){

            @Override
            public Object onRequest(FilterSetting filterSetting, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.setFilter(filterSetting, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/target-response").withDescription("Gets the frequency response of the target for the measurement at index id, index starts from 1").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + $B.Y.C()).and().withQueryParam().withName(MeasurementsService.getPPO_KEY()).withDescription("Specify the points per octave to get log-spaced data  e.g. ?ppo=48, default is 96 PPO").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getTargetResponse(request, response, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/frequency-response").withDescription("Gets the frequency response for the measurement at index id, index starts from 1").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + $B.Y.C()).and().withQueryParam().withName(MeasurementsService.getSMOOTHING_KEY()).withDescription("Specify the smoothing  e.g. ?smoothing=\"1/12\", default is the measurement's current smoothing").and().withQueryParam().withName(MeasurementsService.getPPO_KEY()).withDescription("Specify the points per octave to get log-spaced data  e.g. ?ppo=48, default is the measurement's current spacing").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getMeasuredFrequencyResponse(request, response, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/eq/frequency-response").withDescription("Gets the predicted frequency response for the equalised measurement at index id, index starts from 1").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + $B.Y.C()).and().withQueryParam().withName(MeasurementsService.getSMOOTHING_KEY()).withDescription("Specify the smoothing  e.g. ?smoothing=\"1/12\", default is the measurement's current smoothing").and().withQueryParam().withName(MeasurementsService.getPPO_KEY()).withDescription("Specify the points per octave to get log-spaced data  e.g. ?ppo=48, default is the measurement's current spacing").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getPredictedFrequencyResponse(request, response, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/impulse-response").withDescription("Gets the impulse response for the measurement at index id, index starts from 1").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the impulse data unit  e.g. ?unit=dBFS, default is " + MeasurementsService.getDefaultImpulseResponseAxis().C()).and().withQueryParam().withName(MeasurementsService.getWINDOWED_KEY()).withDescription("For windowed data include ?windowed=true, default is false").and().withQueryParam().withName(MeasurementsService.getNORMALISED_KEY()).withDescription("For data that is not normalised include ?normalised=false, default is true").and().withResponseType(ImpulseResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    if (!MeasurementsEndpoint.this.service.measurementHasIR(n2)) {
                        return MeasurementsEndpoint.this.measurementHasNoIR(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getMeasuredImpulseResponse(request, response, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/eq/impulse-response").withDescription("Gets the predicted impulse response for the equalised measurement at index id, index starts from 1").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the impulse data unit  e.g. ?unit=dBFS, default is " + MeasurementsService.getDefaultImpulseResponseAxis().C()).and().withQueryParam().withName(MeasurementsService.getWINDOWED_KEY()).withDescription("For windowed data include ?windowed=true, default is false").and().withQueryParam().withName(MeasurementsService.getNORMALISED_KEY()).withDescription("For data that is not normalised include ?normalised=false, default is true").and().withResponseType(ImpulseResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getPredictedImpulseResponse(request, response, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).get(MethodDescriptor.path("/:id/filters-impulse-response").withDescription("Gets the filters impulse response for the measurement at index id, index starts from 1").withQueryParam().withName(SAMPLE_RATE_KEY).withDescription("Use samplerate to set the sample rate in Hz, e.g. ?samplerate=48000").and().withQueryParam().withName(LENGTH_KEY).withDescription("Use length to set the number of samples in the impulse response, e.g. ?length=65536").and().withResponseType(ImpulseResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (!MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                    }
                    String string = request.queryParamOrDefault(MeasurementsEndpoint.SAMPLE_RATE_KEY, "");
                    if (string.isEmpty()) {
                        return APIResponse.badRequest(response, "The sample rate must be specified");
                    }
                    Double d2 = API.getFrequency(string);
                    if (d2 == null) {
                        return APIResponse.badRequest(response, string + " does not appear to be a sample rate");
                    }
                    String string2 = request.queryParamOrDefault(MeasurementsEndpoint.LENGTH_KEY, "");
                    if (string2.isEmpty()) {
                        return APIResponse.badRequest(response, "The length must be specified");
                    }
                    Integer n3 = API.getInt(string2);
                    if (n3 == null) {
                        return APIResponse.badRequest(response, string2 + " does not appear to be a number of samples");
                    }
                    if (n3 <= 0) {
                        return APIResponse.badRequest(response, "The number of samples must be greater than zero");
                    }
                    if (n3 > uB.C().E()) {
                        return APIResponse.badRequest(response, "The number of samples must be at most " + uB.C().E());
                    }
                    return APIResponse.ok(response, MeasurementsEndpoint.this.service.getFiltersImpulseResponse(request, response, n2, (double)d2, (int)n3));
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).post(MethodDescriptor.path("/:id/eq/command").withDescription("Send an EQ command for the measurement at index id, index starts from 1").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    if (MeasurementsEndpoint.this.service.measurementExistsAt(n2)) {
                        return MeasurementsEndpoint.this.service.runEQCommand(command, response, n2);
                    }
                    return MeasurementsEndpoint.this.measurementNotFound(response, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).delete(MethodDescriptor.path("/:id").withDescription("Deletes the measurement at index id, index starts from 1").withResponseType(APIResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                try {
                    int n2 = Integer.parseInt(request.params(":id")) - 1;
                    return MeasurementsEndpoint.this.service.deleteMeasurement(n2, response);
                }
                catch (NumberFormatException numberFormatException) {
                    return MeasurementsEndpoint.this.badIndex(request, response);
                }
            }
        }).delete(MethodDescriptor.path("").withDescription("Remove all measurements").withResponseType(APIResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return MeasurementsEndpoint.this.service.deleteAll(response);
            }
        });
    }

    private APIResponse measurementHasNoIR(Response response, int n2) {
        return APIResponse.notFound(response, "The measurement at index " + (n2 + 1) + " does not have an impulse response");
    }

    private APIResponse measurementNotFound(Response response, int n2) {
        return APIResponse.notFound(response, "There is no measurement at index " + (n2 + 1) + ", there are " + this.service.numMeasurements() + " measurements");
    }

    private APIResponse badIndex(Request request, Response response) {
        return APIResponse.badRequest(response, "Measurement indices are numeric, this is not a valid measurement index: " + request.params(":id"));
    }
}

