/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.GeneratorService;
import roomeqwizard.api.MeasureService;
import roomeqwizard.api.model.ChannelList;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.MeasSweepConfiguration;
import roomeqwizard.api.model.MeasurementNaming;
import roomeqwizard.api.model.Protections;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.Value;
import spark.Request;
import spark.Response;

public class MeasureEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/measure";
    private final MeasureService service = new MeasureService();

    public static String getNameSpace() {
        return "/measure/";
    }

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Measure API exposing ways to measure "), null).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a measure command  ").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return MeasureEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/naming").withDescription("Get the measurement naming settings ").withResponseType(MeasurementNaming.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getNaming());
            }
        }).post(MethodDescriptor.path("/naming").withDescription("Configure measurement naming ").withRequestType(MeasurementNaming.class).withResponseType(APIResponse.class), new TypedRoute<MeasurementNaming>(){

            @Override
            public Object onRequest(MeasurementNaming measurementNaming, Request request, Response response) {
                return MeasureEndpoint.this.service.setNaming(measurementNaming, response);
            }
        }).put(MethodDescriptor.path("/naming").withDescription("Configure some settings of measurement naming ").withRequestType(MeasurementNaming.class).withResponseType(APIResponse.class), new TypedRoute<MeasurementNaming>(){

            @Override
            public Object onRequest(MeasurementNaming measurementNaming, Request request, Response response) {
                return MeasureEndpoint.this.service.setNaming(measurementNaming, response);
            }
        }).get(MethodDescriptor.path("/naming/naming-options").withDescription("Get the list of naming options ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getNamingOptions());
            }
        }).get(MethodDescriptor.path("/naming/date-time-formats").withDescription("Get the list of date/time formats ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getDateTimeFormats());
            }
        }).get(MethodDescriptor.path("/notes").withDescription("Get the notes that will be used for the next measurement").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getNotes());
            }
        }).post(MethodDescriptor.path("/notes").withDescription("Set the notes that will be used for the next measurement").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return MeasureEndpoint.this.service.setNotes(string, response);
            }
        }).get(MethodDescriptor.path("/level").withDescription("Get the measurement level ").withResponseType(Value.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getLevel());
            }
        }).get(MethodDescriptor.path("/level/units").withDescription("Get the accepted units for the measurement level ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getLevelUnits());
            }
        }).post(MethodDescriptor.path("/level").withDescription("Set the measurement level").withRequestType(Value.class).withResponseType(APIResponse.class), new TypedRoute<Value>(){

            @Override
            public Object onRequest(Value value, Request request, Response response) {
                return MeasureEndpoint.this.service.setLevel(value, response);
            }
        }).get(MethodDescriptor.path("/protection-options").withDescription("Get the protection options").withResponseType(Protections.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getProtectionOptions());
            }
        }).post(MethodDescriptor.path("/protection-options").withDescription("Set the protection options").withRequestType(Protections.class).withResponseType(APIResponse.class), new TypedRoute<Protections>(){

            @Override
            public Object onRequest(Protections protections, Request request, Response response) {
                return MeasureEndpoint.this.service.setProtectionOptions(protections, response);
            }
        }).put(MethodDescriptor.path("/protection-options").withDescription("Set some protection options").withRequestType(Protections.class).withResponseType(APIResponse.class), new TypedRoute<Protections>(){

            @Override
            public Object onRequest(Protections protections, Request request, Response response) {
                return MeasureEndpoint.this.service.setProtectionOptions(protections, response);
            }
        }).get(MethodDescriptor.path("/sweep/configuration").withDescription("Get the configuration for the measurement sweep ").withResponseType(MeasSweepConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getMeasSweepConfiguration());
            }
        }).post(MethodDescriptor.path("/sweep/configuration").withDescription("Configure the measurement sweep ").withRequestType(MeasSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MeasSweepConfiguration>(){

            @Override
            public Object onRequest(MeasSweepConfiguration measSweepConfiguration, Request request, Response response) {
                return GeneratorService.setMeasSweepConfiguration(measSweepConfiguration, response);
            }
        }).put(MethodDescriptor.path("/sweep/configuration").withDescription("Configure some settings of the measurement sweep ").withRequestType(MeasSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MeasSweepConfiguration>(){

            @Override
            public Object onRequest(MeasSweepConfiguration measSweepConfiguration, Request request, Response response) {
                return GeneratorService.setMeasSweepConfiguration(measSweepConfiguration, response);
            }
        }).get(MethodDescriptor.path("/sweep/configuration/sweep-lengths").withDescription("Get the sweep length options for the measurement sweep ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSweepLengths());
            }
        }).get(MethodDescriptor.path("/sweep/repetitions").withDescription("Get the number of sweep repetitions").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getSweepRepetitions());
            }
        }).post(MethodDescriptor.path("/sweep/repetitions").withDescription("Set the number of sweep repetitions").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setSweepRepetitions(n2, response);
            }
        }).get(MethodDescriptor.path("/measurement-mode").withDescription("Get the measurement mode").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getMeasurementMode());
            }
        }).post(MethodDescriptor.path("/measurement-mode").withDescription("Set the measurement mode").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return MeasureEndpoint.this.service.setMeasurementMode(string, response);
            }
        }).get(MethodDescriptor.path("/measurement-mode/choices").withDescription("Get the measurement mode choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getMeasurementModes());
            }
        }).get(MethodDescriptor.path("/sequential-channels").withDescription("Get the channel selections for the sequential measurement mode").withResponseType(ChannelList.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getSequentialChannels());
            }
        }).post(MethodDescriptor.path("/sequential-channels").withDescription("Set the channel selections for the sequential measurement mode").withRequestType(ChannelList.class).withResponseType(APIResponse.class), new TypedRoute<ChannelList>(){

            @Override
            public Object onRequest(ChannelList channelList, Request request, Response response) {
                return MeasureEndpoint.this.service.setSequentialChannels(channelList, response);
            }
        }).get(MethodDescriptor.path("/sequential-choices").withDescription("Get the available channel choices for the sequential measurement mode").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getSequentialChoices());
            }
        }).get(MethodDescriptor.path("/filtered-spl-filter-source").withDescription("Get the index of the measurement that will provide the filters for a Filtered SPL measurement").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getFilteredSPLFilterSource());
            }
        }).post(MethodDescriptor.path("/filtered-spl-filter-source").withDescription("Set the index of the measurement that will provide the filters for a Filtered SPL measurement").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setFilteredSPLFilterSource(n2, response);
            }
        }).get(MethodDescriptor.path("/playback-mode").withDescription("Get the playback mode").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getPlaybackMode());
            }
        }).post(MethodDescriptor.path("/playback-mode").withDescription("Set the playback mode").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return MeasureEndpoint.this.service.setPlaybackMode(string, response);
            }
        }).get(MethodDescriptor.path("/playback-mode/choices").withDescription("Get the playback mode choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getPlaybackModes());
            }
        }).get(MethodDescriptor.path("/timing/reference").withDescription("Get the timing reference").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getTimingReference());
            }
        }).post(MethodDescriptor.path("/timing/reference").withDescription("Set the timing reference").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return MeasureEndpoint.this.service.setTimingReference(string, response);
            }
        }).get(MethodDescriptor.path("/timing/reference/choices").withDescription("Get the timing choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getTimingReferenceChoices());
            }
        }).get(MethodDescriptor.path("/timing/reference/none/tzero").withDescription("Get the t=0 option with no timing reference").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getTZero());
            }
        }).post(MethodDescriptor.path("/timing/reference/none/tzero").withDescription("Set the t=0 option with no timing reference").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return MeasureEndpoint.this.service.setTZero(string, response);
            }
        }).get(MethodDescriptor.path("/timing/reference/none/tzero/choices").withDescription("Get the t=0 option choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureService.getTZeroChoices());
            }
        }).get(MethodDescriptor.path("/timing/reference/looback-cal/merge").withDescription("Get whether the loopback calibration should be merged with the IR").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getMergeLoopbackCal());
            }
        }).post(MethodDescriptor.path("/timing/reference/looback-cal/merge").withDescription("Set whether the loopback calibration should be merged with the IR").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setMergeLoopbackCal(bl, response);
            }
        }).get(MethodDescriptor.path("/timing/reference/acoustic/trim").withDescription("Get the timing reference level trim").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getTimingRefTrim());
            }
        }).post(MethodDescriptor.path("/timing/reference/acoustic/trim").withDescription("Set the timing reference level trim").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return MeasureEndpoint.this.service.setTimingRefTrim(d2, response);
            }
        }).get(MethodDescriptor.path("/timing/reference/wired/trim").withDescription("Get the timing reference level trim").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getTimingRefTrim());
            }
        }).post(MethodDescriptor.path("/timing/reference/wired/trim").withDescription("Set the timing reference level trim").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return MeasureEndpoint.this.service.setTimingRefTrim(d2, response);
            }
        }).get(MethodDescriptor.path("/timing/offset").withDescription("Get the timing offset in seconds").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getTimingOffset());
            }
        }).post(MethodDescriptor.path("/timing/offset").withDescription("Set the timing offset in seconds").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return MeasureEndpoint.this.service.setTimingOffset(d2, response);
            }
        }).get(MethodDescriptor.path("/number-of-repetitions").withDescription("Get the number of measurements that will be made for a repeated SPL measurement").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getNumMeasurements());
            }
        }).post(MethodDescriptor.path("/number-of-repetitions").withDescription("Set the number of measurements that will be made for a repeated SPL measurement").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setNumMeasurements(n2, response);
            }
        }).get(MethodDescriptor.path("/start-delay").withDescription("Get the delay in seconds before a measurement starts").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getStartDelay());
            }
        }).post(MethodDescriptor.path("/start-delay").withDescription("Set the delay in seconds before a measurement starts").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setStartDelay(n2, response);
            }
        }).get(MethodDescriptor.path("/between-measurements-delay").withDescription("Get the delay in seconds between repeated measurements").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getInterMeasDelay());
            }
        }).post(MethodDescriptor.path("/between-measurements-delay").withDescription("Set the delay in seconds between repeated measurements").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setInterMeasDelay(n2, response);
            }
        }).get(MethodDescriptor.path("/invert-second-output").withDescription("Get whether to invert the second output for an SPL measurement when two outputs are driven").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getInvertSecondOutput());
            }
        }).post(MethodDescriptor.path("/invert-second-output").withDescription("Set whether to invert the second output for an SPL measurement when two outputs are driven").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setInvertSecondOutput(bl, response);
            }
        }).get(MethodDescriptor.path("/play-dither-before-sweep").withDescription("Get whether to play a period of dither before the sweep starts to ensure the replay path is active").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getPlayDither());
            }
        }).post(MethodDescriptor.path("/play-dither-before-sweep").withDescription("Set whether to play a period of dither before the sweep starts to ensure the replay path is active").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setPlayDither(bl, response);
            }
        }).get(MethodDescriptor.path("/lfe-minus-10-db").withDescription("Get whether to reduce the sweep level by 10 dB when measuring the LFE channel").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getLfeMinus10dB());
            }
        }).post(MethodDescriptor.path("/lfe-minus-10-db").withDescription("Set whether to reduce the sweep level by 10 dB when measuring the LFE channel").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setLfeMinus10dB(bl, response);
            }
        }).get(MethodDescriptor.path("/use-lfe-end-frequency").withDescription("Get whether to use the configured end frequency when measuring the LFE channel").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getUseLfeEndFreq());
            }
        }).post(MethodDescriptor.path("/use-lfe-end-frequency").withDescription("Set whether to use the configured end frequency when measuring the LFE channel").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setUseLfeEndFreq(bl, response);
            }
        }).get(MethodDescriptor.path("/lfe-end-frequency").withDescription("Get the end frequency to use when measuring the LFE channel").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getLfeEndFreq());
            }
        }).post(MethodDescriptor.path("/lfe-end-frequency").withDescription("Set the end frequency to use when measuring the LFE channel").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return MeasureEndpoint.this.service.setLfeEndFreq(n2, response);
            }
        }).get(MethodDescriptor.path("/fill-silence-with-dither").withDescription("Get whether to fill silent parts of the output with 16-bit dither to ensure the replay path is active").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getFillSilenceWithDither());
            }
        }).post(MethodDescriptor.path("/fill-silence-with-dither").withDescription("Set whether to fill silent parts of the output with 16-bit dither").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setFillSilenceWithDither(bl, response);
            }
        }).get(MethodDescriptor.path("/capture-noise-floor").withDescription("Get whether to capture the noise floor before an SPL measurement").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getCaptureNoiseFloor());
            }
        }).post(MethodDescriptor.path("/capture-noise-floor").withDescription("Set whether to capture the noise floor before an SPL measurement").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return MeasureEndpoint.this.service.setCaptureNoiseFloor(bl, response);
            }
        }).post(MethodDescriptor.path("/subscribe").withDescription("Subscribe to measurement progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return MeasureEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.MEASUREMENT_PROGRESS, response);
            }
        }).post(MethodDescriptor.path("/unsubscribe").withDescription("Unsubscribe from measurement progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return MeasureEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.MEASUREMENT_PROGRESS, response);
            }
        }).get(MethodDescriptor.path("/subscribers").withDescription("Get the measurement progress subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, MeasureEndpoint.this.service.getSubscribers(SubscriptionType.MEASUREMENT_PROGRESS));
            }
        });
    }
}

