/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.InputLevelsService;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.InputLevels;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import spark.Request;
import spark.Response;

public class InputLevelsEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/input-levels";
    private final InputLevelsService service = InputLevelsService.getInstance();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("API to monitor levels on the inputs "), null).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, InputLevelsEndpoint.this.service.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a command  ").withRequestType(Command.class).withResponseStatus(200).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return InputLevelsEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/units").withDescription("Get the accepted units ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, InputLevelsService.getAxisUnits());
            }
        }).get(MethodDescriptor.path("/last-levels").withDescription("Get the last input levels update ").withResponseType(InputLevels.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, InputLevelsService.getInputLevels());
            }
        }).post(MethodDescriptor.path("/subscribe").withDescription("Subscribe to input level updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return InputLevelsEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.INPUT_LEVELS, response);
            }
        }).post(MethodDescriptor.path("/unsubscribe").withDescription("Unsubscribe from input level updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return InputLevelsEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.INPUT_LEVELS, response);
            }
        }).get(MethodDescriptor.path("/subscribers").withDescription("Get the input level subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, InputLevelsEndpoint.this.service.getSubscribers(SubscriptionType.INPUT_LEVELS));
            }
        });
    }
}

