/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.ImportService;
import roomeqwizard.api.model.FilePath;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import spark.Request;
import spark.Response;

public class ImportEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/import";
    private final ImportService service = new ImportService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Import API "), null).get(MethodDescriptor.path("/sweep-recordings/stimulus").withDescription("Get the sweep recordings stimulus ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ImportService.getSweepStimulus());
            }
        }).post(MethodDescriptor.path("/sweep-recordings/stimulus").withDescription("Set the sweep recordings stimulus ").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return ImportEndpoint.this.service.setSweepStimulus(string, response);
            }
        }).get(MethodDescriptor.path("/sweep-recordings/response").withDescription("Get the sweep recordings response ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ImportService.getSweepResponse());
            }
        }).post(MethodDescriptor.path("/sweep-recordings/response").withDescription("Set the sweep recordings response ").withRequestType(FilePath.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<FilePath>(){

            @Override
            public Object onRequest(FilePath filePath, Request request, Response response) {
                return ImportEndpoint.this.service.setSweepResponse(filePath, response);
            }
        }).get(MethodDescriptor.path("/frequency-response").withDescription("Get the path of the last frequency response file imported ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ImportEndpoint.this.service.getLastFRFileImported());
            }
        }).post(MethodDescriptor.path("/frequency-response").withDescription("Import a text frequency response file ").withRequestType(FilePath.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<FilePath>(){

            @Override
            public Object onRequest(FilePath filePath, Request request, Response response) {
                return ImportEndpoint.this.service.importFrequencyResponse(filePath, response);
            }
        }).get(MethodDescriptor.path("/impulse-response").withDescription("Get the path of the last impulse response file imported ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ImportEndpoint.this.service.getLastIRFileImported());
            }
        }).post(MethodDescriptor.path("/impulse-response").withDescription("Import an impulse response file ").withRequestType(FilePath.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<FilePath>(){

            @Override
            public Object onRequest(FilePath filePath, Request request, Response response) {
                return ImportEndpoint.this.service.importImpulseResponse(filePath, response);
            }
        }).post(MethodDescriptor.path("/subscribe").withDescription("Subscribe to import updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ImportEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.IMPORT, response);
            }
        }).post(MethodDescriptor.path("/unsubscribe").withDescription("Unsubscribe from import updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ImportEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.IMPORT, response);
            }
        }).get(MethodDescriptor.path("/subscribers").withDescription("Get the import subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ImportEndpoint.this.service.getSubscribers(SubscriptionType.IMPORT));
            }
        });
    }
}

