/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import java.util.Map;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.GeneratorService;
import roomeqwizard.api.model.CEABurstConfiguration;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.GeneratorStatus;
import roomeqwizard.api.model.LinearSweepConfiguration;
import roomeqwizard.api.model.LogSweepConfiguration;
import roomeqwizard.api.model.MeasSweepConfiguration;
import roomeqwizard.api.model.MultitoneConfiguration;
import roomeqwizard.api.model.MultitoneDetails;
import roomeqwizard.api.model.PeriodicNoiseConfiguration;
import roomeqwizard.api.model.Protections;
import roomeqwizard.api.model.RandomNoiseConfiguration;
import roomeqwizard.api.model.SawtoothConfiguration;
import roomeqwizard.api.model.Signal;
import roomeqwizard.api.model.SineConfiguration;
import roomeqwizard.api.model.SineDistortion;
import roomeqwizard.api.model.SquareConfiguration;
import roomeqwizard.api.model.ThreeToneConfiguration;
import roomeqwizard.api.model.ToneBurstConfiguration;
import roomeqwizard.api.model.TwoToneConfiguration;
import roomeqwizard.api.model.Value;
import spark.Request;
import spark.Response;

public class GeneratorEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/generator";
    private final GeneratorService service = new GeneratorService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Signal generator endpoints exposing all signals and controls "), null).get(MethodDescriptor.path("/status").withDescription("Get the current status of the generator ").withResponseType(GeneratorStatus.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getStatus());
            }
        }).get(MethodDescriptor.path("/commands").withDescription("Get the commands the generator accepts ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a command to the generator ").withRequestType(Command.class).withResponseStatus(200, 202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return GeneratorEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/level").withDescription("Get the generator output level ").withResponseType(Value.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getLevel());
            }
        }).get(MethodDescriptor.path("/level/units").withDescription("Get the accepted units for the generator output level ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getLevelUnits());
            }
        }).post(MethodDescriptor.path("/level").withDescription("Set the generator output level").withRequestType(Value.class).withResponseType(APIResponse.class), new TypedRoute<Value>(){

            @Override
            public Object onRequest(Value value, Request request, Response response) {
                return GeneratorEndpoint.this.service.setLevel(value, response);
            }
        }).get(MethodDescriptor.path("/frequency").withDescription("Get the generator frequency").withResponseType(Value.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getFrequency());
            }
        }).post(MethodDescriptor.path("/frequency").withDescription("Set the generator frequency").withRequestType(Value.class).withResponseType(APIResponse.class), new TypedRoute<Value>(){

            @Override
            public Object onRequest(Value value, Request request, Response response) {
                return GeneratorEndpoint.this.service.setFrequency(value, response);
            }
        }).get(MethodDescriptor.path("/protection").withDescription("Get the protection settings that stop the generator if the input signal breaches limits ").withResponseType(Protections.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getGeneratorProtection());
            }
        }).post(MethodDescriptor.path("/protection").withDescription("Configure the protection settings ").withRequestType(Protections.class).withResponseType(APIResponse.class), new TypedRoute<Protections>(){

            @Override
            public Object onRequest(Protections protections, Request request, Response response) {
                return GeneratorEndpoint.this.service.setGeneratorProtection(protections, response);
            }
        }).put(MethodDescriptor.path("/protection").withDescription("Configure some protection settings ").withRequestType(Protections.class).withResponseType(APIResponse.class), new TypedRoute<Protections>(){

            @Override
            public Object onRequest(Protections protections, Request request, Response response) {
                return GeneratorEndpoint.this.service.setGeneratorProtection(protections, response);
            }
        }).get(MethodDescriptor.path("/signal").withDescription("Get the generator signal ").withResponseType(Signal.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getSignal());
            }
        }).post(MethodDescriptor.path("/signal").withDescription("Select the generator signal ").withRequestType(Signal.class).withResponseType(APIResponse.class), new TypedRoute<Signal>(){

            @Override
            public Object onRequest(Signal signal, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSignal(signal, response);
            }
        }).get(MethodDescriptor.path("/signal/configuration").withDescription("Get the configuration options for the current signal ").withResponseType(Object.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                Object object = GeneratorEndpoint.this.service.getCurrentSignalConfiguration();
                if (object != null) {
                    return APIResponse.ok(response, object);
                }
                return APIResponse.notImplemented(response);
            }
        }).post(MethodDescriptor.path("/signal/configuration").withDescription("Configure the signal ").withRequestType(Map.class).withResponseType(APIResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return GeneratorEndpoint.this.service.setConfiguration(request, response);
            }
        }).put(MethodDescriptor.path("/signal/configuration").withDescription("Configure some settings of the signal ").withRequestType(Map.class).withResponseType(APIResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return GeneratorEndpoint.this.service.setConfiguration(request, response);
            }
        }).get(MethodDescriptor.path("/signal/commands").withDescription("Get the commands the current signal accepts ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getCurrentSignalCommands());
            }
        }).post(MethodDescriptor.path("/signal/command").withDescription("Send a command to the current signal ").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return GeneratorEndpoint.this.service.runSignalCommand(command, response);
            }
        }).get(MethodDescriptor.path("/signals").withDescription("Get the generator signal choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSignals());
            }
        }).get(MethodDescriptor.path("/signals/pinknoise/configuration").withDescription("Get the configuration options for the pink noise signal ").withResponseType(RandomNoiseConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getPinkNoiseConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/pinknoise/configuration").withDescription("Configure the pink noise signal ").withRequestType(RandomNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RandomNoiseConfiguration>(){

            @Override
            public Object onRequest(RandomNoiseConfiguration randomNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setPinkNoiseConfiguration(randomNoiseConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/pinknoise/configuration").withDescription("Configure some settings of the pink noise signal ").withRequestType(RandomNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RandomNoiseConfiguration>(){

            @Override
            public Object onRequest(RandomNoiseConfiguration randomNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setPinkNoiseConfiguration(randomNoiseConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/pinkpn/configuration").withDescription("Get the configuration options for the pink periodic noise signal ").withResponseType(PeriodicNoiseConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getPinkPNConfiguration());
            }
        }).get(MethodDescriptor.path("/signals/pinknoise/configuration/types").withDescription("Get the noise type configuration options for the pink noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getPinkTypes());
            }
        }).post(MethodDescriptor.path("/signals/pinkpn/configuration").withDescription("Configure the pink periodic noise signal ").withRequestType(PeriodicNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<PeriodicNoiseConfiguration>(){

            @Override
            public Object onRequest(PeriodicNoiseConfiguration periodicNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setPinkPNConfiguration(periodicNoiseConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/pinkpn/configuration").withDescription("Configure some settings of the pink periodic noise signal ").withRequestType(PeriodicNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<PeriodicNoiseConfiguration>(){

            @Override
            public Object onRequest(PeriodicNoiseConfiguration periodicNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setPinkPNConfiguration(periodicNoiseConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/pinkpn/configuration/types").withDescription("Get the noise type configuration options for the pink periodic noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getPinkTypes());
            }
        }).get(MethodDescriptor.path("/signals/pinkpn/configuration/sequence-lengths").withDescription("Get the sequence length configuration options for the pink periodic noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSequenceLengths());
            }
        }).get(MethodDescriptor.path("/signals/whitenoise/configuration").withDescription("Get the configuration options for the white noise signal ").withResponseType(RandomNoiseConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getWhiteNoiseConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/whitenoise/configuration").withDescription("Configure the white noise signal ").withRequestType(RandomNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RandomNoiseConfiguration>(){

            @Override
            public Object onRequest(RandomNoiseConfiguration randomNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setWhiteNoiseConfiguration(randomNoiseConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/whitenoise/configuration").withDescription("Configure some settings of the white noise signal ").withRequestType(RandomNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<RandomNoiseConfiguration>(){

            @Override
            public Object onRequest(RandomNoiseConfiguration randomNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setWhiteNoiseConfiguration(randomNoiseConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/whitenoise/configuration/types").withDescription("Get the noise type configuration options for the white noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getWhiteTypes());
            }
        }).get(MethodDescriptor.path("/signals/whitepn/configuration").withDescription("Get the configuration options for the white periodic noise signal ").withResponseType(PeriodicNoiseConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getWhitePNConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/whitepn/configuration").withDescription("Configure the white periodic noise signal ").withRequestType(PeriodicNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<PeriodicNoiseConfiguration>(){

            @Override
            public Object onRequest(PeriodicNoiseConfiguration periodicNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setWhitePNConfiguration(periodicNoiseConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/whitepn/configuration").withDescription("Configure some settings of the white periodic noise signal ").withRequestType(PeriodicNoiseConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<PeriodicNoiseConfiguration>(){

            @Override
            public Object onRequest(PeriodicNoiseConfiguration periodicNoiseConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setWhitePNConfiguration(periodicNoiseConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/whitepn/configuration/types").withDescription("Get the noise type configuration options for the white periodic noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getWhiteTypes());
            }
        }).get(MethodDescriptor.path("/signals/whitepn/configuration/sequence-lengths").withDescription("Get the sequence length configuration options for the white periodic noise signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSequenceLengths());
            }
        }).get(MethodDescriptor.path("/signals/sine/configuration").withDescription("Get the configuration options for the sine signal ").withResponseType(SineConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getSineConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/sine/configuration").withDescription("Configure the sine signal ").withRequestType(SineConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SineConfiguration>(){

            @Override
            public Object onRequest(SineConfiguration sineConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSineConfiguration(sineConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/sine/configuration").withDescription("Configure some settings of the sine signal ").withRequestType(SineConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SineConfiguration>(){

            @Override
            public Object onRequest(SineConfiguration sineConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSineConfiguration(sineConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/sine/distortion").withDescription("Get the harmonic distortion settings options for the sine signal ").withResponseType(SineDistortion.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getSineDistortion());
            }
        }).post(MethodDescriptor.path("/signals/sine/distortion").withDescription("Set the harmonic distortion levels for the sine signal ").withRequestType(SineDistortion.class).withResponseType(APIResponse.class), new TypedRoute<SineDistortion>(){

            @Override
            public Object onRequest(SineDistortion sineDistortion, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSineDistortion(sineDistortion, response);
            }
        }).put(MethodDescriptor.path("/signals/sine/distortion").withDescription("Set some harmonic distortion levels for the sine signal ").withRequestType(SineDistortion.class).withResponseType(APIResponse.class), new TypedRoute<SineDistortion>(){

            @Override
            public Object onRequest(SineDistortion sineDistortion, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSineDistortion(sineDistortion, response);
            }
        }).get(MethodDescriptor.path("/signals/square/configuration").withDescription("Get the configuration options for the square signal ").withResponseType(SquareConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getSquareConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/square/configuration").withDescription("Configure the square signal ").withRequestType(SquareConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SquareConfiguration>(){

            @Override
            public Object onRequest(SquareConfiguration squareConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSquareConfiguration(squareConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/square/configuration").withDescription("Configure some settings of the square signal ").withRequestType(SquareConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SquareConfiguration>(){

            @Override
            public Object onRequest(SquareConfiguration squareConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSquareConfiguration(squareConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/sawtooth/configuration").withDescription("Get the configuration options for the sawtooth signal ").withResponseType(SawtoothConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getSawtoothConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/sawtooth/configuration").withDescription("Configure the sawtooth signal ").withRequestType(SawtoothConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SawtoothConfiguration>(){

            @Override
            public Object onRequest(SawtoothConfiguration sawtoothConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSawtoothConfiguration(sawtoothConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/sawtooth/configuration").withDescription("Configure some settings of the sawtooth signal ").withRequestType(SawtoothConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<SawtoothConfiguration>(){

            @Override
            public Object onRequest(SawtoothConfiguration sawtoothConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setSawtoothConfiguration(sawtoothConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/toneburst/configuration").withDescription("Get the configuration options for the toneburst signal ").withResponseType(ToneBurstConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getToneBurstConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/toneburst/configuration").withDescription("Configure the toneburst signal ").withRequestType(ToneBurstConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<ToneBurstConfiguration>(){

            @Override
            public Object onRequest(ToneBurstConfiguration toneBurstConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setToneBurstConfiguration(toneBurstConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/toneburst/configuration").withDescription("Configure some settings of the toneburst signal ").withRequestType(ToneBurstConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<ToneBurstConfiguration>(){

            @Override
            public Object onRequest(ToneBurstConfiguration toneBurstConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setToneBurstConfiguration(toneBurstConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/cea-burst/configuration").withDescription("Get the configuration options for the cea-burst signal ").withResponseType(CEABurstConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getCEABurstConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/cea-burst/configuration").withDescription("Configure the CEA2010 burst signal ").withRequestType(CEABurstConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<CEABurstConfiguration>(){

            @Override
            public Object onRequest(CEABurstConfiguration cEABurstConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setCEABurstConfiguration(cEABurstConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/cea-burst/configuration").withDescription("Configure some settings of the CEA2010 burst signal ").withRequestType(CEABurstConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<CEABurstConfiguration>(){

            @Override
            public Object onRequest(CEABurstConfiguration cEABurstConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setCEABurstConfiguration(cEABurstConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/dualtone/configuration").withDescription("Get the configuration options for the dual tone signal ").withResponseType(TwoToneConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getTwoToneConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/dualtone/configuration").withDescription("Configure the dual tone signal ").withRequestType(TwoToneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<TwoToneConfiguration>(){

            @Override
            public Object onRequest(TwoToneConfiguration twoToneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setTwoToneConfiguration(twoToneConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/dualtone/configuration").withDescription("Configure some settings of the dual tone signal ").withRequestType(TwoToneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<TwoToneConfiguration>(){

            @Override
            public Object onRequest(TwoToneConfiguration twoToneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setTwoToneConfiguration(twoToneConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/dualtone/configuration/types").withDescription("Get the type configuration options for the dual tone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getTwoToneTypes());
            }
        }).get(MethodDescriptor.path("/signals/tripletone/configuration").withDescription("Get the configuration options for the triple tone signal ").withResponseType(ThreeToneConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getThreeToneConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/tripletone/configuration").withDescription("Configure the triple tone signal ").withRequestType(ThreeToneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<ThreeToneConfiguration>(){

            @Override
            public Object onRequest(ThreeToneConfiguration threeToneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setThreeToneConfiguration(threeToneConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/tripletone/configuration").withDescription("Configure some settings of the triple tone signal ").withRequestType(ThreeToneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<ThreeToneConfiguration>(){

            @Override
            public Object onRequest(ThreeToneConfiguration threeToneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setThreeToneConfiguration(threeToneConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/tripletone/configuration/types").withDescription("Get the type configuration options for the triple tone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getThreeToneTypes());
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration").withDescription("Get the configuration options for the multitone signal ").withResponseType(MultitoneConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getMultitoneConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/multitone/configuration").withDescription("Configure the multitone signal ").withRequestType(MultitoneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MultitoneConfiguration>(){

            @Override
            public Object onRequest(MultitoneConfiguration multitoneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setMultitoneConfiguration(multitoneConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/multitone/configuration").withDescription("Configure some settings of the multitone signal ").withRequestType(MultitoneConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MultitoneConfiguration>(){

            @Override
            public Object onRequest(MultitoneConfiguration multitoneConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setMultitoneConfiguration(multitoneConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration/sequence-lengths").withDescription("Get the sequence length configuration options for the multitone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getMultitoneLengths());
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration/spectrum-types").withDescription("Get the spectrum configuration options for the multitone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSpectrumTypes());
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration/spacing-types").withDescription("Get the spacing configuration options for the multitone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getMultitoneSpacings());
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration/octave-spacings").withDescription("Get the octave fraction spacing configuration options for the multitone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getOctaveFractions());
            }
        }).get(MethodDescriptor.path("/signals/multitone/configuration/decade-spacings").withDescription("Get the decade fraction spacing configuration options for the multitone signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getDecadeFractions());
            }
        }).get(MethodDescriptor.path("/signals/multitone/details").withDescription("Get the details for the generated multitone signal ").withResponseType(MultitoneDetails.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getMultitoneDetails());
            }
        }).get(MethodDescriptor.path("/signals/linearsweep/configuration").withDescription("Get the configuration options for the linear sweep signal ").withResponseType(LinearSweepConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getLinearSweepConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/linearsweep/configuration").withDescription("Configure the linear sweep signal ").withRequestType(LinearSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<LinearSweepConfiguration>(){

            @Override
            public Object onRequest(LinearSweepConfiguration linearSweepConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setLinearSweepConfiguration(linearSweepConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/linearsweep/configuration").withDescription("Configure some settings of the linear sweep signal ").withRequestType(LinearSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<LinearSweepConfiguration>(){

            @Override
            public Object onRequest(LinearSweepConfiguration linearSweepConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setLinearSweepConfiguration(linearSweepConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/logsweep/configuration").withDescription("Get the configuration options for the log sweep signal ").withResponseType(LogSweepConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getLogSweepConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/logsweep/configuration").withDescription("Configure the log sweep signal ").withRequestType(LogSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<LogSweepConfiguration>(){

            @Override
            public Object onRequest(LogSweepConfiguration logSweepConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setLogSweepConfiguration(logSweepConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/logsweep/configuration").withDescription("Configure some settings of the log sweep signal ").withRequestType(LogSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<LogSweepConfiguration>(){

            @Override
            public Object onRequest(LogSweepConfiguration logSweepConfiguration, Request request, Response response) {
                return GeneratorEndpoint.this.service.setLogSweepConfiguration(logSweepConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/logsweep/configuration/fade-fractions").withDescription("Get the fade fraction configuration options for the log sweep signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getFadeFractions());
            }
        }).get(MethodDescriptor.path("/signals/meassweep/configuration").withDescription("Get the configuration options for the meas sweep signal ").withResponseType(MeasSweepConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getMeasSweepConfiguration());
            }
        }).post(MethodDescriptor.path("/signals/meassweep/configuration").withDescription("Configure the meas sweep signal ").withRequestType(MeasSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MeasSweepConfiguration>(){

            @Override
            public Object onRequest(MeasSweepConfiguration measSweepConfiguration, Request request, Response response) {
                return GeneratorService.setMeasSweepConfiguration(measSweepConfiguration, response);
            }
        }).put(MethodDescriptor.path("/signals/meassweep/configuration").withDescription("Configure some settings of the meas sweep signal ").withRequestType(MeasSweepConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<MeasSweepConfiguration>(){

            @Override
            public Object onRequest(MeasSweepConfiguration measSweepConfiguration, Request request, Response response) {
                return GeneratorService.setMeasSweepConfiguration(measSweepConfiguration, response);
            }
        }).get(MethodDescriptor.path("/signals/meassweep/configuration/sweep-lengths").withDescription("Get the sweep length configuration options for the meas sweep signal ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorService.getSweepLengths());
            }
        }).get(MethodDescriptor.path("/invert-second-output").withDescription("Get whether to invert the second output when two outputs are driven").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, GeneratorEndpoint.this.service.getInvertSecondOutput());
            }
        }).post(MethodDescriptor.path("/invert-second-output").withDescription("Set whether to invert the second output when two outputs are driven").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return GeneratorEndpoint.this.service.setInvertSecondOutput(bl, response);
            }
        });
    }
}

