/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import java.util.List;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.EQService;
import roomeqwizard.api.model.EqualiserEntry;
import roomeqwizard.api.model.MatchTargetSettings;
import roomeqwizard.api.model.RoomCurveSettings;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.TargetSettings;
import spark.Request;
import spark.Response;

public class EQEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/eq";
    private final EQService service = new EQService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("EQ API exposing EQ defaults and settings "), null).get(MethodDescriptor.path("/equalisers").withDescription("Get the list of equalisers ").withQueryParam().withName(EQService.getManufacturerKey()).withDescription("Optionally specify the manufacturer e.g. ?manufacturer=\"miniDSP\", if not specified results for all manufacturers are returned").and().withResponseAsCollection(EqualiserEntry.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                List<EqualiserEntry> list = EQService.getEqualisers(request, response);
                if (list.isEmpty()) {
                    return APIResponse.badRequest(response, "No results for manufacturer " + request.queryParamOrDefault(EQService.getManufacturerKey(), ""));
                }
                return APIResponse.ok(response, list);
            }
        }).get(MethodDescriptor.path("/manufacturers").withDescription("Get the list of equaliser manufacturers ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getManufacturers());
            }
        }).get(MethodDescriptor.path("/target-shapes").withDescription("Get the list of target shapes ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getTargetShapes());
            }
        }).get(MethodDescriptor.path("/crossover-types").withDescription("Get the list of crossover types ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getCrossoverTypes());
            }
        }).get(MethodDescriptor.path("/slopes").withDescription("Get the list of dB per octave slopes ").withResponseAsCollection(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getSlopes());
            }
        }).get(MethodDescriptor.path("/default-equaliser").withDescription("Get the default equaliser for new measurements ").withResponseType(EqualiserEntry.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getDefaultEqualiser());
            }
        }).post(MethodDescriptor.path("/default-equaliser").withDescription("Set the default equaliser for new measurements ").withRequestType(EqualiserEntry.class).withResponseType(APIResponse.class), new TypedRoute<EqualiserEntry>(){

            @Override
            public Object onRequest(EqualiserEntry equaliserEntry, Request request, Response response) {
                return EQService.setDefaultEqualiser(equaliserEntry, response);
            }
        }).get(MethodDescriptor.path("/default-target-settings").withDescription("Get the default target settings for new measurements ").withResponseType(TargetSettings.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getDefaultTargetSettings());
            }
        }).post(MethodDescriptor.path("/default-target-settings").withDescription("Set the default target settings for new measurements ").withRequestType(TargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<TargetSettings>(){

            @Override
            public Object onRequest(TargetSettings targetSettings, Request request, Response response) {
                return EQService.setDefaultTargetSettings(targetSettings, response);
            }
        }).put(MethodDescriptor.path("/default-target-settings").withDescription("Set some default target settings for new measurements ").withRequestType(TargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<TargetSettings>(){

            @Override
            public Object onRequest(TargetSettings targetSettings, Request request, Response response) {
                return EQService.setDefaultTargetSettings(targetSettings, response);
            }
        }).get(MethodDescriptor.path("/default-target-level").withDescription("Get the default target level in dB SPL for new measurements ").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQEndpoint.this.service.getTargetLevel());
            }
        }).post(MethodDescriptor.path("/default-target-level").withDescription("Set the default target levekl in dB SPL for new measurements ").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return EQEndpoint.this.service.setTargetLevel(d2, response);
            }
        }).get(MethodDescriptor.path("/default-room-curve-settings").withDescription("Get the default room curve settings for new measurements ").withResponseType(RoomCurveSettings.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getDefaultRoomCurveSettings());
            }
        }).post(MethodDescriptor.path("/default-room-curve-settings").withDescription("Set the default room curve settings for new measurements ").withRequestType(RoomCurveSettings.class).withResponseType(APIResponse.class), new TypedRoute<RoomCurveSettings>(){

            @Override
            public Object onRequest(RoomCurveSettings roomCurveSettings, Request request, Response response) {
                return EQService.setDefaultRoomCurveSettings(roomCurveSettings, response);
            }
        }).put(MethodDescriptor.path("/default-room-curve-settings").withDescription("Set some default room curve settings for new measurements ").withRequestType(RoomCurveSettings.class).withResponseType(APIResponse.class), new TypedRoute<RoomCurveSettings>(){

            @Override
            public Object onRequest(RoomCurveSettings roomCurveSettings, Request request, Response response) {
                return EQService.setDefaultRoomCurveSettings(roomCurveSettings, response);
            }
        }).get(MethodDescriptor.path("/match-target-settings").withDescription("Get the match target settings ").withResponseType(MatchTargetSettings.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQService.getMatchTargetSettings());
            }
        }).post(MethodDescriptor.path("/match-target-settings").withDescription("Set the match target settings ").withRequestType(MatchTargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<MatchTargetSettings>(){

            @Override
            public Object onRequest(MatchTargetSettings matchTargetSettings, Request request, Response response) {
                return EQService.setMatchTargetSettings(matchTargetSettings, response);
            }
        }).get(MethodDescriptor.path("/house-curve").withDescription("Get the house curve file path ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQEndpoint.this.service.getHouseCurvePath());
            }
        }).post(MethodDescriptor.path("/house-curve").withDescription("Set the house curve file path ").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return EQEndpoint.this.service.setHouseCurvePath(string, response);
            }
        }).delete(MethodDescriptor.path("house-curve").withDescription("Delete the house curve file path ").withResponseType(APIResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return EQEndpoint.this.service.clearHouseCurvePath(response);
            }
        }).put(MethodDescriptor.path("/match-target-settings").withDescription("Set some match target settings ").withRequestType(MatchTargetSettings.class).withResponseType(APIResponse.class), new TypedRoute<MatchTargetSettings>(){

            @Override
            public Object onRequest(MatchTargetSettings matchTargetSettings, Request request, Response response) {
                return EQService.setMatchTargetSettings(matchTargetSettings, response);
            }
        }).post(MethodDescriptor.path("/subscribe").withDescription("Subscribe to EQ progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return EQEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.EQ_PROGRESS, response);
            }
        }).post(MethodDescriptor.path("/unsubscribe").withDescription("Unsubscribe from EQ progress updates").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return EQEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.EQ_PROGRESS, response);
            }
        }).get(MethodDescriptor.path("/subscribers").withDescription("Get the EQ progress subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, EQEndpoint.this.service.getSubscribers(SubscriptionType.EQ_PROGRESS));
            }
        });
    }
}

