/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.AudioService;
import roomeqwizard.api.model.AudioConfiguration;
import roomeqwizard.api.model.AudioStatus;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.Device;
import roomeqwizard.api.model.Driver;
import roomeqwizard.api.model.Enable;
import roomeqwizard.api.model.Input;
import roomeqwizard.api.model.InputCalConfiguration;
import roomeqwizard.api.model.InputChannel;
import roomeqwizard.api.model.InputOptions;
import roomeqwizard.api.model.Output;
import roomeqwizard.api.model.OutputCalConfiguration;
import roomeqwizard.api.model.OutputChannel;
import roomeqwizard.api.model.OutputChannelMappingList;
import roomeqwizard.api.model.OutputOptions;
import roomeqwizard.api.model.Value;
import spark.Request;
import spark.Response;

public class AudioEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/audio";
    private final AudioService service = new AudioService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("Audio I/O "), null).get(MethodDescriptor.path("/status").withDescription("Get the audio I/O status ").withResponseType(AudioStatus.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getStatus());
            }
        }).get(MethodDescriptor.path("/configuration").withDescription("Get the audio configuration settings ").withResponseType(AudioConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getAudioConfiguration());
            }
        }).post(MethodDescriptor.path("/configuration").withDescription("Set the audio configuration options ").withRequestType(AudioConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<AudioConfiguration>(){

            @Override
            public Object onRequest(AudioConfiguration audioConfiguration, Request request, Response response) {
                return AudioEndpoint.this.service.setAudioConfiguration(audioConfiguration, response);
            }
        }).put(MethodDescriptor.path("/configuration").withDescription("Set some audio configuration options ").withRequestType(AudioConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<AudioConfiguration>(){

            @Override
            public Object onRequest(AudioConfiguration audioConfiguration, Request request, Response response) {
                return AudioEndpoint.this.service.setAudioConfiguration(audioConfiguration, response);
            }
        }).get(MethodDescriptor.path("/driver").withDescription("Get the driver type ").withResponseType(Driver.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getDriver());
            }
        }).post(MethodDescriptor.path("/driver").withDescription("Set the driver type").withRequestType(Driver.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Driver>(){

            @Override
            public Object onRequest(Driver driver, Request request, Response response) {
                return AudioEndpoint.this.service.setDriver(driver, response);
            }
        }).get(MethodDescriptor.path("/driver-types").withDescription("Get the driver type choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getDriverTypes());
            }
        }).get(MethodDescriptor.path("/input-cal").withDescription("Get the input calibration configuration ").withResponseType(InputCalConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputCalConfiguration());
            }
        }).put(MethodDescriptor.path("/input-cal").withDescription("Set some input calibration configuration settings ").withRequestType(InputCalConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<InputCalConfiguration>(){

            @Override
            public Object onRequest(InputCalConfiguration inputCalConfiguration, Request request, Response response) {
                return AudioEndpoint.this.service.setInputCalConfiguration(inputCalConfiguration, response);
            }
        }).get(MethodDescriptor.path("/output-cal").withDescription("Get the output calibration configuration ").withResponseType(OutputCalConfiguration.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputCalConfiguration());
            }
        }).put(MethodDescriptor.path("/output-cal").withDescription("Set some output calibration configuration settings ").withRequestType(OutputCalConfiguration.class).withResponseType(APIResponse.class), new TypedRoute<OutputCalConfiguration>(){

            @Override
            public Object onRequest(OutputCalConfiguration outputCalConfiguration, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputCalConfiguration(outputCalConfiguration, response);
            }
        }).get(MethodDescriptor.path("/input-options").withDescription("Get the audio input options ").withResponseType(InputOptions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputOptions());
            }
        }).post(MethodDescriptor.path("/input-options").withDescription("Set the audio input options ").withRequestType(InputOptions.class).withResponseType(APIResponse.class), new TypedRoute<InputOptions>(){

            @Override
            public Object onRequest(InputOptions inputOptions, Request request, Response response) {
                return AudioEndpoint.this.service.setInputOptions(inputOptions, response);
            }
        }).put(MethodDescriptor.path("/input-options").withDescription("Set some audio input options ").withRequestType(InputOptions.class).withResponseType(APIResponse.class), new TypedRoute<InputOptions>(){

            @Override
            public Object onRequest(InputOptions inputOptions, Request request, Response response) {
                return AudioEndpoint.this.service.setInputOptions(inputOptions, response);
            }
        }).get(MethodDescriptor.path("/output-options").withDescription("Get the audio output options ").withResponseType(OutputOptions.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputOptions());
            }
        }).post(MethodDescriptor.path("/output-options").withDescription("Set the audio output options ").withRequestType(OutputOptions.class).withResponseType(APIResponse.class), new TypedRoute<OutputOptions>(){

            @Override
            public Object onRequest(OutputOptions outputOptions, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputOptions(outputOptions, response);
            }
        }).put(MethodDescriptor.path("/output-options").withDescription("Set some audio output options ").withRequestType(OutputOptions.class).withResponseType(APIResponse.class), new TypedRoute<OutputOptions>(){

            @Override
            public Object onRequest(OutputOptions outputOptions, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputOptions(outputOptions, response);
            }
        }).get(MethodDescriptor.path("/samplerate").withDescription("Get the sample rate ").withResponseType(Value.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getSampleRate());
            }
        }).post(MethodDescriptor.path("/samplerate").withDescription("Set the sample rate").withRequestType(Value.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Value>(){

            @Override
            public Object onRequest(Value value, Request request, Response response) {
                return AudioEndpoint.this.service.setSampleRate(value, response);
            }
        }).get(MethodDescriptor.path("/samplerates").withDescription("Get the sample rate choices ").withResponseAsCollection(Value.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getSampleRateValues());
            }
        }).get(MethodDescriptor.path("/asio/commands").withDescription("Get the ASIO commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioService.getASIOCommands());
            }
        }).post(MethodDescriptor.path("/asio/command").withDescription("Send an ASIO command  ").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return AudioEndpoint.this.service.runASIOCommand(command, response);
            }
        }).get(MethodDescriptor.path("/asio/device").withDescription("Get the ASIO device").withResponseType(Device.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIODevice());
            }
        }).post(MethodDescriptor.path("/asio/device").withDescription("Set the ASIO device").withRequestType(Device.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Device>(){

            @Override
            public Object onRequest(Device device, Request request, Response response) {
                return AudioEndpoint.this.service.setASIODevice(device, response);
            }
        }).get(MethodDescriptor.path("/asio/devices").withDescription("Get the ASIO device choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIODevices());
            }
        }).get(MethodDescriptor.path("/asio/input").withDescription("Get the input").withResponseType(Input.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOInput());
            }
        }).post(MethodDescriptor.path("/asio/input").withDescription("Set the input").withRequestType(Input.class).withResponseType(APIResponse.class), new TypedRoute<Input>(){

            @Override
            public Object onRequest(Input input, Request request, Response response) {
                return AudioEndpoint.this.service.setASIOInput(input, response);
            }
        }).get(MethodDescriptor.path("/asio/inputs").withDescription("Get the input choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOInputs());
            }
        }).get(MethodDescriptor.path("/asio/ref-input").withDescription("Get the ref input").withResponseType(Input.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIORefInput());
            }
        }).post(MethodDescriptor.path("/asio/ref-input").withDescription("Set the ref input").withRequestType(Input.class).withResponseType(APIResponse.class), new TypedRoute<Input>(){

            @Override
            public Object onRequest(Input input, Request request, Response response) {
                return AudioEndpoint.this.service.setASIORefInput(input, response);
            }
        }).get(MethodDescriptor.path("/asio/last-input").withDescription("Get the last input of the multi-input set").withResponseType(Input.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOLastInput());
            }
        }).post(MethodDescriptor.path("/asio/last-input").withDescription("Set the last input of the multi-input set").withRequestType(Input.class).withResponseType(APIResponse.class), new TypedRoute<Input>(){

            @Override
            public Object onRequest(Input input, Request request, Response response) {
                return AudioEndpoint.this.service.setASIOLastInput(input, response);
            }
        }).get(MethodDescriptor.path("/asio/output").withDescription("Get the output").withResponseType(Output.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOOutput());
            }
        }).post(MethodDescriptor.path("/asio/output").withDescription("Set the output").withRequestType(Output.class).withResponseType(APIResponse.class), new TypedRoute<Output>(){

            @Override
            public Object onRequest(Output output, Request request, Response response) {
                return AudioEndpoint.this.service.setASIOOutput(output, response);
            }
        }).get(MethodDescriptor.path("/asio/outputs").withDescription("Get the output choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOOutputs());
            }
        }).get(MethodDescriptor.path("/asio/ref-output").withDescription("Get the ref output").withResponseType(Output.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIORefOutput());
            }
        }).post(MethodDescriptor.path("/asio/ref-output").withDescription("Set the ref output").withRequestType(Output.class).withResponseType(APIResponse.class), new TypedRoute<Output>(){

            @Override
            public Object onRequest(Output output, Request request, Response response) {
                return AudioEndpoint.this.service.setASIORefOutput(output, response);
            }
        }).get(MethodDescriptor.path("/asio/secondary-output").withDescription("Get the secondary output ").withResponseType(Output.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getASIOSecondaryOutput());
            }
        }).post(MethodDescriptor.path("/asio/secondary-output").withDescription("Set the secondary output ").withRequestType(Output.class).withResponseType(APIResponse.class), new TypedRoute<Output>(){

            @Override
            public Object onRequest(Output output, Request request, Response response) {
                return AudioEndpoint.this.service.setASIOSecondaryOutput(output, response);
            }
        }).get(MethodDescriptor.path("/asio/secondary-output-enable").withDescription("Get the secondary output enable setting").withResponseType(Enable.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getSecondaryOutputEnable());
            }
        }).post(MethodDescriptor.path("/asio/secondary-output-enable").withDescription("Set secondary output enable").withRequestType(Enable.class).withResponseType(APIResponse.class), new TypedRoute<Enable>(){

            @Override
            public Object onRequest(Enable enable, Request request, Response response) {
                return AudioEndpoint.this.service.setSecondaryOutputEnable(enable, response);
            }
        }).get(MethodDescriptor.path("/java/stereo-only").withDescription("Get the stereo only enable setting").withResponseType(Enable.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getStereoOnly());
            }
        }).post(MethodDescriptor.path("/java/stereo-only").withDescription("Set stereo only enable").withRequestType(Enable.class).withResponseType(APIResponse.class), new TypedRoute<Enable>(){

            @Override
            public Object onRequest(Enable enable, Request request, Response response) {
                return AudioEndpoint.this.service.setStereoOnly(enable, response);
            }
        }).get(MethodDescriptor.path("/java/input-device").withDescription("Get the input device").withResponseType(Device.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputDevice());
            }
        }).post(MethodDescriptor.path("/java/input-device").withDescription("Set the input device").withRequestType(Device.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Device>(){

            @Override
            public Object onRequest(Device device, Request request, Response response) {
                return AudioEndpoint.this.service.setInputDevice(device, response);
            }
        }).get(MethodDescriptor.path("/java/input-devices").withDescription("Get the input device choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputDevices());
            }
        }).get(MethodDescriptor.path("/java/num-input-device-channels").withDescription("Get the number of hardware channels the input device has").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioService.getNumInputDeviceChannels());
            }
        }).get(MethodDescriptor.path("/java/output-device").withDescription("Get the output device").withResponseType(Device.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputDevice());
            }
        }).post(MethodDescriptor.path("/java/output-device").withDescription("Set the output device").withRequestType(Device.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Device>(){

            @Override
            public Object onRequest(Device device, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputDevice(device, response);
            }
        }).get(MethodDescriptor.path("/java/output-devices").withDescription("Get the output device choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputDevices());
            }
        }).get(MethodDescriptor.path("/java/num-output-device-channels").withDescription("Get the number of hardware channels the output device has").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioService.getNumOutputDeviceChannels());
            }
        }).get(MethodDescriptor.path("/java/output-channel-mapping").withDescription("Get the output channel mapping").withResponseType(OutputChannelMappingList.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputChannelMapping());
            }
        }).post(MethodDescriptor.path("/java/output-channel-mapping").withDescription("Set the output channel mapping").withRequestType(OutputChannelMappingList.class).withResponseType(APIResponse.class), new TypedRoute<OutputChannelMappingList>(){

            @Override
            public Object onRequest(OutputChannelMappingList outputChannelMappingList, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputChannelMapping(outputChannelMappingList, response);
            }
        }).get(MethodDescriptor.path("/java/input").withDescription("Get the input").withResponseType(Input.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInput());
            }
        }).post(MethodDescriptor.path("/java/input").withDescription("Set the input").withRequestType(Input.class).withResponseType(APIResponse.class), new TypedRoute<Input>(){

            @Override
            public Object onRequest(Input input, Request request, Response response) {
                return AudioEndpoint.this.service.setInput(input, response);
            }
        }).get(MethodDescriptor.path("/java/inputs").withDescription("Get the input choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputs());
            }
        }).get(MethodDescriptor.path("/java/input-channel").withDescription("Get the input channel").withResponseType(InputChannel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getInputChannel());
            }
        }).post(MethodDescriptor.path("/java/input-channel").withDescription("Set the input channel").withRequestType(InputChannel.class).withResponseType(APIResponse.class), new TypedRoute<InputChannel>(){

            @Override
            public Object onRequest(InputChannel inputChannel, Request request, Response response) {
                return AudioEndpoint.this.service.setInputChannel(inputChannel, response);
            }
        }).get(MethodDescriptor.path("/java/num-input-channels").withDescription("Get the number of input channels ").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioService.getNumInputChannels());
            }
        }).get(MethodDescriptor.path("/java/ref-input-channel").withDescription("Get the ref input channel").withResponseType(InputChannel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getRefInputChannel());
            }
        }).post(MethodDescriptor.path("/java/ref-input-channel").withDescription("Set the ref input channel").withRequestType(InputChannel.class).withResponseType(APIResponse.class), new TypedRoute<InputChannel>(){

            @Override
            public Object onRequest(InputChannel inputChannel, Request request, Response response) {
                return AudioEndpoint.this.service.setRefInputChannel(inputChannel, response);
            }
        }).get(MethodDescriptor.path("/java/last-input-channel").withDescription("Get the last input channel of the multi-input set").withResponseType(InputChannel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getLastInputChannel());
            }
        }).post(MethodDescriptor.path("/java/last-input-channel").withDescription("Set the last input channel of the multi-input set").withRequestType(InputChannel.class).withResponseType(APIResponse.class), new TypedRoute<InputChannel>(){

            @Override
            public Object onRequest(InputChannel inputChannel, Request request, Response response) {
                return AudioEndpoint.this.service.setLastInputChannel(inputChannel, response);
            }
        }).get(MethodDescriptor.path("/java/output").withDescription("Get the output").withResponseType(Output.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutput());
            }
        }).post(MethodDescriptor.path("/java/output").withDescription("Set the output").withRequestType(Output.class).withResponseType(APIResponse.class), new TypedRoute<Output>(){

            @Override
            public Object onRequest(Output output, Request request, Response response) {
                return AudioEndpoint.this.service.setOutput(output, response);
            }
        }).get(MethodDescriptor.path("/java/outputs").withDescription("Get the output choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputs());
            }
        }).get(MethodDescriptor.path("/java/output-channel").withDescription("Get the output channel").withResponseType(OutputChannel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputChannel());
            }
        }).post(MethodDescriptor.path("/java/output-channel").withDescription("Set the output channel").withRequestType(OutputChannel.class).withResponseType(APIResponse.class), new TypedRoute<OutputChannel>(){

            @Override
            public Object onRequest(OutputChannel outputChannel, Request request, Response response) {
                return AudioEndpoint.this.service.setOutputChannel(outputChannel, response);
            }
        }).get(MethodDescriptor.path("/java/output-channels").withDescription("Get the output channel choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getOutputChannels());
            }
        }).get(MethodDescriptor.path("/java/ref-output-channel").withDescription("Get the ref output channel").withResponseType(OutputChannel.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getRefOutputChannel());
            }
        }).post(MethodDescriptor.path("/java/ref-output-channel").withDescription("Set the ref output channel").withRequestType(OutputChannel.class).withResponseType(APIResponse.class), new TypedRoute<OutputChannel>(){

            @Override
            public Object onRequest(OutputChannel outputChannel, Request request, Response response) {
                return AudioEndpoint.this.service.setRefOutputChannel(outputChannel, response);
            }
        }).get(MethodDescriptor.path("/java/ref-output-channels").withDescription("Get the ref output channel choices ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AudioEndpoint.this.service.getRefOutputChannels());
            }
        });
    }
}

