/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.ApplicationService;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.ErrorMessage;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.WarningMessage;
import spark.Request;
import spark.Response;

public class ApplicationEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/application";
    private final ApplicationService service = new ApplicationService();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("REW application-level settings and coommands "), null).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationService.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send an application command  ").withRequestType(Command.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<Command>(){

            @Override
            public Object onRequest(Command command, Request request, Response response) {
                return ApplicationEndpoint.this.service.runCommand(command, response);
            }
        }).get(MethodDescriptor.path("/last-error").withDescription("Get the last error that occurred").withResponseType(ErrorMessage.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getLastError(request, response));
            }
        }).get(MethodDescriptor.path("/errors").withDescription("Get any errors that have occurred").withResponseAsCollection(ErrorMessage.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getErrors(request, response));
            }
        }).post(MethodDescriptor.path("/errors/subscribe").withDescription("Subscribe to errors").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ApplicationEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.ERROR, response);
            }
        }).post(MethodDescriptor.path("/errors/unsubscribe").withDescription("Unsubscribe from errors").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ApplicationEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.ERROR, response);
            }
        }).get(MethodDescriptor.path("/errors/subscribers").withDescription("Get the error subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getSubscribers(SubscriptionType.ERROR));
            }
        }).get(MethodDescriptor.path("/last-warning").withDescription("Get the last warning that occurred").withResponseType(WarningMessage.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getLastWarning(request, response));
            }
        }).get(MethodDescriptor.path("/warnings").withDescription("Get any warnings that have been issued").withResponseAsCollection(WarningMessage.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getWarnings(request, response));
            }
        }).post(MethodDescriptor.path("/warnings/subscribe").withDescription("Subscribe to warnings").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ApplicationEndpoint.this.service.addSubscriber(subscriber, SubscriptionType.WARNING, response);
            }
        }).post(MethodDescriptor.path("/warnings/unsubscribe").withDescription("Unsubscribe from warnings").withRequestType(Subscriber.class).withResponseType(APIResponse.class), new TypedRoute<Subscriber>(){

            @Override
            public Object onRequest(Subscriber subscriber, Request request, Response response) {
                return ApplicationEndpoint.this.service.removeSubscriber(subscriber, SubscriptionType.WARNING, response);
            }
        }).get(MethodDescriptor.path("/warnings/subscribers").withDescription("Get the warning subscribers ").withResponseAsCollection(Subscriber.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, ApplicationEndpoint.this.service.getSubscribers(SubscriptionType.WARNING));
            }
        });
    }
}

