/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api.endpoint;

import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.descriptor.EndpointDescriptor;
import io.github.manusant.ss.descriptor.MethodDescriptor;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.rest.Endpoint;
import io.github.manusant.ss.route.Route;
import io.github.manusant.ss.route.TypedRoute;
import roomeqwizard.$B;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.AlignmentToolService;
import roomeqwizard.api.MeasurementsService;
import roomeqwizard.api.model.AlignmentCommand;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.ImpulseResponse;
import spark.Request;
import spark.Response;

public class AlignmentToolEndpoint
implements Endpoint {
    private static final String NAME_SPACE = "/alignment-tool";
    private final AlignmentToolService service = AlignmentToolService.getInstance();

    @Override
    public void bind(SparkSwagger sparkSwagger) {
        sparkSwagger.endpoint(EndpointDescriptor.Builder.newBuilder().withPath(NAME_SPACE).withExternalDoc(ExternalDocs.newBuilder().withDescription("Find out more").withUrl(API.helpUrl(NAME_SPACE)).build()).withDescription("API to use the alignment tool "), null).get(MethodDescriptor.path("/commands").withDescription("Get the list of commands ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getCommands());
            }
        }).post(MethodDescriptor.path("/command").withDescription("Send a command ").withRequestType(AlignmentCommand.class).withResponseStatus(202).withResponseType(APIResponse.class), new TypedRoute<AlignmentCommand>(){

            @Override
            public Object onRequest(AlignmentCommand alignmentCommand, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.runCommand(alignmentCommand, response);
            }
        }).get(MethodDescriptor.path("/modes").withDescription("Get the list of alignment modes ").withResponseAsCollection(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getModes());
            }
        }).get(MethodDescriptor.path("/mode").withDescription("Get the alignment mode ").withResponseType(String.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                response.status(200);
                return AlignmentToolEndpoint.this.service.getAlignmentMode();
            }
        }).post(MethodDescriptor.path("/mode").withDescription("Get the alignment mode ").withRequestType(String.class).withResponseType(APIResponse.class), new TypedRoute<String>(){

            @Override
            public Object onRequest(String string, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setAlignmentMode(string, response);
            }
        }).get(MethodDescriptor.path("/frequency").withDescription("Get the alignment frequency ").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getAlignmentFrequency());
            }
        }).get(MethodDescriptor.path("/index-a").withDescription("Get the index of measurement A ").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getIndexA());
            }
        }).post(MethodDescriptor.path("/index-a").withDescription("Set the measurement A index ").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setIndexA(n2, response);
            }
        }).get(MethodDescriptor.path("/gain-a").withDescription("Get the gain in dB for measurement A ").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getGainAdB());
            }
        }).post(MethodDescriptor.path("/gain-a").withDescription("Set the gain in dB for measurement A ").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setGainAdB(d2, response);
            }
        }).get(MethodDescriptor.path("/invert-a").withDescription("Get whether measurement A is inverted ").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getInvertA());
            }
        }).post(MethodDescriptor.path("/invert-a").withDescription("Set whether measurement A is inverted ").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setInvertA(bl, response);
            }
        }).get(MethodDescriptor.path("/index-b").withDescription("Get the index of measurement B ").withResponseType(Integer.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getIndexB());
            }
        }).post(MethodDescriptor.path("/index-b").withDescription("Set the measurement B index ").withRequestType(Integer.class).withResponseType(APIResponse.class), new TypedRoute<Integer>(){

            @Override
            public Object onRequest(Integer n2, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setIndexB(n2, response);
            }
        }).get(MethodDescriptor.path("/gain-b").withDescription("Get the gain in dB for measurement B ").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getGainBdB());
            }
        }).post(MethodDescriptor.path("/gain-b").withDescription("Set the gain in dB for measurement B ").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setGainBdB(d2, response);
            }
        }).get(MethodDescriptor.path("/delay-b").withDescription("Get the delay in ms for measurement B ").withResponseType(Double.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getDelayBms());
            }
        }).post(MethodDescriptor.path("/delay-b").withDescription("Set the delay in ms for measurement B ").withRequestType(Double.class).withResponseType(APIResponse.class), new TypedRoute<Double>(){

            @Override
            public Object onRequest(Double d2, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setDelayBms(d2, response);
            }
        }).get(MethodDescriptor.path("/invert-b").withDescription("Get whether measurement B is inverted ").withResponseType(Boolean.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getInvertB());
            }
        }).post(MethodDescriptor.path("/invert-b").withDescription("Set whether measurement B is inverted ").withRequestType(Boolean.class).withResponseType(APIResponse.class), new TypedRoute<Boolean>(){

            @Override
            public Object onRequest(Boolean bl, Request request, Response response) {
                return AlignmentToolEndpoint.this.service.setInvertB(bl, response);
            }
        }).get(MethodDescriptor.path("/aligned-frequency-response").withDescription("Gets the predicted frequency response for the aligned sum ").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the magnitude data unit  e.g. ?unit=dBFS, default is " + $B.Y.C()).and().withQueryParam().withName(MeasurementsService.getSMOOTHING_KEY()).withDescription("Specify the smoothing  e.g. ?smoothing=\"1/12\", default is the measurement's current smoothing").and().withQueryParam().withName(MeasurementsService.getPPO_KEY()).withDescription("Specify the points per octave to get log-spaced data  e.g. ?ppo=48, default is the measurement's current spacing").and().withResponseType(FrequencyResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getAlignedFrequencyResponse(request, response));
            }
        }).get(MethodDescriptor.path("/filtered-impulse-response-a").withDescription("Get the filtered impulse response for measurement A").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the impulse data unit  e.g. ?unit=dBFS, default is " + MeasurementsService.getDefaultImpulseResponseAxis().C()).and().withResponseType(ImpulseResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getFilteredImpulseResponseA(request, response));
            }
        }).get(MethodDescriptor.path("/filtered-impulse-response-b").withDescription("Get the filtered impulse response for measurement B").withQueryParam().withName(MeasurementsService.getAXIS_UNIT_KEY()).withDescription("Specify the impulse data unit  e.g. ?unit=dBFS, default is " + MeasurementsService.getDefaultImpulseResponseAxis().C()).and().withResponseType(ImpulseResponse.class), new Route(){

            @Override
            public Object onRequest(Request request, Response response) {
                return APIResponse.ok(response, AlignmentToolEndpoint.this.service.getFilteredImpulseResponseB(request, response));
            }
        });
    }
}

