/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import roomeqwizard.HL;
import roomeqwizard.StepTest;
import roomeqwizard.TwoToneSignal;
import roomeqwizard.VI;
import roomeqwizard.Window;
import roomeqwizard.ZK;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.RTAService;
import roomeqwizard.api.model.CommandWithMap;
import roomeqwizard.api.model.SteppedCommand;
import roomeqwizard.api.model.SteppedFFTConfiguration;
import roomeqwizard.api.model.SteppedFreqSpan;
import roomeqwizard.api.model.SteppedLevelSpan;
import roomeqwizard.api.model.SteppedOptions;
import roomeqwizard.api.model.SteppedProgress;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.hG;
import roomeqwizard.lG;
import roomeqwizard.sE;
import spark.Response;

public class SteppedService
extends Publisher {
    private static final String FREQ_PARAM = "frequencyHz";
    private static final String LEVEL_PARAM = "leveldBFS";
    private static final String STIMULUS_PARAM = "stimulus";
    private static final String SETTLING_PARAM = "settlingTimems";
    private static List<String> commands;
    private static List<String> types;
    private static List<String> imdStimuli;
    private static List<Integer> ppoValues;
    private static List<Integer> numAverages;
    private static SteppedService instance;
    private HL rtaFrame;
    private VI dialog;

    private SteppedService() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SteppedService.this.rtaFrame = HL.F();
                SteppedService.this.dialog = VI.C(SteppedService.this.rtaFrame.C());
            }
        });
        instance = this;
    }

    public static SteppedService getInstance() {
        if (instance == null) {
            instance = new SteppedService();
        }
        return instance;
    }

    public static List<String> getTypes() {
        if (types == null) {
            types = new ArrayList<String>();
            for (StepTest stepTest : StepTest.values()) {
                types.add(stepTest.apiName());
            }
        }
        return types;
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (SteppedCommand steppedCommand : SteppedCommand.values()) {
                commands.add(steppedCommand.commandName());
            }
        }
        return commands;
    }

    public List<String> getIMDStimuli() {
        if (imdStimuli == null) {
            imdStimuli = new ArrayList<String>();
            for (TwoToneSignal twoToneSignal : TwoToneSignal.values()) {
                imdStimuli.add(twoToneSignal.apiName());
            }
        }
        return imdStimuli;
    }

    public static List<Integer> getPPOValues() {
        if (ppoValues == null) {
            ppoValues = new ArrayList<Integer>();
            for (int n2 : VI.\u00d0()) {
                ppoValues.add(n2);
            }
        }
        return ppoValues;
    }

    public static List<Integer> getNumAverageChoices() {
        if (numAverages == null) {
            numAverages = new ArrayList<Integer>();
            numAverages.addAll(Arrays.asList(sE.\u0145()));
        }
        return numAverages;
    }

    public String getType() {
        return lG.\u0432().apiName();
    }

    public APIResponse setType(String string, Response response) {
        if (string == null || string.isEmpty()) {
            return APIResponse.badRequest(response, "No stepped measurement type in the request");
        }
        final StepTest stepTest = StepTest.getFromApiName(string);
        if (stepTest == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised stepped measurement type").validValues(SteppedService.getTypes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SteppedService.this.dialog.C(stepTest);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        return APIResponse.ok(response, string + " selected");
    }

    public APIResponse runCommand(CommandWithMap commandWithMap, Response response) {
        if (commandWithMap.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = commandWithMap.getCommand();
        SteppedCommand steppedCommand = SteppedCommand.getFromCommandName(string);
        if (steppedCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        boolean bl = true;
        switch (steppedCommand) {
            case START: {
                ArrayList<String> arrayList;
                if (VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is already in progress");
                }
                StepTest stepTest = this.dialog.c();
                Map<String, String> map = commandWithMap.getParameters();
                ArrayList<String> arrayList2 = API.checkForMissingParameters(map, arrayList = this.getRequiredParameters(stepTest));
                if (!arrayList2.isEmpty()) {
                    return API.handleMissingParameters(arrayList2, response);
                }
                String string2 = map.get(SETTLING_PARAM);
                try {
                    final int n2 = Integer.parseInt(string2);
                    if (SteppedService.invalidSettling(n2)) {
                        return APIResponse.badRequest(response, "settlingTimems of " + n2 + " is outside the accepted range of " + VI.V() + " to " + VI.z() + " ms");
                    }
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SteppedService.this.dialog.D(n2);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException exception) {}
                }
                catch (NumberFormatException numberFormatException) {
                    return APIResponse.badRequest(response, string2 + " is not an integer ");
                }
                switch (stepTest) {
                    case THD_FREQ: {
                        String string3 = map.get(LEVEL_PARAM);
                        try {
                            final double d2 = Double.parseDouble(string3);
                            if (SteppedService.invalidLevel(d2)) {
                                return APIResponse.badRequest(response, "leveldBFS of " + d2 + " is outside the accepted range of " + VI.h() + " to " + VI.\u00ca() + " dBFS");
                            }
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        SteppedService.this.dialog.D(d2);
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {}
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return APIResponse.badRequest(response, string3 + " is not a number ");
                        }
                    }
                    case THD_LEVEL: {
                        String string4 = map.get(FREQ_PARAM);
                        try {
                            final double d3 = Double.parseDouble(string4);
                            if (SteppedService.invalidFreq(d3)) {
                                return APIResponse.badRequest(response, "frequencyHz of " + d3 + " is outside the accepted range of " + VI.\u00a5() + " to " + VI.k() + " Hz");
                            }
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        SteppedService.this.dialog.A(d3);
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {}
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return APIResponse.badRequest(response, string4 + " is not a number ");
                        }
                    }
                    case IMD_LEVEL: {
                        String string5 = map.get(STIMULUS_PARAM);
                        final TwoToneSignal twoToneSignal = TwoToneSignal.getFromApiName(string5);
                        if (twoToneSignal != null) {
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        SteppedService.this.dialog.A(twoToneSignal);
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {}
                            break;
                        }
                        ValidValues validValues = ValidValues.builder().message(string5 + " is not a valid IMD stimulus").validValues(this.getIMDStimuli()).build();
                        return APIResponse.badRequest(response, validValues);
                    }
                    case MT_LEVEL: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled enum type";
                        break;
                    }
                }
                hG hG2 = this.dialog.E(true);
                if (!hG2.E()) {
                    return APIResponse.badRequest(response, "Measurement cannot start due to " + hG2.C() + ". " + hG2.A());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.G(true);
                    }
                });
                return APIResponse.ok(response, "Starting stepped measurement");
            }
            case STOP: {
                if (!VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is not in progress");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.\u00a2();
                    }
                });
                return APIResponse.ok(response, "Stopping stepped measurement");
            }
            case PAUSE: {
                if (!VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is not in progress");
                }
                if (VI.T()) {
                    return APIResponse.badRequest(response, "Measurement is already paused");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.H(true);
                    }
                });
                return APIResponse.ok(response, "Pausing stepped measurement");
            }
            case RESUME: {
                if (!VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is not in progress");
                }
                if (!VI.T()) {
                    return APIResponse.badRequest(response, "No paused measurement to resume");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.H(false);
                    }
                });
                return APIResponse.ok(response, "Resuming stepped measurement");
            }
            case BACK: {
                if (!VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is not in progress");
                }
                if (!this.dialog.\u00ce()) {
                    return APIResponse.badRequest(response, "Cannot go back a step");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.\u00c4();
                    }
                });
                return APIResponse.ok(response, "Going back one step");
            }
            case CANCEL: {
                if (!VI.\u00c1()) {
                    return APIResponse.badRequest(response, "A stepped measurement is not in progress");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.\u00c7();
                    }
                });
                return APIResponse.ok(response, "Cancelling stepped measurement");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    private ArrayList<String> getRequiredParameters(StepTest stepTest) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SETTLING_PARAM);
        switch (stepTest) {
            case THD_FREQ: {
                arrayList.add(LEVEL_PARAM);
                break;
            }
            case THD_LEVEL: {
                arrayList.add(FREQ_PARAM);
                break;
            }
            case IMD_LEVEL: {
                arrayList.add(STIMULUS_PARAM);
                break;
            }
            case MT_LEVEL: {
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
        return arrayList;
    }

    public SteppedFreqSpan getSteppedFreqSpan() {
        return SteppedFreqSpan.builder().startFreq(lG.\u0162()).endFreq(lG.\u00ed()).ppo(lG.\u0255()).build();
    }

    private static boolean invalidFreq(double d2) {
        return d2 < VI.\u00a5() || d2 > VI.k();
    }

    public APIResponse setSteppedFreqSpan(final SteppedFreqSpan steppedFreqSpan, Response response) {
        double d2;
        boolean bl = false;
        if (steppedFreqSpan.getStartFreq() != null) {
            d2 = steppedFreqSpan.getStartFreq();
            if (SteppedService.invalidFreq(d2)) {
                return APIResponse.badRequest(response, d2 + " start frequency is outside the accepted range of " + VI.\u00a5() + " to " + VI.k() + " Hz");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.B(d2);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (steppedFreqSpan.getEndFreq() != null) {
            d2 = steppedFreqSpan.getEndFreq();
            if (SteppedService.invalidFreq(d2)) {
                return APIResponse.badRequest(response, d2 + " end frequency is outside the accepted range of " + VI.\u00a5() + " to " + VI.k() + " Hz");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.C(d2);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (steppedFreqSpan.getPpo() != null) {
            if (SteppedService.getPPOValues().contains(steppedFreqSpan.getPpo())) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SteppedService.this.dialog.C(steppedFreqSpan.getPpo());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(steppedFreqSpan.getPpo() + " is not a valid PPO value").validValues(SteppedService.getPPOValues()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Frequency span processed");
        }
        return APIResponse.badRequest(response, "No frequency span entries in the request");
    }

    public SteppedLevelSpan getSteppedLevelSpan() {
        return SteppedLevelSpan.builder().startLevel(lG.\u03b9()).endLevel(lG.\u00ff()).step(lG.\u00a2()).build();
    }

    private static boolean invalidLevel(double d2) {
        return d2 < VI.h() || d2 > VI.\u00ca();
    }

    private static boolean invalidStep(double d2) {
        return d2 < VI.f() || d2 > VI.\u00c0();
    }

    private static boolean invalidSettling(int n2) {
        return (double)n2 < VI.V() || (double)n2 > VI.z();
    }

    public APIResponse setSteppedLevelSpan(final SteppedLevelSpan steppedLevelSpan, Response response) {
        double d2;
        boolean bl = false;
        if (steppedLevelSpan.getStartLevel() != null) {
            d2 = steppedLevelSpan.getStartLevel();
            if (SteppedService.invalidLevel(d2)) {
                return APIResponse.badRequest(response, d2 + " start level is outside the accepted range of " + VI.h() + " to " + VI.\u00ca() + " dBFS");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.E(d2);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (steppedLevelSpan.getEndLevel() != null) {
            d2 = steppedLevelSpan.getEndLevel();
            if (SteppedService.invalidLevel(d2)) {
                return APIResponse.badRequest(response, d2 + " end level is outside the accepted range of " + VI.h() + " to " + VI.\u00ca() + " dBFS");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.F(d2);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (steppedLevelSpan.getStep() != null) {
            d2 = steppedLevelSpan.getStep();
            if (SteppedService.invalidStep(d2)) {
                return APIResponse.badRequest(response, d2 + " step is outside the accepted range of " + VI.f() + " to " + VI.\u00c0() + " dB");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SteppedService.this.dialog.H(steppedLevelSpan.getStep());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Level span processed");
        }
        return APIResponse.badRequest(response, "No level span entries in the request");
    }

    public SteppedFFTConfiguration getFFTConfiguration() {
        return SteppedFFTConfiguration.builder().fftLength(ZK.B(lG.S()).A()).window(lG.\u027a().toString()).averages(lG.\u01a8()).maximumOverlap(lG.\u0274()).build();
    }

    public APIResponse setFFTConfiguration(SteppedFFTConfiguration steppedFFTConfiguration, Response response) {
        Object object;
        Object object2;
        boolean bl = false;
        if (steppedFFTConfiguration.getFftLength() != null) {
            object2 = ZK.A(steppedFFTConfiguration.getFftLength());
            if (object2 == null) {
                ValidValues validValues = ValidValues.builder().message(steppedFFTConfiguration.getFftLength() + " is not a valid FFT length").validValues(RTAService.getRTALengths()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable((ZK)((Object)object2)){
                final /* synthetic */ ZK val$len;
                {
                    this.val$len = zK2;
                }

                @Override
                public void run() {
                    SteppedService.this.dialog.A(this.val$len);
                }
            });
            bl = true;
        }
        if (steppedFFTConfiguration.getAverages() != null) {
            final int n2 = steppedFFTConfiguration.getAverages();
            if (!SteppedService.getNumAverageChoices().contains(n2)) {
                ValidValues validValues = ValidValues.builder().message(steppedFFTConfiguration.getAverages() + " is not a valid number of averages").validValues(SteppedService.getNumAverageChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SteppedService.this.dialog.B(n2);
                }
            });
            bl = true;
        }
        if (steppedFFTConfiguration.getMaximumOverlap() != null) {
            object2 = null;
            for (String object3 : RTAService.getOverlapChoices()) {
                if (!object3.equalsIgnoreCase(steppedFFTConfiguration.getMaximumOverlap())) continue;
                object2 = object3;
                break;
            }
            if (object2 == null) {
                object = ValidValues.builder().message(steppedFFTConfiguration.getMaximumOverlap() + " is not a recognised maximum overlap option").validValues(RTAService.getOverlapChoices()).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            object = object2;
            EventQueue.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$theOverlap;
                {
                    this.val$theOverlap = string;
                }

                @Override
                public void run() {
                    SteppedService.this.dialog.D(this.val$theOverlap);
                }
            });
            bl = true;
        }
        if (steppedFFTConfiguration.getWindow() != null) {
            object2 = Window.Types.getTypeFromDescription(steppedFFTConfiguration.getWindow());
            object = Arrays.asList(sE.\u0140());
            if (object2 == null) {
                ValidValues validValues = ValidValues.builder().message(steppedFFTConfiguration.getWindow() + " is not a recognised window type").validValues(RTAService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (!object.contains(object2)) {
                ValidValues validValues = ValidValues.builder().message(steppedFFTConfiguration.getWindow() + " is not a window type the RTA accepts").validValues(RTAService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable((Window.Types)((Object)object2)){
                final /* synthetic */ Window.Types val$windowType;
                {
                    this.val$windowType = types;
                }

                @Override
                public void run() {
                    SteppedService.this.dialog.A(this.val$windowType);
                }
            });
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No configuration entries in the request");
        }
        return APIResponse.ok(response, "Configuration processed");
    }

    public SteppedOptions getOptions() {
        return SteppedOptions.builder().captureSpectrum(lG.\u03da()).reduceStepIfDistortionLimitHit(lG.\u00f0()).stopAtDistortionLimit(lG.\u0406()).stopForHeavyClipping(lG.\u028e()).distortionLimitPercent(lG.\u0177()).silenceIntervalSeconds(lG.\u0164()).build();
    }

    public APIResponse setOptions(SteppedOptions steppedOptions, Response response) {
        boolean bl = false;
        if (steppedOptions.getCaptureSpectrum() != null) {
            lG.\u00c5(steppedOptions.getCaptureSpectrum());
            bl = true;
        }
        if (steppedOptions.getReduceStepIfDistortionLimitHit() != null) {
            lG.\u00c8(steppedOptions.getReduceStepIfDistortionLimitHit());
            bl = true;
        }
        if (steppedOptions.getStopAtDistortionLimit() != null) {
            lG.p(steppedOptions.getStopAtDistortionLimit());
            bl = true;
        }
        if (steppedOptions.getStopForHeavyClipping() != null) {
            lG.\u00c9(steppedOptions.getStopForHeavyClipping());
            bl = true;
        }
        if (steppedOptions.getDistortionLimitPercent() != null) {
            final double d2 = steppedOptions.getDistortionLimitPercent();
            if (d2 < VI.o() || d2 > VI.X()) {
                return APIResponse.badRequest(response, d2 + " is outside the accepted range of " + VI.o() + " to " + VI.X() + " %");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SteppedService.this.dialog.G(d2);
                }
            });
            bl = true;
        }
        if (steppedOptions.getSilenceIntervalSeconds() != null) {
            final int n2 = steppedOptions.getSilenceIntervalSeconds();
            if ((double)n2 < VI.\u00ba() || (double)n2 > VI.g()) {
                return APIResponse.badRequest(response, n2 + " is outside the accepted range of " + VI.\u00ba() + " to " + VI.g() + " seconds");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SteppedService.this.dialog.F(n2);
                }
            });
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No configuration entries in the request");
        }
        return APIResponse.ok(response, "Configuration processed");
    }

    public SteppedProgress getProgress() {
        return this.dialog.b();
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        this.dialog.A(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        this.dialog.B(subscriptionType, this);
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }
}

