/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import roomeqwizard.$D;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.SPLMeterCommand;
import roomeqwizard.api.model.SPLMeterConfiguration;
import roomeqwizard.api.model.SPLValues;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.fA;
import roomeqwizard.lG;
import roomeqwizard.mE;
import spark.Response;

public class SPLMeterService
extends Publisher {
    private static List<String> commands;
    private static List<String> weightings;
    private static List<String> filters;
    private static List<String> modes;
    private static SPLMeterService instance;

    private SPLMeterService() {
        instance = this;
    }

    public static SPLMeterService getInstance() {
        if (instance == null) {
            instance = new SPLMeterService();
        }
        return instance;
    }

    public static List<String> getWeightings() {
        if (weightings == null) {
            weightings = new ArrayList<String>();
            for (mE mE2 : mE.values()) {
                weightings.add(mE2.B());
            }
        }
        return weightings;
    }

    public static List<String> getFilters() {
        if (filters == null) {
            filters = new ArrayList<String>();
            for (fA fA2 : fA.values()) {
                filters.add(fA2.C());
            }
        }
        return filters;
    }

    public static List<String> getModes() {
        if (modes == null) {
            modes = new ArrayList<String>();
            for ($D._A _A2 : $D._A.values()) {
                modes.add(_A2.B());
            }
        }
        return modes;
    }

    public static SubscriptionType getSubscriptionType(int n2) {
        switch (n2) {
            case 0: {
                return SubscriptionType.SPL_METER_1;
            }
            case 1: {
                return SubscriptionType.SPL_METER_2;
            }
            case 2: {
                return SubscriptionType.SPL_METER_3;
            }
            case 3: {
                return SubscriptionType.SPL_METER_4;
            }
        }
        assert (false) : "Unhandled index";
        return SubscriptionType.SPL_METER_1;
    }

    public static int getIndex(SubscriptionType subscriptionType) {
        switch (subscriptionType) {
            case SPL_METER_1: {
                return 0;
            }
            case SPL_METER_2: {
                return 1;
            }
            case SPL_METER_3: {
                return 2;
            }
            case SPL_METER_4: {
                return 3;
            }
        }
        assert (false) : "Unhandled enum type";
        return 0;
    }

    public SPLValues getLevels(int n2) {
        $D $D = $D.S($D.\u00d6(n2));
        return $D.\u03ac();
    }

    public static int numMeters() {
        return $D.\u03b2();
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        $D $D = $D.S($D.\u00d6(SPLMeterService.getIndex(subscriptionType)));
        $D.I(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        $D $D = $D.S($D.\u00d6(SPLMeterService.getIndex(subscriptionType)));
        $D.J(subscriptionType, this);
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (SPLMeterCommand sPLMeterCommand : SPLMeterCommand.values()) {
                commands.add(sPLMeterCommand.commandName());
            }
        }
        return commands;
    }

    public APIResponse runCommand(int n2, Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        SPLMeterCommand sPLMeterCommand = SPLMeterCommand.getFromCommandName(string);
        if (sPLMeterCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        final $D $D = $D.S($D.\u00d6(n2));
        switch (sPLMeterCommand) {
            case START: {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            $D.\u03b5();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                return APIResponse.ok(response, "Starting SPL meter " + (n2 + 1));
            }
            case STOP: {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            $D.\u03b7();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                return APIResponse.ok(response, "Stopping SPL meter " + (n2 + 1));
            }
            case RESET: {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            $D.\u03b0();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                return APIResponse.ok(response, "Reset SPL meter " + (n2 + 1));
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    public SPLMeterConfiguration getSPLMeterConfiguration(int n2) {
        $D.S($D.\u00d6(n2));
        return SPLMeterConfiguration.builder().mode(lG.c(n2)).weighting(lG.\u00f8(n2)).filter(fA.B(lG.Z(n2)).C()).highPassActive(lG.\u0105(n2)).rollingLeqActive(lG.B("rollingleq", $D.\u00d6(n2))).rollingLeqMinutes(lG.A("rollingleqinterval", $D.\u00d6(n2))).build();
    }

    public APIResponse setConfiguration(int n2, final SPLMeterConfiguration sPLMeterConfiguration, Response response) {
        Enum enum_;
        boolean bl = false;
        final $D $D = $D.S($D.\u00d6(n2));
        if (sPLMeterConfiguration.getMode() != null) {
            enum_ = $D._A.A(sPLMeterConfiguration.getMode());
            if (enum_ != null) {
                try {
                    EventQueue.invokeAndWait(new Runnable(($D._A)enum_){
                        final /* synthetic */ $D._A val$mode;
                        {
                            this.val$mode = _A2;
                        }

                        @Override
                        public void run() {
                            $D.A(this.val$mode);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(sPLMeterConfiguration.getMode() + " is not a valid display mode").validValues(SPLMeterService.getModes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (sPLMeterConfiguration.getWeighting() != null) {
            enum_ = mE.A(sPLMeterConfiguration.getWeighting());
            if (enum_ != null) {
                try {
                    EventQueue.invokeAndWait(new Runnable((mE)enum_){
                        final /* synthetic */ mE val$weight;
                        {
                            this.val$weight = mE2;
                        }

                        @Override
                        public void run() {
                            $D.A(this.val$weight);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(sPLMeterConfiguration.getMode() + " is not a valid weighting").validValues(SPLMeterService.getWeightings()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (sPLMeterConfiguration.getFilter() != null) {
            enum_ = fA.A(sPLMeterConfiguration.getFilter());
            if (enum_ != null) {
                try {
                    EventQueue.invokeAndWait(new Runnable((fA)enum_){
                        final /* synthetic */ fA val$rate;
                        {
                            this.val$rate = fA2;
                        }

                        @Override
                        public void run() {
                            $D.A(this.val$rate);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(sPLMeterConfiguration.getMode() + " is not a valid filter").validValues(SPLMeterService.getFilters()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (sPLMeterConfiguration.getHighPassActive() != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        $D.\u00d0(sPLMeterConfiguration.getHighPassActive());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (sPLMeterConfiguration.getRollingLeqActive() != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        $D.\u00d1(sPLMeterConfiguration.getRollingLeqActive());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (sPLMeterConfiguration.getRollingLeqMinutes() != null) {
            final int n3 = sPLMeterConfiguration.getRollingLeqMinutes();
            int n4 = $D.\u03ab();
            if (n3 < 1 || n3 > n4) {
                return APIResponse.badRequest(response, "The rolling Leq interval must be between 1 and " + n4 + " minutes");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        $D.\u00d5(n3);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }
}

